/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Stackframe.h"

// sys
#include <cstring>


Variable::Variable(VariableType type, sc::Size size)
: _type(type), _size(size)
{
  _value = malloc(_size);
  _kind  = vkNone;
}

Variable::Variable(const Variable& src)
: _type(src._type), _size(src._size)
{
  _value = malloc(_size);
  value(src._value);
  _kind  = src._kind;
  _name  = src._name;
}

Variable::~Variable()
{
  free(_value);
}

void Variable::value( void* val )
{
  memcpy(_value,val,_size);
}

void Variable::name( char* name, sc::Size len )
{
  _name = sc::String(name,len);
}

Variable::operator int() const
{
  return *(int*)_value;
}




Stackframe::Stackframe()
{
  _error      = false;

  _addr       = 0;
  _addrSeg    = 0;

  _symbol     = false;
  _symbolDisp = 0;

  _module     = false;

  _line       = false;
  _lineNr     = 0;
  _lineDisp   = 0;
}
