/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _FILE_SELECT_DIALOG_H
#define _FILE_SELECT_DIALOG_H

// qt
#include <QtGui/QDialog>
class QLineEdit;
class QComboBox;


class FileSelectDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  FileSelectDialog( QWidget* parent = NULL );
  virtual ~FileSelectDialog();

  enum Result
  {
    rDiff2 = 1,
    rDiff3 = 2
  };

  bool eventFilter( QObject *o, QEvent *e );

public slots:
  void setOriginal();
  void setModified();
  void setLatest();

  void ok();
  void okDiff();
  void okMerge();

public:
  QString getOriginal() const;
  QString getModified() const;
  QString getLatest() const;
  QString getEncoding() const;

private:
  void setFile( QComboBox* e );

  QComboBox* _original;
  QComboBox* _modified;
  QComboBox* _latest;
  QComboBox* _encoding;
};



#endif //  _FILE_SELECT_DIALOG_H

