/*
 * Decompiled with CFR 0.152.
 */
package adql.db.region;

import adql.db.region.CoordSys;
import adql.db.region.Region;
import adql.parser.grammar.ParseException;
import adql.query.TextPosition;
import adql.query.operand.function.geometry.GeometryFunction;
import java.util.ArrayList;

public final class STCS {
    private STCS() {
    }

    public static CoordSys parseCoordSys(String stcs) throws ParseException {
        return new STCSParser().parseCoordSys(stcs);
    }

    public static String toSTCS(CoordSys coordSys) {
        if (coordSys == null) {
            return "";
        }
        return coordSys.toSTCS();
    }

    public static Region parseRegion(String stcsRegion) throws ParseException {
        if (stcsRegion == null || stcsRegion.trim().length() == 0) {
            throw new ParseException("Missing STC-S expression to parse!");
        }
        return new STCSParser().parseRegion(stcsRegion);
    }

    public static String toSTCS(Region region) {
        return STCS.toSTCS(region, false);
    }

    public static String toSTCS(Region region, boolean explicitCoordSys) {
        if (region == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        StringBuffer buf = new StringBuffer(region.type.toString());
        if (region.type != Region.RegionType.NOT) {
            String coordSysStr;
            String string = coordSysStr = explicitCoordSys ? region.coordSys.toFullSTCS() : region.coordSys.toSTCS();
            if (coordSysStr != null && coordSysStr.length() > 0) {
                buf.append(' ').append(coordSysStr);
            }
            buf.append(' ');
        }
        switch (region.type) {
            case POSITION: 
            case POLYGON: {
                STCS.appendCoordinates(buf, region.coordinates);
                break;
            }
            case CIRCLE: {
                STCS.appendCoordinates(buf, region.coordinates);
                buf.append(' ').append(region.radius);
                break;
            }
            case BOX: {
                STCS.appendCoordinates(buf, region.coordinates);
                buf.append(' ').append(region.width).append(' ').append(region.height);
                break;
            }
            case UNION: 
            case INTERSECTION: 
            case NOT: {
                buf.append('(');
                STCS.appendRegions(buf, region.regions, false);
                buf.append(')');
            }
        }
        return buf.toString();
    }

    public static String toSTCS(GeometryFunction region) throws ParseException {
        if (region == null) {
            throw new NullPointerException("Missing region to serialize into STC-S!");
        }
        return new Region(region).toSTCS();
    }

    private static void appendCoordinates(StringBuffer buf, double[][] coords) {
        for (int i = 0; i < coords.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(coords[i][0]).append(' ').append(coords[i][1]);
        }
    }

    private static void appendRegions(StringBuffer buf, Region[] regions, boolean fullCoordSys) {
        for (int i = 0; i < regions.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            if (fullCoordSys) {
                buf.append(regions[i].toFullSTCS());
                continue;
            }
            buf.append(regions[i].toSTCS());
        }
    }

    static class STCSParser {
        private static final String numericRegExp = "(\\+|-)?(\\d+(\\.\\d*)?|\\.\\d+)([Ee](\\+|-)?\\d+)?";
        private int pos;
        private String stcs;
        private String token;
        private StringBuffer buffer;

        public CoordSys parseCoordSys(String stcs) throws ParseException {
            this.init(stcs);
            CoordSys coordsys = null;
            try {
                coordsys = this.coordSys();
                this.end(CoordSys.COORD_SYS_SYNTAX);
                return coordsys;
            }
            catch (EOEException ex) {
                ex.printStackTrace();
                return new CoordSys();
            }
        }

        public Region parseRegion(String stcs) throws ParseException {
            this.init(stcs);
            Region region = this.region();
            this.end("\"POSITION <coordsys> <coordPair>\", \"CIRCLE <coordSys> <coordPair> <numeric>\", \"BOX <coordSys> <coordPair> <coordPair>\", \"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", \"UNION <coordSys> ( <region> <region> [<region> ...] )\", \"INTERSECTION [<coordSys>] ( <region> <region> [<region> ...] )\" or \"NOT ( <region> )\"");
            return region;
        }

        private void init(String newStcs) {
            this.stcs = newStcs == null ? "" : newStcs;
            this.token = null;
            this.buffer = new StringBuffer();
            this.pos = 0;
        }

        private void end(String expectedSyntax) throws ParseException {
            this.skipSpaces();
            if (this.stcs.length() > 0 && this.pos < this.stcs.length()) {
                throw new ParseException("Incorrect syntax: \"" + this.stcs.substring(this.pos) + "\" was unexpected! Expected syntax: " + expectedSyntax + ".", new TextPosition(1, this.pos, 1, this.stcs.length()));
            }
            this.buffer = null;
            this.stcs = null;
            this.token = null;
        }

        private void skipSpaces() {
            while (this.pos < this.stcs.length() && Character.isWhitespace(this.stcs.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private String nextToken() throws EOEException {
            this.skipSpaces();
            while (this.pos < this.stcs.length() && !Character.isWhitespace(this.stcs.charAt(this.pos)) && this.stcs.charAt(this.pos) != '(' && this.stcs.charAt(this.pos) != ')') {
                this.buffer.append(this.stcs.charAt(this.pos++));
            }
            if (this.buffer.length() == 0) {
                throw new EOEException();
            }
            this.token = this.buffer.toString();
            this.buffer.delete(0, this.token.length());
            return this.token;
        }

        private double numeric() throws ParseException {
            if (this.nextToken().matches(numericRegExp)) {
                return Double.parseDouble(this.token);
            }
            throw new ParseException("a numeric was expected!", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
        }

        private double[] coordPair() throws ParseException {
            this.skipSpaces();
            int startPos = this.pos;
            try {
                return new double[]{this.numeric(), this.numeric()};
            }
            catch (ParseException pe) {
                if (pe instanceof EOEException) {
                    throw pe;
                }
                throw new ParseException("a coordinates pair (2 numerics separated by one or more spaces) was expected!", new TextPosition(1, startPos, 1, this.pos));
            }
        }

        private CoordSys coordSys() throws ParseException {
            this.skipSpaces();
            String oldToken = this.token;
            int startPos = this.pos;
            CoordSys.Frame fr = null;
            CoordSys.RefPos rp = null;
            CoordSys.Flavor fl = null;
            try {
                this.nextToken();
                fr = this.frame();
                if (fr != null) {
                    startPos = this.pos;
                    oldToken = this.token;
                    this.nextToken();
                }
                if ((rp = this.refpos()) != null) {
                    startPos = this.pos;
                    oldToken = this.token;
                    this.nextToken();
                }
                if ((fl = this.flavor()) == null) {
                    this.pos = startPos;
                    this.token = oldToken;
                }
            }
            catch (EOEException eOEException) {
                // empty catch block
            }
            try {
                return new CoordSys(fr, rp, fl);
            }
            catch (IllegalArgumentException iae) {
                throw new ParseException(iae.getMessage(), new TextPosition(1, startPos, 1, this.pos));
            }
        }

        private CoordSys.Frame frame() {
            try {
                return CoordSys.Frame.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private CoordSys.RefPos refpos() {
            try {
                return CoordSys.RefPos.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private CoordSys.Flavor flavor() {
            try {
                return CoordSys.Flavor.valueOf(this.token.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        private Region region() throws ParseException {
            this.skipSpaces();
            int startPos = this.pos;
            this.token = this.nextToken().toUpperCase();
            if (this.token.equals("POSITION")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    return new Region(coordSys, coords);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"POSITION <coordSys> <coordPair>\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("CIRCLE")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    double radius = this.numeric();
                    return new Region(coordSys, coords, radius);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"CIRCLE <coordSys> <coordPair> <radius>\", where coordPair=\"<numeric> <numeric>\", radius=\"<numeric>\" and coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("BOX")) {
                try {
                    CoordSys coordSys = this.coordSys();
                    double[] coords = this.coordPair();
                    double width = this.numeric();
                    double height = this.numeric();
                    return new Region(coordSys, coords, width, height);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"BOX <coordSys> <coordPair> <width> <height>\", where coordPair=\"<numeric> <numeric>\", width and height=\"<numeric>\" and coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("POLYGON")) {
                try {
                    double[] coords;
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Double> coordinates = new ArrayList<Double>(6);
                    for (int i = 0; i < 3; ++i) {
                        coords = this.coordPair();
                        coordinates.add(coords[0]);
                        coordinates.add(coords[1]);
                    }
                    boolean moreCoord = true;
                    do {
                        int posBackup = this.pos;
                        try {
                            coords = this.coordPair();
                            coordinates.add(coords[0]);
                            coordinates.add(coords[1]);
                        }
                        catch (ParseException pe) {
                            moreCoord = false;
                            this.pos = posBackup;
                        }
                    } while (moreCoord);
                    double[][] allCoords = new double[coordinates.size() / 2][2];
                    for (int i = 0; i < coordinates.size() && i + 1 < coordinates.size(); i += 2) {
                        allCoords[i / 2] = new double[]{(Double)coordinates.get(i), (Double)coordinates.get(i + 1)};
                    }
                    return new Region(coordSys, allCoords);
                }
                catch (Exception e) {
                    throw this.buildException(e, "\"POLYGON <coordSys> <coordPair> <coordPair> <coordPair> [<coordPair> ...]\", where coordPair=\"<numeric> <numeric>\" and coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("UNION") || this.token.equals("INTERSECTION")) {
                Region.RegionType type = this.token.equals("UNION") ? Region.RegionType.UNION : Region.RegionType.INTERSECTION;
                try {
                    CoordSys coordSys = this.coordSys();
                    ArrayList<Region> regions = new ArrayList<Region>(2);
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("a opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"" + (Object)((Object)type) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                    }
                    ++this.pos;
                    regions.add(this.region());
                    regions.add(this.region());
                    this.skipSpaces();
                    while (this.stcs.charAt(this.pos) != ')') {
                        regions.add(this.region());
                        this.skipSpaces();
                    }
                    ++this.pos;
                    return new Region(type, coordSys, regions.toArray(new Region[regions.size()]));
                }
                catch (Exception e) {
                    if (e instanceof ParseException && e.getMessage().startsWith("Incorrect syntax: \"")) {
                        throw (ParseException)e;
                    }
                    throw this.buildException(e, "\"" + (Object)((Object)type) + " <coordSys> ( <region> <region> [<region> ...] )\", where coordSys=" + CoordSys.COORD_SYS_SYNTAX, startPos);
                }
            }
            if (this.token.equals("NOT")) {
                try {
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != '(') {
                        throw this.buildException(new ParseException("an opening parenthesis - ( - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", startPos);
                    }
                    ++this.pos;
                    Region region = this.region();
                    this.skipSpaces();
                    if (this.stcs.charAt(this.pos) != ')') {
                        throw this.buildException(new ParseException("a closing parenthesis - ) - was expected!", new TextPosition(1, this.pos, 1, this.pos + 1)), "\"NOT ( <region> )\"", startPos);
                    }
                    ++this.pos;
                    return new Region(region);
                }
                catch (Exception e) {
                    if (e instanceof ParseException && e.getMessage().startsWith("Incorrect syntax: ")) {
                        throw (ParseException)e;
                    }
                    throw this.buildException(e, "\"NOT ( <region> )\"", startPos);
                }
            }
            throw new ParseException("Unknown STC region type: \"" + this.token + "\"!", new TextPosition(1, startPos, 1, this.pos));
        }

        private ParseException buildException(Exception ex, String expectedSyntax, int startPos) {
            if (ex instanceof EOEException) {
                return new ParseException("Unexpected End Of Expression! Expected syntax: " + expectedSyntax + ".", new TextPosition(1, startPos, 1, this.pos));
            }
            if (ex instanceof ParseException) {
                return new ParseException("Incorrect syntax: " + ex.getMessage() + " Expected syntax: " + expectedSyntax + ".", ((ParseException)ex).getPosition() != null ? ((ParseException)ex).getPosition() : new TextPosition(1, startPos, 1, this.pos));
            }
            return new ParseException(ex.getMessage(), new TextPosition(1, startPos, 1, this.pos));
        }

        private static class EOEException
        extends ParseException {
            private static final long serialVersionUID = 1L;

            public EOEException() {
                super("Unexpected End Of Expression!");
            }
        }
    }
}

