/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_20 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4199, "epsg", 4199,
        "Egypt 1930", 1, 1,
        "International 1924", "Greenwich",
        "Egypt_1930", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt 1930\",DATUM[\"Egypt_1930\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6199\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4199\"]]");
    p = add_epsg_def_ex (filter, first, last, 4200, "epsg", 4200,
        "Pulkovo 1995", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=24.47,-130.89,-81.56");
    add_proj4text (p, 1,
        ",0,0,0.13,-0.22 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],AUTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4200\"]]");
    p = add_epsg_def_ex (filter, first, last, 4201, "epsg", 4201,
        "Adindan", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Adindan\",DATUM[\"Adindan\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 1,
        "880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 2,
        "2\"]],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4201\"]]");
    p = add_epsg_def_ex (filter, first, last, 4202, "epsg", 4202,
        "AGD66", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-117.808,-51.536,1");
    add_proj4text (p, 1,
        "37.784,0.303,0.446,0.234,-0.29 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"AGD66\",DATUM[\"Australian_Geodetic_Datum_1966\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Australian National Spheroid\",6378160,298.2");
    add_srs_wkt (p, 2,
        "5,AUTHORITY[\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"620");
    add_srs_wkt (p, 3,
        "2\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4202\"]]");
    p = add_epsg_def_ex (filter, first, last, 4203, "epsg", 4203,
        "AGD84", 1, 1,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +towgs84=-134,-48,149,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"AGD84\",DATUM[\"Australian_Geodetic_Datum_1984\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Australian National Spheroid\",6378160,298.2");
    add_srs_wkt (p, 2,
        "5,AUTHORITY[\"EPSG\",\"7003\"]],AUTHORITY[\"EPSG\",\"620");
    add_srs_wkt (p, 3,
        "3\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4203\"]]");
    p = add_epsg_def_ex (filter, first, last, 4204, "epsg", 4204,
        "Ain el Abd", 1, 1,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Ain el Abd\",DATUM[\"Ain_el_Abd_1970\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4204\"]]");
    p = add_epsg_def_ex (filter, first, last, 4205, "epsg", 4205,
        "Afgooye", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=-43,-163,45,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Afgooye\",DATUM[\"Afgooye\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 1,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"6205\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 5,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4205\"]");
    add_srs_wkt (p, 6,
        "]");
    p = add_epsg_def_ex (filter, first, last, 4206, "epsg", 4206,
        "Agadez", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Agadez", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Agadez\",DATUM[\"Agadez\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7011\"]],AUTHORITY[\"EPSG\",\"6206\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4206\"]]");
    p = add_epsg_def_ex (filter, first, last, 4207, "epsg", 4207,
        "Lisbon", 1, 1,
        "International 1924", "Greenwich",
        "Lisbon_1937", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.");
    add_proj4text (p, 1,
        "64,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lisbon\",DATUM[\"Lisbon_1937\",SPHEROID[\"Inter");
    add_srs_wkt (p, 1,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6207\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"420");
    add_srs_wkt (p, 6,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 4208, "epsg", 4208,
        "Aratu", 1, 1,
        "International 1924", "Greenwich",
        "Aratu", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-151.99,287.04,-147.4");
    add_proj4text (p, 1,
        "5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Aratu\",DATUM[\"Aratu\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 1,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4208\"]]");
    p = add_epsg_def_ex (filter, first, last, 4209, "epsg", 4209,
        "Arc 1950", 1, 1,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs");
    add_proj4text (p, 1,
        "84=-143,-90,-294,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Arc 1950\",DATUM[\"Arc_1950\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (Arc)\",6378249.145,293.4663077,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7013\"]],AUTHORITY[\"EPSG\",\"6209\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4209\"]]");
    p = add_epsg_def_ex (filter, first, last, 4210, "epsg", 4210,
        "Arc 1960", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Arc 1960\",DATUM[\"Arc_1960\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "012\"]],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4210\"]]");
    p = add_epsg_def_ex (filter, first, last, 4211, "epsg", 4211,
        "Batavia", 1, 1,
        "Bessel 1841", "Greenwich",
        "Batavia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia\",DATUM[\"Batavia\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "11\"]]");
    p = add_epsg_def_ex (filter, first, last, 4212, "epsg", 4212,
        "Barbados 1938", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=31.95,300.99,419.19");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6212\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4212\"]]");
    p = add_epsg_def_ex (filter, first, last, 4213, "epsg", 4213,
        "Beduaram", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Beduaram", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106,-87,");
    add_proj4text (p, 1,
        "188,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Beduaram\",DATUM[\"Beduaram\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7011\"]],AUTHORITY[\"EPSG\",\"6213\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4213\"]]");
    p = add_epsg_def_ex (filter, first, last, 4214, "epsg", 4214,
        "Beijing 1954", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=15.8,-154.4,-82.3,0,");
    add_proj4text (p, 1,
        "0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],AUTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4214\"]]");
    p = add_epsg_def_ex (filter, first, last, 4215, "epsg", 4215,
        "Belge 1950", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1950\",DATUM[\"Reseau_National_Belge_1950");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6215\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4215\"]]");
    p = add_epsg_def_ex (filter, first, last, 4216, "epsg", 4216,
        "Bermuda 1957", 1, 1,
        "Clarke 1866", "Greenwich",
        "Bermuda_1957", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-73,213,296,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bermuda 1957\",DATUM[\"Bermuda_1957\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6216\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4216\"]]");
    p = add_epsg_def_ex (filter, first, last, 4217, "epsg", 4217,
        "NAD83 / BLM 59N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 59N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",171],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4217\"]]");
    p = add_epsg_def_ex (filter, first, last, 4218, "epsg", 4218,
        "Bogota 1975", 1, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4218\"]]");
    p = add_epsg_def_ex (filter, first, last, 4219, "epsg", 4219,
        "Bukit Rimpah", 1, 1,
        "Bessel 1841", "Greenwich",
        "Bukit_Rimpah", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-384,664,-48,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bukit Rimpah\",DATUM[\"Bukit_Rimpah\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 2,
        "\",\"7004\"]],AUTHORITY[\"EPSG\",\"6219\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 3,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4219\"]]");
    p = add_epsg_def_ex (filter, first, last, 4220, "epsg", 4220,
        "Camacupa 1948", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Camacupa 1948\",DATUM[\"Camacupa_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6220\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4220\"]]");
    p = add_epsg_def_ex (filter, first, last, 4221, "epsg", 4221,
        "Campo Inchauspe", 1, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-148,136,90,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Campo Inchauspe\",DATUM[\"Campo_Inchauspe\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4221\"]]");
    p = add_epsg_def_ex (filter, first, last, 4222, "epsg", 4222,
        "Cape", 1, 1,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs");
    add_proj4text (p, 1,
        "84=-136,-108,-292,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cape\",DATUM[\"Cape\",SPHEROID[\"Clarke 1880 (A");
    add_srs_wkt (p, 1,
        "rc)\",6378249.145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "22\"]]");
    p = add_epsg_def_ex (filter, first, last, 4223, "epsg", 4223,
        "Carthage", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,43");
    add_proj4text (p, 1,
        "1,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Carthage\",DATUM[\"Carthage\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7011\"]],AUTHORITY[\"EPSG\",\"6223\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4223\"]]");
    p = add_epsg_def_ex (filter, first, last, 4224, "epsg", 4224,
        "Chua", 1, 1,
        "International 1924", "Greenwich",
        "Chua", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-143.87,243.37,-33.52");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Chua\",DATUM[\"Chua\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6224\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 5,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4224\"]]");
    p = add_epsg_def_ex (filter, first, last, 4225, "epsg", 4225,
        "Corrego Alegre 1970-72", 1, 1,
        "International 1924", "Greenwich",
        "Corrego_Alegre_1970-72", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-205.57,168.77,-4.12,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Corrego Alegre 1970-72\",DATUM[\"Corrego_Alegre");
    add_srs_wkt (p, 1,
        "_1970-72\",SPHEROID[\"International 1924\",6378388,297,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6225\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4225\"]]");
    p = add_epsg_def_ex (filter, first, last, 4226, "epsg", 4226,
        "Cote d'Ivoire (deprecated)", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Cote_d_Ivoire", "none", "degree minute second hemisphere",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Cote d'Ivoire (deprecated)\",DATUM[\"Cote_d_Ivo");
    add_srs_wkt (p, 1,
        "ire\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "1293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6226\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree minute second hemisphere\",0.0174");
    add_srs_wkt (p, 5,
        "532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AXIS[\"Latitu");
    add_srs_wkt (p, 6,
        "de\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4226\"]]");
    p = add_epsg_def_ex (filter, first, last, 4227, "epsg", 4227,
        "Deir ez Zor", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Deir_ez_Zor", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-190.421,");
    add_proj4text (p, 1,
        "8.532,238.69,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Deir ez Zor\",DATUM[\"Deir_ez_Zor\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6227\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4227\"]]");
    p = add_epsg_def_ex (filter, first, last, 4228, "epsg", 4228,
        "Douala 1948", 1, 1,
        "International 1924", "Greenwich",
        "Douala_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Douala 1948\",DATUM[\"Douala_1948\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6192\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4192\"]]");
    p = add_epsg_def_ex (filter, first, last, 4229, "epsg", 4229,
        "Egypt 1907", 1, 1,
        "Helmert 1906", "Greenwich",
        "Egypt_1907", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +towgs84=-130,110,-13,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Egypt 1907\",DATUM[\"Egypt_1907\",SPHEROID[\"He");
    add_srs_wkt (p, 1,
        "lmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6229\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4229");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4230, "epsg", 4230,
        "ED50", 1, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED50\",DATUM[\"European_Datum_1950\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4230\"]]");
    p = add_epsg_def_ex (filter, first, last, 4231, "epsg", 4231,
        "ED87", 1, 1,
        "International 1924", "Greenwich",
        "European_Datum_1987", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-83.11,-97.38,-117.22");
    add_proj4text (p, 1,
        ",0.005693,-0.044698,0.044285,0.1218 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ED87\",DATUM[\"European_Datum_1987\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6231\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4231\"]]");
    p = add_epsg_def_ex (filter, first, last, 4232, "epsg", 4232,
        "Fahud", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Fahud", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-333.102,-11.02,230");
    add_proj4text (p, 1,
        ".69,0,0,0.554,0.219 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Fahud\",DATUM[\"Fahud\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 1,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6232\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"423");
    add_srs_wkt (p, 6,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 4233, "epsg", 4233,
        "Gandajika 1970 (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Gandajika_1970", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gandajika 1970 (deprecated)\",DATUM[\"Gandajika");
    add_srs_wkt (p, 1,
        "_1970\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6233\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4233\"]]");
    p = add_epsg_def_ex (filter, first, last, 4234, "epsg", 4234,
        "Garoua", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Garoua", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Garoua\",DATUM[\"Garoua\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6197\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 6,
        "97\"]]");
    p = add_epsg_def_ex (filter, first, last, 4235, "epsg", 4235,
        "CSG67", 1, 1,
        "International 1924", "Greenwich",
        "Centre_Spatial_Guyanais_1967", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"CSG67\",DATUM[\"Centre_Spatial_Guyanais_1967\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6623\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4623\"]]");
    p = add_epsg_def_ex (filter, first, last, 4236, "epsg", 4236,
        "Hu Tzu Shan 1950", 1, 1,
        "International 1924", "Greenwich",
        "Hu_Tzu_Shan_1950", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-637,-549,-203,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hu Tzu Shan 1950\",DATUM[\"Hu_Tzu_Shan_1950\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6236\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4236\"]]");
    p = add_epsg_def_ex (filter, first, last, 4237, "epsg", 4237,
        "HD72", 1, 1,
        "GRS 1967", "Greenwich",
        "Hungarian_Datum_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +towgs84=52.17,-71.82,-14.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"HD72\",DATUM[\"Hungarian_Datum_1972\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"GRS 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7036\"]],AUTHORITY[\"EPSG\",\"6237\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4237\"]]");
    p = add_epsg_def_ex (filter, first, last, 4238, "epsg", 4238,
        "ID74", 1, 1,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378160 +b=6356774.50408554 +towgs84=-2");
    add_proj4text (p, 1,
        "4,-15,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ID74\",DATUM[\"Indonesian_Datum_1974\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"Indonesian National Spheroid\",6378160,298.247,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7021\"]],AUTHORITY[\"EPSG\",\"6238\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4238\"]]");
    p = add_epsg_def_ex (filter, first, last, 4239, "epsg", 4239,
        "Indian 1954", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=217,823,299,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Indian 1954\",DATUM[\"Indian_1954\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6239\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4239\"]]");
    p = add_epsg_def_ex (filter, first, last, 4240, "epsg", 4240,
        "Indian 1975", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1975", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=210,814,289,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Indian 1975\",DATUM[\"Indian_1975\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 (1937 Adjustment)\",6377276.345,300.8017,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6240\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4240\"]]");
    p = add_epsg_def_ex (filter, first, last, 4241, "epsg", 4241,
        "Jamaica 1875", 1, 1,
        "Clarke 1880", "Greenwich",
        "Jamaica_1875", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.144808011 +b=6356514.966204134 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Jamaica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880\",6378249.14480801,293.466307655636,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4241\"]]");
    p = add_epsg_def_ex (filter, first, last, 4242, "epsg", 4242,
        "JAD69", 1, 1,
        "Clarke 1866", "Greenwich",
        "Jamaica_1969", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=70,207,389.5,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JAD69\",DATUM[\"Jamaica_1969\",SPHEROID[\"Clark");
    add_srs_wkt (p, 1,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7008\"]],AUTHORITY[\"EPSG\",\"6242\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4242\"]]");
    p = add_epsg_def_ex (filter, first, last, 4243, "epsg", 4243,
        "Kalianpur 1880", 1, 1,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kalianpur 1880\",DATUM[\"Kalianpur_1880\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Everest (1830 Definition)\",6377299.36559538,300.8");
    add_srs_wkt (p, 2,
        "01725543355,AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6243\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4243\"]]");
    p = add_epsg_def_ex (filter, first, last, 4244, "epsg", 4244,
        "Kandawala", 1, 1,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kandawala", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs8");
    add_proj4text (p, 1,
        "4=-97,787,86,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kandawala\",DATUM[\"Kandawala\",SPHEROID[\"Ever");
    add_srs_wkt (p, 1,
        "est 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7015\"]],AUTHORITY[\"EPSG\",\"6244\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4244\"]]");
    p = add_epsg_def_ex (filter, first, last, 4245, "epsg", 4245,
        "Kertau 1968", 1, 1,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs");
    add_proj4text (p, 1,
        "84=-11,851,5,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Everest 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7018\"]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4245\"]]");
    p = add_epsg_def_ex (filter, first, last, 4246, "epsg", 4246,
        "KOC", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kuwait_Oil_Company", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil_Company\",SPHEROID[\"C");
    add_srs_wkt (p, 1,
        "larke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6246\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4246\"]]");
    p = add_epsg_def_ex (filter, first, last, 4247, "epsg", 4247,
        "La Canoa", 1, 1,
        "International 1924", "Greenwich",
        "La_Canoa", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"La Canoa\",DATUM[\"La_Canoa\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4247");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4248, "epsg", 4248,
        "PSAD56", 1, 1,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-288,175,-376,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PSAD56\",DATUM[\"Provisional_South_American_Dat");
    add_srs_wkt (p, 1,
        "um_1956\",SPHEROID[\"International 1924\",6378388,297,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6248\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4248\"]]");
    p = add_epsg_def_ex (filter, first, last, 4249, "epsg", 4249,
        "Lake", 1, 1,
        "International 1924", "Greenwich",
        "Lake", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lake\",DATUM[\"Lake\",SPHEROID[\"International ");
    add_srs_wkt (p, 1,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"6249\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 5,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4249\"]]");
    p = add_epsg_def_ex (filter, first, last, 4250, "epsg", 4250,
        "Leigon", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Leigon", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Leigon\",DATUM[\"Leigon\",SPHEROID[\"Clarke 188");
    add_srs_wkt (p, 1,
        "0 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6250\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "50\"]]");
    p = add_epsg_def_ex (filter, first, last, 4251, "epsg", 4251,
        "Liberia 1964", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Liberia_1964", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-90,40,88,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Liberia 1964\",DATUM[\"Liberia_1964\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6251\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4251\"]]");
    p = add_epsg_def_ex (filter, first, last, 4252, "epsg", 4252,
        "Lome", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Lome", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Lome\",DATUM[\"Lome\",SPHEROID[\"Clarke 1880 (I");
    add_srs_wkt (p, 1,
        "GN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "11\"]],AUTHORITY[\"EPSG\",\"6252\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4252\"]]");
    p = add_epsg_def_ex (filter, first, last, 4253, "epsg", 4253,
        "Luzon 1911", 1, 1,
        "Clarke 1866", "Greenwich",
        "Luzon_1911", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Luzon 1911\",DATUM[\"Luzon_1911\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6253\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4253\"]]");
    p = add_epsg_def_ex (filter, first, last, 4254, "epsg", 4254,
        "Hito XVIII 1963", 1, 1,
        "International 1924", "Greenwich",
        "Hito_XVIII_1963", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=16,196,93,0,0,0,0 +no");
    add_proj4text (p, 1,
        "_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Hito XVIII 1963\",DATUM[\"Hito_XVIII_1963\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"International 1924\",6378388,297,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7022\"]],AUTHORITY[\"EPSG\",\"6254\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4254\"]]");
    p = add_epsg_def_ex (filter, first, last, 4255, "epsg", 4255,
        "Herat North", 1, 1,
        "International 1924", "Greenwich",
        "Herat_North", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-333,-222,114,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Herat North\",DATUM[\"Herat_North\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6255\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4255\"]]");
    p = add_epsg_def_ex (filter, first, last, 4256, "epsg", 4256,
        "Mahe 1971", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Mahe_1971", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=41,-220,-134,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mahe 1971\",DATUM[\"Mahe_1971\",SPHEROID[\"Clar");
    add_srs_wkt (p, 1,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7012\"]],AUTHORITY[\"EPSG\",\"6256\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4256\"]]");
    p = add_epsg_def_ex (filter, first, last, 4257, "epsg", 4257,
        "Makassar", 1, 1,
        "Bessel 1841", "Greenwich",
        "Makassar", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.7");
    add_proj4text (p, 1,
        "6,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Makassar\",DATUM[\"Makassar\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "4\"]],AUTHORITY[\"EPSG\",\"6257\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4257\"]]");
    p = add_epsg_def_ex (filter, first, last, 4258, "epsg", 4258,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ETRS89\",DATUM[\"European_Terrestrial_Reference");
    add_srs_wkt (p, 1,
        "_System_1989\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "58\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4258\"]]");
    p = add_epsg_def_ex (filter, first, last, 4259, "epsg", 4259,
        "Malongo 1987", 1, 1,
        "International 1924", "Greenwich",
        "Malongo_1987", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-254.1,-5.36,-100.29,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Malongo 1987\",DATUM[\"Malongo_1987\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6259\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4259\"]]");
    p = add_epsg_def_ex (filter, first, last, 4260, "epsg", 4260,
        "Manoca 1962", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Manoca_1962", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-70.9,-151.8,-41.4,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Manoca 1962\",DATUM[\"Manoca_1962\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6193\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4193\"]]");
    p = add_epsg_def_ex (filter, first, last, 4261, "epsg", 4261,
        "Merchich", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Merchich", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31,146,47");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Merchich\",DATUM[\"Merchich\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 1,
        " 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7011\"]],AUTHORITY[\"EPSG\",\"6261\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4261\"]]");
    p = add_epsg_def_ex (filter, first, last, 4262, "epsg", 4262,
        "Massawa", 1, 1,
        "Bessel 1841", "Greenwich",
        "Massawa", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=639,405,60,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Massawa\",DATUM[\"Massawa\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6262\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "62\"]]");
    p = add_epsg_def_ex (filter, first, last, 4263, "epsg", 4263,
        "Minna", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Minna", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Minna\",DATUM[\"Minna\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 1,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 2,
        "],AUTHORITY[\"EPSG\",\"6263\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 5,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 4264, "epsg", 4264,
        "Mhast (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Mhast", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,");
    add_proj4text (p, 1,
        "0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Mhast (deprecated)\",DATUM[\"Mhast\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6264\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4264\"]]");
    p = add_epsg_def_ex (filter, first, last, 4265, "epsg", 4265,
        "Monte Mario", 1, 1,
        "International 1924", "Greenwich",
        "Monte_Mario", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.9");
    add_proj4text (p, 1,
        "71,-2.917,0.714,-11.68 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Monte Mario\",DATUM[\"Monte_Mario\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6265\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4265\"]]");
    p = add_epsg_def_ex (filter, first, last, 4266, "epsg", 4266,
        "M'poraloko", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "M_poraloko", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-74,-130,");
    add_proj4text (p, 1,
        "42,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"M'poraloko\",DATUM[\"M_poraloko\",SPHEROID[\"Cl");
    add_srs_wkt (p, 1,
        "arke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6266\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4266\"]]");
    p = add_epsg_def_ex (filter, first, last, 4267, "epsg", 4267,
        "NAD27", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD27 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4267\"]]");
    p = add_epsg_def_ex (filter, first, last, 4268, "epsg", 4268,
        "NAD27", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4267\"]]");
    p = add_epsg_def_ex (filter, first, last, 4269, "epsg", 4269,
        "NAD83", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4269\"]]");
    p = add_epsg_def_ex (filter, first, last, 4270, "epsg", 4270,
        "Nahrwan 1967", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nahrwan_1967", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-249,-156,381,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nahrwan 1967\",DATUM[\"Nahrwan_1967\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6270\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4270\"]]");
    p = add_epsg_def_ex (filter, first, last, 4271, "epsg", 4271,
        "Naparima 1972", 1, 1,
        "International 1924", "Greenwich",
        "Naparima_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-10,375,165,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Naparima 1972\",DATUM[\"Naparima_1972\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6271\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4271\"]]");
    p = add_epsg_def_ex (filter, first, last, 4272, "epsg", 4272,
        "NZGD49", 1, 1,
        "International 1924", "Greenwich",
        "New_Zealand_Geodetic_Datum_1949", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=59.47,-5.04,187.44,0.");
    add_proj4text (p, 1,
        "47,-0.1,1.024,-4.5993 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_194");
    add_srs_wkt (p, 1,
        "9\",SPHEROID[\"International 1924\",6378388,297,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6272\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4272\"]]");
    p = add_epsg_def_ex (filter, first, last, 4273, "epsg", 4273,
        "NGO 1948", 1, 1,
        "Bessel Modified", "Greenwich",
        "NGO_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs");
    add_proj4text (p, 1,
        "84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGO 1948\",DATUM[\"NGO_1948\",SPHEROID[\"Bessel");
    add_srs_wkt (p, 1,
        " Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7005\"]],AUTHORITY[\"EPSG\",\"6273\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4273\"]]");
    p = add_epsg_def_ex (filter, first, last, 4274, "epsg", 4274,
        "Datum 73", 1, 1,
        "International 1924", "Greenwich",
        "Datum_73", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-223.237,110.193,36.6");
    add_proj4text (p, 1,
        "49,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4274");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4275, "epsg", 4275,
        "NTF", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Nouvelle_Triangulation_Francaise", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NTF\",DATUM[\"Nouvelle_Triangulation_Francaise\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 2,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "75\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4275\"]]");
    p = add_epsg_def_ex (filter, first, last, 4276, "epsg", 4276,
        "NSWC 9Z-2", 1, 1,
        "NWL 9D", "Greenwich",
        "NSWC_9Z-2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS66 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NSWC 9Z-2\",DATUM[\"NSWC_9Z-2\",SPHEROID[\"NWL ");
    add_srs_wkt (p, 1,
        "9D\",6378145,298.25,AUTHORITY[\"EPSG\",\"7025\"]],AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"6276\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 5,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4276\"]]");
    p = add_epsg_def_ex (filter, first, last, 4277, "epsg", 4277,
        "OSGB 1936", 1, 1,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +towgs84=446.448,-125.157,542.");
    add_proj4text (p, 1,
        "06,0.15,0.247,0.842,-20.489 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OSGB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4277\"]]");
    p = add_epsg_def_ex (filter, first, last, 4278, "epsg", 4278,
        "OSGB70", 1, 1,
        "Airy 1830", "Greenwich",
        "OSGB_1970_SN", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OSGB70\",DATUM[\"OSGB_1970_SN\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],AUTHORITY[\"EPSG\",\"6278\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4278\"]]");
    p = add_epsg_def_ex (filter, first, last, 4279, "epsg", 4279,
        "OS(SN)80", 1, 1,
        "Airy 1830", "Greenwich",
        "OS_SN_1980", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=airy +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"OS(SN)80\",DATUM[\"OS_SN_1980\",SPHEROID[\"Airy");
    add_srs_wkt (p, 1,
        " 1830\",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 2,
        "1\"]],AUTHORITY[\"EPSG\",\"6279\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4279\"]]");
    p = add_epsg_def_ex (filter, first, last, 4280, "epsg", 4280,
        "Batavia", 1, 1,
        "Bessel 1841", "Greenwich",
        "Batavia", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Batavia\",DATUM[\"Batavia\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 1,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 2,
        "]],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 4,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 5,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "11\"]]");
    p = add_epsg_def_ex (filter, first, last, 4281, "epsg", 4281,
        "Palestine 1923", 1, 1,
        "Clarke 1880 (Benoit)", "Greenwich",
        "Palestine_1923", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-27");
    add_proj4text (p, 1,
        "5.7224,94.7824,340.8944,-8.001,-4.42,-11.821,1 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Palestine 1923\",DATUM[\"Palestine_1923\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"Clarke 1880 (Benoit)\",6378300.789,293.46631553898");
    add_srs_wkt (p, 2,
        "1,AUTHORITY[\"EPSG\",\"7010\"]],AUTHORITY[\"EPSG\",\"628");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4281\"]]");
    p = add_epsg_def_ex (filter, first, last, 4282, "epsg", 4282,
        "Pointe Noire", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Congo_1960_Pointe_Noire", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-148,51,-");
    add_proj4text (p, 1,
        "291,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pointe Noire\",DATUM[\"Congo_1960_Pointe_Noire\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 2,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 3,
        "82\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4282\"]]");
    p = add_epsg_def_ex (filter, first, last, 4283, "epsg", 4283,
        "GDA94", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GDA94\",DATUM[\"Geocentric_Datum_of_Australia_1");
    add_srs_wkt (p, 1,
        "994\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6283\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4283\"]]");
    p = add_epsg_def_ex (filter, first, last, 4284, "epsg", 4284,
        "Pulkovo 1942", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=23.92,-141.27,-80.9,");
    add_proj4text (p, 1,
        "0,0.35,0.82,-0.12 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "024\"]],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4284\"]]");
    p = add_epsg_def_ex (filter, first, last, 4285, "epsg", 4285,
        "Qatar 1974", 1, 1,
        "International 1924", "Greenwich",
        "Qatar_1974", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-128.16,-282.42,21.93");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qatar 1974\",DATUM[\"Qatar_1974\",SPHEROID[\"In");
    add_srs_wkt (p, 1,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6285\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4285\"]]");
    p = add_epsg_def_ex (filter, first, last, 4286, "epsg", 4286,
        "Qatar 1948", 1, 1,
        "Helmert 1906", "Greenwich",
        "Qatar_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qatar 1948\",DATUM[\"Qatar_1948\",SPHEROID[\"He");
    add_srs_wkt (p, 1,
        "lmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"7020\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6286\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4286");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4287, "epsg", 4287,
        "Qornoq 1927", 1, 1,
        "International 1924", "Greenwich",
        "Qornoq_1927", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Qornoq 1927\",DATUM[\"Qornoq_1927\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "22\"]],AUTHORITY[\"EPSG\",\"6194\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4194\"]]");
    p = add_epsg_def_ex (filter, first, last, 4288, "epsg", 4288,
        "Loma Quintana", 1, 1,
        "International 1924", "Greenwich",
        "Loma_Quintana", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Loma Quintana\",DATUM[\"Loma_Quintana\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7022\"]],AUTHORITY[\"EPSG\",\"6288\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4288\"]]");
    p = add_epsg_def_ex (filter, first, last, 4289, "epsg", 4289,
        "Amersfoort", 1, 1,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=565.2369,50.0087,46");
    add_proj4text (p, 1,
        "5.658,-0.406857,0.350733,-1.87035,4.0812 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Amersfoort\",DATUM[\"Amersfoort\",SPHEROID[\"Be");
    add_srs_wkt (p, 1,
        "ssel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],AUTHORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4289\"]]");
    p = add_epsg_def_ex (filter, first, last, 4291, "epsg", 4291,
        "SAD69", 1, 1,
        "GRS 1967 Modified", "Greenwich",
        "South_American_Datum_1969", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SAD69\",DATUM[\"South_American_Datum_1969\",SPH");
    add_srs_wkt (p, 1,
        "EROID[\"GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7050\"]],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4618\"]]");
    p = add_epsg_def_ex (filter, first, last, 4292, "epsg", 4292,
        "Sapper Hill 1943", 1, 1,
        "International 1924", "Greenwich",
        "Sapper_Hill_1943", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-355,21,72,0,0,0,0 +n");
    add_proj4text (p, 1,
        "o_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Sapper Hill 1943\",DATUM[\"Sapper_Hill_1943\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"International 1924\",6378388,297,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6292\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4292\"]]");
    p = add_epsg_def_ex (filter, first, last, 4293, "epsg", 4293,
        "Schwarzeck", 1, 1,
        "Bessel Namibia (GLM)", "Greenwich",
        "Schwarzeck", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bess_nam +towgs84=616,97,-251,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Schwarzeck\",DATUM[\"Schwarzeck\",SPHEROID[\"Be");
    add_srs_wkt (p, 1,
        "ssel Namibia (GLM)\",6377483.86528042,299.1528128,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7046\"]],AUTHORITY[\"EPSG\",\"6293\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4293\"]]");
    p = add_epsg_def_ex (filter, first, last, 4294, "epsg", 4294,
        "Segara", 1, 1,
        "Bessel 1841", "Greenwich",
        "Gunung_Segara", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Segara\",DATUM[\"Gunung_Segara\",SPHEROID[\"Bes");
    add_srs_wkt (p, 1,
        "sel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7004\"]],AUTHORITY[\"EPSG\",\"6613\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4613\"]]");
    p = add_epsg_def_ex (filter, first, last, 4295, "epsg", 4295,
        "Serindung", 1, 1,
        "Bessel 1841", "Greenwich",
        "Serindung", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Serindung\",DATUM[\"Serindung\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6295\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4295\"]]");
    p = add_epsg_def_ex (filter, first, last, 4296, "epsg", 4296,
        "Adindan", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Adindan\",DATUM[\"Adindan\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 1,
        "880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 2,
        "2\"]],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4201\"]]");
    p = add_epsg_def_ex (filter, first, last, 4297, "epsg", 4297,
        "Tananarive", 1, 1,
        "International 1924", "Greenwich",
        "Tananarive_1925", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tananarive\",DATUM[\"Tananarive_1925\",SPHEROID");
    add_srs_wkt (p, 1,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7022\"]],AUTHORITY[\"EPSG\",\"6297\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4297\"]]");
    p = add_epsg_def_ex (filter, first, last, 4298, "epsg", 4298,
        "Timbalai 1948", 1, 1,
        "Everest 1830 (1967 Definition)", "Greenwich",
        "Timbalai_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=evrstSS +towgs84=-679,669,-48,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Timbalai 1948\",DATUM[\"Timbalai_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Everest 1830 (1967 Definition)\",6377298.556,300.801");
    add_srs_wkt (p, 2,
        "7,AUTHORITY[\"EPSG\",\"7016\"]],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 3,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4298\"]]");
    p = add_epsg_def_ex (filter, first, last, 4299, "epsg", 4299,
        "TM65", 1, 1,
        "Airy Modified 1849", "Greenwich",
        "TM65", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 1,
        "6,-1.042,-0.214,-0.631,8.15 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TM65\",DATUM[\"TM65\",SPHEROID[\"Airy Modified ");
    add_srs_wkt (p, 1,
        "1849\",6377340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6299\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4299\"]]");
    p = add_epsg_def_ex (filter, first, last, 4300, "epsg", 4300,
        "TM75", 1, 1,
        "Airy Modified 1849", "Greenwich",
        "Geodetic_Datum_of_1965", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 1,
        "6,-1.042,-0.214,-0.631,8.15 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TM75\",DATUM[\"Geodetic_Datum_of_1965\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Airy Modified 1849\",6377340.189,299.3249646,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7002\"]],AUTHORITY[\"EPSG\",\"6300\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4300\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

