//***************************************************************************
//* Copyright (c) 2023-2024 SPAdes team
//* Copyright (c) 2015-2022 Saint Petersburg State University
//* Copyright (c) 2011-2014 Saint Petersburg Academic University
//* All Rights Reserved
//* See file LICENSE for details.
//***************************************************************************

/*
 * memory.hpp
 *
 *  Created on: 05.03.2011
 *      Author: http://stackoverflow.com/questions/669438/how-to-get-memory-usage-at-run-time-in-c
 */

#ifndef MEMORY_HPP_
#define MEMORY_HPP_

#include <unistd.h>
#include <ios>
#include <iostream>
#include <fstream>
#include <string>

namespace utils {
//////////////////////////////////////////////////////////////////////////////
//
// process_mem_usage(unsigned long &, long &) - takes two longs by reference,
// attempts to read the system-dependent data for a process' virtual memory
// size and resident set size, and return the results in KB.
//
// On failure, returns 0, 0

inline void process_mem_usage(unsigned long &vm_usage, long &resident_set) {
   using std::ios_base;
   using std::ifstream;
   using std::string;

   vm_usage = 0;
   resident_set = 0;

   // 'file' stat seems to give the most reliable results
   //
   ifstream stat_stream("/proc/self/stat", ios_base::in);

   // dummy vars for leading entries in stat that we don't care about
   //
   string pid, comm, state, ppid, pgrp, session, tty_nr;
   string tpgid, flags, minflt, cminflt, majflt, cmajflt;
   string utime, stime, cutime, cstime, priority, nice;
   string O, itrealvalue, starttime;

   // the two fields we want
   //
   unsigned long vsize;
   long rss;

   stat_stream >> pid >> comm >> state >> ppid >> pgrp >> session >> tty_nr
               >> tpgid >> flags >> minflt >> cminflt >> majflt >> cmajflt
               >> utime >> stime >> cutime >> cstime >> priority >> nice
               >> O >> itrealvalue >> starttime >> vsize >> rss; // don't care about the rest

   stat_stream.close();

   long page_size_kb = sysconf(_SC_PAGE_SIZE) / 1024; // in case x86-64 is configured to use 2MB pages
   vm_usage = vsize / 1024;
   resident_set = rss * page_size_kb;
}

}
#endif /* MEMORY_HPP_ */
