11.1 Podstawowe API

# Podstawowe API oferowane przez Minecraft Pi

Sonic Pi aktualnie wspiera następujące podstawowe interakcje z Minecraft Pi: 

* Wyświetlanie wiadomości czat
* Ustawianie pozycji gracza
* Odczyt pozycji gracza
* Ustawianie typu bloku na podanych współrzędnych
* Zabieranie typu bloku na podanych współrzędnych

Spróbujmy przyjrzeć się każemu z nich po kolei.

## Wyświetlanie wiadomości w czacie

Zobaczmy jak łatwo jest kontrolować Minecraft Pi z Sonic Pi. Najpierw, 
upewnij się, że zarówno Minecraft Pi jak i Sonic Pi są jednocześnie 
otwarte a także, upewnij się, że udało Ci się wejść do świata Minecraft 
i możesz się poruszać.

W czystym buforze Sonic Pi po prostu wprowadź poniższy kod: 

```
mc_message "Hello from Sonic Pi"
```

Kiedy naciśniesz przycisk *Run*, zobaczysz migającą wiadomość w ekranie 
Minecraft. Gratulacje, właśnie napisałeś swój pierwszy kod w Minecraft! 
To było proste, prawda?

## Ustawianie pozycji gracza

Teraz, spróbujmy odrobine magii. Spróbujmy przeteleportować nas 
w inne miejsce. Spróbuj następującego kodu: 

```
mc_teleport 50, 50, 50
```

Kiedy naciśniesz *Run* - bum! Zostajesz błyskawicznie przetransportowany 
w nowe miejsce. Bardzo prawdopodobne jest to, że to gdzieś w powietrzu 
i spadniesz w dół na suchy ląd lub do wody. Teraz, co to za liczby: 
`50, 50, 50`? Są to współrzędne miejsca do którego starasz się 
przetleportować. Poświęćmy krótką chwilę żeby dowiedzieć się czym są 
współrzędne i jak działają, ponieważ są one naprawdę ważne w programowaniu 
Minecraft.

## Współrzędne

Wyobraź sobie mapę piratów z wielkim `X` oznacającym miejsce jakiegoś 
skarbu. Dokładna lokalizacja `X` może być opisana przez podanie 
dwóch liczb - jak daleko na mapie od lewej do prawej oraz jak daleko 
od dołu mapy w górę. Na przykład `10cm` wszerz i `8cm` w górę. Te dwie 
liczby `10` i `8` to współrzędne. Możesz bardzo łatwo wyobrazić sobie 
opisywanie sekretnych miejsc ze skarbami za pomocą innej pary liczb. 
Być może bardzo duża skrzynia złota znajduje się na `2` w poprzek 
`9` w górę. 

Teraz, w Minecraft dwie liczby to za mało. Potrzebujemy także wiedzieć 
o tym, jak wysoko się znajdujemy. Dlatego też potrzebujemy 3 liczb: 

* Jak daleko od prawej do lewej w naszym świecie - `x`
* jak daleko od przodu do tyłu w naszym świecie - `z`
* Jak wysoko znajdujemy się w naszym świecie - `y`

Jeszcze jedna rzecz - zazwyczaj opisujemy te współrzędne w następującej 
kolejności `x`, `y`, `z`.

## Odczytywanie twojej aktualnej lokalizacji

Spróbujmy pobawić się współrzędnymi. Przenieść się do jakiegoś 
ładnego miejsca na mapie Minecraft następnie przełącz się do Sonic Pi. 
Teraz wpisz następującą linijkę:

```
puts mc_location
```

Kiedy uruchomisz przycis *Run* zobaczysz współrzędne twojego aktualnego 
położenia wyświetlone w panelu z logami. Zapisz je, następnie spróbuj 
przemieścić się do przodu w świecie i spróbuj jeszcze raz. Zauważ, że 
współrzędne się zmieniły! Teraz, zalecam Ci poświęcić Ci trochę czasu 
na powtórzenie tego kilka razy - przenieś się gdzieś kawałek w twoim 
świecie, zerknij na współrzędne i powtórz. Próbuj tego do momentu, 
w którym poczujesz jak zmieniają się współrzędne gdy się poruszasz. 
Gdy już zrozumiesz jak działają współrzędne, programowanie z API 
oferowanym przez Minecraft będzie dla Ciebie bułką z masłem.

## Zbudujmy Coś!

Teraz gdy już wiesz w jaki sposob znaleźć aktualną pozycje oraz w jaki 
sposob możesz się teleportować korzystając z współrzędnych, posiadasz 
już wszystkie narzędzia, których potrzebujesz aby zacząć budować rzeczy 
w Minecraft za pomocą kodu. Powiedzmy, że chciałbyś stworzyć blok ze szkła 
o współrzędnych `40`, `50`, `60`. Proste: 

```
mc_set_block :glass, 40, 50, 60
```

Tak, tak, to naprawde jest takie proste. Aby obejrzeć swoje dzieło 
po prostu przeteleportuj się niedaleko i zerknij na nie: 


```
mc_teleport 35, 50, 60
```

Teraz obróć się i powinieneś zobaczyć twój blok ze szkła. Spróbuj zmienić 
go w diament: 

```
mc_set_block :diamond, 40, 50, 60
```

Jeśli patrzyłeś w odpowiednim kierunku to być może nawet zauważyłeś 
jak zmienił się na twoich oczach! To początek czegoś ekscytującego...

## Patrzenie na Bloki

Spróbujmy spojrzeć na ostatnią rzecz zanim zaczniemy coś bardziej 
angażującego. Podająć zestaw współrzędnych możemy zapytać Minecraft 
o to jakiego typu jest specyficzny blok. Spróbujmy tego z naszym 
blokiem diamentu, który stworzyłeś przed chwilą:

```
puts mc_get_block 40, 50, 60
```

Łał! To diament (`:diamond`)!. Spróbuj ponownie zmienić go w szkło 
i jeszcze raz zapytać o typ - czy teraz pokazał szkło (`:glass`). 
Jestem pewien, że tak :-)

## Dostępne typy bloków

Zanim udasz oddasz się szaleństwu programowania z Minecraft Pi, być może 
zainteresuje Cie poniższa lista dostępnych typów bloków:

        :air
        :stone
        :grass
        :dirt
        :cobblestone
        :wood_plank
        :sapling
        :bedrock
        :water_flowing
        :water
        :water_stationary
        :lava_flowing
        :lava
        :lava_stationary
        :sand
        :gravel
        :gold_ore
        :iron_ore
        :coal_ore
        :wood
        :leaves
        :glass
        :lapis
        :lapis_lazuli_block
        :sandstone
        :bed
        :cobweb
        :grass_tall
        :flower_yellow
        :flower_cyan
        :mushroom_brown
        :mushroom_red
        :gold_block
        :gold
        :iron_block
        :iron
        :stone_slab_double
        :stone_slab
        :brick
        :brick_block
        :tnt
        :bookshelf
        :moss_stone
        :obsidian
        :torch
        :fire
        :stairs_wood
        :chest
        :diamond_ore
        :diamond_block
        :diamond
        :crafting_table
        :farmland
        :furnace_inactive
        :furnace_active
        :door_wood
        :ladder
        :stairs_cobblestone
        :door_iron
        :redstone_ore
        :snow
        :ice
        :snow_block
        :cactus
        :clay
        :sugar_cane
        :fence
        :glowstone_block
        :bedrock_invisible
        :stone_brick
        :glass_pane
        :melon
        :fence_gate
        :glowing_obsidian
        :nether_reactor_core
