/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2024 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/* don't #pragma once this file, it gets #included multiple times! */

#ifndef SDL3_SYM
#define SDL3_SYM(rc,fn,params,args,ret)
#endif
#ifndef SDL3_SYM_PASSTHROUGH
#define SDL3_SYM_PASSTHROUGH(rc,fn,params,args,ret) SDL3_SYM(rc,fn,params,args,ret)
#endif
#ifndef SDL3_SYM_PASSTHROUGH_BOOL
#define SDL3_SYM_PASSTHROUGH_BOOL SDL3_SYM_PASSTHROUGH
#endif
#ifndef SDL3_SYM_PASSTHROUGH_RETCODE
#define SDL3_SYM_PASSTHROUGH_RETCODE SDL3_SYM_PASSTHROUGH
#endif
#ifndef SDL3_SYM_RENAMED
#define SDL3_SYM_RENAMED(rc,oldfn,newfn,params,args,ret) SDL3_SYM(rc,newfn,params,args,ret)
#endif
#ifndef SDL3_SYM_RENAMED_BOOL
#define SDL3_SYM_RENAMED_BOOL SDL3_SYM_RENAMED
#endif
#ifndef SDL3_SYM_RENAMED_RETCODE
#define SDL3_SYM_RENAMED_RETCODE SDL3_SYM_RENAMED
#endif
#ifndef SDL3_SYM_VARARGS
#define SDL3_SYM_VARARGS(rc,fn,params) SDL3_SYM(rc,fn,params,unused,unused)
#endif

SDL3_SYM_VARARGS(bool,SetError,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL3_SYM_VARARGS(void,Log,(SDL_PRINTF_FORMAT_STRING const char *a, ...))
SDL3_SYM_VARARGS(void,LogVerbose,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogDebug,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogInfo,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogWarn,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogError,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogCritical,(int a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(void,LogMessage,(int a, SDL_LogPriority b, SDL_PRINTF_FORMAT_STRING const char *c, ...))
SDL3_SYM_VARARGS(int,sscanf,(const char *a, SDL_SCANF_FORMAT_STRING const char *b, ...))
SDL3_SYM_VARARGS(int,snprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, SDL_PRINTF_FORMAT_STRING const char *c, ...))
SDL3_SYM(SDL_Thread*,CreateThreadWithPropertiesRuntime,(SDL_PropertiesID a, SDL_FunctionPointer b, SDL_FunctionPointer c),(a,b,c),return)

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_GDK)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,RegisterApp,(const char *a, Uint32 b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void,UnregisterApp,(void),(),)
SDL3_SYM(void,SetWindowsMessageHook,(SDL_WindowsMessageHook a, void *b),(a,b),)
#endif

#if defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK)
SDL3_SYM(int,GetDirect3D9AdapterIndex,(SDL_DisplayID a),(a),return)
SDL3_SYM(bool,GetDXGIOutputInfo,(SDL_DisplayID a,int *b, int *c),(a,b,c),return)
#endif

#ifdef SDL_PLATFORM_GDK
SDL3_SYM_RENAMED_RETCODE(bool,GDKGetTaskQueue,GetGDKTaskQueue,(XTaskQueueHandle *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,GDKGetDefaultUser,GetGDKDefaultUser,(XUserHandle *a),(a),return)
#endif

#ifdef SDL_PLATFORM_IOS
SDL3_SYM_RENAMED_RETCODE(bool,iPhoneSetAnimationCallback,SetiOSAnimationCallback,(SDL_Window *a, int b, SDL_iOSAnimationCallback c, void *d),(a,b,c,d),return)
SDL3_SYM(void,iPhoneSetEventPump,SetiOSEventPump,(bool a),(a),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidChangeStatusBarOrientation,(void),(),)
#endif

#ifdef SDL_PLATFORM_LINUX
SDL3_SYM_RENAMED_RETCODE(bool,LinuxSetThreadPriority,SetLinuxThreadPriority,(Sint64 a, int b),(a,b),return)
SDL3_SYM_RENAMED_RETCODE(bool,LinuxSetThreadPriorityAndPolicy,SetLinuxThreadPriorityAndPolicy,(Sint64 a, int b, int c),(a,b,c),return)
#endif

#ifdef SDL_PLATFORM_ANDROID
SDL3_SYM_RENAMED(void*,AndroidGetJNIEnv,GetAndroidJNIEnv,(void),(),return)
SDL3_SYM_RENAMED(void*,AndroidGetActivity,GetAndroidActivity,(void),(),return)
SDL3_SYM_RENAMED(const char*,AndroidGetInternalStoragePath,GetAndroidInternalStoragePath,(void),(),return)
SDL3_SYM(Uint32,GetAndroidExternalStorageState,(void),(),return)
SDL3_SYM_RENAMED(const char*,AndroidGetExternalStoragePath,GetAndroidExternalStoragePath,(void),(),return)
SDL3_SYM_RENAMED_RETCODE(bool,AndroidSendMessage,SendAndroidMessage,(Uint32 a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,IsChromebook,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,IsDeXMode,(void),(),return)
SDL3_SYM_RENAMED(void,AndroidBackButton,SendAndroidBackButton,(void),(),)
SDL3_SYM(bool,RequestAndroidPermission,(const char *a, SDL_RequestAndroidPermissionCallback b, void *c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,AndroidShowToast,ShowAndroidToast,(const char *a, int b, int c, int d, int e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,GetAndroidSDKVersion,(void),(),return)
#endif

SDL3_SYM(int,AddGamepadMappingsFromIO,(SDL_IOStream *a, bool b),(a,b),return)
SDL3_SYM(bool,AddHintCallback,(const char *a, SDL_HintCallback b, void *c),(a,b,c),)
SDL3_SYM(SDL_TimerID,AddTimer,(Uint32 a, SDL_TimerCallback b, void *c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_Palette*,AllocPalette,CreatePalette,(int a),(a),return)
SDL3_SYM_RENAMED(int,AtomicAdd,AddAtomicInt,(SDL_atomic_t *a, int b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,AtomicCAS,CompareAndSwapAtomicInt,(SDL_atomic_t *a, int b, int c),(a,b,c),return)
SDL3_SYM_RENAMED_BOOL(bool,AtomicCASPtr,CompareAndSwapAtomicPointer,(void **a, void *b, void *c),(a,b,c),return)
SDL3_SYM_RENAMED(int,AtomicGet,GetAtomicInt,(SDL_atomic_t *a),(a),return)
SDL3_SYM_RENAMED(void*,AtomicGetPtr,GetAtomicPointer,(void **a),(a),return)
SDL3_SYM_RENAMED(void,AtomicLock,LockSpinlock,(SDL_SpinLock *a),(a),)
SDL3_SYM_RENAMED(int,AtomicSet,SetAtomicInt,(SDL_atomic_t *a, int b),(a,b),return)
SDL3_SYM_RENAMED(void*,AtomicSetPtr,SetAtomicPointer,(void **a, void *b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,AtomicTryLock,TryLockSpinlock,(SDL_SpinLock *a),(a),return)
SDL3_SYM_RENAMED(void,AtomicUnlock,UnlockSpinlock,(SDL_SpinLock *a),(a),)
SDL3_SYM(SDL_JoystickID,AttachVirtualJoystick,(const SDL_VirtualJoystickDesc *a),(a),return)
SDL3_SYM(bool,AudioDevicePaused,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(bool,BindAudioStream,(SDL_AudioDeviceID a, SDL_AudioStream *b),(a,b),return)
SDL3_SYM(bool,BlitSurface,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM(bool,BlitSurfaceScaled,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM(bool,BlitSurfaceUnchecked,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM(bool,BlitSurfaceUncheckedScaled,(SDL_Surface *a, const SDL_Rect *b, SDL_Surface *c, const SDL_Rect *d, SDL_ScaleMode e),(a,b,c,d,e),return)
SDL3_SYM(void,BroadcastCondition,(SDL_Condition *a),(a),return)
SDL3_SYM(bool,CaptureMouse,(bool a),(a),return)
SDL3_SYM(bool,ClearAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(bool,ClearComposition,(SDL_Window *a),(a),return)
SDL3_SYM(bool,ClearError,(void),(),return)
SDL3_SYM(bool,ClearProperty,(SDL_PropertiesID a, const char *b),(a,b),return)
SDL3_SYM(void,CloseAudioDevice,(SDL_AudioDeviceID a),(a),)
SDL3_SYM(bool,CloseIO,(SDL_IOStream *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_BlendMode,ComposeCustomBlendMode,(SDL_BlendFactor a, SDL_BlendFactor b, SDL_BlendOperation c, SDL_BlendFactor d, SDL_BlendFactor e, SDL_BlendOperation f),(a,b,c,d,e,f),return)
SDL3_SYM(bool,ConvertEventToRenderCoordinates,(SDL_Renderer *a, SDL_Event *b),(a,b),return)
SDL3_SYM(bool,ConvertPixelsAndColorspace,(int a, int b, SDL_PixelFormat c, SDL_Colorspace d, SDL_PropertiesID e, const void *f, int g, SDL_PixelFormat h, SDL_Colorspace i, SDL_PropertiesID j, void *k, int l),(a,b,c,d,e,f,g,h,i,j,k,l),return)
SDL3_SYM(SDL_Surface*,ConvertSurface,(SDL_Surface *a, SDL_PixelFormat b),(a,b),return)
SDL3_SYM(SDL_Surface *,ConvertSurfaceAndColorspace,(SDL_Surface *a, SDL_PixelFormat b, SDL_Palette *c, SDL_Colorspace d, SDL_PropertiesID e),(a,b,c,d,e),return)
SDL3_SYM(SDL_AudioStream*,CreateAudioStream,(const SDL_AudioSpec *a, const SDL_AudioSpec *b),(a,b),return)
SDL3_SYM(SDL_Cursor*,CreateColorCursor,(SDL_Surface *a, int b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(SDL_Condition*,CreateCond,CreateCondition,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,CreateCursor,(const Uint8 *a, const Uint8 *b, int c, int d, int e, int f),(a,b,c,d,e,f),return)
SDL3_SYM(int,CreateHapticEffect,(SDL_Haptic *a, const SDL_HapticEffect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Mutex*,CreateMutex,(void),(),return)
SDL3_SYM(SDL_Window*,CreatePopupWindow,(SDL_Window *a, int b, int c, int d, int e, SDL_WindowFlags f),(a,b,c,d,e,f),return)
SDL3_SYM(SDL_PropertiesID,CreateProperties,(void),(),return)
SDL3_SYM(SDL_Renderer*,CreateRenderer,(SDL_Window *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Semaphore*,CreateSemaphore,(Uint32 a),(a),return)
SDL3_SYM(SDL_Renderer*,CreateSoftwareRenderer,(SDL_Surface *a),(a),return)
SDL3_SYM(SDL_Surface*,CreateSurface,(int a, int b, SDL_PixelFormat c),(a,b,c),return)
SDL3_SYM(SDL_Surface*,CreateSurfaceFrom,(int a, int b, SDL_PixelFormat c, void *d, int e),(a,b,c,d,e),return)
SDL3_SYM(SDL_Palette *,CreateSurfacePalette,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,CreateSystemCursor,(SDL_SystemCursor a),(a),return)
SDL3_SYM(SDL_Texture*,CreateTexture,(SDL_Renderer *a, SDL_PixelFormat b, SDL_TextureAccess c, int d, int e),(a,b,c,d,e),return)
SDL3_SYM(SDL_Texture*,CreateTextureFromSurface,(SDL_Renderer *a, SDL_Surface *b),(a,b),return)
SDL3_SYM(SDL_Window*,CreateWindow,(const char *a, int b, int c, SDL_WindowFlags d),(a,b,c,d),return)
SDL3_SYM(SDL_Window*,CreateWindowWithProperties,(SDL_PropertiesID a),(a),return)
SDL3_SYM(bool,CursorVisible,(void),(),return)
SDL3_SYM(void,RemoveHintCallback,(const char *a, SDL_HintCallback b, void *c),(a,b,c),)
SDL3_SYM_PASSTHROUGH(void,Delay,(Uint32 a),(a),)
SDL3_SYM(void,DestroyAudioStream,(SDL_AudioStream *a),(a),)
SDL3_SYM_RENAMED(void,DestroyCond,DestroyCondition,(SDL_Condition *a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroyMutex,(SDL_Mutex *a),(a),)
SDL3_SYM(void,DestroyPalette,(SDL_Palette *a),(a),)
SDL3_SYM(void,DestroyProperties,(SDL_PropertiesID a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroyRenderer,(SDL_Renderer *a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroySemaphore,(SDL_Semaphore *a),(a),)
SDL3_SYM(void,DestroySurface,(SDL_Surface *a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroyTexture,(SDL_Texture *a),(a),)
SDL3_SYM_PASSTHROUGH(void,DestroyWindow,(SDL_Window *a),(a),)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,DestroyWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,DetachThread,(SDL_Thread *a),(a),)
SDL3_SYM(bool,DetachVirtualJoystick,(SDL_JoystickID a),(a),return)
SDL3_SYM(bool,DisableScreenSaver,(void),(),return)
SDL3_SYM(SDL_Surface*,DuplicateSurface,(SDL_Surface *a),(a),return)
SDL3_SYM(bool,EnableScreenSaver,(void),(),return)
SDL3_SYM_RENAMED_BOOL(bool,EncloseFPoints,GetRectEnclosingPointsFloat,(const SDL_FPoint *a, int b, const SDL_FRect *c, SDL_FRect *d),(a,b,c,d),return)
SDL3_SYM_RENAMED_BOOL(bool,EnclosePoints,GetRectEnclosingPoints,(const SDL_Point *a, int b, const SDL_Rect *c, SDL_Rect *d),(a,b,c,d),return)
SDL3_SYM(bool,EventEnabled,(Uint32 a),(a),return)
SDL3_SYM(bool,FillSurfaceRect,(SDL_Surface *a, const SDL_Rect *b, Uint32 c),(a,b,c),return)
SDL3_SYM(bool,FillSurfaceRects,(SDL_Surface *a, const SDL_Rect *b, int c, Uint32 d),(a,b,c,d),return)
SDL3_SYM(void,FilterEvents,(SDL_EventFilter a, void *b),(a,b),)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,FlashWindow,(SDL_Window *a, SDL_FlashOperation b),(a,b),return)
SDL3_SYM(bool,FlushAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,FlushEvent,(Uint32 a),(a),)
SDL3_SYM_PASSTHROUGH(void,FlushEvents,(Uint32 a, Uint32 b),(a,b),)
SDL3_SYM_RENAMED(void,FreeCursor,DestroyCursor,(SDL_Cursor *a),(a),)
SDL3_SYM_PASSTHROUGH(SDL_GLContext,GL_CreateContext,(SDL_Window *a),(a),return)
SDL3_SYM(bool,GL_DestroyContext,(SDL_GLContext a),(a),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,GL_ExtensionSupported,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GL_GetAttribute,(SDL_GLattr a, int *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_GLContext,GL_GetCurrentContext,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GL_GetCurrentWindow,(void),(),return)
SDL3_SYM_PASSTHROUGH(void*,GL_GetProcAddress,(const char *a),(a),return)
SDL3_SYM(bool,GL_GetSwapInterval,(int *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GL_LoadLibrary,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GL_MakeCurrent,(SDL_Window *a, SDL_GLContext b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,GL_ResetAttributes,(void),(),)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GL_SetAttribute,(SDL_GLattr a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GL_SetSwapInterval,(int a),(a),return)
SDL3_SYM(bool,GL_SwapWindow,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,GL_UnloadLibrary,(void),(),)
SDL3_SYM_RENAMED(SDL_GUID,GUIDFromString,StringToGUID,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,GUIDToString,(SDL_GUID a, char *b, int c),(a,b,c),)
SDL3_SYM_RENAMED(int,GameControllerAddMapping,AddGamepadMapping,(const char *a),(a),return)
SDL3_SYM_RENAMED(void,GameControllerClose,CloseGamepad,(SDL_GameController *a),(a),)
SDL3_SYM_RENAMED(SDL_GameController*,GameControllerFromPlayerIndex,GetGamepadFromPlayerIndex,(int a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetAppleSFSymbolsNameForAxis,GetGamepadAppleSFSymbolsNameForAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetAppleSFSymbolsNameForButton,GetGamepadAppleSFSymbolsNameForButton,(SDL_GameController *a, SDL_GameControllerButton b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,GameControllerGetAttached,GamepadConnected,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Sint16,GameControllerGetAxis,GetGamepadAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_RENAMED(SDL_GameControllerAxis,GameControllerGetAxisFromString,GetGamepadAxisFromString,(const char *a),(a),return)
SDL3_SYM_RENAMED(SDL_GameControllerButton,GameControllerGetButtonFromString,GetGamepadButtonFromString,(const char *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetFirmwareVersion,GetGamepadFirmwareVersion,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(SDL_Joystick*,GameControllerGetJoystick,GetGamepadJoystick,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerGetNumTouchpadFingers,GetNumGamepadTouchpadFingers,(SDL_GameController *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,GameControllerGetNumTouchpads,GetNumGamepadTouchpads,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(int,GameControllerGetPlayerIndex,GetGamepadPlayerIndex,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetProduct,GetGamepadProduct,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetProductVersion,GetGamepadProductVersion,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,GameControllerGetSensorData,GetGamepadSensorData,(SDL_GameController *a, SDL_SensorType b, float *c, int d),(a,b,c,d),return)
SDL3_SYM_RENAMED(float,GameControllerGetSensorDataRate,GetGamepadSensorDataRate,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetSerial,GetGamepadSerial,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(Uint64,GameControllerGetSteamHandle,GetGamepadSteamHandle,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetStringForAxis,GetGamepadStringForAxis,(SDL_GameControllerAxis a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerGetStringForButton,GetGamepadStringForButton,(SDL_GameControllerButton a),(a),return)
SDL3_SYM(bool,GetGamepadTouchpadFinger,(SDL_GameController *a, int b, int c, bool *d, float *e, float *f, float *g),(a,b,c,d,e,f,g),return)
SDL3_SYM_RENAMED(Uint16,GameControllerGetVendor,GetGamepadVendor,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,GameControllerHasAxis,GamepadHasAxis,(SDL_GameController *a, SDL_GameControllerAxis b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,GameControllerHasButton,GamepadHasButton,(SDL_GameController *a, SDL_GameControllerButton b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,GameControllerHasSensor,GamepadHasSensor,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,GameControllerIsSensorEnabled,GamepadSensorEnabled,(SDL_GameController *a, SDL_SensorType b),(a,b),return)
SDL3_SYM_RENAMED(char*,GameControllerMapping,GetGamepadMapping,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(char*,GameControllerMappingForGUID,GetGamepadMappingForGUID,(SDL_GUID a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerName,GetGamepadName,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED(const char*,GameControllerPath,GetGamepadPath,(SDL_GameController *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,GameControllerRumble,RumbleGamepad,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED_RETCODE(bool,GameControllerRumbleTriggers,RumbleGamepadTriggers,(SDL_GameController *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED_RETCODE(bool,GameControllerSendEffect,SendGamepadEffect,(SDL_GameController *a, const void *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,GameControllerSetLED,SetGamepadLED,(SDL_GameController *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM(bool,SetGamepadSensorEnabled,(SDL_GameController *a, SDL_SensorType b, bool c),(a,b,c),return)
SDL3_SYM_RENAMED(void,GameControllerUpdate,UpdateGamepads,(void),(),)
SDL3_SYM(bool,GamepadEventsEnabled,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_AssertionHandler,GetAssertionHandler,(void **a),(a),return)
SDL3_SYM_PASSTHROUGH(const SDL_AssertData*,GetAssertionReport,(void),(),return)
SDL3_SYM(bool,GetAudioDeviceFormat,(SDL_AudioDeviceID a, SDL_AudioSpec *b, int *c),(a,b,c),return)
SDL3_SYM(const char*,GetAudioDeviceName,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetAudioDriver,(int a),(a),return)
SDL3_SYM(SDL_AudioDeviceID*,GetAudioPlaybackDevices,(int *a),(a),return)
SDL3_SYM(SDL_AudioDeviceID*,GetAudioRecordingDevices,(int *a),(a),return)
SDL3_SYM(int,GetAudioStreamAvailable,(SDL_AudioStream *a),(a),return)
SDL3_SYM(int,GetAudioStreamData,(SDL_AudioStream *a, void *b, int c),(a,b,c),return)
SDL3_SYM(SDL_AudioDeviceID,GetAudioStreamDevice,(SDL_AudioStream *a),(a),return)
SDL3_SYM(const char*,GetBasePath,(void),(),return)
SDL3_SYM(bool,GetBooleanProperty,(SDL_PropertiesID a, const char *b, bool c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,GetCPUCacheLineSize,(void),(),return)
SDL3_SYM_RENAMED(int,GetCPUCount,GetNumLogicalCPUCores,(void),(),return)
SDL3_SYM_PASSTHROUGH(char*,GetClipboardText,(void),(),return)
SDL3_SYM(bool,GetClosestFullscreenDisplayMode,(SDL_DisplayID a, int b, int c, float d, bool e, SDL_DisplayMode *f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH(const char*,GetCurrentAudioDriver,(void),(),return)
SDL3_SYM(const SDL_DisplayMode*,GetCurrentDisplayMode,(SDL_DisplayID a),(a),return)
SDL3_SYM(SDL_DisplayOrientation,GetCurrentDisplayOrientation,(SDL_DisplayID a),(a),return)
SDL3_SYM(Uint64,GetCurrentThreadID,(void),(),return)
SDL3_SYM(const char*,GetCurrentVideoDriver,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,GetCursor,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_AssertionHandler,GetDefaultAssertionHandler,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Cursor*,GetDefaultCursor,(void),(),return)
SDL3_SYM(const SDL_DisplayMode*,GetDesktopDisplayMode,(SDL_DisplayID a),(a),return)
SDL3_SYM(bool,GetDisplayBounds,(SDL_DisplayID a, SDL_Rect *b),(a,b),return)
SDL3_SYM(float,GetDisplayContentScale,(SDL_DisplayID a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForPoint,(const SDL_Point *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForRect,(const SDL_Rect *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetDisplayForWindow,(SDL_Window *a),(a),return)
SDL3_SYM(const char*,GetDisplayName,(SDL_DisplayID a),(a),return)
SDL3_SYM(bool,GetDisplayUsableBounds,(SDL_DisplayID a, SDL_Rect *b),(a,b),return)
SDL3_SYM(SDL_DisplayID*,GetDisplays,(int *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetError,(void),(),return)
SDL3_SYM(bool,GetEventFilter,(SDL_EventFilter *a, void **b),(a,b),)
SDL3_SYM(float,GetFloatProperty,(SDL_PropertiesID a, const char *b, float c),(a,b,c),return)
SDL3_SYM(SDL_DisplayMode **,GetFullscreenDisplayModes,(SDL_DisplayID a, int *b),(a,b),return)
SDL3_SYM(SDL_GamepadBinding **,GetGamepadBindings,(SDL_Gamepad *a, int *b),(a,b),return)
SDL3_SYM(bool,GetGamepadButton,(SDL_Gamepad *a, SDL_GamepadButton b),(a,b),return)
SDL3_SYM(SDL_GamepadButtonLabel,GetGamepadButtonLabel,(SDL_Gamepad *a, SDL_GamepadButton b),(a,b),return)
SDL3_SYM(SDL_GameController*,GetGamepadFromID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickID,GetGamepadID,(SDL_GameController *a),(a),return)
SDL3_SYM(char*,GetGamepadMappingForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(char **,GetGamepadMappings,(int *a),(a),return)
SDL3_SYM(const char *,GetGamepadNameForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetGamepadPathForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_PropertiesID,GetGamepadProperties,(SDL_GameController *a),(a),return)
SDL3_SYM(SDL_GamepadType,GetGamepadType,(SDL_GameController *a),(a),return)
SDL3_SYM(SDL_GamepadType,GetGamepadTypeForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint32,GetGlobalMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetGrabbedWindow,(void),(),return)
SDL3_SYM(Uint32,GetHapticFeatures,(SDL_Haptic *a),(a),return)
SDL3_SYM(SDL_Haptic *,GetHapticFromID,(SDL_HapticID a),(a),return)
SDL3_SYM(SDL_HapticID,GetHapticID,(SDL_Haptic *a),(a),return)
SDL3_SYM(const char *,GetHapticNameForID,(SDL_HapticID a),(a),return)
SDL3_SYM(SDL_HapticID *,GetHaptics,(int *a),(a),return)
SDL3_SYM(const char*,GetHint,(const char *a),(a),return)
SDL3_SYM(bool,GetHintBoolean,(const char *a, bool b),(a,b),return)
SDL3_SYM(SDL_PropertiesID,GetIOProperties,(SDL_IOStream *a),(a),return)
SDL3_SYM(Sint64,GetIOSize,(SDL_IOStream *a),(a),return)
SDL3_SYM(SDL_JoystickConnectionState,GetJoystickConnectionState,(SDL_Joystick *a),(a),return)
SDL3_SYM(SDL_Joystick*,GetJoystickFromID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_GUID,GetJoystickGUIDForID,(SDL_JoystickID a),(a),return)
SDL3_SYM_PASSTHROUGH(void,GetJoystickGUIDInfo,(SDL_GUID a, Uint16 *b, Uint16 *c, Uint16 *d, Uint16 *e),(a,b,c,d,e),)
SDL3_SYM(SDL_JoystickID,GetJoystickID,(SDL_Joystick *a),(a),return)
SDL3_SYM(const char *,GetJoystickNameForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(const char *,GetJoystickPathForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(int,GetJoystickPlayerIndexForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_PowerState,GetJoystickPowerInfo,(SDL_Joystick *a, int *b),(a,b),return)
SDL3_SYM(Uint16,GetJoystickProductForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint16,GetJoystickProductVersionForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_PropertiesID,GetJoystickProperties,(SDL_Joystick *a),(a),return)
SDL3_SYM(SDL_JoystickType,GetJoystickTypeForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(Uint16,GetJoystickVendorForID,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_JoystickID*,GetJoysticks,(int *a),(a),return)
SDL3_SYM(SDL_Keycode,GetKeyFromName,(const char *a),(a),return)
SDL3_SYM(SDL_Keycode,GetKeyFromScancode,(SDL_Scancode a, SDL_Keymod b, bool c),(a,b,c),return)
SDL3_SYM(const char*,GetKeyName,(SDL_Keycode a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetKeyboardFocus,(void),(),return)
SDL3_SYM(const bool*,GetKeyboardState,(int *a),(a),return)
SDL3_SYM(bool,GetMasksForPixelFormat,(SDL_PixelFormat a, int *b, Uint32 *c, Uint32 *d, Uint32 *e, Uint32 *f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH(void,GetMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d),(a,b,c,d),)
SDL3_SYM(SDL_Keymod,GetModState,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetMouseFocus,(void),(),return)
SDL3_SYM(Uint32,GetMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,GetNumAllocations,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetNumAudioDrivers,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetNumRenderDrivers,(void),(),return)
SDL3_SYM_PASSTHROUGH(int,GetNumVideoDrivers,(void),(),return)
SDL3_SYM(Sint64,GetNumberProperty,(SDL_PropertiesID a, const char *b, Sint64 c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void,GetOriginalMemoryFunctions,(SDL_malloc_func *a, SDL_calloc_func *b, SDL_realloc_func *c, SDL_free_func *d),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(Uint64,GetPerformanceCounter,(void),(),return)
SDL3_SYM_PASSTHROUGH(Uint64,GetPerformanceFrequency,(void),(),return)
SDL3_SYM(const SDL_PixelFormatDetails *,GetPixelFormatDetails,(SDL_PixelFormat a),(a),return)
SDL3_SYM(SDL_PixelFormat,GetPixelFormatForMasks,(int a, Uint32 b, Uint32 c, Uint32 d, Uint32 e),(a,b,c,d,e),return)
SDL3_SYM(const char*,GetPixelFormatName,(SDL_PixelFormat a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetPlatform,(void),(),return)
SDL3_SYM(void*,GetPointerProperty,(SDL_PropertiesID a, const char *b, void *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_PowerState,GetPowerInfo,(int *a, int *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,GetPrefPath,(const char *a, const char *b),(a,b),return)
SDL3_SYM(SDL_Locale **,GetPreferredLocales,(int *a),(a),return)
SDL3_SYM(SDL_DisplayID,GetPrimaryDisplay,(void),(),return)
SDL3_SYM_PASSTHROUGH(char*,GetPrimarySelectionText,(void),(),return)
SDL3_SYM(void,GetRGB,(Uint32 a, const SDL_PixelFormatDetails *b, const SDL_Palette *c, Uint8 *d, Uint8 *e, Uint8 *f),(a,b,c,d,e,f),)
SDL3_SYM(void,GetRGBA,(Uint32 a, const SDL_PixelFormatDetails *b, const SDL_Palette *c, Uint8 *d, Uint8 *e, Uint8 *f, Uint8 *g),(a,b,c,d,e,f,g),)
SDL3_SYM(bool,GetRectUnion,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c),(a,b,c),return)
SDL3_SYM(bool,GetRectUnionFloat,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c),(a,b,c),return)
SDL3_SYM(Uint32,GetRelativeMouseState,(float *a, float *b),(a,b),return)
SDL3_SYM(bool,GetRenderClipRect,(SDL_Renderer *a, SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetRenderDrawColor,(SDL_Renderer *a, Uint8 *b, Uint8 *c, Uint8 *d, Uint8 *e),(a,b,c,d,e),return)
SDL3_SYM(const char *,GetRenderDriver,(int a),(a),return);
SDL3_SYM(bool,GetRenderLogicalPresentation,(SDL_Renderer *a, int *b, int *c, SDL_RendererLogicalPresentation *d),(a,b,c,d),return)
SDL3_SYM(bool,GetRenderScale,(SDL_Renderer *a, float *b, float *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(SDL_Texture*,GetRenderTarget,(SDL_Renderer *a),(a),return)
SDL3_SYM(bool,GetRenderViewport,(SDL_Renderer *a, SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(SDL_Renderer*,GetRenderer,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_Renderer *,GetRendererFromTexture,(SDL_Texture *a),(a),return)
SDL3_SYM(const char*,GetRendererName,(SDL_Renderer *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,GetRendererOutputSize,GetRenderOutputSize,(SDL_Renderer *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(SDL_PropertiesID,GetRendererProperties,(SDL_Renderer *a),(a),return)
SDL3_SYM(SDL_Scancode,GetScancodeFromKey,(SDL_Keycode a, SDL_Keymod *b),(a,b),return)
SDL3_SYM(SDL_Scancode,GetScancodeFromName,(const char *a),(a),return)
SDL3_SYM(const char*,GetScancodeName,(SDL_Scancode a),(a),return)
SDL3_SYM(SDL_Sensor*,GetSensorFromID,(SDL_SensorID a),(a),return)
SDL3_SYM(SDL_SensorID,GetSensorID,(SDL_Sensor *a),(a),return)
SDL3_SYM(const char *,GetSensorNameForID,(SDL_SensorID a),(a),return)
SDL3_SYM(int,GetSensorNonPortableTypeForID,(SDL_SensorID a),(a),return)
SDL3_SYM(SDL_SensorType,GetSensorTypeForID,(SDL_SensorID a),(a),return)
SDL3_SYM(SDL_SensorID *,GetSensors,(int *a),(a),return)
SDL3_SYM(int,GetSilenceValueForFormat,(SDL_AudioFormat a),(a),return)
SDL3_SYM(bool,GetSurfaceAlphaMod,(SDL_Surface *a, Uint8 *b),(a,b),return)
SDL3_SYM(bool,GetSurfaceBlendMode,(SDL_Surface *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM(bool,GetSurfaceClipRect,(SDL_Surface *a, SDL_Rect *b),(a,b),return)
SDL3_SYM(bool,GetSurfaceColorKey,(SDL_Surface *a, Uint32 *b),(a,b),return)
SDL3_SYM(bool,GetSurfaceColorMod,(SDL_Surface *a, Uint8 *b, Uint8 *c, Uint8 *d),(a,b,c,d),return)
SDL3_SYM(SDL_Colorspace,GetSurfaceColorspace,(SDL_Surface *a),(a),return)
SDL3_SYM(SDL_Palette *,GetSurfacePalette,(SDL_Surface *a),(a),return)
SDL3_SYM(SDL_PropertiesID,GetSurfaceProperties,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,GetSystemRAM,(void),(),return)
SDL3_SYM(void*,GetTLS,(SDL_TLSID *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetTextureAlphaMod,(SDL_Texture *a, Uint8 *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetTextureColorMod,(SDL_Texture *a, Uint8 *b, Uint8 *c, Uint8 *d),(a,b,c,d),return)
SDL3_SYM(SDL_PropertiesID,GetTextureProperties,(SDL_Texture *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode *b),(a,b),return)
SDL3_SYM(Uint64,GetThreadID,(SDL_Thread *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetThreadName,(SDL_Thread *a),(a),return)
SDL3_SYM(Uint64,GetTicks,(void),(),return)
SDL3_SYM(const char*,GetTouchDeviceName,(SDL_TouchID a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_TouchDeviceType,GetTouchDeviceType,(SDL_TouchID a),(a),return)
SDL3_SYM(SDL_TouchID*,GetTouchDevices,(int *a),(a),return)
SDL3_SYM(SDL_Finger**,GetTouchFingers,(SDL_TouchID a, int *b),(a,b),return)
SDL3_SYM(int,GetVersion,(void),(),return)
SDL3_SYM(const char*,GetVideoDriver,(int a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,GetWindowBordersSize,(SDL_Window *a, int *b, int *c, int *d, int *e),(a,b,c,d,e),return)
SDL3_SYM(SDL_WindowFlags,GetWindowFlags,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_Window*,GetWindowFromID,(Uint32 a),(a),return)
SDL3_SYM(const SDL_DisplayMode *,GetWindowFullscreenMode,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,GetWindowICCProfile,(SDL_Window *a, size_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(Uint32,GetWindowID,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,GetWindowKeyboardGrab,(SDL_Window *a),(a),return)
SDL3_SYM(bool,GetWindowMaximumSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(bool,GetWindowMinimumSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,GetWindowMouseGrab,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(const SDL_Rect*,GetWindowMouseRect,(SDL_Window *a),(a),return)
SDL3_SYM(float,GetWindowOpacity,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_PixelFormat,GetWindowPixelFormat,(SDL_Window *a),(a),return)
SDL3_SYM(bool,GetWindowPosition,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(SDL_PropertiesID,GetWindowProperties,(SDL_Window *a),(a),return)
SDL3_SYM(bool,GetWindowRelativeMouseMode,(SDL_Window *a),(a),return)
SDL3_SYM(bool,GetWindowSize,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(bool,GetWindowSizeInPixels,(SDL_Window *a, int *b, int *c),(a,b,c),return)
SDL3_SYM(SDL_Surface*,GetWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(const char*,GetWindowTitle,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_Window **,GetWindows,(int *a),(a),return)
SDL3_SYM_RENAMED(void,HapticClose,CloseHaptic,(SDL_Haptic *a),(a),)
SDL3_SYM_RENAMED(void,HapticDestroyEffect,DestroyHapticEffect,(SDL_Haptic *a, int b),(a,b),)
SDL3_SYM(bool,HapticEffectSupported,(SDL_Haptic *a, const SDL_HapticEffect *b),(a,b),return)
SDL3_SYM(bool,GetHapticEffectStatus,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,HapticNumAxes,GetNumHapticAxes,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticNumEffects,GetMaxHapticEffects,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(int,HapticNumEffectsPlaying,GetMaxHapticEffectsPlaying,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED(SDL_Haptic*,HapticOpenFromJoystick,OpenHapticFromJoystick,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_Haptic*,HapticOpenFromMouse,OpenHapticFromMouse,(void),(),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticPause,PauseHaptic,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticRumbleInit,InitHapticRumble,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticRumblePlay,PlayHapticRumble,(SDL_Haptic *a, float b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticRumbleStop,StopHapticRumble,(SDL_Haptic *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,HapticRumbleSupported,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticRunEffect,RunHapticEffect,(SDL_Haptic *a, int b, Uint32 c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticSetAutocenter,SetHapticAutocenter,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticSetGain,SetHapticGain,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticStopAll,StopHapticEffects,(SDL_Haptic *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticStopEffect,StopHapticEffect,(SDL_Haptic *a, int b),(a,b),return)
SDL3_SYM_RENAMED_RETCODE(bool,HapticUnpause,ResumeHaptic,(SDL_Haptic *a),(a),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasARMSIMD,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasAVX,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasAVX2,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasAVX512F,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasAltiVec,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasClipboardText,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasEvent,(Uint32 a),(a),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasEvents,(Uint32 a, Uint32 b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,HasIntersection,HasRectIntersection,(const SDL_Rect *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,HasIntersectionF,HasRectIntersectionFloat,(const SDL_FRect *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasLASX,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasLSX,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasMMX,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasNEON,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasPrimarySelectionText,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasSSE,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasSSE2,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasSSE3,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasSSE41,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasSSE42,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,HasScreenKeyboardSupport,(void),(),return)
SDL3_SYM_RENAMED_BOOL(bool,HasWindowSurface,WindowHasSurface,(SDL_Window *a),(a),return)
SDL3_SYM(bool,HideCursor,(void),(),return)
SDL3_SYM(bool,HideWindow,(SDL_Window *a),(a),return)
SDL3_SYM(SDL_IOStream*,IOFromConstMem,(const void *a, size_t b),(a,b),return)
SDL3_SYM(SDL_IOStream*,IOFromFile,(const char *a, const char *b),(a,b),return)
SDL3_SYM(SDL_IOStream*,IOFromMem,(void *a, size_t b),(a,b),return)
SDL3_SYM(bool,InitSubSystem,(Uint32 a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,IntersectFRect,GetRectIntersectionFloat,(const SDL_FRect *a, const SDL_FRect *b, SDL_FRect *c),(a,b,c),return)
SDL3_SYM_RENAMED_BOOL(bool,IntersectFRectAndLine,GetRectAndLineIntersectionFloat,(const SDL_FRect *a, float *b, float *c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM_RENAMED_BOOL(bool,IntersectRect,GetRectIntersection,(const SDL_Rect *a, const SDL_Rect *b, SDL_Rect *c),(a,b,c),return)
SDL3_SYM_RENAMED_BOOL(bool,IntersectRectAndLine,GetRectAndLineIntersection,(const SDL_Rect *a, int *b, int *c, int *d, int *e),(a,b,c,d,e),return)
SDL3_SYM(bool,IsGamepad,(SDL_JoystickID a),(a),return)
SDL3_SYM(bool,IsJoystickVirtual,(SDL_JoystickID a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,IsScreenKeyboardShown,ScreenKeyboardShown,(SDL_Window *a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,IsScreenSaverEnabled,ScreenSaverEnabled,(void),(),return)
SDL3_SYM(bool,IsTV,(void),(),return)
SDL3_SYM_PASSTHROUGH_BOOL(bool,IsTablet,(void),(),return)
SDL3_SYM_RENAMED(void,JoystickClose,CloseJoystick,(SDL_Joystick *a),(a),)
SDL3_SYM(bool,JoystickEventsEnabled,(void),(),return)
SDL3_SYM_RENAMED(SDL_Joystick*,JoystickFromPlayerIndex,GetJoystickFromPlayerIndex,(int a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,JoystickGetAttached,JoystickConnected,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Sint16,JoystickGetAxis,GetJoystickAxis,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED_BOOL(bool,JoystickGetAxisInitialState,GetJoystickAxisInitialState,(SDL_Joystick *a, int b, Sint16 *c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickGetBall,GetJoystickBall,(SDL_Joystick *a, int b, int *c, int *d),(a,b,c,d),return);
SDL3_SYM(bool,GetJoystickButton,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetFirmwareVersion,GetJoystickFirmwareVersion,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_GUID,JoystickGetGUID,GetJoystickGUID,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint8,JoystickGetHat,GetJoystickHat,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,JoystickGetPlayerIndex,GetJoystickPlayerIndex,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetProduct,GetJoystickProduct,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetProductVersion,GetJoystickProductVersion,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(const char*,JoystickGetSerial,GetJoystickSerial,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(SDL_JoystickType,JoystickGetType,GetJoystickType,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(Uint16,JoystickGetVendor,GetJoystickVendor,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickIsHaptic,IsJoystickHaptic,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(const char*,JoystickName,GetJoystickName,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumAxes,GetNumJoystickAxes,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumBalls,GetNumJoystickBalls,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumButtons,GetNumJoystickButtons,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(int,JoystickNumHats,GetNumJoystickHats,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED(const char*,JoystickPath,GetJoystickPath,(SDL_Joystick *a),(a),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickRumble,RumbleJoystick,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickRumbleTriggers,RumbleJoystickTriggers,(SDL_Joystick *a, Uint16 b, Uint16 c, Uint32 d),(a,b,c,d),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickSendEffect,SendJoystickEffect,(SDL_Joystick *a, const void *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickSetLED,SetJoystickLED,(SDL_Joystick *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickSetVirtualAxis,SetJoystickVirtualAxis,(SDL_Joystick *a, int b, Sint16 c),(a,b,c),return)
SDL3_SYM(bool,SetJoystickVirtualButton,(SDL_Joystick *a, int b, bool c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,JoystickSetVirtualHat,SetJoystickVirtualHat,(SDL_Joystick *a, int b, Uint8 c),(a,b,c),return)
SDL3_SYM_RENAMED(void,JoystickUpdate,UpdateJoysticks,(void),(),)
SDL3_SYM(SDL_Surface*,LoadBMP_IO,(SDL_IOStream *a, bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void*,LoadFile,(const char *a, size_t *b),(a,b),return)
SDL3_SYM(void*,LoadFile_IO,(SDL_IOStream *a, size_t *b, bool c),(a,b,c),return)
SDL3_SYM(SDL_FunctionPointer,LoadFunction,(SDL_SharedObject *a, const char *b),(a,b),return)
SDL3_SYM(SDL_SharedObject*,LoadObject,(const char *a),(a),return)
SDL3_SYM(bool,LoadWAV_IO,(SDL_IOStream *a, bool b, SDL_AudioSpec *c, Uint8 **d, Uint32 *e),(a,b,c,d,e),return)
SDL3_SYM(bool,LockAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(void,LockMutex,(SDL_Mutex *a),(a),)
SDL3_SYM(bool,LockSurface,(SDL_Surface *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,LockTexture,(SDL_Texture *a, const SDL_Rect *b, void **c, int *d),(a,b,c,d),return)
SDL3_SYM(bool,LockTextureToSurface,(SDL_Texture *a, const SDL_Rect *b, SDL_Surface **c),(a,b,c),return)
SDL3_SYM_RENAMED(void,LogGetOutputFunction,GetLogOutputFunction,(SDL_LogOutputFunction *a, void **b),(a,b),)
SDL3_SYM(SDL_LogPriority,GetLogPriority,(int a),(a),return)
SDL3_SYM(void,LogMessageV,(int a, SDL_LogPriority b, const char *c, va_list d),(a,b,c,d),)
SDL3_SYM_RENAMED(void,LogResetPriorities,ResetLogPriorities,(void),(),)
SDL3_SYM(void,SetLogPriorities,(SDL_LogPriority a),(a),)
SDL3_SYM_RENAMED(void,LogSetOutputFunction,SetLogOutputFunction,(SDL_LogOutputFunction a, void *b),(a,b),)
SDL3_SYM(void,SetLogPriority,(int a, SDL_LogPriority b),(a,b),)
SDL3_SYM(Uint32,MapRGB,(const SDL_PixelFormatDetails *a, const SDL_Palette *b, Uint8 c, Uint8 d, Uint8 e),(a,b,c,d,e),return)
SDL3_SYM(Uint32,MapRGBA,(const SDL_PixelFormatDetails *a, const SDL_Palette *b, Uint8 c, Uint8 d, Uint8 e, Uint8 f),(a,b,c,d,e,f),return)
SDL3_SYM(bool,MaximizeWindow,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,MemoryBarrierAcquireFunction,(void),(),)
SDL3_SYM_PASSTHROUGH(void,MemoryBarrierReleaseFunction,(void),(),)
SDL3_SYM_PASSTHROUGH(SDL_MetalView,Metal_CreateView,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,Metal_DestroyView,(SDL_MetalView a),(a),)
SDL3_SYM_PASSTHROUGH(void*,Metal_GetLayer,(SDL_MetalView a),(a),return)
SDL3_SYM(bool,MinimizeWindow,(SDL_Window *a),(a),return)
SDL3_SYM(bool,MixAudio,(Uint8 *a, const Uint8 *b, SDL_AudioFormat c, Uint32 d, float e),(a,b,c,d,e),return)
SDL3_SYM_RENAMED_RETCODE(bool,MouseIsHaptic,IsMouseHaptic,(void),(),return)
SDL3_SYM_RENAMED(void,OnApplicationDidBecomeActive,OnApplicationDidEnterForeground,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidEnterBackground,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationDidReceiveMemoryWarning,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationWillEnterForeground,(void),(),)
SDL3_SYM_RENAMED(void,OnApplicationWillResignActive,OnApplicationWillEnterBackground,(void),(),)
SDL3_SYM_PASSTHROUGH(void,OnApplicationWillTerminate,(void),(),)
SDL3_SYM(SDL_AudioDeviceID,OpenAudioDevice,(SDL_AudioDeviceID a, const SDL_AudioSpec *b),(a,b),return)
SDL3_SYM(SDL_Gamepad *,OpenGamepad,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_Haptic*,OpenHaptic,(SDL_HapticID a),(a),return)
SDL3_SYM(SDL_IOStream*,OpenIO,(const SDL_IOStreamInterface *a, void *b),(a,b),return)
SDL3_SYM(SDL_Joystick *,OpenJoystick,(SDL_JoystickID a),(a),return)
SDL3_SYM(SDL_Sensor *,OpenSensor,(SDL_SensorID a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,OpenURL,(const char *a),(a),return)
SDL3_SYM(bool,OutOfMemory,(void),(),return)
SDL3_SYM(bool,PauseAudioDevice,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(int,PeepEvents,(SDL_Event *a, int b, SDL_EventAction c, Uint32 d, Uint32 e),(a,b,c,d,e),return)
SDL3_SYM(bool,PremultiplyAlpha,(int a, int b, SDL_PixelFormat c, const void *d, int e, SDL_PixelFormat f, void *g, int h, bool i),(a,b,c,d,e,f,g,h,i),return)
SDL3_SYM_PASSTHROUGH(void,PumpEvents,(void),(),)
SDL3_SYM(bool,PushEvent,(SDL_Event *a),(a),return)
SDL3_SYM(bool,PutAudioStreamData,(SDL_AudioStream *a, const void *b, int c),(a,b,c),return)
SDL3_SYM(void,Quit,(void),(),)
SDL3_SYM(void,QuitSubSystem,(Uint32 a),(a),)
SDL3_SYM(bool,RaiseWindow,(SDL_Window *a),(a),return)
SDL3_SYM(size_t,ReadIO,(SDL_IOStream *a, void *b, size_t c),(a,b,c),return)
SDL3_SYM(Uint32,RegisterEvents,(int a),(a),return)
SDL3_SYM(bool,RemoveTimer,(SDL_TimerID a),(a),return)
SDL3_SYM(bool,RenderClear,(SDL_Renderer *a),(a),return)
SDL3_SYM(bool,RenderCoordinatesFromWindow,(SDL_Renderer *a, float b, float c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM(bool,RenderCoordinatesToWindow,(SDL_Renderer *a, float b, float c, float *d, float *e),(a,b,c,d,e),return)
SDL3_SYM(bool,RenderFillRect,(SDL_Renderer *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM(bool,RenderFillRects,(SDL_Renderer *a, const SDL_FRect *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,RenderFlush,FlushRenderer,(SDL_Renderer *a),(a),return)
SDL3_SYM(bool,RenderGeometryRaw,(SDL_Renderer *a, SDL_Texture *b, const float *c, int d, const SDL_FColor *e, int f, const float *g, int h, int i, const void *j, int k, int l),(a,b,c,d,e,f,g,h,i,j,k,l),return)
SDL3_SYM_RENAMED(void*,RenderGetMetalCommandEncoder,GetRenderMetalCommandEncoder,(SDL_Renderer *a),(a),return)
SDL3_SYM_RENAMED(void*,RenderGetMetalLayer,GetRenderMetalLayer,(SDL_Renderer *a),(a),return)
SDL3_SYM_RENAMED(SDL_Window*,RenderGetWindow,GetRenderWindow,(SDL_Renderer *a),(a),return)
SDL3_SYM_RENAMED_BOOL(bool,RenderIsClipEnabled,RenderClipEnabled,(SDL_Renderer *a),(a),return)
SDL3_SYM(bool,RenderLines,(SDL_Renderer *a, const SDL_FPoint *b, int c),(a,b,c),return)
SDL3_SYM(bool,RenderPoints,(SDL_Renderer *a, const SDL_FPoint *b, int c),(a,b,c),return)
SDL3_SYM(bool,RenderPresent,(SDL_Renderer *a),(a),return)
SDL3_SYM(SDL_Surface *,RenderReadPixels,(SDL_Renderer *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM(bool,RenderRect,(SDL_Renderer *a, const SDL_FRect *b),(a,b),return)
SDL3_SYM(bool,RenderRects,(SDL_Renderer *a, const SDL_FRect *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,RenderSetScale,SetRenderScale,(SDL_Renderer *a, float b, float c),(a,b,c),return)
SDL3_SYM_RENAMED_RETCODE(bool,RenderSetVSync,SetRenderVSync,(SDL_Renderer *a, int b),(a,b),return)
SDL3_SYM(bool,RenderTexture,(SDL_Renderer *a, SDL_Texture *b, const SDL_FRect *c, const SDL_FRect *d),(a,b,c,d),return)
SDL3_SYM(bool,RenderTextureRotated,(SDL_Renderer *a, SDL_Texture *b, const SDL_FRect *c, const SDL_FRect *d, double e, const SDL_FPoint *f, SDL_FlipMode g),(a,b,c,d,e,f,g),return)
SDL3_SYM_PASSTHROUGH(SDL_AssertState,ReportAssertion,(SDL_AssertData *a, const char *b, const char *c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(void,ResetAssertionReport,(void),(),)
SDL3_SYM(bool,ResetHint,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,ResetHints,(void),(),)
SDL3_SYM_PASSTHROUGH(void,ResetKeyboard,(void),(),)
SDL3_SYM(bool,RestoreWindow,(SDL_Window *a),(a),return)
SDL3_SYM(bool,ResumeAudioDevice,(SDL_AudioDeviceID a),(a),return)
SDL3_SYM(int,RunApp,(int a, char **b, SDL_main_func c, void *d),(a,b,c,d),return)
SDL3_SYM_RENAMED(size_t,SIMDGetAlignment,GetSIMDAlignment,(void),(),return)
SDL3_SYM(bool,SaveBMP_IO,(SDL_Surface *a, SDL_IOStream *b, bool c),(a,b,c),return)
SDL3_SYM(Sint64,SeekIO,(SDL_IOStream *a, Sint64 b, SDL_IOWhence c),(a,b,c),return)
SDL3_SYM_RENAMED(Uint32,SemValue,GetSemaphoreValue,(SDL_Semaphore *a),(a),return)
SDL3_SYM_RENAMED(void,SensorClose,CloseSensor,(SDL_Sensor *a),(a),)
SDL3_SYM_RENAMED_RETCODE(bool,SensorGetData,GetSensorData,(SDL_Sensor *a, float *b, int c),(a,b,c),return)
SDL3_SYM_RENAMED(const char*,SensorGetName,GetSensorName,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(int,SensorGetNonPortableType,GetSensorNonPortableType,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(SDL_SensorType,SensorGetType,GetSensorType,(SDL_Sensor *a),(a),return)
SDL3_SYM_RENAMED(void,SensorUpdate,UpdateSensors,(void),(),)
SDL3_SYM_PASSTHROUGH(void,SetAssertionHandler,(SDL_AssertionHandler a, void *b),(a,b),)
SDL3_SYM(bool,SetAudioStreamGetCallback,(SDL_AudioStream *a, SDL_AudioStreamCallback b, void *c),(a,b,c),return)
SDL3_SYM(bool,SetAudioStreamPutCallback,(SDL_AudioStream *a, SDL_AudioStreamCallback b, void *c),(a,b,c),return)
SDL3_SYM(bool,SetBooleanProperty,(SDL_PropertiesID a, const char *b, bool c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetClipboardText,(const char *a),(a),return)
SDL3_SYM(bool,SetCursor,(SDL_Cursor *a),(a),return)
SDL3_SYM(void,SetEventEnabled,(Uint32 a, bool b),(a,b),)
SDL3_SYM(void,SetEventFilter,(SDL_EventFilter a, void *b),(a,b),)
SDL3_SYM(void,SetGamepadEventsEnabled,(bool a),(a),)
SDL3_SYM(bool,SetGamepadPlayerIndex,(SDL_GameController *a, int b),(a,b),return)
SDL3_SYM(bool,SetHint,(const char *a, const char *b),(a,b),return)
SDL3_SYM(bool,SetHintWithPriority,(const char *a, const char *b, SDL_HintPriority c),(a,b,c),return)
SDL3_SYM(void,SetJoystickEventsEnabled,(bool a),(a),)
SDL3_SYM(bool,SetJoystickPlayerIndex,(SDL_Joystick *a, int b),(a,b),return)
SDL3_SYM(bool,SetLogPriorityPrefix,(SDL_LogPriority a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,SetMainReady,(void),(),)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetMemoryFunctions,(SDL_malloc_func a, SDL_calloc_func b, SDL_realloc_func c, SDL_free_func d),(a,b,c,d),return)
SDL3_SYM(void,SetModState,(SDL_Keymod a),(a),)
SDL3_SYM(bool,SetNumberProperty,(SDL_PropertiesID a, const char *b, Sint64 c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetPaletteColors,(SDL_Palette *a, const SDL_Color *b, int c, int d),(a,b,c,d),return)
SDL3_SYM(bool,SetPointerProperty,(SDL_PropertiesID a, const char *b, void *c),(a,b,c),return)
SDL3_SYM(bool,SetPointerPropertyWithCleanup,(SDL_PropertiesID a, const char *b, void *c, SDL_CleanupPropertyCallback d, void *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetPrimarySelectionText,(const char *a),(a),return)
SDL3_SYM(bool,SetRenderClipRect,(SDL_Renderer *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetRenderDrawBlendMode,(SDL_Renderer *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetRenderDrawColor,(SDL_Renderer *a, Uint8 b, Uint8 c, Uint8 d, Uint8 e),(a,b,c,d,e),return)
SDL3_SYM(bool,SetRenderLogicalPresentation,(SDL_Renderer *a, int b, int c, SDL_RendererLogicalPresentation d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetRenderTarget,(SDL_Renderer *a, SDL_Texture *b),(a,b),return)
SDL3_SYM(bool,SetRenderViewport,(SDL_Renderer *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM(bool,SetStringProperty,(SDL_PropertiesID a, const char *b, const char *c),(a,b,c),return)
SDL3_SYM(bool,SetSurfaceAlphaMod,(SDL_Surface *a, Uint8 b),(a,b),return)
SDL3_SYM(bool,SetSurfaceBlendMode,(SDL_Surface *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM(bool,SetSurfaceClipRect,(SDL_Surface *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM(bool,SetSurfaceColorKey,(SDL_Surface *a, bool b, Uint32 c),(a,b,c),return)
SDL3_SYM(bool,SetSurfaceColorMod,(SDL_Surface *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM(bool,SetSurfacePalette,(SDL_Surface *a, SDL_Palette *b),(a,b),return)
SDL3_SYM(bool,SetSurfaceRLE,(SDL_Surface *a, bool b),(a,b),return)
SDL3_SYM(bool,SetTLS,(SDL_TLSID *a, const void *b, SDL_TLSDestructorCallback c),(a,b,c),return)
SDL3_SYM(bool,SetTextInputArea,(SDL_Window *a, const SDL_Rect *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetTextureAlphaMod,(SDL_Texture *a, Uint8 b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetTextureBlendMode,(SDL_Texture *a, SDL_BlendMode b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetTextureColorMod,(SDL_Texture *a, Uint8 b, Uint8 c, Uint8 d),(a,b,c,d),return)
SDL3_SYM(bool,SetTextureScaleMode,(SDL_Texture *a, SDL_ScaleMode b),(a,b),return)
SDL3_SYM_RENAMED_RETCODE(bool,SetThreadPriority,SetCurrentThreadPriority,(SDL_ThreadPriority a),(a),return)
SDL3_SYM(bool,SetWindowAlwaysOnTop,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowBordered,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowFullscreen,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowFullscreenMode,(SDL_Window *a, const SDL_DisplayMode *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetWindowHitTest,(SDL_Window *a, SDL_HitTest b, void *c),(a,b,c),return)
SDL3_SYM(bool,SetWindowIcon,(SDL_Window *a, SDL_Surface *b),(a,b),return)
SDL3_SYM(bool,SetWindowKeyboardGrab,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowMaximumSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(bool,SetWindowMinimumSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(bool,SetWindowModal,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowMouseGrab,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetWindowMouseRect,(SDL_Window *a, const SDL_Rect *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,SetWindowOpacity,(SDL_Window *a, float b),(a,b),return)
SDL3_SYM(bool,SetWindowParent,(SDL_Window *a, SDL_Window *b),(a,b),return)
SDL3_SYM(bool,SetWindowPosition,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(bool,SetWindowRelativeMouseMode,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowResizable,(SDL_Window *a, bool b),(a,b),return)
SDL3_SYM(bool,SetWindowShape,(SDL_Window *a, SDL_Surface *b),(a,b),return)
SDL3_SYM(bool,SetWindowSize,(SDL_Window *a, int b, int c),(a,b,c),return)
SDL3_SYM(bool,SetWindowTitle,(SDL_Window *a, const char *b),(a,b),return)
SDL3_SYM(bool,ShowCursor,(void),(),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,ShowMessageBox,(const SDL_MessageBoxData *a, int *b),(a,b),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,ShowSimpleMessageBox,(Uint32 a, const char *b, const char *c, SDL_Window *d),(a,b,c,d),return)
SDL3_SYM(bool,ShowWindow,(SDL_Window *a),(a),return)
SDL3_SYM(void,SignalCondition,(SDL_Condition *a),(a),return)
SDL3_SYM(void,SignalSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM(bool,StartTextInputWithProperties,(SDL_Window *a, SDL_PropertiesID b),(a,b),return)
SDL3_SYM(bool,StopTextInput,(SDL_Window *a),(a),return)
SDL3_SYM(bool,SurfaceHasColorKey,(SDL_Surface *a),(a),return)
SDL3_SYM(bool,SurfaceHasRLE,(SDL_Surface *a),(a),return)
SDL3_SYM_RENAMED(void,TLSCleanup,CleanupTLS,(void),(),)
SDL3_SYM(Sint64,TellIO,(SDL_IOStream *a),(a),return)
SDL3_SYM(bool,TextInputActive,(SDL_Window *a),(a),return)
SDL3_SYM(bool,TryLockMutex,(SDL_Mutex *a),(a),return)
SDL3_SYM(bool,TryWaitSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM(void,UnloadObject,(SDL_SharedObject *a),(a),)
SDL3_SYM(bool,UnlockAudioStream,(SDL_AudioStream *a),(a),return)
SDL3_SYM(void,UnlockMutex,(SDL_Mutex *a),(a),)
SDL3_SYM(void,UnlockSurface,(SDL_Surface *a),(a),)
SDL3_SYM_PASSTHROUGH(void,UnlockTexture,(SDL_Texture *a),(a),)
SDL3_SYM(bool,UpdateHapticEffect,(SDL_Haptic *a, int b, const SDL_HapticEffect *c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,UpdateNVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f),(a,b,c,d,e,f),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,UpdateTexture,(SDL_Texture *a, const SDL_Rect *b, const void *c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,UpdateWindowSurface,(SDL_Window *a),(a),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,UpdateWindowSurfaceRects,(SDL_Window *a, const SDL_Rect *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,UpdateYUVTexture,(SDL_Texture *a, const SDL_Rect *b, const Uint8 *c, int d, const Uint8 *e, int f, const Uint8 *g, int h),(a,b,c,d,e,f,g,h),return)
SDL3_SYM(bool,Vulkan_CreateSurface,(SDL_Window *a, VkInstance b, const struct VkAllocationCallbacks *c, VkSurfaceKHR *d),(a,b,c,d),return)
SDL3_SYM(char const* const* ,Vulkan_GetInstanceExtensions,(Uint32 *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,Vulkan_GetVkGetInstanceProcAddr,(void),(),return)
SDL3_SYM_PASSTHROUGH_RETCODE(bool,Vulkan_LoadLibrary,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void,Vulkan_UnloadLibrary,(void),(),)
SDL3_SYM(void,WaitCondition,(SDL_Condition *a, SDL_Mutex *b),(a,b),return)
SDL3_SYM(bool,WaitConditionTimeout,(SDL_Condition *a, SDL_Mutex *b, Sint32 c),(a,b,c),return)
SDL3_SYM(bool,WaitEventTimeout,(SDL_Event *a, Sint32 b),(a,b),return)
SDL3_SYM(void,WaitSemaphore,(SDL_Semaphore *a),(a),return)
SDL3_SYM(bool,WaitSemaphoreTimeout,(SDL_Semaphore *a, Sint32 b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,WaitThread,(SDL_Thread *a, int *b),(a,b),)
SDL3_SYM(bool,WarpMouseGlobal,(float a, float b),(a,b),return)
SDL3_SYM(void,WarpMouseInWindow,(SDL_Window *a, float b, float c),(a,b,c),)
SDL3_SYM_PASSTHROUGH(Uint32,WasInit,(Uint32 a),(a),return)
SDL3_SYM(size_t,WriteIO,(SDL_IOStream *a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,abs,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(double,acos,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,acosf,(float a),(a),return)
SDL3_SYM(void*,aligned_alloc,(size_t a, size_t b),(a,b),return)
SDL3_SYM(void,aligned_free,(void *a),(a),)
SDL3_SYM_PASSTHROUGH(double,asin,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,asinf,(float a),(a),return)
SDL3_SYM_VARARGS(int,asprintf,(char **a, SDL_PRINTF_FORMAT_STRING const char *b, ...))
SDL3_SYM_PASSTHROUGH(double,atan,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,atan2,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,atan2f,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,atanf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,atof,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,atoi,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(void*,bsearch,(const void *a, const void *b, size_t c, size_t d, SDL_CompareCallback e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(void*,calloc,(size_t a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,ceil,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,ceilf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,copysign,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,copysignf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,cos,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,cosf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(Uint16,crc16,(Uint16 a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(Uint32,crc32,(Uint32 a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(double,exp,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,expf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,fabs,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,fabsf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,floor,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,floorf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,fmod,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,fmodf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,free,(void *a),(a),)
SDL3_SYM_PASSTHROUGH(const char*,getenv,(const char *a),(a),return)
SDL3_SYM(void,hid_ble_scan,(bool a),(a),)
SDL3_SYM(int,hid_close,(SDL_hid_device *a),(a),return)
SDL3_SYM_PASSTHROUGH(Uint32,hid_device_change_count,(void),(),return)
SDL3_SYM(SDL_hid_device_info*,hid_enumerate,(unsigned short a, unsigned short b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,hid_exit,(void),(),return)
SDL3_SYM(void,hid_free_enumeration,(SDL_hid_device_info *a),(a),)
SDL3_SYM_PASSTHROUGH(int,hid_get_feature_report,(SDL_hid_device *a, unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_indexed_string,(SDL_hid_device *a, int b, wchar_t *c, size_t d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_manufacturer_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_product_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_get_serial_number_string,(SDL_hid_device *a, wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_init,(void),(),return)
SDL3_SYM_PASSTHROUGH(SDL_hid_device*,hid_open,(unsigned short a, unsigned short b, const wchar_t *c),(a,b,c),return)
SDL3_SYM(SDL_hid_device*,hid_open_path,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,hid_read,(SDL_hid_device *a, unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_read_timeout,(SDL_hid_device *a, unsigned char *b, size_t c, int d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,hid_send_feature_report,(SDL_hid_device *a, const unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,hid_set_nonblocking,(SDL_hid_device *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,hid_write,(SDL_hid_device *a, const unsigned char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,iconv,(SDL_iconv_t a, const char **b, size_t *c, char **d, size_t *e),(a,b,c,d,e),return)
SDL3_SYM_PASSTHROUGH(int,iconv_close,(SDL_iconv_t a),(a),return)
SDL3_SYM_PASSTHROUGH(SDL_iconv_t,iconv_open,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,iconv_string,(const char *a, const char *b, const char *c, size_t d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,isalnum,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isalpha,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isblank,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,iscntrl,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isdigit,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isgraph,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,islower,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isprint,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,ispunct,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isspace,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isupper,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,isxdigit,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,itoa,(int a, char *b, int c),(a,b,c),return)
SDL3_SYM(char*,lltoa,(long long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(double,log,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(double,log10,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,log10f,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(float,logf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(long,lround,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(long,lroundf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,ltoa,(long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,malloc,(size_t a),(a),return)
SDL3_SYM_PASSTHROUGH(int,memcmp,(const void *a, const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,memcpy,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,memmove,(SDL_OUT_BYTECAP(c) void *a, SDL_IN_BYTECAP(c) const void *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(void*,memset,(SDL_OUT_BYTECAP(c) void *a, int b, size_t c),(a,b,c),return)
SDL3_SYM(double,modf,(double a, double *b),(a,b),return)
SDL3_SYM(float,modff,(float a, float *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,pow,(double a, double b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,powf,(float a, float b),(a,b),return)
SDL3_SYM_PASSTHROUGH(void,qsort,(void *a, size_t b, size_t c, SDL_CompareCallback d),(a,b,c,d),)
SDL3_SYM_PASSTHROUGH(void*,realloc,(void *a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,round,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,roundf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,scalbn,(double a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(float,scalbnf,(float a, int b),(a,b),return)
SDL3_SYM_RENAMED(int,setenv,setenv_unsafe,(const char *a, const char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(double,sin,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,sinf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(double,sqrt,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,sqrtf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(int,strcasecmp,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strcasestr,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strchr,(const char *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,strcmp,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strdup,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,strlcat,(SDL_INOUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,strlen,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strlwr,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,strncasecmp,(const char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,strncmp,(const char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,strrchr,(const char *a, int b),(a,b),return)
SDL3_SYM_PASSTHROUGH(char*,strrev,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,strstr,(const char *a, const char *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(double,strtod,(const char *a, char **b),(a,b),return)
SDL3_SYM_RENAMED(char*,strtokr,strtok_r,(char *a, const char *b, char **c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(long,strtol,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM(long long,strtoll,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(unsigned long,strtoul,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM(unsigned long long,strtoull,(const char *a, char **b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,strupr,(char *a),(a),return)
SDL3_SYM_PASSTHROUGH(double,tan,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,tanf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(int,tolower,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(int,toupper,(int a),(a),return)
SDL3_SYM_PASSTHROUGH(double,trunc,(double a),(a),return)
SDL3_SYM_PASSTHROUGH(float,truncf,(float a),(a),return)
SDL3_SYM_PASSTHROUGH(char*,uitoa,(unsigned int a, char *b, int c),(a,b,c),return)
SDL3_SYM(char*,ulltoa,(unsigned long long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(char*,ultoa,(unsigned long a, char *b, int c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,utf8strlcpy,(SDL_OUT_Z_CAP(c) char *a, const char *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,utf8strlen,(const char *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,utf8strnlen,(const char *a, size_t b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,vasprintf,(char **a, const char *b, va_list c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,vsnprintf,(SDL_OUT_Z_CAP(b) char *a, size_t b, const char *c, va_list d),(a,b,c,d),return)
SDL3_SYM_PASSTHROUGH(int,vsscanf,(const char *a, const char *b, va_list c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,wcscasecmp,(const wchar_t *a, const wchar_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(int,wcscmp,(const wchar_t *a, const wchar_t *b),(a,b),return)
SDL3_SYM_PASSTHROUGH(wchar_t*,wcsdup,(const wchar_t *a),(a),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslcat,(SDL_INOUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslcpy,(SDL_OUT_Z_CAP(c) wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(size_t,wcslen,(const wchar_t *a),(a),return)
SDL3_SYM_PASSTHROUGH(int,wcsncasecmp,(const wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(int,wcsncmp,(const wchar_t *a, const wchar_t *b, size_t c),(a,b,c),return)
SDL3_SYM_PASSTHROUGH(wchar_t*,wcsstr,(const wchar_t *a, const wchar_t *b),(a,b),return)

#undef SDL3_SYM
#undef SDL3_SYM_PASSTHROUGH
#undef SDL3_SYM_PASSTHROUGH_BOOL
#undef SDL3_SYM_PASSTHROUGH_RETCODE
#undef SDL3_SYM_RENAMED
#undef SDL3_SYM_RENAMED_BOOL
#undef SDL3_SYM_RENAMED_RETCODE
#undef SDL3_SYM_VARARGS
