#![allow(
    dead_code,
    non_upper_case_globals,
    unused_assignments,
    unused_parens,
    while_true,
    clippy::assign_op_pattern,
    clippy::comparison_chain,
    clippy::double_parens,
    clippy::unnecessary_cast,
    clippy::single_match,
    clippy::never_loop
)]

use super::buffer::{hb_buffer_t, HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE};

static _indic_syllable_machine_trans_keys: [u8; 278] = [
    7, 7, 3, 12, 4, 12, 4, 12, 12, 12, 3, 12, 3, 12, 3, 12, 7, 7, 4, 12, 4, 12, 12, 12, 3, 12, 3,
    12, 3, 12, 3, 12, 7, 7, 4, 12, 4, 12, 12, 12, 3, 12, 3, 12, 3, 12, 7, 7, 4, 12, 4, 12, 12, 12,
    3, 12, 3, 12, 4, 12, 7, 7, 0, 17, 2, 15, 2, 15, 3, 15, 0, 14, 4, 8, 4, 8, 8, 8, 4, 8, 0, 14, 0,
    14, 0, 14, 2, 12, 3, 12, 4, 12, 4, 12, 3, 12, 4, 8, 2, 8, 4, 8, 2, 15, 2, 15, 2, 15, 2, 15, 3,
    15, 0, 14, 2, 15, 2, 15, 3, 15, 0, 14, 4, 8, 8, 8, 4, 8, 0, 14, 0, 14, 2, 12, 3, 12, 4, 12, 4,
    12, 3, 12, 4, 8, 4, 8, 2, 8, 4, 8, 2, 15, 2, 15, 3, 12, 2, 15, 2, 15, 3, 15, 0, 14, 2, 15, 0,
    14, 4, 8, 8, 8, 4, 8, 0, 14, 0, 14, 2, 12, 3, 12, 4, 12, 4, 12, 2, 15, 3, 12, 4, 8, 4, 8, 2, 8,
    4, 8, 2, 15, 3, 12, 3, 12, 2, 15, 2, 15, 3, 15, 0, 14, 2, 15, 0, 14, 4, 8, 8, 8, 4, 8, 0, 14,
    0, 14, 2, 12, 3, 12, 4, 12, 4, 12, 2, 15, 3, 12, 4, 8, 4, 8, 2, 8, 4, 8, 0, 15, 2, 15, 0, 15,
    3, 12, 4, 12, 4, 12, 8, 8, 4, 8, 0, 14, 2, 8, 4, 8, 4, 8, 8, 8, 4, 8, 0, 14, 0, 0,
];
static _indic_syllable_machine_char_class: [i8; 20] = [
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 0,
];
static _indic_syllable_machine_index_offsets: [i16; 140] = [
    0, 1, 11, 20, 29, 30, 40, 50, 60, 61, 70, 79, 80, 90, 100, 110, 120, 121, 130, 139, 140, 150,
    160, 170, 171, 180, 189, 190, 200, 210, 219, 220, 238, 252, 266, 279, 294, 299, 304, 305, 310,
    325, 340, 355, 366, 376, 385, 394, 404, 409, 416, 421, 435, 449, 463, 477, 490, 505, 519, 533,
    546, 561, 566, 567, 572, 587, 602, 613, 623, 632, 641, 651, 656, 661, 668, 673, 687, 701, 711,
    725, 739, 752, 767, 781, 796, 801, 802, 807, 822, 837, 848, 858, 867, 876, 890, 900, 905, 910,
    917, 922, 936, 946, 956, 970, 984, 997, 1012, 1026, 1041, 1046, 1047, 1052, 1067, 1082, 1093,
    1103, 1112, 1121, 1135, 1145, 1150, 1155, 1162, 1167, 1183, 1197, 1213, 1223, 1232, 1241, 1242,
    1247, 1262, 1269, 1274, 1279, 1280, 1285, 0, 0,
];
static _indic_syllable_machine_indices: [i16; 1302] = [
    1, 2, 3, 3, 4, 5, 0, 0, 0, 0, 4, 3, 3, 4, 6, 0, 0, 0, 0, 4, 3, 3, 4, 5, 0, 0, 0, 0, 4, 4, 7, 3,
    3, 4, 5, 0, 0, 0, 0, 4, 2, 3, 3, 4, 5, 0, 0, 0, 8, 4, 10, 11, 11, 12, 13, 9, 9, 9, 9, 12, 14,
    11, 11, 12, 15, 9, 9, 9, 9, 12, 11, 11, 12, 13, 9, 9, 9, 9, 12, 12, 16, 11, 11, 12, 13, 9, 9,
    9, 9, 12, 10, 11, 11, 12, 13, 9, 9, 9, 17, 12, 10, 11, 11, 12, 13, 9, 9, 9, 18, 12, 20, 21, 21,
    22, 23, 19, 19, 19, 24, 22, 25, 21, 21, 22, 27, 26, 26, 26, 26, 22, 21, 21, 22, 23, 19, 19, 19,
    19, 22, 22, 20, 21, 21, 22, 23, 19, 19, 19, 19, 22, 28, 21, 21, 22, 23, 19, 19, 19, 19, 22, 30,
    31, 31, 32, 33, 29, 29, 29, 34, 32, 35, 31, 31, 32, 36, 29, 29, 29, 29, 32, 31, 31, 32, 33, 29,
    29, 29, 29, 32, 32, 30, 31, 31, 32, 33, 29, 29, 29, 29, 32, 37, 31, 31, 32, 33, 29, 29, 29, 29,
    32, 21, 21, 22, 38, 0, 0, 0, 0, 22, 40, 43, 44, 45, 46, 47, 48, 22, 23, 49, 50, 50, 24, 22, 51,
    52, 53, 54, 55, 57, 58, 59, 60, 4, 5, 61, 56, 56, 8, 4, 56, 56, 62, 63, 58, 64, 64, 4, 5, 61,
    56, 56, 56, 4, 56, 56, 62, 58, 64, 64, 4, 5, 61, 56, 56, 56, 4, 56, 56, 62, 43, 56, 56, 56, 65,
    66, 56, 1, 61, 56, 56, 56, 56, 56, 43, 67, 67, 56, 1, 61, 61, 56, 56, 68, 61, 61, 61, 56, 56,
    56, 61, 43, 56, 69, 56, 67, 67, 56, 1, 61, 56, 56, 56, 56, 56, 43, 43, 56, 56, 56, 67, 67, 56,
    1, 61, 56, 56, 56, 56, 56, 43, 43, 56, 56, 56, 67, 66, 56, 1, 61, 56, 56, 56, 56, 56, 43, 70,
    71, 72, 72, 4, 5, 61, 56, 56, 56, 4, 71, 72, 72, 4, 5, 61, 56, 56, 56, 4, 72, 72, 4, 5, 61, 56,
    56, 56, 4, 61, 56, 56, 68, 61, 56, 56, 56, 4, 73, 74, 74, 4, 5, 61, 56, 56, 56, 4, 65, 75, 56,
    1, 61, 65, 56, 67, 67, 56, 1, 61, 67, 75, 56, 1, 61, 57, 58, 64, 64, 4, 5, 61, 56, 56, 56, 4,
    56, 56, 62, 57, 58, 59, 64, 4, 5, 61, 56, 56, 8, 4, 56, 56, 62, 77, 78, 79, 80, 12, 13, 81, 76,
    76, 18, 12, 76, 76, 82, 83, 78, 84, 80, 12, 13, 81, 76, 76, 76, 12, 76, 76, 82, 78, 84, 80, 12,
    13, 81, 76, 76, 76, 12, 76, 76, 82, 85, 76, 76, 76, 86, 87, 76, 14, 81, 76, 76, 76, 76, 76, 85,
    88, 78, 89, 90, 12, 13, 81, 76, 76, 17, 12, 76, 76, 82, 91, 78, 84, 84, 12, 13, 81, 76, 76, 76,
    12, 76, 76, 82, 78, 84, 84, 12, 13, 81, 76, 76, 76, 12, 76, 76, 82, 85, 76, 76, 76, 92, 87, 76,
    14, 81, 76, 76, 76, 76, 76, 85, 81, 76, 76, 93, 81, 81, 81, 76, 76, 76, 81, 85, 76, 94, 76, 92,
    92, 76, 14, 81, 76, 76, 76, 76, 76, 85, 85, 76, 76, 76, 92, 92, 76, 14, 81, 76, 76, 76, 76, 76,
    85, 95, 96, 97, 97, 12, 13, 81, 76, 76, 76, 12, 96, 97, 97, 12, 13, 81, 76, 76, 76, 12, 97, 97,
    12, 13, 81, 76, 76, 76, 12, 81, 76, 76, 93, 81, 76, 76, 76, 12, 98, 99, 99, 12, 13, 81, 76, 76,
    76, 12, 86, 100, 76, 14, 81, 92, 92, 76, 14, 81, 86, 76, 92, 92, 76, 14, 81, 92, 100, 76, 14,
    81, 88, 78, 84, 84, 12, 13, 81, 76, 76, 76, 12, 76, 76, 82, 88, 78, 89, 84, 12, 13, 81, 76, 76,
    17, 12, 76, 76, 82, 10, 11, 11, 12, 13, 76, 76, 76, 76, 12, 77, 78, 84, 80, 12, 13, 81, 76, 76,
    76, 12, 76, 76, 82, 102, 46, 103, 103, 22, 23, 49, 101, 101, 101, 22, 101, 101, 53, 46, 103,
    103, 22, 23, 49, 101, 101, 101, 22, 101, 101, 53, 104, 101, 101, 101, 105, 106, 101, 25, 49,
    101, 101, 101, 101, 101, 104, 45, 46, 107, 108, 22, 23, 49, 101, 101, 24, 22, 101, 101, 53,
    104, 101, 101, 101, 109, 106, 101, 25, 49, 101, 101, 101, 101, 101, 104, 49, 101, 101, 110, 49,
    49, 49, 101, 101, 101, 49, 104, 101, 111, 101, 109, 109, 101, 25, 49, 101, 101, 101, 101, 101,
    104, 104, 101, 101, 101, 109, 109, 101, 25, 49, 101, 101, 101, 101, 101, 104, 112, 113, 114,
    114, 22, 23, 49, 101, 101, 101, 22, 113, 114, 114, 22, 23, 49, 101, 101, 101, 22, 114, 114, 22,
    23, 49, 101, 101, 101, 22, 49, 101, 101, 110, 49, 101, 101, 101, 22, 45, 46, 103, 103, 22, 23,
    49, 101, 101, 101, 22, 101, 101, 53, 115, 116, 116, 22, 23, 49, 101, 101, 101, 22, 105, 117,
    101, 25, 49, 109, 109, 101, 25, 49, 105, 101, 109, 109, 101, 25, 49, 109, 117, 101, 25, 49, 45,
    46, 107, 103, 22, 23, 49, 101, 101, 24, 22, 101, 101, 53, 20, 21, 21, 22, 23, 118, 118, 118,
    24, 22, 20, 21, 21, 22, 23, 118, 118, 118, 118, 22, 120, 121, 122, 123, 32, 33, 124, 119, 119,
    34, 32, 119, 119, 125, 126, 121, 123, 123, 32, 33, 124, 119, 119, 119, 32, 119, 119, 125, 121,
    123, 123, 32, 33, 124, 119, 119, 119, 32, 119, 119, 125, 127, 119, 119, 119, 128, 129, 119, 35,
    124, 119, 119, 119, 119, 119, 127, 120, 121, 122, 50, 32, 33, 124, 119, 119, 34, 32, 119, 119,
    125, 127, 119, 119, 119, 130, 129, 119, 35, 124, 119, 119, 119, 119, 119, 127, 124, 119, 119,
    131, 124, 124, 124, 119, 119, 119, 124, 127, 119, 132, 119, 130, 130, 119, 35, 124, 119, 119,
    119, 119, 119, 127, 127, 119, 119, 119, 130, 130, 119, 35, 124, 119, 119, 119, 119, 119, 127,
    133, 134, 135, 135, 32, 33, 124, 119, 119, 119, 32, 134, 135, 135, 32, 33, 124, 119, 119, 119,
    32, 135, 135, 32, 33, 124, 119, 119, 119, 32, 124, 119, 119, 131, 124, 119, 119, 119, 32, 120,
    121, 123, 123, 32, 33, 124, 119, 119, 119, 32, 119, 119, 125, 136, 137, 137, 32, 33, 124, 119,
    119, 119, 32, 128, 138, 119, 35, 124, 130, 130, 119, 35, 124, 128, 119, 130, 130, 119, 35, 124,
    130, 138, 119, 35, 124, 43, 44, 45, 46, 107, 103, 22, 23, 49, 50, 50, 24, 22, 101, 43, 53, 57,
    139, 59, 60, 4, 5, 61, 56, 56, 8, 4, 56, 56, 62, 43, 44, 45, 46, 140, 141, 22, 142, 143, 56,
    50, 24, 22, 56, 43, 53, 20, 144, 144, 22, 142, 61, 56, 56, 24, 22, 61, 56, 56, 68, 61, 56, 56,
    56, 22, 143, 56, 56, 145, 143, 56, 56, 56, 22, 143, 143, 56, 56, 56, 143, 43, 56, 69, 20, 144,
    144, 22, 142, 61, 56, 56, 56, 22, 56, 43, 147, 146, 148, 148, 146, 40, 149, 148, 148, 146, 40,
    149, 149, 146, 146, 150, 149, 149, 149, 146, 146, 146, 149, 43, 118, 118, 118, 118, 118, 118,
    118, 118, 50, 118, 118, 118, 118, 43, 0, 0,
];
static _indic_syllable_machine_index_defaults: [i16; 140] = [
    0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 9, 9, 9, 9, 9, 19, 19, 26, 19, 26, 19, 19, 29, 29, 29, 29, 29,
    29, 29, 0, 39, 42, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
    56, 56, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76,
    76, 76, 76, 76, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101,
    101, 101, 101, 101, 101, 118, 118, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119,
    119, 119, 119, 119, 119, 119, 119, 119, 119, 101, 56, 56, 56, 56, 56, 56, 56, 56, 146, 146,
    146, 146, 146, 118, 0, 0,
];
static _indic_syllable_machine_cond_targs: [i16; 153] = [
    31, 37, 42, 2, 43, 46, 4, 50, 51, 31, 60, 9, 66, 69, 61, 11, 74, 75, 78, 31, 83, 17, 89, 92,
    93, 84, 31, 19, 98, 31, 107, 24, 113, 116, 117, 108, 26, 122, 127, 31, 134, 31, 31, 32, 53, 79,
    81, 100, 101, 85, 102, 123, 124, 94, 132, 137, 31, 33, 35, 6, 52, 38, 47, 34, 1, 36, 40, 0, 39,
    41, 44, 45, 3, 48, 5, 49, 31, 54, 56, 14, 77, 62, 70, 55, 7, 57, 72, 64, 58, 13, 76, 59, 8, 63,
    65, 67, 68, 10, 71, 12, 73, 31, 80, 20, 82, 96, 87, 15, 99, 16, 86, 88, 90, 91, 18, 95, 21, 97,
    31, 31, 103, 105, 22, 27, 109, 118, 104, 106, 120, 111, 23, 110, 112, 114, 115, 25, 119, 28,
    121, 125, 126, 131, 128, 129, 29, 130, 31, 133, 30, 135, 136, 0, 0,
];
static _indic_syllable_machine_cond_actions: [i8; 153] = [
    1, 0, 2, 0, 2, 0, 0, 2, 2, 3, 2, 0, 2, 0, 0, 0, 2, 2, 2, 4, 2, 0, 5, 0, 5, 0, 6, 0, 2, 7, 2, 0,
    2, 0, 2, 0, 0, 2, 0, 8, 0, 0, 11, 2, 2, 5, 0, 12, 12, 0, 2, 5, 2, 5, 2, 0, 13, 2, 0, 0, 2, 0,
    2, 2, 0, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 2, 14, 2, 0, 0, 2, 0, 2, 2, 0, 2, 2, 2, 2, 0, 2, 2, 0,
    0, 2, 2, 2, 0, 0, 0, 2, 15, 5, 0, 5, 2, 2, 0, 5, 0, 0, 2, 5, 5, 0, 0, 0, 2, 16, 17, 2, 0, 0, 0,
    0, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 2, 0, 18, 18, 0, 0, 0, 0, 19, 2, 0, 0, 0, 0, 0,
];
static _indic_syllable_machine_to_state_actions: [i8; 140] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _indic_syllable_machine_from_state_actions: [i8; 140] = [
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
];
static _indic_syllable_machine_eof_trans: [i16; 140] = [
    1, 1, 1, 1, 1, 1, 1, 10, 10, 10, 10, 10, 10, 10, 10, 20, 20, 27, 20, 27, 20, 20, 30, 30, 30,
    30, 30, 30, 30, 1, 40, 42, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
    57, 57, 57, 57, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77,
    77, 77, 77, 77, 77, 77, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102,
    102, 102, 102, 102, 102, 102, 102, 119, 119, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
    120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 102, 57, 57, 57, 57, 57, 57, 57, 57,
    147, 147, 147, 147, 147, 119, 0, 0,
];
static indic_syllable_machine_start: i32 = 31;
static indic_syllable_machine_first_final: i32 = 31;
static indic_syllable_machine_error: i32 = -1;
static indic_syllable_machine_en_main: i32 = 31;
#[derive(Clone, Copy)]
pub enum SyllableType {
    ConsonantSyllable = 0,
    VowelSyllable,
    StandaloneCluster,
    SymbolCluster,
    BrokenCluster,
    NonIndicCluster,
}

pub fn find_syllables_indic(buffer: &mut hb_buffer_t) {
    let mut cs = 0;
    let mut ts = 0;
    let mut te = 0;
    let mut act = 0;
    let mut p = 0;
    let pe = buffer.len;
    let eof = buffer.len;
    let mut syllable_serial = 1u8;

    macro_rules! found_syllable {
        ($kind:expr) => {{
            found_syllable(ts, te, &mut syllable_serial, $kind, buffer)
        }};
    }

    {
        cs = (indic_syllable_machine_start) as i32;
        ts = 0;
        te = 0;
        act = 0;
    }

    {
        let mut _trans = 0;
        let mut _keys: i32 = 0;
        let mut _inds: i32 = 0;
        let mut _ic = 0;
        '_resume: while (p != pe || p == eof) {
            '_again: while (true) {
                match (_indic_syllable_machine_from_state_actions[(cs) as usize]) {
                    10 => {
                        ts = p;
                    }

                    _ => {}
                }
                if (p == eof) {
                    {
                        if (_indic_syllable_machine_eof_trans[(cs) as usize] > 0) {
                            {
                                _trans =
                                    (_indic_syllable_machine_eof_trans[(cs) as usize]) as u32 - 1;
                            }
                        }
                    }
                } else {
                    {
                        _keys = (cs << 1) as i32;
                        _inds = (_indic_syllable_machine_index_offsets[(cs) as usize]) as i32;
                        if ((buffer.info[p].indic_category() as u8) <= 18
                            && (buffer.info[p].indic_category() as u8) >= 1)
                        {
                            {
                                _ic = (_indic_syllable_machine_char_class
                                    [((buffer.info[p].indic_category() as u8) as i32 - 1) as usize])
                                    as i32;
                                if (_ic
                                    <= (_indic_syllable_machine_trans_keys[(_keys + 1) as usize])
                                        as i32
                                    && _ic
                                        >= (_indic_syllable_machine_trans_keys[(_keys) as usize])
                                            as i32)
                                {
                                    _trans = (_indic_syllable_machine_indices[(_inds
                                        + (_ic
                                            - (_indic_syllable_machine_trans_keys[(_keys) as usize])
                                                as i32)
                                            as i32)
                                        as usize])
                                        as u32;
                                } else {
                                    _trans = (_indic_syllable_machine_index_defaults[(cs) as usize])
                                        as u32;
                                }
                            }
                        } else {
                            {
                                _trans =
                                    (_indic_syllable_machine_index_defaults[(cs) as usize]) as u32;
                            }
                        }
                    }
                }
                cs = (_indic_syllable_machine_cond_targs[(_trans) as usize]) as i32;
                if (_indic_syllable_machine_cond_actions[(_trans) as usize] != 0) {
                    {
                        match (_indic_syllable_machine_cond_actions[(_trans) as usize]) {
                            2 => {
                                te = p + 1;
                            }
                            11 => {
                                te = p + 1;
                                {
                                    found_syllable!(SyllableType::NonIndicCluster);
                                }
                            }
                            13 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::ConsonantSyllable);
                                }
                            }
                            14 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::VowelSyllable);
                                }
                            }
                            17 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::StandaloneCluster);
                                }
                            }
                            19 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::SymbolCluster);
                                }
                            }
                            15 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::BrokenCluster);
                                    buffer.scratch_flags |=
                                        HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE;
                                }
                            }
                            16 => {
                                te = p;
                                p = p - 1;
                                {
                                    found_syllable!(SyllableType::NonIndicCluster);
                                }
                            }
                            1 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::ConsonantSyllable);
                                }
                            }
                            3 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::VowelSyllable);
                                }
                            }
                            7 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::StandaloneCluster);
                                }
                            }
                            8 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::SymbolCluster);
                                }
                            }
                            4 => {
                                p = (te) - 1;
                                {
                                    found_syllable!(SyllableType::BrokenCluster);
                                    buffer.scratch_flags |=
                                        HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE;
                                }
                            }
                            6 => match (act) {
                                1 => {
                                    p = (te) - 1;
                                    {
                                        found_syllable!(SyllableType::ConsonantSyllable);
                                    }
                                }
                                5 => {
                                    p = (te) - 1;
                                    {
                                        found_syllable!(SyllableType::BrokenCluster);
                                        buffer.scratch_flags |=
                                            HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE;
                                    }
                                }
                                6 => {
                                    p = (te) - 1;
                                    {
                                        found_syllable!(SyllableType::NonIndicCluster);
                                    }
                                }

                                _ => {}
                            },
                            18 => {
                                {
                                    {
                                        te = p + 1;
                                    }
                                }
                                {
                                    {
                                        act = 1;
                                    }
                                }
                            }
                            5 => {
                                {
                                    {
                                        te = p + 1;
                                    }
                                }
                                {
                                    {
                                        act = 5;
                                    }
                                }
                            }
                            12 => {
                                {
                                    {
                                        te = p + 1;
                                    }
                                }
                                {
                                    {
                                        act = 6;
                                    }
                                }
                            }

                            _ => {}
                        }
                    }
                }
                break '_again;
            }
            if (p == eof) {
                {
                    if (cs >= 31) {
                        break '_resume;
                    }
                }
            } else {
                {
                    match (_indic_syllable_machine_to_state_actions[(cs) as usize]) {
                        9 => {
                            ts = 0;
                        }

                        _ => {}
                    }
                    p += 1;
                    continue '_resume;
                }
            }
            break '_resume;
        }
    }
}

#[inline]
fn found_syllable(
    start: usize,
    end: usize,
    syllable_serial: &mut u8,
    kind: SyllableType,
    buffer: &mut hb_buffer_t,
) {
    for i in start..end {
        buffer.info[i].set_syllable((*syllable_serial << 4) | kind as u8);
    }

    *syllable_serial += 1;

    if *syllable_serial == 16 {
        *syllable_serial = 1;
    }
}
