# Change Log
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

## [Unreleased]

## [0.17.0] - 2024-07-02
### Changed
- Bump `ttf-parser`.

## [0.16.0] - 2024-07-02
- Sync with HarfBuzz 9.0.0.
  Thanks to [@LaurenzV](https://github.com/LaurenzV).

### Changed
- Bump `ttf-parser`.
- Use `core_maths` instead of `libm`. Should simplify the build process.

### Removed
- `no-std-float` build flag. Should be handled automatically now.

## [0.15.0] - 2024-06-29
- Sync with HarfBuzz 8.5.0 🎉<br>
  `rustybuzz` is finally in-sync with `harfbuzz`.
  Thanks to [@LaurenzV](https://github.com/LaurenzV).

### Changed
- When building without the `std` feature one must enable `no-std-float` feature instead.

### Fixed
- `gvar` phantom points handling which fixes some variable fonts shaping.

## [0.14.1] - 2024-06-12
### Fixed
- `no_std` build.
  Thanks to [@jackpot51](https://github.com/jackpot51)

## [0.14.0] - 2024-05-10
- Sync with HarfBuzz 4.3.0.
  Thanks to [@Pi-Cla](https://github.com/Pi-Cla) and [@LaurenzV](https://github.com/LaurenzV).

### Changed
- Bump `ttf-parser`.
- Bump Rust Edition to 2021.

## [0.13.0] - 2024-02-18
- Sync with HarfBuzz 4.1.0.
  Thanks to [@LaurenzV](https://github.com/LaurenzV).

## [0.12.1] - 2023-12-16
### Added
- Derive `Hash` for `Feature`.
  Thanks to [@laurmaedje](https://github.com/laurmaedje).
- `ShapePlan` is `Send` and `Sync` now.
  Thanks to [@laurmaedje](https://github.com/laurmaedje).

## [0.12.0] - 2023-11-29
### Added
- Sync with HarfBuzz 2.9.1.
  Thanks to [@bluebear94](https://github.com/bluebear94).
- `UnicodeBuffer::set_pre_context` and `UnicodeBuffer::set_post_context`.
  Thanks to [@bluebear94](https://github.com/bluebear94).
- `shape_with_plan` function to allow cached `ShapePlan`s.
  Thanks to [@vorporeal](https://github.com/vorporeal).

## [0.11.0] - 2023-10-15
### Added
- Sync with HarfBuzz 2.9.0.
  Thanks to [@bluebear94](https://github.com/bluebear94).

## [0.10.0] - 2023-09-10
### Added
- Sync with HarfBuzz 2.8.0.

## [0.9.0] - 2023-09-09
### Added
- Sync with HarfBuzz 2.7.4. Thanks to [@bluebear94](https://github.com/bluebear94).
- State machines are autogenerated via `ragel` instead of manually translating them from C now.
  Thanks to [@notgull](https://github.com/notgull).

### Changed
- Use `unicode-properties` crate instead of `unicode-general-category`.
  Should significantly reduce compilation times.
  Thanks to [@eddyb](https://github.com/eddyb).

### Fixed
- Panic in the Universal shaper. Thanks to [@notgull](https://github.com/notgull).

## [0.8.0] - 2023-06-12
### Changed
- Bump `ttf-parser`.

## [0.7.0] - 2023-02-04
### Added
- `UnicodeBuffer::add` thanks to [@bluebear94](https://github.com/bluebear94).

### Changed
- Bump `ttf-parser`.
- `Face::from_face` no longer returns `Option`.

## [0.6.0] - 2022-10-24
### Added
- `ttf-parser` is reexported now.

### Changed
- Bump `ttf-parser`.

## [0.5.3] - 2022-10-24
### Changed
- Revert 0.5.2 because it was a breaking change.

## [0.5.2] - 2022-10-22
### Added
- `ttf-parser` is reexported now.

### Changed
- Bump `ttf-parser`.

## [0.5.1] - 2022-06-11
### Added
- Implement `PartialOrd`, `Ord` and `Hash` for `Script`.

### Fixed
- `no_std` support thanks to [@CryZe](https://github.com/CryZe).

## [0.5.0] - 2022-02-20
### Changed
- `GSUB`, `GPOS`, `ankr`, `feat`, `kern`, `kerx`, `morx` and `trak`
  tables parsing was moved to `ttf-parser`.
- `rustybuzz` no longer do any TrueType parsing. Everything is handled by `ttf-parser`.

### Fixed
- Multiple issues in AAT Lookup Table parsing.

## [0.4.0] - 2021-06-27
### Added
- `Face::from_face`, so you can create `rustybuzz::Face` directly from `ttf_parser::Face`.
  Thanks to [@lain-dono](https://github.com/lain-dono)
- `no_std` support thanks to [@CryZe](https://github.com/CryZe).
- `GlyphInfo::unsafe_to_break` thanks to [@glowcoil](https://github.com/glowcoil).

### Changed
- Sync with harfbuzz 2.7.1
- Rename `GlyphInfo.codepoint` into `GlyphInfo.glyph_id` to remove confusion.

## [0.3.0] - 2020-12-05
### Ported
- Everything! 🎉
- Tables: `GSUB`, `GPOS`, `GDEF`, `ankr`, `feat`, `kern`, `kerx`, `morx`, `trak`.
- Main shaping logic.
- `hb_shape_plan_t` and `hb_ot_shape_plan_t`
- `hb_ot_map_t`
- `hb_ot_complex_shaper_t`
- OpenType layout (GSUB, GPOS).
- AAT layout.
- Normalization.
- Fallback shaper.
- Kerning.

### Changed
- Rename `Font` to `Face`.

Most of the changes in this release were made by [laurmaedje](https://github.com/laurmaedje).

## [0.2.0] - 2020-07-25
### Ported
- All complex shapers.
- Tables: `CBDT`, `CFF`, `CFF2`, `HVAR`, `MVAR`, `OS/2`, `SVG`, `VORG`, `VVAR`,
  `avar`, `cmap`, `fvar`, `glyf`, `gvar`, `hhea`, `hmtx`, `post`, `sbix`, `vhea`, `vmtx`.
- `hb_buffer_t`
- `hb_script_t`
- `hb_feature_t`
- `hb_variation_t`
- `hb_language_t`
- `hb_font_t`
- `hb-ot-metrics`
- Unicode functions and tables.
- Buffer serialization.

### Changed
- Update to HarfBuzz 2.7.0
- Rename `Font::from_data` into `Font::from_slice`.
- Font is parsed via `ttf-parser` first.
  And if the parsing fails, the `Font` will not be created.
  `harfbuzz` allows malformed fonts.

### Removed
- `hb_font_funcs_t`. Only the embedded TrueType implementation is used.
- `hb_unicode_funcs_t`. Only the embedded Unicode implementation is used.
- `Font::set_scale`/`hb_font_set_scale`/`--font-size`. Shaping is always in font units now.
  This simplifies the code quite a lot.
- Shaping plan caching.
- Fallback shaper.
- Unused `hdmx` table.

## [0.1.1] - 2020-07-04
### Fixed
- Compilation with an old XCode.

## 0.1.0 - 2020-07-04
At this point, this is just a simple Rust bindings to a stripped down harfbuzz.

### Added
- An absolute minimum Rust API.
- harfbuzz's shaping test suite had been ported to Rust.

### Changed
- harfbuzz source code was reformatted using clang-format.

### Removed
- Subsetting. This is probably a bit controversial, but I want to port only the shaper for now.
  This is also removes around 7000 LOC.
- Arabic fallback shaper. Since it requires subsetting.
- Unused TrueType tables: BASE, COLR, CPAL, JSTF, MATH, STAT, bsln, fdsc, gasp, just, lcar, ltag, meta, name, opbd.
- All external dependencies: coretext, directwrite, freetype, gdi, glib, gobject, graphite, icu, uniscribe.
  Embedded harfbuzz relies only on internal TrueType implementation.
- Most of the non-shaping harfbuzz API.

[Unreleased]: https://github.com/RazrFalcon/rustybuzz/compare/v0.17.0...HEAD
[0.17.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.16.0...v0.17.0
[0.16.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.15.0...v0.16.0
[0.15.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.14.1...v0.15.0
[0.14.1]: https://github.com/RazrFalcon/rustybuzz/compare/v0.14.0...v0.14.1
[0.14.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.13.0...v0.14.0
[0.13.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.12.1...v0.13.0
[0.12.1]: https://github.com/RazrFalcon/rustybuzz/compare/v0.12.0...v0.12.1
[0.12.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.11.0...v0.12.0
[0.11.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.10.0...v0.11.0
[0.10.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.9.0...v0.10.0
[0.9.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.8.0...v0.9.0
[0.8.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.7.0...v0.8.0
[0.7.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.6.0...v0.7.0
[0.6.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.5.3...v0.6.0
[0.5.3]: https://github.com/RazrFalcon/rustybuzz/compare/v0.5.2...v0.5.3
[0.5.2]: https://github.com/RazrFalcon/rustybuzz/compare/v0.5.1...v0.5.2
[0.5.1]: https://github.com/RazrFalcon/rustybuzz/compare/v0.5.0...v0.5.1
[0.5.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.4.0...v0.5.0
[0.4.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.3.0...v0.4.0
[0.3.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.2.0...v0.3.0
[0.2.0]: https://github.com/RazrFalcon/rustybuzz/compare/v0.1.1...v0.2.0
[0.1.1]: https://github.com/RazrFalcon/rustybuzz/compare/v0.1.0...v0.1.1
