#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1031
#define LARGE_STATE_COUNT 96
#define SYMBOL_COUNT 220
#define ALIAS_COUNT 0
#define TOKEN_COUNT 101
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 25
#define MAX_ALIAS_SEQUENCE_LENGTH 9

enum {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_DOT = 3,
  anon_sym_from = 4,
  anon_sym___future__ = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_COMMA = 8,
  anon_sym_as = 9,
  anon_sym_STAR = 10,
  anon_sym_print = 11,
  anon_sym_GT_GT = 12,
  anon_sym_assert = 13,
  anon_sym_COLON_EQ = 14,
  anon_sym_return = 15,
  anon_sym_del = 16,
  anon_sym_raise = 17,
  anon_sym_pass = 18,
  anon_sym_break = 19,
  anon_sym_continue = 20,
  anon_sym_if = 21,
  anon_sym_COLON = 22,
  anon_sym_elif = 23,
  anon_sym_else = 24,
  anon_sym_async = 25,
  anon_sym_for = 26,
  anon_sym_in = 27,
  anon_sym_while = 28,
  anon_sym_try = 29,
  anon_sym_except = 30,
  anon_sym_finally = 31,
  anon_sym_with = 32,
  anon_sym_def = 33,
  anon_sym_DASH_GT = 34,
  anon_sym_EQ = 35,
  anon_sym_STAR_STAR = 36,
  anon_sym_global = 37,
  anon_sym_nonlocal = 38,
  anon_sym_exec = 39,
  anon_sym_class = 40,
  anon_sym_AT = 41,
  anon_sym_not = 42,
  anon_sym_and = 43,
  anon_sym_or = 44,
  anon_sym_PLUS = 45,
  anon_sym_DASH = 46,
  anon_sym_SLASH = 47,
  anon_sym_PERCENT = 48,
  anon_sym_SLASH_SLASH = 49,
  anon_sym_PIPE = 50,
  anon_sym_AMP = 51,
  anon_sym_CARET = 52,
  anon_sym_LT_LT = 53,
  anon_sym_TILDE = 54,
  anon_sym_LT = 55,
  anon_sym_LT_EQ = 56,
  anon_sym_EQ_EQ = 57,
  anon_sym_BANG_EQ = 58,
  anon_sym_GT_EQ = 59,
  anon_sym_GT = 60,
  anon_sym_LT_GT = 61,
  anon_sym_is = 62,
  anon_sym_lambda = 63,
  anon_sym_PLUS_EQ = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_STAR_EQ = 66,
  anon_sym_SLASH_EQ = 67,
  anon_sym_AT_EQ = 68,
  anon_sym_SLASH_SLASH_EQ = 69,
  anon_sym_PERCENT_EQ = 70,
  anon_sym_STAR_STAR_EQ = 71,
  anon_sym_GT_GT_EQ = 72,
  anon_sym_LT_LT_EQ = 73,
  anon_sym_AMP_EQ = 74,
  anon_sym_CARET_EQ = 75,
  anon_sym_PIPE_EQ = 76,
  anon_sym_yield = 77,
  anon_sym_LBRACK = 78,
  anon_sym_RBRACK = 79,
  sym_ellipsis = 80,
  anon_sym_LBRACE = 81,
  anon_sym_RBRACE = 82,
  sym_escape_sequence = 83,
  sym__not_escape_sequence = 84,
  aux_sym_format_specifier_token1 = 85,
  sym_type_conversion = 86,
  sym_integer = 87,
  sym_float = 88,
  sym_true = 89,
  sym_false = 90,
  sym_none = 91,
  anon_sym_await = 92,
  sym_comment = 93,
  sym__semicolon = 94,
  sym__newline = 95,
  sym__indent = 96,
  sym__dedent = 97,
  sym__string_start = 98,
  sym__string_content = 99,
  sym__string_end = 100,
  sym_module = 101,
  sym__statement = 102,
  sym__simple_statements = 103,
  sym_import_statement = 104,
  sym_import_prefix = 105,
  sym_relative_import = 106,
  sym_future_import_statement = 107,
  sym_import_from_statement = 108,
  sym__import_list = 109,
  sym_aliased_import = 110,
  sym_wildcard_import = 111,
  sym_print_statement = 112,
  sym_chevron = 113,
  sym_assert_statement = 114,
  sym_expression_statement = 115,
  sym_named_expression = 116,
  sym_return_statement = 117,
  sym_delete_statement = 118,
  sym_raise_statement = 119,
  sym_pass_statement = 120,
  sym_break_statement = 121,
  sym_continue_statement = 122,
  sym_if_statement = 123,
  sym_elif_clause = 124,
  sym_else_clause = 125,
  sym_for_statement = 126,
  sym_while_statement = 127,
  sym_try_statement = 128,
  sym_except_clause = 129,
  sym_finally_clause = 130,
  sym_with_statement = 131,
  sym_with_item = 132,
  sym_function_definition = 133,
  sym_parameters = 134,
  sym_lambda_parameters = 135,
  sym__parameters = 136,
  sym_default_parameter = 137,
  sym_typed_default_parameter = 138,
  sym_list_splat = 139,
  sym_dictionary_splat = 140,
  sym_global_statement = 141,
  sym_nonlocal_statement = 142,
  sym_exec_statement = 143,
  sym_class_definition = 144,
  sym_parenthesized_list_splat = 145,
  sym_argument_list = 146,
  sym_decorated_definition = 147,
  sym_decorator = 148,
  sym_block = 149,
  sym_variables = 150,
  sym_expression_list = 151,
  sym_dotted_name = 152,
  sym__expression_within_for_in_clause = 153,
  sym__expression = 154,
  sym__primary_expression = 155,
  sym_not_operator = 156,
  sym_boolean_operator = 157,
  sym_binary_operator = 158,
  sym_unary_operator = 159,
  sym_comparison_operator = 160,
  sym_lambda = 161,
  sym_lambda_within_for_in_clause = 162,
  sym_assignment = 163,
  sym_augmented_assignment = 164,
  sym__right_hand_side = 165,
  sym_yield = 166,
  sym_attribute = 167,
  sym_subscript = 168,
  sym_slice = 169,
  sym_call = 170,
  sym_typed_parameter = 171,
  sym_type = 172,
  sym_keyword_argument = 173,
  sym_list = 174,
  sym__comprehension_clauses = 175,
  sym_list_comprehension = 176,
  sym_dictionary = 177,
  sym_dictionary_comprehension = 178,
  sym_pair = 179,
  sym_set = 180,
  sym_set_comprehension = 181,
  sym_parenthesized_expression = 182,
  sym__collection_elements = 183,
  sym_tuple = 184,
  sym_generator_expression = 185,
  sym_for_in_clause = 186,
  sym_if_clause = 187,
  sym_conditional_expression = 188,
  sym_concatenated_string = 189,
  sym_string = 190,
  sym_interpolation = 191,
  sym_format_specifier = 192,
  sym_format_expression = 193,
  sym_await = 194,
  aux_sym_module_repeat1 = 195,
  aux_sym__simple_statements_repeat1 = 196,
  aux_sym_import_prefix_repeat1 = 197,
  aux_sym__import_list_repeat1 = 198,
  aux_sym_print_statement_repeat1 = 199,
  aux_sym_assert_statement_repeat1 = 200,
  aux_sym_if_statement_repeat1 = 201,
  aux_sym_try_statement_repeat1 = 202,
  aux_sym_with_statement_repeat1 = 203,
  aux_sym__parameters_repeat1 = 204,
  aux_sym_global_statement_repeat1 = 205,
  aux_sym_argument_list_repeat1 = 206,
  aux_sym_decorated_definition_repeat1 = 207,
  aux_sym_variables_repeat1 = 208,
  aux_sym_dotted_name_repeat1 = 209,
  aux_sym_comparison_operator_repeat1 = 210,
  aux_sym_subscript_repeat1 = 211,
  aux_sym__comprehension_clauses_repeat1 = 212,
  aux_sym_dictionary_repeat1 = 213,
  aux_sym_set_repeat1 = 214,
  aux_sym__collection_elements_repeat1 = 215,
  aux_sym_for_in_clause_repeat1 = 216,
  aux_sym_concatenated_string_repeat1 = 217,
  aux_sym_string_repeat1 = 218,
  aux_sym_format_specifier_repeat1 = 219,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_EQ] = "=",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_class] = "class",
  [anon_sym_AT] = "@",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [anon_sym_await] = "await",
  [sym_comment] = "comment",
  [sym__semicolon] = "_semicolon",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym__parameters] = "_parameters",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_class_definition] = "class_definition",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_variables] = "variables",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary] = "dictionary",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_pair] = "pair",
  [sym_set] = "set",
  [sym_set_comprehension] = "set_comprehension",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_tuple] = "tuple",
  [sym_generator_expression] = "generator_expression",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_interpolation] = "interpolation",
  [sym_format_specifier] = "format_specifier",
  [sym_format_expression] = "format_expression",
  [sym_await] = "await",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_with_statement_repeat1] = "with_statement_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_variables_repeat1] = "variables_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym_set_repeat1] = "set_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [anon_sym_await] = anon_sym_await,
  [sym_comment] = sym_comment,
  [sym__semicolon] = sym__semicolon,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym__parameters] = sym__parameters,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_variables] = sym_variables,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary] = sym_dictionary,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_pair] = sym_pair,
  [sym_set] = sym_set,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_tuple] = sym_tuple,
  [sym_generator_expression] = sym_generator_expression,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_interpolation] = sym_interpolation,
  [sym_format_specifier] = sym_format_specifier,
  [sym_format_expression] = sym_format_expression,
  [sym_await] = sym_await,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_with_statement_repeat1] = aux_sym_with_statement_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_variables_repeat1] = aux_sym_variables_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym_set_repeat1] = aux_sym_set_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_variables] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variables_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_function = 12,
  field_key = 13,
  field_left = 14,
  field_module_name = 15,
  field_name = 16,
  field_object = 17,
  field_operator = 18,
  field_parameters = 19,
  field_return_type = 20,
  field_right = 21,
  field_subscript = 22,
  field_superclasses = 23,
  field_type = 24,
  field_value = 25,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[94] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 1},
  [11] = {.index = 10, .length = 2},
  [12] = {.index = 12, .length = 1},
  [13] = {.index = 13, .length = 2},
  [14] = {.index = 15, .length = 1},
  [15] = {.index = 16, .length = 1},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 2},
  [19] = {.index = 23, .length = 3},
  [20] = {.index = 26, .length = 2},
  [21] = {.index = 28, .length = 1},
  [22] = {.index = 29, .length = 2},
  [23] = {.index = 31, .length = 2},
  [24] = {.index = 33, .length = 1},
  [25] = {.index = 34, .length = 2},
  [27] = {.index = 36, .length = 1},
  [28] = {.index = 37, .length = 2},
  [29] = {.index = 39, .length = 1},
  [30] = {.index = 40, .length = 2},
  [31] = {.index = 42, .length = 2},
  [32] = {.index = 16, .length = 1},
  [33] = {.index = 44, .length = 1},
  [34] = {.index = 45, .length = 2},
  [35] = {.index = 47, .length = 2},
  [36] = {.index = 49, .length = 1},
  [39] = {.index = 17, .length = 2},
  [40] = {.index = 50, .length = 1},
  [41] = {.index = 51, .length = 2},
  [42] = {.index = 53, .length = 2},
  [43] = {.index = 55, .length = 2},
  [44] = {.index = 57, .length = 1},
  [45] = {.index = 58, .length = 3},
  [46] = {.index = 61, .length = 3},
  [47] = {.index = 64, .length = 3},
  [48] = {.index = 67, .length = 1},
  [49] = {.index = 68, .length = 3},
  [50] = {.index = 71, .length = 3},
  [51] = {.index = 74, .length = 2},
  [52] = {.index = 76, .length = 2},
  [53] = {.index = 78, .length = 3},
  [54] = {.index = 81, .length = 3},
  [55] = {.index = 84, .length = 3},
  [56] = {.index = 87, .length = 3},
  [57] = {.index = 90, .length = 3},
  [58] = {.index = 93, .length = 1},
  [59] = {.index = 94, .length = 2},
  [60] = {.index = 96, .length = 2},
  [61] = {.index = 98, .length = 4},
  [62] = {.index = 102, .length = 2},
  [63] = {.index = 104, .length = 4},
  [64] = {.index = 108, .length = 4},
  [65] = {.index = 112, .length = 2},
  [66] = {.index = 114, .length = 1},
  [67] = {.index = 115, .length = 3},
  [68] = {.index = 118, .length = 3},
  [69] = {.index = 121, .length = 4},
  [71] = {.index = 125, .length = 4},
  [72] = {.index = 129, .length = 4},
  [73] = {.index = 133, .length = 3},
  [74] = {.index = 133, .length = 3},
  [75] = {.index = 136, .length = 2},
  [76] = {.index = 138, .length = 3},
  [77] = {.index = 141, .length = 5},
  [78] = {.index = 146, .length = 3},
  [79] = {.index = 149, .length = 2},
  [80] = {.index = 151, .length = 4},
  [81] = {.index = 155, .length = 4},
  [82] = {.index = 159, .length = 4},
  [84] = {.index = 163, .length = 4},
  [85] = {.index = 167, .length = 3},
  [86] = {.index = 170, .length = 4},
  [87] = {.index = 174, .length = 4},
  [88] = {.index = 178, .length = 4},
  [89] = {.index = 182, .length = 5},
  [90] = {.index = 187, .length = 5},
  [91] = {.index = 192, .length = 5},
  [92] = {.index = 197, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_definition, 1},
  [10] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [12] =
    {field_argument, 2, .inherited = true},
  [13] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [15] =
    {field_cause, 2},
  [16] =
    {field_body, 2},
  [17] =
    {field_name, 0},
    {field_value, 2},
  [19] =
    {field_left, 0},
    {field_type, 2},
  [21] =
    {field_left, 0},
    {field_right, 2},
  [23] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [26] =
    {field_attribute, 2},
    {field_object, 0},
  [28] =
    {field_name, 1},
  [29] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [31] =
    {field_alias, 2},
    {field_name, 0},
  [33] =
    {field_name, 3, .inherited = true},
  [34] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [36] =
    {field_body, 1},
  [37] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [39] =
    {field_cause, 3},
  [40] =
    {field_condition, 1},
    {field_consequence, 3},
  [42] =
    {field_body, 3},
    {field_condition, 1},
  [44] =
    {field_body, 3},
  [45] =
    {field_alias, 2},
    {field_value, 0},
  [47] =
    {field_body, 3},
    {field_name, 1},
  [49] =
    {field_arguments, 2},
  [50] =
    {field_type, 2},
  [51] =
    {field_body, 3},
    {field_parameters, 1},
  [53] =
    {field_key, 0},
    {field_value, 2},
  [55] =
    {field_subscript, 2},
    {field_value, 0},
  [57] =
    {field_alternative, 0},
  [58] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [61] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [64] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [67] =
    {field_body, 4},
  [68] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [71] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [74] =
    {field_body, 2},
    {field_body, 3},
  [76] =
    {field_body, 3},
    {field_body, 4},
  [78] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [81] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [84] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [87] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [90] =
    {field_subscript, 2},
    {field_subscript, 3},
    {field_value, 0},
  [93] =
    {field_name, 4, .inherited = true},
  [94] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [96] =
    {field_left, 1},
    {field_right, 3},
  [98] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [102] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [104] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [108] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [112] =
    {field_body, 4},
    {field_body, 5},
  [114] =
    {field_body, 5},
  [115] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [118] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [121] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [125] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [129] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [133] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [136] =
    {field_left, 2},
    {field_right, 4},
  [138] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [141] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [149] =
    {field_body, 5},
    {field_body, 6},
  [151] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [155] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [163] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [167] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [170] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [174] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [178] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [182] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [187] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [192] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [197] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
};

static TSSymbol ts_alias_sequences[94][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [8] = {
    [0] = sym_list_splat,
  },
  [26] = {
    [1] = sym_parenthesized_expression,
  },
  [30] = {
    [3] = sym_block,
  },
  [31] = {
    [3] = sym_block,
  },
  [32] = {
    [2] = sym_block,
  },
  [33] = {
    [3] = sym_block,
  },
  [35] = {
    [3] = sym_block,
  },
  [37] = {
    [1] = sym_list_splat,
  },
  [38] = {
    [1] = sym_identifier,
  },
  [39] = {
    [0] = sym_identifier,
  },
  [45] = {
    [3] = sym_block,
  },
  [46] = {
    [3] = sym_block,
  },
  [48] = {
    [4] = sym_block,
  },
  [49] = {
    [3] = sym_block,
  },
  [53] = {
    [4] = sym_block,
  },
  [55] = {
    [4] = sym_block,
  },
  [61] = {
    [3] = sym_block,
  },
  [66] = {
    [5] = sym_block,
  },
  [67] = {
    [5] = sym_block,
  },
  [68] = {
    [5] = sym_block,
  },
  [70] = {
    [2] = sym_block,
  },
  [73] = {
    [0] = sym_identifier,
  },
  [78] = {
    [6] = sym_block,
  },
  [81] = {
    [5] = sym_block,
  },
  [83] = {
    [3] = sym_block,
  },
  [84] = {
    [6] = sym_block,
  },
  [86] = {
    [6] = sym_block,
  },
  [88] = {
    [7] = sym_block,
  },
  [93] = {
    [5] = sym_block,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(58);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(56);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '@') ADVANCE(53);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(35)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == '^') ADVANCE(62);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(60);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(10)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(91);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(11)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(9)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(9)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(58);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '@') ADVANCE(53);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == '^') ADVANCE(62);
      if (lookahead == '|') ADVANCE(60);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(58);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '@') ADVANCE(53);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == '^') ADVANCE(62);
      if (lookahead == '|') ADVANCE(60);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '-') ADVANCE(15);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(87);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(68);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(97);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 16:
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 20:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(23);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(26);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(28);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 35:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(34)
      END_STATE();
    case 36:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      END_STATE();
    case 37:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      if (lookahead == '\r') SKIP(36)
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(58);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(51);
      if (lookahead == '>') ADVANCE(70);
      if (lookahead == '@') ADVANCE(53);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(86);
      if (lookahead == '^') ADVANCE(62);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(60);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(52);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '=') ADVANCE(75);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(63);
      if (lookahead == '=') ADVANCE(66);
      if (lookahead == '>') ADVANCE(71);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(46);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (lookahead == '\n') ADVANCE(91);
      if (lookahead == '\r') ADVANCE(3);
      if (lookahead == 'U') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(29);
      if (lookahead == 'x') ADVANCE(27);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '{' ||
          lookahead == '}') ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(16);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(18);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(109);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym__semicolon);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(25)
      END_STATE();
    case 5:
      if (lookahead == '_') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'n') ADVANCE(27);
      if (lookahead == 's') ADVANCE(28);
      if (lookahead == 'w') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(45);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(59);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(66);
      if (lookahead == 'l') ADVANCE(67);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(77);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 51:
      if (lookahead == 'y') ADVANCE(84);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 55:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 68:
      if (lookahead == 'f') ADVANCE(98);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(104);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(106);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 86:
      if (lookahead == 'h') ADVANCE(113);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(114);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(118);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 95:
      if (lookahead == 'k') ADVANCE(120);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 106:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 114:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 116:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_except);
      END_STATE();
    case 138:
      if (lookahead == 'y') ADVANCE(146);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(147);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 148:
      if (lookahead == '_') ADVANCE(151);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 151:
      if (lookahead == '_') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 38, .external_lex_state = 2},
  [2] = {.lex_state = 38, .external_lex_state = 3},
  [3] = {.lex_state = 38, .external_lex_state = 3},
  [4] = {.lex_state = 38, .external_lex_state = 3},
  [5] = {.lex_state = 38, .external_lex_state = 3},
  [6] = {.lex_state = 38, .external_lex_state = 3},
  [7] = {.lex_state = 38, .external_lex_state = 3},
  [8] = {.lex_state = 38, .external_lex_state = 3},
  [9] = {.lex_state = 38, .external_lex_state = 3},
  [10] = {.lex_state = 38, .external_lex_state = 3},
  [11] = {.lex_state = 38, .external_lex_state = 3},
  [12] = {.lex_state = 38, .external_lex_state = 3},
  [13] = {.lex_state = 38, .external_lex_state = 3},
  [14] = {.lex_state = 38, .external_lex_state = 3},
  [15] = {.lex_state = 38, .external_lex_state = 3},
  [16] = {.lex_state = 38, .external_lex_state = 3},
  [17] = {.lex_state = 38, .external_lex_state = 3},
  [18] = {.lex_state = 38, .external_lex_state = 3},
  [19] = {.lex_state = 38, .external_lex_state = 3},
  [20] = {.lex_state = 38, .external_lex_state = 3},
  [21] = {.lex_state = 38, .external_lex_state = 3},
  [22] = {.lex_state = 38, .external_lex_state = 3},
  [23] = {.lex_state = 38, .external_lex_state = 3},
  [24] = {.lex_state = 38, .external_lex_state = 3},
  [25] = {.lex_state = 38, .external_lex_state = 3},
  [26] = {.lex_state = 38, .external_lex_state = 3},
  [27] = {.lex_state = 38, .external_lex_state = 3},
  [28] = {.lex_state = 38, .external_lex_state = 3},
  [29] = {.lex_state = 38, .external_lex_state = 3},
  [30] = {.lex_state = 38, .external_lex_state = 3},
  [31] = {.lex_state = 38, .external_lex_state = 3},
  [32] = {.lex_state = 38, .external_lex_state = 3},
  [33] = {.lex_state = 38, .external_lex_state = 3},
  [34] = {.lex_state = 38, .external_lex_state = 3},
  [35] = {.lex_state = 38, .external_lex_state = 3},
  [36] = {.lex_state = 38, .external_lex_state = 3},
  [37] = {.lex_state = 38, .external_lex_state = 3},
  [38] = {.lex_state = 38, .external_lex_state = 3},
  [39] = {.lex_state = 38, .external_lex_state = 3},
  [40] = {.lex_state = 38, .external_lex_state = 3},
  [41] = {.lex_state = 38, .external_lex_state = 3},
  [42] = {.lex_state = 38, .external_lex_state = 2},
  [43] = {.lex_state = 38, .external_lex_state = 3},
  [44] = {.lex_state = 38, .external_lex_state = 3},
  [45] = {.lex_state = 38, .external_lex_state = 3},
  [46] = {.lex_state = 38, .external_lex_state = 3},
  [47] = {.lex_state = 38, .external_lex_state = 2},
  [48] = {.lex_state = 38, .external_lex_state = 4},
  [49] = {.lex_state = 38, .external_lex_state = 5},
  [50] = {.lex_state = 38, .external_lex_state = 5},
  [51] = {.lex_state = 38, .external_lex_state = 5},
  [52] = {.lex_state = 38, .external_lex_state = 5},
  [53] = {.lex_state = 38, .external_lex_state = 5},
  [54] = {.lex_state = 38, .external_lex_state = 5},
  [55] = {.lex_state = 38, .external_lex_state = 5},
  [56] = {.lex_state = 38, .external_lex_state = 5},
  [57] = {.lex_state = 38, .external_lex_state = 5},
  [58] = {.lex_state = 38, .external_lex_state = 5},
  [59] = {.lex_state = 38, .external_lex_state = 5},
  [60] = {.lex_state = 38, .external_lex_state = 5},
  [61] = {.lex_state = 38, .external_lex_state = 5},
  [62] = {.lex_state = 38, .external_lex_state = 5},
  [63] = {.lex_state = 38, .external_lex_state = 5},
  [64] = {.lex_state = 38, .external_lex_state = 5},
  [65] = {.lex_state = 38, .external_lex_state = 5},
  [66] = {.lex_state = 38, .external_lex_state = 5},
  [67] = {.lex_state = 38, .external_lex_state = 5},
  [68] = {.lex_state = 38, .external_lex_state = 5},
  [69] = {.lex_state = 38, .external_lex_state = 5},
  [70] = {.lex_state = 38, .external_lex_state = 5},
  [71] = {.lex_state = 38, .external_lex_state = 5},
  [72] = {.lex_state = 38, .external_lex_state = 5},
  [73] = {.lex_state = 38, .external_lex_state = 5},
  [74] = {.lex_state = 38, .external_lex_state = 5},
  [75] = {.lex_state = 38, .external_lex_state = 5},
  [76] = {.lex_state = 38, .external_lex_state = 5},
  [77] = {.lex_state = 38, .external_lex_state = 5},
  [78] = {.lex_state = 38, .external_lex_state = 5},
  [79] = {.lex_state = 38, .external_lex_state = 5},
  [80] = {.lex_state = 38, .external_lex_state = 5},
  [81] = {.lex_state = 38, .external_lex_state = 5},
  [82] = {.lex_state = 38, .external_lex_state = 5},
  [83] = {.lex_state = 38, .external_lex_state = 5},
  [84] = {.lex_state = 38, .external_lex_state = 5},
  [85] = {.lex_state = 38, .external_lex_state = 5},
  [86] = {.lex_state = 38, .external_lex_state = 5},
  [87] = {.lex_state = 38, .external_lex_state = 5},
  [88] = {.lex_state = 38, .external_lex_state = 5},
  [89] = {.lex_state = 38, .external_lex_state = 4},
  [90] = {.lex_state = 38, .external_lex_state = 4},
  [91] = {.lex_state = 38, .external_lex_state = 4},
  [92] = {.lex_state = 38, .external_lex_state = 4},
  [93] = {.lex_state = 38, .external_lex_state = 4},
  [94] = {.lex_state = 38, .external_lex_state = 4},
  [95] = {.lex_state = 38, .external_lex_state = 2},
  [96] = {.lex_state = 38, .external_lex_state = 4},
  [97] = {.lex_state = 38, .external_lex_state = 4},
  [98] = {.lex_state = 38, .external_lex_state = 4},
  [99] = {.lex_state = 38, .external_lex_state = 4},
  [100] = {.lex_state = 38, .external_lex_state = 2},
  [101] = {.lex_state = 38, .external_lex_state = 2},
  [102] = {.lex_state = 38, .external_lex_state = 2},
  [103] = {.lex_state = 38, .external_lex_state = 2},
  [104] = {.lex_state = 38, .external_lex_state = 2},
  [105] = {.lex_state = 38, .external_lex_state = 2},
  [106] = {.lex_state = 38, .external_lex_state = 2},
  [107] = {.lex_state = 38, .external_lex_state = 2},
  [108] = {.lex_state = 38, .external_lex_state = 2},
  [109] = {.lex_state = 10, .external_lex_state = 4},
  [110] = {.lex_state = 38, .external_lex_state = 2},
  [111] = {.lex_state = 38, .external_lex_state = 2},
  [112] = {.lex_state = 38, .external_lex_state = 2},
  [113] = {.lex_state = 38, .external_lex_state = 2},
  [114] = {.lex_state = 38, .external_lex_state = 2},
  [115] = {.lex_state = 38, .external_lex_state = 2},
  [116] = {.lex_state = 38, .external_lex_state = 2},
  [117] = {.lex_state = 38, .external_lex_state = 2},
  [118] = {.lex_state = 38, .external_lex_state = 2},
  [119] = {.lex_state = 38, .external_lex_state = 2},
  [120] = {.lex_state = 38, .external_lex_state = 2},
  [121] = {.lex_state = 38, .external_lex_state = 2},
  [122] = {.lex_state = 38, .external_lex_state = 2},
  [123] = {.lex_state = 38, .external_lex_state = 2},
  [124] = {.lex_state = 10, .external_lex_state = 4},
  [125] = {.lex_state = 38, .external_lex_state = 2},
  [126] = {.lex_state = 10, .external_lex_state = 6},
  [127] = {.lex_state = 38, .external_lex_state = 2},
  [128] = {.lex_state = 38, .external_lex_state = 2},
  [129] = {.lex_state = 38, .external_lex_state = 2},
  [130] = {.lex_state = 38, .external_lex_state = 2},
  [131] = {.lex_state = 38, .external_lex_state = 2},
  [132] = {.lex_state = 38, .external_lex_state = 2},
  [133] = {.lex_state = 38, .external_lex_state = 2},
  [134] = {.lex_state = 38, .external_lex_state = 2},
  [135] = {.lex_state = 10, .external_lex_state = 4},
  [136] = {.lex_state = 38, .external_lex_state = 2},
  [137] = {.lex_state = 38, .external_lex_state = 2},
  [138] = {.lex_state = 10, .external_lex_state = 6},
  [139] = {.lex_state = 10, .external_lex_state = 6},
  [140] = {.lex_state = 38, .external_lex_state = 2},
  [141] = {.lex_state = 10, .external_lex_state = 6},
  [142] = {.lex_state = 38, .external_lex_state = 2},
  [143] = {.lex_state = 10, .external_lex_state = 6},
  [144] = {.lex_state = 10, .external_lex_state = 6},
  [145] = {.lex_state = 10, .external_lex_state = 6},
  [146] = {.lex_state = 10, .external_lex_state = 6},
  [147] = {.lex_state = 10, .external_lex_state = 6},
  [148] = {.lex_state = 10, .external_lex_state = 6},
  [149] = {.lex_state = 10, .external_lex_state = 6},
  [150] = {.lex_state = 38, .external_lex_state = 2},
  [151] = {.lex_state = 38, .external_lex_state = 2},
  [152] = {.lex_state = 10, .external_lex_state = 4},
  [153] = {.lex_state = 38, .external_lex_state = 2},
  [154] = {.lex_state = 10, .external_lex_state = 4},
  [155] = {.lex_state = 10, .external_lex_state = 4},
  [156] = {.lex_state = 9, .external_lex_state = 6},
  [157] = {.lex_state = 38, .external_lex_state = 2},
  [158] = {.lex_state = 10, .external_lex_state = 6},
  [159] = {.lex_state = 10, .external_lex_state = 6},
  [160] = {.lex_state = 10, .external_lex_state = 6},
  [161] = {.lex_state = 10, .external_lex_state = 6},
  [162] = {.lex_state = 10, .external_lex_state = 6},
  [163] = {.lex_state = 38, .external_lex_state = 4},
  [164] = {.lex_state = 38, .external_lex_state = 2},
  [165] = {.lex_state = 38, .external_lex_state = 2},
  [166] = {.lex_state = 10, .external_lex_state = 6},
  [167] = {.lex_state = 10, .external_lex_state = 6},
  [168] = {.lex_state = 10, .external_lex_state = 6},
  [169] = {.lex_state = 10, .external_lex_state = 6},
  [170] = {.lex_state = 10, .external_lex_state = 6},
  [171] = {.lex_state = 10, .external_lex_state = 6},
  [172] = {.lex_state = 10, .external_lex_state = 6},
  [173] = {.lex_state = 10, .external_lex_state = 6},
  [174] = {.lex_state = 10, .external_lex_state = 6},
  [175] = {.lex_state = 38, .external_lex_state = 3},
  [176] = {.lex_state = 10, .external_lex_state = 6},
  [177] = {.lex_state = 38, .external_lex_state = 2},
  [178] = {.lex_state = 10, .external_lex_state = 6},
  [179] = {.lex_state = 38, .external_lex_state = 4},
  [180] = {.lex_state = 10, .external_lex_state = 6},
  [181] = {.lex_state = 10, .external_lex_state = 6},
  [182] = {.lex_state = 38, .external_lex_state = 2},
  [183] = {.lex_state = 10, .external_lex_state = 6},
  [184] = {.lex_state = 10, .external_lex_state = 6},
  [185] = {.lex_state = 38, .external_lex_state = 3},
  [186] = {.lex_state = 10, .external_lex_state = 6},
  [187] = {.lex_state = 10, .external_lex_state = 6},
  [188] = {.lex_state = 38, .external_lex_state = 2},
  [189] = {.lex_state = 10, .external_lex_state = 6},
  [190] = {.lex_state = 10, .external_lex_state = 6},
  [191] = {.lex_state = 38, .external_lex_state = 2},
  [192] = {.lex_state = 10, .external_lex_state = 6},
  [193] = {.lex_state = 38, .external_lex_state = 2},
  [194] = {.lex_state = 10, .external_lex_state = 6},
  [195] = {.lex_state = 38, .external_lex_state = 2},
  [196] = {.lex_state = 10, .external_lex_state = 6},
  [197] = {.lex_state = 38, .external_lex_state = 2},
  [198] = {.lex_state = 38, .external_lex_state = 2},
  [199] = {.lex_state = 10, .external_lex_state = 6},
  [200] = {.lex_state = 10, .external_lex_state = 6},
  [201] = {.lex_state = 10, .external_lex_state = 6},
  [202] = {.lex_state = 38, .external_lex_state = 2},
  [203] = {.lex_state = 38, .external_lex_state = 2},
  [204] = {.lex_state = 38, .external_lex_state = 2},
  [205] = {.lex_state = 38, .external_lex_state = 2},
  [206] = {.lex_state = 38, .external_lex_state = 2},
  [207] = {.lex_state = 38, .external_lex_state = 2},
  [208] = {.lex_state = 38, .external_lex_state = 2},
  [209] = {.lex_state = 38, .external_lex_state = 4},
  [210] = {.lex_state = 38, .external_lex_state = 2},
  [211] = {.lex_state = 38, .external_lex_state = 2},
  [212] = {.lex_state = 38, .external_lex_state = 2},
  [213] = {.lex_state = 38, .external_lex_state = 2},
  [214] = {.lex_state = 38, .external_lex_state = 2},
  [215] = {.lex_state = 38, .external_lex_state = 2},
  [216] = {.lex_state = 38, .external_lex_state = 2},
  [217] = {.lex_state = 38, .external_lex_state = 2},
  [218] = {.lex_state = 38, .external_lex_state = 2},
  [219] = {.lex_state = 38, .external_lex_state = 2},
  [220] = {.lex_state = 38, .external_lex_state = 2},
  [221] = {.lex_state = 38, .external_lex_state = 4},
  [222] = {.lex_state = 38, .external_lex_state = 2},
  [223] = {.lex_state = 38, .external_lex_state = 3},
  [224] = {.lex_state = 38, .external_lex_state = 3},
  [225] = {.lex_state = 38, .external_lex_state = 2},
  [226] = {.lex_state = 38, .external_lex_state = 2},
  [227] = {.lex_state = 38, .external_lex_state = 2},
  [228] = {.lex_state = 38, .external_lex_state = 2},
  [229] = {.lex_state = 38, .external_lex_state = 3},
  [230] = {.lex_state = 38, .external_lex_state = 2},
  [231] = {.lex_state = 38, .external_lex_state = 2},
  [232] = {.lex_state = 38, .external_lex_state = 3},
  [233] = {.lex_state = 38, .external_lex_state = 4},
  [234] = {.lex_state = 38, .external_lex_state = 3},
  [235] = {.lex_state = 38, .external_lex_state = 2},
  [236] = {.lex_state = 38, .external_lex_state = 2},
  [237] = {.lex_state = 38, .external_lex_state = 4},
  [238] = {.lex_state = 38, .external_lex_state = 4},
  [239] = {.lex_state = 38, .external_lex_state = 2},
  [240] = {.lex_state = 38, .external_lex_state = 2},
  [241] = {.lex_state = 38, .external_lex_state = 2},
  [242] = {.lex_state = 38, .external_lex_state = 2},
  [243] = {.lex_state = 38, .external_lex_state = 2},
  [244] = {.lex_state = 38, .external_lex_state = 2},
  [245] = {.lex_state = 38, .external_lex_state = 2},
  [246] = {.lex_state = 38, .external_lex_state = 2},
  [247] = {.lex_state = 38, .external_lex_state = 2},
  [248] = {.lex_state = 38, .external_lex_state = 2},
  [249] = {.lex_state = 38, .external_lex_state = 2},
  [250] = {.lex_state = 38, .external_lex_state = 2},
  [251] = {.lex_state = 38, .external_lex_state = 2},
  [252] = {.lex_state = 38, .external_lex_state = 2},
  [253] = {.lex_state = 38, .external_lex_state = 2},
  [254] = {.lex_state = 38, .external_lex_state = 2},
  [255] = {.lex_state = 38, .external_lex_state = 2},
  [256] = {.lex_state = 38, .external_lex_state = 2},
  [257] = {.lex_state = 38, .external_lex_state = 2},
  [258] = {.lex_state = 38, .external_lex_state = 2},
  [259] = {.lex_state = 38, .external_lex_state = 2},
  [260] = {.lex_state = 38, .external_lex_state = 2},
  [261] = {.lex_state = 38, .external_lex_state = 2},
  [262] = {.lex_state = 38, .external_lex_state = 2},
  [263] = {.lex_state = 38, .external_lex_state = 2},
  [264] = {.lex_state = 38, .external_lex_state = 2},
  [265] = {.lex_state = 38, .external_lex_state = 3},
  [266] = {.lex_state = 38, .external_lex_state = 2},
  [267] = {.lex_state = 38, .external_lex_state = 2},
  [268] = {.lex_state = 38, .external_lex_state = 3},
  [269] = {.lex_state = 38, .external_lex_state = 2},
  [270] = {.lex_state = 38, .external_lex_state = 3},
  [271] = {.lex_state = 38, .external_lex_state = 2},
  [272] = {.lex_state = 38, .external_lex_state = 3},
  [273] = {.lex_state = 38, .external_lex_state = 3},
  [274] = {.lex_state = 38, .external_lex_state = 2},
  [275] = {.lex_state = 38, .external_lex_state = 2},
  [276] = {.lex_state = 38, .external_lex_state = 3},
  [277] = {.lex_state = 38, .external_lex_state = 2},
  [278] = {.lex_state = 38, .external_lex_state = 2},
  [279] = {.lex_state = 38, .external_lex_state = 2},
  [280] = {.lex_state = 38, .external_lex_state = 2},
  [281] = {.lex_state = 38, .external_lex_state = 3},
  [282] = {.lex_state = 38, .external_lex_state = 2},
  [283] = {.lex_state = 38, .external_lex_state = 2},
  [284] = {.lex_state = 38, .external_lex_state = 2},
  [285] = {.lex_state = 38, .external_lex_state = 2},
  [286] = {.lex_state = 38, .external_lex_state = 2},
  [287] = {.lex_state = 38, .external_lex_state = 2},
  [288] = {.lex_state = 38, .external_lex_state = 2},
  [289] = {.lex_state = 38, .external_lex_state = 2},
  [290] = {.lex_state = 38, .external_lex_state = 2},
  [291] = {.lex_state = 38, .external_lex_state = 2},
  [292] = {.lex_state = 38, .external_lex_state = 2},
  [293] = {.lex_state = 38, .external_lex_state = 2},
  [294] = {.lex_state = 38, .external_lex_state = 3},
  [295] = {.lex_state = 38, .external_lex_state = 2},
  [296] = {.lex_state = 38, .external_lex_state = 2},
  [297] = {.lex_state = 38, .external_lex_state = 2},
  [298] = {.lex_state = 38, .external_lex_state = 2},
  [299] = {.lex_state = 38, .external_lex_state = 3},
  [300] = {.lex_state = 38, .external_lex_state = 2},
  [301] = {.lex_state = 38, .external_lex_state = 2},
  [302] = {.lex_state = 38, .external_lex_state = 2},
  [303] = {.lex_state = 38, .external_lex_state = 2},
  [304] = {.lex_state = 38, .external_lex_state = 2},
  [305] = {.lex_state = 38, .external_lex_state = 2},
  [306] = {.lex_state = 38, .external_lex_state = 2},
  [307] = {.lex_state = 38, .external_lex_state = 2},
  [308] = {.lex_state = 38, .external_lex_state = 2},
  [309] = {.lex_state = 38, .external_lex_state = 2},
  [310] = {.lex_state = 38, .external_lex_state = 2},
  [311] = {.lex_state = 38, .external_lex_state = 2},
  [312] = {.lex_state = 38, .external_lex_state = 2},
  [313] = {.lex_state = 38, .external_lex_state = 2},
  [314] = {.lex_state = 38, .external_lex_state = 2},
  [315] = {.lex_state = 38, .external_lex_state = 2},
  [316] = {.lex_state = 38, .external_lex_state = 2},
  [317] = {.lex_state = 38, .external_lex_state = 2},
  [318] = {.lex_state = 38, .external_lex_state = 2},
  [319] = {.lex_state = 38, .external_lex_state = 2},
  [320] = {.lex_state = 38, .external_lex_state = 2},
  [321] = {.lex_state = 38, .external_lex_state = 3},
  [322] = {.lex_state = 38, .external_lex_state = 3},
  [323] = {.lex_state = 38, .external_lex_state = 2},
  [324] = {.lex_state = 38, .external_lex_state = 3},
  [325] = {.lex_state = 38, .external_lex_state = 2},
  [326] = {.lex_state = 38, .external_lex_state = 2},
  [327] = {.lex_state = 38, .external_lex_state = 2},
  [328] = {.lex_state = 38, .external_lex_state = 2},
  [329] = {.lex_state = 38, .external_lex_state = 2},
  [330] = {.lex_state = 38, .external_lex_state = 2},
  [331] = {.lex_state = 38, .external_lex_state = 2},
  [332] = {.lex_state = 38, .external_lex_state = 2},
  [333] = {.lex_state = 38, .external_lex_state = 2},
  [334] = {.lex_state = 38, .external_lex_state = 2},
  [335] = {.lex_state = 38, .external_lex_state = 2},
  [336] = {.lex_state = 38, .external_lex_state = 2},
  [337] = {.lex_state = 38, .external_lex_state = 2},
  [338] = {.lex_state = 38, .external_lex_state = 2},
  [339] = {.lex_state = 38, .external_lex_state = 2},
  [340] = {.lex_state = 38, .external_lex_state = 2},
  [341] = {.lex_state = 38, .external_lex_state = 2},
  [342] = {.lex_state = 38, .external_lex_state = 2},
  [343] = {.lex_state = 38, .external_lex_state = 2},
  [344] = {.lex_state = 38, .external_lex_state = 2},
  [345] = {.lex_state = 38, .external_lex_state = 2},
  [346] = {.lex_state = 38, .external_lex_state = 2},
  [347] = {.lex_state = 38, .external_lex_state = 2},
  [348] = {.lex_state = 38, .external_lex_state = 2},
  [349] = {.lex_state = 38, .external_lex_state = 2},
  [350] = {.lex_state = 38, .external_lex_state = 2},
  [351] = {.lex_state = 38, .external_lex_state = 2},
  [352] = {.lex_state = 38, .external_lex_state = 2},
  [353] = {.lex_state = 38, .external_lex_state = 2},
  [354] = {.lex_state = 38, .external_lex_state = 3},
  [355] = {.lex_state = 38, .external_lex_state = 3},
  [356] = {.lex_state = 38, .external_lex_state = 2},
  [357] = {.lex_state = 38, .external_lex_state = 2},
  [358] = {.lex_state = 38, .external_lex_state = 3},
  [359] = {.lex_state = 38, .external_lex_state = 2},
  [360] = {.lex_state = 38, .external_lex_state = 3},
  [361] = {.lex_state = 38, .external_lex_state = 2},
  [362] = {.lex_state = 38, .external_lex_state = 2},
  [363] = {.lex_state = 38, .external_lex_state = 3},
  [364] = {.lex_state = 38, .external_lex_state = 3},
  [365] = {.lex_state = 38, .external_lex_state = 3},
  [366] = {.lex_state = 38, .external_lex_state = 3},
  [367] = {.lex_state = 38, .external_lex_state = 3},
  [368] = {.lex_state = 38, .external_lex_state = 2},
  [369] = {.lex_state = 38, .external_lex_state = 2},
  [370] = {.lex_state = 38, .external_lex_state = 3},
  [371] = {.lex_state = 38, .external_lex_state = 3},
  [372] = {.lex_state = 38, .external_lex_state = 2},
  [373] = {.lex_state = 38, .external_lex_state = 3},
  [374] = {.lex_state = 10, .external_lex_state = 2},
  [375] = {.lex_state = 38, .external_lex_state = 2},
  [376] = {.lex_state = 10, .external_lex_state = 2},
  [377] = {.lex_state = 10, .external_lex_state = 2},
  [378] = {.lex_state = 10},
  [379] = {.lex_state = 38, .external_lex_state = 3},
  [380] = {.lex_state = 38, .external_lex_state = 3},
  [381] = {.lex_state = 10},
  [382] = {.lex_state = 38, .external_lex_state = 3},
  [383] = {.lex_state = 38, .external_lex_state = 3},
  [384] = {.lex_state = 38, .external_lex_state = 2},
  [385] = {.lex_state = 38, .external_lex_state = 3},
  [386] = {.lex_state = 38, .external_lex_state = 3},
  [387] = {.lex_state = 38, .external_lex_state = 3},
  [388] = {.lex_state = 38, .external_lex_state = 3},
  [389] = {.lex_state = 38, .external_lex_state = 3},
  [390] = {.lex_state = 38, .external_lex_state = 3},
  [391] = {.lex_state = 38, .external_lex_state = 3},
  [392] = {.lex_state = 38, .external_lex_state = 3},
  [393] = {.lex_state = 38, .external_lex_state = 3},
  [394] = {.lex_state = 38, .external_lex_state = 3},
  [395] = {.lex_state = 38, .external_lex_state = 3},
  [396] = {.lex_state = 38, .external_lex_state = 3},
  [397] = {.lex_state = 38, .external_lex_state = 3},
  [398] = {.lex_state = 38, .external_lex_state = 2},
  [399] = {.lex_state = 38, .external_lex_state = 3},
  [400] = {.lex_state = 38, .external_lex_state = 3},
  [401] = {.lex_state = 38, .external_lex_state = 2},
  [402] = {.lex_state = 10},
  [403] = {.lex_state = 38, .external_lex_state = 3},
  [404] = {.lex_state = 38, .external_lex_state = 2},
  [405] = {.lex_state = 38, .external_lex_state = 2},
  [406] = {.lex_state = 38, .external_lex_state = 3},
  [407] = {.lex_state = 38, .external_lex_state = 2},
  [408] = {.lex_state = 38, .external_lex_state = 3},
  [409] = {.lex_state = 38, .external_lex_state = 3},
  [410] = {.lex_state = 38, .external_lex_state = 3},
  [411] = {.lex_state = 38, .external_lex_state = 2},
  [412] = {.lex_state = 38, .external_lex_state = 3},
  [413] = {.lex_state = 10},
  [414] = {.lex_state = 10},
  [415] = {.lex_state = 10},
  [416] = {.lex_state = 38, .external_lex_state = 3},
  [417] = {.lex_state = 38, .external_lex_state = 2},
  [418] = {.lex_state = 10},
  [419] = {.lex_state = 38, .external_lex_state = 2},
  [420] = {.lex_state = 10},
  [421] = {.lex_state = 10},
  [422] = {.lex_state = 38, .external_lex_state = 2},
  [423] = {.lex_state = 38, .external_lex_state = 3},
  [424] = {.lex_state = 38, .external_lex_state = 2},
  [425] = {.lex_state = 10},
  [426] = {.lex_state = 38, .external_lex_state = 2},
  [427] = {.lex_state = 38, .external_lex_state = 3},
  [428] = {.lex_state = 38, .external_lex_state = 2},
  [429] = {.lex_state = 38, .external_lex_state = 2},
  [430] = {.lex_state = 38, .external_lex_state = 3},
  [431] = {.lex_state = 10},
  [432] = {.lex_state = 38, .external_lex_state = 2},
  [433] = {.lex_state = 38, .external_lex_state = 3},
  [434] = {.lex_state = 38, .external_lex_state = 3},
  [435] = {.lex_state = 38, .external_lex_state = 2},
  [436] = {.lex_state = 38, .external_lex_state = 2},
  [437] = {.lex_state = 38, .external_lex_state = 2},
  [438] = {.lex_state = 38, .external_lex_state = 3},
  [439] = {.lex_state = 38, .external_lex_state = 2},
  [440] = {.lex_state = 38, .external_lex_state = 2},
  [441] = {.lex_state = 38, .external_lex_state = 2},
  [442] = {.lex_state = 38, .external_lex_state = 3},
  [443] = {.lex_state = 38, .external_lex_state = 2},
  [444] = {.lex_state = 38, .external_lex_state = 3},
  [445] = {.lex_state = 38, .external_lex_state = 3},
  [446] = {.lex_state = 38, .external_lex_state = 2},
  [447] = {.lex_state = 38, .external_lex_state = 2},
  [448] = {.lex_state = 38, .external_lex_state = 2},
  [449] = {.lex_state = 38, .external_lex_state = 2},
  [450] = {.lex_state = 38, .external_lex_state = 2},
  [451] = {.lex_state = 38, .external_lex_state = 2},
  [452] = {.lex_state = 38, .external_lex_state = 2},
  [453] = {.lex_state = 38, .external_lex_state = 2},
  [454] = {.lex_state = 38, .external_lex_state = 3},
  [455] = {.lex_state = 38, .external_lex_state = 2},
  [456] = {.lex_state = 38, .external_lex_state = 2},
  [457] = {.lex_state = 38, .external_lex_state = 2},
  [458] = {.lex_state = 38, .external_lex_state = 3},
  [459] = {.lex_state = 38, .external_lex_state = 2},
  [460] = {.lex_state = 38, .external_lex_state = 2},
  [461] = {.lex_state = 38, .external_lex_state = 2},
  [462] = {.lex_state = 38, .external_lex_state = 3},
  [463] = {.lex_state = 38, .external_lex_state = 2},
  [464] = {.lex_state = 9},
  [465] = {.lex_state = 10, .external_lex_state = 2},
  [466] = {.lex_state = 10, .external_lex_state = 2},
  [467] = {.lex_state = 10},
  [468] = {.lex_state = 10},
  [469] = {.lex_state = 10},
  [470] = {.lex_state = 10},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 10},
  [473] = {.lex_state = 10},
  [474] = {.lex_state = 10},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 10},
  [478] = {.lex_state = 10},
  [479] = {.lex_state = 10},
  [480] = {.lex_state = 10},
  [481] = {.lex_state = 10},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 10},
  [484] = {.lex_state = 10},
  [485] = {.lex_state = 10},
  [486] = {.lex_state = 10},
  [487] = {.lex_state = 10},
  [488] = {.lex_state = 10},
  [489] = {.lex_state = 10},
  [490] = {.lex_state = 10},
  [491] = {.lex_state = 10},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 10},
  [494] = {.lex_state = 10},
  [495] = {.lex_state = 10},
  [496] = {.lex_state = 10},
  [497] = {.lex_state = 10, .external_lex_state = 2},
  [498] = {.lex_state = 10},
  [499] = {.lex_state = 10, .external_lex_state = 2},
  [500] = {.lex_state = 9},
  [501] = {.lex_state = 10, .external_lex_state = 2},
  [502] = {.lex_state = 38, .external_lex_state = 2},
  [503] = {.lex_state = 10},
  [504] = {.lex_state = 38, .external_lex_state = 2},
  [505] = {.lex_state = 38, .external_lex_state = 2},
  [506] = {.lex_state = 10},
  [507] = {.lex_state = 38, .external_lex_state = 2},
  [508] = {.lex_state = 10},
  [509] = {.lex_state = 38, .external_lex_state = 2},
  [510] = {.lex_state = 38, .external_lex_state = 2},
  [511] = {.lex_state = 38, .external_lex_state = 2},
  [512] = {.lex_state = 38, .external_lex_state = 2},
  [513] = {.lex_state = 38, .external_lex_state = 2},
  [514] = {.lex_state = 38, .external_lex_state = 2},
  [515] = {.lex_state = 10},
  [516] = {.lex_state = 10},
  [517] = {.lex_state = 38, .external_lex_state = 2},
  [518] = {.lex_state = 10},
  [519] = {.lex_state = 10},
  [520] = {.lex_state = 10},
  [521] = {.lex_state = 10},
  [522] = {.lex_state = 10},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 38, .external_lex_state = 2},
  [525] = {.lex_state = 38, .external_lex_state = 2},
  [526] = {.lex_state = 38, .external_lex_state = 2},
  [527] = {.lex_state = 38, .external_lex_state = 2},
  [528] = {.lex_state = 38, .external_lex_state = 2},
  [529] = {.lex_state = 38, .external_lex_state = 2},
  [530] = {.lex_state = 38, .external_lex_state = 6},
  [531] = {.lex_state = 38, .external_lex_state = 2},
  [532] = {.lex_state = 38, .external_lex_state = 2},
  [533] = {.lex_state = 38, .external_lex_state = 2},
  [534] = {.lex_state = 38, .external_lex_state = 2},
  [535] = {.lex_state = 10, .external_lex_state = 2},
  [536] = {.lex_state = 38, .external_lex_state = 2},
  [537] = {.lex_state = 38, .external_lex_state = 2},
  [538] = {.lex_state = 38, .external_lex_state = 2},
  [539] = {.lex_state = 9},
  [540] = {.lex_state = 38, .external_lex_state = 2},
  [541] = {.lex_state = 38, .external_lex_state = 2},
  [542] = {.lex_state = 10, .external_lex_state = 2},
  [543] = {.lex_state = 38, .external_lex_state = 6},
  [544] = {.lex_state = 38, .external_lex_state = 2},
  [545] = {.lex_state = 38, .external_lex_state = 2},
  [546] = {.lex_state = 38, .external_lex_state = 2},
  [547] = {.lex_state = 38, .external_lex_state = 2},
  [548] = {.lex_state = 38, .external_lex_state = 2},
  [549] = {.lex_state = 38, .external_lex_state = 2},
  [550] = {.lex_state = 38, .external_lex_state = 2},
  [551] = {.lex_state = 38, .external_lex_state = 2},
  [552] = {.lex_state = 38, .external_lex_state = 2},
  [553] = {.lex_state = 38, .external_lex_state = 2},
  [554] = {.lex_state = 38, .external_lex_state = 2},
  [555] = {.lex_state = 38, .external_lex_state = 2},
  [556] = {.lex_state = 38, .external_lex_state = 2},
  [557] = {.lex_state = 38, .external_lex_state = 2},
  [558] = {.lex_state = 38, .external_lex_state = 2},
  [559] = {.lex_state = 38, .external_lex_state = 2},
  [560] = {.lex_state = 10},
  [561] = {.lex_state = 10},
  [562] = {.lex_state = 10},
  [563] = {.lex_state = 10},
  [564] = {.lex_state = 10},
  [565] = {.lex_state = 10},
  [566] = {.lex_state = 10},
  [567] = {.lex_state = 10},
  [568] = {.lex_state = 10},
  [569] = {.lex_state = 10},
  [570] = {.lex_state = 10},
  [571] = {.lex_state = 10},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 10},
  [575] = {.lex_state = 10},
  [576] = {.lex_state = 10},
  [577] = {.lex_state = 10},
  [578] = {.lex_state = 10},
  [579] = {.lex_state = 10},
  [580] = {.lex_state = 10},
  [581] = {.lex_state = 10},
  [582] = {.lex_state = 10},
  [583] = {.lex_state = 10},
  [584] = {.lex_state = 10},
  [585] = {.lex_state = 10},
  [586] = {.lex_state = 10},
  [587] = {.lex_state = 10},
  [588] = {.lex_state = 10},
  [589] = {.lex_state = 10},
  [590] = {.lex_state = 38},
  [591] = {.lex_state = 38},
  [592] = {.lex_state = 38, .external_lex_state = 6},
  [593] = {.lex_state = 38, .external_lex_state = 6},
  [594] = {.lex_state = 38, .external_lex_state = 6},
  [595] = {.lex_state = 38, .external_lex_state = 6},
  [596] = {.lex_state = 38, .external_lex_state = 6},
  [597] = {.lex_state = 38, .external_lex_state = 6},
  [598] = {.lex_state = 38, .external_lex_state = 6},
  [599] = {.lex_state = 38, .external_lex_state = 6},
  [600] = {.lex_state = 38, .external_lex_state = 6},
  [601] = {.lex_state = 38, .external_lex_state = 6},
  [602] = {.lex_state = 38, .external_lex_state = 6},
  [603] = {.lex_state = 10},
  [604] = {.lex_state = 38, .external_lex_state = 6},
  [605] = {.lex_state = 38, .external_lex_state = 6},
  [606] = {.lex_state = 10},
  [607] = {.lex_state = 38, .external_lex_state = 6},
  [608] = {.lex_state = 38},
  [609] = {.lex_state = 38},
  [610] = {.lex_state = 38, .external_lex_state = 6},
  [611] = {.lex_state = 38},
  [612] = {.lex_state = 38},
  [613] = {.lex_state = 38},
  [614] = {.lex_state = 38},
  [615] = {.lex_state = 38},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 38},
  [618] = {.lex_state = 38},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 38},
  [621] = {.lex_state = 38},
  [622] = {.lex_state = 38},
  [623] = {.lex_state = 38},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 38},
  [626] = {.lex_state = 38},
  [627] = {.lex_state = 38},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 38},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 38},
  [634] = {.lex_state = 38},
  [635] = {.lex_state = 38},
  [636] = {.lex_state = 38},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 38},
  [640] = {.lex_state = 38},
  [641] = {.lex_state = 38},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 38},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 38},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 12, .external_lex_state = 7},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 10, .external_lex_state = 6},
  [670] = {.lex_state = 12, .external_lex_state = 7},
  [671] = {.lex_state = 38},
  [672] = {.lex_state = 12, .external_lex_state = 7},
  [673] = {.lex_state = 0, .external_lex_state = 6},
  [674] = {.lex_state = 0, .external_lex_state = 6},
  [675] = {.lex_state = 12, .external_lex_state = 7},
  [676] = {.lex_state = 12, .external_lex_state = 7},
  [677] = {.lex_state = 12, .external_lex_state = 7},
  [678] = {.lex_state = 38},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 12, .external_lex_state = 7},
  [682] = {.lex_state = 38},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 38},
  [686] = {.lex_state = 12, .external_lex_state = 7},
  [687] = {.lex_state = 38},
  [688] = {.lex_state = 12, .external_lex_state = 7},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 10, .external_lex_state = 6},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 38},
  [693] = {.lex_state = 10, .external_lex_state = 6},
  [694] = {.lex_state = 10},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 38},
  [698] = {.lex_state = 38},
  [699] = {.lex_state = 0, .external_lex_state = 6},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0, .external_lex_state = 6},
  [703] = {.lex_state = 38},
  [704] = {.lex_state = 38},
  [705] = {.lex_state = 10},
  [706] = {.lex_state = 38},
  [707] = {.lex_state = 38},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 38},
  [710] = {.lex_state = 38},
  [711] = {.lex_state = 38},
  [712] = {.lex_state = 38},
  [713] = {.lex_state = 38},
  [714] = {.lex_state = 38},
  [715] = {.lex_state = 10, .external_lex_state = 6},
  [716] = {.lex_state = 38},
  [717] = {.lex_state = 38},
  [718] = {.lex_state = 10},
  [719] = {.lex_state = 38},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 38},
  [722] = {.lex_state = 38},
  [723] = {.lex_state = 38},
  [724] = {.lex_state = 0, .external_lex_state = 6},
  [725] = {.lex_state = 38},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 10},
  [729] = {.lex_state = 12, .external_lex_state = 7},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0, .external_lex_state = 6},
  [732] = {.lex_state = 38},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 12, .external_lex_state = 7},
  [735] = {.lex_state = 38},
  [736] = {.lex_state = 4},
  [737] = {.lex_state = 38},
  [738] = {.lex_state = 0, .external_lex_state = 6},
  [739] = {.lex_state = 38},
  [740] = {.lex_state = 0, .external_lex_state = 6},
  [741] = {.lex_state = 0, .external_lex_state = 6},
  [742] = {.lex_state = 0, .external_lex_state = 6},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 4},
  [750] = {.lex_state = 10},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0, .external_lex_state = 6},
  [753] = {.lex_state = 38},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 4},
  [758] = {.lex_state = 12, .external_lex_state = 7},
  [759] = {.lex_state = 38},
  [760] = {.lex_state = 0, .external_lex_state = 6},
  [761] = {.lex_state = 38},
  [762] = {.lex_state = 10},
  [763] = {.lex_state = 38},
  [764] = {.lex_state = 38},
  [765] = {.lex_state = 38},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0, .external_lex_state = 6},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 38},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0, .external_lex_state = 6},
  [775] = {.lex_state = 38},
  [776] = {.lex_state = 0, .external_lex_state = 6},
  [777] = {.lex_state = 38},
  [778] = {.lex_state = 38},
  [779] = {.lex_state = 0, .external_lex_state = 6},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0, .external_lex_state = 6},
  [783] = {.lex_state = 38},
  [784] = {.lex_state = 38},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0, .external_lex_state = 6},
  [788] = {.lex_state = 0, .external_lex_state = 6},
  [789] = {.lex_state = 0, .external_lex_state = 6},
  [790] = {.lex_state = 0, .external_lex_state = 6},
  [791] = {.lex_state = 0, .external_lex_state = 6},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 38},
  [794] = {.lex_state = 0, .external_lex_state = 6},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 10},
  [797] = {.lex_state = 0, .external_lex_state = 6},
  [798] = {.lex_state = 38},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 38},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0, .external_lex_state = 6},
  [804] = {.lex_state = 0, .external_lex_state = 6},
  [805] = {.lex_state = 38},
  [806] = {.lex_state = 38},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 38},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 38},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 38},
  [821] = {.lex_state = 0, .external_lex_state = 6},
  [822] = {.lex_state = 0, .external_lex_state = 6},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 38},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0, .external_lex_state = 6},
  [829] = {.lex_state = 0, .external_lex_state = 6},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 38},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 38},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0, .external_lex_state = 6},
  [840] = {.lex_state = 38},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0, .external_lex_state = 6},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0, .external_lex_state = 6},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 38},
  [848] = {.lex_state = 38},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 38},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0, .external_lex_state = 6},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0, .external_lex_state = 6},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 38},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 4},
  [880] = {.lex_state = 0, .external_lex_state = 6},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 38},
  [883] = {.lex_state = 0, .external_lex_state = 6},
  [884] = {.lex_state = 0, .external_lex_state = 6},
  [885] = {.lex_state = 38},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 38},
  [888] = {.lex_state = 38},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 38},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 38},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0, .external_lex_state = 6},
  [898] = {.lex_state = 38},
  [899] = {.lex_state = 38},
  [900] = {.lex_state = 38},
  [901] = {.lex_state = 38},
  [902] = {.lex_state = 38},
  [903] = {.lex_state = 0, .external_lex_state = 6},
  [904] = {.lex_state = 0, .external_lex_state = 6},
  [905] = {.lex_state = 0, .external_lex_state = 6},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0, .external_lex_state = 6},
  [908] = {.lex_state = 0, .external_lex_state = 6},
  [909] = {.lex_state = 0, .external_lex_state = 6},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0, .external_lex_state = 6},
  [913] = {.lex_state = 38},
  [914] = {.lex_state = 38},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0, .external_lex_state = 6},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0, .external_lex_state = 6},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0, .external_lex_state = 6},
  [921] = {.lex_state = 11},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0, .external_lex_state = 6},
  [925] = {.lex_state = 0, .external_lex_state = 6},
  [926] = {.lex_state = 0, .external_lex_state = 6},
  [927] = {.lex_state = 0, .external_lex_state = 6},
  [928] = {.lex_state = 0, .external_lex_state = 6},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0, .external_lex_state = 6},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0, .external_lex_state = 6},
  [935] = {.lex_state = 0, .external_lex_state = 6},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 11},
  [938] = {.lex_state = 0, .external_lex_state = 6},
  [939] = {.lex_state = 11},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 11},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 11},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 11},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 38},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 38},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 38},
  [968] = {.lex_state = 38},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 38},
  [989] = {.lex_state = 38},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 38},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 38},
  [997] = {.lex_state = 0, .external_lex_state = 6},
  [998] = {.lex_state = 38},
  [999] = {.lex_state = 38},
  [1000] = {.lex_state = 38},
  [1001] = {.lex_state = 38},
  [1002] = {.lex_state = 38},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 38},
  [1005] = {.lex_state = 38},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 38},
  [1012] = {.lex_state = 38},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 38},
  [1015] = {.lex_state = 38},
  [1016] = {.lex_state = 38},
  [1017] = {.lex_state = 38},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
  },
  [7] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(987),
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(657),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(657),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(39),
    [anon_sym_with] = ACTIONS(41),
    [anon_sym_def] = ACTIONS(43),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
  },
  [2] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(321),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [3] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(746),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(73),
  },
  [4] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(428),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [5] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(372),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [6] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(359),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [7] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(224),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [8] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(365),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [9] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(422),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [10] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(454),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [11] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(426),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [12] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(369),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [13] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(324),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [14] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(394),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [15] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(747),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(73),
  },
  [16] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(392),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [17] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(355),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [18] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(307),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [19] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(242),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [20] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(388),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [21] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(456),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [22] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(455),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [23] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(423),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [24] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(436),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [25] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(448),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [26] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(351),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [27] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(409),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [28] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(340),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [29] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(452),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [30] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(412),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [31] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(416),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [32] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(451),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [33] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(356),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [34] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(326),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [35] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(367),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [36] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(299),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [37] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(433),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [38] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(439),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
  },
  [39] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(379),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [40] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(360),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [41] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(662),
    [sym_block] = STATE(462),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(91),
    [sym__string_start] = ACTIONS(73),
  },
  [42] = {
    [sym__statement] = STATE(47),
    [sym__simple_statements] = STATE(47),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_if_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_try_statement] = STATE(47),
    [sym_with_statement] = STATE(47),
    [sym_function_definition] = STATE(47),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_class_definition] = STATE(47),
    [sym_decorated_definition] = STATE(47),
    [sym_decorator] = STATE(657),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(47),
    [aux_sym_decorated_definition_repeat1] = STATE(657),
    [ts_builtin_sym_end] = ACTIONS(97),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_async] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(39),
    [anon_sym_with] = ACTIONS(41),
    [anon_sym_def] = ACTIONS(43),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(51),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
  },
  [43] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(662),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(73),
  },
  [44] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(662),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_import] = ACTIONS(104),
    [anon_sym_from] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(110),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_assert] = ACTIONS(116),
    [anon_sym_return] = ACTIONS(119),
    [anon_sym_del] = ACTIONS(122),
    [anon_sym_raise] = ACTIONS(125),
    [anon_sym_pass] = ACTIONS(128),
    [anon_sym_break] = ACTIONS(131),
    [anon_sym_continue] = ACTIONS(134),
    [anon_sym_if] = ACTIONS(137),
    [anon_sym_async] = ACTIONS(140),
    [anon_sym_for] = ACTIONS(143),
    [anon_sym_while] = ACTIONS(146),
    [anon_sym_try] = ACTIONS(149),
    [anon_sym_with] = ACTIONS(152),
    [anon_sym_def] = ACTIONS(155),
    [anon_sym_global] = ACTIONS(158),
    [anon_sym_nonlocal] = ACTIONS(161),
    [anon_sym_exec] = ACTIONS(164),
    [anon_sym_class] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(170),
    [anon_sym_not] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(176),
    [anon_sym_DASH] = ACTIONS(176),
    [anon_sym_TILDE] = ACTIONS(176),
    [anon_sym_lambda] = ACTIONS(179),
    [anon_sym_yield] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(185),
    [sym_ellipsis] = ACTIONS(188),
    [anon_sym_LBRACE] = ACTIONS(191),
    [sym_integer] = ACTIONS(194),
    [sym_float] = ACTIONS(188),
    [sym_true] = ACTIONS(194),
    [sym_false] = ACTIONS(194),
    [sym_none] = ACTIONS(194),
    [anon_sym_await] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(200),
    [sym__string_start] = ACTIONS(202),
  },
  [45] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(662),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(205),
    [sym__string_start] = ACTIONS(73),
  },
  [46] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(662),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(662),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(75),
    [anon_sym_async] = ACTIONS(77),
    [anon_sym_for] = ACTIONS(79),
    [anon_sym_while] = ACTIONS(81),
    [anon_sym_try] = ACTIONS(83),
    [anon_sym_with] = ACTIONS(85),
    [anon_sym_def] = ACTIONS(87),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(207),
    [sym__string_start] = ACTIONS(73),
  },
  [47] = {
    [sym__statement] = STATE(47),
    [sym__simple_statements] = STATE(47),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_if_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_try_statement] = STATE(47),
    [sym_with_statement] = STATE(47),
    [sym_function_definition] = STATE(47),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_class_definition] = STATE(47),
    [sym_decorated_definition] = STATE(47),
    [sym_decorator] = STATE(657),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [aux_sym_module_repeat1] = STATE(47),
    [aux_sym_decorated_definition_repeat1] = STATE(657),
    [ts_builtin_sym_end] = ACTIONS(200),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_import] = ACTIONS(104),
    [anon_sym_from] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(110),
    [anon_sym_print] = ACTIONS(113),
    [anon_sym_assert] = ACTIONS(116),
    [anon_sym_return] = ACTIONS(119),
    [anon_sym_del] = ACTIONS(122),
    [anon_sym_raise] = ACTIONS(125),
    [anon_sym_pass] = ACTIONS(128),
    [anon_sym_break] = ACTIONS(131),
    [anon_sym_continue] = ACTIONS(134),
    [anon_sym_if] = ACTIONS(209),
    [anon_sym_async] = ACTIONS(212),
    [anon_sym_for] = ACTIONS(215),
    [anon_sym_while] = ACTIONS(218),
    [anon_sym_try] = ACTIONS(221),
    [anon_sym_with] = ACTIONS(224),
    [anon_sym_def] = ACTIONS(227),
    [anon_sym_global] = ACTIONS(158),
    [anon_sym_nonlocal] = ACTIONS(161),
    [anon_sym_exec] = ACTIONS(164),
    [anon_sym_class] = ACTIONS(230),
    [anon_sym_AT] = ACTIONS(170),
    [anon_sym_not] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(176),
    [anon_sym_DASH] = ACTIONS(176),
    [anon_sym_TILDE] = ACTIONS(176),
    [anon_sym_lambda] = ACTIONS(179),
    [anon_sym_yield] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(185),
    [sym_ellipsis] = ACTIONS(188),
    [anon_sym_LBRACE] = ACTIONS(191),
    [sym_integer] = ACTIONS(194),
    [sym_float] = ACTIONS(188),
    [sym_true] = ACTIONS(194),
    [sym_false] = ACTIONS(194),
    [sym_none] = ACTIONS(194),
    [anon_sym_await] = ACTIONS(197),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(202),
  },
  [48] = {
    [sym_chevron] = STATE(760),
    [sym_named_expression] = STATE(674),
    [sym__expression] = STATE(674),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(674),
    [sym_boolean_operator] = STATE(674),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(674),
    [sym_lambda] = STATE(674),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(674),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(674),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(233),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_COMMA] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(233),
    [anon_sym_print] = ACTIONS(237),
    [anon_sym_GT_GT] = ACTIONS(239),
    [anon_sym_if] = ACTIONS(233),
    [anon_sym_COLON] = ACTIONS(235),
    [anon_sym_in] = ACTIONS(233),
    [anon_sym_EQ] = ACTIONS(233),
    [anon_sym_STAR_STAR] = ACTIONS(233),
    [anon_sym_exec] = ACTIONS(237),
    [anon_sym_AT] = ACTIONS(233),
    [anon_sym_not] = ACTIONS(233),
    [anon_sym_and] = ACTIONS(233),
    [anon_sym_or] = ACTIONS(233),
    [anon_sym_PLUS] = ACTIONS(233),
    [anon_sym_DASH] = ACTIONS(233),
    [anon_sym_SLASH] = ACTIONS(233),
    [anon_sym_PERCENT] = ACTIONS(233),
    [anon_sym_SLASH_SLASH] = ACTIONS(233),
    [anon_sym_PIPE] = ACTIONS(233),
    [anon_sym_AMP] = ACTIONS(233),
    [anon_sym_CARET] = ACTIONS(233),
    [anon_sym_LT_LT] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_LT_GT] = ACTIONS(235),
    [anon_sym_is] = ACTIONS(233),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_PLUS_EQ] = ACTIONS(235),
    [anon_sym_DASH_EQ] = ACTIONS(235),
    [anon_sym_STAR_EQ] = ACTIONS(235),
    [anon_sym_SLASH_EQ] = ACTIONS(235),
    [anon_sym_AT_EQ] = ACTIONS(235),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(235),
    [anon_sym_PERCENT_EQ] = ACTIONS(235),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(235),
    [anon_sym_GT_GT_EQ] = ACTIONS(235),
    [anon_sym_LT_LT_EQ] = ACTIONS(235),
    [anon_sym_AMP_EQ] = ACTIONS(235),
    [anon_sym_CARET_EQ] = ACTIONS(235),
    [anon_sym_PIPE_EQ] = ACTIONS(235),
    [anon_sym_LBRACK] = ACTIONS(235),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(235),
    [sym__newline] = ACTIONS(235),
    [sym__string_start] = ACTIONS(73),
  },
  [49] = {
    [sym__simple_statements] = STATE(370),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(241),
    [sym__indent] = ACTIONS(243),
    [sym__string_start] = ACTIONS(73),
  },
  [50] = {
    [sym__simple_statements] = STATE(393),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(245),
    [sym__indent] = ACTIONS(247),
    [sym__string_start] = ACTIONS(73),
  },
  [51] = {
    [sym__simple_statements] = STATE(289),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(249),
    [sym__indent] = ACTIONS(251),
    [sym__string_start] = ACTIONS(73),
  },
  [52] = {
    [sym__simple_statements] = STATE(234),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(253),
    [sym__indent] = ACTIONS(255),
    [sym__string_start] = ACTIONS(73),
  },
  [53] = {
    [sym__simple_statements] = STATE(371),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(257),
    [sym__indent] = ACTIONS(259),
    [sym__string_start] = ACTIONS(73),
  },
  [54] = {
    [sym__simple_statements] = STATE(446),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(261),
    [sym__indent] = ACTIONS(263),
    [sym__string_start] = ACTIONS(73),
  },
  [55] = {
    [sym__simple_statements] = STATE(460),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(265),
    [sym__indent] = ACTIONS(267),
    [sym__string_start] = ACTIONS(73),
  },
  [56] = {
    [sym__simple_statements] = STATE(398),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(269),
    [sym__indent] = ACTIONS(271),
    [sym__string_start] = ACTIONS(73),
  },
  [57] = {
    [sym__simple_statements] = STATE(391),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(273),
    [sym__indent] = ACTIONS(275),
    [sym__string_start] = ACTIONS(73),
  },
  [58] = {
    [sym__simple_statements] = STATE(357),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym__indent] = ACTIONS(279),
    [sym__string_start] = ACTIONS(73),
  },
  [59] = {
    [sym__simple_statements] = STATE(404),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(281),
    [sym__indent] = ACTIONS(283),
    [sym__string_start] = ACTIONS(73),
  },
  [60] = {
    [sym__simple_statements] = STATE(406),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(285),
    [sym__indent] = ACTIONS(287),
    [sym__string_start] = ACTIONS(73),
  },
  [61] = {
    [sym__simple_statements] = STATE(444),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(289),
    [sym__indent] = ACTIONS(291),
    [sym__string_start] = ACTIONS(73),
  },
  [62] = {
    [sym__simple_statements] = STATE(449),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(293),
    [sym__indent] = ACTIONS(295),
    [sym__string_start] = ACTIONS(73),
  },
  [63] = {
    [sym__simple_statements] = STATE(387),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(297),
    [sym__indent] = ACTIONS(299),
    [sym__string_start] = ACTIONS(73),
  },
  [64] = {
    [sym__simple_statements] = STATE(403),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(301),
    [sym__indent] = ACTIONS(303),
    [sym__string_start] = ACTIONS(73),
  },
  [65] = {
    [sym__simple_statements] = STATE(285),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(305),
    [sym__indent] = ACTIONS(307),
    [sym__string_start] = ACTIONS(73),
  },
  [66] = {
    [sym__simple_statements] = STATE(441),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(309),
    [sym__indent] = ACTIONS(311),
    [sym__string_start] = ACTIONS(73),
  },
  [67] = {
    [sym__simple_statements] = STATE(322),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__string_start] = ACTIONS(73),
  },
  [68] = {
    [sym__simple_statements] = STATE(375),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(317),
    [sym__indent] = ACTIONS(319),
    [sym__string_start] = ACTIONS(73),
  },
  [69] = {
    [sym__simple_statements] = STATE(429),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(321),
    [sym__indent] = ACTIONS(323),
    [sym__string_start] = ACTIONS(73),
  },
  [70] = {
    [sym__simple_statements] = STATE(386),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(325),
    [sym__indent] = ACTIONS(327),
    [sym__string_start] = ACTIONS(73),
  },
  [71] = {
    [sym__simple_statements] = STATE(424),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(329),
    [sym__indent] = ACTIONS(331),
    [sym__string_start] = ACTIONS(73),
  },
  [72] = {
    [sym__simple_statements] = STATE(327),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(333),
    [sym__indent] = ACTIONS(335),
    [sym__string_start] = ACTIONS(73),
  },
  [73] = {
    [sym__simple_statements] = STATE(399),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(337),
    [sym__indent] = ACTIONS(339),
    [sym__string_start] = ACTIONS(73),
  },
  [74] = {
    [sym__simple_statements] = STATE(363),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(341),
    [sym__indent] = ACTIONS(343),
    [sym__string_start] = ACTIONS(73),
  },
  [75] = {
    [sym__simple_statements] = STATE(438),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(345),
    [sym__indent] = ACTIONS(347),
    [sym__string_start] = ACTIONS(73),
  },
  [76] = {
    [sym__simple_statements] = STATE(463),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(349),
    [sym__indent] = ACTIONS(351),
    [sym__string_start] = ACTIONS(73),
  },
  [77] = {
    [sym__simple_statements] = STATE(281),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(353),
    [sym__indent] = ACTIONS(355),
    [sym__string_start] = ACTIONS(73),
  },
  [78] = {
    [sym__simple_statements] = STATE(756),
    [sym_import_statement] = STATE(828),
    [sym_future_import_statement] = STATE(828),
    [sym_import_from_statement] = STATE(828),
    [sym_print_statement] = STATE(828),
    [sym_assert_statement] = STATE(828),
    [sym_expression_statement] = STATE(828),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(828),
    [sym_delete_statement] = STATE(828),
    [sym_raise_statement] = STATE(828),
    [sym_pass_statement] = STATE(828),
    [sym_break_statement] = STATE(828),
    [sym_continue_statement] = STATE(828),
    [sym_global_statement] = STATE(828),
    [sym_nonlocal_statement] = STATE(828),
    [sym_exec_statement] = STATE(828),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(357),
    [sym__indent] = ACTIONS(359),
    [sym__string_start] = ACTIONS(73),
  },
  [79] = {
    [sym__simple_statements] = STATE(366),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(361),
    [sym__indent] = ACTIONS(363),
    [sym__string_start] = ACTIONS(73),
  },
  [80] = {
    [sym__simple_statements] = STATE(435),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(365),
    [sym__indent] = ACTIONS(367),
    [sym__string_start] = ACTIONS(73),
  },
  [81] = {
    [sym__simple_statements] = STATE(755),
    [sym_import_statement] = STATE(828),
    [sym_future_import_statement] = STATE(828),
    [sym_import_from_statement] = STATE(828),
    [sym_print_statement] = STATE(828),
    [sym_assert_statement] = STATE(828),
    [sym_expression_statement] = STATE(828),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(828),
    [sym_delete_statement] = STATE(828),
    [sym_raise_statement] = STATE(828),
    [sym_pass_statement] = STATE(828),
    [sym_break_statement] = STATE(828),
    [sym_continue_statement] = STATE(828),
    [sym_global_statement] = STATE(828),
    [sym_nonlocal_statement] = STATE(828),
    [sym_exec_statement] = STATE(828),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__indent] = ACTIONS(371),
    [sym__string_start] = ACTIONS(73),
  },
  [82] = {
    [sym__simple_statements] = STATE(352),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(373),
    [sym__indent] = ACTIONS(375),
    [sym__string_start] = ACTIONS(73),
  },
  [83] = {
    [sym__simple_statements] = STATE(294),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(377),
    [sym__indent] = ACTIONS(379),
    [sym__string_start] = ACTIONS(73),
  },
  [84] = {
    [sym__simple_statements] = STATE(373),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(381),
    [sym__indent] = ACTIONS(383),
    [sym__string_start] = ACTIONS(73),
  },
  [85] = {
    [sym__simple_statements] = STATE(380),
    [sym_import_statement] = STATE(864),
    [sym_future_import_statement] = STATE(864),
    [sym_import_from_statement] = STATE(864),
    [sym_print_statement] = STATE(864),
    [sym_assert_statement] = STATE(864),
    [sym_expression_statement] = STATE(864),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(864),
    [sym_delete_statement] = STATE(864),
    [sym_raise_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_global_statement] = STATE(864),
    [sym_nonlocal_statement] = STATE(864),
    [sym_exec_statement] = STATE(864),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(385),
    [sym__indent] = ACTIONS(387),
    [sym__string_start] = ACTIONS(73),
  },
  [86] = {
    [sym__simple_statements] = STATE(350),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(389),
    [sym__indent] = ACTIONS(391),
    [sym__string_start] = ACTIONS(73),
  },
  [87] = {
    [sym__simple_statements] = STATE(243),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(393),
    [sym__indent] = ACTIONS(395),
    [sym__string_start] = ACTIONS(73),
  },
  [88] = {
    [sym__simple_statements] = STATE(361),
    [sym_import_statement] = STATE(835),
    [sym_future_import_statement] = STATE(835),
    [sym_import_from_statement] = STATE(835),
    [sym_print_statement] = STATE(835),
    [sym_assert_statement] = STATE(835),
    [sym_expression_statement] = STATE(835),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(835),
    [sym_delete_statement] = STATE(835),
    [sym_raise_statement] = STATE(835),
    [sym_pass_statement] = STATE(835),
    [sym_break_statement] = STATE(835),
    [sym_continue_statement] = STATE(835),
    [sym_global_statement] = STATE(835),
    [sym_nonlocal_statement] = STATE(835),
    [sym_exec_statement] = STATE(835),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(397),
    [sym__indent] = ACTIONS(399),
    [sym__string_start] = ACTIONS(73),
  },
  [89] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(401),
    [sym__string_start] = ACTIONS(73),
  },
  [90] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__string_start] = ACTIONS(73),
  },
  [91] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(405),
    [sym__string_start] = ACTIONS(73),
  },
  [92] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__string_start] = ACTIONS(73),
  },
  [93] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(409),
    [sym__string_start] = ACTIONS(73),
  },
  [94] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__string_start] = ACTIONS(73),
  },
  [95] = {
    [sym_import_statement] = STATE(928),
    [sym_future_import_statement] = STATE(928),
    [sym_import_from_statement] = STATE(928),
    [sym_print_statement] = STATE(928),
    [sym_assert_statement] = STATE(928),
    [sym_expression_statement] = STATE(928),
    [sym_named_expression] = STATE(598),
    [sym_return_statement] = STATE(928),
    [sym_delete_statement] = STATE(928),
    [sym_raise_statement] = STATE(928),
    [sym_pass_statement] = STATE(928),
    [sym_break_statement] = STATE(928),
    [sym_continue_statement] = STATE(928),
    [sym_global_statement] = STATE(928),
    [sym_nonlocal_statement] = STATE(928),
    [sym_exec_statement] = STATE(928),
    [sym_expression_list] = STATE(613),
    [sym__expression] = STATE(598),
    [sym__primary_expression] = STATE(126),
    [sym_not_operator] = STATE(598),
    [sym_boolean_operator] = STATE(598),
    [sym_binary_operator] = STATE(126),
    [sym_unary_operator] = STATE(126),
    [sym_comparison_operator] = STATE(598),
    [sym_lambda] = STATE(598),
    [sym_assignment] = STATE(930),
    [sym_augmented_assignment] = STATE(930),
    [sym_yield] = STATE(930),
    [sym_attribute] = STATE(126),
    [sym_subscript] = STATE(126),
    [sym_call] = STATE(126),
    [sym_list] = STATE(126),
    [sym_list_comprehension] = STATE(126),
    [sym_dictionary] = STATE(126),
    [sym_dictionary_comprehension] = STATE(126),
    [sym_set] = STATE(126),
    [sym_set_comprehension] = STATE(126),
    [sym_parenthesized_expression] = STATE(126),
    [sym_tuple] = STATE(126),
    [sym_generator_expression] = STATE(126),
    [sym_conditional_expression] = STATE(598),
    [sym_concatenated_string] = STATE(126),
    [sym_string] = STATE(109),
    [sym_await] = STATE(598),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_print] = ACTIONS(15),
    [anon_sym_assert] = ACTIONS(17),
    [anon_sym_return] = ACTIONS(19),
    [anon_sym_del] = ACTIONS(21),
    [anon_sym_raise] = ACTIONS(23),
    [anon_sym_pass] = ACTIONS(25),
    [anon_sym_break] = ACTIONS(27),
    [anon_sym_continue] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(45),
    [anon_sym_nonlocal] = ACTIONS(47),
    [anon_sym_exec] = ACTIONS(49),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_lambda] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [sym_ellipsis] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_integer] = ACTIONS(69),
    [sym_float] = ACTIONS(65),
    [sym_true] = ACTIONS(69),
    [sym_false] = ACTIONS(69),
    [sym_none] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_TILDE,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(413), 1,
      anon_sym_from,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(417), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(602), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
    ACTIONS(415), 17,
      sym__newline,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [102] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_TILDE,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(419), 1,
      anon_sym_from,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(417), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(602), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
    ACTIONS(421), 17,
      sym__newline,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [204] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_TILDE,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(417), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(423), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(602), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    ACTIONS(415), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [305] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_TILDE,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(417), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(425), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(602), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    ACTIONS(421), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [406] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(689), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(431), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(435), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [498] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(689), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(455), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(457), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [590] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(463), 1,
      anon_sym_RPAREN,
    ACTIONS(465), 1,
      anon_sym_COMMA,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(859), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(878), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(649), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [688] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(463), 1,
      anon_sym_RPAREN,
    ACTIONS(465), 1,
      anon_sym_COMMA,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(859), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(878), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [786] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(689), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(475), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(477), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [878] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(479), 1,
      anon_sym_RPAREN,
    ACTIONS(481), 1,
      anon_sym_COMMA,
    STATE(377), 1,
      sym_string,
    STATE(872), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(871), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(726), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [976] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(483), 1,
      anon_sym_RPAREN,
    ACTIONS(485), 1,
      anon_sym_COMMA,
    STATE(377), 1,
      sym_string,
    STATE(809), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(810), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(647), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1074] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(689), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(487), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(489), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1166] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(479), 1,
      anon_sym_RPAREN,
    ACTIONS(481), 1,
      anon_sym_COMMA,
    STATE(377), 1,
      sym_string,
    STATE(872), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(871), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(645), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1264] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(135), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(493), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [1327] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(495), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1422] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(497), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1517] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1612] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(850), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(701), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1705] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(507), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1800] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(509), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1895] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(966), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(780), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(700), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1990] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(513), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2085] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(515), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2180] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(517), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(850), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(701), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2273] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(832), 1,
      sym_yield,
    STATE(966), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(780), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(646), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2370] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(519), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(985), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(780), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(644), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2465] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(521), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(947), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(780), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(642), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2560] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(523), 1,
      anon_sym_COMMA,
    ACTIONS(525), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(696), 1,
      sym_pair,
    STATE(889), 1,
      sym_dictionary_splat,
    STATE(891), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(640), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2659] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      sym__string_start,
    STATE(124), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(529), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(527), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [2722] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(534), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2817] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(548), 1,
      anon_sym_EQ,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(552), 1,
      anon_sym_not,
    ACTIONS(556), 1,
      anon_sym_PIPE,
    ACTIONS(558), 1,
      anon_sym_AMP,
    ACTIONS(560), 1,
      anon_sym_CARET,
    ACTIONS(564), 1,
      anon_sym_is,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    STATE(543), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(562), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(546), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(538), 21,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [2908] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(568), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3003] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(874), 1,
      sym_yield,
    STATE(957), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(780), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(648), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3100] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(572), 1,
      anon_sym_COMMA,
    ACTIONS(574), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(668), 1,
      sym_pair,
    STATE(837), 1,
      sym_list_splat,
    STATE(838), 1,
      sym_dictionary_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(641), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3199] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(576), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(855), 1,
      sym_yield,
    STATE(962), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(780), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(650), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3296] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(951), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(780), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(643), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3391] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(684), 1,
      sym_pair,
    STATE(852), 1,
      sym_dictionary_splat,
    STATE(853), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(639), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3490] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(832), 1,
      sym_yield,
    STATE(854), 1,
      sym_list_splat,
    STATE(861), 1,
      sym_parenthesized_list_splat,
    STATE(966), 1,
      sym__collection_elements,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(646), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3589] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(584), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3684] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(124), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(588), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(586), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [3747] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(590), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3842] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(592), 1,
      anon_sym_RPAREN,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3937] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 6,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4011] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(600), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(598), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4079] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(932), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(754), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4171] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4239] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(61), 1,
      anon_sym_yield,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(610), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(938), 4,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4329] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 8,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4401] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(556), 1,
      anon_sym_PIPE,
    ACTIONS(558), 1,
      anon_sym_AMP,
    ACTIONS(560), 1,
      anon_sym_CARET,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(604), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(602), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4481] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4549] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 10,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4619] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(556), 1,
      anon_sym_PIPE,
    ACTIONS(558), 1,
      anon_sym_AMP,
    ACTIONS(560), 1,
      anon_sym_CARET,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(608), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(606), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4699] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(558), 1,
      anon_sym_AMP,
    ACTIONS(560), 1,
      anon_sym_CARET,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4777] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 1,
      anon_sym_DOT,
    ACTIONS(540), 1,
      anon_sym_LPAREN,
    ACTIONS(550), 1,
      anon_sym_STAR_STAR,
    ACTIONS(560), 1,
      anon_sym_CARET,
    ACTIONS(566), 1,
      anon_sym_LBRACK,
    ACTIONS(544), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(554), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(167), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(542), 5,
      anon_sym_STAR,
      anon_sym_AT,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 5,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 29,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [4853] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(61), 1,
      anon_sym_yield,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(610), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(916), 4,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4943] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(61), 1,
      anon_sym_yield,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(610), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(909), 4,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5033] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 1,
      sym__string_start,
    STATE(897), 1,
      sym_string,
    ACTIONS(233), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(235), 31,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5094] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(612), 1,
      anon_sym_from,
    STATE(377), 1,
      sym_string,
    STATE(816), 1,
      sym_expression_list,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(614), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(663), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5183] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(616), 33,
      sym__newline,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(620), 33,
      sym__newline,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5297] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 1,
      anon_sym_COLON_EQ,
    ACTIONS(493), 17,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 31,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5356] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(461), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_yield,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(850), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(701), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(626), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(630), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(634), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(638), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(644), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(642), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [5725] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(646), 1,
      anon_sym_from,
    STATE(109), 1,
      sym_string,
    STATE(883), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(648), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5813] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(656), 1,
      anon_sym_except,
    ACTIONS(658), 1,
      anon_sym_finally,
    STATE(368), 1,
      sym_else_clause,
    STATE(417), 1,
      sym_finally_clause,
    STATE(246), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(650), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(652), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5881] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(656), 1,
      anon_sym_except,
    ACTIONS(658), 1,
      anon_sym_finally,
    STATE(353), 1,
      sym_else_clause,
    STATE(457), 1,
      sym_finally_clause,
    STATE(246), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(660), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(662), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(664), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(668), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(672), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(676), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(684), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(688), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(692), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(696), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6453] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(702), 1,
      anon_sym_except,
    ACTIONS(704), 1,
      anon_sym_finally,
    STATE(364), 1,
      sym_else_clause,
    STATE(382), 1,
      sym_finally_clause,
    STATE(223), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(660), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(662), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [6521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(706), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6577] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(710), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(712), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6721] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(716), 1,
      anon_sym_from,
    STATE(109), 1,
      sym_string,
    STATE(907), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(614), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(718), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(722), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [6921] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(726), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(728), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7065] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(732), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7121] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(702), 1,
      anon_sym_except,
    ACTIONS(704), 1,
      anon_sym_finally,
    STATE(358), 1,
      sym_else_clause,
    STATE(396), 1,
      sym_finally_clause,
    STATE(223), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(650), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(652), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [7189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(736), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(740), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7301] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(744), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(746), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7445] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(750), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7501] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(421), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(692), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(235), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7641] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(415), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(692), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(754), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7781] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(758), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(760), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [7925] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(764), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8013] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(766), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(768), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [8157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(772), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [8213] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(776), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_LBRACK,
      sym__semicolon,
  [8269] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(780), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8356] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8443] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(784), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(661), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8526] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(788), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(786), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(719), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8611] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(792), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8698] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(796), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(794), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(710), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8783] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(798), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8870] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(920), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(800), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8955] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(802), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9042] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(804), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9129] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9216] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(808), 1,
      anon_sym_COMMA,
    ACTIONS(810), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    STATE(817), 1,
      aux_sym__parameters_repeat1,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(661), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9303] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(810), 1,
      anon_sym_RPAREN,
    ACTIONS(812), 1,
      anon_sym_COMMA,
    STATE(377), 1,
      sym_string,
    STATE(856), 1,
      aux_sym__parameters_repeat1,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(661), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9390] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(814), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9477] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(816), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9564] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    ACTIONS(818), 1,
      anon_sym_RBRACK,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9651] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(820), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9738] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(471), 1,
      anon_sym_STAR_STAR,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(929), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(783), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9823] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    ACTIONS(822), 1,
      anon_sym_RBRACE,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9910] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(824), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(702), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9992] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(826), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(748), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_except,
    STATE(223), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(830), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(828), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10132] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(839), 1,
      anon_sym_elif,
    STATE(232), 1,
      aux_sym_if_statement_repeat1,
    STATE(354), 1,
      sym_elif_clause,
    STATE(389), 1,
      sym_else_clause,
    ACTIONS(837), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(835), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10196] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(658), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10278] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(689), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10360] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    STATE(875), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(671), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10444] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(845), 1,
      anon_sym_elif,
    STATE(274), 1,
      aux_sym_if_statement_repeat1,
    STATE(362), 1,
      sym_elif_clause,
    STATE(453), 1,
      sym_else_clause,
    ACTIONS(841), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(843), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10508] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(839), 1,
      anon_sym_elif,
    STATE(270), 1,
      aux_sym_if_statement_repeat1,
    STATE(354), 1,
      sym_elif_clause,
    STATE(390), 1,
      sym_else_clause,
    ACTIONS(849), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(847), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10572] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(786), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(744), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10654] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(503), 1,
      anon_sym_STAR,
    STATE(377), 1,
      sym_string,
    STATE(922), 1,
      sym_list_splat,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(745), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10738] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(839), 1,
      anon_sym_elif,
    STATE(270), 1,
      aux_sym_if_statement_repeat1,
    STATE(354), 1,
      sym_elif_clause,
    STATE(410), 1,
      sym_else_clause,
    ACTIONS(841), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(843), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10802] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(851), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(702), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10884] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    ACTIONS(839), 1,
      anon_sym_elif,
    STATE(229), 1,
      aux_sym_if_statement_repeat1,
    STATE(354), 1,
      sym_elif_clause,
    STATE(400), 1,
      sym_else_clause,
    ACTIONS(855), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(853), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10948] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(695), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(656), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11030] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(857), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(743), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11112] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(859), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(702), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11194] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(861), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(702), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11276] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(659), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(652), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11358] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    STATE(823), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(682), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11442] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(845), 1,
      anon_sym_elif,
    STATE(274), 1,
      aux_sym_if_statement_repeat1,
    STATE(362), 1,
      sym_elif_clause,
    STATE(432), 1,
      sym_else_clause,
    ACTIONS(849), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(847), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11506] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(845), 1,
      anon_sym_elif,
    STATE(228), 1,
      aux_sym_if_statement_repeat1,
    STATE(362), 1,
      sym_elif_clause,
    STATE(384), 1,
      sym_else_clause,
    ACTIONS(837), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(835), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11570] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    ACTIONS(845), 1,
      anon_sym_elif,
    STATE(241), 1,
      aux_sym_if_statement_repeat1,
    STATE(362), 1,
      sym_elif_clause,
    STATE(401), 1,
      sym_else_clause,
    ACTIONS(855), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(853), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11634] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(441), 1,
      anon_sym_lambda,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    STATE(691), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(653), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11716] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    STATE(867), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(685), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11800] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      anon_sym_except,
    STATE(246), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(830), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(828), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11858] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    ACTIONS(790), 1,
      anon_sym_COLON,
    STATE(377), 1,
      sym_string,
    STATE(906), 1,
      sym_slice,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(703), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(868), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11995] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1005), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12076] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(996), 1,
      sym_expression_list,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(663), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12157] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    STATE(833), 1,
      sym_with_item,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(723), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12238] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(988), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12319] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    STATE(840), 1,
      sym_with_item,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(723), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12400] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1004), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12481] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    STATE(888), 1,
      sym_with_item,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(723), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12562] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1016), 1,
      sym_expression_list,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(663), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12643] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    ACTIONS(894), 1,
      anon_sym_COLON,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(717), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12724] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1000), 1,
      sym_expression_list,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(663), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12805] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1002), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12886] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(918), 1,
      sym_expression_list,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(592), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12967] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    STATE(901), 1,
      sym_with_item,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(723), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(898), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13101] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1022), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13182] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    STATE(913), 1,
      sym_with_item,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(723), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(898), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13316] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    STATE(880), 1,
      sym_type,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(699), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(902), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(868), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13503] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    ACTIONS(904), 1,
      anon_sym_COLON,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(707), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13584] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(910), 1,
      anon_sym_elif,
    STATE(270), 1,
      aux_sym_if_statement_repeat1,
    STATE(354), 1,
      sym_elif_clause,
    ACTIONS(908), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(906), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13643] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(1014), 1,
      sym_expression_list,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(663), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13724] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(902), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(913), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13830] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_elif,
    STATE(274), 1,
      aux_sym_if_statement_repeat1,
    STATE(362), 1,
      sym_elif_clause,
    ACTIONS(908), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(906), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13889] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(877), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(920), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(913), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14076] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    STATE(765), 1,
      sym_type,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(687), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(922), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(920), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14210] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(630), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14288] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(924), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14340] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(738), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14418] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(601), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14496] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(795), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(930), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14626] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(602), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14704] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(597), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14782] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(621), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(934), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14912] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(714), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14990] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(771), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15068] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(666), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15146] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(713), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15224] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(934), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [15276] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(697), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15354] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15432] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(753), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15510] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(618), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(936), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [15640] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(692), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15718] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(763), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15796] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(594), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15874] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(680), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15952] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(617), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16030] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(764), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16108] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(793), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(942), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [16238] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(627), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16316] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(708), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16394] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(798), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16472] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(622), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16550] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(636), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16628] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(725), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16706] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(661), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16784] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(767), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16862] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(698), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16940] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(805), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17018] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(724), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17096] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(702), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17174] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(752), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(944), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(930), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17356] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(801), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(942), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17486] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(722), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(936), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17616] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(926), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(924), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17668] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(595), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17746] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(716), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17824] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(712), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17902] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(599), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17980] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(711), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18058] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(673), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18136] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(777), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18214] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(709), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18292] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(704), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18370] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(678), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18448] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(683), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18526] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(742), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(946), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(944), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [18656] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(876), 1,
      anon_sym_not,
    ACTIONS(880), 1,
      anon_sym_lambda,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(890), 1,
      anon_sym_await,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(884), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(888), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(706), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(498), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18734] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(778), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18812] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(596), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18890] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(721), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18968] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(593), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19046] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(59), 1,
      anon_sym_lambda,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(71), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(65), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(69), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(600), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(126), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19124] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(634), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19202] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(730), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19280] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym_identifier,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(437), 1,
      anon_sym_not,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(451), 1,
      anon_sym_await,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(473), 1,
      anon_sym_lambda,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(445), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(449), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(751), 8,
      sym_named_expression,
      sym__expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(378), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19358] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(443), 1,
      sym_else_clause,
    ACTIONS(948), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(950), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(954), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19464] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(450), 1,
      sym_else_clause,
    ACTIONS(956), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(958), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19519] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_finally,
    STATE(447), 1,
      sym_finally_clause,
    ACTIONS(960), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(964), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(954), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19676] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(440), 1,
      sym_else_clause,
    ACTIONS(968), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(970), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(974), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19782] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(704), 1,
      anon_sym_finally,
    STATE(383), 1,
      sym_finally_clause,
    ACTIONS(978), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(976), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19837] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(437), 1,
      sym_else_clause,
    ACTIONS(980), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(982), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19892] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(458), 1,
      sym_else_clause,
    ACTIONS(980), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(982), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(411), 1,
      sym_else_clause,
    ACTIONS(984), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(986), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(964), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(974), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20104] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(704), 1,
      anon_sym_finally,
    STATE(434), 1,
      sym_finally_clause,
    ACTIONS(960), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20159] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(385), 1,
      sym_else_clause,
    ACTIONS(990), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(988), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20214] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(430), 1,
      sym_else_clause,
    ACTIONS(956), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(958), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20269] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(445), 1,
      sym_else_clause,
    ACTIONS(968), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(970), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20324] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_finally,
    STATE(459), 1,
      sym_finally_clause,
    ACTIONS(978), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(976), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20379] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_else,
    STATE(461), 1,
      sym_else_clause,
    ACTIONS(990), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(988), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20434] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(442), 1,
      sym_else_clause,
    ACTIONS(948), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(950), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20489] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_else,
    STATE(397), 1,
      sym_else_clause,
    ACTIONS(984), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(986), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20544] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(994), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(996), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20644] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      sym__string_start,
    STATE(374), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(529), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(527), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20698] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(996), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20748] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(374), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(588), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(586), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20802] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(376), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(493), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20856] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(548), 1,
      anon_sym_EQ,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1017), 1,
      anon_sym_not,
    ACTIONS(1021), 1,
      anon_sym_PIPE,
    ACTIONS(1023), 1,
      anon_sym_AMP,
    ACTIONS(1025), 1,
      anon_sym_CARET,
    ACTIONS(1029), 1,
      anon_sym_is,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    STATE(590), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1027), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1011), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(538), 12,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_and,
      anon_sym_or,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [20940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(994), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1033), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21039] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 25,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [21104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1037), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21202] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1043), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1045), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1049), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21349] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1053), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21398] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1057), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1041), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1043), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1061), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1065), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1069), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1073), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21692] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1077), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21741] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(662), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(976), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21839] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1083), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1081), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1087), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1089), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21986] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1093), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1093), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22084] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1021), 1,
      anon_sym_PIPE,
    ACTIONS(1023), 1,
      anon_sym_AMP,
    ACTIONS(1025), 1,
      anon_sym_CARET,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(608), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(606), 20,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [22157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1097), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1089), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(652), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1087), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22353] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1103), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(650), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(652), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1105), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1109), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1083), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1081), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22598] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1113), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22647] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 23,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [22714] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1025), 1,
      anon_sym_CARET,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 22,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [22783] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1023), 1,
      anon_sym_AMP,
    ACTIONS(1025), 1,
      anon_sym_CARET,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 21,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [22854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1117), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(976), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22952] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 27,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [23015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(662), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23064] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 30,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [23123] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1021), 1,
      anon_sym_PIPE,
    ACTIONS(1023), 1,
      anon_sym_AMP,
    ACTIONS(1025), 1,
      anon_sym_CARET,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    ACTIONS(1007), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1009), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1019), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(604), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1015), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(602), 20,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [23196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1077), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1121), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1073), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23343] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 30,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [23402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1059), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1057), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1103), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1069), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1067), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1065), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23598] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1125), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23647] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1003), 1,
      anon_sym_DOT,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    ACTIONS(1013), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1031), 1,
      anon_sym_LBRACK,
    STATE(477), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(600), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(598), 30,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [23706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1061), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1129), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1133), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1049), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1139), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1143), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1147), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1145), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1149), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1151), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24098] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1155), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1157), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1159), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1161), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1163), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1161), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1157), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1159), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1155), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1147), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1145), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1133), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1129), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1097), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1127), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1125), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1119), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1117), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1113), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1111), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1109), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1149), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1151), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1107), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1105), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1121), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1143), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1037), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1035), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1033), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1045), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 11,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1139), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 11,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1053), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [25274] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_COLON_EQ,
    ACTIONS(493), 6,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 33,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(620), 35,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(616), 35,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25420] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(688), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(666), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(664), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(732), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25561] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(776), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(712), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25655] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(696), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25702] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(706), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(692), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(728), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(668), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(676), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(750), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(754), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(644), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(642), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(746), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(740), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(672), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(684), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(760), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(638), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(736), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(718), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(722), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(772), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(235), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(768), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(630), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26736] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(634), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(626), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26830] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(499), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(493), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 28,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [26877] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1181), 1,
      anon_sym_not,
    ACTIONS(1185), 1,
      anon_sym_PIPE,
    ACTIONS(1187), 1,
      anon_sym_AMP,
    ACTIONS(1189), 1,
      anon_sym_CARET,
    ACTIONS(1193), 1,
      anon_sym_is,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(608), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1191), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(538), 6,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1175), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
  [26952] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(501), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(588), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(586), 28,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [26999] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1197), 1,
      anon_sym_EQ,
    ACTIONS(493), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 29,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [27046] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 1,
      sym__string_start,
    STATE(501), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(529), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(527), 28,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [27093] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      sym__string_start,
    ACTIONS(1204), 1,
      anon_sym_not,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1206), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1202), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(522), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27153] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(600), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(598), 24,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [27205] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(1026), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27265] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(958), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1212), 1,
      anon_sym_EQ,
    ACTIONS(233), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(235), 29,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [27369] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(1020), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27429] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1185), 1,
      anon_sym_PIPE,
    ACTIONS(1187), 1,
      anon_sym_AMP,
    ACTIONS(1189), 1,
      anon_sym_CARET,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(608), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(606), 14,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [27495] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(1216), 1,
      anon_sym_in,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1218), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1214), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(606), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27555] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(1222), 1,
      anon_sym_not,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1224), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1220), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(421), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27615] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(994), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27675] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(1228), 1,
      anon_sym_not,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1230), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1226), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(144), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27735] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(1021), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27795] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    STATE(1028), 1,
      sym_variables,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1210), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1208), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(603), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27855] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 17,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [27915] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1189), 1,
      anon_sym_CARET,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 16,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [27977] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    ACTIONS(1232), 1,
      anon_sym_in,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1218), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1214), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(606), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28037] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1187), 1,
      anon_sym_AMP,
    ACTIONS(1189), 1,
      anon_sym_CARET,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 15,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28101] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 21,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28157] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 24,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28209] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(594), 19,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28267] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1185), 1,
      anon_sym_PIPE,
    ACTIONS(1187), 1,
      anon_sym_AMP,
    ACTIONS(1189), 1,
      anon_sym_CARET,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    ACTIONS(604), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1173), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1183), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1179), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(602), 14,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28333] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    ACTIONS(1177), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1195), 1,
      anon_sym_LBRACK,
    STATE(570), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(596), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(594), 24,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
  [28385] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(447), 1,
      anon_sym_LBRACE,
    ACTIONS(453), 1,
      sym__string_start,
    STATE(377), 1,
      sym_string,
    ACTIONS(433), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1236), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(439), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1234), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(402), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28442] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1240), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1238), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(138), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28499] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1244), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1242), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(141), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28556] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1248), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1246), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(143), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28613] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1230), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1226), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(144), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28670] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1252), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1250), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(145), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28727] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 1,
      anon_sym_EQ,
    ACTIONS(1257), 1,
      anon_sym_not,
    ACTIONS(1263), 1,
      anon_sym_is,
    STATE(530), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1260), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1254), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(602), 21,
      sym__newline,
      anon_sym_from,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [28778] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1268), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1266), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(148), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28835] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1272), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1270), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(508), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28892] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1276), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1274), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(523), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28949] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1280), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1278), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(147), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [29006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(620), 29,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_LBRACK,
  [29047] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1284), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1282), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(521), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [29104] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    ACTIONS(882), 1,
      anon_sym_LBRACK,
    ACTIONS(886), 1,
      anon_sym_LBRACE,
    ACTIONS(892), 1,
      sym__string_start,
    STATE(497), 1,
      sym_string,
    ACTIONS(874), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1206), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(878), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1202), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(522), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [29161] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(109), 1,
      sym_string,
    ACTIONS(237), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(1288), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(57), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(1286), 5,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
    STATE(146), 16,
      sym__primary_expression,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [29218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 1,
      anon_sym_COLON_EQ,
    ACTIONS(493), 5,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 27,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT