#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1136
#define LARGE_STATE_COUNT 184
#define SYMBOL_COUNT 229
#define ALIAS_COUNT 7
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_if = 15,
  anon_sym_else = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_new = 53,
  anon_sym_PLUS_EQ = 54,
  anon_sym_DASH_EQ = 55,
  anon_sym_STAR_EQ = 56,
  anon_sym_SLASH_EQ = 57,
  anon_sym_PERCENT_EQ = 58,
  anon_sym_CARET_EQ = 59,
  anon_sym_AMP_EQ = 60,
  anon_sym_PIPE_EQ = 61,
  anon_sym_GT_GT_EQ = 62,
  anon_sym_GT_GT_GT_EQ = 63,
  anon_sym_LT_LT_EQ = 64,
  anon_sym_STAR_STAR_EQ = 65,
  anon_sym_AMP_AMP_EQ = 66,
  anon_sym_PIPE_PIPE_EQ = 67,
  anon_sym_QMARK_QMARK_EQ = 68,
  anon_sym_DOT_DOT_DOT = 69,
  anon_sym_QMARK = 70,
  anon_sym_AMP_AMP = 71,
  anon_sym_PIPE_PIPE = 72,
  anon_sym_GT_GT = 73,
  anon_sym_GT_GT_GT = 74,
  anon_sym_LT_LT = 75,
  anon_sym_AMP = 76,
  anon_sym_CARET = 77,
  anon_sym_PIPE = 78,
  anon_sym_PLUS = 79,
  anon_sym_DASH = 80,
  anon_sym_PERCENT = 81,
  anon_sym_STAR_STAR = 82,
  anon_sym_LT_EQ = 83,
  anon_sym_EQ_EQ = 84,
  anon_sym_EQ_EQ_EQ = 85,
  anon_sym_BANG_EQ = 86,
  anon_sym_BANG_EQ_EQ = 87,
  anon_sym_GT_EQ = 88,
  anon_sym_QMARK_QMARK = 89,
  anon_sym_instanceof = 90,
  anon_sym_BANG = 91,
  anon_sym_TILDE = 92,
  anon_sym_typeof = 93,
  anon_sym_void = 94,
  anon_sym_delete = 95,
  anon_sym_PLUS_PLUS = 96,
  anon_sym_DASH_DASH = 97,
  anon_sym_DQUOTE = 98,
  aux_sym_string_token1 = 99,
  anon_sym_SQUOTE = 100,
  aux_sym_string_token2 = 101,
  sym_escape_sequence = 102,
  sym_comment = 103,
  anon_sym_BQUOTE = 104,
  anon_sym_DOLLAR_LBRACE = 105,
  anon_sym_SLASH2 = 106,
  sym_regex_pattern = 107,
  sym_regex_flags = 108,
  sym_number = 109,
  anon_sym_target = 110,
  sym_this = 111,
  sym_super = 112,
  sym_true = 113,
  sym_false = 114,
  sym_null = 115,
  sym_undefined = 116,
  anon_sym_AT = 117,
  anon_sym_static = 118,
  anon_sym_get = 119,
  anon_sym_set = 120,
  sym__automatic_semicolon = 121,
  sym__template_chars = 122,
  sym_program = 123,
  sym_export_statement = 124,
  sym_export_clause = 125,
  sym__import_export_specifier = 126,
  sym__declaration = 127,
  sym_import = 128,
  sym_import_statement = 129,
  sym_import_clause = 130,
  sym__from_clause = 131,
  sym_namespace_import = 132,
  sym_named_imports = 133,
  sym_expression_statement = 134,
  sym_variable_declaration = 135,
  sym_lexical_declaration = 136,
  sym_variable_declarator = 137,
  sym_statement_block = 138,
  sym_if_statement = 139,
  sym_switch_statement = 140,
  sym_for_statement = 141,
  sym_for_in_statement = 142,
  sym__for_header = 143,
  sym_while_statement = 144,
  sym_do_statement = 145,
  sym_try_statement = 146,
  sym_with_statement = 147,
  sym_break_statement = 148,
  sym_continue_statement = 149,
  sym_debugger_statement = 150,
  sym_return_statement = 151,
  sym_throw_statement = 152,
  sym_empty_statement = 153,
  sym_labeled_statement = 154,
  sym_switch_body = 155,
  sym_switch_case = 156,
  sym_switch_default = 157,
  sym_catch_clause = 158,
  sym_finally_clause = 159,
  sym_parenthesized_expression = 160,
  sym__expression = 161,
  sym_yield_expression = 162,
  sym_object = 163,
  sym_assignment_pattern = 164,
  sym_array = 165,
  sym_jsx_element = 166,
  sym_jsx_fragment = 167,
  sym_jsx_expression = 168,
  sym_jsx_opening_element = 169,
  sym_nested_identifier = 170,
  sym_jsx_namespace_name = 171,
  sym_jsx_closing_element = 172,
  sym_jsx_self_closing_element = 173,
  sym_jsx_attribute = 174,
  sym_class = 175,
  sym_class_declaration = 176,
  sym_class_heritage = 177,
  sym_function = 178,
  sym_function_declaration = 179,
  sym_generator_function = 180,
  sym_generator_function_declaration = 181,
  sym_arrow_function = 182,
  sym_call_expression = 183,
  sym_new_expression = 184,
  sym_await_expression = 185,
  sym_member_expression = 186,
  sym_subscript_expression = 187,
  sym_assignment_expression = 188,
  sym_augmented_assignment_expression = 189,
  sym__initializer = 190,
  sym_spread_element = 191,
  sym_ternary_expression = 192,
  sym_binary_expression = 193,
  sym_unary_expression = 194,
  sym_update_expression = 195,
  sym_sequence_expression = 196,
  sym_string = 197,
  sym_template_string = 198,
  sym_template_substitution = 199,
  sym_regex = 200,
  sym_meta_property = 201,
  sym_arguments = 202,
  sym_decorator = 203,
  sym_decorator_member_expression = 204,
  sym_decorator_call_expression = 205,
  sym_class_body = 206,
  sym_public_field_definition = 207,
  sym_formal_parameters = 208,
  sym_rest_parameter = 209,
  sym_method_definition = 210,
  sym_pair = 211,
  sym__property_name = 212,
  sym_computed_property_name = 213,
  aux_sym_program_repeat1 = 214,
  aux_sym_export_statement_repeat1 = 215,
  aux_sym_export_clause_repeat1 = 216,
  aux_sym_named_imports_repeat1 = 217,
  aux_sym_variable_declaration_repeat1 = 218,
  aux_sym_switch_body_repeat1 = 219,
  aux_sym_object_repeat1 = 220,
  aux_sym_array_repeat1 = 221,
  aux_sym_jsx_element_repeat1 = 222,
  aux_sym_jsx_opening_element_repeat1 = 223,
  aux_sym_string_repeat1 = 224,
  aux_sym_string_repeat2 = 225,
  aux_sym_template_string_repeat1 = 226,
  aux_sym_class_body_repeat1 = 227,
  aux_sym_formal_parameters_repeat1 = 228,
  alias_sym_array_pattern = 229,
  alias_sym_export_specifier = 230,
  alias_sym_import_specifier = 231,
  alias_sym_object_pattern = 232,
  alias_sym_property_identifier = 233,
  alias_sym_shorthand_property_identifier = 234,
  alias_sym_statement_identifier = 235,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "??=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "??",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "_import_export_specifier",
  [sym__declaration] = "_declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__expression] = "_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_array] = "array",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_rest_parameter] = "rest_parameter",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_array_pattern] = "array_pattern",
  [alias_sym_export_specifier] = "export_specifier",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_object_pattern] = "object_pattern",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym__declaration] = sym__declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__expression] = sym__expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_array] = sym_array,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_rest_parameter] = sym_rest_parameter,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_array_pattern] = alias_sym_array_pattern,
  [alias_sym_export_specifier] = alias_sym_export_specifier,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_object_pattern] = alias_sym_object_pattern,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[107] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 2, .length = 1},
  [8] = {.index = 3, .length = 1},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 4, .length = 1},
  [11] = {.index = 5, .length = 2},
  [12] = {.index = 7, .length = 2},
  [14] = {.index = 9, .length = 2},
  [15] = {.index = 11, .length = 2},
  [16] = {.index = 13, .length = 2},
  [18] = {.index = 15, .length = 1},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 16, .length = 2},
  [21] = {.index = 16, .length = 2},
  [22] = {.index = 18, .length = 2},
  [23] = {.index = 20, .length = 2},
  [24] = {.index = 22, .length = 3},
  [27] = {.index = 25, .length = 2},
  [28] = {.index = 27, .length = 2},
  [29] = {.index = 29, .length = 2},
  [30] = {.index = 31, .length = 2},
  [31] = {.index = 33, .length = 1},
  [32] = {.index = 34, .length = 1},
  [33] = {.index = 35, .length = 1},
  [34] = {.index = 36, .length = 1},
  [35] = {.index = 37, .length = 1},
  [36] = {.index = 38, .length = 1},
  [37] = {.index = 39, .length = 2},
  [38] = {.index = 41, .length = 1},
  [39] = {.index = 42, .length = 1},
  [40] = {.index = 43, .length = 2},
  [41] = {.index = 45, .length = 2},
  [42] = {.index = 47, .length = 2},
  [43] = {.index = 49, .length = 2},
  [44] = {.index = 51, .length = 2},
  [45] = {.index = 51, .length = 2},
  [46] = {.index = 43, .length = 2},
  [47] = {.index = 45, .length = 2},
  [48] = {.index = 47, .length = 2},
  [49] = {.index = 7, .length = 2},
  [50] = {.index = 53, .length = 3},
  [51] = {.index = 43, .length = 2},
  [52] = {.index = 43, .length = 2},
  [53] = {.index = 56, .length = 2},
  [54] = {.index = 58, .length = 2},
  [55] = {.index = 60, .length = 2},
  [56] = {.index = 62, .length = 1},
  [57] = {.index = 63, .length = 1},
  [58] = {.index = 64, .length = 2},
  [59] = {.index = 43, .length = 2},
  [60] = {.index = 66, .length = 2},
  [61] = {.index = 68, .length = 3},
  [62] = {.index = 64, .length = 2},
  [63] = {.index = 71, .length = 1},
  [64] = {.index = 72, .length = 3},
  [65] = {.index = 75, .length = 3},
  [66] = {.index = 78, .length = 2},
  [67] = {.index = 80, .length = 2},
  [68] = {.index = 82, .length = 2},
  [69] = {.index = 84, .length = 1},
  [70] = {.index = 85, .length = 2},
  [71] = {.index = 87, .length = 1},
  [72] = {.index = 88, .length = 2},
  [73] = {.index = 90, .length = 2},
  [74] = {.index = 92, .length = 2},
  [75] = {.index = 94, .length = 2},
  [76] = {.index = 92, .length = 2},
  [77] = {.index = 96, .length = 2},
  [78] = {.index = 98, .length = 3},
  [79] = {.index = 101, .length = 2},
  [80] = {.index = 103, .length = 3},
  [81] = {.index = 106, .length = 2},
  [82] = {.index = 108, .length = 2},
  [83] = {.index = 110, .length = 3},
  [84] = {.index = 113, .length = 2},
  [85] = {.index = 115, .length = 2},
  [86] = {.index = 117, .length = 2},
  [87] = {.index = 119, .length = 3},
  [88] = {.index = 122, .length = 3},
  [89] = {.index = 125, .length = 1},
  [90] = {.index = 126, .length = 2},
  [91] = {.index = 128, .length = 3},
  [92] = {.index = 131, .length = 2},
  [93] = {.index = 131, .length = 2},
  [94] = {.index = 133, .length = 3},
  [95] = {.index = 131, .length = 2},
  [96] = {.index = 131, .length = 2},
  [97] = {.index = 136, .length = 3},
  [98] = {.index = 139, .length = 2},
  [99] = {.index = 139, .length = 2},
  [100] = {.index = 139, .length = 2},
  [101] = {.index = 139, .length = 2},
  [102] = {.index = 141, .length = 4},
  [103] = {.index = 145, .length = 2},
  [104] = {.index = 145, .length = 2},
  [105] = {.index = 145, .length = 2},
  [106] = {.index = 147, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_argument, 0},
    {field_operator, 1},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_source, 1},
  [16] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [18] =
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_body, 2},
    {field_value, 1},
  [22] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_condition, 1},
  [27] =
    {field_body, 1},
    {field_handler, 2},
  [29] =
    {field_body, 1},
    {field_finalizer, 2},
  [31] =
    {field_body, 2},
    {field_object, 1},
  [33] =
    {field_label, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_attribute, 0},
  [36] =
    {field_pattern, 1},
  [37] =
    {field_member, 0},
  [38] =
    {field_property, 0},
  [39] =
    {field_body, 2},
    {field_name, 1},
  [41] =
    {field_body, 2},
  [42] =
    {field_label, 0},
  [43] =
    {field_left, 0},
    {field_right, 2},
  [45] =
    {field_object, 0},
    {field_property, 2},
  [47] =
    {field_body, 2},
    {field_parameter, 0},
  [49] =
    {field_body, 2},
    {field_parameters, 1},
  [51] =
    {field_arguments, 2},
    {field_constructor, 1},
  [53] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [56] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [58] =
    {field_body, 2},
    {field_parameters, 0},
  [60] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [62] =
    {field_source, 2, .inherited = true},
  [63] =
    {field_value, 2},
  [64] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [66] =
    {field_key, 0},
    {field_value, 2},
  [68] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [71] =
    {field_value, 1},
  [72] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [75] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [78] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [80] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [82] =
    {field_flags, 3},
    {field_pattern, 1},
  [84] =
    {field_property, 1},
  [85] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [87] =
    {field_member, 1, .inherited = true},
  [88] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [90] =
    {field_body, 3},
    {field_name, 1},
  [92] =
    {field_body, 3},
    {field_parameter, 1},
  [94] =
    {field_body, 3},
    {field_parameters, 2},
  [96] =
    {field_body, 3},
    {field_parameters, 1},
  [98] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [101] =
    {field_index, 2},
    {field_object, 0},
  [103] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [106] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [108] =
    {field_alias, 2},
    {field_name, 0},
  [110] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [113] =
    {field_body, 1},
    {field_condition, 3},
  [115] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [117] =
    {field_body, 4},
    {field_parameters, 3},
  [119] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [122] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [125] =
    {field_name, 2},
  [126] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [128] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [131] =
    {field_left, 1},
    {field_right, 3},
  [133] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [136] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [139] =
    {field_left, 2},
    {field_right, 4},
  [141] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [145] =
    {field_body, 4},
    {field_parameter, 2},
  [147] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static TSSymbol ts_alias_sequences[107][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [6] = {
    [0] = alias_sym_object_pattern,
  },
  [7] = {
    [0] = alias_sym_array_pattern,
  },
  [9] = {
    [1] = sym_identifier,
  },
  [13] = {
    [1] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [20] = {
    [0] = alias_sym_object_pattern,
  },
  [21] = {
    [0] = alias_sym_array_pattern,
  },
  [25] = {
    [1] = alias_sym_object_pattern,
  },
  [26] = {
    [1] = alias_sym_array_pattern,
  },
  [31] = {
    [1] = alias_sym_statement_identifier,
  },
  [39] = {
    [0] = alias_sym_statement_identifier,
  },
  [40] = {
    [0] = sym_identifier,
  },
  [41] = {
    [0] = sym_identifier,
    [2] = alias_sym_property_identifier,
  },
  [42] = {
    [0] = sym_identifier,
  },
  [44] = {
    [1] = sym_identifier,
  },
  [47] = {
    [2] = alias_sym_property_identifier,
  },
  [49] = {
    [0] = sym_identifier,
  },
  [51] = {
    [0] = alias_sym_object_pattern,
  },
  [52] = {
    [0] = alias_sym_array_pattern,
  },
  [58] = {
    [1] = alias_sym_export_specifier,
  },
  [59] = {
    [0] = alias_sym_shorthand_property_identifier,
  },
  [62] = {
    [1] = alias_sym_import_specifier,
  },
  [74] = {
    [1] = sym_identifier,
  },
  [92] = {
    [1] = sym_identifier,
  },
  [95] = {
    [1] = alias_sym_object_pattern,
  },
  [96] = {
    [1] = alias_sym_array_pattern,
  },
  [98] = {
    [2] = sym_identifier,
  },
  [100] = {
    [2] = alias_sym_object_pattern,
  },
  [101] = {
    [2] = alias_sym_array_pattern,
  },
  [104] = {
    [2] = alias_sym_object_pattern,
  },
  [105] = {
    [2] = alias_sym_array_pattern,
  },
};

static inline bool sym_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    (0 <= lookahead && lookahead <= '#') ||
    ('%' <= lookahead && lookahead <= '/') ||
    (':' <= lookahead && lookahead <= '@') ||
    ('[' <= lookahead && lookahead <= '^') ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~') ||
    lookahead == 160 ||
    lookahead == 8203 ||
    lookahead == 8288 ||
    lookahead == 65279;
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(191);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(192);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(156);
      if (lookahead != 0) ADVANCE(157);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(152);
      if (lookahead == '\r') ADVANCE(166);
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(170);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(163);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(159);
      if (lookahead == '\r') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(170);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(177);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(62);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '~') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(192);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          lookahead != '@' &&
          lookahead != '~') ADVANCE(192);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(192);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(192);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(173);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(111);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(20)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead)) ADVANCE(192);
      END_STATE();
    case 21:
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 25:
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == 'u') ADVANCE(30);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(170);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(170);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 29:
      if (lookahead == '{') ADVANCE(175);
      END_STATE();
    case 30:
      if (lookahead == '{') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 37:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(183);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(184);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(192);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 57:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 58:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(191);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(192);
      END_STATE();
    case 59:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead)) ADVANCE(192);
      END_STATE();
    case 60:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(151);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '\'') ADVANCE(158);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(181);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '@') ADVANCE(193);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '`') ADVANCE(174);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(148);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(192);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(136);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(139);
      if (lookahead == '>') ADVANCE(95);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(95);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(143);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(143);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(173);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(17);
      if (lookahead != 0) ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(17);
      if (lookahead != 0) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(145);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(144);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(115);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(114);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '|') ADVANCE(117);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(116);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(149);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(149);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(150);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(150);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(154);
      if (lookahead == '/') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(164);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(161);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(161);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(164);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(152);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(159);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(192);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(165);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(169);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(173);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(27);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(179);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(192);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == '0') ADVANCE(186);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(37);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(45);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(180);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(189);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(180);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(190);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(192);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(175);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 60},
  [2] = {.lex_state = 60},
  [3] = {.lex_state = 60},
  [4] = {.lex_state = 60},
  [5] = {.lex_state = 60},
  [6] = {.lex_state = 60},
  [7] = {.lex_state = 60},
  [8] = {.lex_state = 60},
  [9] = {.lex_state = 60},
  [10] = {.lex_state = 60},
  [11] = {.lex_state = 60},
  [12] = {.lex_state = 60},
  [13] = {.lex_state = 60},
  [14] = {.lex_state = 60},
  [15] = {.lex_state = 60},
  [16] = {.lex_state = 60},
  [17] = {.lex_state = 60},
  [18] = {.lex_state = 60},
  [19] = {.lex_state = 60},
  [20] = {.lex_state = 60},
  [21] = {.lex_state = 60},
  [22] = {.lex_state = 60},
  [23] = {.lex_state = 60},
  [24] = {.lex_state = 60},
  [25] = {.lex_state = 60},
  [26] = {.lex_state = 60},
  [27] = {.lex_state = 60},
  [28] = {.lex_state = 60},
  [29] = {.lex_state = 60},
  [30] = {.lex_state = 60},
  [31] = {.lex_state = 60},
  [32] = {.lex_state = 60},
  [33] = {.lex_state = 60},
  [34] = {.lex_state = 60},
  [35] = {.lex_state = 60},
  [36] = {.lex_state = 60},
  [37] = {.lex_state = 60},
  [38] = {.lex_state = 60},
  [39] = {.lex_state = 60},
  [40] = {.lex_state = 60},
  [41] = {.lex_state = 60},
  [42] = {.lex_state = 60},
  [43] = {.lex_state = 59},
  [44] = {.lex_state = 59, .external_lex_state = 2},
  [45] = {.lex_state = 59, .external_lex_state = 2},
  [46] = {.lex_state = 59, .external_lex_state = 2},
  [47] = {.lex_state = 59, .external_lex_state = 2},
  [48] = {.lex_state = 59, .external_lex_state = 2},
  [49] = {.lex_state = 59, .external_lex_state = 2},
  [50] = {.lex_state = 59, .external_lex_state = 2},
  [51] = {.lex_state = 59, .external_lex_state = 2},
  [52] = {.lex_state = 59, .external_lex_state = 2},
  [53] = {.lex_state = 59, .external_lex_state = 2},
  [54] = {.lex_state = 59, .external_lex_state = 2},
  [55] = {.lex_state = 59, .external_lex_state = 2},
  [56] = {.lex_state = 59, .external_lex_state = 2},
  [57] = {.lex_state = 59, .external_lex_state = 2},
  [58] = {.lex_state = 59, .external_lex_state = 2},
  [59] = {.lex_state = 59, .external_lex_state = 2},
  [60] = {.lex_state = 60},
  [61] = {.lex_state = 60},
  [62] = {.lex_state = 60},
  [63] = {.lex_state = 60},
  [64] = {.lex_state = 60},
  [65] = {.lex_state = 60},
  [66] = {.lex_state = 60},
  [67] = {.lex_state = 60},
  [68] = {.lex_state = 60},
  [69] = {.lex_state = 60},
  [70] = {.lex_state = 60},
  [71] = {.lex_state = 60},
  [72] = {.lex_state = 60},
  [73] = {.lex_state = 60},
  [74] = {.lex_state = 60},
  [75] = {.lex_state = 60},
  [76] = {.lex_state = 60, .external_lex_state = 2},
  [77] = {.lex_state = 60},
  [78] = {.lex_state = 60},
  [79] = {.lex_state = 60},
  [80] = {.lex_state = 60},
  [81] = {.lex_state = 60},
  [82] = {.lex_state = 60},
  [83] = {.lex_state = 60},
  [84] = {.lex_state = 60},
  [85] = {.lex_state = 60},
  [86] = {.lex_state = 60},
  [87] = {.lex_state = 60},
  [88] = {.lex_state = 60},
  [89] = {.lex_state = 7},
  [90] = {.lex_state = 60},
  [91] = {.lex_state = 60},
  [92] = {.lex_state = 60},
  [93] = {.lex_state = 60},
  [94] = {.lex_state = 7},
  [95] = {.lex_state = 60},
  [96] = {.lex_state = 60},
  [97] = {.lex_state = 60},
  [98] = {.lex_state = 60},
  [99] = {.lex_state = 60},
  [100] = {.lex_state = 60},
  [101] = {.lex_state = 60},
  [102] = {.lex_state = 60},
  [103] = {.lex_state = 60},
  [104] = {.lex_state = 60},
  [105] = {.lex_state = 60},
  [106] = {.lex_state = 60},
  [107] = {.lex_state = 60},
  [108] = {.lex_state = 60},
  [109] = {.lex_state = 60},
  [110] = {.lex_state = 60},
  [111] = {.lex_state = 60},
  [112] = {.lex_state = 60},
  [113] = {.lex_state = 60},
  [114] = {.lex_state = 60},
  [115] = {.lex_state = 60},
  [116] = {.lex_state = 60},
  [117] = {.lex_state = 60},
  [118] = {.lex_state = 60},
  [119] = {.lex_state = 60},
  [120] = {.lex_state = 60},
  [121] = {.lex_state = 60},
  [122] = {.lex_state = 60},
  [123] = {.lex_state = 60},
  [124] = {.lex_state = 60},
  [125] = {.lex_state = 60},
  [126] = {.lex_state = 60},
  [127] = {.lex_state = 60},
  [128] = {.lex_state = 60},
  [129] = {.lex_state = 60},
  [130] = {.lex_state = 60},
  [131] = {.lex_state = 60},
  [132] = {.lex_state = 60},
  [133] = {.lex_state = 8, .external_lex_state = 2},
  [134] = {.lex_state = 8, .external_lex_state = 2},
  [135] = {.lex_state = 60},
  [136] = {.lex_state = 60},
  [137] = {.lex_state = 60},
  [138] = {.lex_state = 60},
  [139] = {.lex_state = 60},
  [140] = {.lex_state = 60},
  [141] = {.lex_state = 60},
  [142] = {.lex_state = 60},
  [143] = {.lex_state = 60},
  [144] = {.lex_state = 60},
  [145] = {.lex_state = 60},
  [146] = {.lex_state = 60},
  [147] = {.lex_state = 60},
  [148] = {.lex_state = 60},
  [149] = {.lex_state = 60},
  [150] = {.lex_state = 60},
  [151] = {.lex_state = 60},
  [152] = {.lex_state = 60},
  [153] = {.lex_state = 60},
  [154] = {.lex_state = 60},
  [155] = {.lex_state = 60},
  [156] = {.lex_state = 60},
  [157] = {.lex_state = 60},
  [158] = {.lex_state = 60},
  [159] = {.lex_state = 60},
  [160] = {.lex_state = 60},
  [161] = {.lex_state = 60},
  [162] = {.lex_state = 60},
  [163] = {.lex_state = 60},
  [164] = {.lex_state = 60},
  [165] = {.lex_state = 60},
  [166] = {.lex_state = 60},
  [167] = {.lex_state = 60},
  [168] = {.lex_state = 60},
  [169] = {.lex_state = 60},
  [170] = {.lex_state = 60},
  [171] = {.lex_state = 60},
  [172] = {.lex_state = 60},
  [173] = {.lex_state = 60},
  [174] = {.lex_state = 60},
  [175] = {.lex_state = 60},
  [176] = {.lex_state = 60},
  [177] = {.lex_state = 60},
  [178] = {.lex_state = 60},
  [179] = {.lex_state = 60},
  [180] = {.lex_state = 8, .external_lex_state = 2},
  [181] = {.lex_state = 8, .external_lex_state = 2},
  [182] = {.lex_state = 8, .external_lex_state = 2},
  [183] = {.lex_state = 8, .external_lex_state = 2},
  [184] = {.lex_state = 60, .external_lex_state = 2},
  [185] = {.lex_state = 8},
  [186] = {.lex_state = 60, .external_lex_state = 2},
  [187] = {.lex_state = 8},
  [188] = {.lex_state = 60},
  [189] = {.lex_state = 60},
  [190] = {.lex_state = 60},
  [191] = {.lex_state = 8, .external_lex_state = 2},
  [192] = {.lex_state = 8, .external_lex_state = 2},
  [193] = {.lex_state = 60},
  [194] = {.lex_state = 8, .external_lex_state = 2},
  [195] = {.lex_state = 8, .external_lex_state = 2},
  [196] = {.lex_state = 8, .external_lex_state = 2},
  [197] = {.lex_state = 60, .external_lex_state = 2},
  [198] = {.lex_state = 60, .external_lex_state = 2},
  [199] = {.lex_state = 8},
  [200] = {.lex_state = 60, .external_lex_state = 2},
  [201] = {.lex_state = 60, .external_lex_state = 2},
  [202] = {.lex_state = 60},
  [203] = {.lex_state = 60, .external_lex_state = 2},
  [204] = {.lex_state = 60, .external_lex_state = 2},
  [205] = {.lex_state = 60, .external_lex_state = 2},
  [206] = {.lex_state = 60},
  [207] = {.lex_state = 60},
  [208] = {.lex_state = 60},
  [209] = {.lex_state = 60, .external_lex_state = 2},
  [210] = {.lex_state = 60},
  [211] = {.lex_state = 60, .external_lex_state = 2},
  [212] = {.lex_state = 60},
  [213] = {.lex_state = 60, .external_lex_state = 2},
  [214] = {.lex_state = 60, .external_lex_state = 2},
  [215] = {.lex_state = 60, .external_lex_state = 2},
  [216] = {.lex_state = 60, .external_lex_state = 2},
  [217] = {.lex_state = 60, .external_lex_state = 2},
  [218] = {.lex_state = 60},
  [219] = {.lex_state = 60},
  [220] = {.lex_state = 60},
  [221] = {.lex_state = 60},
  [222] = {.lex_state = 60},
  [223] = {.lex_state = 60},
  [224] = {.lex_state = 60},
  [225] = {.lex_state = 60},
  [226] = {.lex_state = 60},
  [227] = {.lex_state = 60},
  [228] = {.lex_state = 60},
  [229] = {.lex_state = 60},
  [230] = {.lex_state = 60},
  [231] = {.lex_state = 60},
  [232] = {.lex_state = 60},
  [233] = {.lex_state = 60},
  [234] = {.lex_state = 60},
  [235] = {.lex_state = 60},
  [236] = {.lex_state = 60},
  [237] = {.lex_state = 60},
  [238] = {.lex_state = 60},
  [239] = {.lex_state = 60},
  [240] = {.lex_state = 60},
  [241] = {.lex_state = 60},
  [242] = {.lex_state = 60},
  [243] = {.lex_state = 60},
  [244] = {.lex_state = 60},
  [245] = {.lex_state = 60},
  [246] = {.lex_state = 60},
  [247] = {.lex_state = 60},
  [248] = {.lex_state = 60},
  [249] = {.lex_state = 60},
  [250] = {.lex_state = 60},
  [251] = {.lex_state = 60},
  [252] = {.lex_state = 60},
  [253] = {.lex_state = 60},
  [254] = {.lex_state = 60},
  [255] = {.lex_state = 60},
  [256] = {.lex_state = 60},
  [257] = {.lex_state = 60},
  [258] = {.lex_state = 60},
  [259] = {.lex_state = 60},
  [260] = {.lex_state = 60},
  [261] = {.lex_state = 60},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 8},
  [264] = {.lex_state = 8},
  [265] = {.lex_state = 8},
  [266] = {.lex_state = 8, .external_lex_state = 2},
  [267] = {.lex_state = 8, .external_lex_state = 2},
  [268] = {.lex_state = 8},
  [269] = {.lex_state = 8},
  [270] = {.lex_state = 8},
  [271] = {.lex_state = 8},
  [272] = {.lex_state = 8},
  [273] = {.lex_state = 8},
  [274] = {.lex_state = 8},
  [275] = {.lex_state = 8, .external_lex_state = 2},
  [276] = {.lex_state = 8, .external_lex_state = 2},
  [277] = {.lex_state = 8, .external_lex_state = 2},
  [278] = {.lex_state = 8},
  [279] = {.lex_state = 8, .external_lex_state = 2},
  [280] = {.lex_state = 8, .external_lex_state = 2},
  [281] = {.lex_state = 8, .external_lex_state = 2},
  [282] = {.lex_state = 8, .external_lex_state = 2},
  [283] = {.lex_state = 60},
  [284] = {.lex_state = 60},
  [285] = {.lex_state = 8, .external_lex_state = 2},
  [286] = {.lex_state = 8, .external_lex_state = 2},
  [287] = {.lex_state = 60},
  [288] = {.lex_state = 8, .external_lex_state = 2},
  [289] = {.lex_state = 8, .external_lex_state = 2},
  [290] = {.lex_state = 8, .external_lex_state = 2},
  [291] = {.lex_state = 8, .external_lex_state = 2},
  [292] = {.lex_state = 8, .external_lex_state = 2},
  [293] = {.lex_state = 60},
  [294] = {.lex_state = 60},
  [295] = {.lex_state = 60},
  [296] = {.lex_state = 60},
  [297] = {.lex_state = 60},
  [298] = {.lex_state = 8, .external_lex_state = 2},
  [299] = {.lex_state = 8, .external_lex_state = 2},
  [300] = {.lex_state = 60},
  [301] = {.lex_state = 8},
  [302] = {.lex_state = 8, .external_lex_state = 2},
  [303] = {.lex_state = 8, .external_lex_state = 2},
  [304] = {.lex_state = 8},
  [305] = {.lex_state = 8},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 8},
  [308] = {.lex_state = 8},
  [309] = {.lex_state = 8},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 59},
  [312] = {.lex_state = 59},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 59},
  [315] = {.lex_state = 59, .external_lex_state = 2},
  [316] = {.lex_state = 59},
  [317] = {.lex_state = 59},
  [318] = {.lex_state = 59},
  [319] = {.lex_state = 59},
  [320] = {.lex_state = 59},
  [321] = {.lex_state = 59},
  [322] = {.lex_state = 59},
  [323] = {.lex_state = 59},
  [324] = {.lex_state = 59},
  [325] = {.lex_state = 59},
  [326] = {.lex_state = 59},
  [327] = {.lex_state = 59},
  [328] = {.lex_state = 59},
  [329] = {.lex_state = 59},
  [330] = {.lex_state = 59},
  [331] = {.lex_state = 59},
  [332] = {.lex_state = 59},
  [333] = {.lex_state = 59},
  [334] = {.lex_state = 59},
  [335] = {.lex_state = 59},
  [336] = {.lex_state = 59},
  [337] = {.lex_state = 59},
  [338] = {.lex_state = 59, .external_lex_state = 2},
  [339] = {.lex_state = 59},
  [340] = {.lex_state = 59},
  [341] = {.lex_state = 59},
  [342] = {.lex_state = 59},
  [343] = {.lex_state = 59},
  [344] = {.lex_state = 59},
  [345] = {.lex_state = 59},
  [346] = {.lex_state = 59},
  [347] = {.lex_state = 59},
  [348] = {.lex_state = 59},
  [349] = {.lex_state = 59},
  [350] = {.lex_state = 59},
  [351] = {.lex_state = 59},
  [352] = {.lex_state = 59},
  [353] = {.lex_state = 59},
  [354] = {.lex_state = 59},
  [355] = {.lex_state = 59},
  [356] = {.lex_state = 9},
  [357] = {.lex_state = 59, .external_lex_state = 2},
  [358] = {.lex_state = 59},
  [359] = {.lex_state = 59},
  [360] = {.lex_state = 59, .external_lex_state = 2},
  [361] = {.lex_state = 59},
  [362] = {.lex_state = 59},
  [363] = {.lex_state = 59},
  [364] = {.lex_state = 59},
  [365] = {.lex_state = 59, .external_lex_state = 2},
  [366] = {.lex_state = 59, .external_lex_state = 2},
  [367] = {.lex_state = 59},
  [368] = {.lex_state = 59, .external_lex_state = 2},
  [369] = {.lex_state = 59},
  [370] = {.lex_state = 59},
  [371] = {.lex_state = 59, .external_lex_state = 2},
  [372] = {.lex_state = 59, .external_lex_state = 2},
  [373] = {.lex_state = 59, .external_lex_state = 2},
  [374] = {.lex_state = 59, .external_lex_state = 2},
  [375] = {.lex_state = 59},
  [376] = {.lex_state = 59, .external_lex_state = 2},
  [377] = {.lex_state = 59, .external_lex_state = 2},
  [378] = {.lex_state = 59, .external_lex_state = 2},
  [379] = {.lex_state = 59},
  [380] = {.lex_state = 59},
  [381] = {.lex_state = 59},
  [382] = {.lex_state = 59},
  [383] = {.lex_state = 59, .external_lex_state = 2},
  [384] = {.lex_state = 59, .external_lex_state = 2},
  [385] = {.lex_state = 59, .external_lex_state = 2},
  [386] = {.lex_state = 59},
  [387] = {.lex_state = 59, .external_lex_state = 2},
  [388] = {.lex_state = 59},
  [389] = {.lex_state = 59},
  [390] = {.lex_state = 59, .external_lex_state = 2},
  [391] = {.lex_state = 59, .external_lex_state = 2},
  [392] = {.lex_state = 59},
  [393] = {.lex_state = 59, .external_lex_state = 2},
  [394] = {.lex_state = 59, .external_lex_state = 2},
  [395] = {.lex_state = 59, .external_lex_state = 2},
  [396] = {.lex_state = 59},
  [397] = {.lex_state = 59},
  [398] = {.lex_state = 59},
  [399] = {.lex_state = 59},
  [400] = {.lex_state = 59},
  [401] = {.lex_state = 59},
  [402] = {.lex_state = 59},
  [403] = {.lex_state = 59, .external_lex_state = 2},
  [404] = {.lex_state = 59, .external_lex_state = 2},
  [405] = {.lex_state = 59, .external_lex_state = 2},
  [406] = {.lex_state = 59},
  [407] = {.lex_state = 59},
  [408] = {.lex_state = 59, .external_lex_state = 2},
  [409] = {.lex_state = 59, .external_lex_state = 2},
  [410] = {.lex_state = 59, .external_lex_state = 2},
  [411] = {.lex_state = 59, .external_lex_state = 2},
  [412] = {.lex_state = 59, .external_lex_state = 2},
  [413] = {.lex_state = 59, .external_lex_state = 2},
  [414] = {.lex_state = 59, .external_lex_state = 2},
  [415] = {.lex_state = 59, .external_lex_state = 2},
  [416] = {.lex_state = 59, .external_lex_state = 2},
  [417] = {.lex_state = 59},
  [418] = {.lex_state = 59},
  [419] = {.lex_state = 59, .external_lex_state = 2},
  [420] = {.lex_state = 59, .external_lex_state = 2},
  [421] = {.lex_state = 59, .external_lex_state = 2},
  [422] = {.lex_state = 59, .external_lex_state = 2},
  [423] = {.lex_state = 59, .external_lex_state = 2},
  [424] = {.lex_state = 59, .external_lex_state = 2},
  [425] = {.lex_state = 59, .external_lex_state = 2},
  [426] = {.lex_state = 59},
  [427] = {.lex_state = 59},
  [428] = {.lex_state = 59, .external_lex_state = 2},
  [429] = {.lex_state = 59},
  [430] = {.lex_state = 59},
  [431] = {.lex_state = 59},
  [432] = {.lex_state = 59},
  [433] = {.lex_state = 59, .external_lex_state = 2},
  [434] = {.lex_state = 59},
  [435] = {.lex_state = 59},
  [436] = {.lex_state = 59},
  [437] = {.lex_state = 59, .external_lex_state = 2},
  [438] = {.lex_state = 59, .external_lex_state = 2},
  [439] = {.lex_state = 59},
  [440] = {.lex_state = 59},
  [441] = {.lex_state = 59},
  [442] = {.lex_state = 59},
  [443] = {.lex_state = 59},
  [444] = {.lex_state = 59},
  [445] = {.lex_state = 59},
  [446] = {.lex_state = 59},
  [447] = {.lex_state = 59},
  [448] = {.lex_state = 59},
  [449] = {.lex_state = 59, .external_lex_state = 2},
  [450] = {.lex_state = 59},
  [451] = {.lex_state = 59, .external_lex_state = 2},
  [452] = {.lex_state = 59, .external_lex_state = 2},
  [453] = {.lex_state = 59, .external_lex_state = 2},
  [454] = {.lex_state = 59},
  [455] = {.lex_state = 59, .external_lex_state = 2},
  [456] = {.lex_state = 59, .external_lex_state = 2},
  [457] = {.lex_state = 59},
  [458] = {.lex_state = 59, .external_lex_state = 2},
  [459] = {.lex_state = 59, .external_lex_state = 2},
  [460] = {.lex_state = 59},
  [461] = {.lex_state = 59, .external_lex_state = 2},
  [462] = {.lex_state = 59, .external_lex_state = 2},
  [463] = {.lex_state = 59, .external_lex_state = 2},
  [464] = {.lex_state = 59, .external_lex_state = 2},
  [465] = {.lex_state = 59},
  [466] = {.lex_state = 59, .external_lex_state = 2},
  [467] = {.lex_state = 59, .external_lex_state = 2},
  [468] = {.lex_state = 59, .external_lex_state = 2},
  [469] = {.lex_state = 59},
  [470] = {.lex_state = 59, .external_lex_state = 2},
  [471] = {.lex_state = 59, .external_lex_state = 2},
  [472] = {.lex_state = 59, .external_lex_state = 2},
  [473] = {.lex_state = 59, .external_lex_state = 2},
  [474] = {.lex_state = 59, .external_lex_state = 2},
  [475] = {.lex_state = 9, .external_lex_state = 2},
  [476] = {.lex_state = 59, .external_lex_state = 2},
  [477] = {.lex_state = 59},
  [478] = {.lex_state = 59},
  [479] = {.lex_state = 59},
  [480] = {.lex_state = 59, .external_lex_state = 2},
  [481] = {.lex_state = 59, .external_lex_state = 2},
  [482] = {.lex_state = 59, .external_lex_state = 2},
  [483] = {.lex_state = 59, .external_lex_state = 2},
  [484] = {.lex_state = 59, .external_lex_state = 2},
  [485] = {.lex_state = 59},
  [486] = {.lex_state = 59},
  [487] = {.lex_state = 59},
  [488] = {.lex_state = 59, .external_lex_state = 2},
  [489] = {.lex_state = 59, .external_lex_state = 2},
  [490] = {.lex_state = 59, .external_lex_state = 2},
  [491] = {.lex_state = 59, .external_lex_state = 2},
  [492] = {.lex_state = 59, .external_lex_state = 2},
  [493] = {.lex_state = 59, .external_lex_state = 2},
  [494] = {.lex_state = 59},
  [495] = {.lex_state = 59},
  [496] = {.lex_state = 59},
  [497] = {.lex_state = 59},
  [498] = {.lex_state = 59},
  [499] = {.lex_state = 59},
  [500] = {.lex_state = 59},
  [501] = {.lex_state = 59, .external_lex_state = 2},
  [502] = {.lex_state = 59},
  [503] = {.lex_state = 59},
  [504] = {.lex_state = 59},
  [505] = {.lex_state = 59},
  [506] = {.lex_state = 59, .external_lex_state = 2},
  [507] = {.lex_state = 59, .external_lex_state = 2},
  [508] = {.lex_state = 59, .external_lex_state = 2},
  [509] = {.lex_state = 59},
  [510] = {.lex_state = 59},
  [511] = {.lex_state = 59, .external_lex_state = 2},
  [512] = {.lex_state = 59},
  [513] = {.lex_state = 59, .external_lex_state = 2},
  [514] = {.lex_state = 59, .external_lex_state = 2},
  [515] = {.lex_state = 59, .external_lex_state = 2},
  [516] = {.lex_state = 59, .external_lex_state = 2},
  [517] = {.lex_state = 59, .external_lex_state = 2},
  [518] = {.lex_state = 59, .external_lex_state = 2},
  [519] = {.lex_state = 59, .external_lex_state = 2},
  [520] = {.lex_state = 59},
  [521] = {.lex_state = 59, .external_lex_state = 2},
  [522] = {.lex_state = 59, .external_lex_state = 2},
  [523] = {.lex_state = 59, .external_lex_state = 2},
  [524] = {.lex_state = 59},
  [525] = {.lex_state = 59, .external_lex_state = 2},
  [526] = {.lex_state = 59, .external_lex_state = 2},
  [527] = {.lex_state = 59},
  [528] = {.lex_state = 59},
  [529] = {.lex_state = 59, .external_lex_state = 2},
  [530] = {.lex_state = 59, .external_lex_state = 2},
  [531] = {.lex_state = 59},
  [532] = {.lex_state = 59, .external_lex_state = 2},
  [533] = {.lex_state = 59, .external_lex_state = 2},
  [534] = {.lex_state = 59, .external_lex_state = 2},
  [535] = {.lex_state = 59, .external_lex_state = 2},
  [536] = {.lex_state = 59, .external_lex_state = 2},
  [537] = {.lex_state = 59, .external_lex_state = 2},
  [538] = {.lex_state = 59, .external_lex_state = 2},
  [539] = {.lex_state = 59},
  [540] = {.lex_state = 59, .external_lex_state = 2},
  [541] = {.lex_state = 59, .external_lex_state = 2},
  [542] = {.lex_state = 59},
  [543] = {.lex_state = 59, .external_lex_state = 2},
  [544] = {.lex_state = 59, .external_lex_state = 2},
  [545] = {.lex_state = 59},
  [546] = {.lex_state = 59, .external_lex_state = 2},
  [547] = {.lex_state = 59, .external_lex_state = 2},
  [548] = {.lex_state = 59},
  [549] = {.lex_state = 59, .external_lex_state = 2},
  [550] = {.lex_state = 59, .external_lex_state = 2},
  [551] = {.lex_state = 59, .external_lex_state = 2},
  [552] = {.lex_state = 59, .external_lex_state = 2},
  [553] = {.lex_state = 59, .external_lex_state = 2},
  [554] = {.lex_state = 59, .external_lex_state = 2},
  [555] = {.lex_state = 59, .external_lex_state = 2},
  [556] = {.lex_state = 59, .external_lex_state = 2},
  [557] = {.lex_state = 59},
  [558] = {.lex_state = 59, .external_lex_state = 2},
  [559] = {.lex_state = 59},
  [560] = {.lex_state = 59},
  [561] = {.lex_state = 59, .external_lex_state = 2},
  [562] = {.lex_state = 59, .external_lex_state = 2},
  [563] = {.lex_state = 59, .external_lex_state = 2},
  [564] = {.lex_state = 59},
  [565] = {.lex_state = 59},
  [566] = {.lex_state = 59},
  [567] = {.lex_state = 59},
  [568] = {.lex_state = 59},
  [569] = {.lex_state = 59},
  [570] = {.lex_state = 59},
  [571] = {.lex_state = 59},
  [572] = {.lex_state = 59},
  [573] = {.lex_state = 59},
  [574] = {.lex_state = 59},
  [575] = {.lex_state = 59},
  [576] = {.lex_state = 59},
  [577] = {.lex_state = 60},
  [578] = {.lex_state = 60},
  [579] = {.lex_state = 60},
  [580] = {.lex_state = 60},
  [581] = {.lex_state = 60},
  [582] = {.lex_state = 60},
  [583] = {.lex_state = 60},
  [584] = {.lex_state = 60},
  [585] = {.lex_state = 60},
  [586] = {.lex_state = 60},
  [587] = {.lex_state = 60},
  [588] = {.lex_state = 60},
  [589] = {.lex_state = 60},
  [590] = {.lex_state = 60},
  [591] = {.lex_state = 60},
  [592] = {.lex_state = 60},
  [593] = {.lex_state = 60},
  [594] = {.lex_state = 60},
  [595] = {.lex_state = 60},
  [596] = {.lex_state = 60},
  [597] = {.lex_state = 60},
  [598] = {.lex_state = 60},
  [599] = {.lex_state = 60, .external_lex_state = 2},
  [600] = {.lex_state = 60, .external_lex_state = 2},
  [601] = {.lex_state = 60, .external_lex_state = 2},
  [602] = {.lex_state = 60},
  [603] = {.lex_state = 60},
  [604] = {.lex_state = 59},
  [605] = {.lex_state = 60},
  [606] = {.lex_state = 60, .external_lex_state = 2},
  [607] = {.lex_state = 59},
  [608] = {.lex_state = 60, .external_lex_state = 2},
  [609] = {.lex_state = 59},
  [610] = {.lex_state = 59},
  [611] = {.lex_state = 60},
  [612] = {.lex_state = 60},
  [613] = {.lex_state = 60},
  [614] = {.lex_state = 60},
  [615] = {.lex_state = 60},
  [616] = {.lex_state = 60},
  [617] = {.lex_state = 60},
  [618] = {.lex_state = 60},
  [619] = {.lex_state = 60},
  [620] = {.lex_state = 60},
  [621] = {.lex_state = 60},
  [622] = {.lex_state = 60},
  [623] = {.lex_state = 60},
  [624] = {.lex_state = 60},
  [625] = {.lex_state = 60},
  [626] = {.lex_state = 60},
  [627] = {.lex_state = 60},
  [628] = {.lex_state = 60},
  [629] = {.lex_state = 60},
  [630] = {.lex_state = 60},
  [631] = {.lex_state = 60},
  [632] = {.lex_state = 60},
  [633] = {.lex_state = 60},
  [634] = {.lex_state = 60},
  [635] = {.lex_state = 60},
  [636] = {.lex_state = 60},
  [637] = {.lex_state = 60},
  [638] = {.lex_state = 60},
  [639] = {.lex_state = 60},
  [640] = {.lex_state = 60},
  [641] = {.lex_state = 60},
  [642] = {.lex_state = 60},
  [643] = {.lex_state = 60},
  [644] = {.lex_state = 20},
  [645] = {.lex_state = 20},
  [646] = {.lex_state = 20},
  [647] = {.lex_state = 20},
  [648] = {.lex_state = 20},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 20},
  [651] = {.lex_state = 60},
  [652] = {.lex_state = 60},
  [653] = {.lex_state = 20},
  [654] = {.lex_state = 20},
  [655] = {.lex_state = 20},
  [656] = {.lex_state = 20},
  [657] = {.lex_state = 20},
  [658] = {.lex_state = 20},
  [659] = {.lex_state = 21},
  [660] = {.lex_state = 20},
  [661] = {.lex_state = 21},
  [662] = {.lex_state = 21},
  [663] = {.lex_state = 20},
  [664] = {.lex_state = 20},
  [665] = {.lex_state = 20},
  [666] = {.lex_state = 20},
  [667] = {.lex_state = 21},
  [668] = {.lex_state = 21},
  [669] = {.lex_state = 21},
  [670] = {.lex_state = 20},
  [671] = {.lex_state = 21},
  [672] = {.lex_state = 20},
  [673] = {.lex_state = 20},
  [674] = {.lex_state = 21},
  [675] = {.lex_state = 21},
  [676] = {.lex_state = 21},
  [677] = {.lex_state = 21},
  [678] = {.lex_state = 21},
  [679] = {.lex_state = 21},
  [680] = {.lex_state = 21},
  [681] = {.lex_state = 21},
  [682] = {.lex_state = 20},
  [683] = {.lex_state = 60},
  [684] = {.lex_state = 0, .external_lex_state = 2},
  [685] = {.lex_state = 60},
  [686] = {.lex_state = 60},
  [687] = {.lex_state = 12, .external_lex_state = 3},
  [688] = {.lex_state = 60},
  [689] = {.lex_state = 59},
  [690] = {.lex_state = 12, .external_lex_state = 3},
  [691] = {.lex_state = 12, .external_lex_state = 3},
  [692] = {.lex_state = 60},
  [693] = {.lex_state = 0, .external_lex_state = 2},
  [694] = {.lex_state = 20},
  [695] = {.lex_state = 59},
  [696] = {.lex_state = 20},
  [697] = {.lex_state = 60},
  [698] = {.lex_state = 59},
  [699] = {.lex_state = 12, .external_lex_state = 3},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 20},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 12, .external_lex_state = 3},
  [704] = {.lex_state = 60},
  [705] = {.lex_state = 20},
  [706] = {.lex_state = 0, .external_lex_state = 2},
  [707] = {.lex_state = 20},
  [708] = {.lex_state = 20},
  [709] = {.lex_state = 60},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 20},
  [712] = {.lex_state = 20},
  [713] = {.lex_state = 60},
  [714] = {.lex_state = 60},
  [715] = {.lex_state = 20},
  [716] = {.lex_state = 60},
  [717] = {.lex_state = 60},
  [718] = {.lex_state = 20},
  [719] = {.lex_state = 20},
  [720] = {.lex_state = 20},
  [721] = {.lex_state = 20},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 60},
  [724] = {.lex_state = 20},
  [725] = {.lex_state = 0, .external_lex_state = 2},
  [726] = {.lex_state = 60},
  [727] = {.lex_state = 20},
  [728] = {.lex_state = 20},
  [729] = {.lex_state = 20},
  [730] = {.lex_state = 20},
  [731] = {.lex_state = 20},
  [732] = {.lex_state = 20},
  [733] = {.lex_state = 20},
  [734] = {.lex_state = 60},
  [735] = {.lex_state = 20},
  [736] = {.lex_state = 60},
  [737] = {.lex_state = 20},
  [738] = {.lex_state = 20},
  [739] = {.lex_state = 60},
  [740] = {.lex_state = 20},
  [741] = {.lex_state = 60},
  [742] = {.lex_state = 20},
  [743] = {.lex_state = 20},
  [744] = {.lex_state = 20},
  [745] = {.lex_state = 20},
  [746] = {.lex_state = 20},
  [747] = {.lex_state = 60},
  [748] = {.lex_state = 20},
  [749] = {.lex_state = 60},
  [750] = {.lex_state = 60},
  [751] = {.lex_state = 20},
  [752] = {.lex_state = 60, .external_lex_state = 2},
  [753] = {.lex_state = 60},
  [754] = {.lex_state = 60},
  [755] = {.lex_state = 12, .external_lex_state = 3},
  [756] = {.lex_state = 1},
  [757] = {.lex_state = 3},
  [758] = {.lex_state = 1},
  [759] = {.lex_state = 3},
  [760] = {.lex_state = 60},
  [761] = {.lex_state = 3},
  [762] = {.lex_state = 1},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 60},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 60},
  [767] = {.lex_state = 60},
  [768] = {.lex_state = 60},
  [769] = {.lex_state = 0, .external_lex_state = 2},
  [770] = {.lex_state = 60},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 60},
  [773] = {.lex_state = 3},
  [774] = {.lex_state = 1},
  [775] = {.lex_state = 1},
  [776] = {.lex_state = 3},
  [777] = {.lex_state = 60},
  [778] = {.lex_state = 3},
  [779] = {.lex_state = 1},
  [780] = {.lex_state = 60},
  [781] = {.lex_state = 60},
  [782] = {.lex_state = 3},
  [783] = {.lex_state = 0, .external_lex_state = 2},
  [784] = {.lex_state = 1},
  [785] = {.lex_state = 0, .external_lex_state = 2},
  [786] = {.lex_state = 0, .external_lex_state = 2},
  [787] = {.lex_state = 60},
  [788] = {.lex_state = 60},
  [789] = {.lex_state = 60},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 60},
  [792] = {.lex_state = 60},
  [793] = {.lex_state = 60},
  [794] = {.lex_state = 0, .external_lex_state = 2},
  [795] = {.lex_state = 20},
  [796] = {.lex_state = 0, .external_lex_state = 2},
  [797] = {.lex_state = 20},
  [798] = {.lex_state = 60},
  [799] = {.lex_state = 20},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 60},
  [802] = {.lex_state = 60},
  [803] = {.lex_state = 60},
  [804] = {.lex_state = 60},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 60},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 60},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 60},
  [820] = {.lex_state = 60},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 60},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 60},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 60},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 60, .external_lex_state = 2},
  [833] = {.lex_state = 60},
  [834] = {.lex_state = 21},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 60},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0, .external_lex_state = 2},
  [840] = {.lex_state = 60, .external_lex_state = 2},
  [841] = {.lex_state = 60, .external_lex_state = 2},
  [842] = {.lex_state = 60, .external_lex_state = 2},
  [843] = {.lex_state = 60},
  [844] = {.lex_state = 7},
  [845] = {.lex_state = 60},
  [846] = {.lex_state = 7},
  [847] = {.lex_state = 60, .external_lex_state = 2},
  [848] = {.lex_state = 7},
  [849] = {.lex_state = 0, .external_lex_state = 2},
  [850] = {.lex_state = 21},
  [851] = {.lex_state = 60},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 7},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 60},
  [857] = {.lex_state = 60},
  [858] = {.lex_state = 60, .external_lex_state = 2},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0, .external_lex_state = 2},
  [868] = {.lex_state = 0, .external_lex_state = 2},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 21},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 21},
  [875] = {.lex_state = 21},
  [876] = {.lex_state = 60},
  [877] = {.lex_state = 21},
  [878] = {.lex_state = 21},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 21},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 60, .external_lex_state = 2},
  [883] = {.lex_state = 60},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 21},
  [887] = {.lex_state = 60, .external_lex_state = 2},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0, .external_lex_state = 2},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 60},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 60},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 60},
  [905] = {.lex_state = 60},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0, .external_lex_state = 2},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0, .external_lex_state = 2},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 60},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0, .external_lex_state = 2},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0, .external_lex_state = 2},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 60},
  [930] = {.lex_state = 0, .external_lex_state = 2},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0, .external_lex_state = 2},
  [936] = {.lex_state = 60},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0, .external_lex_state = 2},
  [941] = {.lex_state = 0, .external_lex_state = 2},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0, .external_lex_state = 2},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0, .external_lex_state = 2},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0, .external_lex_state = 2},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0, .external_lex_state = 2},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0, .external_lex_state = 2},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 20},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 60},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 60},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 7},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 60},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 60},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 7},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 60},
  [1023] = {.lex_state = 7},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 60},
  [1026] = {.lex_state = 7},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0, .external_lex_state = 2},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 60},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 5},
  [1047] = {.lex_state = 60},
  [1048] = {.lex_state = 60},
  [1049] = {.lex_state = 5},
  [1050] = {.lex_state = 60},
  [1051] = {.lex_state = 60},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 60},
  [1055] = {.lex_state = 60},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 60},
  [1058] = {.lex_state = 60},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 60},
  [1062] = {.lex_state = 60},
  [1063] = {.lex_state = 60},
  [1064] = {.lex_state = 60},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 60},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 60},
  [1070] = {.lex_state = 60},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 60},
  [1073] = {.lex_state = 60},
  [1074] = {.lex_state = 60},
  [1075] = {.lex_state = 60},
  [1076] = {.lex_state = 60},
  [1077] = {.lex_state = 60},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 60},
  [1080] = {.lex_state = 12},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 60},
  [1084] = {.lex_state = 60},
  [1085] = {.lex_state = 60},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 60},
  [1088] = {.lex_state = 60},
  [1089] = {.lex_state = 60},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 60},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 60},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 60},
  [1098] = {.lex_state = 60},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 60},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 60},
  [1109] = {.lex_state = 12},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 60},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 60},
  [1116] = {.lex_state = 60},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 60},
  [1119] = {.lex_state = 60},
  [1120] = {.lex_state = 60},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 60},
  [1124] = {.lex_state = 60},
  [1125] = {.lex_state = 60},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 60},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 60},
  [1132] = {.lex_state = 60},
  [1133] = {.lex_state = 60},
  [1134] = {.lex_state = 60},
  [1135] = {.lex_state = 60},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1130),
    [sym_export_statement] = STATE(22),
    [sym__declaration] = STATE(22),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(22),
    [sym_lexical_declaration] = STATE(22),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(22),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(22),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(22),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [2] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [3] = {
    [sym_export_statement] = STATE(14),
    [sym__declaration] = STATE(14),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(14),
    [sym_lexical_declaration] = STATE(14),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(14),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(14),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(14),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [4] = {
    [sym_export_statement] = STATE(19),
    [sym__declaration] = STATE(19),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(19),
    [sym_lexical_declaration] = STATE(19),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(884),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(19),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(19),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(19),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(884),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(884),
    [sym_pair] = STATE(884),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(889),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(117),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
  },
  [5] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(532),
    [sym_assignment_pattern] = STATE(809),
    [sym_array] = STATE(529),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_spread_element] = STATE(809),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(534),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [sym_method_definition] = STATE(809),
    [sym_pair] = STATE(809),
    [sym__property_name] = STATE(890),
    [sym_computed_property_name] = STATE(890),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(594),
    [aux_sym_object_repeat1] = STATE(885),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [6] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(125),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(130),
    [anon_sym_default] = ACTIONS(133),
    [anon_sym_LBRACE] = ACTIONS(135),
    [anon_sym_RBRACE] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(138),
    [anon_sym_var] = ACTIONS(141),
    [anon_sym_let] = ACTIONS(144),
    [anon_sym_const] = ACTIONS(144),
    [anon_sym_if] = ACTIONS(147),
    [anon_sym_switch] = ACTIONS(150),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(156),
    [anon_sym_await] = ACTIONS(159),
    [anon_sym_while] = ACTIONS(162),
    [anon_sym_do] = ACTIONS(165),
    [anon_sym_try] = ACTIONS(168),
    [anon_sym_with] = ACTIONS(171),
    [anon_sym_break] = ACTIONS(174),
    [anon_sym_continue] = ACTIONS(177),
    [anon_sym_debugger] = ACTIONS(180),
    [anon_sym_return] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(186),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_case] = ACTIONS(133),
    [anon_sym_yield] = ACTIONS(192),
    [anon_sym_LBRACK] = ACTIONS(195),
    [anon_sym_LT] = ACTIONS(198),
    [anon_sym_SLASH] = ACTIONS(201),
    [anon_sym_class] = ACTIONS(204),
    [anon_sym_async] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(210),
    [anon_sym_new] = ACTIONS(213),
    [anon_sym_PLUS] = ACTIONS(216),
    [anon_sym_DASH] = ACTIONS(216),
    [anon_sym_BANG] = ACTIONS(219),
    [anon_sym_TILDE] = ACTIONS(219),
    [anon_sym_typeof] = ACTIONS(222),
    [anon_sym_void] = ACTIONS(222),
    [anon_sym_delete] = ACTIONS(222),
    [anon_sym_PLUS_PLUS] = ACTIONS(225),
    [anon_sym_DASH_DASH] = ACTIONS(225),
    [anon_sym_DQUOTE] = ACTIONS(228),
    [anon_sym_SQUOTE] = ACTIONS(231),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(234),
    [sym_number] = ACTIONS(237),
    [sym_this] = ACTIONS(240),
    [sym_super] = ACTIONS(243),
    [sym_true] = ACTIONS(240),
    [sym_false] = ACTIONS(240),
    [sym_null] = ACTIONS(240),
    [sym_undefined] = ACTIONS(240),
    [anon_sym_AT] = ACTIONS(246),
    [anon_sym_static] = ACTIONS(249),
    [anon_sym_get] = ACTIONS(249),
    [anon_sym_set] = ACTIONS(249),
  },
  [7] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(254),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(252),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [8] = {
    [sym_export_statement] = STATE(7),
    [sym__declaration] = STATE(7),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(7),
    [sym_lexical_declaration] = STATE(7),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(7),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(7),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(7),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(258),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(256),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [9] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(262),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(260),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [10] = {
    [sym_export_statement] = STATE(9),
    [sym__declaration] = STATE(9),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(9),
    [sym_lexical_declaration] = STATE(9),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(9),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(9),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(9),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(266),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(264),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [11] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(268),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [12] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(270),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [13] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(272),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [14] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(274),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [15] = {
    [sym_export_statement] = STATE(19),
    [sym__declaration] = STATE(19),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(19),
    [sym_lexical_declaration] = STATE(19),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(19),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(19),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(19),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(276),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [16] = {
    [sym_export_statement] = STATE(11),
    [sym__declaration] = STATE(11),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(11),
    [sym_lexical_declaration] = STATE(11),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(11),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(11),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(11),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(278),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [17] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(280),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [18] = {
    [sym_export_statement] = STATE(17),
    [sym__declaration] = STATE(17),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(17),
    [sym_lexical_declaration] = STATE(17),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(17),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(17),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(17),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(282),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [19] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(284),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [20] = {
    [sym_export_statement] = STATE(12),
    [sym__declaration] = STATE(12),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(12),
    [sym_lexical_declaration] = STATE(12),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(12),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(12),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(12),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(286),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [21] = {
    [sym_export_statement] = STATE(14),
    [sym__declaration] = STATE(14),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(14),
    [sym_lexical_declaration] = STATE(14),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(14),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(14),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(14),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(278),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [22] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(272),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [23] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [ts_builtin_sym_end] = ACTIONS(288),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [24] = {
    [sym_export_statement] = STATE(1001),
    [sym__declaration] = STATE(1001),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(1001),
    [sym_expression_statement] = STATE(1001),
    [sym_variable_declaration] = STATE(1001),
    [sym_lexical_declaration] = STATE(1001),
    [sym_statement_block] = STATE(1001),
    [sym_if_statement] = STATE(1001),
    [sym_switch_statement] = STATE(1001),
    [sym_for_statement] = STATE(1001),
    [sym_for_in_statement] = STATE(1001),
    [sym_while_statement] = STATE(1001),
    [sym_do_statement] = STATE(1001),
    [sym_try_statement] = STATE(1001),
    [sym_with_statement] = STATE(1001),
    [sym_break_statement] = STATE(1001),
    [sym_continue_statement] = STATE(1001),
    [sym_debugger_statement] = STATE(1001),
    [sym_return_statement] = STATE(1001),
    [sym_throw_statement] = STATE(1001),
    [sym_empty_statement] = STATE(1001),
    [sym_labeled_statement] = STATE(1001),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(1001),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(1001),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(1001),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [25] = {
    [sym_export_statement] = STATE(230),
    [sym__declaration] = STATE(230),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(230),
    [sym_expression_statement] = STATE(230),
    [sym_variable_declaration] = STATE(230),
    [sym_lexical_declaration] = STATE(230),
    [sym_statement_block] = STATE(230),
    [sym_if_statement] = STATE(230),
    [sym_switch_statement] = STATE(230),
    [sym_for_statement] = STATE(230),
    [sym_for_in_statement] = STATE(230),
    [sym_while_statement] = STATE(230),
    [sym_do_statement] = STATE(230),
    [sym_try_statement] = STATE(230),
    [sym_with_statement] = STATE(230),
    [sym_break_statement] = STATE(230),
    [sym_continue_statement] = STATE(230),
    [sym_debugger_statement] = STATE(230),
    [sym_return_statement] = STATE(230),
    [sym_throw_statement] = STATE(230),
    [sym_empty_statement] = STATE(230),
    [sym_labeled_statement] = STATE(230),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(230),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(230),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(230),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [26] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [27] = {
    [sym_export_statement] = STATE(243),
    [sym__declaration] = STATE(243),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(243),
    [sym_expression_statement] = STATE(243),
    [sym_variable_declaration] = STATE(243),
    [sym_lexical_declaration] = STATE(243),
    [sym_statement_block] = STATE(243),
    [sym_if_statement] = STATE(243),
    [sym_switch_statement] = STATE(243),
    [sym_for_statement] = STATE(243),
    [sym_for_in_statement] = STATE(243),
    [sym_while_statement] = STATE(243),
    [sym_do_statement] = STATE(243),
    [sym_try_statement] = STATE(243),
    [sym_with_statement] = STATE(243),
    [sym_break_statement] = STATE(243),
    [sym_continue_statement] = STATE(243),
    [sym_debugger_statement] = STATE(243),
    [sym_return_statement] = STATE(243),
    [sym_throw_statement] = STATE(243),
    [sym_empty_statement] = STATE(243),
    [sym_labeled_statement] = STATE(243),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(243),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(243),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(243),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [28] = {
    [sym_export_statement] = STATE(245),
    [sym__declaration] = STATE(245),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(245),
    [sym_expression_statement] = STATE(245),
    [sym_variable_declaration] = STATE(245),
    [sym_lexical_declaration] = STATE(245),
    [sym_statement_block] = STATE(245),
    [sym_if_statement] = STATE(245),
    [sym_switch_statement] = STATE(245),
    [sym_for_statement] = STATE(245),
    [sym_for_in_statement] = STATE(245),
    [sym_while_statement] = STATE(245),
    [sym_do_statement] = STATE(245),
    [sym_try_statement] = STATE(245),
    [sym_with_statement] = STATE(245),
    [sym_break_statement] = STATE(245),
    [sym_continue_statement] = STATE(245),
    [sym_debugger_statement] = STATE(245),
    [sym_return_statement] = STATE(245),
    [sym_throw_statement] = STATE(245),
    [sym_empty_statement] = STATE(245),
    [sym_labeled_statement] = STATE(245),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(245),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(245),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(245),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [29] = {
    [sym_export_statement] = STATE(230),
    [sym__declaration] = STATE(230),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(230),
    [sym_expression_statement] = STATE(230),
    [sym_variable_declaration] = STATE(230),
    [sym_lexical_declaration] = STATE(230),
    [sym_statement_block] = STATE(230),
    [sym_if_statement] = STATE(230),
    [sym_switch_statement] = STATE(230),
    [sym_for_statement] = STATE(230),
    [sym_for_in_statement] = STATE(230),
    [sym_while_statement] = STATE(230),
    [sym_do_statement] = STATE(230),
    [sym_try_statement] = STATE(230),
    [sym_with_statement] = STATE(230),
    [sym_break_statement] = STATE(230),
    [sym_continue_statement] = STATE(230),
    [sym_debugger_statement] = STATE(230),
    [sym_return_statement] = STATE(230),
    [sym_throw_statement] = STATE(230),
    [sym_empty_statement] = STATE(230),
    [sym_labeled_statement] = STATE(230),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(230),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(230),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(230),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [30] = {
    [sym_export_statement] = STATE(1102),
    [sym__declaration] = STATE(1102),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(1102),
    [sym_expression_statement] = STATE(1102),
    [sym_variable_declaration] = STATE(1102),
    [sym_lexical_declaration] = STATE(1102),
    [sym_statement_block] = STATE(1102),
    [sym_if_statement] = STATE(1102),
    [sym_switch_statement] = STATE(1102),
    [sym_for_statement] = STATE(1102),
    [sym_for_in_statement] = STATE(1102),
    [sym_while_statement] = STATE(1102),
    [sym_do_statement] = STATE(1102),
    [sym_try_statement] = STATE(1102),
    [sym_with_statement] = STATE(1102),
    [sym_break_statement] = STATE(1102),
    [sym_continue_statement] = STATE(1102),
    [sym_debugger_statement] = STATE(1102),
    [sym_return_statement] = STATE(1102),
    [sym_throw_statement] = STATE(1102),
    [sym_empty_statement] = STATE(1102),
    [sym_labeled_statement] = STATE(1102),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(1102),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(1102),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(1102),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [31] = {
    [sym_export_statement] = STATE(234),
    [sym__declaration] = STATE(234),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(234),
    [sym_expression_statement] = STATE(234),
    [sym_variable_declaration] = STATE(234),
    [sym_lexical_declaration] = STATE(234),
    [sym_statement_block] = STATE(234),
    [sym_if_statement] = STATE(234),
    [sym_switch_statement] = STATE(234),
    [sym_for_statement] = STATE(234),
    [sym_for_in_statement] = STATE(234),
    [sym_while_statement] = STATE(234),
    [sym_do_statement] = STATE(234),
    [sym_try_statement] = STATE(234),
    [sym_with_statement] = STATE(234),
    [sym_break_statement] = STATE(234),
    [sym_continue_statement] = STATE(234),
    [sym_debugger_statement] = STATE(234),
    [sym_return_statement] = STATE(234),
    [sym_throw_statement] = STATE(234),
    [sym_empty_statement] = STATE(234),
    [sym_labeled_statement] = STATE(234),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(234),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(234),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(234),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [32] = {
    [sym_export_statement] = STATE(219),
    [sym__declaration] = STATE(219),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(219),
    [sym_expression_statement] = STATE(219),
    [sym_variable_declaration] = STATE(219),
    [sym_lexical_declaration] = STATE(219),
    [sym_statement_block] = STATE(219),
    [sym_if_statement] = STATE(219),
    [sym_switch_statement] = STATE(219),
    [sym_for_statement] = STATE(219),
    [sym_for_in_statement] = STATE(219),
    [sym_while_statement] = STATE(219),
    [sym_do_statement] = STATE(219),
    [sym_try_statement] = STATE(219),
    [sym_with_statement] = STATE(219),
    [sym_break_statement] = STATE(219),
    [sym_continue_statement] = STATE(219),
    [sym_debugger_statement] = STATE(219),
    [sym_return_statement] = STATE(219),
    [sym_throw_statement] = STATE(219),
    [sym_empty_statement] = STATE(219),
    [sym_labeled_statement] = STATE(219),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(219),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(219),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(219),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [33] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [34] = {
    [sym_export_statement] = STATE(219),
    [sym__declaration] = STATE(219),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(219),
    [sym_expression_statement] = STATE(219),
    [sym_variable_declaration] = STATE(219),
    [sym_lexical_declaration] = STATE(219),
    [sym_statement_block] = STATE(219),
    [sym_if_statement] = STATE(219),
    [sym_switch_statement] = STATE(219),
    [sym_for_statement] = STATE(219),
    [sym_for_in_statement] = STATE(219),
    [sym_while_statement] = STATE(219),
    [sym_do_statement] = STATE(219),
    [sym_try_statement] = STATE(219),
    [sym_with_statement] = STATE(219),
    [sym_break_statement] = STATE(219),
    [sym_continue_statement] = STATE(219),
    [sym_debugger_statement] = STATE(219),
    [sym_return_statement] = STATE(219),
    [sym_throw_statement] = STATE(219),
    [sym_empty_statement] = STATE(219),
    [sym_labeled_statement] = STATE(219),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(219),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(219),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(219),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [35] = {
    [sym_export_statement] = STATE(234),
    [sym__declaration] = STATE(234),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(234),
    [sym_expression_statement] = STATE(234),
    [sym_variable_declaration] = STATE(234),
    [sym_lexical_declaration] = STATE(234),
    [sym_statement_block] = STATE(234),
    [sym_if_statement] = STATE(234),
    [sym_switch_statement] = STATE(234),
    [sym_for_statement] = STATE(234),
    [sym_for_in_statement] = STATE(234),
    [sym_while_statement] = STATE(234),
    [sym_do_statement] = STATE(234),
    [sym_try_statement] = STATE(234),
    [sym_with_statement] = STATE(234),
    [sym_break_statement] = STATE(234),
    [sym_continue_statement] = STATE(234),
    [sym_debugger_statement] = STATE(234),
    [sym_return_statement] = STATE(234),
    [sym_throw_statement] = STATE(234),
    [sym_empty_statement] = STATE(234),
    [sym_labeled_statement] = STATE(234),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(234),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(234),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(234),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [36] = {
    [sym_export_statement] = STATE(258),
    [sym__declaration] = STATE(258),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(258),
    [sym_expression_statement] = STATE(258),
    [sym_variable_declaration] = STATE(258),
    [sym_lexical_declaration] = STATE(258),
    [sym_statement_block] = STATE(258),
    [sym_if_statement] = STATE(258),
    [sym_switch_statement] = STATE(258),
    [sym_for_statement] = STATE(258),
    [sym_for_in_statement] = STATE(258),
    [sym_while_statement] = STATE(258),
    [sym_do_statement] = STATE(258),
    [sym_try_statement] = STATE(258),
    [sym_with_statement] = STATE(258),
    [sym_break_statement] = STATE(258),
    [sym_continue_statement] = STATE(258),
    [sym_debugger_statement] = STATE(258),
    [sym_return_statement] = STATE(258),
    [sym_throw_statement] = STATE(258),
    [sym_empty_statement] = STATE(258),
    [sym_labeled_statement] = STATE(258),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(258),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(258),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(258),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [37] = {
    [sym_export_statement] = STATE(260),
    [sym__declaration] = STATE(260),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(260),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(260),
    [sym_lexical_declaration] = STATE(260),
    [sym_statement_block] = STATE(260),
    [sym_if_statement] = STATE(260),
    [sym_switch_statement] = STATE(260),
    [sym_for_statement] = STATE(260),
    [sym_for_in_statement] = STATE(260),
    [sym_while_statement] = STATE(260),
    [sym_do_statement] = STATE(260),
    [sym_try_statement] = STATE(260),
    [sym_with_statement] = STATE(260),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(260),
    [sym_debugger_statement] = STATE(260),
    [sym_return_statement] = STATE(260),
    [sym_throw_statement] = STATE(260),
    [sym_empty_statement] = STATE(260),
    [sym_labeled_statement] = STATE(260),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(260),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(260),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(260),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [38] = {
    [sym_export_statement] = STATE(245),
    [sym__declaration] = STATE(245),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(245),
    [sym_expression_statement] = STATE(245),
    [sym_variable_declaration] = STATE(245),
    [sym_lexical_declaration] = STATE(245),
    [sym_statement_block] = STATE(245),
    [sym_if_statement] = STATE(245),
    [sym_switch_statement] = STATE(245),
    [sym_for_statement] = STATE(245),
    [sym_for_in_statement] = STATE(245),
    [sym_while_statement] = STATE(245),
    [sym_do_statement] = STATE(245),
    [sym_try_statement] = STATE(245),
    [sym_with_statement] = STATE(245),
    [sym_break_statement] = STATE(245),
    [sym_continue_statement] = STATE(245),
    [sym_debugger_statement] = STATE(245),
    [sym_return_statement] = STATE(245),
    [sym_throw_statement] = STATE(245),
    [sym_empty_statement] = STATE(245),
    [sym_labeled_statement] = STATE(245),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(245),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(245),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(245),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [39] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(747),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [40] = {
    [sym_export_statement] = STATE(243),
    [sym__declaration] = STATE(243),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(243),
    [sym_expression_statement] = STATE(243),
    [sym_variable_declaration] = STATE(243),
    [sym_lexical_declaration] = STATE(243),
    [sym_statement_block] = STATE(243),
    [sym_if_statement] = STATE(243),
    [sym_switch_statement] = STATE(243),
    [sym_for_statement] = STATE(243),
    [sym_for_in_statement] = STATE(243),
    [sym_while_statement] = STATE(243),
    [sym_do_statement] = STATE(243),
    [sym_try_statement] = STATE(243),
    [sym_with_statement] = STATE(243),
    [sym_break_statement] = STATE(243),
    [sym_continue_statement] = STATE(243),
    [sym_debugger_statement] = STATE(243),
    [sym_return_statement] = STATE(243),
    [sym_throw_statement] = STATE(243),
    [sym_empty_statement] = STATE(243),
    [sym_labeled_statement] = STATE(243),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(243),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(243),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(243),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [41] = {
    [sym_export_statement] = STATE(260),
    [sym__declaration] = STATE(260),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(260),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(260),
    [sym_lexical_declaration] = STATE(260),
    [sym_statement_block] = STATE(260),
    [sym_if_statement] = STATE(260),
    [sym_switch_statement] = STATE(260),
    [sym_for_statement] = STATE(260),
    [sym_for_in_statement] = STATE(260),
    [sym_while_statement] = STATE(260),
    [sym_do_statement] = STATE(260),
    [sym_try_statement] = STATE(260),
    [sym_with_statement] = STATE(260),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(260),
    [sym_debugger_statement] = STATE(260),
    [sym_return_statement] = STATE(260),
    [sym_throw_statement] = STATE(260),
    [sym_empty_statement] = STATE(260),
    [sym_labeled_statement] = STATE(260),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(260),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(260),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(260),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [42] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(481),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(403),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(481),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(726),
    [sym_identifier] = ACTIONS(290),
    [anon_sym_export] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(296),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(302),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(304),
    [anon_sym_async] = ACTIONS(306),
    [anon_sym_function] = ACTIONS(308),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(310),
    [anon_sym_get] = ACTIONS(310),
    [anon_sym_set] = ACTIONS(310),
  },
  [43] = {
    [sym_import] = STATE(319),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(319),
    [sym_yield_expression] = STATE(319),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(319),
    [sym_jsx_fragment] = STATE(319),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(319),
    [sym_class] = STATE(319),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(319),
    [sym_arrow_function] = STATE(319),
    [sym_call_expression] = STATE(319),
    [sym_new_expression] = STATE(319),
    [sym_await_expression] = STATE(319),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(319),
    [sym_augmented_assignment_expression] = STATE(319),
    [sym_ternary_expression] = STATE(319),
    [sym_binary_expression] = STATE(319),
    [sym_unary_expression] = STATE(319),
    [sym_update_expression] = STATE(319),
    [sym_string] = STATE(319),
    [sym_template_string] = STATE(319),
    [sym_regex] = STATE(319),
    [sym_meta_property] = STATE(319),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_STAR] = ACTIONS(314),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(318),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_in] = ACTIONS(326),
    [anon_sym_COLON] = ACTIONS(318),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(318),
    [anon_sym_LT] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_DOT] = ACTIONS(326),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_QMARK] = ACTIONS(326),
    [anon_sym_AMP_AMP] = ACTIONS(318),
    [anon_sym_PIPE_PIPE] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(326),
    [anon_sym_GT_GT_GT] = ACTIONS(318),
    [anon_sym_LT_LT] = ACTIONS(318),
    [anon_sym_AMP] = ACTIONS(326),
    [anon_sym_CARET] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_PERCENT] = ACTIONS(318),
    [anon_sym_STAR_STAR] = ACTIONS(318),
    [anon_sym_LT_EQ] = ACTIONS(318),
    [anon_sym_EQ_EQ] = ACTIONS(326),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(326),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(318),
    [anon_sym_GT_EQ] = ACTIONS(318),
    [anon_sym_QMARK_QMARK] = ACTIONS(318),
    [anon_sym_instanceof] = ACTIONS(326),
    [anon_sym_BANG] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(360),
    [sym_this] = ACTIONS(362),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(362),
    [sym_false] = ACTIONS(362),
    [sym_null] = ACTIONS(362),
    [sym_undefined] = ACTIONS(362),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [44] = {
    [sym_import] = STATE(384),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(384),
    [sym_yield_expression] = STATE(384),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(384),
    [sym_jsx_fragment] = STATE(384),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(384),
    [sym_class] = STATE(384),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(384),
    [sym_arrow_function] = STATE(384),
    [sym_call_expression] = STATE(384),
    [sym_new_expression] = STATE(384),
    [sym_await_expression] = STATE(384),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(384),
    [sym_augmented_assignment_expression] = STATE(384),
    [sym_ternary_expression] = STATE(384),
    [sym_binary_expression] = STATE(384),
    [sym_unary_expression] = STATE(384),
    [sym_update_expression] = STATE(384),
    [sym_string] = STATE(384),
    [sym_template_string] = STATE(384),
    [sym_regex] = STATE(384),
    [sym_meta_property] = STATE(384),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_COMMA] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(318),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(326),
    [anon_sym_SEMI] = ACTIONS(318),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(376),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(326),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(326),
    [anon_sym_AMP_AMP] = ACTIONS(318),
    [anon_sym_PIPE_PIPE] = ACTIONS(318),
    [anon_sym_GT_GT] = ACTIONS(326),
    [anon_sym_GT_GT_GT] = ACTIONS(318),
    [anon_sym_LT_LT] = ACTIONS(318),
    [anon_sym_AMP] = ACTIONS(326),
    [anon_sym_CARET] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(318),
    [anon_sym_STAR_STAR] = ACTIONS(318),
    [anon_sym_LT_EQ] = ACTIONS(318),
    [anon_sym_EQ_EQ] = ACTIONS(326),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(326),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(318),
    [anon_sym_GT_EQ] = ACTIONS(318),
    [anon_sym_QMARK_QMARK] = ACTIONS(318),
    [anon_sym_instanceof] = ACTIONS(326),
    [anon_sym_BANG] = ACTIONS(384),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(386),
    [sym_this] = ACTIONS(388),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(388),
    [sym_false] = ACTIONS(388),
    [sym_null] = ACTIONS(388),
    [sym_undefined] = ACTIONS(388),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
    [sym__automatic_semicolon] = ACTIONS(318),
  },
  [45] = {
    [ts_builtin_sym_end] = ACTIONS(392),
    [sym_identifier] = ACTIONS(394),
    [anon_sym_export] = ACTIONS(394),
    [anon_sym_STAR] = ACTIONS(396),
    [anon_sym_default] = ACTIONS(394),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_COMMA] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(392),
    [anon_sym_import] = ACTIONS(394),
    [anon_sym_var] = ACTIONS(394),
    [anon_sym_let] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_else] = ACTIONS(394),
    [anon_sym_switch] = ACTIONS(394),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_await] = ACTIONS(394),
    [anon_sym_in] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(394),
    [anon_sym_do] = ACTIONS(394),
    [anon_sym_try] = ACTIONS(394),
    [anon_sym_with] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(394),
    [anon_sym_continue] = ACTIONS(394),
    [anon_sym_debugger] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_throw] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_case] = ACTIONS(394),
    [anon_sym_yield] = ACTIONS(394),
    [anon_sym_EQ] = ACTIONS(396),
    [anon_sym_LBRACK] = ACTIONS(392),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(396),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_DOT] = ACTIONS(396),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(394),
    [anon_sym_new] = ACTIONS(394),
    [anon_sym_QMARK] = ACTIONS(396),
    [anon_sym_AMP_AMP] = ACTIONS(398),
    [anon_sym_PIPE_PIPE] = ACTIONS(398),
    [anon_sym_GT_GT] = ACTIONS(396),
    [anon_sym_GT_GT_GT] = ACTIONS(398),
    [anon_sym_LT_LT] = ACTIONS(398),
    [anon_sym_AMP] = ACTIONS(396),
    [anon_sym_CARET] = ACTIONS(398),
    [anon_sym_PIPE] = ACTIONS(396),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(398),
    [anon_sym_STAR_STAR] = ACTIONS(398),
    [anon_sym_LT_EQ] = ACTIONS(398),
    [anon_sym_EQ_EQ] = ACTIONS(396),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(398),
    [anon_sym_BANG_EQ] = ACTIONS(396),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(398),
    [anon_sym_GT_EQ] = ACTIONS(398),
    [anon_sym_QMARK_QMARK] = ACTIONS(398),
    [anon_sym_instanceof] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(392),
    [anon_sym_DASH_DASH] = ACTIONS(392),
    [anon_sym_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE] = ACTIONS(392),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(392),
    [sym_number] = ACTIONS(392),
    [sym_this] = ACTIONS(394),
    [sym_super] = ACTIONS(394),
    [sym_true] = ACTIONS(394),
    [sym_false] = ACTIONS(394),
    [sym_null] = ACTIONS(394),
    [sym_undefined] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_static] = ACTIONS(394),
    [anon_sym_get] = ACTIONS(394),
    [anon_sym_set] = ACTIONS(394),
    [sym__automatic_semicolon] = ACTIONS(400),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(402),
    [sym_identifier] = ACTIONS(404),
    [anon_sym_export] = ACTIONS(404),
    [anon_sym_STAR] = ACTIONS(406),
    [anon_sym_default] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_COMMA] = ACTIONS(408),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_import] = ACTIONS(404),
    [anon_sym_var] = ACTIONS(404),
    [anon_sym_let] = ACTIONS(404),
    [anon_sym_const] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_else] = ACTIONS(404),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_for] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_in] = ACTIONS(406),
    [anon_sym_while] = ACTIONS(404),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_try] = ACTIONS(404),
    [anon_sym_with] = ACTIONS(404),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(404),
    [anon_sym_debugger] = ACTIONS(404),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_throw] = ACTIONS(404),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_case] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(404),
    [anon_sym_LBRACK] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(404),
    [anon_sym_GT] = ACTIONS(406),
    [anon_sym_SLASH] = ACTIONS(404),
    [anon_sym_DOT] = ACTIONS(406),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_async] = ACTIONS(404),
    [anon_sym_function] = ACTIONS(404),
    [anon_sym_new] = ACTIONS(404),
    [anon_sym_QMARK] = ACTIONS(406),
    [anon_sym_AMP_AMP] = ACTIONS(408),
    [anon_sym_PIPE_PIPE] = ACTIONS(408),
    [anon_sym_GT_GT] = ACTIONS(406),
    [anon_sym_GT_GT_GT] = ACTIONS(408),
    [anon_sym_LT_LT] = ACTIONS(408),
    [anon_sym_AMP] = ACTIONS(406),
    [anon_sym_CARET] = ACTIONS(408),
    [anon_sym_PIPE] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_PERCENT] = ACTIONS(408),
    [anon_sym_STAR_STAR] = ACTIONS(408),
    [anon_sym_LT_EQ] = ACTIONS(408),
    [anon_sym_EQ_EQ] = ACTIONS(406),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(408),
    [anon_sym_BANG_EQ] = ACTIONS(406),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(408),
    [anon_sym_GT_EQ] = ACTIONS(408),
    [anon_sym_QMARK_QMARK] = ACTIONS(408),
    [anon_sym_instanceof] = ACTIONS(406),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_TILDE] = ACTIONS(402),
    [anon_sym_typeof] = ACTIONS(404),
    [anon_sym_void] = ACTIONS(404),
    [anon_sym_delete] = ACTIONS(404),
    [anon_sym_PLUS_PLUS] = ACTIONS(402),
    [anon_sym_DASH_DASH] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(402),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(402),
    [sym_this] = ACTIONS(404),
    [sym_super] = ACTIONS(404),
    [sym_true] = ACTIONS(404),
    [sym_false] = ACTIONS(404),
    [sym_null] = ACTIONS(404),
    [sym_undefined] = ACTIONS(404),
    [anon_sym_AT] = ACTIONS(402),
    [anon_sym_static] = ACTIONS(404),
    [anon_sym_get] = ACTIONS(404),
    [anon_sym_set] = ACTIONS(404),
    [sym__automatic_semicolon] = ACTIONS(410),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(412),
    [sym_identifier] = ACTIONS(414),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_STAR] = ACTIONS(416),
    [anon_sym_default] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(412),
    [anon_sym_COMMA] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(412),
    [anon_sym_import] = ACTIONS(414),
    [anon_sym_var] = ACTIONS(414),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_const] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(414),
    [anon_sym_else] = ACTIONS(414),
    [anon_sym_switch] = ACTIONS(414),
    [anon_sym_for] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_await] = ACTIONS(414),
    [anon_sym_in] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(414),
    [anon_sym_do] = ACTIONS(414),
    [anon_sym_try] = ACTIONS(414),
    [anon_sym_with] = ACTIONS(414),
    [anon_sym_break] = ACTIONS(414),
    [anon_sym_continue] = ACTIONS(414),
    [anon_sym_debugger] = ACTIONS(414),
    [anon_sym_return] = ACTIONS(414),
    [anon_sym_throw] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(412),
    [anon_sym_case] = ACTIONS(414),
    [anon_sym_yield] = ACTIONS(414),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_LT] = ACTIONS(414),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_SLASH] = ACTIONS(414),
    [anon_sym_DOT] = ACTIONS(416),
    [anon_sym_class] = ACTIONS(414),
    [anon_sym_async] = ACTIONS(414),
    [anon_sym_function] = ACTIONS(414),
    [anon_sym_new] = ACTIONS(414),
    [anon_sym_QMARK] = ACTIONS(416),
    [anon_sym_AMP_AMP] = ACTIONS(418),
    [anon_sym_PIPE_PIPE] = ACTIONS(418),
    [anon_sym_GT_GT] = ACTIONS(416),
    [anon_sym_GT_GT_GT] = ACTIONS(418),
    [anon_sym_LT_LT] = ACTIONS(418),
    [anon_sym_AMP] = ACTIONS(416),
    [anon_sym_CARET] = ACTIONS(418),
    [anon_sym_PIPE] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_PERCENT] = ACTIONS(418),
    [anon_sym_STAR_STAR] = ACTIONS(418),
    [anon_sym_LT_EQ] = ACTIONS(418),
    [anon_sym_EQ_EQ] = ACTIONS(416),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(418),
    [anon_sym_BANG_EQ] = ACTIONS(416),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(418),
    [anon_sym_GT_EQ] = ACTIONS(418),
    [anon_sym_QMARK_QMARK] = ACTIONS(418),
    [anon_sym_instanceof] = ACTIONS(416),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(412),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(412),
    [anon_sym_DASH_DASH] = ACTIONS(412),
    [anon_sym_DQUOTE] = ACTIONS(412),
    [anon_sym_SQUOTE] = ACTIONS(412),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(412),
    [sym_number] = ACTIONS(412),
    [sym_this] = ACTIONS(414),
    [sym_super] = ACTIONS(414),
    [sym_true] = ACTIONS(414),
    [sym_false] = ACTIONS(414),
    [sym_null] = ACTIONS(414),
    [sym_undefined] = ACTIONS(414),
    [anon_sym_AT] = ACTIONS(412),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym__automatic_semicolon] = ACTIONS(420),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(422),
    [sym_identifier] = ACTIONS(424),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_STAR] = ACTIONS(426),
    [anon_sym_default] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(422),
    [anon_sym_COMMA] = ACTIONS(428),
    [anon_sym_RBRACE] = ACTIONS(422),
    [anon_sym_import] = ACTIONS(424),
    [anon_sym_var] = ACTIONS(424),
    [anon_sym_let] = ACTIONS(424),
    [anon_sym_const] = ACTIONS(424),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_else] = ACTIONS(424),
    [anon_sym_switch] = ACTIONS(424),
    [anon_sym_for] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_await] = ACTIONS(424),
    [anon_sym_in] = ACTIONS(426),
    [anon_sym_while] = ACTIONS(424),
    [anon_sym_do] = ACTIONS(424),
    [anon_sym_try] = ACTIONS(424),
    [anon_sym_with] = ACTIONS(424),
    [anon_sym_break] = ACTIONS(424),
    [anon_sym_continue] = ACTIONS(424),
    [anon_sym_debugger] = ACTIONS(424),
    [anon_sym_return] = ACTIONS(424),
    [anon_sym_throw] = ACTIONS(424),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_case] = ACTIONS(424),
    [anon_sym_yield] = ACTIONS(424),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(424),
    [anon_sym_GT] = ACTIONS(426),
    [anon_sym_SLASH] = ACTIONS(424),
    [anon_sym_DOT] = ACTIONS(426),
    [anon_sym_class] = ACTIONS(424),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(424),
    [anon_sym_new] = ACTIONS(424),
    [anon_sym_QMARK] = ACTIONS(426),
    [anon_sym_AMP_AMP] = ACTIONS(428),
    [anon_sym_PIPE_PIPE] = ACTIONS(428),
    [anon_sym_GT_GT] = ACTIONS(426),
    [anon_sym_GT_GT_GT] = ACTIONS(428),
    [anon_sym_LT_LT] = ACTIONS(428),
    [anon_sym_AMP] = ACTIONS(426),
    [anon_sym_CARET] = ACTIONS(428),
    [anon_sym_PIPE] = ACTIONS(426),
    [anon_sym_PLUS] = ACTIONS(424),
    [anon_sym_DASH] = ACTIONS(424),
    [anon_sym_PERCENT] = ACTIONS(428),
    [anon_sym_STAR_STAR] = ACTIONS(428),
    [anon_sym_LT_EQ] = ACTIONS(428),
    [anon_sym_EQ_EQ] = ACTIONS(426),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(428),
    [anon_sym_BANG_EQ] = ACTIONS(426),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(428),
    [anon_sym_GT_EQ] = ACTIONS(428),
    [anon_sym_QMARK_QMARK] = ACTIONS(428),
    [anon_sym_instanceof] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(424),
    [anon_sym_TILDE] = ACTIONS(422),
    [anon_sym_typeof] = ACTIONS(424),
    [anon_sym_void] = ACTIONS(424),
    [anon_sym_delete] = ACTIONS(424),
    [anon_sym_PLUS_PLUS] = ACTIONS(422),
    [anon_sym_DASH_DASH] = ACTIONS(422),
    [anon_sym_DQUOTE] = ACTIONS(422),
    [anon_sym_SQUOTE] = ACTIONS(422),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym_number] = ACTIONS(422),
    [sym_this] = ACTIONS(424),
    [sym_super] = ACTIONS(424),
    [sym_true] = ACTIONS(424),
    [sym_false] = ACTIONS(424),
    [sym_null] = ACTIONS(424),
    [sym_undefined] = ACTIONS(424),
    [anon_sym_AT] = ACTIONS(422),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
    [sym__automatic_semicolon] = ACTIONS(430),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(432),
    [sym_identifier] = ACTIONS(434),
    [anon_sym_export] = ACTIONS(434),
    [anon_sym_STAR] = ACTIONS(436),
    [anon_sym_default] = ACTIONS(434),
    [anon_sym_LBRACE] = ACTIONS(432),
    [anon_sym_COMMA] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(432),
    [anon_sym_import] = ACTIONS(434),
    [anon_sym_var] = ACTIONS(434),
    [anon_sym_let] = ACTIONS(434),
    [anon_sym_const] = ACTIONS(434),
    [anon_sym_if] = ACTIONS(434),
    [anon_sym_else] = ACTIONS(434),
    [anon_sym_switch] = ACTIONS(434),
    [anon_sym_for] = ACTIONS(434),
    [anon_sym_LPAREN] = ACTIONS(432),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_in] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(434),
    [anon_sym_do] = ACTIONS(434),
    [anon_sym_try] = ACTIONS(434),
    [anon_sym_with] = ACTIONS(434),
    [anon_sym_break] = ACTIONS(434),
    [anon_sym_continue] = ACTIONS(434),
    [anon_sym_debugger] = ACTIONS(434),
    [anon_sym_return] = ACTIONS(434),
    [anon_sym_throw] = ACTIONS(434),
    [anon_sym_SEMI] = ACTIONS(432),
    [anon_sym_case] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(434),
    [anon_sym_LBRACK] = ACTIONS(432),
    [anon_sym_LT] = ACTIONS(434),
    [anon_sym_GT] = ACTIONS(436),
    [anon_sym_SLASH] = ACTIONS(434),
    [anon_sym_DOT] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(434),
    [anon_sym_async] = ACTIONS(434),
    [anon_sym_function] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(434),
    [anon_sym_QMARK] = ACTIONS(436),
    [anon_sym_AMP_AMP] = ACTIONS(438),
    [anon_sym_PIPE_PIPE] = ACTIONS(438),
    [anon_sym_GT_GT] = ACTIONS(436),
    [anon_sym_GT_GT_GT] = ACTIONS(438),
    [anon_sym_LT_LT] = ACTIONS(438),
    [anon_sym_AMP] = ACTIONS(436),
    [anon_sym_CARET] = ACTIONS(438),
    [anon_sym_PIPE] = ACTIONS(436),
    [anon_sym_PLUS] = ACTIONS(434),
    [anon_sym_DASH] = ACTIONS(434),
    [anon_sym_PERCENT] = ACTIONS(438),
    [anon_sym_STAR_STAR] = ACTIONS(438),
    [anon_sym_LT_EQ] = ACTIONS(438),
    [anon_sym_EQ_EQ] = ACTIONS(436),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(438),
    [anon_sym_BANG_EQ] = ACTIONS(436),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(438),
    [anon_sym_GT_EQ] = ACTIONS(438),
    [anon_sym_QMARK_QMARK] = ACTIONS(438),
    [anon_sym_instanceof] = ACTIONS(436),
    [anon_sym_BANG] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(432),
    [anon_sym_typeof] = ACTIONS(434),
    [anon_sym_void] = ACTIONS(434),
    [anon_sym_delete] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(432),
    [anon_sym_DASH_DASH] = ACTIONS(432),
    [anon_sym_DQUOTE] = ACTIONS(432),
    [anon_sym_SQUOTE] = ACTIONS(432),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(432),
    [sym_number] = ACTIONS(432),
    [sym_this] = ACTIONS(434),
    [sym_super] = ACTIONS(434),
    [sym_true] = ACTIONS(434),
    [sym_false] = ACTIONS(434),
    [sym_null] = ACTIONS(434),
    [sym_undefined] = ACTIONS(434),
    [anon_sym_AT] = ACTIONS(432),
    [anon_sym_static] = ACTIONS(434),
    [anon_sym_get] = ACTIONS(434),
    [anon_sym_set] = ACTIONS(434),
    [sym__automatic_semicolon] = ACTIONS(440),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(442),
    [sym_identifier] = ACTIONS(444),
    [anon_sym_export] = ACTIONS(444),
    [anon_sym_STAR] = ACTIONS(444),
    [anon_sym_default] = ACTIONS(444),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_COMMA] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(442),
    [anon_sym_import] = ACTIONS(444),
    [anon_sym_var] = ACTIONS(444),
    [anon_sym_let] = ACTIONS(444),
    [anon_sym_const] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_else] = ACTIONS(444),
    [anon_sym_switch] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(442),
    [anon_sym_await] = ACTIONS(444),
    [anon_sym_in] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(444),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_try] = ACTIONS(444),
    [anon_sym_with] = ACTIONS(444),
    [anon_sym_break] = ACTIONS(444),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_debugger] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(444),
    [anon_sym_throw] = ACTIONS(444),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_case] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(444),
    [anon_sym_LBRACK] = ACTIONS(442),
    [anon_sym_LT] = ACTIONS(444),
    [anon_sym_GT] = ACTIONS(444),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_DOT] = ACTIONS(444),
    [anon_sym_class] = ACTIONS(444),
    [anon_sym_async] = ACTIONS(444),
    [anon_sym_function] = ACTIONS(444),
    [anon_sym_new] = ACTIONS(444),
    [anon_sym_QMARK] = ACTIONS(444),
    [anon_sym_AMP_AMP] = ACTIONS(442),
    [anon_sym_PIPE_PIPE] = ACTIONS(442),
    [anon_sym_GT_GT] = ACTIONS(444),
    [anon_sym_GT_GT_GT] = ACTIONS(442),
    [anon_sym_LT_LT] = ACTIONS(442),
    [anon_sym_AMP] = ACTIONS(444),
    [anon_sym_CARET] = ACTIONS(442),
    [anon_sym_PIPE] = ACTIONS(444),
    [anon_sym_PLUS] = ACTIONS(444),
    [anon_sym_DASH] = ACTIONS(444),
    [anon_sym_PERCENT] = ACTIONS(442),
    [anon_sym_STAR_STAR] = ACTIONS(442),
    [anon_sym_LT_EQ] = ACTIONS(442),
    [anon_sym_EQ_EQ] = ACTIONS(444),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(442),
    [anon_sym_BANG_EQ] = ACTIONS(444),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(442),
    [anon_sym_GT_EQ] = ACTIONS(442),
    [anon_sym_QMARK_QMARK] = ACTIONS(442),
    [anon_sym_instanceof] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(442),
    [anon_sym_typeof] = ACTIONS(444),
    [anon_sym_void] = ACTIONS(444),
    [anon_sym_delete] = ACTIONS(444),
    [anon_sym_PLUS_PLUS] = ACTIONS(442),
    [anon_sym_DASH_DASH] = ACTIONS(442),
    [anon_sym_DQUOTE] = ACTIONS(442),
    [anon_sym_SQUOTE] = ACTIONS(442),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(442),
    [sym_number] = ACTIONS(442),
    [sym_this] = ACTIONS(444),
    [sym_super] = ACTIONS(444),
    [sym_true] = ACTIONS(444),
    [sym_false] = ACTIONS(444),
    [sym_null] = ACTIONS(444),
    [sym_undefined] = ACTIONS(444),
    [anon_sym_AT] = ACTIONS(442),
    [anon_sym_static] = ACTIONS(444),
    [anon_sym_get] = ACTIONS(444),
    [anon_sym_set] = ACTIONS(444),
    [sym__automatic_semicolon] = ACTIONS(442),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(446),
    [sym_identifier] = ACTIONS(448),
    [anon_sym_export] = ACTIONS(448),
    [anon_sym_STAR] = ACTIONS(450),
    [anon_sym_default] = ACTIONS(448),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_COMMA] = ACTIONS(452),
    [anon_sym_RBRACE] = ACTIONS(446),
    [anon_sym_import] = ACTIONS(448),
    [anon_sym_var] = ACTIONS(448),
    [anon_sym_let] = ACTIONS(448),
    [anon_sym_const] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_else] = ACTIONS(448),
    [anon_sym_switch] = ACTIONS(448),
    [anon_sym_for] = ACTIONS(448),
    [anon_sym_LPAREN] = ACTIONS(446),
    [anon_sym_await] = ACTIONS(448),
    [anon_sym_in] = ACTIONS(450),
    [anon_sym_while] = ACTIONS(448),
    [anon_sym_do] = ACTIONS(448),
    [anon_sym_try] = ACTIONS(448),
    [anon_sym_with] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(448),
    [anon_sym_continue] = ACTIONS(448),
    [anon_sym_debugger] = ACTIONS(448),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_throw] = ACTIONS(448),
    [anon_sym_SEMI] = ACTIONS(446),
    [anon_sym_case] = ACTIONS(448),
    [anon_sym_yield] = ACTIONS(448),
    [anon_sym_LBRACK] = ACTIONS(446),
    [anon_sym_LT] = ACTIONS(448),
    [anon_sym_GT] = ACTIONS(450),
    [anon_sym_SLASH] = ACTIONS(448),
    [anon_sym_DOT] = ACTIONS(450),
    [anon_sym_class] = ACTIONS(448),
    [anon_sym_async] = ACTIONS(448),
    [anon_sym_function] = ACTIONS(448),
    [anon_sym_new] = ACTIONS(448),
    [anon_sym_QMARK] = ACTIONS(450),
    [anon_sym_AMP_AMP] = ACTIONS(452),
    [anon_sym_PIPE_PIPE] = ACTIONS(452),
    [anon_sym_GT_GT] = ACTIONS(450),
    [anon_sym_GT_GT_GT] = ACTIONS(452),
    [anon_sym_LT_LT] = ACTIONS(452),
    [anon_sym_AMP] = ACTIONS(450),
    [anon_sym_CARET] = ACTIONS(452),
    [anon_sym_PIPE] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(448),
    [anon_sym_DASH] = ACTIONS(448),
    [anon_sym_PERCENT] = ACTIONS(452),
    [anon_sym_STAR_STAR] = ACTIONS(452),
    [anon_sym_LT_EQ] = ACTIONS(452),
    [anon_sym_EQ_EQ] = ACTIONS(450),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(452),
    [anon_sym_BANG_EQ] = ACTIONS(450),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(452),
    [anon_sym_GT_EQ] = ACTIONS(452),
    [anon_sym_QMARK_QMARK] = ACTIONS(452),
    [anon_sym_instanceof] = ACTIONS(450),
    [anon_sym_BANG] = ACTIONS(448),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(448),
    [anon_sym_void] = ACTIONS(448),
    [anon_sym_delete] = ACTIONS(448),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(446),
    [anon_sym_SQUOTE] = ACTIONS(446),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(446),
    [sym_number] = ACTIONS(446),
    [sym_this] = ACTIONS(448),
    [sym_super] = ACTIONS(448),
    [sym_true] = ACTIONS(448),
    [sym_false] = ACTIONS(448),
    [sym_null] = ACTIONS(448),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(446),
    [anon_sym_static] = ACTIONS(448),
    [anon_sym_get] = ACTIONS(448),
    [anon_sym_set] = ACTIONS(448),
    [sym__automatic_semicolon] = ACTIONS(454),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(456),
    [sym_identifier] = ACTIONS(458),
    [anon_sym_export] = ACTIONS(458),
    [anon_sym_STAR] = ACTIONS(458),
    [anon_sym_default] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(456),
    [anon_sym_COMMA] = ACTIONS(456),
    [anon_sym_RBRACE] = ACTIONS(456),
    [anon_sym_import] = ACTIONS(458),
    [anon_sym_var] = ACTIONS(458),
    [anon_sym_let] = ACTIONS(458),
    [anon_sym_const] = ACTIONS(458),
    [anon_sym_if] = ACTIONS(458),
    [anon_sym_else] = ACTIONS(458),
    [anon_sym_switch] = ACTIONS(458),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(456),
    [anon_sym_await] = ACTIONS(458),
    [anon_sym_in] = ACTIONS(458),
    [anon_sym_while] = ACTIONS(458),
    [anon_sym_do] = ACTIONS(458),
    [anon_sym_try] = ACTIONS(458),
    [anon_sym_with] = ACTIONS(458),
    [anon_sym_break] = ACTIONS(458),
    [anon_sym_continue] = ACTIONS(458),
    [anon_sym_debugger] = ACTIONS(458),
    [anon_sym_return] = ACTIONS(458),
    [anon_sym_throw] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(456),
    [anon_sym_case] = ACTIONS(458),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(456),
    [anon_sym_LT] = ACTIONS(458),
    [anon_sym_GT] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(458),
    [anon_sym_DOT] = ACTIONS(458),
    [anon_sym_class] = ACTIONS(458),
    [anon_sym_async] = ACTIONS(458),
    [anon_sym_function] = ACTIONS(458),
    [anon_sym_new] = ACTIONS(458),
    [anon_sym_QMARK] = ACTIONS(458),
    [anon_sym_AMP_AMP] = ACTIONS(456),
    [anon_sym_PIPE_PIPE] = ACTIONS(456),
    [anon_sym_GT_GT] = ACTIONS(458),
    [anon_sym_GT_GT_GT] = ACTIONS(456),
    [anon_sym_LT_LT] = ACTIONS(456),
    [anon_sym_AMP] = ACTIONS(458),
    [anon_sym_CARET] = ACTIONS(456),
    [anon_sym_PIPE] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_PERCENT] = ACTIONS(456),
    [anon_sym_STAR_STAR] = ACTIONS(456),
    [anon_sym_LT_EQ] = ACTIONS(456),
    [anon_sym_EQ_EQ] = ACTIONS(458),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(456),
    [anon_sym_BANG_EQ] = ACTIONS(458),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(456),
    [anon_sym_GT_EQ] = ACTIONS(456),
    [anon_sym_QMARK_QMARK] = ACTIONS(456),
    [anon_sym_instanceof] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(456),
    [anon_sym_typeof] = ACTIONS(458),
    [anon_sym_void] = ACTIONS(458),
    [anon_sym_delete] = ACTIONS(458),
    [anon_sym_PLUS_PLUS] = ACTIONS(456),
    [anon_sym_DASH_DASH] = ACTIONS(456),
    [anon_sym_DQUOTE] = ACTIONS(456),
    [anon_sym_SQUOTE] = ACTIONS(456),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(456),
    [sym_number] = ACTIONS(456),
    [sym_this] = ACTIONS(458),
    [sym_super] = ACTIONS(458),
    [sym_true] = ACTIONS(458),
    [sym_false] = ACTIONS(458),
    [sym_null] = ACTIONS(458),
    [sym_undefined] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(456),
    [anon_sym_static] = ACTIONS(458),
    [anon_sym_get] = ACTIONS(458),
    [anon_sym_set] = ACTIONS(458),
    [sym__automatic_semicolon] = ACTIONS(456),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(460),
    [sym_identifier] = ACTIONS(462),
    [anon_sym_export] = ACTIONS(462),
    [anon_sym_STAR] = ACTIONS(464),
    [anon_sym_default] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(462),
    [anon_sym_var] = ACTIONS(462),
    [anon_sym_let] = ACTIONS(462),
    [anon_sym_const] = ACTIONS(462),
    [anon_sym_if] = ACTIONS(462),
    [anon_sym_else] = ACTIONS(462),
    [anon_sym_switch] = ACTIONS(462),
    [anon_sym_for] = ACTIONS(462),
    [anon_sym_LPAREN] = ACTIONS(460),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_in] = ACTIONS(464),
    [anon_sym_while] = ACTIONS(462),
    [anon_sym_do] = ACTIONS(462),
    [anon_sym_try] = ACTIONS(462),
    [anon_sym_with] = ACTIONS(462),
    [anon_sym_break] = ACTIONS(462),
    [anon_sym_continue] = ACTIONS(462),
    [anon_sym_debugger] = ACTIONS(462),
    [anon_sym_return] = ACTIONS(462),
    [anon_sym_throw] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(460),
    [anon_sym_case] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(462),
    [anon_sym_LBRACK] = ACTIONS(460),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(464),
    [anon_sym_SLASH] = ACTIONS(462),
    [anon_sym_DOT] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(462),
    [anon_sym_async] = ACTIONS(462),
    [anon_sym_function] = ACTIONS(462),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_QMARK] = ACTIONS(464),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_GT_GT] = ACTIONS(464),
    [anon_sym_GT_GT_GT] = ACTIONS(466),
    [anon_sym_LT_LT] = ACTIONS(466),
    [anon_sym_AMP] = ACTIONS(464),
    [anon_sym_CARET] = ACTIONS(466),
    [anon_sym_PIPE] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(462),
    [anon_sym_DASH] = ACTIONS(462),
    [anon_sym_PERCENT] = ACTIONS(466),
    [anon_sym_STAR_STAR] = ACTIONS(466),
    [anon_sym_LT_EQ] = ACTIONS(466),
    [anon_sym_EQ_EQ] = ACTIONS(464),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(466),
    [anon_sym_BANG_EQ] = ACTIONS(464),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(466),
    [anon_sym_GT_EQ] = ACTIONS(466),
    [anon_sym_QMARK_QMARK] = ACTIONS(466),
    [anon_sym_instanceof] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(460),
    [anon_sym_typeof] = ACTIONS(462),
    [anon_sym_void] = ACTIONS(462),
    [anon_sym_delete] = ACTIONS(462),
    [anon_sym_PLUS_PLUS] = ACTIONS(460),
    [anon_sym_DASH_DASH] = ACTIONS(460),
    [anon_sym_DQUOTE] = ACTIONS(460),
    [anon_sym_SQUOTE] = ACTIONS(460),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(460),
    [sym_number] = ACTIONS(460),
    [sym_this] = ACTIONS(462),
    [sym_super] = ACTIONS(462),
    [sym_true] = ACTIONS(462),
    [sym_false] = ACTIONS(462),
    [sym_null] = ACTIONS(462),
    [sym_undefined] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_static] = ACTIONS(462),
    [anon_sym_get] = ACTIONS(462),
    [anon_sym_set] = ACTIONS(462),
    [sym__automatic_semicolon] = ACTIONS(468),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(470),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(472),
    [anon_sym_STAR] = ACTIONS(474),
    [anon_sym_default] = ACTIONS(472),
    [anon_sym_LBRACE] = ACTIONS(470),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_import] = ACTIONS(472),
    [anon_sym_var] = ACTIONS(472),
    [anon_sym_let] = ACTIONS(472),
    [anon_sym_const] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_else] = ACTIONS(472),
    [anon_sym_switch] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [anon_sym_LPAREN] = ACTIONS(470),
    [anon_sym_await] = ACTIONS(472),
    [anon_sym_in] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(472),
    [anon_sym_do] = ACTIONS(472),
    [anon_sym_try] = ACTIONS(472),
    [anon_sym_with] = ACTIONS(472),
    [anon_sym_break] = ACTIONS(472),
    [anon_sym_continue] = ACTIONS(472),
    [anon_sym_debugger] = ACTIONS(472),
    [anon_sym_return] = ACTIONS(472),
    [anon_sym_throw] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_case] = ACTIONS(472),
    [anon_sym_yield] = ACTIONS(472),
    [anon_sym_LBRACK] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(472),
    [anon_sym_GT] = ACTIONS(474),
    [anon_sym_SLASH] = ACTIONS(472),
    [anon_sym_DOT] = ACTIONS(474),
    [anon_sym_class] = ACTIONS(472),
    [anon_sym_async] = ACTIONS(472),
    [anon_sym_function] = ACTIONS(472),
    [anon_sym_new] = ACTIONS(472),
    [anon_sym_QMARK] = ACTIONS(474),
    [anon_sym_AMP_AMP] = ACTIONS(476),
    [anon_sym_PIPE_PIPE] = ACTIONS(476),
    [anon_sym_GT_GT] = ACTIONS(474),
    [anon_sym_GT_GT_GT] = ACTIONS(476),
    [anon_sym_LT_LT] = ACTIONS(476),
    [anon_sym_AMP] = ACTIONS(474),
    [anon_sym_CARET] = ACTIONS(476),
    [anon_sym_PIPE] = ACTIONS(474),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_PERCENT] = ACTIONS(476),
    [anon_sym_STAR_STAR] = ACTIONS(476),
    [anon_sym_LT_EQ] = ACTIONS(476),
    [anon_sym_EQ_EQ] = ACTIONS(474),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(476),
    [anon_sym_BANG_EQ] = ACTIONS(474),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(476),
    [anon_sym_GT_EQ] = ACTIONS(476),
    [anon_sym_QMARK_QMARK] = ACTIONS(476),
    [anon_sym_instanceof] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(472),
    [anon_sym_TILDE] = ACTIONS(470),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(470),
    [anon_sym_DASH_DASH] = ACTIONS(470),
    [anon_sym_DQUOTE] = ACTIONS(470),
    [anon_sym_SQUOTE] = ACTIONS(470),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(470),
    [sym_number] = ACTIONS(470),
    [sym_this] = ACTIONS(472),
    [sym_super] = ACTIONS(472),
    [sym_true] = ACTIONS(472),
    [sym_false] = ACTIONS(472),
    [sym_null] = ACTIONS(472),
    [sym_undefined] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_static] = ACTIONS(472),
    [anon_sym_get] = ACTIONS(472),
    [anon_sym_set] = ACTIONS(472),
    [sym__automatic_semicolon] = ACTIONS(478),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(480),
    [sym_identifier] = ACTIONS(482),
    [anon_sym_export] = ACTIONS(482),
    [anon_sym_STAR] = ACTIONS(482),
    [anon_sym_default] = ACTIONS(482),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_COMMA] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_import] = ACTIONS(482),
    [anon_sym_var] = ACTIONS(482),
    [anon_sym_let] = ACTIONS(482),
    [anon_sym_const] = ACTIONS(482),
    [anon_sym_if] = ACTIONS(482),
    [anon_sym_else] = ACTIONS(482),
    [anon_sym_switch] = ACTIONS(482),
    [anon_sym_for] = ACTIONS(482),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_await] = ACTIONS(482),
    [anon_sym_in] = ACTIONS(482),
    [anon_sym_while] = ACTIONS(482),
    [anon_sym_do] = ACTIONS(482),
    [anon_sym_try] = ACTIONS(482),
    [anon_sym_with] = ACTIONS(482),
    [anon_sym_break] = ACTIONS(482),
    [anon_sym_continue] = ACTIONS(482),
    [anon_sym_debugger] = ACTIONS(482),
    [anon_sym_return] = ACTIONS(482),
    [anon_sym_throw] = ACTIONS(482),
    [anon_sym_SEMI] = ACTIONS(480),
    [anon_sym_case] = ACTIONS(482),
    [anon_sym_yield] = ACTIONS(482),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_GT] = ACTIONS(482),
    [anon_sym_SLASH] = ACTIONS(482),
    [anon_sym_DOT] = ACTIONS(482),
    [anon_sym_class] = ACTIONS(482),
    [anon_sym_async] = ACTIONS(482),
    [anon_sym_function] = ACTIONS(482),
    [anon_sym_new] = ACTIONS(482),
    [anon_sym_QMARK] = ACTIONS(482),
    [anon_sym_AMP_AMP] = ACTIONS(480),
    [anon_sym_PIPE_PIPE] = ACTIONS(480),
    [anon_sym_GT_GT] = ACTIONS(482),
    [anon_sym_GT_GT_GT] = ACTIONS(480),
    [anon_sym_LT_LT] = ACTIONS(480),
    [anon_sym_AMP] = ACTIONS(482),
    [anon_sym_CARET] = ACTIONS(480),
    [anon_sym_PIPE] = ACTIONS(482),
    [anon_sym_PLUS] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_PERCENT] = ACTIONS(480),
    [anon_sym_STAR_STAR] = ACTIONS(480),
    [anon_sym_LT_EQ] = ACTIONS(480),
    [anon_sym_EQ_EQ] = ACTIONS(482),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(480),
    [anon_sym_BANG_EQ] = ACTIONS(482),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(480),
    [anon_sym_GT_EQ] = ACTIONS(480),
    [anon_sym_QMARK_QMARK] = ACTIONS(480),
    [anon_sym_instanceof] = ACTIONS(482),
    [anon_sym_BANG] = ACTIONS(482),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_typeof] = ACTIONS(482),
    [anon_sym_void] = ACTIONS(482),
    [anon_sym_delete] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(480),
    [anon_sym_DASH_DASH] = ACTIONS(480),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(480),
    [sym_number] = ACTIONS(480),
    [sym_this] = ACTIONS(482),
    [sym_super] = ACTIONS(482),
    [sym_true] = ACTIONS(482),
    [sym_false] = ACTIONS(482),
    [sym_null] = ACTIONS(482),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_static] = ACTIONS(482),
    [anon_sym_get] = ACTIONS(482),
    [anon_sym_set] = ACTIONS(482),
    [sym__automatic_semicolon] = ACTIONS(480),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(484),
    [sym_identifier] = ACTIONS(486),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_STAR] = ACTIONS(488),
    [anon_sym_default] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(484),
    [anon_sym_COMMA] = ACTIONS(490),
    [anon_sym_RBRACE] = ACTIONS(484),
    [anon_sym_import] = ACTIONS(486),
    [anon_sym_var] = ACTIONS(486),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_const] = ACTIONS(486),
    [anon_sym_if] = ACTIONS(486),
    [anon_sym_else] = ACTIONS(486),
    [anon_sym_switch] = ACTIONS(486),
    [anon_sym_for] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(484),
    [anon_sym_await] = ACTIONS(486),
    [anon_sym_in] = ACTIONS(488),
    [anon_sym_while] = ACTIONS(486),
    [anon_sym_do] = ACTIONS(486),
    [anon_sym_try] = ACTIONS(486),
    [anon_sym_with] = ACTIONS(486),
    [anon_sym_break] = ACTIONS(486),
    [anon_sym_continue] = ACTIONS(486),
    [anon_sym_debugger] = ACTIONS(486),
    [anon_sym_return] = ACTIONS(486),
    [anon_sym_throw] = ACTIONS(486),
    [anon_sym_SEMI] = ACTIONS(484),
    [anon_sym_case] = ACTIONS(486),
    [anon_sym_yield] = ACTIONS(486),
    [anon_sym_LBRACK] = ACTIONS(484),
    [anon_sym_LT] = ACTIONS(486),
    [anon_sym_GT] = ACTIONS(488),
    [anon_sym_SLASH] = ACTIONS(486),
    [anon_sym_DOT] = ACTIONS(488),
    [anon_sym_class] = ACTIONS(486),
    [anon_sym_async] = ACTIONS(486),
    [anon_sym_function] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(486),
    [anon_sym_QMARK] = ACTIONS(488),
    [anon_sym_AMP_AMP] = ACTIONS(490),
    [anon_sym_PIPE_PIPE] = ACTIONS(490),
    [anon_sym_GT_GT] = ACTIONS(488),
    [anon_sym_GT_GT_GT] = ACTIONS(490),
    [anon_sym_LT_LT] = ACTIONS(490),
    [anon_sym_AMP] = ACTIONS(488),
    [anon_sym_CARET] = ACTIONS(490),
    [anon_sym_PIPE] = ACTIONS(488),
    [anon_sym_PLUS] = ACTIONS(486),
    [anon_sym_DASH] = ACTIONS(486),
    [anon_sym_PERCENT] = ACTIONS(490),
    [anon_sym_STAR_STAR] = ACTIONS(490),
    [anon_sym_LT_EQ] = ACTIONS(490),
    [anon_sym_EQ_EQ] = ACTIONS(488),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(490),
    [anon_sym_BANG_EQ] = ACTIONS(488),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(490),
    [anon_sym_GT_EQ] = ACTIONS(490),
    [anon_sym_QMARK_QMARK] = ACTIONS(490),
    [anon_sym_instanceof] = ACTIONS(488),
    [anon_sym_BANG] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(484),
    [anon_sym_typeof] = ACTIONS(486),
    [anon_sym_void] = ACTIONS(486),
    [anon_sym_delete] = ACTIONS(486),
    [anon_sym_PLUS_PLUS] = ACTIONS(484),
    [anon_sym_DASH_DASH] = ACTIONS(484),
    [anon_sym_DQUOTE] = ACTIONS(484),
    [anon_sym_SQUOTE] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(484),
    [sym_number] = ACTIONS(484),
    [sym_this] = ACTIONS(486),
    [sym_super] = ACTIONS(486),
    [sym_true] = ACTIONS(486),
    [sym_false] = ACTIONS(486),
    [sym_null] = ACTIONS(486),
    [sym_undefined] = ACTIONS(486),
    [anon_sym_AT] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym__automatic_semicolon] = ACTIONS(492),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [anon_sym_export] = ACTIONS(496),
    [anon_sym_STAR] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_var] = ACTIONS(496),
    [anon_sym_let] = ACTIONS(496),
    [anon_sym_const] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_await] = ACTIONS(496),
    [anon_sym_in] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_with] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_debugger] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_yield] = ACTIONS(496),
    [anon_sym_LBRACK] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(496),
    [anon_sym_GT] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(496),
    [anon_sym_DOT] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_async] = ACTIONS(496),
    [anon_sym_function] = ACTIONS(496),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_QMARK] = ACTIONS(496),
    [anon_sym_AMP_AMP] = ACTIONS(494),
    [anon_sym_PIPE_PIPE] = ACTIONS(494),
    [anon_sym_GT_GT] = ACTIONS(496),
    [anon_sym_GT_GT_GT] = ACTIONS(494),
    [anon_sym_LT_LT] = ACTIONS(494),
    [anon_sym_AMP] = ACTIONS(496),
    [anon_sym_CARET] = ACTIONS(494),
    [anon_sym_PIPE] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_PERCENT] = ACTIONS(494),
    [anon_sym_STAR_STAR] = ACTIONS(494),
    [anon_sym_LT_EQ] = ACTIONS(494),
    [anon_sym_EQ_EQ] = ACTIONS(496),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(494),
    [anon_sym_BANG_EQ] = ACTIONS(496),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(494),
    [anon_sym_GT_EQ] = ACTIONS(494),
    [anon_sym_QMARK_QMARK] = ACTIONS(494),
    [anon_sym_instanceof] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(496),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_typeof] = ACTIONS(496),
    [anon_sym_void] = ACTIONS(496),
    [anon_sym_delete] = ACTIONS(496),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_DQUOTE] = ACTIONS(494),
    [anon_sym_SQUOTE] = ACTIONS(494),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(494),
    [sym_number] = ACTIONS(494),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_null] = ACTIONS(496),
    [sym_undefined] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(494),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_get] = ACTIONS(496),
    [anon_sym_set] = ACTIONS(496),
    [sym__automatic_semicolon] = ACTIONS(494),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [anon_sym_export] = ACTIONS(496),
    [anon_sym_STAR] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_var] = ACTIONS(496),
    [anon_sym_let] = ACTIONS(496),
    [anon_sym_const] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_await] = ACTIONS(496),
    [anon_sym_in] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_with] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_debugger] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_yield] = ACTIONS(496),
    [anon_sym_LBRACK] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(496),
    [anon_sym_GT] = ACTIONS(496),
    [anon_sym_SLASH] = ACTIONS(496),
    [anon_sym_DOT] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_async] = ACTIONS(496),
    [anon_sym_function] = ACTIONS(496),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_QMARK] = ACTIONS(496),
    [anon_sym_AMP_AMP] = ACTIONS(494),
    [anon_sym_PIPE_PIPE] = ACTIONS(494),
    [anon_sym_GT_GT] = ACTIONS(496),
    [anon_sym_GT_GT_GT] = ACTIONS(494),
    [anon_sym_LT_LT] = ACTIONS(494),
    [anon_sym_AMP] = ACTIONS(496),
    [anon_sym_CARET] = ACTIONS(494),
    [anon_sym_PIPE] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_PERCENT] = ACTIONS(494),
    [anon_sym_STAR_STAR] = ACTIONS(494),
    [anon_sym_LT_EQ] = ACTIONS(494),
    [anon_sym_EQ_EQ] = ACTIONS(496),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(494),
    [anon_sym_BANG_EQ] = ACTIONS(496),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(494),
    [anon_sym_GT_EQ] = ACTIONS(494),
    [anon_sym_QMARK_QMARK] = ACTIONS(494),
    [anon_sym_instanceof] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(496),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_typeof] = ACTIONS(496),
    [anon_sym_void] = ACTIONS(496),
    [anon_sym_delete] = ACTIONS(496),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_DQUOTE] = ACTIONS(494),
    [anon_sym_SQUOTE] = ACTIONS(494),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(494),
    [sym_number] = ACTIONS(494),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_null] = ACTIONS(496),
    [sym_undefined] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(494),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_get] = ACTIONS(496),
    [anon_sym_set] = ACTIONS(496),
    [sym__automatic_semicolon] = ACTIONS(498),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(392),
    [sym_identifier] = ACTIONS(394),
    [anon_sym_export] = ACTIONS(394),
    [anon_sym_STAR] = ACTIONS(394),
    [anon_sym_default] = ACTIONS(394),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_COMMA] = ACTIONS(392),
    [anon_sym_RBRACE] = ACTIONS(392),
    [anon_sym_import] = ACTIONS(394),
    [anon_sym_var] = ACTIONS(394),
    [anon_sym_let] = ACTIONS(394),
    [anon_sym_const] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(394),
    [anon_sym_else] = ACTIONS(394),
    [anon_sym_switch] = ACTIONS(394),
    [anon_sym_for] = ACTIONS(394),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_await] = ACTIONS(394),
    [anon_sym_in] = ACTIONS(394),
    [anon_sym_while] = ACTIONS(394),
    [anon_sym_do] = ACTIONS(394),
    [anon_sym_try] = ACTIONS(394),
    [anon_sym_with] = ACTIONS(394),
    [anon_sym_break] = ACTIONS(394),
    [anon_sym_continue] = ACTIONS(394),
    [anon_sym_debugger] = ACTIONS(394),
    [anon_sym_return] = ACTIONS(394),
    [anon_sym_throw] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(392),
    [anon_sym_case] = ACTIONS(394),
    [anon_sym_yield] = ACTIONS(394),
    [anon_sym_LBRACK] = ACTIONS(392),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(394),
    [anon_sym_DOT] = ACTIONS(394),
    [anon_sym_class] = ACTIONS(394),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(394),
    [anon_sym_new] = ACTIONS(394),
    [anon_sym_QMARK] = ACTIONS(394),
    [anon_sym_AMP_AMP] = ACTIONS(392),
    [anon_sym_PIPE_PIPE] = ACTIONS(392),
    [anon_sym_GT_GT] = ACTIONS(394),
    [anon_sym_GT_GT_GT] = ACTIONS(392),
    [anon_sym_LT_LT] = ACTIONS(392),
    [anon_sym_AMP] = ACTIONS(394),
    [anon_sym_CARET] = ACTIONS(392),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_PERCENT] = ACTIONS(392),
    [anon_sym_STAR_STAR] = ACTIONS(392),
    [anon_sym_LT_EQ] = ACTIONS(392),
    [anon_sym_EQ_EQ] = ACTIONS(394),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(392),
    [anon_sym_BANG_EQ] = ACTIONS(394),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(392),
    [anon_sym_GT_EQ] = ACTIONS(392),
    [anon_sym_QMARK_QMARK] = ACTIONS(392),
    [anon_sym_instanceof] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(392),
    [anon_sym_DASH_DASH] = ACTIONS(392),
    [anon_sym_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE] = ACTIONS(392),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(392),
    [sym_number] = ACTIONS(392),
    [sym_this] = ACTIONS(394),
    [sym_super] = ACTIONS(394),
    [sym_true] = ACTIONS(394),
    [sym_false] = ACTIONS(394),
    [sym_null] = ACTIONS(394),
    [sym_undefined] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_static] = ACTIONS(394),
    [anon_sym_get] = ACTIONS(394),
    [anon_sym_set] = ACTIONS(394),
    [sym__automatic_semicolon] = ACTIONS(500),
  },
  [60] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(72),
    [sym_variable_declaration] = STATE(72),
    [sym_lexical_declaration] = STATE(72),
    [sym_empty_statement] = STATE(72),
    [sym_parenthesized_expression] = STATE(303),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(490),
    [sym_array] = STATE(489),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(303),
    [sym_subscript_expression] = STATE(303),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(502),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_var] = ACTIONS(504),
    [anon_sym_let] = ACTIONS(506),
    [anon_sym_const] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(508),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_get] = ACTIONS(510),
    [anon_sym_set] = ACTIONS(510),
  },
  [61] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(73),
    [sym_variable_declaration] = STATE(73),
    [sym_lexical_declaration] = STATE(73),
    [sym_empty_statement] = STATE(73),
    [sym_parenthesized_expression] = STATE(303),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(490),
    [sym_array] = STATE(489),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(303),
    [sym_subscript_expression] = STATE(303),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(502),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_var] = ACTIONS(504),
    [anon_sym_let] = ACTIONS(506),
    [anon_sym_const] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(508),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_get] = ACTIONS(510),
    [anon_sym_set] = ACTIONS(510),
  },
  [62] = {
    [sym_import] = STATE(479),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(479),
    [sym_yield_expression] = STATE(479),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(479),
    [sym_jsx_fragment] = STATE(479),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(479),
    [sym_class] = STATE(479),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(479),
    [sym_arrow_function] = STATE(479),
    [sym_call_expression] = STATE(479),
    [sym_new_expression] = STATE(479),
    [sym_await_expression] = STATE(479),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(479),
    [sym_augmented_assignment_expression] = STATE(479),
    [sym_spread_element] = STATE(831),
    [sym_ternary_expression] = STATE(479),
    [sym_binary_expression] = STATE(479),
    [sym_unary_expression] = STATE(479),
    [sym_update_expression] = STATE(479),
    [sym_string] = STATE(479),
    [sym_template_string] = STATE(479),
    [sym_regex] = STATE(479),
    [sym_meta_property] = STATE(479),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(837),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(514),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(518),
    [sym_this] = ACTIONS(520),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(520),
    [sym_false] = ACTIONS(520),
    [sym_null] = ACTIONS(520),
    [sym_undefined] = ACTIONS(520),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [63] = {
    [sym_import] = STATE(457),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(457),
    [sym_yield_expression] = STATE(457),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(457),
    [sym_jsx_fragment] = STATE(457),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(457),
    [sym_class] = STATE(457),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(457),
    [sym_arrow_function] = STATE(457),
    [sym_call_expression] = STATE(457),
    [sym_new_expression] = STATE(457),
    [sym_await_expression] = STATE(457),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(457),
    [sym_augmented_assignment_expression] = STATE(457),
    [sym_spread_element] = STATE(810),
    [sym_ternary_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym_string] = STATE(457),
    [sym_template_string] = STATE(457),
    [sym_regex] = STATE(457),
    [sym_meta_property] = STATE(457),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(879),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(522),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(524),
    [sym_this] = ACTIONS(526),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(526),
    [sym_false] = ACTIONS(526),
    [sym_null] = ACTIONS(526),
    [sym_undefined] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [64] = {
    [sym_import] = STATE(465),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(465),
    [sym_yield_expression] = STATE(465),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(465),
    [sym_jsx_fragment] = STATE(465),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(465),
    [sym_class] = STATE(465),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(465),
    [sym_arrow_function] = STATE(465),
    [sym_call_expression] = STATE(465),
    [sym_new_expression] = STATE(465),
    [sym_await_expression] = STATE(465),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(465),
    [sym_augmented_assignment_expression] = STATE(465),
    [sym_spread_element] = STATE(859),
    [sym_ternary_expression] = STATE(465),
    [sym_binary_expression] = STATE(465),
    [sym_unary_expression] = STATE(465),
    [sym_update_expression] = STATE(465),
    [sym_string] = STATE(465),
    [sym_template_string] = STATE(465),
    [sym_regex] = STATE(465),
    [sym_meta_property] = STATE(465),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(528),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(528),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(528),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(530),
    [sym_this] = ACTIONS(532),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_null] = ACTIONS(532),
    [sym_undefined] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [65] = {
    [sym_import] = STATE(460),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(460),
    [sym_yield_expression] = STATE(460),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(460),
    [sym_jsx_fragment] = STATE(460),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(460),
    [sym_class] = STATE(460),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(460),
    [sym_arrow_function] = STATE(460),
    [sym_call_expression] = STATE(460),
    [sym_new_expression] = STATE(460),
    [sym_await_expression] = STATE(460),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(460),
    [sym_augmented_assignment_expression] = STATE(460),
    [sym_spread_element] = STATE(831),
    [sym_ternary_expression] = STATE(460),
    [sym_binary_expression] = STATE(460),
    [sym_unary_expression] = STATE(460),
    [sym_update_expression] = STATE(460),
    [sym_string] = STATE(460),
    [sym_template_string] = STATE(460),
    [sym_regex] = STATE(460),
    [sym_meta_property] = STATE(460),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(837),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(514),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(534),
    [sym_this] = ACTIONS(536),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [sym_null] = ACTIONS(536),
    [sym_undefined] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [66] = {
    [sym_import] = STATE(469),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(469),
    [sym_yield_expression] = STATE(469),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(469),
    [sym_jsx_fragment] = STATE(469),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(469),
    [sym_class] = STATE(469),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(469),
    [sym_arrow_function] = STATE(469),
    [sym_call_expression] = STATE(469),
    [sym_new_expression] = STATE(469),
    [sym_await_expression] = STATE(469),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(469),
    [sym_augmented_assignment_expression] = STATE(469),
    [sym_spread_element] = STATE(810),
    [sym_ternary_expression] = STATE(469),
    [sym_binary_expression] = STATE(469),
    [sym_unary_expression] = STATE(469),
    [sym_update_expression] = STATE(469),
    [sym_string] = STATE(469),
    [sym_template_string] = STATE(469),
    [sym_regex] = STATE(469),
    [sym_meta_property] = STATE(469),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(879),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_RBRACK] = ACTIONS(522),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(538),
    [sym_this] = ACTIONS(540),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(540),
    [sym_false] = ACTIONS(540),
    [sym_null] = ACTIONS(540),
    [sym_undefined] = ACTIONS(540),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [67] = {
    [sym_import] = STATE(520),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(520),
    [sym_yield_expression] = STATE(520),
    [sym_object] = STATE(528),
    [sym_assignment_pattern] = STATE(829),
    [sym_array] = STATE(494),
    [sym_jsx_element] = STATE(520),
    [sym_jsx_fragment] = STATE(520),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(520),
    [sym_class] = STATE(520),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(520),
    [sym_arrow_function] = STATE(520),
    [sym_call_expression] = STATE(520),
    [sym_new_expression] = STATE(520),
    [sym_await_expression] = STATE(520),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(520),
    [sym_augmented_assignment_expression] = STATE(520),
    [sym_ternary_expression] = STATE(520),
    [sym_binary_expression] = STATE(520),
    [sym_unary_expression] = STATE(520),
    [sym_update_expression] = STATE(520),
    [sym_sequence_expression] = STATE(1059),
    [sym_string] = STATE(520),
    [sym_template_string] = STATE(520),
    [sym_regex] = STATE(520),
    [sym_meta_property] = STATE(520),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [sym_rest_parameter] = STATE(829),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(546),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(548),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(550),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_null] = ACTIONS(552),
    [sym_undefined] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
  },
  [68] = {
    [sym_import] = STATE(477),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(477),
    [sym_yield_expression] = STATE(477),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(477),
    [sym_jsx_fragment] = STATE(477),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(477),
    [sym_class] = STATE(477),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(477),
    [sym_arrow_function] = STATE(477),
    [sym_call_expression] = STATE(477),
    [sym_new_expression] = STATE(477),
    [sym_await_expression] = STATE(477),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(477),
    [sym_augmented_assignment_expression] = STATE(477),
    [sym_spread_element] = STATE(863),
    [sym_ternary_expression] = STATE(477),
    [sym_binary_expression] = STATE(477),
    [sym_unary_expression] = STATE(477),
    [sym_update_expression] = STATE(477),
    [sym_string] = STATE(477),
    [sym_template_string] = STATE(477),
    [sym_regex] = STATE(477),
    [sym_meta_property] = STATE(477),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(862),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(556),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(558),
    [sym_this] = ACTIONS(560),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(560),
    [sym_false] = ACTIONS(560),
    [sym_null] = ACTIONS(560),
    [sym_undefined] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [69] = {
    [sym_import] = STATE(478),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(478),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(478),
    [sym_arrow_function] = STATE(478),
    [sym_call_expression] = STATE(478),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(860),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_string] = STATE(478),
    [sym_template_string] = STATE(478),
    [sym_regex] = STATE(478),
    [sym_meta_property] = STATE(478),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [aux_sym_array_repeat1] = STATE(861),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_COMMA] = ACTIONS(512),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(562),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(564),
    [sym_this] = ACTIONS(566),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(566),
    [sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(566),
    [sym_undefined] = ACTIONS(566),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [70] = {
    [sym_import] = STATE(496),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(496),
    [sym_yield_expression] = STATE(496),
    [sym_object] = STATE(528),
    [sym_assignment_pattern] = STATE(829),
    [sym_array] = STATE(494),
    [sym_jsx_element] = STATE(496),
    [sym_jsx_fragment] = STATE(496),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(496),
    [sym_class] = STATE(496),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(496),
    [sym_arrow_function] = STATE(496),
    [sym_call_expression] = STATE(496),
    [sym_new_expression] = STATE(496),
    [sym_await_expression] = STATE(496),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(496),
    [sym_augmented_assignment_expression] = STATE(496),
    [sym_ternary_expression] = STATE(496),
    [sym_binary_expression] = STATE(496),
    [sym_unary_expression] = STATE(496),
    [sym_update_expression] = STATE(496),
    [sym_sequence_expression] = STATE(1100),
    [sym_string] = STATE(496),
    [sym_template_string] = STATE(496),
    [sym_regex] = STATE(496),
    [sym_meta_property] = STATE(496),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [sym_rest_parameter] = STATE(829),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(544),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(546),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(548),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(568),
    [sym_this] = ACTIONS(570),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(570),
    [sym_false] = ACTIONS(570),
    [sym_null] = ACTIONS(570),
    [sym_undefined] = ACTIONS(570),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
  },
  [71] = {
    [sym_import] = STATE(542),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(542),
    [sym_yield_expression] = STATE(542),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(542),
    [sym_jsx_fragment] = STATE(542),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(542),
    [sym_class] = STATE(542),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(542),
    [sym_arrow_function] = STATE(542),
    [sym_call_expression] = STATE(542),
    [sym_new_expression] = STATE(542),
    [sym_await_expression] = STATE(542),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(542),
    [sym_augmented_assignment_expression] = STATE(542),
    [sym_spread_element] = STATE(1112),
    [sym_ternary_expression] = STATE(542),
    [sym_binary_expression] = STATE(542),
    [sym_unary_expression] = STATE(542),
    [sym_update_expression] = STATE(542),
    [sym_sequence_expression] = STATE(1112),
    [sym_string] = STATE(542),
    [sym_template_string] = STATE(542),
    [sym_regex] = STATE(542),
    [sym_meta_property] = STATE(542),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_RBRACE] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(574),
    [sym_this] = ACTIONS(576),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(576),
    [sym_false] = ACTIONS(576),
    [sym_null] = ACTIONS(576),
    [sym_undefined] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [72] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(77),
    [sym_empty_statement] = STATE(77),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [73] = {
    [sym_import] = STATE(481),
    [sym_expression_statement] = STATE(78),
    [sym_empty_statement] = STATE(78),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(481),
    [sym_yield_expression] = STATE(481),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(481),
    [sym_jsx_fragment] = STATE(481),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(481),
    [sym_class] = STATE(481),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(481),
    [sym_arrow_function] = STATE(481),
    [sym_call_expression] = STATE(481),
    [sym_new_expression] = STATE(481),
    [sym_await_expression] = STATE(481),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(481),
    [sym_augmented_assignment_expression] = STATE(481),
    [sym_ternary_expression] = STATE(481),
    [sym_binary_expression] = STATE(481),
    [sym_unary_expression] = STATE(481),
    [sym_update_expression] = STATE(481),
    [sym_sequence_expression] = STATE(954),
    [sym_string] = STATE(481),
    [sym_template_string] = STATE(481),
    [sym_regex] = STATE(481),
    [sym_meta_property] = STATE(481),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [74] = {
    [sym_import] = STATE(560),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(560),
    [sym_yield_expression] = STATE(560),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(560),
    [sym_jsx_fragment] = STATE(560),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(560),
    [sym_class] = STATE(560),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(560),
    [sym_arrow_function] = STATE(560),
    [sym_call_expression] = STATE(560),
    [sym_new_expression] = STATE(560),
    [sym_await_expression] = STATE(560),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(560),
    [sym_augmented_assignment_expression] = STATE(560),
    [sym_spread_element] = STATE(1081),
    [sym_ternary_expression] = STATE(560),
    [sym_binary_expression] = STATE(560),
    [sym_unary_expression] = STATE(560),
    [sym_update_expression] = STATE(560),
    [sym_sequence_expression] = STATE(1081),
    [sym_string] = STATE(560),
    [sym_template_string] = STATE(560),
    [sym_regex] = STATE(560),
    [sym_meta_property] = STATE(560),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(580),
    [sym_this] = ACTIONS(582),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(582),
    [sym_false] = ACTIONS(582),
    [sym_null] = ACTIONS(582),
    [sym_undefined] = ACTIONS(582),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [75] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(310),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(571),
    [sym_array] = STATE(575),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(310),
    [sym_subscript_expression] = STATE(310),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_var] = ACTIONS(586),
    [anon_sym_let] = ACTIONS(586),
    [anon_sym_const] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(588),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(590),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_null] = ACTIONS(592),
    [sym_undefined] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(594),
    [anon_sym_get] = ACTIONS(594),
    [anon_sym_set] = ACTIONS(594),
  },
  [76] = {
    [sym_import] = STATE(488),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(488),
    [sym_yield_expression] = STATE(488),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(488),
    [sym_jsx_fragment] = STATE(488),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(488),
    [sym_class] = STATE(488),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(488),
    [sym_arrow_function] = STATE(488),
    [sym_call_expression] = STATE(488),
    [sym_new_expression] = STATE(488),
    [sym_await_expression] = STATE(488),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(488),
    [sym_augmented_assignment_expression] = STATE(488),
    [sym_ternary_expression] = STATE(488),
    [sym_binary_expression] = STATE(488),
    [sym_unary_expression] = STATE(488),
    [sym_update_expression] = STATE(488),
    [sym_sequence_expression] = STATE(908),
    [sym_string] = STATE(488),
    [sym_template_string] = STATE(488),
    [sym_regex] = STATE(488),
    [sym_meta_property] = STATE(488),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(596),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(598),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_null] = ACTIONS(600),
    [sym_undefined] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
    [sym__automatic_semicolon] = ACTIONS(596),
  },
  [77] = {
    [sym_import] = STATE(504),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(504),
    [sym_yield_expression] = STATE(504),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(504),
    [sym_jsx_fragment] = STATE(504),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(504),
    [sym_class] = STATE(504),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(504),
    [sym_arrow_function] = STATE(504),
    [sym_call_expression] = STATE(504),
    [sym_new_expression] = STATE(504),
    [sym_await_expression] = STATE(504),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(504),
    [sym_augmented_assignment_expression] = STATE(504),
    [sym_ternary_expression] = STATE(504),
    [sym_binary_expression] = STATE(504),
    [sym_unary_expression] = STATE(504),
    [sym_update_expression] = STATE(504),
    [sym_sequence_expression] = STATE(1105),
    [sym_string] = STATE(504),
    [sym_template_string] = STATE(504),
    [sym_regex] = STATE(504),
    [sym_meta_property] = STATE(504),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(602),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(604),
    [sym_this] = ACTIONS(606),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_null] = ACTIONS(606),
    [sym_undefined] = ACTIONS(606),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [78] = {
    [sym_import] = STATE(503),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(503),
    [sym_yield_expression] = STATE(503),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(503),
    [sym_jsx_fragment] = STATE(503),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(503),
    [sym_class] = STATE(503),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(503),
    [sym_arrow_function] = STATE(503),
    [sym_call_expression] = STATE(503),
    [sym_new_expression] = STATE(503),
    [sym_await_expression] = STATE(503),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(503),
    [sym_augmented_assignment_expression] = STATE(503),
    [sym_ternary_expression] = STATE(503),
    [sym_binary_expression] = STATE(503),
    [sym_unary_expression] = STATE(503),
    [sym_update_expression] = STATE(503),
    [sym_sequence_expression] = STATE(1091),
    [sym_string] = STATE(503),
    [sym_template_string] = STATE(503),
    [sym_regex] = STATE(503),
    [sym_meta_property] = STATE(503),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(608),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(610),
    [sym_this] = ACTIONS(612),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_undefined] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [79] = {
    [sym_import] = STATE(472),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(472),
    [sym_yield_expression] = STATE(472),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(472),
    [sym_jsx_fragment] = STATE(472),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(472),
    [sym_class] = STATE(472),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(472),
    [sym_arrow_function] = STATE(472),
    [sym_call_expression] = STATE(472),
    [sym_new_expression] = STATE(472),
    [sym_await_expression] = STATE(472),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(472),
    [sym_augmented_assignment_expression] = STATE(472),
    [sym_ternary_expression] = STATE(472),
    [sym_binary_expression] = STATE(472),
    [sym_unary_expression] = STATE(472),
    [sym_update_expression] = STATE(472),
    [sym_sequence_expression] = STATE(940),
    [sym_string] = STATE(472),
    [sym_template_string] = STATE(472),
    [sym_regex] = STATE(472),
    [sym_meta_property] = STATE(472),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(614),
    [sym_this] = ACTIONS(616),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(616),
    [sym_false] = ACTIONS(616),
    [sym_null] = ACTIONS(616),
    [sym_undefined] = ACTIONS(616),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [80] = {
    [sym_import] = STATE(404),
    [sym_statement_block] = STATE(546),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(404),
    [sym_yield_expression] = STATE(404),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(404),
    [sym_jsx_fragment] = STATE(404),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(404),
    [sym_class] = STATE(404),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(404),
    [sym_arrow_function] = STATE(404),
    [sym_call_expression] = STATE(404),
    [sym_new_expression] = STATE(404),
    [sym_await_expression] = STATE(404),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(404),
    [sym_augmented_assignment_expression] = STATE(404),
    [sym_ternary_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym_string] = STATE(404),
    [sym_template_string] = STATE(404),
    [sym_regex] = STATE(404),
    [sym_meta_property] = STATE(404),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(620),
    [sym_this] = ACTIONS(622),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(622),
    [sym_false] = ACTIONS(622),
    [sym_null] = ACTIONS(622),
    [sym_undefined] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [81] = {
    [sym_import] = STATE(524),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(524),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_fragment] = STATE(524),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(524),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(524),
    [sym_arrow_function] = STATE(524),
    [sym_call_expression] = STATE(524),
    [sym_new_expression] = STATE(524),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(524),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_sequence_expression] = STATE(1122),
    [sym_string] = STATE(524),
    [sym_template_string] = STATE(524),
    [sym_regex] = STATE(524),
    [sym_meta_property] = STATE(524),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(624),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(626),
    [sym_false] = ACTIONS(626),
    [sym_null] = ACTIONS(626),
    [sym_undefined] = ACTIONS(626),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [82] = {
    [sym_import] = STATE(509),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(509),
    [sym_yield_expression] = STATE(509),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(509),
    [sym_jsx_fragment] = STATE(509),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(509),
    [sym_class] = STATE(509),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(509),
    [sym_arrow_function] = STATE(509),
    [sym_call_expression] = STATE(509),
    [sym_new_expression] = STATE(509),
    [sym_await_expression] = STATE(509),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(509),
    [sym_augmented_assignment_expression] = STATE(509),
    [sym_ternary_expression] = STATE(509),
    [sym_binary_expression] = STATE(509),
    [sym_unary_expression] = STATE(509),
    [sym_update_expression] = STATE(509),
    [sym_sequence_expression] = STATE(1103),
    [sym_string] = STATE(509),
    [sym_template_string] = STATE(509),
    [sym_regex] = STATE(509),
    [sym_meta_property] = STATE(509),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(628),
    [sym_this] = ACTIONS(630),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_undefined] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [83] = {
    [sym_import] = STATE(419),
    [sym_statement_block] = STATE(538),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(419),
    [sym_yield_expression] = STATE(419),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(419),
    [sym_jsx_fragment] = STATE(419),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(419),
    [sym_class] = STATE(419),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(419),
    [sym_arrow_function] = STATE(419),
    [sym_call_expression] = STATE(419),
    [sym_new_expression] = STATE(419),
    [sym_await_expression] = STATE(419),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(419),
    [sym_augmented_assignment_expression] = STATE(419),
    [sym_ternary_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym_string] = STATE(419),
    [sym_template_string] = STATE(419),
    [sym_regex] = STATE(419),
    [sym_meta_property] = STATE(419),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(632),
    [sym_this] = ACTIONS(634),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_undefined] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [84] = {
    [sym_import] = STATE(502),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(502),
    [sym_yield_expression] = STATE(502),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(502),
    [sym_jsx_fragment] = STATE(502),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(502),
    [sym_class] = STATE(502),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(502),
    [sym_arrow_function] = STATE(502),
    [sym_call_expression] = STATE(502),
    [sym_new_expression] = STATE(502),
    [sym_await_expression] = STATE(502),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(502),
    [sym_augmented_assignment_expression] = STATE(502),
    [sym_ternary_expression] = STATE(502),
    [sym_binary_expression] = STATE(502),
    [sym_unary_expression] = STATE(502),
    [sym_update_expression] = STATE(502),
    [sym_sequence_expression] = STATE(1104),
    [sym_string] = STATE(502),
    [sym_template_string] = STATE(502),
    [sym_regex] = STATE(502),
    [sym_meta_property] = STATE(502),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(636),
    [sym_this] = ACTIONS(638),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(638),
    [sym_false] = ACTIONS(638),
    [sym_null] = ACTIONS(638),
    [sym_undefined] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [85] = {
    [sym_import] = STATE(350),
    [sym_statement_block] = STATE(454),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(350),
    [sym_yield_expression] = STATE(350),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(350),
    [sym_jsx_fragment] = STATE(350),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(350),
    [sym_class] = STATE(350),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(350),
    [sym_arrow_function] = STATE(350),
    [sym_call_expression] = STATE(350),
    [sym_new_expression] = STATE(350),
    [sym_await_expression] = STATE(350),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(350),
    [sym_augmented_assignment_expression] = STATE(350),
    [sym_ternary_expression] = STATE(350),
    [sym_binary_expression] = STATE(350),
    [sym_unary_expression] = STATE(350),
    [sym_update_expression] = STATE(350),
    [sym_string] = STATE(350),
    [sym_template_string] = STATE(350),
    [sym_regex] = STATE(350),
    [sym_meta_property] = STATE(350),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(642),
    [sym_this] = ACTIONS(644),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(644),
    [sym_false] = ACTIONS(644),
    [sym_null] = ACTIONS(644),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [86] = {
    [sym_import] = STATE(424),
    [sym_statement_block] = STATE(533),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(424),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(424),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(424),
    [sym_arrow_function] = STATE(424),
    [sym_call_expression] = STATE(424),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(424),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(424),
    [sym_template_string] = STATE(424),
    [sym_regex] = STATE(424),
    [sym_meta_property] = STATE(424),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(646),
    [sym_this] = ACTIONS(648),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_null] = ACTIONS(648),
    [sym_undefined] = ACTIONS(648),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [87] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(539),
    [sym_yield_expression] = STATE(539),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(539),
    [sym_jsx_fragment] = STATE(539),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(539),
    [sym_class] = STATE(539),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(539),
    [sym_await_expression] = STATE(539),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(539),
    [sym_augmented_assignment_expression] = STATE(539),
    [sym_ternary_expression] = STATE(539),
    [sym_binary_expression] = STATE(539),
    [sym_unary_expression] = STATE(539),
    [sym_update_expression] = STATE(539),
    [sym_sequence_expression] = STATE(1127),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(650),
    [sym_this] = ACTIONS(652),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(652),
    [sym_false] = ACTIONS(652),
    [sym_null] = ACTIONS(652),
    [sym_undefined] = ACTIONS(652),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [88] = {
    [sym_import] = STATE(557),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(557),
    [sym_yield_expression] = STATE(557),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(557),
    [sym_jsx_fragment] = STATE(557),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(557),
    [sym_class] = STATE(557),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(557),
    [sym_arrow_function] = STATE(557),
    [sym_call_expression] = STATE(557),
    [sym_new_expression] = STATE(557),
    [sym_await_expression] = STATE(557),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(557),
    [sym_augmented_assignment_expression] = STATE(557),
    [sym_ternary_expression] = STATE(557),
    [sym_binary_expression] = STATE(557),
    [sym_unary_expression] = STATE(557),
    [sym_update_expression] = STATE(557),
    [sym_sequence_expression] = STATE(1086),
    [sym_string] = STATE(557),
    [sym_template_string] = STATE(557),
    [sym_regex] = STATE(557),
    [sym_meta_property] = STATE(557),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(654),
    [sym_this] = ACTIONS(656),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(656),
    [sym_false] = ACTIONS(656),
    [sym_null] = ACTIONS(656),
    [sym_undefined] = ACTIONS(656),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [89] = {
    [sym_import] = STATE(363),
    [sym_parenthesized_expression] = STATE(269),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(324),
    [sym_array] = STATE(325),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(363),
    [sym_function] = STATE(326),
    [sym_generator_function] = STATE(363),
    [sym_arrow_function] = STATE(363),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(363),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(269),
    [sym_subscript_expression] = STATE(269),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(363),
    [sym_template_string] = STATE(363),
    [sym_regex] = STATE(363),
    [sym_meta_property] = STATE(363),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(658),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_DOT] = ACTIONS(660),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(662),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(664),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_null] = ACTIONS(666),
    [sym_undefined] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(668),
    [anon_sym_get] = ACTIONS(668),
    [anon_sym_set] = ACTIONS(668),
  },
  [90] = {
    [sym_import] = STATE(393),
    [sym_statement_block] = STATE(562),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(393),
    [sym_yield_expression] = STATE(393),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(393),
    [sym_jsx_fragment] = STATE(393),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(393),
    [sym_class] = STATE(393),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(393),
    [sym_arrow_function] = STATE(393),
    [sym_call_expression] = STATE(393),
    [sym_new_expression] = STATE(393),
    [sym_await_expression] = STATE(393),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(393),
    [sym_augmented_assignment_expression] = STATE(393),
    [sym_ternary_expression] = STATE(393),
    [sym_binary_expression] = STATE(393),
    [sym_unary_expression] = STATE(393),
    [sym_update_expression] = STATE(393),
    [sym_string] = STATE(393),
    [sym_template_string] = STATE(393),
    [sym_regex] = STATE(393),
    [sym_meta_property] = STATE(393),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(670),
    [sym_this] = ACTIONS(672),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(672),
    [sym_false] = ACTIONS(672),
    [sym_null] = ACTIONS(672),
    [sym_undefined] = ACTIONS(672),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [91] = {
    [sym_import] = STATE(316),
    [sym_statement_block] = STATE(380),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(316),
    [sym_yield_expression] = STATE(316),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(316),
    [sym_jsx_fragment] = STATE(316),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(316),
    [sym_class] = STATE(316),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(316),
    [sym_arrow_function] = STATE(316),
    [sym_call_expression] = STATE(316),
    [sym_new_expression] = STATE(316),
    [sym_await_expression] = STATE(316),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(316),
    [sym_augmented_assignment_expression] = STATE(316),
    [sym_ternary_expression] = STATE(316),
    [sym_binary_expression] = STATE(316),
    [sym_unary_expression] = STATE(316),
    [sym_update_expression] = STATE(316),
    [sym_string] = STATE(316),
    [sym_template_string] = STATE(316),
    [sym_regex] = STATE(316),
    [sym_meta_property] = STATE(316),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(674),
    [sym_this] = ACTIONS(676),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(676),
    [sym_false] = ACTIONS(676),
    [sym_null] = ACTIONS(676),
    [sym_undefined] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [92] = {
    [sym_import] = STATE(548),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(548),
    [sym_yield_expression] = STATE(548),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(548),
    [sym_jsx_fragment] = STATE(548),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(548),
    [sym_class] = STATE(548),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(548),
    [sym_arrow_function] = STATE(548),
    [sym_call_expression] = STATE(548),
    [sym_new_expression] = STATE(548),
    [sym_await_expression] = STATE(548),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(548),
    [sym_augmented_assignment_expression] = STATE(548),
    [sym_ternary_expression] = STATE(548),
    [sym_binary_expression] = STATE(548),
    [sym_unary_expression] = STATE(548),
    [sym_update_expression] = STATE(548),
    [sym_sequence_expression] = STATE(1078),
    [sym_string] = STATE(548),
    [sym_template_string] = STATE(548),
    [sym_regex] = STATE(548),
    [sym_meta_property] = STATE(548),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(678),
    [sym_this] = ACTIONS(680),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(680),
    [sym_false] = ACTIONS(680),
    [sym_null] = ACTIONS(680),
    [sym_undefined] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [93] = {
    [sym_import] = STATE(545),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(545),
    [sym_yield_expression] = STATE(545),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(545),
    [sym_jsx_fragment] = STATE(545),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(545),
    [sym_class] = STATE(545),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(545),
    [sym_arrow_function] = STATE(545),
    [sym_call_expression] = STATE(545),
    [sym_new_expression] = STATE(545),
    [sym_await_expression] = STATE(545),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(545),
    [sym_augmented_assignment_expression] = STATE(545),
    [sym_ternary_expression] = STATE(545),
    [sym_binary_expression] = STATE(545),
    [sym_unary_expression] = STATE(545),
    [sym_update_expression] = STATE(545),
    [sym_sequence_expression] = STATE(1111),
    [sym_string] = STATE(545),
    [sym_template_string] = STATE(545),
    [sym_regex] = STATE(545),
    [sym_meta_property] = STATE(545),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(682),
    [sym_this] = ACTIONS(684),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_null] = ACTIONS(684),
    [sym_undefined] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [94] = {
    [sym_import] = STATE(466),
    [sym_parenthesized_expression] = STATE(280),
    [sym__expression] = STATE(576),
    [sym_yield_expression] = STATE(576),
    [sym_object] = STATE(433),
    [sym_array] = STATE(428),
    [sym_jsx_element] = STATE(576),
    [sym_jsx_fragment] = STATE(576),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(576),
    [sym_class] = STATE(466),
    [sym_function] = STATE(365),
    [sym_generator_function] = STATE(466),
    [sym_arrow_function] = STATE(466),
    [sym_call_expression] = STATE(576),
    [sym_new_expression] = STATE(466),
    [sym_await_expression] = STATE(576),
    [sym_member_expression] = STATE(280),
    [sym_subscript_expression] = STATE(280),
    [sym_assignment_expression] = STATE(576),
    [sym_augmented_assignment_expression] = STATE(576),
    [sym_ternary_expression] = STATE(576),
    [sym_binary_expression] = STATE(576),
    [sym_unary_expression] = STATE(576),
    [sym_update_expression] = STATE(576),
    [sym_string] = STATE(466),
    [sym_template_string] = STATE(466),
    [sym_regex] = STATE(466),
    [sym_meta_property] = STATE(466),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(688),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(690),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(692),
    [sym_this] = ACTIONS(694),
    [sym_super] = ACTIONS(696),
    [sym_true] = ACTIONS(694),
    [sym_false] = ACTIONS(694),
    [sym_null] = ACTIONS(694),
    [sym_undefined] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(698),
    [anon_sym_get] = ACTIONS(698),
    [anon_sym_set] = ACTIONS(698),
  },
  [95] = {
    [sym_import] = STATE(559),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(559),
    [sym_yield_expression] = STATE(559),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(559),
    [sym_jsx_fragment] = STATE(559),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(559),
    [sym_class] = STATE(559),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(559),
    [sym_arrow_function] = STATE(559),
    [sym_call_expression] = STATE(559),
    [sym_new_expression] = STATE(559),
    [sym_await_expression] = STATE(559),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(559),
    [sym_augmented_assignment_expression] = STATE(559),
    [sym_ternary_expression] = STATE(559),
    [sym_binary_expression] = STATE(559),
    [sym_unary_expression] = STATE(559),
    [sym_update_expression] = STATE(559),
    [sym_sequence_expression] = STATE(1082),
    [sym_string] = STATE(559),
    [sym_template_string] = STATE(559),
    [sym_regex] = STATE(559),
    [sym_meta_property] = STATE(559),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(700),
    [sym_this] = ACTIONS(702),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_null] = ACTIONS(702),
    [sym_undefined] = ACTIONS(702),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [96] = {
    [sym_import] = STATE(527),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(527),
    [sym_yield_expression] = STATE(527),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(527),
    [sym_jsx_fragment] = STATE(527),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(527),
    [sym_class] = STATE(527),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(527),
    [sym_arrow_function] = STATE(527),
    [sym_call_expression] = STATE(527),
    [sym_new_expression] = STATE(527),
    [sym_await_expression] = STATE(527),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(527),
    [sym_augmented_assignment_expression] = STATE(527),
    [sym_ternary_expression] = STATE(527),
    [sym_binary_expression] = STATE(527),
    [sym_unary_expression] = STATE(527),
    [sym_update_expression] = STATE(527),
    [sym_sequence_expression] = STATE(1045),
    [sym_string] = STATE(527),
    [sym_template_string] = STATE(527),
    [sym_regex] = STATE(527),
    [sym_meta_property] = STATE(527),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(704),
    [sym_this] = ACTIONS(706),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_null] = ACTIONS(706),
    [sym_undefined] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [97] = {
    [sym_import] = STATE(361),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(361),
    [sym_yield_expression] = STATE(361),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(361),
    [sym_jsx_fragment] = STATE(361),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(361),
    [sym_class] = STATE(361),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(361),
    [sym_arrow_function] = STATE(361),
    [sym_call_expression] = STATE(361),
    [sym_new_expression] = STATE(361),
    [sym_await_expression] = STATE(361),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(361),
    [sym_augmented_assignment_expression] = STATE(361),
    [sym_ternary_expression] = STATE(361),
    [sym_binary_expression] = STATE(361),
    [sym_unary_expression] = STATE(361),
    [sym_update_expression] = STATE(361),
    [sym_sequence_expression] = STATE(808),
    [sym_string] = STATE(361),
    [sym_template_string] = STATE(361),
    [sym_regex] = STATE(361),
    [sym_meta_property] = STATE(361),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(708),
    [sym_this] = ACTIONS(710),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_null] = ACTIONS(710),
    [sym_undefined] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [98] = {
    [sym_import] = STATE(531),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(531),
    [sym_yield_expression] = STATE(531),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(531),
    [sym_jsx_fragment] = STATE(531),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(531),
    [sym_class] = STATE(531),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(531),
    [sym_await_expression] = STATE(531),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(531),
    [sym_augmented_assignment_expression] = STATE(531),
    [sym_ternary_expression] = STATE(531),
    [sym_binary_expression] = STATE(531),
    [sym_unary_expression] = STATE(531),
    [sym_update_expression] = STATE(531),
    [sym_sequence_expression] = STATE(1071),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(712),
    [sym_this] = ACTIONS(714),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(714),
    [sym_false] = ACTIONS(714),
    [sym_null] = ACTIONS(714),
    [sym_undefined] = ACTIONS(714),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [99] = {
    [sym_import] = STATE(348),
    [sym_statement_block] = STATE(379),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(348),
    [sym_yield_expression] = STATE(348),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(348),
    [sym_jsx_fragment] = STATE(348),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(348),
    [sym_class] = STATE(348),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(348),
    [sym_arrow_function] = STATE(348),
    [sym_call_expression] = STATE(348),
    [sym_new_expression] = STATE(348),
    [sym_await_expression] = STATE(348),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(348),
    [sym_augmented_assignment_expression] = STATE(348),
    [sym_ternary_expression] = STATE(348),
    [sym_binary_expression] = STATE(348),
    [sym_unary_expression] = STATE(348),
    [sym_update_expression] = STATE(348),
    [sym_string] = STATE(348),
    [sym_template_string] = STATE(348),
    [sym_regex] = STATE(348),
    [sym_meta_property] = STATE(348),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(716),
    [sym_this] = ACTIONS(718),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(718),
    [sym_false] = ACTIONS(718),
    [sym_null] = ACTIONS(718),
    [sym_undefined] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [100] = {
    [sym_import] = STATE(496),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(496),
    [sym_yield_expression] = STATE(496),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(496),
    [sym_jsx_fragment] = STATE(496),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(496),
    [sym_class] = STATE(496),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(496),
    [sym_arrow_function] = STATE(496),
    [sym_call_expression] = STATE(496),
    [sym_new_expression] = STATE(496),
    [sym_await_expression] = STATE(496),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(496),
    [sym_augmented_assignment_expression] = STATE(496),
    [sym_ternary_expression] = STATE(496),
    [sym_binary_expression] = STATE(496),
    [sym_unary_expression] = STATE(496),
    [sym_update_expression] = STATE(496),
    [sym_sequence_expression] = STATE(1100),
    [sym_string] = STATE(496),
    [sym_template_string] = STATE(496),
    [sym_regex] = STATE(496),
    [sym_meta_property] = STATE(496),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(568),
    [sym_this] = ACTIONS(570),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(570),
    [sym_false] = ACTIONS(570),
    [sym_null] = ACTIONS(570),
    [sym_undefined] = ACTIONS(570),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [101] = {
    [sym_import] = STATE(510),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(510),
    [sym_yield_expression] = STATE(510),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(510),
    [sym_jsx_fragment] = STATE(510),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(510),
    [sym_class] = STATE(510),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(510),
    [sym_arrow_function] = STATE(510),
    [sym_call_expression] = STATE(510),
    [sym_new_expression] = STATE(510),
    [sym_await_expression] = STATE(510),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(510),
    [sym_augmented_assignment_expression] = STATE(510),
    [sym_ternary_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_sequence_expression] = STATE(1107),
    [sym_string] = STATE(510),
    [sym_template_string] = STATE(510),
    [sym_regex] = STATE(510),
    [sym_meta_property] = STATE(510),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(720),
    [sym_this] = ACTIONS(722),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_null] = ACTIONS(722),
    [sym_undefined] = ACTIONS(722),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [102] = {
    [sym_import] = STATE(373),
    [sym_statement_block] = STATE(518),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(373),
    [sym_yield_expression] = STATE(373),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(373),
    [sym_jsx_fragment] = STATE(373),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(373),
    [sym_class] = STATE(373),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(373),
    [sym_arrow_function] = STATE(373),
    [sym_call_expression] = STATE(373),
    [sym_new_expression] = STATE(373),
    [sym_await_expression] = STATE(373),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(373),
    [sym_augmented_assignment_expression] = STATE(373),
    [sym_ternary_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym_string] = STATE(373),
    [sym_template_string] = STATE(373),
    [sym_regex] = STATE(373),
    [sym_meta_property] = STATE(373),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(724),
    [sym_this] = ACTIONS(726),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_null] = ACTIONS(726),
    [sym_undefined] = ACTIONS(726),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [103] = {
    [sym_import] = STATE(491),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(491),
    [sym_yield_expression] = STATE(491),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(491),
    [sym_jsx_fragment] = STATE(491),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(491),
    [sym_class] = STATE(491),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(491),
    [sym_arrow_function] = STATE(491),
    [sym_call_expression] = STATE(491),
    [sym_new_expression] = STATE(491),
    [sym_await_expression] = STATE(491),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(491),
    [sym_augmented_assignment_expression] = STATE(491),
    [sym_ternary_expression] = STATE(491),
    [sym_binary_expression] = STATE(491),
    [sym_unary_expression] = STATE(491),
    [sym_update_expression] = STATE(491),
    [sym_sequence_expression] = STATE(941),
    [sym_string] = STATE(491),
    [sym_template_string] = STATE(491),
    [sym_regex] = STATE(491),
    [sym_meta_property] = STATE(491),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(728),
    [sym_this] = ACTIONS(730),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_null] = ACTIONS(730),
    [sym_undefined] = ACTIONS(730),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [104] = {
    [sym_import] = STATE(574),
    [sym_variable_declarator] = STATE(790),
    [sym_parenthesized_expression] = STATE(313),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(378),
    [sym_array] = STATE(376),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(732),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(590),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_null] = ACTIONS(592),
    [sym_undefined] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_get] = ACTIONS(736),
    [anon_sym_set] = ACTIONS(736),
  },
  [105] = {
    [sym_import] = STATE(495),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(495),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(495),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(495),
    [sym_arrow_function] = STATE(495),
    [sym_call_expression] = STATE(495),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(495),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1114),
    [sym_string] = STATE(495),
    [sym_template_string] = STATE(495),
    [sym_regex] = STATE(495),
    [sym_meta_property] = STATE(495),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(738),
    [sym_this] = ACTIONS(740),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(740),
    [sym_false] = ACTIONS(740),
    [sym_null] = ACTIONS(740),
    [sym_undefined] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [106] = {
    [sym_import] = STATE(337),
    [sym_statement_block] = STATE(432),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(337),
    [sym_yield_expression] = STATE(337),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(337),
    [sym_jsx_fragment] = STATE(337),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(337),
    [sym_class] = STATE(337),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(337),
    [sym_arrow_function] = STATE(337),
    [sym_call_expression] = STATE(337),
    [sym_new_expression] = STATE(337),
    [sym_await_expression] = STATE(337),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(337),
    [sym_augmented_assignment_expression] = STATE(337),
    [sym_ternary_expression] = STATE(337),
    [sym_binary_expression] = STATE(337),
    [sym_unary_expression] = STATE(337),
    [sym_update_expression] = STATE(337),
    [sym_string] = STATE(337),
    [sym_template_string] = STATE(337),
    [sym_regex] = STATE(337),
    [sym_meta_property] = STATE(337),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(742),
    [sym_this] = ACTIONS(744),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_undefined] = ACTIONS(744),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [107] = {
    [sym_import] = STATE(336),
    [sym_statement_block] = STATE(436),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(336),
    [sym_yield_expression] = STATE(336),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(336),
    [sym_jsx_fragment] = STATE(336),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(336),
    [sym_class] = STATE(336),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(336),
    [sym_arrow_function] = STATE(336),
    [sym_call_expression] = STATE(336),
    [sym_new_expression] = STATE(336),
    [sym_await_expression] = STATE(336),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(336),
    [sym_augmented_assignment_expression] = STATE(336),
    [sym_ternary_expression] = STATE(336),
    [sym_binary_expression] = STATE(336),
    [sym_unary_expression] = STATE(336),
    [sym_update_expression] = STATE(336),
    [sym_string] = STATE(336),
    [sym_template_string] = STATE(336),
    [sym_regex] = STATE(336),
    [sym_meta_property] = STATE(336),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(746),
    [sym_this] = ACTIONS(748),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_undefined] = ACTIONS(748),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [108] = {
    [sym_import] = STATE(335),
    [sym_statement_block] = STATE(439),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(335),
    [sym_yield_expression] = STATE(335),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(335),
    [sym_jsx_fragment] = STATE(335),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(335),
    [sym_class] = STATE(335),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(335),
    [sym_arrow_function] = STATE(335),
    [sym_call_expression] = STATE(335),
    [sym_new_expression] = STATE(335),
    [sym_await_expression] = STATE(335),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(335),
    [sym_augmented_assignment_expression] = STATE(335),
    [sym_ternary_expression] = STATE(335),
    [sym_binary_expression] = STATE(335),
    [sym_unary_expression] = STATE(335),
    [sym_update_expression] = STATE(335),
    [sym_string] = STATE(335),
    [sym_template_string] = STATE(335),
    [sym_regex] = STATE(335),
    [sym_meta_property] = STATE(335),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(750),
    [sym_this] = ACTIONS(752),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_undefined] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [109] = {
    [sym_import] = STATE(574),
    [sym_variable_declarator] = STATE(794),
    [sym_parenthesized_expression] = STATE(313),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(378),
    [sym_array] = STATE(376),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(732),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(590),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_null] = ACTIONS(592),
    [sym_undefined] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_get] = ACTIONS(736),
    [anon_sym_set] = ACTIONS(736),
  },
  [110] = {
    [sym_import] = STATE(409),
    [sym_statement_block] = STATE(544),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(409),
    [sym_yield_expression] = STATE(409),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(409),
    [sym_jsx_fragment] = STATE(409),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(409),
    [sym_class] = STATE(409),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(409),
    [sym_arrow_function] = STATE(409),
    [sym_call_expression] = STATE(409),
    [sym_new_expression] = STATE(409),
    [sym_await_expression] = STATE(409),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(409),
    [sym_augmented_assignment_expression] = STATE(409),
    [sym_ternary_expression] = STATE(409),
    [sym_binary_expression] = STATE(409),
    [sym_unary_expression] = STATE(409),
    [sym_update_expression] = STATE(409),
    [sym_string] = STATE(409),
    [sym_template_string] = STATE(409),
    [sym_regex] = STATE(409),
    [sym_meta_property] = STATE(409),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(754),
    [sym_this] = ACTIONS(756),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_undefined] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [111] = {
    [sym_import] = STATE(512),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(512),
    [sym_yield_expression] = STATE(512),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(512),
    [sym_jsx_fragment] = STATE(512),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(512),
    [sym_class] = STATE(512),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(512),
    [sym_arrow_function] = STATE(512),
    [sym_call_expression] = STATE(512),
    [sym_new_expression] = STATE(512),
    [sym_await_expression] = STATE(512),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(512),
    [sym_augmented_assignment_expression] = STATE(512),
    [sym_ternary_expression] = STATE(512),
    [sym_binary_expression] = STATE(512),
    [sym_unary_expression] = STATE(512),
    [sym_update_expression] = STATE(512),
    [sym_sequence_expression] = STATE(1096),
    [sym_string] = STATE(512),
    [sym_template_string] = STATE(512),
    [sym_regex] = STATE(512),
    [sym_meta_property] = STATE(512),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(758),
    [sym_this] = ACTIONS(760),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(760),
    [sym_false] = ACTIONS(760),
    [sym_null] = ACTIONS(760),
    [sym_undefined] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [112] = {
    [sym_import] = STATE(470),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(470),
    [sym_yield_expression] = STATE(470),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(470),
    [sym_jsx_fragment] = STATE(470),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(470),
    [sym_class] = STATE(470),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(470),
    [sym_arrow_function] = STATE(470),
    [sym_call_expression] = STATE(470),
    [sym_new_expression] = STATE(470),
    [sym_await_expression] = STATE(470),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(470),
    [sym_augmented_assignment_expression] = STATE(470),
    [sym_ternary_expression] = STATE(470),
    [sym_binary_expression] = STATE(470),
    [sym_unary_expression] = STATE(470),
    [sym_update_expression] = STATE(470),
    [sym_string] = STATE(470),
    [sym_template_string] = STATE(470),
    [sym_regex] = STATE(470),
    [sym_meta_property] = STATE(470),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(762),
    [sym_this] = ACTIONS(764),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(764),
    [sym_false] = ACTIONS(764),
    [sym_null] = ACTIONS(764),
    [sym_undefined] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [113] = {
    [sym_import] = STATE(347),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(347),
    [sym_yield_expression] = STATE(347),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(347),
    [sym_jsx_fragment] = STATE(347),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(347),
    [sym_class] = STATE(347),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(347),
    [sym_arrow_function] = STATE(347),
    [sym_call_expression] = STATE(347),
    [sym_new_expression] = STATE(347),
    [sym_await_expression] = STATE(347),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(347),
    [sym_augmented_assignment_expression] = STATE(347),
    [sym_ternary_expression] = STATE(347),
    [sym_binary_expression] = STATE(347),
    [sym_unary_expression] = STATE(347),
    [sym_update_expression] = STATE(347),
    [sym_string] = STATE(347),
    [sym_template_string] = STATE(347),
    [sym_regex] = STATE(347),
    [sym_meta_property] = STATE(347),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(766),
    [sym_this] = ACTIONS(768),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_null] = ACTIONS(768),
    [sym_undefined] = ACTIONS(768),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [114] = {
    [sym_import] = STATE(570),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(570),
    [sym_yield_expression] = STATE(570),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(570),
    [sym_jsx_fragment] = STATE(570),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(570),
    [sym_class] = STATE(570),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(570),
    [sym_arrow_function] = STATE(570),
    [sym_call_expression] = STATE(570),
    [sym_new_expression] = STATE(570),
    [sym_await_expression] = STATE(570),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(570),
    [sym_augmented_assignment_expression] = STATE(570),
    [sym_ternary_expression] = STATE(570),
    [sym_binary_expression] = STATE(570),
    [sym_unary_expression] = STATE(570),
    [sym_update_expression] = STATE(570),
    [sym_string] = STATE(570),
    [sym_template_string] = STATE(570),
    [sym_regex] = STATE(570),
    [sym_meta_property] = STATE(570),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(770),
    [sym_this] = ACTIONS(772),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(772),
    [sym_false] = ACTIONS(772),
    [sym_null] = ACTIONS(772),
    [sym_undefined] = ACTIONS(772),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [115] = {
    [sym_import] = STATE(567),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(567),
    [sym_yield_expression] = STATE(567),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(567),
    [sym_jsx_fragment] = STATE(567),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(567),
    [sym_class] = STATE(567),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(567),
    [sym_arrow_function] = STATE(567),
    [sym_call_expression] = STATE(567),
    [sym_new_expression] = STATE(567),
    [sym_await_expression] = STATE(567),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(567),
    [sym_augmented_assignment_expression] = STATE(567),
    [sym_ternary_expression] = STATE(567),
    [sym_binary_expression] = STATE(567),
    [sym_unary_expression] = STATE(567),
    [sym_update_expression] = STATE(567),
    [sym_string] = STATE(567),
    [sym_template_string] = STATE(567),
    [sym_regex] = STATE(567),
    [sym_meta_property] = STATE(567),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(774),
    [sym_this] = ACTIONS(776),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(776),
    [sym_false] = ACTIONS(776),
    [sym_null] = ACTIONS(776),
    [sym_undefined] = ACTIONS(776),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [116] = {
    [sym_import] = STATE(561),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(561),
    [sym_yield_expression] = STATE(561),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(561),
    [sym_jsx_fragment] = STATE(561),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(561),
    [sym_class] = STATE(561),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(561),
    [sym_arrow_function] = STATE(561),
    [sym_call_expression] = STATE(561),
    [sym_new_expression] = STATE(561),
    [sym_await_expression] = STATE(561),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(561),
    [sym_augmented_assignment_expression] = STATE(561),
    [sym_ternary_expression] = STATE(561),
    [sym_binary_expression] = STATE(561),
    [sym_unary_expression] = STATE(561),
    [sym_update_expression] = STATE(561),
    [sym_string] = STATE(561),
    [sym_template_string] = STATE(561),
    [sym_regex] = STATE(561),
    [sym_meta_property] = STATE(561),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(778),
    [sym_this] = ACTIONS(780),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(780),
    [sym_false] = ACTIONS(780),
    [sym_null] = ACTIONS(780),
    [sym_undefined] = ACTIONS(780),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [117] = {
    [sym_import] = STATE(372),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(372),
    [sym_yield_expression] = STATE(372),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(372),
    [sym_jsx_fragment] = STATE(372),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(372),
    [sym_class] = STATE(372),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(372),
    [sym_arrow_function] = STATE(372),
    [sym_call_expression] = STATE(372),
    [sym_new_expression] = STATE(372),
    [sym_await_expression] = STATE(372),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(372),
    [sym_augmented_assignment_expression] = STATE(372),
    [sym_ternary_expression] = STATE(372),
    [sym_binary_expression] = STATE(372),
    [sym_unary_expression] = STATE(372),
    [sym_update_expression] = STATE(372),
    [sym_string] = STATE(372),
    [sym_template_string] = STATE(372),
    [sym_regex] = STATE(372),
    [sym_meta_property] = STATE(372),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(782),
    [sym_this] = ACTIONS(784),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(784),
    [sym_false] = ACTIONS(784),
    [sym_null] = ACTIONS(784),
    [sym_undefined] = ACTIONS(784),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [118] = {
    [sym_import] = STATE(485),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(485),
    [sym_yield_expression] = STATE(485),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(485),
    [sym_jsx_fragment] = STATE(485),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(485),
    [sym_class] = STATE(485),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(485),
    [sym_arrow_function] = STATE(485),
    [sym_call_expression] = STATE(485),
    [sym_new_expression] = STATE(485),
    [sym_await_expression] = STATE(485),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(485),
    [sym_augmented_assignment_expression] = STATE(485),
    [sym_ternary_expression] = STATE(485),
    [sym_binary_expression] = STATE(485),
    [sym_unary_expression] = STATE(485),
    [sym_update_expression] = STATE(485),
    [sym_string] = STATE(485),
    [sym_template_string] = STATE(485),
    [sym_regex] = STATE(485),
    [sym_meta_property] = STATE(485),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(786),
    [sym_this] = ACTIONS(788),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(788),
    [sym_false] = ACTIONS(788),
    [sym_null] = ACTIONS(788),
    [sym_undefined] = ACTIONS(788),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [119] = {
    [sym_import] = STATE(486),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(486),
    [sym_yield_expression] = STATE(486),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(486),
    [sym_jsx_fragment] = STATE(486),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(486),
    [sym_class] = STATE(486),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(486),
    [sym_arrow_function] = STATE(486),
    [sym_call_expression] = STATE(486),
    [sym_new_expression] = STATE(486),
    [sym_await_expression] = STATE(486),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(486),
    [sym_augmented_assignment_expression] = STATE(486),
    [sym_ternary_expression] = STATE(486),
    [sym_binary_expression] = STATE(486),
    [sym_unary_expression] = STATE(486),
    [sym_update_expression] = STATE(486),
    [sym_string] = STATE(486),
    [sym_template_string] = STATE(486),
    [sym_regex] = STATE(486),
    [sym_meta_property] = STATE(486),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(790),
    [sym_this] = ACTIONS(792),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(792),
    [sym_false] = ACTIONS(792),
    [sym_null] = ACTIONS(792),
    [sym_undefined] = ACTIONS(792),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [120] = {
    [sym_import] = STATE(487),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(487),
    [sym_yield_expression] = STATE(487),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(487),
    [sym_jsx_fragment] = STATE(487),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(487),
    [sym_class] = STATE(487),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(487),
    [sym_arrow_function] = STATE(487),
    [sym_call_expression] = STATE(487),
    [sym_new_expression] = STATE(487),
    [sym_await_expression] = STATE(487),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(487),
    [sym_augmented_assignment_expression] = STATE(487),
    [sym_ternary_expression] = STATE(487),
    [sym_binary_expression] = STATE(487),
    [sym_unary_expression] = STATE(487),
    [sym_update_expression] = STATE(487),
    [sym_string] = STATE(487),
    [sym_template_string] = STATE(487),
    [sym_regex] = STATE(487),
    [sym_meta_property] = STATE(487),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(794),
    [sym_this] = ACTIONS(796),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(796),
    [sym_false] = ACTIONS(796),
    [sym_null] = ACTIONS(796),
    [sym_undefined] = ACTIONS(796),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [121] = {
    [sym_import] = STATE(425),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(425),
    [sym_yield_expression] = STATE(425),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(425),
    [sym_jsx_fragment] = STATE(425),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(425),
    [sym_class] = STATE(425),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(425),
    [sym_arrow_function] = STATE(425),
    [sym_call_expression] = STATE(425),
    [sym_new_expression] = STATE(425),
    [sym_await_expression] = STATE(425),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(425),
    [sym_augmented_assignment_expression] = STATE(425),
    [sym_ternary_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym_string] = STATE(425),
    [sym_template_string] = STATE(425),
    [sym_regex] = STATE(425),
    [sym_meta_property] = STATE(425),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(798),
    [sym_this] = ACTIONS(800),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(800),
    [sym_false] = ACTIONS(800),
    [sym_null] = ACTIONS(800),
    [sym_undefined] = ACTIONS(800),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [122] = {
    [sym_import] = STATE(423),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(423),
    [sym_yield_expression] = STATE(423),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(423),
    [sym_jsx_fragment] = STATE(423),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(423),
    [sym_class] = STATE(423),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(423),
    [sym_arrow_function] = STATE(423),
    [sym_call_expression] = STATE(423),
    [sym_new_expression] = STATE(423),
    [sym_await_expression] = STATE(423),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(423),
    [sym_augmented_assignment_expression] = STATE(423),
    [sym_ternary_expression] = STATE(423),
    [sym_binary_expression] = STATE(423),
    [sym_unary_expression] = STATE(423),
    [sym_update_expression] = STATE(423),
    [sym_string] = STATE(423),
    [sym_template_string] = STATE(423),
    [sym_regex] = STATE(423),
    [sym_meta_property] = STATE(423),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(802),
    [sym_this] = ACTIONS(804),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(804),
    [sym_false] = ACTIONS(804),
    [sym_null] = ACTIONS(804),
    [sym_undefined] = ACTIONS(804),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [123] = {
    [sym_import] = STATE(422),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(422),
    [sym_yield_expression] = STATE(422),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(422),
    [sym_jsx_fragment] = STATE(422),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(422),
    [sym_class] = STATE(422),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(422),
    [sym_arrow_function] = STATE(422),
    [sym_call_expression] = STATE(422),
    [sym_new_expression] = STATE(422),
    [sym_await_expression] = STATE(422),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(422),
    [sym_augmented_assignment_expression] = STATE(422),
    [sym_ternary_expression] = STATE(422),
    [sym_binary_expression] = STATE(422),
    [sym_unary_expression] = STATE(422),
    [sym_update_expression] = STATE(422),
    [sym_string] = STATE(422),
    [sym_template_string] = STATE(422),
    [sym_regex] = STATE(422),
    [sym_meta_property] = STATE(422),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(806),
    [sym_this] = ACTIONS(808),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(808),
    [sym_false] = ACTIONS(808),
    [sym_null] = ACTIONS(808),
    [sym_undefined] = ACTIONS(808),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [124] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(313),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(572),
    [sym_array] = STATE(573),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(574),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(810),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(734),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(590),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_null] = ACTIONS(592),
    [sym_undefined] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_get] = ACTIONS(736),
    [anon_sym_set] = ACTIONS(736),
  },
  [125] = {
    [sym_import] = STATE(421),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(421),
    [sym_yield_expression] = STATE(421),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(421),
    [sym_jsx_fragment] = STATE(421),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(421),
    [sym_class] = STATE(421),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(421),
    [sym_arrow_function] = STATE(421),
    [sym_call_expression] = STATE(421),
    [sym_new_expression] = STATE(421),
    [sym_await_expression] = STATE(421),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(421),
    [sym_augmented_assignment_expression] = STATE(421),
    [sym_ternary_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_string] = STATE(421),
    [sym_template_string] = STATE(421),
    [sym_regex] = STATE(421),
    [sym_meta_property] = STATE(421),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(812),
    [sym_this] = ACTIONS(814),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(814),
    [sym_false] = ACTIONS(814),
    [sym_null] = ACTIONS(814),
    [sym_undefined] = ACTIONS(814),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [126] = {
    [sym_import] = STATE(388),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(388),
    [sym_yield_expression] = STATE(388),
    [sym_object] = STATE(566),
    [sym_array] = STATE(568),
    [sym_jsx_element] = STATE(388),
    [sym_jsx_fragment] = STATE(388),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(388),
    [sym_class] = STATE(388),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(388),
    [sym_arrow_function] = STATE(388),
    [sym_call_expression] = STATE(388),
    [sym_new_expression] = STATE(388),
    [sym_await_expression] = STATE(388),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(388),
    [sym_augmented_assignment_expression] = STATE(388),
    [sym_ternary_expression] = STATE(388),
    [sym_binary_expression] = STATE(388),
    [sym_unary_expression] = STATE(388),
    [sym_update_expression] = STATE(388),
    [sym_string] = STATE(388),
    [sym_template_string] = STATE(388),
    [sym_regex] = STATE(388),
    [sym_meta_property] = STATE(388),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(816),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(818),
    [sym_this] = ACTIONS(820),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(820),
    [sym_false] = ACTIONS(820),
    [sym_null] = ACTIONS(820),
    [sym_undefined] = ACTIONS(820),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [127] = {
    [sym_import] = STATE(371),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(371),
    [sym_yield_expression] = STATE(371),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(371),
    [sym_jsx_fragment] = STATE(371),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(371),
    [sym_class] = STATE(371),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(371),
    [sym_arrow_function] = STATE(371),
    [sym_call_expression] = STATE(371),
    [sym_new_expression] = STATE(371),
    [sym_await_expression] = STATE(371),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(371),
    [sym_augmented_assignment_expression] = STATE(371),
    [sym_ternary_expression] = STATE(371),
    [sym_binary_expression] = STATE(371),
    [sym_unary_expression] = STATE(371),
    [sym_update_expression] = STATE(371),
    [sym_string] = STATE(371),
    [sym_template_string] = STATE(371),
    [sym_regex] = STATE(371),
    [sym_meta_property] = STATE(371),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(822),
    [sym_this] = ACTIONS(824),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(824),
    [sym_false] = ACTIONS(824),
    [sym_null] = ACTIONS(824),
    [sym_undefined] = ACTIONS(824),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [128] = {
    [sym_import] = STATE(556),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(556),
    [sym_yield_expression] = STATE(556),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(556),
    [sym_jsx_fragment] = STATE(556),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(556),
    [sym_class] = STATE(556),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(556),
    [sym_arrow_function] = STATE(556),
    [sym_call_expression] = STATE(556),
    [sym_new_expression] = STATE(556),
    [sym_await_expression] = STATE(556),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(556),
    [sym_augmented_assignment_expression] = STATE(556),
    [sym_ternary_expression] = STATE(556),
    [sym_binary_expression] = STATE(556),
    [sym_unary_expression] = STATE(556),
    [sym_update_expression] = STATE(556),
    [sym_string] = STATE(556),
    [sym_template_string] = STATE(556),
    [sym_regex] = STATE(556),
    [sym_meta_property] = STATE(556),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(826),
    [sym_this] = ACTIONS(828),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(828),
    [sym_false] = ACTIONS(828),
    [sym_null] = ACTIONS(828),
    [sym_undefined] = ACTIONS(828),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [129] = {
    [sym_import] = STATE(484),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(484),
    [sym_yield_expression] = STATE(484),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(484),
    [sym_jsx_fragment] = STATE(484),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(484),
    [sym_class] = STATE(484),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(484),
    [sym_arrow_function] = STATE(484),
    [sym_call_expression] = STATE(484),
    [sym_new_expression] = STATE(484),
    [sym_await_expression] = STATE(484),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(484),
    [sym_augmented_assignment_expression] = STATE(484),
    [sym_ternary_expression] = STATE(484),
    [sym_binary_expression] = STATE(484),
    [sym_unary_expression] = STATE(484),
    [sym_update_expression] = STATE(484),
    [sym_string] = STATE(484),
    [sym_template_string] = STATE(484),
    [sym_regex] = STATE(484),
    [sym_meta_property] = STATE(484),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(830),
    [sym_this] = ACTIONS(832),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(832),
    [sym_false] = ACTIONS(832),
    [sym_null] = ACTIONS(832),
    [sym_undefined] = ACTIONS(832),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [130] = {
    [sym_import] = STATE(483),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(483),
    [sym_yield_expression] = STATE(483),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(483),
    [sym_jsx_fragment] = STATE(483),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(483),
    [sym_class] = STATE(483),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(483),
    [sym_arrow_function] = STATE(483),
    [sym_call_expression] = STATE(483),
    [sym_new_expression] = STATE(483),
    [sym_await_expression] = STATE(483),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(483),
    [sym_augmented_assignment_expression] = STATE(483),
    [sym_ternary_expression] = STATE(483),
    [sym_binary_expression] = STATE(483),
    [sym_unary_expression] = STATE(483),
    [sym_update_expression] = STATE(483),
    [sym_string] = STATE(483),
    [sym_template_string] = STATE(483),
    [sym_regex] = STATE(483),
    [sym_meta_property] = STATE(483),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(834),
    [sym_this] = ACTIONS(836),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(836),
    [sym_false] = ACTIONS(836),
    [sym_null] = ACTIONS(836),
    [sym_undefined] = ACTIONS(836),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [131] = {
    [sym_import] = STATE(458),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(458),
    [sym_yield_expression] = STATE(458),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(458),
    [sym_jsx_fragment] = STATE(458),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(458),
    [sym_class] = STATE(458),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(458),
    [sym_arrow_function] = STATE(458),
    [sym_call_expression] = STATE(458),
    [sym_new_expression] = STATE(458),
    [sym_await_expression] = STATE(458),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(458),
    [sym_augmented_assignment_expression] = STATE(458),
    [sym_ternary_expression] = STATE(458),
    [sym_binary_expression] = STATE(458),
    [sym_unary_expression] = STATE(458),
    [sym_update_expression] = STATE(458),
    [sym_string] = STATE(458),
    [sym_template_string] = STATE(458),
    [sym_regex] = STATE(458),
    [sym_meta_property] = STATE(458),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(838),
    [sym_this] = ACTIONS(840),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(840),
    [sym_false] = ACTIONS(840),
    [sym_null] = ACTIONS(840),
    [sym_undefined] = ACTIONS(840),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [132] = {
    [sym_import] = STATE(438),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(438),
    [sym_yield_expression] = STATE(438),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(438),
    [sym_jsx_fragment] = STATE(438),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(438),
    [sym_class] = STATE(438),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(438),
    [sym_arrow_function] = STATE(438),
    [sym_call_expression] = STATE(438),
    [sym_new_expression] = STATE(438),
    [sym_await_expression] = STATE(438),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(438),
    [sym_augmented_assignment_expression] = STATE(438),
    [sym_ternary_expression] = STATE(438),
    [sym_binary_expression] = STATE(438),
    [sym_unary_expression] = STATE(438),
    [sym_update_expression] = STATE(438),
    [sym_string] = STATE(438),
    [sym_template_string] = STATE(438),
    [sym_regex] = STATE(438),
    [sym_meta_property] = STATE(438),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(842),
    [sym_this] = ACTIONS(844),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(844),
    [sym_false] = ACTIONS(844),
    [sym_null] = ACTIONS(844),
    [sym_undefined] = ACTIONS(844),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [133] = {
    [sym_string] = STATE(1015),
    [sym_formal_parameters] = STATE(1126),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(846),
    [anon_sym_STAR] = ACTIONS(848),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(853),
    [anon_sym_LPAREN] = ACTIONS(855),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(871),
    [anon_sym_function] = ACTIONS(873),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(871),
    [anon_sym_get] = ACTIONS(881),
    [anon_sym_set] = ACTIONS(881),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
  [134] = {
    [sym_string] = STATE(1015),
    [sym_formal_parameters] = STATE(1126),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(838),
    [sym_identifier] = ACTIONS(846),
    [anon_sym_STAR] = ACTIONS(848),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(883),
    [anon_sym_LPAREN] = ACTIONS(855),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(871),
    [anon_sym_function] = ACTIONS(873),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(871),
    [anon_sym_get] = ACTIONS(881),
    [anon_sym_set] = ACTIONS(881),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
  [135] = {
    [sym_import] = STATE(388),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(388),
    [sym_yield_expression] = STATE(388),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(388),
    [sym_jsx_fragment] = STATE(388),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(388),
    [sym_class] = STATE(388),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(388),
    [sym_arrow_function] = STATE(388),
    [sym_call_expression] = STATE(388),
    [sym_new_expression] = STATE(388),
    [sym_await_expression] = STATE(388),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(388),
    [sym_augmented_assignment_expression] = STATE(388),
    [sym_ternary_expression] = STATE(388),
    [sym_binary_expression] = STATE(388),
    [sym_unary_expression] = STATE(388),
    [sym_update_expression] = STATE(388),
    [sym_string] = STATE(388),
    [sym_template_string] = STATE(388),
    [sym_regex] = STATE(388),
    [sym_meta_property] = STATE(388),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(818),
    [sym_this] = ACTIONS(820),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(820),
    [sym_false] = ACTIONS(820),
    [sym_null] = ACTIONS(820),
    [sym_undefined] = ACTIONS(820),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [136] = {
    [sym_import] = STATE(318),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(318),
    [sym_yield_expression] = STATE(318),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(318),
    [sym_jsx_fragment] = STATE(318),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(318),
    [sym_class] = STATE(318),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(318),
    [sym_arrow_function] = STATE(318),
    [sym_call_expression] = STATE(318),
    [sym_new_expression] = STATE(318),
    [sym_await_expression] = STATE(318),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(318),
    [sym_augmented_assignment_expression] = STATE(318),
    [sym_ternary_expression] = STATE(318),
    [sym_binary_expression] = STATE(318),
    [sym_unary_expression] = STATE(318),
    [sym_update_expression] = STATE(318),
    [sym_string] = STATE(318),
    [sym_template_string] = STATE(318),
    [sym_regex] = STATE(318),
    [sym_meta_property] = STATE(318),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(885),
    [sym_this] = ACTIONS(887),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(887),
    [sym_false] = ACTIONS(887),
    [sym_null] = ACTIONS(887),
    [sym_undefined] = ACTIONS(887),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [137] = {
    [sym_import] = STATE(505),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(505),
    [sym_yield_expression] = STATE(505),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(505),
    [sym_jsx_fragment] = STATE(505),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(505),
    [sym_class] = STATE(505),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(505),
    [sym_arrow_function] = STATE(505),
    [sym_call_expression] = STATE(505),
    [sym_new_expression] = STATE(505),
    [sym_await_expression] = STATE(505),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(505),
    [sym_augmented_assignment_expression] = STATE(505),
    [sym_ternary_expression] = STATE(505),
    [sym_binary_expression] = STATE(505),
    [sym_unary_expression] = STATE(505),
    [sym_update_expression] = STATE(505),
    [sym_string] = STATE(505),
    [sym_template_string] = STATE(505),
    [sym_regex] = STATE(505),
    [sym_meta_property] = STATE(505),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(889),
    [sym_this] = ACTIONS(891),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(891),
    [sym_false] = ACTIONS(891),
    [sym_null] = ACTIONS(891),
    [sym_undefined] = ACTIONS(891),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [138] = {
    [sym_import] = STATE(449),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(449),
    [sym_yield_expression] = STATE(449),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(449),
    [sym_jsx_fragment] = STATE(449),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(449),
    [sym_class] = STATE(449),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(449),
    [sym_arrow_function] = STATE(449),
    [sym_call_expression] = STATE(449),
    [sym_new_expression] = STATE(449),
    [sym_await_expression] = STATE(449),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(449),
    [sym_augmented_assignment_expression] = STATE(449),
    [sym_ternary_expression] = STATE(449),
    [sym_binary_expression] = STATE(449),
    [sym_unary_expression] = STATE(449),
    [sym_update_expression] = STATE(449),
    [sym_string] = STATE(449),
    [sym_template_string] = STATE(449),
    [sym_regex] = STATE(449),
    [sym_meta_property] = STATE(449),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(893),
    [sym_this] = ACTIONS(895),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(895),
    [sym_false] = ACTIONS(895),
    [sym_null] = ACTIONS(895),
    [sym_undefined] = ACTIONS(895),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [139] = {
    [sym_import] = STATE(456),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(456),
    [sym_yield_expression] = STATE(456),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(456),
    [sym_jsx_fragment] = STATE(456),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(456),
    [sym_class] = STATE(456),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(456),
    [sym_arrow_function] = STATE(456),
    [sym_call_expression] = STATE(456),
    [sym_new_expression] = STATE(456),
    [sym_await_expression] = STATE(456),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(456),
    [sym_augmented_assignment_expression] = STATE(456),
    [sym_ternary_expression] = STATE(456),
    [sym_binary_expression] = STATE(456),
    [sym_unary_expression] = STATE(456),
    [sym_update_expression] = STATE(456),
    [sym_string] = STATE(456),
    [sym_template_string] = STATE(456),
    [sym_regex] = STATE(456),
    [sym_meta_property] = STATE(456),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(897),
    [sym_this] = ACTIONS(899),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(899),
    [sym_false] = ACTIONS(899),
    [sym_null] = ACTIONS(899),
    [sym_undefined] = ACTIONS(899),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [140] = {
    [sym_import] = STATE(453),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(453),
    [sym_yield_expression] = STATE(453),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(453),
    [sym_jsx_fragment] = STATE(453),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(453),
    [sym_class] = STATE(453),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(453),
    [sym_arrow_function] = STATE(453),
    [sym_call_expression] = STATE(453),
    [sym_new_expression] = STATE(453),
    [sym_await_expression] = STATE(453),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(453),
    [sym_augmented_assignment_expression] = STATE(453),
    [sym_ternary_expression] = STATE(453),
    [sym_binary_expression] = STATE(453),
    [sym_unary_expression] = STATE(453),
    [sym_update_expression] = STATE(453),
    [sym_string] = STATE(453),
    [sym_template_string] = STATE(453),
    [sym_regex] = STATE(453),
    [sym_meta_property] = STATE(453),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(901),
    [sym_this] = ACTIONS(903),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(903),
    [sym_false] = ACTIONS(903),
    [sym_null] = ACTIONS(903),
    [sym_undefined] = ACTIONS(903),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [141] = {
    [sym_import] = STATE(451),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(451),
    [sym_yield_expression] = STATE(451),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(451),
    [sym_jsx_fragment] = STATE(451),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(451),
    [sym_class] = STATE(451),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(451),
    [sym_arrow_function] = STATE(451),
    [sym_call_expression] = STATE(451),
    [sym_new_expression] = STATE(451),
    [sym_await_expression] = STATE(451),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(451),
    [sym_augmented_assignment_expression] = STATE(451),
    [sym_ternary_expression] = STATE(451),
    [sym_binary_expression] = STATE(451),
    [sym_unary_expression] = STATE(451),
    [sym_update_expression] = STATE(451),
    [sym_string] = STATE(451),
    [sym_template_string] = STATE(451),
    [sym_regex] = STATE(451),
    [sym_meta_property] = STATE(451),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(905),
    [sym_this] = ACTIONS(907),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(907),
    [sym_false] = ACTIONS(907),
    [sym_null] = ACTIONS(907),
    [sym_undefined] = ACTIONS(907),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [142] = {
    [sym_import] = STATE(330),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(330),
    [sym_yield_expression] = STATE(330),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(330),
    [sym_jsx_fragment] = STATE(330),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(330),
    [sym_class] = STATE(330),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(330),
    [sym_arrow_function] = STATE(330),
    [sym_call_expression] = STATE(330),
    [sym_new_expression] = STATE(330),
    [sym_await_expression] = STATE(330),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(330),
    [sym_augmented_assignment_expression] = STATE(330),
    [sym_ternary_expression] = STATE(330),
    [sym_binary_expression] = STATE(330),
    [sym_unary_expression] = STATE(330),
    [sym_update_expression] = STATE(330),
    [sym_string] = STATE(330),
    [sym_template_string] = STATE(330),
    [sym_regex] = STATE(330),
    [sym_meta_property] = STATE(330),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(909),
    [sym_this] = ACTIONS(911),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(911),
    [sym_false] = ACTIONS(911),
    [sym_null] = ACTIONS(911),
    [sym_undefined] = ACTIONS(911),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [143] = {
    [sym_import] = STATE(415),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(415),
    [sym_yield_expression] = STATE(415),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(415),
    [sym_jsx_fragment] = STATE(415),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(415),
    [sym_class] = STATE(415),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(415),
    [sym_arrow_function] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_new_expression] = STATE(415),
    [sym_await_expression] = STATE(415),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_string] = STATE(415),
    [sym_template_string] = STATE(415),
    [sym_regex] = STATE(415),
    [sym_meta_property] = STATE(415),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(913),
    [sym_this] = ACTIONS(915),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(915),
    [sym_false] = ACTIONS(915),
    [sym_null] = ACTIONS(915),
    [sym_undefined] = ACTIONS(915),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [144] = {
    [sym_import] = STATE(390),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(390),
    [sym_yield_expression] = STATE(390),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(390),
    [sym_jsx_fragment] = STATE(390),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(390),
    [sym_class] = STATE(390),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(390),
    [sym_arrow_function] = STATE(390),
    [sym_call_expression] = STATE(390),
    [sym_new_expression] = STATE(390),
    [sym_await_expression] = STATE(390),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(390),
    [sym_augmented_assignment_expression] = STATE(390),
    [sym_ternary_expression] = STATE(390),
    [sym_binary_expression] = STATE(390),
    [sym_unary_expression] = STATE(390),
    [sym_update_expression] = STATE(390),
    [sym_string] = STATE(390),
    [sym_template_string] = STATE(390),
    [sym_regex] = STATE(390),
    [sym_meta_property] = STATE(390),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(917),
    [sym_this] = ACTIONS(919),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [sym_null] = ACTIONS(919),
    [sym_undefined] = ACTIONS(919),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [145] = {
    [sym_import] = STATE(354),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(354),
    [sym_yield_expression] = STATE(354),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(354),
    [sym_jsx_fragment] = STATE(354),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(354),
    [sym_class] = STATE(354),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(354),
    [sym_arrow_function] = STATE(354),
    [sym_call_expression] = STATE(354),
    [sym_new_expression] = STATE(354),
    [sym_await_expression] = STATE(354),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(354),
    [sym_augmented_assignment_expression] = STATE(354),
    [sym_ternary_expression] = STATE(354),
    [sym_binary_expression] = STATE(354),
    [sym_unary_expression] = STATE(354),
    [sym_update_expression] = STATE(354),
    [sym_string] = STATE(354),
    [sym_template_string] = STATE(354),
    [sym_regex] = STATE(354),
    [sym_meta_property] = STATE(354),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(921),
    [sym_this] = ACTIONS(923),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(923),
    [sym_false] = ACTIONS(923),
    [sym_null] = ACTIONS(923),
    [sym_undefined] = ACTIONS(923),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [146] = {
    [sym_import] = STATE(564),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(564),
    [sym_yield_expression] = STATE(564),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(564),
    [sym_jsx_fragment] = STATE(564),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(564),
    [sym_class] = STATE(564),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(564),
    [sym_arrow_function] = STATE(564),
    [sym_call_expression] = STATE(564),
    [sym_new_expression] = STATE(564),
    [sym_await_expression] = STATE(564),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(564),
    [sym_augmented_assignment_expression] = STATE(564),
    [sym_ternary_expression] = STATE(564),
    [sym_binary_expression] = STATE(564),
    [sym_unary_expression] = STATE(564),
    [sym_update_expression] = STATE(564),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(564),
    [sym_regex] = STATE(564),
    [sym_meta_property] = STATE(564),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(925),
    [sym_this] = ACTIONS(927),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(927),
    [sym_false] = ACTIONS(927),
    [sym_null] = ACTIONS(927),
    [sym_undefined] = ACTIONS(927),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [147] = {
    [sym_import] = STATE(416),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(416),
    [sym_yield_expression] = STATE(416),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(416),
    [sym_jsx_fragment] = STATE(416),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(416),
    [sym_class] = STATE(416),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(416),
    [sym_arrow_function] = STATE(416),
    [sym_call_expression] = STATE(416),
    [sym_new_expression] = STATE(416),
    [sym_await_expression] = STATE(416),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(416),
    [sym_augmented_assignment_expression] = STATE(416),
    [sym_ternary_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym_string] = STATE(416),
    [sym_template_string] = STATE(416),
    [sym_regex] = STATE(416),
    [sym_meta_property] = STATE(416),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(929),
    [sym_this] = ACTIONS(931),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(931),
    [sym_false] = ACTIONS(931),
    [sym_null] = ACTIONS(931),
    [sym_undefined] = ACTIONS(931),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [148] = {
    [sym_import] = STATE(394),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(394),
    [sym_yield_expression] = STATE(394),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(394),
    [sym_jsx_fragment] = STATE(394),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(394),
    [sym_class] = STATE(394),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(394),
    [sym_arrow_function] = STATE(394),
    [sym_call_expression] = STATE(394),
    [sym_new_expression] = STATE(394),
    [sym_await_expression] = STATE(394),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(394),
    [sym_augmented_assignment_expression] = STATE(394),
    [sym_ternary_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym_string] = STATE(394),
    [sym_template_string] = STATE(394),
    [sym_regex] = STATE(394),
    [sym_meta_property] = STATE(394),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(933),
    [sym_this] = ACTIONS(935),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(935),
    [sym_false] = ACTIONS(935),
    [sym_null] = ACTIONS(935),
    [sym_undefined] = ACTIONS(935),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [149] = {
    [sym_import] = STATE(322),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(322),
    [sym_yield_expression] = STATE(322),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(322),
    [sym_jsx_fragment] = STATE(322),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(322),
    [sym_class] = STATE(322),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(322),
    [sym_arrow_function] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_new_expression] = STATE(322),
    [sym_await_expression] = STATE(322),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(322),
    [sym_augmented_assignment_expression] = STATE(322),
    [sym_ternary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_update_expression] = STATE(322),
    [sym_string] = STATE(322),
    [sym_template_string] = STATE(322),
    [sym_regex] = STATE(322),
    [sym_meta_property] = STATE(322),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(937),
    [sym_this] = ACTIONS(939),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(939),
    [sym_false] = ACTIONS(939),
    [sym_null] = ACTIONS(939),
    [sym_undefined] = ACTIONS(939),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [150] = {
    [sym_import] = STATE(565),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(565),
    [sym_yield_expression] = STATE(565),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(565),
    [sym_jsx_fragment] = STATE(565),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(565),
    [sym_class] = STATE(565),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(565),
    [sym_arrow_function] = STATE(565),
    [sym_call_expression] = STATE(565),
    [sym_new_expression] = STATE(565),
    [sym_await_expression] = STATE(565),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(565),
    [sym_augmented_assignment_expression] = STATE(565),
    [sym_ternary_expression] = STATE(565),
    [sym_binary_expression] = STATE(565),
    [sym_unary_expression] = STATE(565),
    [sym_update_expression] = STATE(565),
    [sym_string] = STATE(565),
    [sym_template_string] = STATE(565),
    [sym_regex] = STATE(565),
    [sym_meta_property] = STATE(565),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(941),
    [sym_this] = ACTIONS(943),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_undefined] = ACTIONS(943),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [151] = {
    [sym_import] = STATE(323),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(323),
    [sym_yield_expression] = STATE(323),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(323),
    [sym_jsx_fragment] = STATE(323),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(323),
    [sym_class] = STATE(323),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(323),
    [sym_arrow_function] = STATE(323),
    [sym_call_expression] = STATE(323),
    [sym_new_expression] = STATE(323),
    [sym_await_expression] = STATE(323),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(323),
    [sym_augmented_assignment_expression] = STATE(323),
    [sym_ternary_expression] = STATE(323),
    [sym_binary_expression] = STATE(323),
    [sym_unary_expression] = STATE(323),
    [sym_update_expression] = STATE(323),
    [sym_string] = STATE(323),
    [sym_template_string] = STATE(323),
    [sym_regex] = STATE(323),
    [sym_meta_property] = STATE(323),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(945),
    [sym_this] = ACTIONS(947),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(947),
    [sym_false] = ACTIONS(947),
    [sym_null] = ACTIONS(947),
    [sym_undefined] = ACTIONS(947),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [152] = {
    [sym_import] = STATE(368),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(368),
    [sym_yield_expression] = STATE(368),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(368),
    [sym_jsx_fragment] = STATE(368),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(368),
    [sym_class] = STATE(368),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(368),
    [sym_arrow_function] = STATE(368),
    [sym_call_expression] = STATE(368),
    [sym_new_expression] = STATE(368),
    [sym_await_expression] = STATE(368),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(368),
    [sym_augmented_assignment_expression] = STATE(368),
    [sym_ternary_expression] = STATE(368),
    [sym_binary_expression] = STATE(368),
    [sym_unary_expression] = STATE(368),
    [sym_update_expression] = STATE(368),
    [sym_string] = STATE(368),
    [sym_template_string] = STATE(368),
    [sym_regex] = STATE(368),
    [sym_meta_property] = STATE(368),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(949),
    [sym_this] = ACTIONS(951),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(951),
    [sym_false] = ACTIONS(951),
    [sym_null] = ACTIONS(951),
    [sym_undefined] = ACTIONS(951),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [153] = {
    [sym_import] = STATE(329),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(329),
    [sym_yield_expression] = STATE(329),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(329),
    [sym_jsx_fragment] = STATE(329),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(329),
    [sym_class] = STATE(329),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(329),
    [sym_arrow_function] = STATE(329),
    [sym_call_expression] = STATE(329),
    [sym_new_expression] = STATE(329),
    [sym_await_expression] = STATE(329),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(329),
    [sym_augmented_assignment_expression] = STATE(329),
    [sym_ternary_expression] = STATE(329),
    [sym_binary_expression] = STATE(329),
    [sym_unary_expression] = STATE(329),
    [sym_update_expression] = STATE(329),
    [sym_string] = STATE(329),
    [sym_template_string] = STATE(329),
    [sym_regex] = STATE(329),
    [sym_meta_property] = STATE(329),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(953),
    [sym_this] = ACTIONS(955),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(955),
    [sym_false] = ACTIONS(955),
    [sym_null] = ACTIONS(955),
    [sym_undefined] = ACTIONS(955),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [154] = {
    [sym_import] = STATE(317),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(317),
    [sym_yield_expression] = STATE(317),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(317),
    [sym_jsx_fragment] = STATE(317),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(317),
    [sym_class] = STATE(317),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(317),
    [sym_arrow_function] = STATE(317),
    [sym_call_expression] = STATE(317),
    [sym_new_expression] = STATE(317),
    [sym_await_expression] = STATE(317),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(317),
    [sym_augmented_assignment_expression] = STATE(317),
    [sym_ternary_expression] = STATE(317),
    [sym_binary_expression] = STATE(317),
    [sym_unary_expression] = STATE(317),
    [sym_update_expression] = STATE(317),
    [sym_string] = STATE(317),
    [sym_template_string] = STATE(317),
    [sym_regex] = STATE(317),
    [sym_meta_property] = STATE(317),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(957),
    [sym_this] = ACTIONS(959),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(959),
    [sym_false] = ACTIONS(959),
    [sym_null] = ACTIONS(959),
    [sym_undefined] = ACTIONS(959),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [155] = {
    [sym_import] = STATE(328),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(328),
    [sym_yield_expression] = STATE(328),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(328),
    [sym_jsx_fragment] = STATE(328),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(328),
    [sym_class] = STATE(328),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(328),
    [sym_arrow_function] = STATE(328),
    [sym_call_expression] = STATE(328),
    [sym_new_expression] = STATE(328),
    [sym_await_expression] = STATE(328),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(328),
    [sym_augmented_assignment_expression] = STATE(328),
    [sym_ternary_expression] = STATE(328),
    [sym_binary_expression] = STATE(328),
    [sym_unary_expression] = STATE(328),
    [sym_update_expression] = STATE(328),
    [sym_string] = STATE(328),
    [sym_template_string] = STATE(328),
    [sym_regex] = STATE(328),
    [sym_meta_property] = STATE(328),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(961),
    [sym_this] = ACTIONS(963),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(963),
    [sym_false] = ACTIONS(963),
    [sym_null] = ACTIONS(963),
    [sym_undefined] = ACTIONS(963),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [156] = {
    [sym_import] = STATE(327),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(327),
    [sym_yield_expression] = STATE(327),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(327),
    [sym_jsx_fragment] = STATE(327),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(327),
    [sym_class] = STATE(327),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(327),
    [sym_arrow_function] = STATE(327),
    [sym_call_expression] = STATE(327),
    [sym_new_expression] = STATE(327),
    [sym_await_expression] = STATE(327),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(327),
    [sym_augmented_assignment_expression] = STATE(327),
    [sym_ternary_expression] = STATE(327),
    [sym_binary_expression] = STATE(327),
    [sym_unary_expression] = STATE(327),
    [sym_update_expression] = STATE(327),
    [sym_string] = STATE(327),
    [sym_template_string] = STATE(327),
    [sym_regex] = STATE(327),
    [sym_meta_property] = STATE(327),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(965),
    [sym_this] = ACTIONS(967),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(967),
    [sym_false] = ACTIONS(967),
    [sym_null] = ACTIONS(967),
    [sym_undefined] = ACTIONS(967),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [157] = {
    [sym_import] = STATE(374),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(374),
    [sym_yield_expression] = STATE(374),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(374),
    [sym_jsx_fragment] = STATE(374),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(374),
    [sym_class] = STATE(374),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(374),
    [sym_arrow_function] = STATE(374),
    [sym_call_expression] = STATE(374),
    [sym_new_expression] = STATE(374),
    [sym_await_expression] = STATE(374),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(374),
    [sym_augmented_assignment_expression] = STATE(374),
    [sym_ternary_expression] = STATE(374),
    [sym_binary_expression] = STATE(374),
    [sym_unary_expression] = STATE(374),
    [sym_update_expression] = STATE(374),
    [sym_string] = STATE(374),
    [sym_template_string] = STATE(374),
    [sym_regex] = STATE(374),
    [sym_meta_property] = STATE(374),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(969),
    [sym_this] = ACTIONS(971),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(971),
    [sym_false] = ACTIONS(971),
    [sym_null] = ACTIONS(971),
    [sym_undefined] = ACTIONS(971),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [158] = {
    [sym_import] = STATE(500),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(500),
    [sym_yield_expression] = STATE(500),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(500),
    [sym_jsx_fragment] = STATE(500),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(500),
    [sym_class] = STATE(500),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(500),
    [sym_arrow_function] = STATE(500),
    [sym_call_expression] = STATE(500),
    [sym_new_expression] = STATE(500),
    [sym_await_expression] = STATE(500),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(500),
    [sym_augmented_assignment_expression] = STATE(500),
    [sym_ternary_expression] = STATE(500),
    [sym_binary_expression] = STATE(500),
    [sym_unary_expression] = STATE(500),
    [sym_update_expression] = STATE(500),
    [sym_string] = STATE(500),
    [sym_template_string] = STATE(500),
    [sym_regex] = STATE(500),
    [sym_meta_property] = STATE(500),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(973),
    [sym_this] = ACTIONS(975),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(975),
    [sym_false] = ACTIONS(975),
    [sym_null] = ACTIONS(975),
    [sym_undefined] = ACTIONS(975),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [159] = {
    [sym_import] = STATE(405),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(405),
    [sym_yield_expression] = STATE(405),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(405),
    [sym_jsx_fragment] = STATE(405),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(405),
    [sym_class] = STATE(405),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(405),
    [sym_arrow_function] = STATE(405),
    [sym_call_expression] = STATE(405),
    [sym_new_expression] = STATE(405),
    [sym_await_expression] = STATE(405),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(405),
    [sym_augmented_assignment_expression] = STATE(405),
    [sym_ternary_expression] = STATE(405),
    [sym_binary_expression] = STATE(405),
    [sym_unary_expression] = STATE(405),
    [sym_update_expression] = STATE(405),
    [sym_string] = STATE(405),
    [sym_template_string] = STATE(405),
    [sym_regex] = STATE(405),
    [sym_meta_property] = STATE(405),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(977),
    [sym_this] = ACTIONS(979),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(979),
    [sym_false] = ACTIONS(979),
    [sym_null] = ACTIONS(979),
    [sym_undefined] = ACTIONS(979),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [160] = {
    [sym_import] = STATE(499),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(499),
    [sym_yield_expression] = STATE(499),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(499),
    [sym_jsx_fragment] = STATE(499),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(499),
    [sym_class] = STATE(499),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(499),
    [sym_arrow_function] = STATE(499),
    [sym_call_expression] = STATE(499),
    [sym_new_expression] = STATE(499),
    [sym_await_expression] = STATE(499),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(499),
    [sym_augmented_assignment_expression] = STATE(499),
    [sym_ternary_expression] = STATE(499),
    [sym_binary_expression] = STATE(499),
    [sym_unary_expression] = STATE(499),
    [sym_update_expression] = STATE(499),
    [sym_string] = STATE(499),
    [sym_template_string] = STATE(499),
    [sym_regex] = STATE(499),
    [sym_meta_property] = STATE(499),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(981),
    [sym_this] = ACTIONS(983),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(983),
    [sym_false] = ACTIONS(983),
    [sym_null] = ACTIONS(983),
    [sym_undefined] = ACTIONS(983),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [161] = {
    [sym_import] = STATE(498),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(498),
    [sym_yield_expression] = STATE(498),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(498),
    [sym_jsx_fragment] = STATE(498),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(498),
    [sym_class] = STATE(498),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(498),
    [sym_arrow_function] = STATE(498),
    [sym_call_expression] = STATE(498),
    [sym_new_expression] = STATE(498),
    [sym_await_expression] = STATE(498),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(498),
    [sym_augmented_assignment_expression] = STATE(498),
    [sym_ternary_expression] = STATE(498),
    [sym_binary_expression] = STATE(498),
    [sym_unary_expression] = STATE(498),
    [sym_update_expression] = STATE(498),
    [sym_string] = STATE(498),
    [sym_template_string] = STATE(498),
    [sym_regex] = STATE(498),
    [sym_meta_property] = STATE(498),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(985),
    [sym_this] = ACTIONS(987),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(987),
    [sym_false] = ACTIONS(987),
    [sym_null] = ACTIONS(987),
    [sym_undefined] = ACTIONS(987),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [162] = {
    [sym_import] = STATE(497),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(497),
    [sym_yield_expression] = STATE(497),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(497),
    [sym_jsx_fragment] = STATE(497),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(497),
    [sym_class] = STATE(497),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(497),
    [sym_arrow_function] = STATE(497),
    [sym_call_expression] = STATE(497),
    [sym_new_expression] = STATE(497),
    [sym_await_expression] = STATE(497),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(497),
    [sym_augmented_assignment_expression] = STATE(497),
    [sym_ternary_expression] = STATE(497),
    [sym_binary_expression] = STATE(497),
    [sym_unary_expression] = STATE(497),
    [sym_update_expression] = STATE(497),
    [sym_string] = STATE(497),
    [sym_template_string] = STATE(497),
    [sym_regex] = STATE(497),
    [sym_meta_property] = STATE(497),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(989),
    [sym_this] = ACTIONS(991),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [sym_null] = ACTIONS(991),
    [sym_undefined] = ACTIONS(991),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [163] = {
    [sym_import] = STATE(321),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(321),
    [sym_yield_expression] = STATE(321),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(321),
    [sym_jsx_fragment] = STATE(321),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(321),
    [sym_class] = STATE(321),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(321),
    [sym_arrow_function] = STATE(321),
    [sym_call_expression] = STATE(321),
    [sym_new_expression] = STATE(321),
    [sym_await_expression] = STATE(321),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(321),
    [sym_augmented_assignment_expression] = STATE(321),
    [sym_ternary_expression] = STATE(321),
    [sym_binary_expression] = STATE(321),
    [sym_unary_expression] = STATE(321),
    [sym_update_expression] = STATE(321),
    [sym_string] = STATE(321),
    [sym_template_string] = STATE(321),
    [sym_regex] = STATE(321),
    [sym_meta_property] = STATE(321),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(993),
    [sym_this] = ACTIONS(995),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(995),
    [sym_false] = ACTIONS(995),
    [sym_null] = ACTIONS(995),
    [sym_undefined] = ACTIONS(995),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [164] = {
    [sym_import] = STATE(408),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(408),
    [sym_yield_expression] = STATE(408),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(408),
    [sym_jsx_fragment] = STATE(408),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(408),
    [sym_class] = STATE(408),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(408),
    [sym_arrow_function] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_new_expression] = STATE(408),
    [sym_await_expression] = STATE(408),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(408),
    [sym_augmented_assignment_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_update_expression] = STATE(408),
    [sym_string] = STATE(408),
    [sym_template_string] = STATE(408),
    [sym_regex] = STATE(408),
    [sym_meta_property] = STATE(408),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(997),
    [sym_this] = ACTIONS(999),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(999),
    [sym_false] = ACTIONS(999),
    [sym_null] = ACTIONS(999),
    [sym_undefined] = ACTIONS(999),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [165] = {
    [sym_import] = STATE(569),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(569),
    [sym_yield_expression] = STATE(569),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(569),
    [sym_jsx_fragment] = STATE(569),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(569),
    [sym_class] = STATE(569),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(569),
    [sym_arrow_function] = STATE(569),
    [sym_call_expression] = STATE(569),
    [sym_new_expression] = STATE(569),
    [sym_await_expression] = STATE(569),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(569),
    [sym_augmented_assignment_expression] = STATE(569),
    [sym_ternary_expression] = STATE(569),
    [sym_binary_expression] = STATE(569),
    [sym_unary_expression] = STATE(569),
    [sym_update_expression] = STATE(569),
    [sym_string] = STATE(569),
    [sym_template_string] = STATE(569),
    [sym_regex] = STATE(569),
    [sym_meta_property] = STATE(569),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1001),
    [sym_this] = ACTIONS(1003),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1003),
    [sym_false] = ACTIONS(1003),
    [sym_null] = ACTIONS(1003),
    [sym_undefined] = ACTIONS(1003),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [166] = {
    [sym_import] = STATE(410),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(410),
    [sym_yield_expression] = STATE(410),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(410),
    [sym_jsx_fragment] = STATE(410),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(410),
    [sym_class] = STATE(410),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(410),
    [sym_arrow_function] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_new_expression] = STATE(410),
    [sym_await_expression] = STATE(410),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(410),
    [sym_augmented_assignment_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym_string] = STATE(410),
    [sym_template_string] = STATE(410),
    [sym_regex] = STATE(410),
    [sym_meta_property] = STATE(410),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1005),
    [sym_this] = ACTIONS(1007),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1007),
    [sym_false] = ACTIONS(1007),
    [sym_null] = ACTIONS(1007),
    [sym_undefined] = ACTIONS(1007),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [167] = {
    [sym_import] = STATE(411),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(411),
    [sym_yield_expression] = STATE(411),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(411),
    [sym_jsx_fragment] = STATE(411),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(411),
    [sym_class] = STATE(411),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(411),
    [sym_arrow_function] = STATE(411),
    [sym_call_expression] = STATE(411),
    [sym_new_expression] = STATE(411),
    [sym_await_expression] = STATE(411),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(411),
    [sym_augmented_assignment_expression] = STATE(411),
    [sym_ternary_expression] = STATE(411),
    [sym_binary_expression] = STATE(411),
    [sym_unary_expression] = STATE(411),
    [sym_update_expression] = STATE(411),
    [sym_string] = STATE(411),
    [sym_template_string] = STATE(411),
    [sym_regex] = STATE(411),
    [sym_meta_property] = STATE(411),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1009),
    [sym_this] = ACTIONS(1011),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1011),
    [sym_false] = ACTIONS(1011),
    [sym_null] = ACTIONS(1011),
    [sym_undefined] = ACTIONS(1011),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [168] = {
    [sym_import] = STATE(412),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(412),
    [sym_yield_expression] = STATE(412),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(412),
    [sym_jsx_fragment] = STATE(412),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(412),
    [sym_class] = STATE(412),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(412),
    [sym_arrow_function] = STATE(412),
    [sym_call_expression] = STATE(412),
    [sym_new_expression] = STATE(412),
    [sym_await_expression] = STATE(412),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(412),
    [sym_augmented_assignment_expression] = STATE(412),
    [sym_ternary_expression] = STATE(412),
    [sym_binary_expression] = STATE(412),
    [sym_unary_expression] = STATE(412),
    [sym_update_expression] = STATE(412),
    [sym_string] = STATE(412),
    [sym_template_string] = STATE(412),
    [sym_regex] = STATE(412),
    [sym_meta_property] = STATE(412),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1013),
    [sym_this] = ACTIONS(1015),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1015),
    [sym_false] = ACTIONS(1015),
    [sym_null] = ACTIONS(1015),
    [sym_undefined] = ACTIONS(1015),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [169] = {
    [sym_import] = STATE(413),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(413),
    [sym_yield_expression] = STATE(413),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(413),
    [sym_jsx_fragment] = STATE(413),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(413),
    [sym_class] = STATE(413),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(413),
    [sym_arrow_function] = STATE(413),
    [sym_call_expression] = STATE(413),
    [sym_new_expression] = STATE(413),
    [sym_await_expression] = STATE(413),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(413),
    [sym_augmented_assignment_expression] = STATE(413),
    [sym_ternary_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym_string] = STATE(413),
    [sym_template_string] = STATE(413),
    [sym_regex] = STATE(413),
    [sym_meta_property] = STATE(413),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1017),
    [sym_this] = ACTIONS(1019),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1019),
    [sym_false] = ACTIONS(1019),
    [sym_null] = ACTIONS(1019),
    [sym_undefined] = ACTIONS(1019),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [170] = {
    [sym_import] = STATE(355),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(355),
    [sym_yield_expression] = STATE(355),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(355),
    [sym_jsx_fragment] = STATE(355),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(355),
    [sym_class] = STATE(355),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(355),
    [sym_arrow_function] = STATE(355),
    [sym_call_expression] = STATE(355),
    [sym_new_expression] = STATE(355),
    [sym_await_expression] = STATE(355),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(355),
    [sym_augmented_assignment_expression] = STATE(355),
    [sym_ternary_expression] = STATE(355),
    [sym_binary_expression] = STATE(355),
    [sym_unary_expression] = STATE(355),
    [sym_update_expression] = STATE(355),
    [sym_string] = STATE(355),
    [sym_template_string] = STATE(355),
    [sym_regex] = STATE(355),
    [sym_meta_property] = STATE(355),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1021),
    [sym_this] = ACTIONS(1023),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1023),
    [sym_false] = ACTIONS(1023),
    [sym_null] = ACTIONS(1023),
    [sym_undefined] = ACTIONS(1023),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [171] = {
    [sym_import] = STATE(339),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(339),
    [sym_yield_expression] = STATE(339),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(339),
    [sym_jsx_fragment] = STATE(339),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(339),
    [sym_class] = STATE(339),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(339),
    [sym_arrow_function] = STATE(339),
    [sym_call_expression] = STATE(339),
    [sym_new_expression] = STATE(339),
    [sym_await_expression] = STATE(339),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(339),
    [sym_augmented_assignment_expression] = STATE(339),
    [sym_ternary_expression] = STATE(339),
    [sym_binary_expression] = STATE(339),
    [sym_unary_expression] = STATE(339),
    [sym_update_expression] = STATE(339),
    [sym_string] = STATE(339),
    [sym_template_string] = STATE(339),
    [sym_regex] = STATE(339),
    [sym_meta_property] = STATE(339),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1025),
    [sym_this] = ACTIONS(1027),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1027),
    [sym_false] = ACTIONS(1027),
    [sym_null] = ACTIONS(1027),
    [sym_undefined] = ACTIONS(1027),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [172] = {
    [sym_import] = STATE(342),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(342),
    [sym_yield_expression] = STATE(342),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(342),
    [sym_jsx_fragment] = STATE(342),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(342),
    [sym_class] = STATE(342),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(342),
    [sym_arrow_function] = STATE(342),
    [sym_call_expression] = STATE(342),
    [sym_new_expression] = STATE(342),
    [sym_await_expression] = STATE(342),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(342),
    [sym_augmented_assignment_expression] = STATE(342),
    [sym_ternary_expression] = STATE(342),
    [sym_binary_expression] = STATE(342),
    [sym_unary_expression] = STATE(342),
    [sym_update_expression] = STATE(342),
    [sym_string] = STATE(342),
    [sym_template_string] = STATE(342),
    [sym_regex] = STATE(342),
    [sym_meta_property] = STATE(342),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1029),
    [sym_this] = ACTIONS(1031),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1031),
    [sym_false] = ACTIONS(1031),
    [sym_null] = ACTIONS(1031),
    [sym_undefined] = ACTIONS(1031),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [173] = {
    [sym_import] = STATE(353),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(353),
    [sym_yield_expression] = STATE(353),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(353),
    [sym_jsx_fragment] = STATE(353),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(353),
    [sym_class] = STATE(353),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(353),
    [sym_arrow_function] = STATE(353),
    [sym_call_expression] = STATE(353),
    [sym_new_expression] = STATE(353),
    [sym_await_expression] = STATE(353),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(353),
    [sym_augmented_assignment_expression] = STATE(353),
    [sym_ternary_expression] = STATE(353),
    [sym_binary_expression] = STATE(353),
    [sym_unary_expression] = STATE(353),
    [sym_update_expression] = STATE(353),
    [sym_string] = STATE(353),
    [sym_template_string] = STATE(353),
    [sym_regex] = STATE(353),
    [sym_meta_property] = STATE(353),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1033),
    [sym_this] = ACTIONS(1035),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1035),
    [sym_false] = ACTIONS(1035),
    [sym_null] = ACTIONS(1035),
    [sym_undefined] = ACTIONS(1035),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [174] = {
    [sym_import] = STATE(344),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(344),
    [sym_yield_expression] = STATE(344),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(344),
    [sym_jsx_fragment] = STATE(344),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(344),
    [sym_class] = STATE(344),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(344),
    [sym_arrow_function] = STATE(344),
    [sym_call_expression] = STATE(344),
    [sym_new_expression] = STATE(344),
    [sym_await_expression] = STATE(344),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(344),
    [sym_augmented_assignment_expression] = STATE(344),
    [sym_ternary_expression] = STATE(344),
    [sym_binary_expression] = STATE(344),
    [sym_unary_expression] = STATE(344),
    [sym_update_expression] = STATE(344),
    [sym_string] = STATE(344),
    [sym_template_string] = STATE(344),
    [sym_regex] = STATE(344),
    [sym_meta_property] = STATE(344),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1037),
    [sym_this] = ACTIONS(1039),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1039),
    [sym_false] = ACTIONS(1039),
    [sym_null] = ACTIONS(1039),
    [sym_undefined] = ACTIONS(1039),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [175] = {
    [sym_import] = STATE(333),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(333),
    [sym_yield_expression] = STATE(333),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(333),
    [sym_jsx_fragment] = STATE(333),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(333),
    [sym_class] = STATE(333),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(333),
    [sym_arrow_function] = STATE(333),
    [sym_call_expression] = STATE(333),
    [sym_new_expression] = STATE(333),
    [sym_await_expression] = STATE(333),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(333),
    [sym_augmented_assignment_expression] = STATE(333),
    [sym_ternary_expression] = STATE(333),
    [sym_binary_expression] = STATE(333),
    [sym_unary_expression] = STATE(333),
    [sym_update_expression] = STATE(333),
    [sym_string] = STATE(333),
    [sym_template_string] = STATE(333),
    [sym_regex] = STATE(333),
    [sym_meta_property] = STATE(333),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1041),
    [sym_this] = ACTIONS(1043),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1043),
    [sym_false] = ACTIONS(1043),
    [sym_null] = ACTIONS(1043),
    [sym_undefined] = ACTIONS(1043),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [176] = {
    [sym_import] = STATE(352),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(352),
    [sym_yield_expression] = STATE(352),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(352),
    [sym_jsx_fragment] = STATE(352),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(352),
    [sym_class] = STATE(352),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(352),
    [sym_arrow_function] = STATE(352),
    [sym_call_expression] = STATE(352),
    [sym_new_expression] = STATE(352),
    [sym_await_expression] = STATE(352),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(352),
    [sym_augmented_assignment_expression] = STATE(352),
    [sym_ternary_expression] = STATE(352),
    [sym_binary_expression] = STATE(352),
    [sym_unary_expression] = STATE(352),
    [sym_update_expression] = STATE(352),
    [sym_string] = STATE(352),
    [sym_template_string] = STATE(352),
    [sym_regex] = STATE(352),
    [sym_meta_property] = STATE(352),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1045),
    [sym_this] = ACTIONS(1047),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1047),
    [sym_false] = ACTIONS(1047),
    [sym_null] = ACTIONS(1047),
    [sym_undefined] = ACTIONS(1047),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [177] = {
    [sym_import] = STATE(351),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(351),
    [sym_yield_expression] = STATE(351),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(351),
    [sym_jsx_fragment] = STATE(351),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(351),
    [sym_class] = STATE(351),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(351),
    [sym_arrow_function] = STATE(351),
    [sym_call_expression] = STATE(351),
    [sym_new_expression] = STATE(351),
    [sym_await_expression] = STATE(351),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(351),
    [sym_augmented_assignment_expression] = STATE(351),
    [sym_ternary_expression] = STATE(351),
    [sym_binary_expression] = STATE(351),
    [sym_unary_expression] = STATE(351),
    [sym_update_expression] = STATE(351),
    [sym_string] = STATE(351),
    [sym_template_string] = STATE(351),
    [sym_regex] = STATE(351),
    [sym_meta_property] = STATE(351),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1049),
    [sym_this] = ACTIONS(1051),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1051),
    [sym_false] = ACTIONS(1051),
    [sym_null] = ACTIONS(1051),
    [sym_undefined] = ACTIONS(1051),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [178] = {
    [sym_import] = STATE(414),
    [sym_parenthesized_expression] = STATE(302),
    [sym__expression] = STATE(414),
    [sym_yield_expression] = STATE(414),
    [sym_object] = STATE(480),
    [sym_array] = STATE(482),
    [sym_jsx_element] = STATE(414),
    [sym_jsx_fragment] = STATE(414),
    [sym_jsx_opening_element] = STATE(659),
    [sym_jsx_self_closing_element] = STATE(414),
    [sym_class] = STATE(414),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(414),
    [sym_arrow_function] = STATE(414),
    [sym_call_expression] = STATE(414),
    [sym_new_expression] = STATE(414),
    [sym_await_expression] = STATE(414),
    [sym_member_expression] = STATE(302),
    [sym_subscript_expression] = STATE(302),
    [sym_assignment_expression] = STATE(414),
    [sym_augmented_assignment_expression] = STATE(414),
    [sym_ternary_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_update_expression] = STATE(414),
    [sym_string] = STATE(414),
    [sym_template_string] = STATE(414),
    [sym_regex] = STATE(414),
    [sym_meta_property] = STATE(414),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1110),
    [aux_sym_export_statement_repeat1] = STATE(791),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(378),
    [anon_sym_async] = ACTIONS(380),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(1053),
    [sym_this] = ACTIONS(1055),
    [sym_super] = ACTIONS(85),
    [sym_true] = ACTIONS(1055),
    [sym_false] = ACTIONS(1055),
    [sym_null] = ACTIONS(1055),
    [sym_undefined] = ACTIONS(1055),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(390),
    [anon_sym_get] = ACTIONS(390),
    [anon_sym_set] = ACTIONS(390),
  },
  [179] = {
    [sym_import] = STATE(332),
    [sym_parenthesized_expression] = STATE(278),
    [sym__expression] = STATE(332),
    [sym_yield_expression] = STATE(332),
    [sym_object] = STATE(358),
    [sym_array] = STATE(359),
    [sym_jsx_element] = STATE(332),
    [sym_jsx_fragment] = STATE(332),
    [sym_jsx_opening_element] = STATE(671),
    [sym_jsx_self_closing_element] = STATE(332),
    [sym_class] = STATE(332),
    [sym_function] = STATE(331),
    [sym_generator_function] = STATE(332),
    [sym_arrow_function] = STATE(332),
    [sym_call_expression] = STATE(332),
    [sym_new_expression] = STATE(332),
    [sym_await_expression] = STATE(332),
    [sym_member_expression] = STATE(278),
    [sym_subscript_expression] = STATE(278),
    [sym_assignment_expression] = STATE(332),
    [sym_augmented_assignment_expression] = STATE(332),
    [sym_ternary_expression] = STATE(332),
    [sym_binary_expression] = STATE(332),
    [sym_unary_expression] = STATE(332),
    [sym_update_expression] = STATE(332),
    [sym_string] = STATE(332),
    [sym_template_string] = STATE(332),
    [sym_regex] = STATE(332),
    [sym_meta_property] = STATE(332),
    [sym_decorator] = STATE(635),
    [sym_formal_parameters] = STATE(1121),
    [aux_sym_export_statement_repeat1] = STATE(807),
    [sym_identifier] = ACTIONS(312),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_await] = ACTIONS(324),
    [anon_sym_yield] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(330),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(334),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_async] = ACTIONS(338),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_new] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_typeof] = ACTIONS(350),
    [anon_sym_void] = ACTIONS(350),
    [anon_sym_delete] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(352),
    [anon_sym_DASH_DASH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym_number] = ACTIONS(1057),
    [sym_this] = ACTIONS(1059),
    [sym_super] = ACTIONS(364),
    [sym_true] = ACTIONS(1059),
    [sym_false] = ACTIONS(1059),
    [sym_null] = ACTIONS(1059),
    [sym_undefined] = ACTIONS(1059),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(366),
    [anon_sym_get] = ACTIONS(366),
    [anon_sym_set] = ACTIONS(366),
  },
  [180] = {
    [sym_string] = STATE(1015),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(848),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(853),
    [anon_sym_LPAREN] = ACTIONS(1063),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(1066),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(1061),
    [anon_sym_get] = ACTIONS(1068),
    [anon_sym_set] = ACTIONS(1068),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
  [181] = {
    [sym_string] = STATE(1015),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(838),
    [sym_identifier] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(848),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(883),
    [anon_sym_LPAREN] = ACTIONS(1063),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(1066),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(1061),
    [anon_sym_get] = ACTIONS(1068),
    [anon_sym_set] = ACTIONS(1068),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
  [182] = {
    [sym_string] = STATE(1015),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(838),
    [sym_identifier] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(859),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(883),
    [anon_sym_LPAREN] = ACTIONS(1063),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(1061),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(1061),
    [anon_sym_get] = ACTIONS(1061),
    [anon_sym_set] = ACTIONS(1061),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
  [183] = {
    [sym_string] = STATE(1015),
    [sym__property_name] = STATE(1015),
    [sym_computed_property_name] = STATE(1015),
    [aux_sym_object_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(1061),
    [anon_sym_STAR] = ACTIONS(859),
    [anon_sym_COMMA] = ACTIONS(851),
    [anon_sym_RBRACE] = ACTIONS(853),
    [anon_sym_LPAREN] = ACTIONS(1063),
    [anon_sym_in] = ACTIONS(859),
    [anon_sym_SEMI] = ACTIONS(851),
    [anon_sym_COLON] = ACTIONS(861),
    [anon_sym_EQ] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(866),
    [anon_sym_LT] = ACTIONS(859),
    [anon_sym_GT] = ACTIONS(859),
    [anon_sym_SLASH] = ACTIONS(859),
    [anon_sym_DOT] = ACTIONS(869),
    [anon_sym_async] = ACTIONS(1061),
    [anon_sym_EQ_GT] = ACTIONS(875),
    [anon_sym_PLUS_EQ] = ACTIONS(877),
    [anon_sym_DASH_EQ] = ACTIONS(877),
    [anon_sym_STAR_EQ] = ACTIONS(877),
    [anon_sym_SLASH_EQ] = ACTIONS(877),
    [anon_sym_PERCENT_EQ] = ACTIONS(877),
    [anon_sym_CARET_EQ] = ACTIONS(877),
    [anon_sym_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(877),
    [anon_sym_LT_LT_EQ] = ACTIONS(877),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(877),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(877),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(877),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_AMP_AMP] = ACTIONS(859),
    [anon_sym_PIPE_PIPE] = ACTIONS(859),
    [anon_sym_GT_GT] = ACTIONS(859),
    [anon_sym_GT_GT_GT] = ACTIONS(859),
    [anon_sym_LT_LT] = ACTIONS(859),
    [anon_sym_AMP] = ACTIONS(859),
    [anon_sym_CARET] = ACTIONS(859),
    [anon_sym_PIPE] = ACTIONS(859),
    [anon_sym_PLUS] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT] = ACTIONS(859),
    [anon_sym_STAR_STAR] = ACTIONS(859),
    [anon_sym_LT_EQ] = ACTIONS(851),
    [anon_sym_EQ_EQ] = ACTIONS(859),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(851),
    [anon_sym_BANG_EQ] = ACTIONS(859),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(851),
    [anon_sym_GT_EQ] = ACTIONS(851),
    [anon_sym_QMARK_QMARK] = ACTIONS(859),
    [anon_sym_instanceof] = ACTIONS(859),
    [anon_sym_PLUS_PLUS] = ACTIONS(851),
    [anon_sym_DASH_DASH] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_SQUOTE] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(851),
    [sym_number] = ACTIONS(879),
    [anon_sym_static] = ACTIONS(1061),
    [anon_sym_get] = ACTIONS(1061),
    [anon_sym_set] = ACTIONS(1061),
    [sym__automatic_semicolon] = ACTIONS(851),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 1,
      sym__automatic_semicolon,
    ACTIONS(392), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(394), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [73] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_function,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    STATE(407), 1,
      sym_arguments,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1080), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1074), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1072), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [162] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1088), 1,
      sym__automatic_semicolon,
    ACTIONS(494), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(496), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [235] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_function,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1080), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 14,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [323] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_catch,
    ACTIONS(1099), 1,
      anon_sym_finally,
    STATE(193), 1,
      sym_catch_clause,
    STATE(233), 1,
      sym_finally_clause,
    ACTIONS(1093), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1095), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(482), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(496), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [541] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1107), 1,
      anon_sym_function,
    STATE(535), 1,
      sym_arguments,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1105), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1074), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1072), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [628] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1107), 1,
      anon_sym_function,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1105), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [714] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      anon_sym_finally,
    STATE(221), 1,
      sym_finally_clause,
    ACTIONS(1111), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1113), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [786] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 1,
      anon_sym_function,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1115), 1,
      anon_sym_COLON,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1105), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [874] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1107), 1,
      anon_sym_function,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1117), 1,
      anon_sym_in,
    ACTIONS(1120), 1,
      anon_sym_of,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1105), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [964] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1101), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1122), 1,
      anon_sym_COLON,
    ACTIONS(1124), 1,
      anon_sym_function,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(1105), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(444), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(496), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1186] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_function,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1126), 1,
      anon_sym_COMMA,
    ACTIONS(1129), 1,
      anon_sym_RPAREN,
    ACTIONS(1132), 1,
      anon_sym_EQ,
    STATE(817), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1080), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 8,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1277] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 1,
      sym__automatic_semicolon,
    ACTIONS(446), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(448), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(458), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1136), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(482), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1547] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 1,
      sym__automatic_semicolon,
    ACTIONS(392), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(394), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1616] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1140), 1,
      sym__automatic_semicolon,
    ACTIONS(494), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(496), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1144), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1148), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1150), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1152), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1886] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 1,
      sym__automatic_semicolon,
    ACTIONS(460), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(462), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1154), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1156), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2022] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 1,
      sym__automatic_semicolon,
    ACTIONS(402), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(404), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1160), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2158] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 1,
      sym__automatic_semicolon,
    ACTIONS(412), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(414), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2227] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 1,
      sym__automatic_semicolon,
    ACTIONS(422), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(424), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2296] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 1,
      sym__automatic_semicolon,
    ACTIONS(470), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(472), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2365] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 1,
      sym__automatic_semicolon,
    ACTIONS(432), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(434), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2434] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 1,
      sym__automatic_semicolon,
    ACTIONS(484), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(486), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1162), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1164), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1168), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1172), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1176), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1178), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1180), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1184), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1188), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1192), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1194), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1196), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1198), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1200), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1204), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1208), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1210), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1212), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1216), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1218), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1220), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1224), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1226), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1228), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1232), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1234), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1236), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1238), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1240), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1242), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1244), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3889] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1246), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1248), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1250), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1252), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1256), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1260), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1262), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1264), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1268), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1272), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1274), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1276), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1278), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1280), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1284), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1288), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1290), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1292), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1296), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1298), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1300), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1304), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1306), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1308), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1310), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1312), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1316), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1318), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1320), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5143] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      anon_sym_else,
    ACTIONS(1322), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1324), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1330), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1332), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1334), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1338), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5409] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_function,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1340), 1,
      anon_sym_in,
    ACTIONS(1343), 1,
      anon_sym_of,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1080), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 8,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [5496] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_function,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    ACTIONS(1117), 1,
      anon_sym_in,
    ACTIONS(1120), 1,
      anon_sym_of,
    STATE(1099), 1,
      sym_formal_parameters,
    ACTIONS(1080), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(851), 8,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [5583] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1347), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1345), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5659] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    STATE(407), 1,
      sym_arguments,
    ACTIONS(1074), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1072), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5735] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      anon_sym_COLON,
    ACTIONS(883), 1,
      anon_sym_RBRACE,
    ACTIONS(1363), 1,
      anon_sym_LPAREN,
    ACTIONS(1366), 1,
      anon_sym_EQ,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    STATE(838), 1,
      aux_sym_object_repeat1,
    ACTIONS(1361), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5814] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 1,
      anon_sym_RBRACE,
    ACTIONS(861), 1,
      anon_sym_COLON,
    ACTIONS(1363), 1,
      anon_sym_LPAREN,
    ACTIONS(1366), 1,
      anon_sym_EQ,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    STATE(870), 1,
      aux_sym_object_repeat1,
    ACTIONS(1361), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1376), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [5956] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1347), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1345), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1380), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1384), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6153] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1361), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6224] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(851), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1388), 33,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6358] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_arguments,
    ACTIONS(1347), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1345), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6432] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    STATE(535), 1,
      sym_arguments,
    ACTIONS(1074), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1072), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6506] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1394), 1,
      anon_sym_in,
    ACTIONS(1397), 1,
      anon_sym_of,
    ACTIONS(1399), 1,
      anon_sym_EQ,
    STATE(839), 1,
      sym__initializer,
    ACTIONS(1392), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1361), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6584] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1361), 17,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6650] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_COLON,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1361), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6721] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_arguments,
    ACTIONS(1347), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1345), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1384), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6851] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1374), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1376), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1405), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1403), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1407), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1378), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1380), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7095] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1361), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1411), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7225] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1415), 1,
      anon_sym_in,
    ACTIONS(1418), 1,
      anon_sym_of,
    ACTIONS(1361), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7298] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1117), 1,
      anon_sym_in,
    ACTIONS(1420), 1,
      anon_sym_of,
    ACTIONS(851), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7371] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(851), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7440] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1115), 1,
      anon_sym_COLON,
    ACTIONS(851), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1386), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1388), 31,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1386), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1424), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1422), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7694] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1428), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1426), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1430), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1436), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1434), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7877] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1122), 1,
      anon_sym_COLON,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1370), 1,
      anon_sym_EQ_GT,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1361), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7948] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 1,
      anon_sym_EQ_GT,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1109), 1,
      anon_sym_EQ,
    ACTIONS(1122), 1,
      anon_sym_COLON,
    ACTIONS(851), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(877), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8019] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1438), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8080] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1442), 1,
      anon_sym_COMMA,
    ACTIONS(1445), 1,
      anon_sym_RPAREN,
    ACTIONS(1448), 1,
      anon_sym_EQ,
    STATE(813), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(1361), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8154] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1361), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8218] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1401), 1,
      anon_sym_EQ,
    ACTIONS(1415), 1,
      anon_sym_in,
    ACTIONS(1418), 1,
      anon_sym_of,
    ACTIONS(1361), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1372), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8286] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1126), 1,
      anon_sym_COMMA,
    ACTIONS(1129), 1,
      anon_sym_RPAREN,
    ACTIONS(1132), 1,
      anon_sym_EQ,
    STATE(817), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(851), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8360] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1450), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1361), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8429] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1415), 1,
      anon_sym_in,
    ACTIONS(1418), 1,
      anon_sym_of,
    ACTIONS(1361), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8499] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1117), 1,
      anon_sym_in,
    ACTIONS(1420), 1,
      anon_sym_of,
    ACTIONS(851), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8569] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_EQ,
    ACTIONS(1078), 1,
      anon_sym_DOT,
    ACTIONS(1084), 1,
      anon_sym_EQ_GT,
    ACTIONS(1340), 1,
      anon_sym_in,
    ACTIONS(1453), 1,
      anon_sym_of,
    ACTIONS(851), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1086), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(859), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8639] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1355), 1,
      anon_sym_EQ_GT,
    ACTIONS(1394), 1,
      anon_sym_in,
    ACTIONS(1397), 1,
      anon_sym_of,
    ACTIONS(1361), 10,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8709] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1415), 1,
      anon_sym_in,
    ACTIONS(1418), 1,
      anon_sym_of,
    ACTIONS(1361), 11,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1455), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1457), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [8831] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1459), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1461), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [8888] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1394), 1,
      anon_sym_in,
    ACTIONS(1397), 1,
      anon_sym_of,
    ACTIONS(1361), 11,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1357), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(1359), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1465), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [9010] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(1467), 1,
      sym_identifier,
    ACTIONS(1469), 1,
      anon_sym_STAR,
    ACTIONS(1471), 1,
      anon_sym_LBRACE,
    STATE(895), 1,
      sym_string,
    STATE(904), 1,
      sym_import_clause,
    STATE(1131), 2,
      sym_namespace_import,
      sym_named_imports,
    ACTIONS(1475), 13,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
    ACTIONS(1473), 21,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9077] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1479), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9159] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1507), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9241] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1509), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9323] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1511), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9405] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1515), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9453] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1517), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9535] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1519), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9617] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1521), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9699] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1523), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1345), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9753] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1525), 1,
      anon_sym_EQ,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1345), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9807] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(398), 1,
      sym_arguments,
    STATE(418), 1,
      sym_template_string,
    ACTIONS(1345), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9859] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1527), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1529), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [9919] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1527), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1529), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [9979] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1527), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1529), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10039] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1531), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1533), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [10097] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1359), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1361), 23,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [10151] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1535), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1537), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10213] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1535), 2,
      anon_sym_QMARK,
      anon_sym_PIPE,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1537), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [10289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1539), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1541), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10337] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1543), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10419] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1545), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10501] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1547), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10583] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 1,
      anon_sym_EQ,
    ACTIONS(1549), 1,
      sym__automatic_semicolon,
    ACTIONS(394), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(392), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10635] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1551), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10717] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1555), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1559), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10813] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1535), 1,
      anon_sym_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1537), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_QMARK_QMARK,
  [10893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1563), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10941] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1535), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1537), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11007] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1567), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11055] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1569), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1571), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11103] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1573), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11185] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1575), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(398), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11315] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1577), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11397] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1535), 8,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1537), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11465] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1535), 3,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1537), 10,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [11537] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1535), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1537), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11597] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1579), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11679] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1581), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11761] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      sym_regex_flags,
    ACTIONS(1583), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
    ACTIONS(1585), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11810] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1549), 1,
      sym__automatic_semicolon,
    ACTIONS(394), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(392), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11859] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 1,
      anon_sym_EQ,
    ACTIONS(1359), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1361), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11908] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      anon_sym_EQ,
    ACTIONS(1359), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1361), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11957] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1589), 1,
      sym__automatic_semicolon,
    ACTIONS(496), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(494), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12006] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1591), 1,
      anon_sym_COMMA,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1593), 4,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12089] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_EQ_GT,
    ACTIONS(1459), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1461), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12138] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    STATE(406), 1,
      sym_arguments,
    ACTIONS(1345), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 24,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1597), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1599), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12235] = 5,
    ACTIONS(3), 1,
      sym_comment,
    STATE(418), 1,
      sym_template_string,
    STATE(547), 1,
      sym_arguments,
    ACTIONS(1345), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 23,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1539), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1541), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(428), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12377] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1507), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(418), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(408), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12549] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1519), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12629] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1509), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12709] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1577), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12789] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1521), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [12869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1631), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12915] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      anon_sym_in,
    ACTIONS(1638), 1,
      anon_sym_of,
    ACTIONS(1640), 1,
      anon_sym_EQ,
    STATE(868), 1,
      sym__initializer,
    ACTIONS(1633), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1359), 12,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1361), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [12971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(398), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13017] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1644), 1,
      anon_sym_in,
    ACTIONS(1647), 1,
      anon_sym_of,
    ACTIONS(1649), 1,
      anon_sym_EQ,
    STATE(867), 1,
      sym__initializer,
    ACTIONS(1642), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(1359), 12,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1361), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1575), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1653), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1479), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(490), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(476), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1655), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1657), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13303] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1511), 4,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
    ACTIONS(1603), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1623), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1515), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(466), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1567), 24,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13521] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 1,
      anon_sym_BQUOTE,
    ACTIONS(1349), 1,
      anon_sym_LPAREN,
    ACTIONS(1353), 1,
      anon_sym_DOT,
    ACTIONS(1483), 1,
      anon_sym_LBRACK,
    ACTIONS(1485), 1,
      anon_sym_QMARK,
    ACTIONS(1487), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1493), 1,
      anon_sym_AMP,
    ACTIONS(1495), 1,
      anon_sym_PIPE,
    ACTIONS(1499), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1503), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1489), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1497), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1505), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(418), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1477), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1491), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1659), 4,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(1481), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1501), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
  [13601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(452), 25,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [13647] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 1,
      anon_sym_BQUOTE,
    ACTIONS(1368), 1,
      anon_sym_DOT,
    ACTIONS(1390), 1,
      anon_sym_LPAREN,
    ACTIONS(1605), 1,
      anon_sym_LBRACK,
    ACTIONS(1607), 1,
      anon_sym_QMARK,
    ACTIONS(1609), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_AMP,
    ACTIONS(1617), 1,
      anon_sym_PIPE,
    ACTIONS(1621), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1625), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1611), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1619), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1627), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(541), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1601), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1613), 3,
      ano