#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 952
#define LARGE_STATE_COUNT 243
#define SYMBOL_COUNT 271
#define ALIAS_COUNT 1
#define TOKEN_COUNT 123
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 11

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_null_literal = 12,
  anon_sym_LPAREN = 13,
  anon_sym_AMP = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DASH_EQ = 18,
  anon_sym_STAR_EQ = 19,
  anon_sym_SLASH_EQ = 20,
  anon_sym_AMP_EQ = 21,
  anon_sym_PIPE_EQ = 22,
  anon_sym_CARET_EQ = 23,
  anon_sym_PERCENT_EQ = 24,
  anon_sym_LT_LT_EQ = 25,
  anon_sym_GT_GT_EQ = 26,
  anon_sym_GT_GT_GT_EQ = 27,
  anon_sym_GT = 28,
  anon_sym_LT = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_GT_EQ = 31,
  anon_sym_LT_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_PIPE = 40,
  anon_sym_CARET = 41,
  anon_sym_PERCENT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_GT_GT_GT = 45,
  anon_sym_instanceof = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_COMMA = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  anon_sym_PLUS_PLUS = 53,
  anon_sym_DASH_DASH = 54,
  anon_sym_new = 55,
  anon_sym_LBRACK = 56,
  anon_sym_RBRACK = 57,
  anon_sym_DOT = 58,
  anon_sym_class = 59,
  anon_sym_COLON_COLON = 60,
  anon_sym_extends = 61,
  anon_sym_SEMI = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_assert = 65,
  anon_sym_switch = 66,
  anon_sym_case = 67,
  anon_sym_default = 68,
  anon_sym_do = 69,
  anon_sym_while = 70,
  anon_sym_break = 71,
  anon_sym_continue = 72,
  anon_sym_return = 73,
  anon_sym_synchronized = 74,
  anon_sym_throw = 75,
  anon_sym_try = 76,
  anon_sym_catch = 77,
  anon_sym_finally = 78,
  anon_sym_if = 79,
  anon_sym_else = 80,
  anon_sym_for = 81,
  anon_sym_AT = 82,
  anon_sym_open = 83,
  anon_sym_module = 84,
  anon_sym_requires = 85,
  anon_sym_exports = 86,
  anon_sym_to = 87,
  anon_sym_opens = 88,
  anon_sym_uses = 89,
  anon_sym_provides = 90,
  anon_sym_with = 91,
  anon_sym_transitive = 92,
  anon_sym_static = 93,
  anon_sym_package = 94,
  anon_sym_import = 95,
  anon_sym_enum = 96,
  anon_sym_public = 97,
  anon_sym_protected = 98,
  anon_sym_private = 99,
  anon_sym_abstract = 100,
  anon_sym_final = 101,
  anon_sym_strictfp = 102,
  anon_sym_native = 103,
  anon_sym_transient = 104,
  anon_sym_volatile = 105,
  anon_sym_implements = 106,
  anon_sym_ATinterface = 107,
  anon_sym_interface = 108,
  anon_sym_byte = 109,
  anon_sym_short = 110,
  anon_sym_int = 111,
  anon_sym_long = 112,
  anon_sym_char = 113,
  anon_sym_float = 114,
  anon_sym_double = 115,
  sym_boolean_type = 116,
  sym_void_type = 117,
  anon_sym_DOT_DOT_DOT = 118,
  anon_sym_throws = 119,
  sym_this = 120,
  sym_super = 121,
  sym_comment = 122,
  sym_program = 123,
  sym__literal = 124,
  sym__expression = 125,
  sym_cast_expression = 126,
  sym_assignment_expression = 127,
  sym_binary_expression = 128,
  sym_instanceof_expression = 129,
  sym_lambda_expression = 130,
  sym_inferred_parameters = 131,
  sym_ternary_expression = 132,
  sym_unary_expression = 133,
  sym_update_expression = 134,
  sym__primary = 135,
  sym_array_creation_expression = 136,
  sym_dimensions_expr = 137,
  sym_parenthesized_expression = 138,
  sym_class_literal = 139,
  sym_object_creation_expression = 140,
  sym__unqualified_object_creation_expression = 141,
  sym_field_access = 142,
  sym_array_access = 143,
  sym_method_invocation = 144,
  sym_argument_list = 145,
  sym_method_reference = 146,
  sym_type_arguments = 147,
  sym_wildcard = 148,
  sym__wildcard_bounds = 149,
  sym_dimensions = 150,
  sym__statement = 151,
  sym_block = 152,
  sym_expression_statement = 153,
  sym_labeled_statement = 154,
  sym_assert_statement = 155,
  sym_switch_statement = 156,
  sym_switch_block = 157,
  sym_switch_label = 158,
  sym_do_statement = 159,
  sym_break_statement = 160,
  sym_continue_statement = 161,
  sym_return_statement = 162,
  sym_synchronized_statement = 163,
  sym_throw_statement = 164,
  sym_try_statement = 165,
  sym_catch_clause = 166,
  sym_catch_formal_parameter = 167,
  sym_catch_type = 168,
  sym_finally_clause = 169,
  sym_try_with_resources_statement = 170,
  sym_resource_specification = 171,
  sym_resource = 172,
  sym_if_statement = 173,
  sym_while_statement = 174,
  sym_for_statement = 175,
  sym_enhanced_for_statement = 176,
  sym__annotation = 177,
  sym_marker_annotation = 178,
  sym_annotation = 179,
  sym_annotation_argument_list = 180,
  sym_element_value_pair = 181,
  sym__element_value = 182,
  sym_element_value_array_initializer = 183,
  sym__declaration = 184,
  sym_module_declaration = 185,
  sym_module_body = 186,
  sym_module_directive = 187,
  sym_requires_modifier = 188,
  sym_package_declaration = 189,
  sym_import_declaration = 190,
  sym_asterisk = 191,
  sym_enum_declaration = 192,
  sym_enum_body = 193,
  sym_enum_body_declarations = 194,
  sym_enum_constant = 195,
  sym_class_declaration = 196,
  sym_modifiers = 197,
  sym_type_parameters = 198,
  sym_type_parameter = 199,
  sym_type_bound = 200,
  sym_superclass = 201,
  sym_super_interfaces = 202,
  sym_interface_type_list = 203,
  sym_class_body = 204,
  sym_static_initializer = 205,
  sym_constructor_declaration = 206,
  sym__constructor_declarator = 207,
  sym_constructor_body = 208,
  sym_explicit_constructor_invocation = 209,
  sym_scoped_identifier = 210,
  sym_field_declaration = 211,
  sym_annotation_type_declaration = 212,
  sym_annotation_type_body = 213,
  sym_annotation_type_element_declaration = 214,
  sym__default_value = 215,
  sym_interface_declaration = 216,
  sym_extends_interfaces = 217,
  sym_interface_body = 218,
  sym_constant_declaration = 219,
  sym__variable_declarator_list = 220,
  sym_variable_declarator = 221,
  sym__variable_declarator_id = 222,
  sym_array_initializer = 223,
  sym__type = 224,
  sym__unannotated_type = 225,
  sym_annotated_type = 226,
  sym_scoped_type_identifier = 227,
  sym_generic_type = 228,
  sym_array_type = 229,
  sym_integral_type = 230,
  sym_floating_point_type = 231,
  sym__method_header = 232,
  sym__method_declarator = 233,
  sym_formal_parameters = 234,
  sym_formal_parameter = 235,
  sym_receiver_parameter = 236,
  sym_spread_parameter = 237,
  sym_throws = 238,
  sym_local_variable_declaration = 239,
  sym_method_declaration = 240,
  aux_sym_program_repeat1 = 241,
  aux_sym_cast_expression_repeat1 = 242,
  aux_sym_inferred_parameters_repeat1 = 243,
  aux_sym_array_creation_expression_repeat1 = 244,
  aux_sym_dimensions_expr_repeat1 = 245,
  aux_sym_argument_list_repeat1 = 246,
  aux_sym_type_arguments_repeat1 = 247,
  aux_sym_dimensions_repeat1 = 248,
  aux_sym_switch_block_repeat1 = 249,
  aux_sym_try_statement_repeat1 = 250,
  aux_sym_catch_type_repeat1 = 251,
  aux_sym_resource_specification_repeat1 = 252,
  aux_sym_for_statement_repeat1 = 253,
  aux_sym_for_statement_repeat2 = 254,
  aux_sym_annotation_argument_list_repeat1 = 255,
  aux_sym_element_value_array_initializer_repeat1 = 256,
  aux_sym_module_body_repeat1 = 257,
  aux_sym_module_directive_repeat1 = 258,
  aux_sym_module_directive_repeat2 = 259,
  aux_sym_enum_body_repeat1 = 260,
  aux_sym_enum_body_declarations_repeat1 = 261,
  aux_sym_modifiers_repeat1 = 262,
  aux_sym_type_parameters_repeat1 = 263,
  aux_sym_type_bound_repeat1 = 264,
  aux_sym_interface_type_list_repeat1 = 265,
  aux_sym_annotation_type_body_repeat1 = 266,
  aux_sym_interface_body_repeat1 = 267,
  aux_sym__variable_declarator_list_repeat1 = 268,
  aux_sym_array_initializer_repeat1 = 269,
  aux_sym_formal_parameters_repeat1 = 270,
  alias_sym_type_identifier = 271,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_assert] = "assert",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_comment] = "comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym__expression] = "_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym__primary] = "_primary",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym__statement] = "_statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym__declaration] = "_declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_directive_repeat1] = "module_directive_repeat1",
  [aux_sym_module_directive_repeat2] = "module_directive_repeat2",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_comment] = sym_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym__expression] = sym__expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym__primary] = sym__primary,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym__statement] = sym__statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_label] = sym_switch_label,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym__declaration] = sym__declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_dimensions_expr_repeat1] = aux_sym_dimensions_expr_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_directive_repeat1] = aux_sym_module_directive_repeat1,
  [aux_sym_module_directive_repeat2] = aux_sym_module_directive_repeat2,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_name = 17,
  field_object = 18,
  field_operand = 19,
  field_operator = 20,
  field_parameters = 21,
  field_resources = 22,
  field_right = 23,
  field_scope = 24,
  field_superclass = 25,
  field_type = 26,
  field_type_arguments = 27,
  field_type_parameters = 28,
  field_update = 29,
  field_value = 30,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[168] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 3},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 1},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 27, .length = 2},
  [24] = {.index = 29, .length = 2},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 3},
  [28] = {.index = 21, .length = 2},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 36, .length = 2},
  [32] = {.index = 33, .length = 3},
  [33] = {.index = 38, .length = 2},
  [35] = {.index = 40, .length = 2},
  [36] = {.index = 42, .length = 3},
  [37] = {.index = 45, .length = 2},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 47, .length = 2},
  [40] = {.index = 49, .length = 2},
  [42] = {.index = 51, .length = 3},
  [43] = {.index = 54, .length = 1},
  [44] = {.index = 55, .length = 2},
  [45] = {.index = 57, .length = 2},
  [46] = {.index = 59, .length = 3},
  [47] = {.index = 62, .length = 3},
  [48] = {.index = 59, .length = 3},
  [49] = {.index = 62, .length = 3},
  [50] = {.index = 65, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 3},
  [53] = {.index = 71, .length = 3},
  [54] = {.index = 74, .length = 3},
  [55] = {.index = 77, .length = 2},
  [56] = {.index = 77, .length = 2},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 79, .length = 2},
  [60] = {.index = 81, .length = 2},
  [61] = {.index = 83, .length = 3},
  [62] = {.index = 83, .length = 3},
  [64] = {.index = 86, .length = 2},
  [65] = {.index = 88, .length = 2},
  [66] = {.index = 90, .length = 1},
  [67] = {.index = 91, .length = 2},
  [68] = {.index = 93, .length = 3},
  [70] = {.index = 96, .length = 3},
  [71] = {.index = 99, .length = 2},
  [72] = {.index = 101, .length = 4},
  [73] = {.index = 105, .length = 4},
  [74] = {.index = 109, .length = 5},
  [75] = {.index = 114, .length = 6},
  [76] = {.index = 120, .length = 4},
  [77] = {.index = 124, .length = 4},
  [78] = {.index = 128, .length = 4},
  [79] = {.index = 132, .length = 2},
  [80] = {.index = 134, .length = 3},
  [81] = {.index = 137, .length = 1},
  [82] = {.index = 138, .length = 2},
  [83] = {.index = 140, .length = 2},
  [84] = {.index = 142, .length = 3},
  [85] = {.index = 145, .length = 2},
  [86] = {.index = 145, .length = 2},
  [87] = {.index = 147, .length = 4},
  [88] = {.index = 147, .length = 4},
  [89] = {.index = 151, .length = 3},
  [90] = {.index = 154, .length = 3},
  [91] = {.index = 157, .length = 3},
  [92] = {.index = 160, .length = 3},
  [93] = {.index = 163, .length = 2},
  [94] = {.index = 165, .length = 2},
  [95] = {.index = 165, .length = 2},
  [96] = {.index = 167, .length = 4},
  [97] = {.index = 171, .length = 5},
  [98] = {.index = 176, .length = 6},
  [99] = {.index = 182, .length = 3},
  [100] = {.index = 185, .length = 5},
  [101] = {.index = 99, .length = 2},
  [102] = {.index = 190, .length = 5},
  [103] = {.index = 195, .length = 4},
  [104] = {.index = 199, .length = 2},
  [105] = {.index = 201, .length = 1},
  [106] = {.index = 202, .length = 2},
  [107] = {.index = 204, .length = 2},
  [108] = {.index = 206, .length = 3},
  [109] = {.index = 209, .length = 3},
  [110] = {.index = 209, .length = 3},
  [111] = {.index = 212, .length = 4},
  [112] = {.index = 216, .length = 4},
  [113] = {.index = 220, .length = 4},
  [114] = {.index = 224, .length = 3},
  [115] = {.index = 227, .length = 4},
  [116] = {.index = 231, .length = 5},
  [117] = {.index = 236, .length = 3},
  [118] = {.index = 236, .length = 3},
  [119] = {.index = 239, .length = 4},
  [120] = {.index = 243, .length = 1},
  [121] = {.index = 244, .length = 2},
  [122] = {.index = 246, .length = 2},
  [123] = {.index = 248, .length = 1},
  [124] = {.index = 249, .length = 2},
  [125] = {.index = 251, .length = 2},
  [126] = {.index = 253, .length = 2},
  [127] = {.index = 255, .length = 3},
  [128] = {.index = 258, .length = 3},
  [130] = {.index = 261, .length = 3},
  [131] = {.index = 264, .length = 4},
  [132] = {.index = 264, .length = 4},
  [133] = {.index = 268, .length = 5},
  [134] = {.index = 273, .length = 2},
  [135] = {.index = 275, .length = 3},
  [136] = {.index = 278, .length = 3},
  [137] = {.index = 281, .length = 3},
  [138] = {.index = 284, .length = 3},
  [139] = {.index = 287, .length = 3},
  [140] = {.index = 290, .length = 5},
  [141] = {.index = 295, .length = 4},
  [142] = {.index = 299, .length = 4},
  [145] = {.index = 303, .length = 2},
  [146] = {.index = 305, .length = 3},
  [147] = {.index = 308, .length = 4},
  [148] = {.index = 312, .length = 4},
  [149] = {.index = 316, .length = 4},
  [150] = {.index = 320, .length = 4},
  [151] = {.index = 324, .length = 4},
  [152] = {.index = 328, .length = 5},
  [153] = {.index = 333, .length = 5},
  [154] = {.index = 338, .length = 2},
  [155] = {.index = 340, .length = 1},
  [156] = {.index = 341, .length = 3},
  [157] = {.index = 344, .length = 3},
  [158] = {.index = 347, .length = 3},
  [159] = {.index = 350, .length = 5},
  [160] = {.index = 355, .length = 5},
  [161] = {.index = 360, .length = 5},
  [162] = {.index = 365, .length = 3},
  [163] = {.index = 368, .length = 3},
  [164] = {.index = 371, .length = 4},
  [165] = {.index = 375, .length = 4},
  [166] = {.index = 379, .length = 6},
  [167] = {.index = 385, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_field, 2},
    {field_object, 0},
  [38] =
    {field_body, 2},
    {field_parameters, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
  [55] =
    {field_type, 1},
    {field_value, 3},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [71] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [74] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [77] =
    {field_name, 2},
    {field_scope, 0},
  [79] =
    {field_body, 3},
    {field_name, 2},
  [81] =
    {field_body, 3},
    {field_name, 1},
  [83] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [86] =
    {field_array, 0},
    {field_index, 2},
  [88] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [90] =
    {field_declarator, 1},
  [91] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [93] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [96] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [99] =
    {field_name, 0},
    {field_parameters, 1},
  [101] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [105] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [109] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [114] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [120] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [124] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [128] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [132] =
    {field_body, 1},
    {field_condition, 3},
  [134] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [137] =
    {field_init, 1},
  [138] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [140] =
    {field_body, 1},
    {field_name, 0},
  [142] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [145] =
    {field_field, 4},
    {field_object, 0},
  [147] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [151] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [154] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [157] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [160] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [163] =
    {field_body, 4},
    {field_name, 2},
  [165] =
    {field_body, 4},
    {field_name, 3},
  [167] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [171] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [176] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [182] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [185] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [190] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [195] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [199] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [201] =
    {field_body, 5},
  [202] =
    {field_body, 5},
    {field_init, 2},
  [204] =
    {field_key, 0},
    {field_value, 2},
  [206] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [209] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [212] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [216] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [220] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [224] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [227] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [231] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [236] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [239] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [243] =
    {field_body, 4},
  [244] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [246] =
    {field_body, 6},
    {field_update, 4},
  [248] =
    {field_update, 1},
  [249] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [251] =
    {field_body, 6},
    {field_condition, 3},
  [253] =
    {field_body, 6},
    {field_init, 2},
  [255] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [258] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [261] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [264] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [268] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [273] =
    {field_arguments, 1},
    {field_constructor, 0},
  [275] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [278] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [281] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [284] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [287] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [290] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [295] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [299] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [303] =
    {field_name, 1},
    {field_type, 0},
  [305] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [308] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [312] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [316] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [320] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [324] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [328] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [333] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [338] =
    {field_name, 2},
    {field_type, 1},
  [340] =
    {field_value, 1},
  [341] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [344] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [347] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [350] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [355] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [360] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [365] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [368] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [371] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [375] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [379] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [385] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static TSSymbol ts_alias_sequences[168][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [30] = {
    [2] = sym_identifier,
  },
  [34] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [37] = {
    [0] = sym_identifier,
  },
  [41] = {
    [2] = alias_sym_type_identifier,
  },
  [48] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [0] = sym_identifier,
  },
  [57] = {
    [2] = sym_identifier,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [69] = {
    [3] = alias_sym_type_identifier,
  },
  [85] = {
    [4] = sym_identifier,
  },
  [87] = {
    [3] = sym_identifier,
  },
  [94] = {
    [3] = sym_identifier,
  },
  [101] = {
    [0] = sym_identifier,
  },
  [109] = {
    [4] = sym_identifier,
  },
  [117] = {
    [0] = sym_identifier,
  },
  [129] = {
    [1] = sym_identifier,
    [2] = sym_identifier,
  },
  [131] = {
    [5] = sym_identifier,
  },
  [143] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [144] = {
    [3] = sym_identifier,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(135);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(114);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(105);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(141);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(146);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(144);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 16:
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(6);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 20:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(23);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 31:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 33:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 40:
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 41:
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 42:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(125);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(42)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 43:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(127);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(123);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == ']') ADVANCE(132);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '|') ADVANCE(110);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 44:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(126);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '\'') ADVANCE(16);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(122);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(142);
      if (lookahead == '{') ADVANCE(139);
      if (lookahead == '}') ADVANCE(140);
      if (lookahead == '~') ADVANCE(128);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(33);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      if (lookahead == '_') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == '_') ADVANCE(17);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(53);
      if (lookahead == '_') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(55);
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(19);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(130);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(137);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(28);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(147);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'h') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 'x') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'u') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'w') ADVANCE(53);
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 21:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(72);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(86);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 43:
      if (lookahead == 'w') ADVANCE(88);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(94);
      END_STATE();
    case 49:
      if (lookahead == 'q') ADVANCE(95);
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(100);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(106);
      if (lookahead == 'y') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(109);
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'b') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(132);
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(136);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 91:
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 92:
      if (lookahead == 'v') ADVANCE(142);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(143);
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 95:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 96:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(155);
      END_STATE();
    case 105:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 112:
      if (lookahead == 'h') ADVANCE(162);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 116:
      if (lookahead == 'k') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 123:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 127:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 138:
      if (lookahead == 'v') ADVANCE(182);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'c') ADVANCE(193);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(195);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 155:
      if (lookahead == 'w') ADVANCE(197);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 160:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(201);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 173:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 180:
      if (lookahead == 'f') ADVANCE(213);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(218);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 188:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(222);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(223);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 195:
      if (lookahead == 'h') ADVANCE(225);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(227);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(232);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 207:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 208:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 209:
      if (lookahead == 'y') ADVANCE(236);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(237);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 212:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(243);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(244);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(245);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(246);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(247);
      if (lookahead == 't') ADVANCE(248);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(249);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 237:
      if (lookahead == 'n') ADVANCE(252);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(254);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 243:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 244:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 245:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 247:
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 252:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 253:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 259:
      if (lookahead == 'i') ADVANCE(267);
      END_STATE();
    case 260:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 261:
      if (lookahead == 'v') ADVANCE(269);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 263:
      if (lookahead == 's') ADVANCE(270);
      END_STATE();
    case 264:
      if (lookahead == 'f') ADVANCE(271);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 267:
      if (lookahead == 'z') ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 274:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 44},
  [2] = {.lex_state = 44},
  [3] = {.lex_state = 44},
  [4] = {.lex_state = 44},
  [5] = {.lex_state = 44},
  [6] = {.lex_state = 44},
  [7] = {.lex_state = 44},
  [8] = {.lex_state = 44},
  [9] = {.lex_state = 44},
  [10] = {.lex_state = 44},
  [11] = {.lex_state = 44},
  [12] = {.lex_state = 44},
  [13] = {.lex_state = 44},
  [14] = {.lex_state = 44},
  [15] = {.lex_state = 44},
  [16] = {.lex_state = 44},
  [17] = {.lex_state = 44},
  [18] = {.lex_state = 44},
  [19] = {.lex_state = 44},
  [20] = {.lex_state = 44},
  [21] = {.lex_state = 44},
  [22] = {.lex_state = 44},
  [23] = {.lex_state = 44},
  [24] = {.lex_state = 44},
  [25] = {.lex_state = 44},
  [26] = {.lex_state = 44},
  [27] = {.lex_state = 44},
  [28] = {.lex_state = 44},
  [29] = {.lex_state = 44},
  [30] = {.lex_state = 44},
  [31] = {.lex_state = 44},
  [32] = {.lex_state = 44},
  [33] = {.lex_state = 44},
  [34] = {.lex_state = 44},
  [35] = {.lex_state = 44},
  [36] = {.lex_state = 44},
  [37] = {.lex_state = 44},
  [38] = {.lex_state = 44},
  [39] = {.lex_state = 44},
  [40] = {.lex_state = 44},
  [41] = {.lex_state = 44},
  [42] = {.lex_state = 44},
  [43] = {.lex_state = 44},
  [44] = {.lex_state = 44},
  [45] = {.lex_state = 44},
  [46] = {.lex_state = 42},
  [47] = {.lex_state = 42},
  [48] = {.lex_state = 43},
  [49] = {.lex_state = 43},
  [50] = {.lex_state = 42},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 44},
  [54] = {.lex_state = 44},
  [55] = {.lex_state = 44},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 44},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 44},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 44},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 44},
  [72] = {.lex_state = 44},
  [73] = {.lex_state = 44},
  [74] = {.lex_state = 44},
  [75] = {.lex_state = 44},
  [76] = {.lex_state = 44},
  [77] = {.lex_state = 44},
  [78] = {.lex_state = 44},
  [79] = {.lex_state = 44},
  [80] = {.lex_state = 44},
  [81] = {.lex_state = 44},
  [82] = {.lex_state = 44},
  [83] = {.lex_state = 44},
  [84] = {.lex_state = 44},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 44},
  [87] = {.lex_state = 44},
  [88] = {.lex_state = 44},
  [89] = {.lex_state = 44},
  [90] = {.lex_state = 44},
  [91] = {.lex_state = 44},
  [92] = {.lex_state = 44},
  [93] = {.lex_state = 44},
  [94] = {.lex_state = 44},
  [95] = {.lex_state = 44},
  [96] = {.lex_state = 44},
  [97] = {.lex_state = 44},
  [98] = {.lex_state = 44},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 44},
  [101] = {.lex_state = 44},
  [102] = {.lex_state = 44},
  [103] = {.lex_state = 44},
  [104] = {.lex_state = 44},
  [105] = {.lex_state = 44},
  [106] = {.lex_state = 44},
  [107] = {.lex_state = 44},
  [108] = {.lex_state = 44},
  [109] = {.lex_state = 44},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 44},
  [112] = {.lex_state = 44},
  [113] = {.lex_state = 44},
  [114] = {.lex_state = 44},
  [115] = {.lex_state = 44},
  [116] = {.lex_state = 44},
  [117] = {.lex_state = 44},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 44},
  [123] = {.lex_state = 44},
  [124] = {.lex_state = 44},
  [125] = {.lex_state = 44},
  [126] = {.lex_state = 44},
  [127] = {.lex_state = 44},
  [128] = {.lex_state = 44},
  [129] = {.lex_state = 44},
  [130] = {.lex_state = 44},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 44},
  [133] = {.lex_state = 44},
  [134] = {.lex_state = 44},
  [135] = {.lex_state = 44},
  [136] = {.lex_state = 44},
  [137] = {.lex_state = 44},
  [138] = {.lex_state = 44},
  [139] = {.lex_state = 44},
  [140] = {.lex_state = 44},
  [141] = {.lex_state = 44},
  [142] = {.lex_state = 44},
  [143] = {.lex_state = 44},
  [144] = {.lex_state = 44},
  [145] = {.lex_state = 44},
  [146] = {.lex_state = 44},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 44},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 44},
  [151] = {.lex_state = 44},
  [152] = {.lex_state = 44},
  [153] = {.lex_state = 44},
  [154] = {.lex_state = 44},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 44},
  [157] = {.lex_state = 44},
  [158] = {.lex_state = 44},
  [159] = {.lex_state = 44},
  [160] = {.lex_state = 44},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 44},
  [163] = {.lex_state = 44},
  [164] = {.lex_state = 44},
  [165] = {.lex_state = 44},
  [166] = {.lex_state = 44},
  [167] = {.lex_state = 44},
  [168] = {.lex_state = 44},
  [169] = {.lex_state = 44},
  [170] = {.lex_state = 44},
  [171] = {.lex_state = 44},
  [172] = {.lex_state = 44},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 44},
  [175] = {.lex_state = 44},
  [176] = {.lex_state = 44},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 44},
  [181] = {.lex_state = 44},
  [182] = {.lex_state = 44},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 44},
  [185] = {.lex_state = 44},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 44},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 44},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 44},
  [192] = {.lex_state = 44},
  [193] = {.lex_state = 44},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 44},
  [196] = {.lex_state = 44},
  [197] = {.lex_state = 44},
  [198] = {.lex_state = 44},
  [199] = {.lex_state = 44},
  [200] = {.lex_state = 44},
  [201] = {.lex_state = 44},
  [202] = {.lex_state = 44},
  [203] = {.lex_state = 44},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 44},
  [236] = {.lex_state = 44},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 44},
  [240] = {.lex_state = 44},
  [241] = {.lex_state = 44},
  [242] = {.lex_state = 44},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 2},
  [249] = {.lex_state = 2},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 2},
  [261] = {.lex_state = 2},
  [262] = {.lex_state = 2},
  [263] = {.lex_state = 2},
  [264] = {.lex_state = 2},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 2},
  [269] = {.lex_state = 3},
  [270] = {.lex_state = 3},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 3},
  [273] = {.lex_state = 7},
  [274] = {.lex_state = 7},
  [275] = {.lex_state = 3},
  [276] = {.lex_state = 3},
  [277] = {.lex_state = 3},
  [278] = {.lex_state = 3},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 2},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 7},
  [287] = {.lex_state = 7},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 3},
  [292] = {.lex_state = 3},
  [293] = {.lex_state = 3},
  [294] = {.lex_state = 3},
  [295] = {.lex_state = 3},
  [296] = {.lex_state = 3},
  [297] = {.lex_state = 3},
  [298] = {.lex_state = 3},
  [299] = {.lex_state = 3},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 3},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 3},
  [312] = {.lex_state = 3},
  [313] = {.lex_state = 3},
  [314] = {.lex_state = 3},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 3},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 3},
  [319] = {.lex_state = 3},
  [320] = {.lex_state = 3},
  [321] = {.lex_state = 3},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 3},
  [329] = {.lex_state = 3},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 1},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 3},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 3},
  [377] = {.lex_state = 3},
  [378] = {.lex_state = 3},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 3},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 3},
  [383] = {.lex_state = 3},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 3},
  [386] = {.lex_state = 3},
  [387] = {.lex_state = 3},
  [388] = {.lex_state = 3},
  [389] = {.lex_state = 3},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 3},
  [392] = {.lex_state = 3},
  [393] = {.lex_state = 3},
  [394] = {.lex_state = 3},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 3},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 3},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 3},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 3},
  [412] = {.lex_state = 3},
  [413] = {.lex_state = 3},
  [414] = {.lex_state = 3},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 3},
  [417] = {.lex_state = 3},
  [418] = {.lex_state = 3},
  [419] = {.lex_state = 3},
  [420] = {.lex_state = 3},
  [421] = {.lex_state = 3},
  [422] = {.lex_state = 5},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 3},
  [426] = {.lex_state = 3},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 3},
  [429] = {.lex_state = 3},
  [430] = {.lex_state = 3},
  [431] = {.lex_state = 3},
  [432] = {.lex_state = 3},
  [433] = {.lex_state = 3},
  [434] = {.lex_state = 3},
  [435] = {.lex_state = 3},
  [436] = {.lex_state = 3},
  [437] = {.lex_state = 3},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 1},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 3},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 3},
  [448] = {.lex_state = 3},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 1},
  [451] = {.lex_state = 3},
  [452] = {.lex_state = 1},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 3},
  [455] = {.lex_state = 3},
  [456] = {.lex_state = 3},
  [457] = {.lex_state = 3},
  [458] = {.lex_state = 1},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 1},
  [462] = {.lex_state = 1},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 1},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 1},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 5},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 5},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 5},
  [484] = {.lex_state = 5},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 5},
  [487] = {.lex_state = 5},
  [488] = {.lex_state = 5},
  [489] = {.lex_state = 5},
  [490] = {.lex_state = 5},
  [491] = {.lex_state = 5},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 5},
  [494] = {.lex_state = 5},
  [495] = {.lex_state = 5},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 5},
  [498] = {.lex_state = 2},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 2},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 2},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 2},
  [516] = {.lex_state = 2},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 2},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 2},
  [529] = {.lex_state = 2},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 1},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 2},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 2},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 2},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 2},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 2},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 2},
  [557] = {.lex_state = 2},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 2},
  [561] = {.lex_state = 2},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 1},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 1},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 1},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 44},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 2},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 2},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 44},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 2},
  [629] = {.lex_state = 2},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 2},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 2},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 2},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 2},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 44},
  [655] = {.lex_state = 44},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 44},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 2},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 44},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 44},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 2},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 2},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 2},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 2},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 44},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 44},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 2},
  [721] = {.lex_state = 2},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 44},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 2},
  [727] = {.lex_state = 2},
  [728] = {.lex_state = 44},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 44},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 2},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 44},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 2},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 2},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 44},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 44},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 2},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 2},
  [775] = {.lex_state = 2},
  [776] = {.lex_state = 2},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 44},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 2},
  [796] = {.lex_state = 2},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 44},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 2},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 44},
  [812] = {.lex_state = 2},
  [813] = {.lex_state = 2},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 2},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 2},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 2},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 2},
  [830] = {.lex_state = 44},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 44},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 2},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 2},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 2},
  [847] = {.lex_state = 2},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 44},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 44},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 2},
  [873] = {.lex_state = 44},
  [874] = {.lex_state = 2},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 2},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(908),
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(12),
    [sym_block] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_assert_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_synchronized_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_try_with_resources_statement] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_enhanced_for_statement] = STATE(12),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(12),
    [sym_module_declaration] = STATE(12),
    [sym_package_declaration] = STATE(12),
    [sym_import_declaration] = STATE(12),
    [sym_enum_declaration] = STATE(12),
    [sym_class_declaration] = STATE(12),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(12),
    [sym_interface_declaration] = STATE(12),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(12),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(405),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(405),
    [sym_array_creation_expression] = STATE(405),
    [sym_parenthesized_expression] = STATE(405),
    [sym_class_literal] = STATE(405),
    [sym_object_creation_expression] = STATE(405),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(405),
    [sym_method_reference] = STATE(405),
    [sym_type_arguments] = STATE(825),
    [sym__statement] = STATE(9),
    [sym_block] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_assert_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_synchronized_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_try_with_resources_statement] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_enhanced_for_statement] = STATE(9),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(9),
    [sym_module_declaration] = STATE(9),
    [sym_package_declaration] = STATE(9),
    [sym_import_declaration] = STATE(9),
    [sym_enum_declaration] = STATE(9),
    [sym_class_declaration] = STATE(9),
    [sym_modifiers] = STATE(480),
    [sym_explicit_constructor_invocation] = STATE(10),
    [sym_annotation_type_declaration] = STATE(9),
    [sym_interface_declaration] = STATE(9),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(9),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(79),
    [sym_hex_integer_literal] = ACTIONS(79),
    [sym_octal_integer_literal] = ACTIONS(81),
    [sym_binary_integer_literal] = ACTIONS(81),
    [sym_decimal_floating_point_literal] = ACTIONS(81),
    [sym_hex_floating_point_literal] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_character_literal] = ACTIONS(81),
    [sym_string_literal] = ACTIONS(81),
    [sym_null_literal] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(85),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(3),
    [sym_block] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_assert_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_switch_label] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_synchronized_statement] = STATE(3),
    [sym_throw_statement] = STATE(3),
    [sym_try_statement] = STATE(3),
    [sym_try_with_resources_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_enhanced_for_statement] = STATE(3),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(3),
    [sym_module_declaration] = STATE(3),
    [sym_package_declaration] = STATE(3),
    [sym_import_declaration] = STATE(3),
    [sym_enum_declaration] = STATE(3),
    [sym_class_declaration] = STATE(3),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(3),
    [sym_interface_declaration] = STATE(3),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(3),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_switch_block_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(93),
    [sym_decimal_integer_literal] = ACTIONS(96),
    [sym_hex_integer_literal] = ACTIONS(96),
    [sym_octal_integer_literal] = ACTIONS(99),
    [sym_binary_integer_literal] = ACTIONS(99),
    [sym_decimal_floating_point_literal] = ACTIONS(99),
    [sym_hex_floating_point_literal] = ACTIONS(96),
    [sym_true] = ACTIONS(96),
    [sym_false] = ACTIONS(96),
    [sym_character_literal] = ACTIONS(99),
    [sym_string_literal] = ACTIONS(99),
    [sym_null_literal] = ACTIONS(96),
    [anon_sym_LPAREN] = ACTIONS(102),
    [anon_sym_PLUS] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(105),
    [anon_sym_BANG] = ACTIONS(108),
    [anon_sym_TILDE] = ACTIONS(108),
    [anon_sym_PLUS_PLUS] = ACTIONS(111),
    [anon_sym_DASH_DASH] = ACTIONS(111),
    [anon_sym_new] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(117),
    [anon_sym_SEMI] = ACTIONS(120),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_RBRACE] = ACTIONS(126),
    [anon_sym_assert] = ACTIONS(128),
    [anon_sym_switch] = ACTIONS(131),
    [anon_sym_case] = ACTIONS(134),
    [anon_sym_default] = ACTIONS(137),
    [anon_sym_do] = ACTIONS(140),
    [anon_sym_while] = ACTIONS(143),
    [anon_sym_break] = ACTIONS(146),
    [anon_sym_continue] = ACTIONS(149),
    [anon_sym_return] = ACTIONS(152),
    [anon_sym_synchronized] = ACTIONS(155),
    [anon_sym_throw] = ACTIONS(158),
    [anon_sym_try] = ACTIONS(161),
    [anon_sym_if] = ACTIONS(164),
    [anon_sym_for] = ACTIONS(167),
    [anon_sym_AT] = ACTIONS(170),
    [anon_sym_open] = ACTIONS(173),
    [anon_sym_module] = ACTIONS(176),
    [anon_sym_static] = ACTIONS(179),
    [anon_sym_package] = ACTIONS(182),
    [anon_sym_import] = ACTIONS(185),
    [anon_sym_enum] = ACTIONS(188),
    [anon_sym_public] = ACTIONS(179),
    [anon_sym_protected] = ACTIONS(179),
    [anon_sym_private] = ACTIONS(179),
    [anon_sym_abstract] = ACTIONS(179),
    [anon_sym_final] = ACTIONS(179),
    [anon_sym_strictfp] = ACTIONS(179),
    [anon_sym_native] = ACTIONS(179),
    [anon_sym_transient] = ACTIONS(179),
    [anon_sym_volatile] = ACTIONS(179),
    [anon_sym_ATinterface] = ACTIONS(191),
    [anon_sym_interface] = ACTIONS(194),
    [anon_sym_byte] = ACTIONS(197),
    [anon_sym_short] = ACTIONS(197),
    [anon_sym_int] = ACTIONS(197),
    [anon_sym_long] = ACTIONS(197),
    [anon_sym_char] = ACTIONS(197),
    [anon_sym_float] = ACTIONS(200),
    [anon_sym_double] = ACTIONS(200),
    [sym_boolean_type] = ACTIONS(203),
    [sym_void_type] = ACTIONS(203),
    [sym_this] = ACTIONS(96),
    [sym_super] = ACTIONS(206),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(5),
    [sym_block] = STATE(5),
    [sym_expression_statement] = STATE(5),
    [sym_labeled_statement] = STATE(5),
    [sym_assert_statement] = STATE(5),
    [sym_switch_statement] = STATE(5),
    [sym_switch_label] = STATE(5),
    [sym_do_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_synchronized_statement] = STATE(5),
    [sym_throw_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_try_with_resources_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_enhanced_for_statement] = STATE(5),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(5),
    [sym_module_declaration] = STATE(5),
    [sym_package_declaration] = STATE(5),
    [sym_import_declaration] = STATE(5),
    [sym_enum_declaration] = STATE(5),
    [sym_class_declaration] = STATE(5),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(5),
    [sym_interface_declaration] = STATE(5),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(5),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_switch_block_repeat1] = STATE(5),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(211),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(213),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(3),
    [sym_block] = STATE(3),
    [sym_expression_statement] = STATE(3),
    [sym_labeled_statement] = STATE(3),
    [sym_assert_statement] = STATE(3),
    [sym_switch_statement] = STATE(3),
    [sym_switch_label] = STATE(3),
    [sym_do_statement] = STATE(3),
    [sym_break_statement] = STATE(3),
    [sym_continue_statement] = STATE(3),
    [sym_return_statement] = STATE(3),
    [sym_synchronized_statement] = STATE(3),
    [sym_throw_statement] = STATE(3),
    [sym_try_statement] = STATE(3),
    [sym_try_with_resources_statement] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_enhanced_for_statement] = STATE(3),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(3),
    [sym_module_declaration] = STATE(3),
    [sym_package_declaration] = STATE(3),
    [sym_import_declaration] = STATE(3),
    [sym_enum_declaration] = STATE(3),
    [sym_class_declaration] = STATE(3),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(3),
    [sym_interface_declaration] = STATE(3),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(3),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_switch_block_repeat1] = STATE(3),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(217),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(213),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [ts_builtin_sym_end] = ACTIONS(221),
    [sym_identifier] = ACTIONS(223),
    [sym_decimal_integer_literal] = ACTIONS(226),
    [sym_hex_integer_literal] = ACTIONS(226),
    [sym_octal_integer_literal] = ACTIONS(229),
    [sym_binary_integer_literal] = ACTIONS(229),
    [sym_decimal_floating_point_literal] = ACTIONS(229),
    [sym_hex_floating_point_literal] = ACTIONS(226),
    [sym_true] = ACTIONS(226),
    [sym_false] = ACTIONS(226),
    [sym_character_literal] = ACTIONS(229),
    [sym_string_literal] = ACTIONS(229),
    [sym_null_literal] = ACTIONS(226),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(235),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_PLUS_PLUS] = ACTIONS(241),
    [anon_sym_DASH_DASH] = ACTIONS(241),
    [anon_sym_new] = ACTIONS(244),
    [anon_sym_class] = ACTIONS(247),
    [anon_sym_SEMI] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_assert] = ACTIONS(256),
    [anon_sym_switch] = ACTIONS(259),
    [anon_sym_default] = ACTIONS(262),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(268),
    [anon_sym_break] = ACTIONS(271),
    [anon_sym_continue] = ACTIONS(274),
    [anon_sym_return] = ACTIONS(277),
    [anon_sym_synchronized] = ACTIONS(280),
    [anon_sym_throw] = ACTIONS(283),
    [anon_sym_try] = ACTIONS(286),
    [anon_sym_if] = ACTIONS(289),
    [anon_sym_for] = ACTIONS(292),
    [anon_sym_AT] = ACTIONS(295),
    [anon_sym_open] = ACTIONS(298),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_static] = ACTIONS(262),
    [anon_sym_package] = ACTIONS(304),
    [anon_sym_import] = ACTIONS(307),
    [anon_sym_enum] = ACTIONS(310),
    [anon_sym_public] = ACTIONS(262),
    [anon_sym_protected] = ACTIONS(262),
    [anon_sym_private] = ACTIONS(262),
    [anon_sym_abstract] = ACTIONS(262),
    [anon_sym_final] = ACTIONS(262),
    [anon_sym_strictfp] = ACTIONS(262),
    [anon_sym_native] = ACTIONS(262),
    [anon_sym_transient] = ACTIONS(262),
    [anon_sym_volatile] = ACTIONS(262),
    [anon_sym_ATinterface] = ACTIONS(313),
    [anon_sym_interface] = ACTIONS(316),
    [anon_sym_byte] = ACTIONS(319),
    [anon_sym_short] = ACTIONS(319),
    [anon_sym_int] = ACTIONS(319),
    [anon_sym_long] = ACTIONS(319),
    [anon_sym_char] = ACTIONS(319),
    [anon_sym_float] = ACTIONS(322),
    [anon_sym_double] = ACTIONS(322),
    [sym_boolean_type] = ACTIONS(325),
    [sym_void_type] = ACTIONS(325),
    [sym_this] = ACTIONS(226),
    [sym_super] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(333),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(7),
    [sym_block] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_assert_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_synchronized_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_try_with_resources_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_enhanced_for_statement] = STATE(7),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(7),
    [sym_module_declaration] = STATE(7),
    [sym_package_declaration] = STATE(7),
    [sym_import_declaration] = STATE(7),
    [sym_enum_declaration] = STATE(7),
    [sym_class_declaration] = STATE(7),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(7),
    [sym_interface_declaration] = STATE(7),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(7),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(8),
    [sym_block] = STATE(8),
    [sym_expression_statement] = STATE(8),
    [sym_labeled_statement] = STATE(8),
    [sym_assert_statement] = STATE(8),
    [sym_switch_statement] = STATE(8),
    [sym_do_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_synchronized_statement] = STATE(8),
    [sym_throw_statement] = STATE(8),
    [sym_try_statement] = STATE(8),
    [sym_try_with_resources_statement] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_enhanced_for_statement] = STATE(8),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(8),
    [sym_module_declaration] = STATE(8),
    [sym_package_declaration] = STATE(8),
    [sym_import_declaration] = STATE(8),
    [sym_enum_declaration] = STATE(8),
    [sym_class_declaration] = STATE(8),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(8),
    [sym_interface_declaration] = STATE(8),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(8),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [ts_builtin_sym_end] = ACTIONS(345),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(6),
    [sym_block] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_assert_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_synchronized_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_try_with_resources_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_enhanced_for_statement] = STATE(6),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(6),
    [sym_module_declaration] = STATE(6),
    [sym_package_declaration] = STATE(6),
    [sym_import_declaration] = STATE(6),
    [sym_enum_declaration] = STATE(6),
    [sym_class_declaration] = STATE(6),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(6),
    [sym_interface_declaration] = STATE(6),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(6),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(13),
    [sym_block] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_assert_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_synchronized_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_try_with_resources_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_enhanced_for_statement] = STATE(13),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(13),
    [sym_module_declaration] = STATE(13),
    [sym_package_declaration] = STATE(13),
    [sym_import_declaration] = STATE(13),
    [sym_enum_declaration] = STATE(13),
    [sym_class_declaration] = STATE(13),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(13),
    [sym_interface_declaration] = STATE(13),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(13),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(139),
    [sym_block] = STATE(139),
    [sym_expression_statement] = STATE(139),
    [sym_labeled_statement] = STATE(139),
    [sym_assert_statement] = STATE(139),
    [sym_switch_statement] = STATE(139),
    [sym_do_statement] = STATE(139),
    [sym_break_statement] = STATE(139),
    [sym_continue_statement] = STATE(139),
    [sym_return_statement] = STATE(139),
    [sym_synchronized_statement] = STATE(139),
    [sym_throw_statement] = STATE(139),
    [sym_try_statement] = STATE(139),
    [sym_try_with_resources_statement] = STATE(139),
    [sym_if_statement] = STATE(139),
    [sym_while_statement] = STATE(139),
    [sym_for_statement] = STATE(139),
    [sym_enhanced_for_statement] = STATE(139),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(139),
    [sym_module_declaration] = STATE(139),
    [sym_package_declaration] = STATE(139),
    [sym_import_declaration] = STATE(139),
    [sym_enum_declaration] = STATE(139),
    [sym_class_declaration] = STATE(139),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(139),
    [sym_interface_declaration] = STATE(139),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(139),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(353),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(129),
    [sym_block] = STATE(129),
    [sym_expression_statement] = STATE(129),
    [sym_labeled_statement] = STATE(129),
    [sym_assert_statement] = STATE(129),
    [sym_switch_statement] = STATE(129),
    [sym_do_statement] = STATE(129),
    [sym_break_statement] = STATE(129),
    [sym_continue_statement] = STATE(129),
    [sym_return_statement] = STATE(129),
    [sym_synchronized_statement] = STATE(129),
    [sym_throw_statement] = STATE(129),
    [sym_try_statement] = STATE(129),
    [sym_try_with_resources_statement] = STATE(129),
    [sym_if_statement] = STATE(129),
    [sym_while_statement] = STATE(129),
    [sym_for_statement] = STATE(129),
    [sym_enhanced_for_statement] = STATE(129),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(129),
    [sym_module_declaration] = STATE(129),
    [sym_package_declaration] = STATE(129),
    [sym_import_declaration] = STATE(129),
    [sym_enum_declaration] = STATE(129),
    [sym_class_declaration] = STATE(129),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(129),
    [sym_interface_declaration] = STATE(129),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(129),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(144),
    [sym_block] = STATE(144),
    [sym_expression_statement] = STATE(144),
    [sym_labeled_statement] = STATE(144),
    [sym_assert_statement] = STATE(144),
    [sym_switch_statement] = STATE(144),
    [sym_do_statement] = STATE(144),
    [sym_break_statement] = STATE(144),
    [sym_continue_statement] = STATE(144),
    [sym_return_statement] = STATE(144),
    [sym_synchronized_statement] = STATE(144),
    [sym_throw_statement] = STATE(144),
    [sym_try_statement] = STATE(144),
    [sym_try_with_resources_statement] = STATE(144),
    [sym_if_statement] = STATE(144),
    [sym_while_statement] = STATE(144),
    [sym_for_statement] = STATE(144),
    [sym_enhanced_for_statement] = STATE(144),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(144),
    [sym_module_declaration] = STATE(144),
    [sym_package_declaration] = STATE(144),
    [sym_import_declaration] = STATE(144),
    [sym_enum_declaration] = STATE(144),
    [sym_class_declaration] = STATE(144),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(144),
    [sym_interface_declaration] = STATE(144),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(144),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(357),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(877),
    [sym_block] = STATE(877),
    [sym_expression_statement] = STATE(877),
    [sym_labeled_statement] = STATE(877),
    [sym_assert_statement] = STATE(877),
    [sym_switch_statement] = STATE(877),
    [sym_do_statement] = STATE(877),
    [sym_break_statement] = STATE(877),
    [sym_continue_statement] = STATE(877),
    [sym_return_statement] = STATE(877),
    [sym_synchronized_statement] = STATE(877),
    [sym_throw_statement] = STATE(877),
    [sym_try_statement] = STATE(877),
    [sym_try_with_resources_statement] = STATE(877),
    [sym_if_statement] = STATE(877),
    [sym_while_statement] = STATE(877),
    [sym_for_statement] = STATE(877),
    [sym_enhanced_for_statement] = STATE(877),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(877),
    [sym_module_declaration] = STATE(877),
    [sym_package_declaration] = STATE(877),
    [sym_import_declaration] = STATE(877),
    [sym_enum_declaration] = STATE(877),
    [sym_class_declaration] = STATE(877),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(877),
    [sym_interface_declaration] = STATE(877),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(877),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(153),
    [sym_block] = STATE(153),
    [sym_expression_statement] = STATE(153),
    [sym_labeled_statement] = STATE(153),
    [sym_assert_statement] = STATE(153),
    [sym_switch_statement] = STATE(153),
    [sym_do_statement] = STATE(153),
    [sym_break_statement] = STATE(153),
    [sym_continue_statement] = STATE(153),
    [sym_return_statement] = STATE(153),
    [sym_synchronized_statement] = STATE(153),
    [sym_throw_statement] = STATE(153),
    [sym_try_statement] = STATE(153),
    [sym_try_with_resources_statement] = STATE(153),
    [sym_if_statement] = STATE(153),
    [sym_while_statement] = STATE(153),
    [sym_for_statement] = STATE(153),
    [sym_enhanced_for_statement] = STATE(153),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(153),
    [sym_module_declaration] = STATE(153),
    [sym_package_declaration] = STATE(153),
    [sym_import_declaration] = STATE(153),
    [sym_enum_declaration] = STATE(153),
    [sym_class_declaration] = STATE(153),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(153),
    [sym_interface_declaration] = STATE(153),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(153),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(146),
    [sym_block] = STATE(146),
    [sym_expression_statement] = STATE(146),
    [sym_labeled_statement] = STATE(146),
    [sym_assert_statement] = STATE(146),
    [sym_switch_statement] = STATE(146),
    [sym_do_statement] = STATE(146),
    [sym_break_statement] = STATE(146),
    [sym_continue_statement] = STATE(146),
    [sym_return_statement] = STATE(146),
    [sym_synchronized_statement] = STATE(146),
    [sym_throw_statement] = STATE(146),
    [sym_try_statement] = STATE(146),
    [sym_try_with_resources_statement] = STATE(146),
    [sym_if_statement] = STATE(146),
    [sym_while_statement] = STATE(146),
    [sym_for_statement] = STATE(146),
    [sym_enhanced_for_statement] = STATE(146),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(146),
    [sym_module_declaration] = STATE(146),
    [sym_package_declaration] = STATE(146),
    [sym_import_declaration] = STATE(146),
    [sym_enum_declaration] = STATE(146),
    [sym_class_declaration] = STATE(146),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(146),
    [sym_interface_declaration] = STATE(146),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(146),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(114),
    [sym_block] = STATE(114),
    [sym_expression_statement] = STATE(114),
    [sym_labeled_statement] = STATE(114),
    [sym_assert_statement] = STATE(114),
    [sym_switch_statement] = STATE(114),
    [sym_do_statement] = STATE(114),
    [sym_break_statement] = STATE(114),
    [sym_continue_statement] = STATE(114),
    [sym_return_statement] = STATE(114),
    [sym_synchronized_statement] = STATE(114),
    [sym_throw_statement] = STATE(114),
    [sym_try_statement] = STATE(114),
    [sym_try_with_resources_statement] = STATE(114),
    [sym_if_statement] = STATE(114),
    [sym_while_statement] = STATE(114),
    [sym_for_statement] = STATE(114),
    [sym_enhanced_for_statement] = STATE(114),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(114),
    [sym_module_declaration] = STATE(114),
    [sym_package_declaration] = STATE(114),
    [sym_import_declaration] = STATE(114),
    [sym_enum_declaration] = STATE(114),
    [sym_class_declaration] = STATE(114),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(114),
    [sym_interface_declaration] = STATE(114),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(114),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(365),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(138),
    [sym_block] = STATE(138),
    [sym_expression_statement] = STATE(138),
    [sym_labeled_statement] = STATE(138),
    [sym_assert_statement] = STATE(138),
    [sym_switch_statement] = STATE(138),
    [sym_do_statement] = STATE(138),
    [sym_break_statement] = STATE(138),
    [sym_continue_statement] = STATE(138),
    [sym_return_statement] = STATE(138),
    [sym_synchronized_statement] = STATE(138),
    [sym_throw_statement] = STATE(138),
    [sym_try_statement] = STATE(138),
    [sym_try_with_resources_statement] = STATE(138),
    [sym_if_statement] = STATE(138),
    [sym_while_statement] = STATE(138),
    [sym_for_statement] = STATE(138),
    [sym_enhanced_for_statement] = STATE(138),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(138),
    [sym_module_declaration] = STATE(138),
    [sym_package_declaration] = STATE(138),
    [sym_import_declaration] = STATE(138),
    [sym_enum_declaration] = STATE(138),
    [sym_class_declaration] = STATE(138),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(138),
    [sym_interface_declaration] = STATE(138),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(138),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(367),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(136),
    [sym_block] = STATE(136),
    [sym_expression_statement] = STATE(136),
    [sym_labeled_statement] = STATE(136),
    [sym_assert_statement] = STATE(136),
    [sym_switch_statement] = STATE(136),
    [sym_do_statement] = STATE(136),
    [sym_break_statement] = STATE(136),
    [sym_continue_statement] = STATE(136),
    [sym_return_statement] = STATE(136),
    [sym_synchronized_statement] = STATE(136),
    [sym_throw_statement] = STATE(136),
    [sym_try_statement] = STATE(136),
    [sym_try_with_resources_statement] = STATE(136),
    [sym_if_statement] = STATE(136),
    [sym_while_statement] = STATE(136),
    [sym_for_statement] = STATE(136),
    [sym_enhanced_for_statement] = STATE(136),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(136),
    [sym_module_declaration] = STATE(136),
    [sym_package_declaration] = STATE(136),
    [sym_import_declaration] = STATE(136),
    [sym_enum_declaration] = STATE(136),
    [sym_class_declaration] = STATE(136),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(136),
    [sym_interface_declaration] = STATE(136),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(136),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(369),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(117),
    [sym_block] = STATE(117),
    [sym_expression_statement] = STATE(117),
    [sym_labeled_statement] = STATE(117),
    [sym_assert_statement] = STATE(117),
    [sym_switch_statement] = STATE(117),
    [sym_do_statement] = STATE(117),
    [sym_break_statement] = STATE(117),
    [sym_continue_statement] = STATE(117),
    [sym_return_statement] = STATE(117),
    [sym_synchronized_statement] = STATE(117),
    [sym_throw_statement] = STATE(117),
    [sym_try_statement] = STATE(117),
    [sym_try_with_resources_statement] = STATE(117),
    [sym_if_statement] = STATE(117),
    [sym_while_statement] = STATE(117),
    [sym_for_statement] = STATE(117),
    [sym_enhanced_for_statement] = STATE(117),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(117),
    [sym_module_declaration] = STATE(117),
    [sym_package_declaration] = STATE(117),
    [sym_import_declaration] = STATE(117),
    [sym_enum_declaration] = STATE(117),
    [sym_class_declaration] = STATE(117),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(117),
    [sym_interface_declaration] = STATE(117),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(117),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(371),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(167),
    [sym_block] = STATE(167),
    [sym_expression_statement] = STATE(167),
    [sym_labeled_statement] = STATE(167),
    [sym_assert_statement] = STATE(167),
    [sym_switch_statement] = STATE(167),
    [sym_do_statement] = STATE(167),
    [sym_break_statement] = STATE(167),
    [sym_continue_statement] = STATE(167),
    [sym_return_statement] = STATE(167),
    [sym_synchronized_statement] = STATE(167),
    [sym_throw_statement] = STATE(167),
    [sym_try_statement] = STATE(167),
    [sym_try_with_resources_statement] = STATE(167),
    [sym_if_statement] = STATE(167),
    [sym_while_statement] = STATE(167),
    [sym_for_statement] = STATE(167),
    [sym_enhanced_for_statement] = STATE(167),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(167),
    [sym_module_declaration] = STATE(167),
    [sym_package_declaration] = STATE(167),
    [sym_import_declaration] = STATE(167),
    [sym_enum_declaration] = STATE(167),
    [sym_class_declaration] = STATE(167),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(167),
    [sym_interface_declaration] = STATE(167),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(167),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(373),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(134),
    [sym_block] = STATE(134),
    [sym_expression_statement] = STATE(134),
    [sym_labeled_statement] = STATE(134),
    [sym_assert_statement] = STATE(134),
    [sym_switch_statement] = STATE(134),
    [sym_do_statement] = STATE(134),
    [sym_break_statement] = STATE(134),
    [sym_continue_statement] = STATE(134),
    [sym_return_statement] = STATE(134),
    [sym_synchronized_statement] = STATE(134),
    [sym_throw_statement] = STATE(134),
    [sym_try_statement] = STATE(134),
    [sym_try_with_resources_statement] = STATE(134),
    [sym_if_statement] = STATE(134),
    [sym_while_statement] = STATE(134),
    [sym_for_statement] = STATE(134),
    [sym_enhanced_for_statement] = STATE(134),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(134),
    [sym_module_declaration] = STATE(134),
    [sym_package_declaration] = STATE(134),
    [sym_import_declaration] = STATE(134),
    [sym_enum_declaration] = STATE(134),
    [sym_class_declaration] = STATE(134),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(134),
    [sym_interface_declaration] = STATE(134),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(134),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(170),
    [sym_block] = STATE(170),
    [sym_expression_statement] = STATE(170),
    [sym_labeled_statement] = STATE(170),
    [sym_assert_statement] = STATE(170),
    [sym_switch_statement] = STATE(170),
    [sym_do_statement] = STATE(170),
    [sym_break_statement] = STATE(170),
    [sym_continue_statement] = STATE(170),
    [sym_return_statement] = STATE(170),
    [sym_synchronized_statement] = STATE(170),
    [sym_throw_statement] = STATE(170),
    [sym_try_statement] = STATE(170),
    [sym_try_with_resources_statement] = STATE(170),
    [sym_if_statement] = STATE(170),
    [sym_while_statement] = STATE(170),
    [sym_for_statement] = STATE(170),
    [sym_enhanced_for_statement] = STATE(170),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(170),
    [sym_module_declaration] = STATE(170),
    [sym_package_declaration] = STATE(170),
    [sym_import_declaration] = STATE(170),
    [sym_enum_declaration] = STATE(170),
    [sym_class_declaration] = STATE(170),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(170),
    [sym_interface_declaration] = STATE(170),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(170),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(132),
    [sym_block] = STATE(132),
    [sym_expression_statement] = STATE(132),
    [sym_labeled_statement] = STATE(132),
    [sym_assert_statement] = STATE(132),
    [sym_switch_statement] = STATE(132),
    [sym_do_statement] = STATE(132),
    [sym_break_statement] = STATE(132),
    [sym_continue_statement] = STATE(132),
    [sym_return_statement] = STATE(132),
    [sym_synchronized_statement] = STATE(132),
    [sym_throw_statement] = STATE(132),
    [sym_try_statement] = STATE(132),
    [sym_try_with_resources_statement] = STATE(132),
    [sym_if_statement] = STATE(132),
    [sym_while_statement] = STATE(132),
    [sym_for_statement] = STATE(132),
    [sym_enhanced_for_statement] = STATE(132),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(132),
    [sym_module_declaration] = STATE(132),
    [sym_package_declaration] = STATE(132),
    [sym_import_declaration] = STATE(132),
    [sym_enum_declaration] = STATE(132),
    [sym_class_declaration] = STATE(132),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(132),
    [sym_interface_declaration] = STATE(132),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(132),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(172),
    [sym_block] = STATE(172),
    [sym_expression_statement] = STATE(172),
    [sym_labeled_statement] = STATE(172),
    [sym_assert_statement] = STATE(172),
    [sym_switch_statement] = STATE(172),
    [sym_do_statement] = STATE(172),
    [sym_break_statement] = STATE(172),
    [sym_continue_statement] = STATE(172),
    [sym_return_statement] = STATE(172),
    [sym_synchronized_statement] = STATE(172),
    [sym_throw_statement] = STATE(172),
    [sym_try_statement] = STATE(172),
    [sym_try_with_resources_statement] = STATE(172),
    [sym_if_statement] = STATE(172),
    [sym_while_statement] = STATE(172),
    [sym_for_statement] = STATE(172),
    [sym_enhanced_for_statement] = STATE(172),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(172),
    [sym_module_declaration] = STATE(172),
    [sym_package_declaration] = STATE(172),
    [sym_import_declaration] = STATE(172),
    [sym_enum_declaration] = STATE(172),
    [sym_class_declaration] = STATE(172),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(172),
    [sym_interface_declaration] = STATE(172),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(172),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(166),
    [sym_block] = STATE(166),
    [sym_expression_statement] = STATE(166),
    [sym_labeled_statement] = STATE(166),
    [sym_assert_statement] = STATE(166),
    [sym_switch_statement] = STATE(166),
    [sym_do_statement] = STATE(166),
    [sym_break_statement] = STATE(166),
    [sym_continue_statement] = STATE(166),
    [sym_return_statement] = STATE(166),
    [sym_synchronized_statement] = STATE(166),
    [sym_throw_statement] = STATE(166),
    [sym_try_statement] = STATE(166),
    [sym_try_with_resources_statement] = STATE(166),
    [sym_if_statement] = STATE(166),
    [sym_while_statement] = STATE(166),
    [sym_for_statement] = STATE(166),
    [sym_enhanced_for_statement] = STATE(166),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(166),
    [sym_module_declaration] = STATE(166),
    [sym_package_declaration] = STATE(166),
    [sym_import_declaration] = STATE(166),
    [sym_enum_declaration] = STATE(166),
    [sym_class_declaration] = STATE(166),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(166),
    [sym_interface_declaration] = STATE(166),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(166),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(383),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(169),
    [sym_block] = STATE(169),
    [sym_expression_statement] = STATE(169),
    [sym_labeled_statement] = STATE(169),
    [sym_assert_statement] = STATE(169),
    [sym_switch_statement] = STATE(169),
    [sym_do_statement] = STATE(169),
    [sym_break_statement] = STATE(169),
    [sym_continue_statement] = STATE(169),
    [sym_return_statement] = STATE(169),
    [sym_synchronized_statement] = STATE(169),
    [sym_throw_statement] = STATE(169),
    [sym_try_statement] = STATE(169),
    [sym_try_with_resources_statement] = STATE(169),
    [sym_if_statement] = STATE(169),
    [sym_while_statement] = STATE(169),
    [sym_for_statement] = STATE(169),
    [sym_enhanced_for_statement] = STATE(169),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(169),
    [sym_module_declaration] = STATE(169),
    [sym_package_declaration] = STATE(169),
    [sym_import_declaration] = STATE(169),
    [sym_enum_declaration] = STATE(169),
    [sym_class_declaration] = STATE(169),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(169),
    [sym_interface_declaration] = STATE(169),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(169),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(159),
    [sym_block] = STATE(159),
    [sym_expression_statement] = STATE(159),
    [sym_labeled_statement] = STATE(159),
    [sym_assert_statement] = STATE(159),
    [sym_switch_statement] = STATE(159),
    [sym_do_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_return_statement] = STATE(159),
    [sym_synchronized_statement] = STATE(159),
    [sym_throw_statement] = STATE(159),
    [sym_try_statement] = STATE(159),
    [sym_try_with_resources_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_enhanced_for_statement] = STATE(159),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(159),
    [sym_module_declaration] = STATE(159),
    [sym_package_declaration] = STATE(159),
    [sym_import_declaration] = STATE(159),
    [sym_enum_declaration] = STATE(159),
    [sym_class_declaration] = STATE(159),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(159),
    [sym_interface_declaration] = STATE(159),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(159),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(387),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(128),
    [sym_block] = STATE(128),
    [sym_expression_statement] = STATE(128),
    [sym_labeled_statement] = STATE(128),
    [sym_assert_statement] = STATE(128),
    [sym_switch_statement] = STATE(128),
    [sym_do_statement] = STATE(128),
    [sym_break_statement] = STATE(128),
    [sym_continue_statement] = STATE(128),
    [sym_return_statement] = STATE(128),
    [sym_synchronized_statement] = STATE(128),
    [sym_throw_statement] = STATE(128),
    [sym_try_statement] = STATE(128),
    [sym_try_with_resources_statement] = STATE(128),
    [sym_if_statement] = STATE(128),
    [sym_while_statement] = STATE(128),
    [sym_for_statement] = STATE(128),
    [sym_enhanced_for_statement] = STATE(128),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(128),
    [sym_module_declaration] = STATE(128),
    [sym_package_declaration] = STATE(128),
    [sym_import_declaration] = STATE(128),
    [sym_enum_declaration] = STATE(128),
    [sym_class_declaration] = STATE(128),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(128),
    [sym_interface_declaration] = STATE(128),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(128),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(171),
    [sym_block] = STATE(171),
    [sym_expression_statement] = STATE(171),
    [sym_labeled_statement] = STATE(171),
    [sym_assert_statement] = STATE(171),
    [sym_switch_statement] = STATE(171),
    [sym_do_statement] = STATE(171),
    [sym_break_statement] = STATE(171),
    [sym_continue_statement] = STATE(171),
    [sym_return_statement] = STATE(171),
    [sym_synchronized_statement] = STATE(171),
    [sym_throw_statement] = STATE(171),
    [sym_try_statement] = STATE(171),
    [sym_try_with_resources_statement] = STATE(171),
    [sym_if_statement] = STATE(171),
    [sym_while_statement] = STATE(171),
    [sym_for_statement] = STATE(171),
    [sym_enhanced_for_statement] = STATE(171),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(171),
    [sym_module_declaration] = STATE(171),
    [sym_package_declaration] = STATE(171),
    [sym_import_declaration] = STATE(171),
    [sym_enum_declaration] = STATE(171),
    [sym_class_declaration] = STATE(171),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(171),
    [sym_interface_declaration] = STATE(171),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(171),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(157),
    [sym_block] = STATE(157),
    [sym_expression_statement] = STATE(157),
    [sym_labeled_statement] = STATE(157),
    [sym_assert_statement] = STATE(157),
    [sym_switch_statement] = STATE(157),
    [sym_do_statement] = STATE(157),
    [sym_break_statement] = STATE(157),
    [sym_continue_statement] = STATE(157),
    [sym_return_statement] = STATE(157),
    [sym_synchronized_statement] = STATE(157),
    [sym_throw_statement] = STATE(157),
    [sym_try_statement] = STATE(157),
    [sym_try_with_resources_statement] = STATE(157),
    [sym_if_statement] = STATE(157),
    [sym_while_statement] = STATE(157),
    [sym_for_statement] = STATE(157),
    [sym_enhanced_for_statement] = STATE(157),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(157),
    [sym_module_declaration] = STATE(157),
    [sym_package_declaration] = STATE(157),
    [sym_import_declaration] = STATE(157),
    [sym_enum_declaration] = STATE(157),
    [sym_class_declaration] = STATE(157),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(157),
    [sym_interface_declaration] = STATE(157),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(157),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(168),
    [sym_block] = STATE(168),
    [sym_expression_statement] = STATE(168),
    [sym_labeled_statement] = STATE(168),
    [sym_assert_statement] = STATE(168),
    [sym_switch_statement] = STATE(168),
    [sym_do_statement] = STATE(168),
    [sym_break_statement] = STATE(168),
    [sym_continue_statement] = STATE(168),
    [sym_return_statement] = STATE(168),
    [sym_synchronized_statement] = STATE(168),
    [sym_throw_statement] = STATE(168),
    [sym_try_statement] = STATE(168),
    [sym_try_with_resources_statement] = STATE(168),
    [sym_if_statement] = STATE(168),
    [sym_while_statement] = STATE(168),
    [sym_for_statement] = STATE(168),
    [sym_enhanced_for_statement] = STATE(168),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(168),
    [sym_module_declaration] = STATE(168),
    [sym_package_declaration] = STATE(168),
    [sym_import_declaration] = STATE(168),
    [sym_enum_declaration] = STATE(168),
    [sym_class_declaration] = STATE(168),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(168),
    [sym_interface_declaration] = STATE(168),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(168),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(187),
    [sym_block] = STATE(187),
    [sym_expression_statement] = STATE(187),
    [sym_labeled_statement] = STATE(187),
    [sym_assert_statement] = STATE(187),
    [sym_switch_statement] = STATE(187),
    [sym_do_statement] = STATE(187),
    [sym_break_statement] = STATE(187),
    [sym_continue_statement] = STATE(187),
    [sym_return_statement] = STATE(187),
    [sym_synchronized_statement] = STATE(187),
    [sym_throw_statement] = STATE(187),
    [sym_try_statement] = STATE(187),
    [sym_try_with_resources_statement] = STATE(187),
    [sym_if_statement] = STATE(187),
    [sym_while_statement] = STATE(187),
    [sym_for_statement] = STATE(187),
    [sym_enhanced_for_statement] = STATE(187),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(187),
    [sym_module_declaration] = STATE(187),
    [sym_package_declaration] = STATE(187),
    [sym_import_declaration] = STATE(187),
    [sym_enum_declaration] = STATE(187),
    [sym_class_declaration] = STATE(187),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(187),
    [sym_interface_declaration] = STATE(187),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(187),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(397),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(180),
    [sym_block] = STATE(180),
    [sym_expression_statement] = STATE(180),
    [sym_labeled_statement] = STATE(180),
    [sym_assert_statement] = STATE(180),
    [sym_switch_statement] = STATE(180),
    [sym_do_statement] = STATE(180),
    [sym_break_statement] = STATE(180),
    [sym_continue_statement] = STATE(180),
    [sym_return_statement] = STATE(180),
    [sym_synchronized_statement] = STATE(180),
    [sym_throw_statement] = STATE(180),
    [sym_try_statement] = STATE(180),
    [sym_try_with_resources_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_for_statement] = STATE(180),
    [sym_enhanced_for_statement] = STATE(180),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(180),
    [sym_module_declaration] = STATE(180),
    [sym_package_declaration] = STATE(180),
    [sym_import_declaration] = STATE(180),
    [sym_enum_declaration] = STATE(180),
    [sym_class_declaration] = STATE(180),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(180),
    [sym_interface_declaration] = STATE(180),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(180),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(130),
    [sym_block] = STATE(130),
    [sym_expression_statement] = STATE(130),
    [sym_labeled_statement] = STATE(130),
    [sym_assert_statement] = STATE(130),
    [sym_switch_statement] = STATE(130),
    [sym_do_statement] = STATE(130),
    [sym_break_statement] = STATE(130),
    [sym_continue_statement] = STATE(130),
    [sym_return_statement] = STATE(130),
    [sym_synchronized_statement] = STATE(130),
    [sym_throw_statement] = STATE(130),
    [sym_try_statement] = STATE(130),
    [sym_try_with_resources_statement] = STATE(130),
    [sym_if_statement] = STATE(130),
    [sym_while_statement] = STATE(130),
    [sym_for_statement] = STATE(130),
    [sym_enhanced_for_statement] = STATE(130),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(130),
    [sym_module_declaration] = STATE(130),
    [sym_package_declaration] = STATE(130),
    [sym_import_declaration] = STATE(130),
    [sym_enum_declaration] = STATE(130),
    [sym_class_declaration] = STATE(130),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(130),
    [sym_interface_declaration] = STATE(130),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(130),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(133),
    [sym_block] = STATE(133),
    [sym_expression_statement] = STATE(133),
    [sym_labeled_statement] = STATE(133),
    [sym_assert_statement] = STATE(133),
    [sym_switch_statement] = STATE(133),
    [sym_do_statement] = STATE(133),
    [sym_break_statement] = STATE(133),
    [sym_continue_statement] = STATE(133),
    [sym_return_statement] = STATE(133),
    [sym_synchronized_statement] = STATE(133),
    [sym_throw_statement] = STATE(133),
    [sym_try_statement] = STATE(133),
    [sym_try_with_resources_statement] = STATE(133),
    [sym_if_statement] = STATE(133),
    [sym_while_statement] = STATE(133),
    [sym_for_statement] = STATE(133),
    [sym_enhanced_for_statement] = STATE(133),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(133),
    [sym_module_declaration] = STATE(133),
    [sym_package_declaration] = STATE(133),
    [sym_import_declaration] = STATE(133),
    [sym_enum_declaration] = STATE(133),
    [sym_class_declaration] = STATE(133),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(133),
    [sym_interface_declaration] = STATE(133),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(133),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(135),
    [sym_block] = STATE(135),
    [sym_expression_statement] = STATE(135),
    [sym_labeled_statement] = STATE(135),
    [sym_assert_statement] = STATE(135),
    [sym_switch_statement] = STATE(135),
    [sym_do_statement] = STATE(135),
    [sym_break_statement] = STATE(135),
    [sym_continue_statement] = STATE(135),
    [sym_return_statement] = STATE(135),
    [sym_synchronized_statement] = STATE(135),
    [sym_throw_statement] = STATE(135),
    [sym_try_statement] = STATE(135),
    [sym_try_with_resources_statement] = STATE(135),
    [sym_if_statement] = STATE(135),
    [sym_while_statement] = STATE(135),
    [sym_for_statement] = STATE(135),
    [sym_enhanced_for_statement] = STATE(135),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(135),
    [sym_module_declaration] = STATE(135),
    [sym_package_declaration] = STATE(135),
    [sym_import_declaration] = STATE(135),
    [sym_enum_declaration] = STATE(135),
    [sym_class_declaration] = STATE(135),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(135),
    [sym_interface_declaration] = STATE(135),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(135),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(137),
    [sym_block] = STATE(137),
    [sym_expression_statement] = STATE(137),
    [sym_labeled_statement] = STATE(137),
    [sym_assert_statement] = STATE(137),
    [sym_switch_statement] = STATE(137),
    [sym_do_statement] = STATE(137),
    [sym_break_statement] = STATE(137),
    [sym_continue_statement] = STATE(137),
    [sym_return_statement] = STATE(137),
    [sym_synchronized_statement] = STATE(137),
    [sym_throw_statement] = STATE(137),
    [sym_try_statement] = STATE(137),
    [sym_try_with_resources_statement] = STATE(137),
    [sym_if_statement] = STATE(137),
    [sym_while_statement] = STATE(137),
    [sym_for_statement] = STATE(137),
    [sym_enhanced_for_statement] = STATE(137),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(137),
    [sym_module_declaration] = STATE(137),
    [sym_package_declaration] = STATE(137),
    [sym_import_declaration] = STATE(137),
    [sym_enum_declaration] = STATE(137),
    [sym_class_declaration] = STATE(137),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(137),
    [sym_interface_declaration] = STATE(137),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(137),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(140),
    [sym_block] = STATE(140),
    [sym_expression_statement] = STATE(140),
    [sym_labeled_statement] = STATE(140),
    [sym_assert_statement] = STATE(140),
    [sym_switch_statement] = STATE(140),
    [sym_do_statement] = STATE(140),
    [sym_break_statement] = STATE(140),
    [sym_continue_statement] = STATE(140),
    [sym_return_statement] = STATE(140),
    [sym_synchronized_statement] = STATE(140),
    [sym_throw_statement] = STATE(140),
    [sym_try_statement] = STATE(140),
    [sym_try_with_resources_statement] = STATE(140),
    [sym_if_statement] = STATE(140),
    [sym_while_statement] = STATE(140),
    [sym_for_statement] = STATE(140),
    [sym_enhanced_for_statement] = STATE(140),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(140),
    [sym_module_declaration] = STATE(140),
    [sym_package_declaration] = STATE(140),
    [sym_import_declaration] = STATE(140),
    [sym_enum_declaration] = STATE(140),
    [sym_class_declaration] = STATE(140),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(140),
    [sym_interface_declaration] = STATE(140),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(140),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(196),
    [sym_block] = STATE(196),
    [sym_expression_statement] = STATE(196),
    [sym_labeled_statement] = STATE(196),
    [sym_assert_statement] = STATE(196),
    [sym_switch_statement] = STATE(196),
    [sym_do_statement] = STATE(196),
    [sym_break_statement] = STATE(196),
    [sym_continue_statement] = STATE(196),
    [sym_return_statement] = STATE(196),
    [sym_synchronized_statement] = STATE(196),
    [sym_throw_statement] = STATE(196),
    [sym_try_statement] = STATE(196),
    [sym_try_with_resources_statement] = STATE(196),
    [sym_if_statement] = STATE(196),
    [sym_while_statement] = STATE(196),
    [sym_for_statement] = STATE(196),
    [sym_enhanced_for_statement] = STATE(196),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(196),
    [sym_module_declaration] = STATE(196),
    [sym_package_declaration] = STATE(196),
    [sym_import_declaration] = STATE(196),
    [sym_enum_declaration] = STATE(196),
    [sym_class_declaration] = STATE(196),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(196),
    [sym_interface_declaration] = STATE(196),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(196),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(411),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(457),
    [sym_cast_expression] = STATE(457),
    [sym_assignment_expression] = STATE(457),
    [sym_binary_expression] = STATE(457),
    [sym_instanceof_expression] = STATE(457),
    [sym_lambda_expression] = STATE(457),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(457),
    [sym_unary_expression] = STATE(457),
    [sym_update_expression] = STATE(457),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__statement] = STATE(199),
    [sym_block] = STATE(199),
    [sym_expression_statement] = STATE(199),
    [sym_labeled_statement] = STATE(199),
    [sym_assert_statement] = STATE(199),
    [sym_switch_statement] = STATE(199),
    [sym_do_statement] = STATE(199),
    [sym_break_statement] = STATE(199),
    [sym_continue_statement] = STATE(199),
    [sym_return_statement] = STATE(199),
    [sym_synchronized_statement] = STATE(199),
    [sym_throw_statement] = STATE(199),
    [sym_try_statement] = STATE(199),
    [sym_try_with_resources_statement] = STATE(199),
    [sym_if_statement] = STATE(199),
    [sym_while_statement] = STATE(199),
    [sym_for_statement] = STATE(199),
    [sym_enhanced_for_statement] = STATE(199),
    [sym__annotation] = STATE(372),
    [sym_marker_annotation] = STATE(372),
    [sym_annotation] = STATE(372),
    [sym__declaration] = STATE(199),
    [sym_module_declaration] = STATE(199),
    [sym_package_declaration] = STATE(199),
    [sym_import_declaration] = STATE(199),
    [sym_enum_declaration] = STATE(199),
    [sym_class_declaration] = STATE(199),
    [sym_modifiers] = STATE(480),
    [sym_annotation_type_declaration] = STATE(199),
    [sym_interface_declaration] = STATE(199),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(505),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(505),
    [sym_integral_type] = STATE(505),
    [sym_floating_point_type] = STATE(505),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(199),
    [aux_sym_dimensions_expr_repeat1] = STATE(450),
    [aux_sym_modifiers_repeat1] = STATE(340),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_SEMI] = ACTIONS(413),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_switch] = ACTIONS(31),
    [anon_sym_default] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_synchronized] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_try] = ACTIONS(49),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_open] = ACTIONS(57),
    [anon_sym_module] = ACTIONS(59),
    [anon_sym_static] = ACTIONS(33),
    [anon_sym_package] = ACTIONS(61),
    [anon_sym_import] = ACTIONS(63),
    [anon_sym_enum] = ACTIONS(65),
    [anon_sym_public] = ACTIONS(33),
    [anon_sym_protected] = ACTIONS(33),
    [anon_sym_private] = ACTIONS(33),
    [anon_sym_abstract] = ACTIONS(33),
    [anon_sym_final] = ACTIONS(33),
    [anon_sym_strictfp] = ACTIONS(33),
    [anon_sym_native] = ACTIONS(33),
    [anon_sym_transient] = ACTIONS(33),
    [anon_sym_volatile] = ACTIONS(33),
    [anon_sym_ATinterface] = ACTIONS(67),
    [anon_sym_interface] = ACTIONS(69),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(75),
    [sym_void_type] = ACTIONS(75),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(415),
    [sym_identifier] = ACTIONS(417),
    [sym_decimal_integer_literal] = ACTIONS(417),
    [sym_hex_integer_literal] = ACTIONS(417),
    [sym_octal_integer_literal] = ACTIONS(415),
    [sym_binary_integer_literal] = ACTIONS(415),
    [sym_decimal_floating_point_literal] = ACTIONS(415),
    [sym_hex_floating_point_literal] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_character_literal] = ACTIONS(415),
    [sym_string_literal] = ACTIONS(415),
    [sym_null_literal] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(415),
    [anon_sym_AMP] = ACTIONS(417),
    [anon_sym_RPAREN] = ACTIONS(415),
    [anon_sym_GT] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(417),
    [anon_sym_EQ_EQ] = ACTIONS(415),
    [anon_sym_GT_EQ] = ACTIONS(415),
    [anon_sym_LT_EQ] = ACTIONS(415),
    [anon_sym_BANG_EQ] = ACTIONS(415),
    [anon_sym_AMP_AMP] = ACTIONS(415),
    [anon_sym_PIPE_PIPE] = ACTIONS(415),
    [anon_sym_PLUS] = ACTIONS(417),
    [anon_sym_DASH] = ACTIONS(417),
    [anon_sym_STAR] = ACTIONS(415),
    [anon_sym_SLASH] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(417),
    [anon_sym_CARET] = ACTIONS(415),
    [anon_sym_PERCENT] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_GT_GT] = ACTIONS(417),
    [anon_sym_GT_GT_GT] = ACTIONS(415),
    [anon_sym_instanceof] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(415),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_COLON] = ACTIONS(417),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_TILDE] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_new] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(415),
    [anon_sym_RBRACK] = ACTIONS(415),
    [anon_sym_DOT] = ACTIONS(417),
    [anon_sym_class] = ACTIONS(417),
    [anon_sym_COLON_COLON] = ACTIONS(415),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_RBRACE] = ACTIONS(415),
    [anon_sym_assert] = ACTIONS(417),
    [anon_sym_switch] = ACTIONS(417),
    [anon_sym_case] = ACTIONS(417),
    [anon_sym_default] = ACTIONS(417),
    [anon_sym_do] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(417),
    [anon_sym_break] = ACTIONS(417),
    [anon_sym_continue] = ACTIONS(417),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_synchronized] = ACTIONS(417),
    [anon_sym_throw] = ACTIONS(417),
    [anon_sym_try] = ACTIONS(417),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_else] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_open] = ACTIONS(417),
    [anon_sym_module] = ACTIONS(417),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_package] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(417),
    [anon_sym_enum] = ACTIONS(417),
    [anon_sym_public] = ACTIONS(417),
    [anon_sym_protected] = ACTIONS(417),
    [anon_sym_private] = ACTIONS(417),
    [anon_sym_abstract] = ACTIONS(417),
    [anon_sym_final] = ACTIONS(417),
    [anon_sym_strictfp] = ACTIONS(417),
    [anon_sym_native] = ACTIONS(417),
    [anon_sym_transient] = ACTIONS(417),
    [anon_sym_volatile] = ACTIONS(417),
    [anon_sym_ATinterface] = ACTIONS(415),
    [anon_sym_interface] = ACTIONS(417),
    [anon_sym_byte] = ACTIONS(417),
    [anon_sym_short] = ACTIONS(417),
    [anon_sym_int] = ACTIONS(417),
    [anon_sym_long] = ACTIONS(417),
    [anon_sym_char] = ACTIONS(417),
    [anon_sym_float] = ACTIONS(417),
    [anon_sym_double] = ACTIONS(417),
    [sym_boolean_type] = ACTIONS(417),
    [sym_void_type] = ACTIONS(417),
    [sym_this] = ACTIONS(417),
    [sym_super] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(419),
    [sym_identifier] = ACTIONS(421),
    [sym_decimal_integer_literal] = ACTIONS(421),
    [sym_hex_integer_literal] = ACTIONS(421),
    [sym_octal_integer_literal] = ACTIONS(419),
    [sym_binary_integer_literal] = ACTIONS(419),
    [sym_decimal_floating_point_literal] = ACTIONS(419),
    [sym_hex_floating_point_literal] = ACTIONS(421),
    [sym_true] = ACTIONS(421),
    [sym_false] = ACTIONS(421),
    [sym_character_literal] = ACTIONS(419),
    [sym_string_literal] = ACTIONS(419),
    [sym_null_literal] = ACTIONS(421),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_AMP] = ACTIONS(421),
    [anon_sym_RPAREN] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(421),
    [anon_sym_LT] = ACTIONS(421),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_GT_EQ] = ACTIONS(419),
    [anon_sym_LT_EQ] = ACTIONS(419),
    [anon_sym_BANG_EQ] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [anon_sym_PLUS] = ACTIONS(421),
    [anon_sym_DASH] = ACTIONS(421),
    [anon_sym_STAR] = ACTIONS(419),
    [anon_sym_SLASH] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(421),
    [anon_sym_CARET] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(419),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_GT_GT_GT] = ACTIONS(419),
    [anon_sym_instanceof] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(419),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_COLON] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_TILDE] = ACTIONS(419),
    [anon_sym_PLUS_PLUS] = ACTIONS(419),
    [anon_sym_DASH_DASH] = ACTIONS(419),
    [anon_sym_new] = ACTIONS(421),
    [anon_sym_LBRACK] = ACTIONS(419),
    [anon_sym_RBRACK] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(421),
    [anon_sym_class] = ACTIONS(421),
    [anon_sym_COLON_COLON] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(419),
    [anon_sym_RBRACE] = ACTIONS(419),
    [anon_sym_assert] = ACTIONS(421),
    [anon_sym_switch] = ACTIONS(421),
    [anon_sym_case] = ACTIONS(421),
    [anon_sym_default] = ACTIONS(421),
    [anon_sym_do] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_break] = ACTIONS(421),
    [anon_sym_continue] = ACTIONS(421),
    [anon_sym_return] = ACTIONS(421),
    [anon_sym_synchronized] = ACTIONS(421),
    [anon_sym_throw] = ACTIONS(421),
    [anon_sym_try] = ACTIONS(421),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_else] = ACTIONS(421),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_AT] = ACTIONS(421),
    [anon_sym_open] = ACTIONS(421),
    [anon_sym_module] = ACTIONS(421),
    [anon_sym_static] = ACTIONS(421),
    [anon_sym_package] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(421),
    [anon_sym_enum] = ACTIONS(421),
    [anon_sym_public] = ACTIONS(421),
    [anon_sym_protected] = ACTIONS(421),
    [anon_sym_private] = ACTIONS(421),
    [anon_sym_abstract] = ACTIONS(421),
    [anon_sym_final] = ACTIONS(421),
    [anon_sym_strictfp] = ACTIONS(421),
    [anon_sym_native] = ACTIONS(421),
    [anon_sym_transient] = ACTIONS(421),
    [anon_sym_volatile] = ACTIONS(421),
    [anon_sym_ATinterface] = ACTIONS(419),
    [anon_sym_interface] = ACTIONS(421),
    [anon_sym_byte] = ACTIONS(421),
    [anon_sym_short] = ACTIONS(421),
    [anon_sym_int] = ACTIONS(421),
    [anon_sym_long] = ACTIONS(421),
    [anon_sym_char] = ACTIONS(421),
    [anon_sym_float] = ACTIONS(421),
    [anon_sym_double] = ACTIONS(421),
    [sym_boolean_type] = ACTIONS(421),
    [sym_void_type] = ACTIONS(421),
    [sym_this] = ACTIONS(421),
    [sym_super] = ACTIONS(421),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(423),
    [sym_identifier] = ACTIONS(425),
    [sym_decimal_integer_literal] = ACTIONS(425),
    [sym_hex_integer_literal] = ACTIONS(425),
    [sym_octal_integer_literal] = ACTIONS(423),
    [sym_binary_integer_literal] = ACTIONS(423),
    [sym_decimal_floating_point_literal] = ACTIONS(423),
    [sym_hex_floating_point_literal] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_character_literal] = ACTIONS(423),
    [sym_string_literal] = ACTIONS(423),
    [sym_null_literal] = ACTIONS(425),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_AMP] = ACTIONS(425),
    [anon_sym_RPAREN] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(425),
    [anon_sym_LT] = ACTIONS(425),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(425),
    [anon_sym_STAR] = ACTIONS(423),
    [anon_sym_SLASH] = ACTIONS(425),
    [anon_sym_PIPE] = ACTIONS(425),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(425),
    [anon_sym_GT_GT_GT] = ACTIONS(423),
    [anon_sym_instanceof] = ACTIONS(425),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_COLON] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(423),
    [anon_sym_DASH_DASH] = ACTIONS(423),
    [anon_sym_new] = ACTIONS(425),
    [anon_sym_RBRACK] = ACTIONS(423),
    [anon_sym_class] = ACTIONS(425),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_assert] = ACTIONS(425),
    [anon_sym_switch] = ACTIONS(425),
    [anon_sym_case] = ACTIONS(425),
    [anon_sym_default] = ACTIONS(425),
    [anon_sym_do] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(425),
    [anon_sym_continue] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(425),
    [anon_sym_synchronized] = ACTIONS(425),
    [anon_sym_throw] = ACTIONS(425),
    [anon_sym_try] = ACTIONS(425),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_AT] = ACTIONS(425),
    [anon_sym_open] = ACTIONS(425),
    [anon_sym_module] = ACTIONS(425),
    [anon_sym_static] = ACTIONS(425),
    [anon_sym_package] = ACTIONS(425),
    [anon_sym_import] = ACTIONS(425),
    [anon_sym_enum] = ACTIONS(425),
    [anon_sym_public] = ACTIONS(425),
    [anon_sym_protected] = ACTIONS(425),
    [anon_sym_private] = ACTIONS(425),
    [anon_sym_abstract] = ACTIONS(425),
    [anon_sym_final] = ACTIONS(425),
    [anon_sym_strictfp] = ACTIONS(425),
    [anon_sym_native] = ACTIONS(425),
    [anon_sym_transient] = ACTIONS(425),
    [anon_sym_volatile] = ACTIONS(425),
    [anon_sym_ATinterface] = ACTIONS(423),
    [anon_sym_interface] = ACTIONS(425),
    [anon_sym_byte] = ACTIONS(425),
    [anon_sym_short] = ACTIONS(425),
    [anon_sym_int] = ACTIONS(425),
    [anon_sym_long] = ACTIONS(425),
    [anon_sym_char] = ACTIONS(425),
    [anon_sym_float] = ACTIONS(425),
    [anon_sym_double] = ACTIONS(425),
    [sym_boolean_type] = ACTIONS(425),
    [sym_void_type] = ACTIONS(425),
    [sym_this] = ACTIONS(425),
    [sym_super] = ACTIONS(425),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(427),
    [sym_identifier] = ACTIONS(429),
    [sym_decimal_integer_literal] = ACTIONS(429),
    [sym_hex_integer_literal] = ACTIONS(429),
    [sym_octal_integer_literal] = ACTIONS(427),
    [sym_binary_integer_literal] = ACTIONS(427),
    [sym_decimal_floating_point_literal] = ACTIONS(427),
    [sym_hex_floating_point_literal] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_character_literal] = ACTIONS(427),
    [sym_string_literal] = ACTIONS(427),
    [sym_null_literal] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(427),
    [anon_sym_AMP] = ACTIONS(429),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(429),
    [anon_sym_STAR] = ACTIONS(427),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(427),
    [anon_sym_PERCENT] = ACTIONS(427),
    [anon_sym_LT_LT] = ACTIONS(427),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_GT_GT_GT] = ACTIONS(427),
    [anon_sym_instanceof] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_TILDE] = ACTIONS(427),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_RBRACK] = ACTIONS(427),
    [anon_sym_class] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_LBRACE] = ACTIONS(427),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_assert] = ACTIONS(429),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(429),
    [anon_sym_default] = ACTIONS(429),
    [anon_sym_do] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_break] = ACTIONS(429),
    [anon_sym_continue] = ACTIONS(429),
    [anon_sym_return] = ACTIONS(429),
    [anon_sym_synchronized] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(429),
    [anon_sym_try] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_else] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_open] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(429),
    [anon_sym_package] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(429),
    [anon_sym_enum] = ACTIONS(429),
    [anon_sym_public] = ACTIONS(429),
    [anon_sym_protected] = ACTIONS(429),
    [anon_sym_private] = ACTIONS(429),
    [anon_sym_abstract] = ACTIONS(429),
    [anon_sym_final] = ACTIONS(429),
    [anon_sym_strictfp] = ACTIONS(429),
    [anon_sym_native] = ACTIONS(429),
    [anon_sym_transient] = ACTIONS(429),
    [anon_sym_volatile] = ACTIONS(429),
    [anon_sym_ATinterface] = ACTIONS(427),
    [anon_sym_interface] = ACTIONS(429),
    [anon_sym_byte] = ACTIONS(429),
    [anon_sym_short] = ACTIONS(429),
    [anon_sym_int] = ACTIONS(429),
    [anon_sym_long] = ACTIONS(429),
    [anon_sym_char] = ACTIONS(429),
    [anon_sym_float] = ACTIONS(429),
    [anon_sym_double] = ACTIONS(429),
    [sym_boolean_type] = ACTIONS(429),
    [sym_void_type] = ACTIONS(429),
    [sym_this] = ACTIONS(429),
    [sym_super] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_identifier] = ACTIONS(431),
    [sym_decimal_integer_literal] = ACTIONS(431),
    [sym_hex_integer_literal] = ACTIONS(431),
    [sym_octal_integer_literal] = ACTIONS(433),
    [sym_binary_integer_literal] = ACTIONS(433),
    [sym_decimal_floating_point_literal] = ACTIONS(433),
    [sym_hex_floating_point_literal] = ACTIONS(431),
    [sym_true] = ACTIONS(431),
    [sym_false] = ACTIONS(431),
    [sym_character_literal] = ACTIONS(433),
    [sym_string_literal] = ACTIONS(433),
    [sym_null_literal] = ACTIONS(431),
    [anon_sym_LPAREN] = ACTIONS(433),
    [anon_sym_AMP] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(433),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_EQ_EQ] = ACTIONS(433),
    [anon_sym_GT_EQ] = ACTIONS(433),
    [anon_sym_LT_EQ] = ACTIONS(433),
    [anon_sym_BANG_EQ] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(433),
    [anon_sym_PIPE_PIPE] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_STAR] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_CARET] = ACTIONS(433),
    [anon_sym_PERCENT] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(431),
    [anon_sym_GT_GT_GT] = ACTIONS(433),
    [anon_sym_instanceof] = ACTIONS(431),
    [anon_sym_COMMA] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(433),
    [anon_sym_COLON] = ACTIONS(431),
    [anon_sym_BANG] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(433),
    [anon_sym_PLUS_PLUS] = ACTIONS(433),
    [anon_sym_DASH_DASH] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(433),
    [anon_sym_RBRACK] = ACTIONS(433),
    [anon_sym_DOT] = ACTIONS(431),
    [anon_sym_class] = ACTIONS(431),
    [anon_sym_COLON_COLON] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(433),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_RBRACE] = ACTIONS(433),
    [anon_sym_assert] = ACTIONS(431),
    [anon_sym_switch] = ACTIONS(431),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_do] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(431),
    [anon_sym_break] = ACTIONS(431),
    [anon_sym_continue] = ACTIONS(431),
    [anon_sym_return] = ACTIONS(431),
    [anon_sym_synchronized] = ACTIONS(431),
    [anon_sym_throw] = ACTIONS(431),
    [anon_sym_try] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(431),
    [anon_sym_open] = ACTIONS(431),
    [anon_sym_module] = ACTIONS(431),
    [anon_sym_static] = ACTIONS(431),
    [anon_sym_package] = ACTIONS(431),
    [anon_sym_import] = ACTIONS(431),
    [anon_sym_enum] = ACTIONS(431),
    [anon_sym_public] = ACTIONS(431),
    [anon_sym_protected] = ACTIONS(431),
    [anon_sym_private] = ACTIONS(431),
    [anon_sym_abstract] = ACTIONS(431),
    [anon_sym_final] = ACTIONS(431),
    [anon_sym_strictfp] = ACTIONS(431),
    [anon_sym_native] = ACTIONS(431),
    [anon_sym_transient] = ACTIONS(431),
    [anon_sym_volatile] = ACTIONS(431),
    [anon_sym_ATinterface] = ACTIONS(433),
    [anon_sym_interface] = ACTIONS(431),
    [anon_sym_byte] = ACTIONS(431),
    [anon_sym_short] = ACTIONS(431),
    [anon_sym_int] = ACTIONS(431),
    [anon_sym_long] = ACTIONS(431),
    [anon_sym_char] = ACTIONS(431),
    [anon_sym_float] = ACTIONS(431),
    [anon_sym_double] = ACTIONS(431),
    [sym_boolean_type] = ACTIONS(431),
    [sym_void_type] = ACTIONS(431),
    [sym_this] = ACTIONS(431),
    [sym_super] = ACTIONS(431),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(441),
    [sym_cast_expression] = STATE(441),
    [sym_assignment_expression] = STATE(441),
    [sym_binary_expression] = STATE(441),
    [sym_instanceof_expression] = STATE(441),
    [sym_lambda_expression] = STATE(441),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(441),
    [sym_unary_expression] = STATE(441),
    [sym_update_expression] = STATE(441),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(506),
    [sym__type] = STATE(666),
    [sym__unannotated_type] = STATE(492),
    [sym_annotated_type] = STATE(666),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(492),
    [sym_integral_type] = STATE(492),
    [sym_floating_point_type] = STATE(492),
    [sym_formal_parameters] = STATE(906),
    [sym_formal_parameter] = STATE(704),
    [sym_receiver_parameter] = STATE(279),
    [sym_spread_parameter] = STATE(704),
    [aux_sym_dimensions_expr_repeat1] = STATE(475),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(435),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(445),
    [sym_void_type] = ACTIONS(445),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(412),
    [sym_cast_expression] = STATE(412),
    [sym_assignment_expression] = STATE(412),
    [sym_binary_expression] = STATE(412),
    [sym_instanceof_expression] = STATE(412),
    [sym_lambda_expression] = STATE(412),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(412),
    [sym_unary_expression] = STATE(412),
    [sym_update_expression] = STATE(412),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(503),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(498),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(498),
    [sym_integral_type] = STATE(498),
    [sym_floating_point_type] = STATE(498),
    [sym_formal_parameters] = STATE(906),
    [sym_local_variable_declaration] = STATE(177),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(449),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(451),
    [sym_void_type] = ACTIONS(451),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_catch_clause] = STATE(57),
    [sym_finally_clause] = STATE(176),
    [aux_sym_try_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(453),
    [sym_identifier] = ACTIONS(455),
    [sym_decimal_integer_literal] = ACTIONS(455),
    [sym_hex_integer_literal] = ACTIONS(455),
    [sym_octal_integer_literal] = ACTIONS(453),
    [sym_binary_integer_literal] = ACTIONS(453),
    [sym_decimal_floating_point_literal] = ACTIONS(453),
    [sym_hex_floating_point_literal] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_character_literal] = ACTIONS(453),
    [sym_string_literal] = ACTIONS(453),
    [sym_null_literal] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(455),
    [anon_sym_DASH] = ACTIONS(455),
    [anon_sym_BANG] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_PLUS_PLUS] = ACTIONS(453),
    [anon_sym_DASH_DASH] = ACTIONS(453),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_class] = ACTIONS(455),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_LBRACE] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_assert] = ACTIONS(455),
    [anon_sym_switch] = ACTIONS(455),
    [anon_sym_case] = ACTIONS(455),
    [anon_sym_default] = ACTIONS(455),
    [anon_sym_do] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_break] = ACTIONS(455),
    [anon_sym_continue] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(455),
    [anon_sym_synchronized] = ACTIONS(455),
    [anon_sym_throw] = ACTIONS(455),
    [anon_sym_try] = ACTIONS(455),
    [anon_sym_catch] = ACTIONS(457),
    [anon_sym_finally] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_else] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_AT] = ACTIONS(455),
    [anon_sym_open] = ACTIONS(455),
    [anon_sym_module] = ACTIONS(455),
    [anon_sym_static] = ACTIONS(455),
    [anon_sym_package] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_enum] = ACTIONS(455),
    [anon_sym_public] = ACTIONS(455),
    [anon_sym_protected] = ACTIONS(455),
    [anon_sym_private] = ACTIONS(455),
    [anon_sym_abstract] = ACTIONS(455),
    [anon_sym_final] = ACTIONS(455),
    [anon_sym_strictfp] = ACTIONS(455),
    [anon_sym_native] = ACTIONS(455),
    [anon_sym_transient] = ACTIONS(455),
    [anon_sym_volatile] = ACTIONS(455),
    [anon_sym_ATinterface] = ACTIONS(453),
    [anon_sym_interface] = ACTIONS(455),
    [anon_sym_byte] = ACTIONS(455),
    [anon_sym_short] = ACTIONS(455),
    [anon_sym_int] = ACTIONS(455),
    [anon_sym_long] = ACTIONS(455),
    [anon_sym_char] = ACTIONS(455),
    [anon_sym_float] = ACTIONS(455),
    [anon_sym_double] = ACTIONS(455),
    [sym_boolean_type] = ACTIONS(455),
    [sym_void_type] = ACTIONS(455),
    [sym_this] = ACTIONS(455),
    [sym_super] = ACTIONS(455),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_catch_clause] = STATE(57),
    [sym_finally_clause] = STATE(116),
    [aux_sym_try_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(461),
    [sym_identifier] = ACTIONS(463),
    [sym_decimal_integer_literal] = ACTIONS(463),
    [sym_hex_integer_literal] = ACTIONS(463),
    [sym_octal_integer_literal] = ACTIONS(461),
    [sym_binary_integer_literal] = ACTIONS(461),
    [sym_decimal_floating_point_literal] = ACTIONS(461),
    [sym_hex_floating_point_literal] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_character_literal] = ACTIONS(461),
    [sym_string_literal] = ACTIONS(461),
    [sym_null_literal] = ACTIONS(463),
    [anon_sym_LPAREN] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_new] = ACTIONS(463),
    [anon_sym_class] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(461),
    [anon_sym_LBRACE] = ACTIONS(461),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_assert] = ACTIONS(463),
    [anon_sym_switch] = ACTIONS(463),
    [anon_sym_case] = ACTIONS(463),
    [anon_sym_default] = ACTIONS(463),
    [anon_sym_do] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_break] = ACTIONS(463),
    [anon_sym_continue] = ACTIONS(463),
    [anon_sym_return] = ACTIONS(463),
    [anon_sym_synchronized] = ACTIONS(463),
    [anon_sym_throw] = ACTIONS(463),
    [anon_sym_try] = ACTIONS(463),
    [anon_sym_catch] = ACTIONS(457),
    [anon_sym_finally] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_else] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(463),
    [anon_sym_open] = ACTIONS(463),
    [anon_sym_module] = ACTIONS(463),
    [anon_sym_static] = ACTIONS(463),
    [anon_sym_package] = ACTIONS(463),
    [anon_sym_import] = ACTIONS(463),
    [anon_sym_enum] = ACTIONS(463),
    [anon_sym_public] = ACTIONS(463),
    [anon_sym_protected] = ACTIONS(463),
    [anon_sym_private] = ACTIONS(463),
    [anon_sym_abstract] = ACTIONS(463),
    [anon_sym_final] = ACTIONS(463),
    [anon_sym_strictfp] = ACTIONS(463),
    [anon_sym_native] = ACTIONS(463),
    [anon_sym_transient] = ACTIONS(463),
    [anon_sym_volatile] = ACTIONS(463),
    [anon_sym_ATinterface] = ACTIONS(461),
    [anon_sym_interface] = ACTIONS(463),
    [anon_sym_byte] = ACTIONS(463),
    [anon_sym_short] = ACTIONS(463),
    [anon_sym_int] = ACTIONS(463),
    [anon_sym_long] = ACTIONS(463),
    [anon_sym_char] = ACTIONS(463),
    [anon_sym_float] = ACTIONS(463),
    [anon_sym_double] = ACTIONS(463),
    [sym_boolean_type] = ACTIONS(463),
    [sym_void_type] = ACTIONS(463),
    [sym_this] = ACTIONS(463),
    [sym_super] = ACTIONS(463),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_catch_clause] = STATE(54),
    [sym_finally_clause] = STATE(181),
    [aux_sym_try_statement_repeat1] = STATE(54),
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym_identifier] = ACTIONS(467),
    [sym_decimal_integer_literal] = ACTIONS(467),
    [sym_hex_integer_literal] = ACTIONS(467),
    [sym_octal_integer_literal] = ACTIONS(465),
    [sym_binary_integer_literal] = ACTIONS(465),
    [sym_decimal_floating_point_literal] = ACTIONS(465),
    [sym_hex_floating_point_literal] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_character_literal] = ACTIONS(465),
    [sym_string_literal] = ACTIONS(465),
    [sym_null_literal] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(467),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_new] = ACTIONS(467),
    [anon_sym_class] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(465),
    [anon_sym_LBRACE] = ACTIONS(465),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_assert] = ACTIONS(467),
    [anon_sym_switch] = ACTIONS(467),
    [anon_sym_case] = ACTIONS(467),
    [anon_sym_default] = ACTIONS(467),
    [anon_sym_do] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_break] = ACTIONS(467),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_synchronized] = ACTIONS(467),
    [anon_sym_throw] = ACTIONS(467),
    [anon_sym_try] = ACTIONS(467),
    [anon_sym_catch] = ACTIONS(457),
    [anon_sym_finally] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_else] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(467),
    [anon_sym_open] = ACTIONS(467),
    [anon_sym_module] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(467),
    [anon_sym_package] = ACTIONS(467),
    [anon_sym_import] = ACTIONS(467),
    [anon_sym_enum] = ACTIONS(467),
    [anon_sym_public] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_abstract] = ACTIONS(467),
    [anon_sym_final] = ACTIONS(467),
    [anon_sym_strictfp] = ACTIONS(467),
    [anon_sym_native] = ACTIONS(467),
    [anon_sym_transient] = ACTIONS(467),
    [anon_sym_volatile] = ACTIONS(467),
    [anon_sym_ATinterface] = ACTIONS(465),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_byte] = ACTIONS(467),
    [anon_sym_short] = ACTIONS(467),
    [anon_sym_int] = ACTIONS(467),
    [anon_sym_long] = ACTIONS(467),
    [anon_sym_char] = ACTIONS(467),
    [anon_sym_float] = ACTIONS(467),
    [anon_sym_double] = ACTIONS(467),
    [sym_boolean_type] = ACTIONS(467),
    [sym_void_type] = ACTIONS(467),
    [sym_this] = ACTIONS(467),
    [sym_super] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(742),
    [sym_element_value_array_initializer] = STATE(742),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_catch_clause] = STATE(57),
    [aux_sym_try_statement_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(477),
    [sym_identifier] = ACTIONS(479),
    [sym_decimal_integer_literal] = ACTIONS(479),
    [sym_hex_integer_literal] = ACTIONS(479),
    [sym_octal_integer_literal] = ACTIONS(477),
    [sym_binary_integer_literal] = ACTIONS(477),
    [sym_decimal_floating_point_literal] = ACTIONS(477),
    [sym_hex_floating_point_literal] = ACTIONS(479),
    [sym_true] = ACTIONS(479),
    [sym_false] = ACTIONS(479),
    [sym_character_literal] = ACTIONS(477),
    [sym_string_literal] = ACTIONS(477),
    [sym_null_literal] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(477),
    [anon_sym_PLUS] = ACTIONS(479),
    [anon_sym_DASH] = ACTIONS(479),
    [anon_sym_BANG] = ACTIONS(477),
    [anon_sym_TILDE] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(477),
    [anon_sym_DASH_DASH] = ACTIONS(477),
    [anon_sym_new] = ACTIONS(479),
    [anon_sym_class] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(477),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_assert] = ACTIONS(479),
    [anon_sym_switch] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(479),
    [anon_sym_default] = ACTIONS(479),
    [anon_sym_do] = ACTIONS(479),
    [anon_sym_while] = ACTIONS(479),
    [anon_sym_break] = ACTIONS(479),
    [anon_sym_continue] = ACTIONS(479),
    [anon_sym_return] = ACTIONS(479),
    [anon_sym_synchronized] = ACTIONS(479),
    [anon_sym_throw] = ACTIONS(479),
    [anon_sym_try] = ACTIONS(479),
    [anon_sym_catch] = ACTIONS(481),
    [anon_sym_finally] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(479),
    [anon_sym_else] = ACTIONS(479),
    [anon_sym_for] = ACTIONS(479),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_open] = ACTIONS(479),
    [anon_sym_module] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_package] = ACTIONS(479),
    [anon_sym_import] = ACTIONS(479),
    [anon_sym_enum] = ACTIONS(479),
    [anon_sym_public] = ACTIONS(479),
    [anon_sym_protected] = ACTIONS(479),
    [anon_sym_private] = ACTIONS(479),
    [anon_sym_abstract] = ACTIONS(479),
    [anon_sym_final] = ACTIONS(479),
    [anon_sym_strictfp] = ACTIONS(479),
    [anon_sym_native] = ACTIONS(479),
    [anon_sym_transient] = ACTIONS(479),
    [anon_sym_volatile] = ACTIONS(479),
    [anon_sym_ATinterface] = ACTIONS(477),
    [anon_sym_interface] = ACTIONS(479),
    [anon_sym_byte] = ACTIONS(479),
    [anon_sym_short] = ACTIONS(479),
    [anon_sym_int] = ACTIONS(479),
    [anon_sym_long] = ACTIONS(479),
    [anon_sym_char] = ACTIONS(479),
    [anon_sym_float] = ACTIONS(479),
    [anon_sym_double] = ACTIONS(479),
    [sym_boolean_type] = ACTIONS(479),
    [sym_void_type] = ACTIONS(479),
    [sym_this] = ACTIONS(479),
    [sym_super] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym_element_value_pair] = STATE(719),
    [sym__element_value] = STATE(943),
    [sym_element_value_array_initializer] = STATE(943),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(484),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(486),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym_element_value_pair] = STATE(771),
    [sym__element_value] = STATE(917),
    [sym_element_value_array_initializer] = STATE(917),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(484),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(488),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(810),
    [sym_element_value_array_initializer] = STATE(810),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(408),
    [sym_cast_expression] = STATE(408),
    [sym_assignment_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_instanceof_expression] = STATE(408),
    [sym_lambda_expression] = STATE(408),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_update_expression] = STATE(408),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym_array_initializer] = STATE(710),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(810),
    [sym_element_value_array_initializer] = STATE(810),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [ts_builtin_sym_end] = ACTIONS(427),
    [sym_identifier] = ACTIONS(429),
    [sym_decimal_integer_literal] = ACTIONS(429),
    [sym_hex_integer_literal] = ACTIONS(429),
    [sym_octal_integer_literal] = ACTIONS(427),
    [sym_binary_integer_literal] = ACTIONS(427),
    [sym_decimal_floating_point_literal] = ACTIONS(427),
    [sym_hex_floating_point_literal] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_character_literal] = ACTIONS(427),
    [sym_string_literal] = ACTIONS(427),
    [sym_null_literal] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(427),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(427),
    [anon_sym_PLUS_PLUS] = ACTIONS(427),
    [anon_sym_DASH_DASH] = ACTIONS(427),
    [anon_sym_new] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(429),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_LBRACE] = ACTIONS(427),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_assert] = ACTIONS(429),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(429),
    [anon_sym_default] = ACTIONS(429),
    [anon_sym_do] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_break] = ACTIONS(429),
    [anon_sym_continue] = ACTIONS(429),
    [anon_sym_return] = ACTIONS(429),
    [anon_sym_synchronized] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(429),
    [anon_sym_try] = ACTIONS(429),
    [anon_sym_catch] = ACTIONS(429),
    [anon_sym_finally] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_else] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_open] = ACTIONS(429),
    [anon_sym_module] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(429),
    [anon_sym_package] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(429),
    [anon_sym_enum] = ACTIONS(429),
    [anon_sym_public] = ACTIONS(429),
    [anon_sym_protected] = ACTIONS(429),
    [anon_sym_private] = ACTIONS(429),
    [anon_sym_abstract] = ACTIONS(429),
    [anon_sym_final] = ACTIONS(429),
    [anon_sym_strictfp] = ACTIONS(429),
    [anon_sym_native] = ACTIONS(429),
    [anon_sym_transient] = ACTIONS(429),
    [anon_sym_volatile] = ACTIONS(429),
    [anon_sym_ATinterface] = ACTIONS(427),
    [anon_sym_interface] = ACTIONS(429),
    [anon_sym_byte] = ACTIONS(429),
    [anon_sym_short] = ACTIONS(429),
    [anon_sym_int] = ACTIONS(429),
    [anon_sym_long] = ACTIONS(429),
    [anon_sym_char] = ACTIONS(429),
    [anon_sym_float] = ACTIONS(429),
    [anon_sym_double] = ACTIONS(429),
    [sym_boolean_type] = ACTIONS(429),
    [sym_void_type] = ACTIONS(429),
    [sym_this] = ACTIONS(429),
    [sym_super] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(884),
    [sym_element_value_array_initializer] = STATE(884),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(429),
    [sym_cast_expression] = STATE(429),
    [sym_assignment_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_lambda_expression] = STATE(429),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym_array_initializer] = STATE(852),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(862),
    [sym_element_value_array_initializer] = STATE(862),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(423),
    [sym_identifier] = ACTIONS(425),
    [sym_decimal_integer_literal] = ACTIONS(425),
    [sym_hex_integer_literal] = ACTIONS(425),
    [sym_octal_integer_literal] = ACTIONS(423),
    [sym_binary_integer_literal] = ACTIONS(423),
    [sym_decimal_floating_point_literal] = ACTIONS(423),
    [sym_hex_floating_point_literal] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_character_literal] = ACTIONS(423),
    [sym_string_literal] = ACTIONS(423),
    [sym_null_literal] = ACTIONS(425),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(425),
    [anon_sym_BANG] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_PLUS_PLUS] = ACTIONS(423),
    [anon_sym_DASH_DASH] = ACTIONS(423),
    [anon_sym_new] = ACTIONS(425),
    [anon_sym_class] = ACTIONS(425),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_assert] = ACTIONS(425),
    [anon_sym_switch] = ACTIONS(425),
    [anon_sym_case] = ACTIONS(425),
    [anon_sym_default] = ACTIONS(425),
    [anon_sym_do] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(425),
    [anon_sym_continue] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(425),
    [anon_sym_synchronized] = ACTIONS(425),
    [anon_sym_throw] = ACTIONS(425),
    [anon_sym_try] = ACTIONS(425),
    [anon_sym_catch] = ACTIONS(425),
    [anon_sym_finally] = ACTIONS(425),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_AT] = ACTIONS(425),
    [anon_sym_open] = ACTIONS(425),
    [anon_sym_module] = ACTIONS(425),
    [anon_sym_static] = ACTIONS(425),
    [anon_sym_package] = ACTIONS(425),
    [anon_sym_import] = ACTIONS(425),
    [anon_sym_enum] = ACTIONS(425),
    [anon_sym_public] = ACTIONS(425),
    [anon_sym_protected] = ACTIONS(425),
    [anon_sym_private] = ACTIONS(425),
    [anon_sym_abstract] = ACTIONS(425),
    [anon_sym_final] = ACTIONS(425),
    [anon_sym_strictfp] = ACTIONS(425),
    [anon_sym_native] = ACTIONS(425),
    [anon_sym_transient] = ACTIONS(425),
    [anon_sym_volatile] = ACTIONS(425),
    [anon_sym_ATinterface] = ACTIONS(423),
    [anon_sym_interface] = ACTIONS(425),
    [anon_sym_byte] = ACTIONS(425),
    [anon_sym_short] = ACTIONS(425),
    [anon_sym_int] = ACTIONS(425),
    [anon_sym_long] = ACTIONS(425),
    [anon_sym_char] = ACTIONS(425),
    [anon_sym_float] = ACTIONS(425),
    [anon_sym_double] = ACTIONS(425),
    [sym_boolean_type] = ACTIONS(425),
    [sym_void_type] = ACTIONS(425),
    [sym_this] = ACTIONS(425),
    [sym_super] = ACTIONS(425),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(432),
    [sym_cast_expression] = STATE(432),
    [sym_assignment_expression] = STATE(432),
    [sym_binary_expression] = STATE(432),
    [sym_instanceof_expression] = STATE(432),
    [sym_lambda_expression] = STATE(432),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(432),
    [sym_unary_expression] = STATE(432),
    [sym_update_expression] = STATE(432),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(862),
    [sym_element_value_array_initializer] = STATE(862),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(401),
    [sym_cast_expression] = STATE(401),
    [sym_assignment_expression] = STATE(401),
    [sym_binary_expression] = STATE(401),
    [sym_instanceof_expression] = STATE(401),
    [sym_lambda_expression] = STATE(401),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(401),
    [sym_unary_expression] = STATE(401),
    [sym_update_expression] = STATE(401),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(512),
    [sym_marker_annotation] = STATE(512),
    [sym_annotation] = STATE(512),
    [sym__element_value] = STATE(810),
    [sym_element_value_array_initializer] = STATE(810),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(429),
    [sym_cast_expression] = STATE(429),
    [sym_assignment_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_lambda_expression] = STATE(429),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym_array_initializer] = STATE(852),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(504),
    [sym_identifier] = ACTIONS(506),
    [sym_decimal_integer_literal] = ACTIONS(506),
    [sym_hex_integer_literal] = ACTIONS(506),
    [sym_octal_integer_literal] = ACTIONS(504),
    [sym_binary_integer_literal] = ACTIONS(504),
    [sym_decimal_floating_point_literal] = ACTIONS(504),
    [sym_hex_floating_point_literal] = ACTIONS(506),
    [sym_true] = ACTIONS(506),
    [sym_false] = ACTIONS(506),
    [sym_character_literal] = ACTIONS(504),
    [sym_string_literal] = ACTIONS(504),
    [sym_null_literal] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_DASH] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(504),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_PLUS_PLUS] = ACTIONS(504),
    [anon_sym_DASH_DASH] = ACTIONS(504),
    [anon_sym_new] = ACTIONS(506),
    [anon_sym_class] = ACTIONS(506),
    [anon_sym_SEMI] = ACTIONS(504),
    [anon_sym_LBRACE] = ACTIONS(504),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_assert] = ACTIONS(506),
    [anon_sym_switch] = ACTIONS(506),
    [anon_sym_case] = ACTIONS(506),
    [anon_sym_default] = ACTIONS(506),
    [anon_sym_do] = ACTIONS(506),
    [anon_sym_while] = ACTIONS(506),
    [anon_sym_break] = ACTIONS(506),
    [anon_sym_continue] = ACTIONS(506),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_synchronized] = ACTIONS(506),
    [anon_sym_throw] = ACTIONS(506),
    [anon_sym_try] = ACTIONS(506),
    [anon_sym_catch] = ACTIONS(506),
    [anon_sym_finally] = ACTIONS(506),
    [anon_sym_if] = ACTIONS(506),
    [anon_sym_else] = ACTIONS(506),
    [anon_sym_for] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(506),
    [anon_sym_open] = ACTIONS(506),
    [anon_sym_module] = ACTIONS(506),
    [anon_sym_static] = ACTIONS(506),
    [anon_sym_package] = ACTIONS(506),
    [anon_sym_import] = ACTIONS(506),
    [anon_sym_enum] = ACTIONS(506),
    [anon_sym_public] = ACTIONS(506),
    [anon_sym_protected] = ACTIONS(506),
    [anon_sym_private] = ACTIONS(506),
    [anon_sym_abstract] = ACTIONS(506),
    [anon_sym_final] = ACTIONS(506),
    [anon_sym_strictfp] = ACTIONS(506),
    [anon_sym_native] = ACTIONS(506),
    [anon_sym_transient] = ACTIONS(506),
    [anon_sym_volatile] = ACTIONS(506),
    [anon_sym_ATinterface] = ACTIONS(504),
    [anon_sym_interface] = ACTIONS(506),
    [anon_sym_byte] = ACTIONS(506),
    [anon_sym_short] = ACTIONS(506),
    [anon_sym_int] = ACTIONS(506),
    [anon_sym_long] = ACTIONS(506),
    [anon_sym_char] = ACTIONS(506),
    [anon_sym_float] = ACTIONS(506),
    [anon_sym_double] = ACTIONS(506),
    [sym_boolean_type] = ACTIONS(506),
    [sym_void_type] = ACTIONS(506),
    [sym_this] = ACTIONS(506),
    [sym_super] = ACTIONS(506),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [sym_decimal_integer_literal] = ACTIONS(510),
    [sym_hex_integer_literal] = ACTIONS(510),
    [sym_octal_integer_literal] = ACTIONS(508),
    [sym_binary_integer_literal] = ACTIONS(508),
    [sym_decimal_floating_point_literal] = ACTIONS(508),
    [sym_hex_floating_point_literal] = ACTIONS(510),
    [sym_true] = ACTIONS(510),
    [sym_false] = ACTIONS(510),
    [sym_character_literal] = ACTIONS(508),
    [sym_string_literal] = ACTIONS(508),
    [sym_null_literal] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_LT] = ACTIONS(508),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(508),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_class] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_assert] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_synchronized] = ACTIONS(510),
    [anon_sym_throw] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(510),
    [anon_sym_open] = ACTIONS(510),
    [anon_sym_module] = ACTIONS(510),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_package] = ACTIONS(510),
    [anon_sym_import] = ACTIONS(510),
    [anon_sym_enum] = ACTIONS(510),
    [anon_sym_public] = ACTIONS(510),
    [anon_sym_protected] = ACTIONS(510),
    [anon_sym_private] = ACTIONS(510),
    [anon_sym_abstract] = ACTIONS(510),
    [anon_sym_final] = ACTIONS(510),
    [anon_sym_strictfp] = ACTIONS(510),
    [anon_sym_native] = ACTIONS(510),
    [anon_sym_transient] = ACTIONS(510),
    [anon_sym_volatile] = ACTIONS(510),
    [anon_sym_ATinterface] = ACTIONS(508),
    [anon_sym_interface] = ACTIONS(510),
    [anon_sym_byte] = ACTIONS(510),
    [anon_sym_short] = ACTIONS(510),
    [anon_sym_int] = ACTIONS(510),
    [anon_sym_long] = ACTIONS(510),
    [anon_sym_char] = ACTIONS(510),
    [anon_sym_float] = ACTIONS(510),
    [anon_sym_double] = ACTIONS(510),
    [sym_boolean_type] = ACTIONS(510),
    [sym_void_type] = ACTIONS(510),
    [sym_this] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(512),
    [sym_identifier] = ACTIONS(514),
    [sym_decimal_integer_literal] = ACTIONS(514),
    [sym_hex_integer_literal] = ACTIONS(514),
    [sym_octal_integer_literal] = ACTIONS(512),
    [sym_binary_integer_literal] = ACTIONS(512),
    [sym_decimal_floating_point_literal] = ACTIONS(512),
    [sym_hex_floating_point_literal] = ACTIONS(514),
    [sym_true] = ACTIONS(514),
    [sym_false] = ACTIONS(514),
    [sym_character_literal] = ACTIONS(512),
    [sym_string_literal] = ACTIONS(512),
    [sym_null_literal] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(512),
    [anon_sym_LT] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(514),
    [anon_sym_DASH] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(512),
    [anon_sym_DASH_DASH] = ACTIONS(512),
    [anon_sym_new] = ACTIONS(514),
    [anon_sym_class] = ACTIONS(514),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(512),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_assert] = ACTIONS(514),
    [anon_sym_switch] = ACTIONS(514),
    [anon_sym_case] = ACTIONS(514),
    [anon_sym_default] = ACTIONS(514),
    [anon_sym_do] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(514),
    [anon_sym_break] = ACTIONS(514),
    [anon_sym_continue] = ACTIONS(514),
    [anon_sym_return] = ACTIONS(514),
    [anon_sym_synchronized] = ACTIONS(514),
    [anon_sym_throw] = ACTIONS(514),
    [anon_sym_try] = ACTIONS(514),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_else] = ACTIONS(514),
    [anon_sym_for] = ACTIONS(514),
    [anon_sym_AT] = ACTIONS(514),
    [anon_sym_open] = ACTIONS(514),
    [anon_sym_module] = ACTIONS(514),
    [anon_sym_static] = ACTIONS(514),
    [anon_sym_package] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_enum] = ACTIONS(514),
    [anon_sym_public] = ACTIONS(514),
    [anon_sym_protected] = ACTIONS(514),
    [anon_sym_private] = ACTIONS(514),
    [anon_sym_abstract] = ACTIONS(514),
    [anon_sym_final] = ACTIONS(514),
    [anon_sym_strictfp] = ACTIONS(514),
    [anon_sym_native] = ACTIONS(514),
    [anon_sym_transient] = ACTIONS(514),
    [anon_sym_volatile] = ACTIONS(514),
    [anon_sym_ATinterface] = ACTIONS(512),
    [anon_sym_interface] = ACTIONS(514),
    [anon_sym_byte] = ACTIONS(514),
    [anon_sym_short] = ACTIONS(514),
    [anon_sym_int] = ACTIONS(514),
    [anon_sym_long] = ACTIONS(514),
    [anon_sym_char] = ACTIONS(514),
    [anon_sym_float] = ACTIONS(514),
    [anon_sym_double] = ACTIONS(514),
    [sym_boolean_type] = ACTIONS(514),
    [sym_void_type] = ACTIONS(514),
    [sym_this] = ACTIONS(514),
    [sym_super] = ACTIONS(514),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(516),
    [sym_identifier] = ACTIONS(518),
    [sym_decimal_integer_literal] = ACTIONS(518),
    [sym_hex_integer_literal] = ACTIONS(518),
    [sym_octal_integer_literal] = ACTIONS(516),
    [sym_binary_integer_literal] = ACTIONS(516),
    [sym_decimal_floating_point_literal] = ACTIONS(516),
    [sym_hex_floating_point_literal] = ACTIONS(518),
    [sym_true] = ACTIONS(518),
    [sym_false] = ACTIONS(518),
    [sym_character_literal] = ACTIONS(516),
    [sym_string_literal] = ACTIONS(516),
    [sym_null_literal] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(516),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(518),
    [anon_sym_DASH] = ACTIONS(518),
    [anon_sym_BANG] = ACTIONS(516),
    [anon_sym_TILDE] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(516),
    [anon_sym_DASH_DASH] = ACTIONS(516),
    [anon_sym_new] = ACTIONS(518),
    [anon_sym_class] = ACTIONS(518),
    [anon_sym_SEMI] = ACTIONS(516),
    [anon_sym_LBRACE] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_assert] = ACTIONS(518),
    [anon_sym_switch] = ACTIONS(518),
    [anon_sym_case] = ACTIONS(518),
    [anon_sym_default] = ACTIONS(518),
    [anon_sym_do] = ACTIONS(518),
    [anon_sym_while] = ACTIONS(518),
    [anon_sym_break] = ACTIONS(518),
    [anon_sym_continue] = ACTIONS(518),
    [anon_sym_return] = ACTIONS(518),
    [anon_sym_synchronized] = ACTIONS(518),
    [anon_sym_throw] = ACTIONS(518),
    [anon_sym_try] = ACTIONS(518),
    [anon_sym_if] = ACTIONS(518),
    [anon_sym_else] = ACTIONS(518),
    [anon_sym_for] = ACTIONS(518),
    [anon_sym_AT] = ACTIONS(518),
    [anon_sym_open] = ACTIONS(518),
    [anon_sym_module] = ACTIONS(518),
    [anon_sym_static] = ACTIONS(518),
    [anon_sym_package] = ACTIONS(518),
    [anon_sym_import] = ACTIONS(518),
    [anon_sym_enum] = ACTIONS(518),
    [anon_sym_public] = ACTIONS(518),
    [anon_sym_protected] = ACTIONS(518),
    [anon_sym_private] = ACTIONS(518),
    [anon_sym_abstract] = ACTIONS(518),
    [anon_sym_final] = ACTIONS(518),
    [anon_sym_strictfp] = ACTIONS(518),
    [anon_sym_native] = ACTIONS(518),
    [anon_sym_transient] = ACTIONS(518),
    [anon_sym_volatile] = ACTIONS(518),
    [anon_sym_ATinterface] = ACTIONS(516),
    [anon_sym_interface] = ACTIONS(518),
    [anon_sym_byte] = ACTIONS(518),
    [anon_sym_short] = ACTIONS(518),
    [anon_sym_int] = ACTIONS(518),
    [anon_sym_long] = ACTIONS(518),
    [anon_sym_char] = ACTIONS(518),
    [anon_sym_float] = ACTIONS(518),
    [anon_sym_double] = ACTIONS(518),
    [sym_boolean_type] = ACTIONS(518),
    [sym_void_type] = ACTIONS(518),
    [sym_this] = ACTIONS(518),
    [sym_super] = ACTIONS(518),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(520),
    [sym_identifier] = ACTIONS(522),
    [sym_decimal_integer_literal] = ACTIONS(522),
    [sym_hex_integer_literal] = ACTIONS(522),
    [sym_octal_integer_literal] = ACTIONS(520),
    [sym_binary_integer_literal] = ACTIONS(520),
    [sym_decimal_floating_point_literal] = ACTIONS(520),
    [sym_hex_floating_point_literal] = ACTIONS(522),
    [sym_true] = ACTIONS(522),
    [sym_false] = ACTIONS(522),
    [sym_character_literal] = ACTIONS(520),
    [sym_string_literal] = ACTIONS(520),
    [sym_null_literal] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(520),
    [anon_sym_LT] = ACTIONS(520),
    [anon_sym_PLUS] = ACTIONS(522),
    [anon_sym_DASH] = ACTIONS(522),
    [anon_sym_BANG] = ACTIONS(520),
    [anon_sym_TILDE] = ACTIONS(520),
    [anon_sym_PLUS_PLUS] = ACTIONS(520),
    [anon_sym_DASH_DASH] = ACTIONS(520),
    [anon_sym_new] = ACTIONS(522),
    [anon_sym_class] = ACTIONS(522),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_LBRACE] = ACTIONS(520),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_assert] = ACTIONS(522),
    [anon_sym_switch] = ACTIONS(522),
    [anon_sym_case] = ACTIONS(522),
    [anon_sym_default] = ACTIONS(522),
    [anon_sym_do] = ACTIONS(522),
    [anon_sym_while] = ACTIONS(522),
    [anon_sym_break] = ACTIONS(522),
    [anon_sym_continue] = ACTIONS(522),
    [anon_sym_return] = ACTIONS(522),
    [anon_sym_synchronized] = ACTIONS(522),
    [anon_sym_throw] = ACTIONS(522),
    [anon_sym_try] = ACTIONS(522),
    [anon_sym_if] = ACTIONS(522),
    [anon_sym_else] = ACTIONS(522),
    [anon_sym_for] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(522),
    [anon_sym_open] = ACTIONS(522),
    [anon_sym_module] = ACTIONS(522),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_package] = ACTIONS(522),
    [anon_sym_import] = ACTIONS(522),
    [anon_sym_enum] = ACTIONS(522),
    [anon_sym_public] = ACTIONS(522),
    [anon_sym_protected] = ACTIONS(522),
    [anon_sym_private] = ACTIONS(522),
    [anon_sym_abstract] = ACTIONS(522),
    [anon_sym_final] = ACTIONS(522),
    [anon_sym_strictfp] = ACTIONS(522),
    [anon_sym_native] = ACTIONS(522),
    [anon_sym_transient] = ACTIONS(522),
    [anon_sym_volatile] = ACTIONS(522),
    [anon_sym_ATinterface] = ACTIONS(520),
    [anon_sym_interface] = ACTIONS(522),
    [anon_sym_byte] = ACTIONS(522),
    [anon_sym_short] = ACTIONS(522),
    [anon_sym_int] = ACTIONS(522),
    [anon_sym_long] = ACTIONS(522),
    [anon_sym_char] = ACTIONS(522),
    [anon_sym_float] = ACTIONS(522),
    [anon_sym_double] = ACTIONS(522),
    [sym_boolean_type] = ACTIONS(522),
    [sym_void_type] = ACTIONS(522),
    [sym_this] = ACTIONS(522),
    [sym_super] = ACTIONS(522),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(524),
    [sym_identifier] = ACTIONS(526),
    [sym_decimal_integer_literal] = ACTIONS(526),
    [sym_hex_integer_literal] = ACTIONS(526),
    [sym_octal_integer_literal] = ACTIONS(524),
    [sym_binary_integer_literal] = ACTIONS(524),
    [sym_decimal_floating_point_literal] = ACTIONS(524),
    [sym_hex_floating_point_literal] = ACTIONS(526),
    [sym_true] = ACTIONS(526),
    [sym_false] = ACTIONS(526),
    [sym_character_literal] = ACTIONS(524),
    [sym_string_literal] = ACTIONS(524),
    [sym_null_literal] = ACTIONS(526),
    [anon_sym_LPAREN] = ACTIONS(524),
    [anon_sym_LT] = ACTIONS(524),
    [anon_sym_PLUS] = ACTIONS(526),
    [anon_sym_DASH] = ACTIONS(526),
    [anon_sym_BANG] = ACTIONS(524),
    [anon_sym_TILDE] = ACTIONS(524),
    [anon_sym_PLUS_PLUS] = ACTIONS(524),
    [anon_sym_DASH_DASH] = ACTIONS(524),
    [anon_sym_new] = ACTIONS(526),
    [anon_sym_class] = ACTIONS(526),
    [anon_sym_SEMI] = ACTIONS(524),
    [anon_sym_LBRACE] = ACTIONS(524),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_assert] = ACTIONS(526),
    [anon_sym_switch] = ACTIONS(526),
    [anon_sym_case] = ACTIONS(526),
    [anon_sym_default] = ACTIONS(526),
    [anon_sym_do] = ACTIONS(526),
    [anon_sym_while] = ACTIONS(526),
    [anon_sym_break] = ACTIONS(526),
    [anon_sym_continue] = ACTIONS(526),
    [anon_sym_return] = ACTIONS(526),
    [anon_sym_synchronized] = ACTIONS(526),
    [anon_sym_throw] = ACTIONS(526),
    [anon_sym_try] = ACTIONS(526),
    [anon_sym_if] = ACTIONS(526),
    [anon_sym_else] = ACTIONS(526),
    [anon_sym_for] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(526),
    [anon_sym_open] = ACTIONS(526),
    [anon_sym_module] = ACTIONS(526),
    [anon_sym_static] = ACTIONS(526),
    [anon_sym_package] = ACTIONS(526),
    [anon_sym_import] = ACTIONS(526),
    [anon_sym_enum] = ACTIONS(526),
    [anon_sym_public] = ACTIONS(526),
    [anon_sym_protected] = ACTIONS(526),
    [anon_sym_private] = ACTIONS(526),
    [anon_sym_abstract] = ACTIONS(526),
    [anon_sym_final] = ACTIONS(526),
    [anon_sym_strictfp] = ACTIONS(526),
    [anon_sym_native] = ACTIONS(526),
    [anon_sym_transient] = ACTIONS(526),
    [anon_sym_volatile] = ACTIONS(526),
    [anon_sym_ATinterface] = ACTIONS(524),
    [anon_sym_interface] = ACTIONS(526),
    [anon_sym_byte] = ACTIONS(526),
    [anon_sym_short] = ACTIONS(526),
    [anon_sym_int] = ACTIONS(526),
    [anon_sym_long] = ACTIONS(526),
    [anon_sym_char] = ACTIONS(526),
    [anon_sym_float] = ACTIONS(526),
    [anon_sym_double] = ACTIONS(526),
    [sym_boolean_type] = ACTIONS(526),
    [sym_void_type] = ACTIONS(526),
    [sym_this] = ACTIONS(526),
    [sym_super] = ACTIONS(526),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(528),
    [sym_identifier] = ACTIONS(530),
    [sym_decimal_integer_literal] = ACTIONS(530),
    [sym_hex_integer_literal] = ACTIONS(530),
    [sym_octal_integer_literal] = ACTIONS(528),
    [sym_binary_integer_literal] = ACTIONS(528),
    [sym_decimal_floating_point_literal] = ACTIONS(528),
    [sym_hex_floating_point_literal] = ACTIONS(530),
    [sym_true] = ACTIONS(530),
    [sym_false] = ACTIONS(530),
    [sym_character_literal] = ACTIONS(528),
    [sym_string_literal] = ACTIONS(528),
    [sym_null_literal] = ACTIONS(530),
    [anon_sym_LPAREN] = ACTIONS(528),
    [anon_sym_LT] = ACTIONS(528),
    [anon_sym_PLUS] = ACTIONS(530),
    [anon_sym_DASH] = ACTIONS(530),
    [anon_sym_BANG] = ACTIONS(528),
    [anon_sym_TILDE] = ACTIONS(528),
    [anon_sym_PLUS_PLUS] = ACTIONS(528),
    [anon_sym_DASH_DASH] = ACTIONS(528),
    [anon_sym_new] = ACTIONS(530),
    [anon_sym_class] = ACTIONS(530),
    [anon_sym_SEMI] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(528),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_assert] = ACTIONS(530),
    [anon_sym_switch] = ACTIONS(530),
    [anon_sym_case] = ACTIONS(530),
    [anon_sym_default] = ACTIONS(530),
    [anon_sym_do] = ACTIONS(530),
    [anon_sym_while] = ACTIONS(530),
    [anon_sym_break] = ACTIONS(530),
    [anon_sym_continue] = ACTIONS(530),
    [anon_sym_return] = ACTIONS(530),
    [anon_sym_synchronized] = ACTIONS(530),
    [anon_sym_throw] = ACTIONS(530),
    [anon_sym_try] = ACTIONS(530),
    [anon_sym_if] = ACTIONS(530),
    [anon_sym_else] = ACTIONS(530),
    [anon_sym_for] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(530),
    [anon_sym_open] = ACTIONS(530),
    [anon_sym_module] = ACTIONS(530),
    [anon_sym_static] = ACTIONS(530),
    [anon_sym_package] = ACTIONS(530),
    [anon_sym_import] = ACTIONS(530),
    [anon_sym_enum] = ACTIONS(530),
    [anon_sym_public] = ACTIONS(530),
    [anon_sym_protected] = ACTIONS(530),
    [anon_sym_private] = ACTIONS(530),
    [anon_sym_abstract] = ACTIONS(530),
    [anon_sym_final] = ACTIONS(530),
    [anon_sym_strictfp] = ACTIONS(530),
    [anon_sym_native] = ACTIONS(530),
    [anon_sym_transient] = ACTIONS(530),
    [anon_sym_volatile] = ACTIONS(530),
    [anon_sym_ATinterface] = ACTIONS(528),
    [anon_sym_interface] = ACTIONS(530),
    [anon_sym_byte] = ACTIONS(530),
    [anon_sym_short] = ACTIONS(530),
    [anon_sym_int] = ACTIONS(530),
    [anon_sym_long] = ACTIONS(530),
    [anon_sym_char] = ACTIONS(530),
    [anon_sym_float] = ACTIONS(530),
    [anon_sym_double] = ACTIONS(530),
    [sym_boolean_type] = ACTIONS(530),
    [sym_void_type] = ACTIONS(530),
    [sym_this] = ACTIONS(530),
    [sym_super] = ACTIONS(530),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(532),
    [sym_identifier] = ACTIONS(534),
    [sym_decimal_integer_literal] = ACTIONS(534),
    [sym_hex_integer_literal] = ACTIONS(534),
    [sym_octal_integer_literal] = ACTIONS(532),
    [sym_binary_integer_literal] = ACTIONS(532),
    [sym_decimal_floating_point_literal] = ACTIONS(532),
    [sym_hex_floating_point_literal] = ACTIONS(534),
    [sym_true] = ACTIONS(534),
    [sym_false] = ACTIONS(534),
    [sym_character_literal] = ACTIONS(532),
    [sym_string_literal] = ACTIONS(532),
    [sym_null_literal] = ACTIONS(534),
    [anon_sym_LPAREN] = ACTIONS(532),
    [anon_sym_LT] = ACTIONS(532),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_BANG] = ACTIONS(532),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_PLUS_PLUS] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(532),
    [anon_sym_new] = ACTIONS(534),
    [anon_sym_class] = ACTIONS(534),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_LBRACE] = ACTIONS(532),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_assert] = ACTIONS(534),
    [anon_sym_switch] = ACTIONS(534),
    [anon_sym_case] = ACTIONS(534),
    [anon_sym_default] = ACTIONS(534),
    [anon_sym_do] = ACTIONS(534),
    [anon_sym_while] = ACTIONS(534),
    [anon_sym_break] = ACTIONS(534),
    [anon_sym_continue] = ACTIONS(534),
    [anon_sym_return] = ACTIONS(534),
    [anon_sym_synchronized] = ACTIONS(534),
    [anon_sym_throw] = ACTIONS(534),
    [anon_sym_try] = ACTIONS(534),
    [anon_sym_if] = ACTIONS(534),
    [anon_sym_else] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(534),
    [anon_sym_AT] = ACTIONS(534),
    [anon_sym_open] = ACTIONS(534),
    [anon_sym_module] = ACTIONS(534),
    [anon_sym_static] = ACTIONS(534),
    [anon_sym_package] = ACTIONS(534),
    [anon_sym_import] = ACTIONS(534),
    [anon_sym_enum] = ACTIONS(534),
    [anon_sym_public] = ACTIONS(534),
    [anon_sym_protected] = ACTIONS(534),
    [anon_sym_private] = ACTIONS(534),
    [anon_sym_abstract] = ACTIONS(534),
    [anon_sym_final] = ACTIONS(534),
    [anon_sym_strictfp] = ACTIONS(534),
    [anon_sym_native] = ACTIONS(534),
    [anon_sym_transient] = ACTIONS(534),
    [anon_sym_volatile] = ACTIONS(534),
    [anon_sym_ATinterface] = ACTIONS(532),
    [anon_sym_interface] = ACTIONS(534),
    [anon_sym_byte] = ACTIONS(534),
    [anon_sym_short] = ACTIONS(534),
    [anon_sym_int] = ACTIONS(534),
    [anon_sym_long] = ACTIONS(534),
    [anon_sym_char] = ACTIONS(534),
    [anon_sym_float] = ACTIONS(534),
    [anon_sym_double] = ACTIONS(534),
    [sym_boolean_type] = ACTIONS(534),
    [sym_void_type] = ACTIONS(534),
    [sym_this] = ACTIONS(534),
    [sym_super] = ACTIONS(534),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(536),
    [sym_identifier] = ACTIONS(538),
    [sym_decimal_integer_literal] = ACTIONS(538),
    [sym_hex_integer_literal] = ACTIONS(538),
    [sym_octal_integer_literal] = ACTIONS(536),
    [sym_binary_integer_literal] = ACTIONS(536),
    [sym_decimal_floating_point_literal] = ACTIONS(536),
    [sym_hex_floating_point_literal] = ACTIONS(538),
    [sym_true] = ACTIONS(538),
    [sym_false] = ACTIONS(538),
    [sym_character_literal] = ACTIONS(536),
    [sym_string_literal] = ACTIONS(536),
    [sym_null_literal] = ACTIONS(538),
    [anon_sym_LPAREN] = ACTIONS(536),
    [anon_sym_LT] = ACTIONS(536),
    [anon_sym_PLUS] = ACTIONS(538),
    [anon_sym_DASH] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(536),
    [anon_sym_PLUS_PLUS] = ACTIONS(536),
    [anon_sym_DASH_DASH] = ACTIONS(536),
    [anon_sym_new] = ACTIONS(538),
    [anon_sym_class] = ACTIONS(538),
    [anon_sym_SEMI] = ACTIONS(536),
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_assert] = ACTIONS(538),
    [anon_sym_switch] = ACTIONS(538),
    [anon_sym_case] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(538),
    [anon_sym_do] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(538),
    [anon_sym_break] = ACTIONS(538),
    [anon_sym_continue] = ACTIONS(538),
    [anon_sym_return] = ACTIONS(538),
    [anon_sym_synchronized] = ACTIONS(538),
    [anon_sym_throw] = ACTIONS(538),
    [anon_sym_try] = ACTIONS(538),
    [anon_sym_if] = ACTIONS(538),
    [anon_sym_else] = ACTIONS(538),
    [anon_sym_for] = ACTIONS(538),
    [anon_sym_AT] = ACTIONS(538),
    [anon_sym_open] = ACTIONS(538),
    [anon_sym_module] = ACTIONS(538),
    [anon_sym_static] = ACTIONS(538),
    [anon_sym_package] = ACTIONS(538),
    [anon_sym_import] = ACTIONS(538),
    [anon_sym_enum] = ACTIONS(538),
    [anon_sym_public] = ACTIONS(538),
    [anon_sym_protected] = ACTIONS(538),
    [anon_sym_private] = ACTIONS(538),
    [anon_sym_abstract] = ACTIONS(538),
    [anon_sym_final] = ACTIONS(538),
    [anon_sym_strictfp] = ACTIONS(538),
    [anon_sym_native] = ACTIONS(538),
    [anon_sym_transient] = ACTIONS(538),
    [anon_sym_volatile] = ACTIONS(538),
    [anon_sym_ATinterface] = ACTIONS(536),
    [anon_sym_interface] = ACTIONS(538),
    [anon_sym_byte] = ACTIONS(538),
    [anon_sym_short] = ACTIONS(538),
    [anon_sym_int] = ACTIONS(538),
    [anon_sym_long] = ACTIONS(538),
    [anon_sym_char] = ACTIONS(538),
    [anon_sym_float] = ACTIONS(538),
    [anon_sym_double] = ACTIONS(538),
    [sym_boolean_type] = ACTIONS(538),
    [sym_void_type] = ACTIONS(538),
    [sym_this] = ACTIONS(538),
    [sym_super] = ACTIONS(538),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(540),
    [sym_identifier] = ACTIONS(542),
    [sym_decimal_integer_literal] = ACTIONS(542),
    [sym_hex_integer_literal] = ACTIONS(542),
    [sym_octal_integer_literal] = ACTIONS(540),
    [sym_binary_integer_literal] = ACTIONS(540),
    [sym_decimal_floating_point_literal] = ACTIONS(540),
    [sym_hex_floating_point_literal] = ACTIONS(542),
    [sym_true] = ACTIONS(542),
    [sym_false] = ACTIONS(542),
    [sym_character_literal] = ACTIONS(540),
    [sym_string_literal] = ACTIONS(540),
    [sym_null_literal] = ACTIONS(542),
    [anon_sym_LPAREN] = ACTIONS(540),
    [anon_sym_LT] = ACTIONS(540),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(540),
    [anon_sym_TILDE] = ACTIONS(540),
    [anon_sym_PLUS_PLUS] = ACTIONS(540),
    [anon_sym_DASH_DASH] = ACTIONS(540),
    [anon_sym_new] = ACTIONS(542),
    [anon_sym_class] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(540),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_assert] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(542),
    [anon_sym_case] = ACTIONS(542),
    [anon_sym_default] = ACTIONS(542),
    [anon_sym_do] = ACTIONS(542),
    [anon_sym_while] = ACTIONS(542),
    [anon_sym_break] = ACTIONS(542),
    [anon_sym_continue] = ACTIONS(542),
    [anon_sym_return] = ACTIONS(542),
    [anon_sym_synchronized] = ACTIONS(542),
    [anon_sym_throw] = ACTIONS(542),
    [anon_sym_try] = ACTIONS(542),
    [anon_sym_if] = ACTIONS(542),
    [anon_sym_else] = ACTIONS(542),
    [anon_sym_for] = ACTIONS(542),
    [anon_sym_AT] = ACTIONS(542),
    [anon_sym_open] = ACTIONS(542),
    [anon_sym_module] = ACTIONS(542),
    [anon_sym_static] = ACTIONS(542),
    [anon_sym_package] = ACTIONS(542),
    [anon_sym_import] = ACTIONS(542),
    [anon_sym_enum] = ACTIONS(542),
    [anon_sym_public] = ACTIONS(542),
    [anon_sym_protected] = ACTIONS(542),
    [anon_sym_private] = ACTIONS(542),
    [anon_sym_abstract] = ACTIONS(542),
    [anon_sym_final] = ACTIONS(542),
    [anon_sym_strictfp] = ACTIONS(542),
    [anon_sym_native] = ACTIONS(542),
    [anon_sym_transient] = ACTIONS(542),
    [anon_sym_volatile] = ACTIONS(542),
    [anon_sym_ATinterface] = ACTIONS(540),
    [anon_sym_interface] = ACTIONS(542),
    [anon_sym_byte] = ACTIONS(542),
    [anon_sym_short] = ACTIONS(542),
    [anon_sym_int] = ACTIONS(542),
    [anon_sym_long] = ACTIONS(542),
    [anon_sym_char] = ACTIONS(542),
    [anon_sym_float] = ACTIONS(542),
    [anon_sym_double] = ACTIONS(542),
    [sym_boolean_type] = ACTIONS(542),
    [sym_void_type] = ACTIONS(542),
    [sym_this] = ACTIONS(542),
    [sym_super] = ACTIONS(542),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(544),
    [sym_identifier] = ACTIONS(546),
    [sym_decimal_integer_literal] = ACTIONS(546),
    [sym_hex_integer_literal] = ACTIONS(546),
    [sym_octal_integer_literal] = ACTIONS(544),
    [sym_binary_integer_literal] = ACTIONS(544),
    [sym_decimal_floating_point_literal] = ACTIONS(544),
    [sym_hex_floating_point_literal] = ACTIONS(546),
    [sym_true] = ACTIONS(546),
    [sym_false] = ACTIONS(546),
    [sym_character_literal] = ACTIONS(544),
    [sym_string_literal] = ACTIONS(544),
    [sym_null_literal] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(544),
    [anon_sym_LT] = ACTIONS(544),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(544),
    [anon_sym_TILDE] = ACTIONS(544),
    [anon_sym_PLUS_PLUS] = ACTIONS(544),
    [anon_sym_DASH_DASH] = ACTIONS(544),
    [anon_sym_new] = ACTIONS(546),
    [anon_sym_class] = ACTIONS(546),
    [anon_sym_SEMI] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(544),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_assert] = ACTIONS(546),
    [anon_sym_switch] = ACTIONS(546),
    [anon_sym_case] = ACTIONS(546),
    [anon_sym_default] = ACTIONS(546),
    [anon_sym_do] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(546),
    [anon_sym_break] = ACTIONS(546),
    [anon_sym_continue] = ACTIONS(546),
    [anon_sym_return] = ACTIONS(546),
    [anon_sym_synchronized] = ACTIONS(546),
    [anon_sym_throw] = ACTIONS(546),
    [anon_sym_try] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_else] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_AT] = ACTIONS(546),
    [anon_sym_open] = ACTIONS(546),
    [anon_sym_module] = ACTIONS(546),
    [anon_sym_static] = ACTIONS(546),
    [anon_sym_package] = ACTIONS(546),
    [anon_sym_import] = ACTIONS(546),
    [anon_sym_enum] = ACTIONS(546),
    [anon_sym_public] = ACTIONS(546),
    [anon_sym_protected] = ACTIONS(546),
    [anon_sym_private] = ACTIONS(546),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_final] = ACTIONS(546),
    [anon_sym_strictfp] = ACTIONS(546),
    [anon_sym_native] = ACTIONS(546),
    [anon_sym_transient] = ACTIONS(546),
    [anon_sym_volatile] = ACTIONS(546),
    [anon_sym_ATinterface] = ACTIONS(544),
    [anon_sym_interface] = ACTIONS(546),
    [anon_sym_byte] = ACTIONS(546),
    [anon_sym_short] = ACTIONS(546),
    [anon_sym_int] = ACTIONS(546),
    [anon_sym_long] = ACTIONS(546),
    [anon_sym_char] = ACTIONS(546),
    [anon_sym_float] = ACTIONS(546),
    [anon_sym_double] = ACTIONS(546),
    [sym_boolean_type] = ACTIONS(546),
    [sym_void_type] = ACTIONS(546),
    [sym_this] = ACTIONS(546),
    [sym_super] = ACTIONS(546),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(548),
    [sym_identifier] = ACTIONS(550),
    [sym_decimal_integer_literal] = ACTIONS(550),
    [sym_hex_integer_literal] = ACTIONS(550),
    [sym_octal_integer_literal] = ACTIONS(548),
    [sym_binary_integer_literal] = ACTIONS(548),
    [sym_decimal_floating_point_literal] = ACTIONS(548),
    [sym_hex_floating_point_literal] = ACTIONS(550),
    [sym_true] = ACTIONS(550),
    [sym_false] = ACTIONS(550),
    [sym_character_literal] = ACTIONS(548),
    [sym_string_literal] = ACTIONS(548),
    [sym_null_literal] = ACTIONS(550),
    [anon_sym_LPAREN] = ACTIONS(548),
    [anon_sym_LT] = ACTIONS(548),
    [anon_sym_PLUS] = ACTIONS(550),
    [anon_sym_DASH] = ACTIONS(550),
    [anon_sym_BANG] = ACTIONS(548),
    [anon_sym_TILDE] = ACTIONS(548),
    [anon_sym_PLUS_PLUS] = ACTIONS(548),
    [anon_sym_DASH_DASH] = ACTIONS(548),
    [anon_sym_new] = ACTIONS(550),
    [anon_sym_class] = ACTIONS(550),
    [anon_sym_SEMI] = ACTIONS(548),
    [anon_sym_LBRACE] = ACTIONS(548),
    [anon_sym_RBRACE] = ACTIONS(548),
    [anon_sym_assert] = ACTIONS(550),
    [anon_sym_switch] = ACTIONS(550),
    [anon_sym_case] = ACTIONS(550),
    [anon_sym_default] = ACTIONS(550),
    [anon_sym_do] = ACTIONS(550),
    [anon_sym_while] = ACTIONS(550),
    [anon_sym_break] = ACTIONS(550),
    [anon_sym_continue] = ACTIONS(550),
    [anon_sym_return] = ACTIONS(550),
    [anon_sym_synchronized] = ACTIONS(550),
    [anon_sym_throw] = ACTIONS(550),
    [anon_sym_try] = ACTIONS(550),
    [anon_sym_if] = ACTIONS(550),
    [anon_sym_else] = ACTIONS(550),
    [anon_sym_for] = ACTIONS(550),
    [anon_sym_AT] = ACTIONS(550),
    [anon_sym_open] = ACTIONS(550),
    [anon_sym_module] = ACTIONS(550),
    [anon_sym_static] = ACTIONS(550),
    [anon_sym_package] = ACTIONS(550),
    [anon_sym_import] = ACTIONS(550),
    [anon_sym_enum] = ACTIONS(550),
    [anon_sym_public] = ACTIONS(550),
    [anon_sym_protected] = ACTIONS(550),
    [anon_sym_private] = ACTIONS(550),
    [anon_sym_abstract] = ACTIONS(550),
    [anon_sym_final] = ACTIONS(550),
    [anon_sym_strictfp] = ACTIONS(550),
    [anon_sym_native] = ACTIONS(550),
    [anon_sym_transient] = ACTIONS(550),
    [anon_sym_volatile] = ACTIONS(550),
    [anon_sym_ATinterface] = ACTIONS(548),
    [anon_sym_interface] = ACTIONS(550),
    [anon_sym_byte] = ACTIONS(550),
    [anon_sym_short] = ACTIONS(550),
    [anon_sym_int] = ACTIONS(550),
    [anon_sym_long] = ACTIONS(550),
    [anon_sym_char] = ACTIONS(550),
    [anon_sym_float] = ACTIONS(550),
    [anon_sym_double] = ACTIONS(550),
    [sym_boolean_type] = ACTIONS(550),
    [sym_void_type] = ACTIONS(550),
    [sym_this] = ACTIONS(550),
    [sym_super] = ACTIONS(550),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(552),
    [sym_identifier] = ACTIONS(554),
    [sym_decimal_integer_literal] = ACTIONS(554),
    [sym_hex_integer_literal] = ACTIONS(554),
    [sym_octal_integer_literal] = ACTIONS(552),
    [sym_binary_integer_literal] = ACTIONS(552),
    [sym_decimal_floating_point_literal] = ACTIONS(552),
    [sym_hex_floating_point_literal] = ACTIONS(554),
    [sym_true] = ACTIONS(554),
    [sym_false] = ACTIONS(554),
    [sym_character_literal] = ACTIONS(552),
    [sym_string_literal] = ACTIONS(552),
    [sym_null_literal] = ACTIONS(554),
    [anon_sym_LPAREN] = ACTIONS(552),
    [anon_sym_LT] = ACTIONS(552),
    [anon_sym_PLUS] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(554),
    [anon_sym_BANG] = ACTIONS(552),
    [anon_sym_TILDE] = ACTIONS(552),
    [anon_sym_PLUS_PLUS] = ACTIONS(552),
    [anon_sym_DASH_DASH] = ACTIONS(552),
    [anon_sym_new] = ACTIONS(554),
    [anon_sym_class] = ACTIONS(554),
    [anon_sym_SEMI] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(552),
    [anon_sym_assert] = ACTIONS(554),
    [anon_sym_switch] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(554),
    [anon_sym_default] = ACTIONS(554),
    [anon_sym_do] = ACTIONS(554),
    [anon_sym_while] = ACTIONS(554),
    [anon_sym_break] = ACTIONS(554),
    [anon_sym_continue] = ACTIONS(554),
    [anon_sym_return] = ACTIONS(554),
    [anon_sym_synchronized] = ACTIONS(554),
    [anon_sym_throw] = ACTIONS(554),
    [anon_sym_try] = ACTIONS(554),
    [anon_sym_if] = ACTIONS(554),
    [anon_sym_else] = ACTIONS(554),
    [anon_sym_for] = ACTIONS(554),
    [anon_sym_AT] = ACTIONS(554),
    [anon_sym_open] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(554),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_package] = ACTIONS(554),
    [anon_sym_import] = ACTIONS(554),
    [anon_sym_enum] = ACTIONS(554),
    [anon_sym_public] = ACTIONS(554),
    [anon_sym_protected] = ACTIONS(554),
    [anon_sym_private] = ACTIONS(554),
    [anon_sym_abstract] = ACTIONS(554),
    [anon_sym_final] = ACTIONS(554),
    [anon_sym_strictfp] = ACTIONS(554),
    [anon_sym_native] = ACTIONS(554),
    [anon_sym_transient] = ACTIONS(554),
    [anon_sym_volatile] = ACTIONS(554),
    [anon_sym_ATinterface] = ACTIONS(552),
    [anon_sym_interface] = ACTIONS(554),
    [anon_sym_byte] = ACTIONS(554),
    [anon_sym_short] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_long] = ACTIONS(554),
    [anon_sym_char] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_double] = ACTIONS(554),
    [sym_boolean_type] = ACTIONS(554),
    [sym_void_type] = ACTIONS(554),
    [sym_this] = ACTIONS(554),
    [sym_super] = ACTIONS(554),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(556),
    [sym_identifier] = ACTIONS(558),
    [sym_decimal_integer_literal] = ACTIONS(558),
    [sym_hex_integer_literal] = ACTIONS(558),
    [sym_octal_integer_literal] = ACTIONS(556),
    [sym_binary_integer_literal] = ACTIONS(556),
    [sym_decimal_floating_point_literal] = ACTIONS(556),
    [sym_hex_floating_point_literal] = ACTIONS(558),
    [sym_true] = ACTIONS(558),
    [sym_false] = ACTIONS(558),
    [sym_character_literal] = ACTIONS(556),
    [sym_string_literal] = ACTIONS(556),
    [sym_null_literal] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(556),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(558),
    [anon_sym_DASH] = ACTIONS(558),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_TILDE] = ACTIONS(556),
    [anon_sym_PLUS_PLUS] = ACTIONS(556),
    [anon_sym_DASH_DASH] = ACTIONS(556),
    [anon_sym_new] = ACTIONS(558),
    [anon_sym_class] = ACTIONS(558),
    [anon_sym_SEMI] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(556),
    [anon_sym_RBRACE] = ACTIONS(556),
    [anon_sym_assert] = ACTIONS(558),
    [anon_sym_switch] = ACTIONS(558),
    [anon_sym_case] = ACTIONS(558),
    [anon_sym_default] = ACTIONS(558),
    [anon_sym_do] = ACTIONS(558),
    [anon_sym_while] = ACTIONS(558),
    [anon_sym_break] = ACTIONS(558),
    [anon_sym_continue] = ACTIONS(558),
    [anon_sym_return] = ACTIONS(558),
    [anon_sym_synchronized] = ACTIONS(558),
    [anon_sym_throw] = ACTIONS(558),
    [anon_sym_try] = ACTIONS(558),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_else] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(558),
    [anon_sym_AT] = ACTIONS(558),
    [anon_sym_open] = ACTIONS(558),
    [anon_sym_module] = ACTIONS(558),
    [anon_sym_static] = ACTIONS(558),
    [anon_sym_package] = ACTIONS(558),
    [anon_sym_import] = ACTIONS(558),
    [anon_sym_enum] = ACTIONS(558),
    [anon_sym_public] = ACTIONS(558),
    [anon_sym_protected] = ACTIONS(558),
    [anon_sym_private] = ACTIONS(558),
    [anon_sym_abstract] = ACTIONS(558),
    [anon_sym_final] = ACTIONS(558),
    [anon_sym_strictfp] = ACTIONS(558),
    [anon_sym_native] = ACTIONS(558),
    [anon_sym_transient] = ACTIONS(558),
    [anon_sym_volatile] = ACTIONS(558),
    [anon_sym_ATinterface] = ACTIONS(556),
    [anon_sym_interface] = ACTIONS(558),
    [anon_sym_byte] = ACTIONS(558),
    [anon_sym_short] = ACTIONS(558),
    [anon_sym_int] = ACTIONS(558),
    [anon_sym_long] = ACTIONS(558),
    [anon_sym_char] = ACTIONS(558),
    [anon_sym_float] = ACTIONS(558),
    [anon_sym_double] = ACTIONS(558),
    [sym_boolean_type] = ACTIONS(558),
    [sym_void_type] = ACTIONS(558),
    [sym_this] = ACTIONS(558),
    [sym_super] = ACTIONS(558),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(417),
    [sym_cast_expression] = STATE(417),
    [sym_assignment_expression] = STATE(417),
    [sym_binary_expression] = STATE(417),
    [sym_instanceof_expression] = STATE(417),
    [sym_lambda_expression] = STATE(417),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(417),
    [sym_unary_expression] = STATE(417),
    [sym_update_expression] = STATE(417),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym_array_initializer] = STATE(761),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(560),
    [sym_identifier] = ACTIONS(562),
    [sym_decimal_integer_literal] = ACTIONS(562),
    [sym_hex_integer_literal] = ACTIONS(562),
    [sym_octal_integer_literal] = ACTIONS(560),
    [sym_binary_integer_literal] = ACTIONS(560),
    [sym_decimal_floating_point_literal] = ACTIONS(560),
    [sym_hex_floating_point_literal] = ACTIONS(562),
    [sym_true] = ACTIONS(562),
    [sym_false] = ACTIONS(562),
    [sym_character_literal] = ACTIONS(560),
    [sym_string_literal] = ACTIONS(560),
    [sym_null_literal] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(560),
    [anon_sym_PLUS] = ACTIONS(562),
    [anon_sym_DASH] = ACTIONS(562),
    [anon_sym_BANG] = ACTIONS(560),
    [anon_sym_TILDE] = ACTIONS(560),
    [anon_sym_PLUS_PLUS] = ACTIONS(560),
    [anon_sym_DASH_DASH] = ACTIONS(560),
    [anon_sym_new] = ACTIONS(562),
    [anon_sym_class] = ACTIONS(562),
    [anon_sym_SEMI] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_RBRACE] = ACTIONS(560),
    [anon_sym_assert] = ACTIONS(562),
    [anon_sym_switch] = ACTIONS(562),
    [anon_sym_case] = ACTIONS(562),
    [anon_sym_default] = ACTIONS(562),
    [anon_sym_do] = ACTIONS(562),
    [anon_sym_while] = ACTIONS(562),
    [anon_sym_break] = ACTIONS(562),
    [anon_sym_continue] = ACTIONS(562),
    [anon_sym_return] = ACTIONS(562),
    [anon_sym_synchronized] = ACTIONS(562),
    [anon_sym_throw] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(562),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_else] = ACTIONS(562),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_AT] = ACTIONS(562),
    [anon_sym_open] = ACTIONS(562),
    [anon_sym_module] = ACTIONS(562),
    [anon_sym_static] = ACTIONS(562),
    [anon_sym_package] = ACTIONS(562),
    [anon_sym_import] = ACTIONS(562),
    [anon_sym_enum] = ACTIONS(562),
    [anon_sym_public] = ACTIONS(562),
    [anon_sym_protected] = ACTIONS(562),
    [anon_sym_private] = ACTIONS(562),
    [anon_sym_abstract] = ACTIONS(562),
    [anon_sym_final] = ACTIONS(562),
    [anon_sym_strictfp] = ACTIONS(562),
    [anon_sym_native] = ACTIONS(562),
    [anon_sym_transient] = ACTIONS(562),
    [anon_sym_volatile] = ACTIONS(562),
    [anon_sym_ATinterface] = ACTIONS(560),
    [anon_sym_interface] = ACTIONS(562),
    [anon_sym_byte] = ACTIONS(562),
    [anon_sym_short] = ACTIONS(562),
    [anon_sym_int] = ACTIONS(562),
    [anon_sym_long] = ACTIONS(562),
    [anon_sym_char] = ACTIONS(562),
    [anon_sym_float] = ACTIONS(562),
    [anon_sym_double] = ACTIONS(562),
    [sym_boolean_type] = ACTIONS(562),
    [sym_void_type] = ACTIONS(562),
    [sym_this] = ACTIONS(562),
    [sym_super] = ACTIONS(562),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(564),
    [sym_identifier] = ACTIONS(566),
    [sym_decimal_integer_literal] = ACTIONS(566),
    [sym_hex_integer_literal] = ACTIONS(566),
    [sym_octal_integer_literal] = ACTIONS(564),
    [sym_binary_integer_literal] = ACTIONS(564),
    [sym_decimal_floating_point_literal] = ACTIONS(564),
    [sym_hex_floating_point_literal] = ACTIONS(566),
    [sym_true] = ACTIONS(566),
    [sym_false] = ACTIONS(566),
    [sym_character_literal] = ACTIONS(564),
    [sym_string_literal] = ACTIONS(564),
    [sym_null_literal] = ACTIONS(566),
    [anon_sym_LPAREN] = ACTIONS(564),
    [anon_sym_LT] = ACTIONS(564),
    [anon_sym_PLUS] = ACTIONS(566),
    [anon_sym_DASH] = ACTIONS(566),
    [anon_sym_BANG] = ACTIONS(564),
    [anon_sym_TILDE] = ACTIONS(564),
    [anon_sym_PLUS_PLUS] = ACTIONS(564),
    [anon_sym_DASH_DASH] = ACTIONS(564),
    [anon_sym_new] = ACTIONS(566),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_RBRACE] = ACTIONS(564),
    [anon_sym_assert] = ACTIONS(566),
    [anon_sym_switch] = ACTIONS(566),
    [anon_sym_case] = ACTIONS(566),
    [anon_sym_default] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_break] = ACTIONS(566),
    [anon_sym_continue] = ACTIONS(566),
    [anon_sym_return] = ACTIONS(566),
    [anon_sym_synchronized] = ACTIONS(566),
    [anon_sym_throw] = ACTIONS(566),
    [anon_sym_try] = ACTIONS(566),
    [anon_sym_if] = ACTIONS(566),
    [anon_sym_else] = ACTIONS(566),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_AT] = ACTIONS(566),
    [anon_sym_open] = ACTIONS(566),
    [anon_sym_module] = ACTIONS(566),
    [anon_sym_static] = ACTIONS(566),
    [anon_sym_package] = ACTIONS(566),
    [anon_sym_import] = ACTIONS(566),
    [anon_sym_enum] = ACTIONS(566),
    [anon_sym_public] = ACTIONS(566),
    [anon_sym_protected] = ACTIONS(566),
    [anon_sym_private] = ACTIONS(566),
    [anon_sym_abstract] = ACTIONS(566),
    [anon_sym_final] = ACTIONS(566),
    [anon_sym_strictfp] = ACTIONS(566),
    [anon_sym_native] = ACTIONS(566),
    [anon_sym_transient] = ACTIONS(566),
    [anon_sym_volatile] = ACTIONS(566),
    [anon_sym_ATinterface] = ACTIONS(564),
    [anon_sym_interface] = ACTIONS(566),
    [anon_sym_byte] = ACTIONS(566),
    [anon_sym_short] = ACTIONS(566),
    [anon_sym_int] = ACTIONS(566),
    [anon_sym_long] = ACTIONS(566),
    [anon_sym_char] = ACTIONS(566),
    [anon_sym_float] = ACTIONS(566),
    [anon_sym_double] = ACTIONS(566),
    [sym_boolean_type] = ACTIONS(566),
    [sym_void_type] = ACTIONS(566),
    [sym_this] = ACTIONS(566),
    [sym_super] = ACTIONS(566),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(568),
    [sym_identifier] = ACTIONS(570),
    [sym_decimal_integer_literal] = ACTIONS(570),
    [sym_hex_integer_literal] = ACTIONS(570),
    [sym_octal_integer_literal] = ACTIONS(568),
    [sym_binary_integer_literal] = ACTIONS(568),
    [sym_decimal_floating_point_literal] = ACTIONS(568),
    [sym_hex_floating_point_literal] = ACTIONS(570),
    [sym_true] = ACTIONS(570),
    [sym_false] = ACTIONS(570),
    [sym_character_literal] = ACTIONS(568),
    [sym_string_literal] = ACTIONS(568),
    [sym_null_literal] = ACTIONS(570),
    [anon_sym_LPAREN] = ACTIONS(568),
    [anon_sym_LT] = ACTIONS(568),
    [anon_sym_PLUS] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(570),
    [anon_sym_BANG] = ACTIONS(568),
    [anon_sym_TILDE] = ACTIONS(568),
    [anon_sym_PLUS_PLUS] = ACTIONS(568),
    [anon_sym_DASH_DASH] = ACTIONS(568),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_class] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_RBRACE] = ACTIONS(568),
    [anon_sym_assert] = ACTIONS(570),
    [anon_sym_switch] = ACTIONS(570),
    [anon_sym_case] = ACTIONS(570),
    [anon_sym_default] = ACTIONS(570),
    [anon_sym_do] = ACTIONS(570),
    [anon_sym_while] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(570),
    [anon_sym_continue] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(570),
    [anon_sym_synchronized] = ACTIONS(570),
    [anon_sym_throw] = ACTIONS(570),
    [anon_sym_try] = ACTIONS(570),
    [anon_sym_if] = ACTIONS(570),
    [anon_sym_else] = ACTIONS(570),
    [anon_sym_for] = ACTIONS(570),
    [anon_sym_AT] = ACTIONS(570),
    [anon_sym_open] = ACTIONS(570),
    [anon_sym_module] = ACTIONS(570),
    [anon_sym_static] = ACTIONS(570),
    [anon_sym_package] = ACTIONS(570),
    [anon_sym_import] = ACTIONS(570),
    [anon_sym_enum] = ACTIONS(570),
    [anon_sym_public] = ACTIONS(570),
    [anon_sym_protected] = ACTIONS(570),
    [anon_sym_private] = ACTIONS(570),
    [anon_sym_abstract] = ACTIONS(570),
    [anon_sym_final] = ACTIONS(570),
    [anon_sym_strictfp] = ACTIONS(570),
    [anon_sym_native] = ACTIONS(570),
    [anon_sym_transient] = ACTIONS(570),
    [anon_sym_volatile] = ACTIONS(570),
    [anon_sym_ATinterface] = ACTIONS(568),
    [anon_sym_interface] = ACTIONS(570),
    [anon_sym_byte] = ACTIONS(570),
    [anon_sym_short] = ACTIONS(570),
    [anon_sym_int] = ACTIONS(570),
    [anon_sym_long] = ACTIONS(570),
    [anon_sym_char] = ACTIONS(570),
    [anon_sym_float] = ACTIONS(570),
    [anon_sym_double] = ACTIONS(570),
    [sym_boolean_type] = ACTIONS(570),
    [sym_void_type] = ACTIONS(570),
    [sym_this] = ACTIONS(570),
    [sym_super] = ACTIONS(570),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(572),
    [sym_identifier] = ACTIONS(574),
    [sym_decimal_integer_literal] = ACTIONS(574),
    [sym_hex_integer_literal] = ACTIONS(574),
    [sym_octal_integer_literal] = ACTIONS(572),
    [sym_binary_integer_literal] = ACTIONS(572),
    [sym_decimal_floating_point_literal] = ACTIONS(572),
    [sym_hex_floating_point_literal] = ACTIONS(574),
    [sym_true] = ACTIONS(574),
    [sym_false] = ACTIONS(574),
    [sym_character_literal] = ACTIONS(572),
    [sym_string_literal] = ACTIONS(572),
    [sym_null_literal] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(572),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(574),
    [anon_sym_DASH] = ACTIONS(574),
    [anon_sym_BANG] = ACTIONS(572),
    [anon_sym_TILDE] = ACTIONS(572),
    [anon_sym_PLUS_PLUS] = ACTIONS(572),
    [anon_sym_DASH_DASH] = ACTIONS(572),
    [anon_sym_new] = ACTIONS(574),
    [anon_sym_class] = ACTIONS(574),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(572),
    [anon_sym_RBRACE] = ACTIONS(572),
    [anon_sym_assert] = ACTIONS(574),
    [anon_sym_switch] = ACTIONS(574),
    [anon_sym_case] = ACTIONS(574),
    [anon_sym_default] = ACTIONS(574),
    [anon_sym_do] = ACTIONS(574),
    [anon_sym_while] = ACTIONS(574),
    [anon_sym_break] = ACTIONS(574),
    [anon_sym_continue] = ACTIONS(574),
    [anon_sym_return] = ACTIONS(574),
    [anon_sym_synchronized] = ACTIONS(574),
    [anon_sym_throw] = ACTIONS(574),
    [anon_sym_try] = ACTIONS(574),
    [anon_sym_if] = ACTIONS(574),
    [anon_sym_else] = ACTIONS(574),
    [anon_sym_for] = ACTIONS(574),
    [anon_sym_AT] = ACTIONS(574),
    [anon_sym_open] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(574),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_package] = ACTIONS(574),
    [anon_sym_import] = ACTIONS(574),
    [anon_sym_enum] = ACTIONS(574),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(574),
    [anon_sym_final] = ACTIONS(574),
    [anon_sym_strictfp] = ACTIONS(574),
    [anon_sym_native] = ACTIONS(574),
    [anon_sym_transient] = ACTIONS(574),
    [anon_sym_volatile] = ACTIONS(574),
    [anon_sym_ATinterface] = ACTIONS(572),
    [anon_sym_interface] = ACTIONS(574),
    [anon_sym_byte] = ACTIONS(574),
    [anon_sym_short] = ACTIONS(574),
    [anon_sym_int] = ACTIONS(574),
    [anon_sym_long] = ACTIONS(574),
    [anon_sym_char] = ACTIONS(574),
    [anon_sym_float] = ACTIONS(574),
    [anon_sym_double] = ACTIONS(574),
    [sym_boolean_type] = ACTIONS(574),
    [sym_void_type] = ACTIONS(574),
    [sym_this] = ACTIONS(574),
    [sym_super] = ACTIONS(574),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(576),
    [sym_identifier] = ACTIONS(578),
    [sym_decimal_integer_literal] = ACTIONS(578),
    [sym_hex_integer_literal] = ACTIONS(578),
    [sym_octal_integer_literal] = ACTIONS(576),
    [sym_binary_integer_literal] = ACTIONS(576),
    [sym_decimal_floating_point_literal] = ACTIONS(576),
    [sym_hex_floating_point_literal] = ACTIONS(578),
    [sym_true] = ACTIONS(578),
    [sym_false] = ACTIONS(578),
    [sym_character_literal] = ACTIONS(576),
    [sym_string_literal] = ACTIONS(576),
    [sym_null_literal] = ACTIONS(578),
    [anon_sym_LPAREN] = ACTIONS(576),
    [anon_sym_LT] = ACTIONS(576),
    [anon_sym_PLUS] = ACTIONS(578),
    [anon_sym_DASH] = ACTIONS(578),
    [anon_sym_BANG] = ACTIONS(576),
    [anon_sym_TILDE] = ACTIONS(576),
    [anon_sym_PLUS_PLUS] = ACTIONS(576),
    [anon_sym_DASH_DASH] = ACTIONS(576),
    [anon_sym_new] = ACTIONS(578),
    [anon_sym_class] = ACTIONS(578),
    [anon_sym_SEMI] = ACTIONS(576),
    [anon_sym_LBRACE] = ACTIONS(576),
    [anon_sym_RBRACE] = ACTIONS(576),
    [anon_sym_assert] = ACTIONS(578),
    [anon_sym_switch] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(578),
    [anon_sym_default] = ACTIONS(578),
    [anon_sym_do] = ACTIONS(578),
    [anon_sym_while] = ACTIONS(578),
    [anon_sym_break] = ACTIONS(578),
    [anon_sym_continue] = ACTIONS(578),
    [anon_sym_return] = ACTIONS(578),
    [anon_sym_synchronized] = ACTIONS(578),
    [anon_sym_throw] = ACTIONS(578),
    [anon_sym_try] = ACTIONS(578),
    [anon_sym_if] = ACTIONS(578),
    [anon_sym_else] = ACTIONS(578),
    [anon_sym_for] = ACTIONS(578),
    [anon_sym_AT] = ACTIONS(578),
    [anon_sym_open] = ACTIONS(578),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_static] = ACTIONS(578),
    [anon_sym_package] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(578),
    [anon_sym_enum] = ACTIONS(578),
    [anon_sym_public] = ACTIONS(578),
    [anon_sym_protected] = ACTIONS(578),
    [anon_sym_private] = ACTIONS(578),
    [anon_sym_abstract] = ACTIONS(578),
    [anon_sym_final] = ACTIONS(578),
    [anon_sym_strictfp] = ACTIONS(578),
    [anon_sym_native] = ACTIONS(578),
    [anon_sym_transient] = ACTIONS(578),
    [anon_sym_volatile] = ACTIONS(578),
    [anon_sym_ATinterface] = ACTIONS(576),
    [anon_sym_interface] = ACTIONS(578),
    [anon_sym_byte] = ACTIONS(578),
    [anon_sym_short] = ACTIONS(578),
    [anon_sym_int] = ACTIONS(578),
    [anon_sym_long] = ACTIONS(578),
    [anon_sym_char] = ACTIONS(578),
    [anon_sym_float] = ACTIONS(578),
    [anon_sym_double] = ACTIONS(578),
    [sym_boolean_type] = ACTIONS(578),
    [sym_void_type] = ACTIONS(578),
    [sym_this] = ACTIONS(578),
    [sym_super] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(580),
    [sym_identifier] = ACTIONS(582),
    [sym_decimal_integer_literal] = ACTIONS(582),
    [sym_hex_integer_literal] = ACTIONS(582),
    [sym_octal_integer_literal] = ACTIONS(580),
    [sym_binary_integer_literal] = ACTIONS(580),
    [sym_decimal_floating_point_literal] = ACTIONS(580),
    [sym_hex_floating_point_literal] = ACTIONS(582),
    [sym_true] = ACTIONS(582),
    [sym_false] = ACTIONS(582),
    [sym_character_literal] = ACTIONS(580),
    [sym_string_literal] = ACTIONS(580),
    [sym_null_literal] = ACTIONS(582),
    [anon_sym_LPAREN] = ACTIONS(580),
    [anon_sym_LT] = ACTIONS(580),
    [anon_sym_PLUS] = ACTIONS(582),
    [anon_sym_DASH] = ACTIONS(582),
    [anon_sym_BANG] = ACTIONS(580),
    [anon_sym_TILDE] = ACTIONS(580),
    [anon_sym_PLUS_PLUS] = ACTIONS(580),
    [anon_sym_DASH_DASH] = ACTIONS(580),
    [anon_sym_new] = ACTIONS(582),
    [anon_sym_class] = ACTIONS(582),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(580),
    [anon_sym_RBRACE] = ACTIONS(580),
    [anon_sym_assert] = ACTIONS(582),
    [anon_sym_switch] = ACTIONS(582),
    [anon_sym_case] = ACTIONS(582),
    [anon_sym_default] = ACTIONS(582),
    [anon_sym_do] = ACTIONS(582),
    [anon_sym_while] = ACTIONS(582),
    [anon_sym_break] = ACTIONS(582),
    [anon_sym_continue] = ACTIONS(582),
    [anon_sym_return] = ACTIONS(582),
    [anon_sym_synchronized] = ACTIONS(582),
    [anon_sym_throw] = ACTIONS(582),
    [anon_sym_try] = ACTIONS(582),
    [anon_sym_if] = ACTIONS(582),
    [anon_sym_else] = ACTIONS(582),
    [anon_sym_for] = ACTIONS(582),
    [anon_sym_AT] = ACTIONS(582),
    [anon_sym_open] = ACTIONS(582),
    [anon_sym_module] = ACTIONS(582),
    [anon_sym_static] = ACTIONS(582),
    [anon_sym_package] = ACTIONS(582),
    [anon_sym_import] = ACTIONS(582),
    [anon_sym_enum] = ACTIONS(582),
    [anon_sym_public] = ACTIONS(582),
    [anon_sym_protected] = ACTIONS(582),
    [anon_sym_private] = ACTIONS(582),
    [anon_sym_abstract] = ACTIONS(582),
    [anon_sym_final] = ACTIONS(582),
    [anon_sym_strictfp] = ACTIONS(582),
    [anon_sym_native] = ACTIONS(582),
    [anon_sym_transient] = ACTIONS(582),
    [anon_sym_volatile] = ACTIONS(582),
    [anon_sym_ATinterface] = ACTIONS(580),
    [anon_sym_interface] = ACTIONS(582),
    [anon_sym_byte] = ACTIONS(582),
    [anon_sym_short] = ACTIONS(582),
    [anon_sym_int] = ACTIONS(582),
    [anon_sym_long] = ACTIONS(582),
    [anon_sym_char] = ACTIONS(582),
    [anon_sym_float] = ACTIONS(582),
    [anon_sym_double] = ACTIONS(582),
    [sym_boolean_type] = ACTIONS(582),
    [sym_void_type] = ACTIONS(582),
    [sym_this] = ACTIONS(582),
    [sym_super] = ACTIONS(582),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(584),
    [sym_identifier] = ACTIONS(586),
    [sym_decimal_integer_literal] = ACTIONS(586),
    [sym_hex_integer_literal] = ACTIONS(586),
    [sym_octal_integer_literal] = ACTIONS(584),
    [sym_binary_integer_literal] = ACTIONS(584),
    [sym_decimal_floating_point_literal] = ACTIONS(584),
    [sym_hex_floating_point_literal] = ACTIONS(586),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_character_literal] = ACTIONS(584),
    [sym_string_literal] = ACTIONS(584),
    [sym_null_literal] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(586),
    [anon_sym_DASH] = ACTIONS(586),
    [anon_sym_BANG] = ACTIONS(584),
    [anon_sym_TILDE] = ACTIONS(584),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_new] = ACTIONS(586),
    [anon_sym_class] = ACTIONS(586),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(584),
    [anon_sym_assert] = ACTIONS(586),
    [anon_sym_switch] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(586),
    [anon_sym_default] = ACTIONS(586),
    [anon_sym_do] = ACTIONS(586),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_break] = ACTIONS(586),
    [anon_sym_continue] = ACTIONS(586),
    [anon_sym_return] = ACTIONS(586),
    [anon_sym_synchronized] = ACTIONS(586),
    [anon_sym_throw] = ACTIONS(586),
    [anon_sym_try] = ACTIONS(586),
    [anon_sym_if] = ACTIONS(586),
    [anon_sym_else] = ACTIONS(586),
    [anon_sym_for] = ACTIONS(586),
    [anon_sym_AT] = ACTIONS(586),
    [anon_sym_open] = ACTIONS(586),
    [anon_sym_module] = ACTIONS(586),
    [anon_sym_static] = ACTIONS(586),
    [anon_sym_package] = ACTIONS(586),
    [anon_sym_import] = ACTIONS(586),
    [anon_sym_enum] = ACTIONS(586),
    [anon_sym_public] = ACTIONS(586),
    [anon_sym_protected] = ACTIONS(586),
    [anon_sym_private] = ACTIONS(586),
    [anon_sym_abstract] = ACTIONS(586),
    [anon_sym_final] = ACTIONS(586),
    [anon_sym_strictfp] = ACTIONS(586),
    [anon_sym_native] = ACTIONS(586),
    [anon_sym_transient] = ACTIONS(586),
    [anon_sym_volatile] = ACTIONS(586),
    [anon_sym_ATinterface] = ACTIONS(584),
    [anon_sym_interface] = ACTIONS(586),
    [anon_sym_byte] = ACTIONS(586),
    [anon_sym_short] = ACTIONS(586),
    [anon_sym_int] = ACTIONS(586),
    [anon_sym_long] = ACTIONS(586),
    [anon_sym_char] = ACTIONS(586),
    [anon_sym_float] = ACTIONS(586),
    [anon_sym_double] = ACTIONS(586),
    [sym_boolean_type] = ACTIONS(586),
    [sym_void_type] = ACTIONS(586),
    [sym_this] = ACTIONS(586),
    [sym_super] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(588),
    [sym_identifier] = ACTIONS(590),
    [sym_decimal_integer_literal] = ACTIONS(590),
    [sym_hex_integer_literal] = ACTIONS(590),
    [sym_octal_integer_literal] = ACTIONS(588),
    [sym_binary_integer_literal] = ACTIONS(588),
    [sym_decimal_floating_point_literal] = ACTIONS(588),
    [sym_hex_floating_point_literal] = ACTIONS(590),
    [sym_true] = ACTIONS(590),
    [sym_false] = ACTIONS(590),
    [sym_character_literal] = ACTIONS(588),
    [sym_string_literal] = ACTIONS(588),
    [sym_null_literal] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_LT] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(588),
    [anon_sym_TILDE] = ACTIONS(588),
    [anon_sym_PLUS_PLUS] = ACTIONS(588),
    [anon_sym_DASH_DASH] = ACTIONS(588),
    [anon_sym_new] = ACTIONS(590),
    [anon_sym_class] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(588),
    [anon_sym_RBRACE] = ACTIONS(588),
    [anon_sym_assert] = ACTIONS(590),
    [anon_sym_switch] = ACTIONS(590),
    [anon_sym_case] = ACTIONS(590),
    [anon_sym_default] = ACTIONS(590),
    [anon_sym_do] = ACTIONS(590),
    [anon_sym_while] = ACTIONS(590),
    [anon_sym_break] = ACTIONS(590),
    [anon_sym_continue] = ACTIONS(590),
    [anon_sym_return] = ACTIONS(590),
    [anon_sym_synchronized] = ACTIONS(590),
    [anon_sym_throw] = ACTIONS(590),
    [anon_sym_try] = ACTIONS(590),
    [anon_sym_if] = ACTIONS(590),
    [anon_sym_else] = ACTIONS(590),
    [anon_sym_for] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(590),
    [anon_sym_open] = ACTIONS(590),
    [anon_sym_module] = ACTIONS(590),
    [anon_sym_static] = ACTIONS(590),
    [anon_sym_package] = ACTIONS(590),
    [anon_sym_import] = ACTIONS(590),
    [anon_sym_enum] = ACTIONS(590),
    [anon_sym_public] = ACTIONS(590),
    [anon_sym_protected] = ACTIONS(590),
    [anon_sym_private] = ACTIONS(590),
    [anon_sym_abstract] = ACTIONS(590),
    [anon_sym_final] = ACTIONS(590),
    [anon_sym_strictfp] = ACTIONS(590),
    [anon_sym_native] = ACTIONS(590),
    [anon_sym_transient] = ACTIONS(590),
    [anon_sym_volatile] = ACTIONS(590),
    [anon_sym_ATinterface] = ACTIONS(588),
    [anon_sym_interface] = ACTIONS(590),
    [anon_sym_byte] = ACTIONS(590),
    [anon_sym_short] = ACTIONS(590),
    [anon_sym_int] = ACTIONS(590),
    [anon_sym_long] = ACTIONS(590),
    [anon_sym_char] = ACTIONS(590),
    [anon_sym_float] = ACTIONS(590),
    [anon_sym_double] = ACTIONS(590),
    [sym_boolean_type] = ACTIONS(590),
    [sym_void_type] = ACTIONS(590),
    [sym_this] = ACTIONS(590),
    [sym_super] = ACTIONS(590),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(592),
    [sym_identifier] = ACTIONS(594),
    [sym_decimal_integer_literal] = ACTIONS(594),
    [sym_hex_integer_literal] = ACTIONS(594),
    [sym_octal_integer_literal] = ACTIONS(592),
    [sym_binary_integer_literal] = ACTIONS(592),
    [sym_decimal_floating_point_literal] = ACTIONS(592),
    [sym_hex_floating_point_literal] = ACTIONS(594),
    [sym_true] = ACTIONS(594),
    [sym_false] = ACTIONS(594),
    [sym_character_literal] = ACTIONS(592),
    [sym_string_literal] = ACTIONS(592),
    [sym_null_literal] = ACTIONS(594),
    [anon_sym_LPAREN] = ACTIONS(592),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(594),
    [anon_sym_DASH] = ACTIONS(594),
    [anon_sym_BANG] = ACTIONS(592),
    [anon_sym_TILDE] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(592),
    [anon_sym_DASH_DASH] = ACTIONS(592),
    [anon_sym_new] = ACTIONS(594),
    [anon_sym_class] = ACTIONS(594),
    [anon_sym_SEMI] = ACTIONS(592),
    [anon_sym_LBRACE] = ACTIONS(592),
    [anon_sym_RBRACE] = ACTIONS(592),
    [anon_sym_assert] = ACTIONS(594),
    [anon_sym_switch] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(594),
    [anon_sym_default] = ACTIONS(594),
    [anon_sym_do] = ACTIONS(594),
    [anon_sym_while] = ACTIONS(594),
    [anon_sym_break] = ACTIONS(594),
    [anon_sym_continue] = ACTIONS(594),
    [anon_sym_return] = ACTIONS(594),
    [anon_sym_synchronized] = ACTIONS(594),
    [anon_sym_throw] = ACTIONS(594),
    [anon_sym_try] = ACTIONS(594),
    [anon_sym_if] = ACTIONS(594),
    [anon_sym_else] = ACTIONS(594),
    [anon_sym_for] = ACTIONS(594),
    [anon_sym_AT] = ACTIONS(594),
    [anon_sym_open] = ACTIONS(594),
    [anon_sym_module] = ACTIONS(594),
    [anon_sym_static] = ACTIONS(594),
    [anon_sym_package] = ACTIONS(594),
    [anon_sym_import] = ACTIONS(594),
    [anon_sym_enum] = ACTIONS(594),
    [anon_sym_public] = ACTIONS(594),
    [anon_sym_protected] = ACTIONS(594),
    [anon_sym_private] = ACTIONS(594),
    [anon_sym_abstract] = ACTIONS(594),
    [anon_sym_final] = ACTIONS(594),
    [anon_sym_strictfp] = ACTIONS(594),
    [anon_sym_native] = ACTIONS(594),
    [anon_sym_transient] = ACTIONS(594),
    [anon_sym_volatile] = ACTIONS(594),
    [anon_sym_ATinterface] = ACTIONS(592),
    [anon_sym_interface] = ACTIONS(594),
    [anon_sym_byte] = ACTIONS(594),
    [anon_sym_short] = ACTIONS(594),
    [anon_sym_int] = ACTIONS(594),
    [anon_sym_long] = ACTIONS(594),
    [anon_sym_char] = ACTIONS(594),
    [anon_sym_float] = ACTIONS(594),
    [anon_sym_double] = ACTIONS(594),
    [sym_boolean_type] = ACTIONS(594),
    [sym_void_type] = ACTIONS(594),
    [sym_this] = ACTIONS(594),
    [sym_super] = ACTIONS(594),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(596),
    [sym_identifier] = ACTIONS(598),
    [sym_decimal_integer_literal] = ACTIONS(598),
    [sym_hex_integer_literal] = ACTIONS(598),
    [sym_octal_integer_literal] = ACTIONS(596),
    [sym_binary_integer_literal] = ACTIONS(596),
    [sym_decimal_floating_point_literal] = ACTIONS(596),
    [sym_hex_floating_point_literal] = ACTIONS(598),
    [sym_true] = ACTIONS(598),
    [sym_false] = ACTIONS(598),
    [sym_character_literal] = ACTIONS(596),
    [sym_string_literal] = ACTIONS(596),
    [sym_null_literal] = ACTIONS(598),
    [anon_sym_LPAREN] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(596),
    [anon_sym_PLUS] = ACTIONS(598),
    [anon_sym_DASH] = ACTIONS(598),
    [anon_sym_BANG] = ACTIONS(596),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_PLUS_PLUS] = ACTIONS(596),
    [anon_sym_DASH_DASH] = ACTIONS(596),
    [anon_sym_new] = ACTIONS(598),
    [anon_sym_class] = ACTIONS(598),
    [anon_sym_SEMI] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(596),
    [anon_sym_RBRACE] = ACTIONS(596),
    [anon_sym_assert] = ACTIONS(598),
    [anon_sym_switch] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(598),
    [anon_sym_default] = ACTIONS(598),
    [anon_sym_do] = ACTIONS(598),
    [anon_sym_while] = ACTIONS(598),
    [anon_sym_break] = ACTIONS(598),
    [anon_sym_continue] = ACTIONS(598),
    [anon_sym_return] = ACTIONS(598),
    [anon_sym_synchronized] = ACTIONS(598),
    [anon_sym_throw] = ACTIONS(598),
    [anon_sym_try] = ACTIONS(598),
    [anon_sym_if] = ACTIONS(598),
    [anon_sym_else] = ACTIONS(598),
    [anon_sym_for] = ACTIONS(598),
    [anon_sym_AT] = ACTIONS(598),
    [anon_sym_open] = ACTIONS(598),
    [anon_sym_module] = ACTIONS(598),
    [anon_sym_static] = ACTIONS(598),
    [anon_sym_package] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(598),
    [anon_sym_enum] = ACTIONS(598),
    [anon_sym_public] = ACTIONS(598),
    [anon_sym_protected] = ACTIONS(598),
    [anon_sym_private] = ACTIONS(598),
    [anon_sym_abstract] = ACTIONS(598),
    [anon_sym_final] = ACTIONS(598),
    [anon_sym_strictfp] = ACTIONS(598),
    [anon_sym_native] = ACTIONS(598),
    [anon_sym_transient] = ACTIONS(598),
    [anon_sym_volatile] = ACTIONS(598),
    [anon_sym_ATinterface] = ACTIONS(596),
    [anon_sym_interface] = ACTIONS(598),
    [anon_sym_byte] = ACTIONS(598),
    [anon_sym_short] = ACTIONS(598),
    [anon_sym_int] = ACTIONS(598),
    [anon_sym_long] = ACTIONS(598),
    [anon_sym_char] = ACTIONS(598),
    [anon_sym_float] = ACTIONS(598),
    [anon_sym_double] = ACTIONS(598),
    [sym_boolean_type] = ACTIONS(598),
    [sym_void_type] = ACTIONS(598),
    [sym_this] = ACTIONS(598),
    [sym_super] = ACTIONS(598),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(600),
    [sym_identifier] = ACTIONS(602),
    [sym_decimal_integer_literal] = ACTIONS(602),
    [sym_hex_integer_literal] = ACTIONS(602),
    [sym_octal_integer_literal] = ACTIONS(600),
    [sym_binary_integer_literal] = ACTIONS(600),
    [sym_decimal_floating_point_literal] = ACTIONS(600),
    [sym_hex_floating_point_literal] = ACTIONS(602),
    [sym_true] = ACTIONS(602),
    [sym_false] = ACTIONS(602),
    [sym_character_literal] = ACTIONS(600),
    [sym_string_literal] = ACTIONS(600),
    [sym_null_literal] = ACTIONS(602),
    [anon_sym_LPAREN] = ACTIONS(600),
    [anon_sym_LT] = ACTIONS(600),
    [anon_sym_PLUS] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_TILDE] = ACTIONS(600),
    [anon_sym_PLUS_PLUS] = ACTIONS(600),
    [anon_sym_DASH_DASH] = ACTIONS(600),
    [anon_sym_new] = ACTIONS(602),
    [anon_sym_class] = ACTIONS(602),
    [anon_sym_SEMI] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(600),
    [anon_sym_assert] = ACTIONS(602),
    [anon_sym_switch] = ACTIONS(602),
    [anon_sym_case] = ACTIONS(602),
    [anon_sym_default] = ACTIONS(602),
    [anon_sym_do] = ACTIONS(602),
    [anon_sym_while] = ACTIONS(602),
    [anon_sym_break] = ACTIONS(602),
    [anon_sym_continue] = ACTIONS(602),
    [anon_sym_return] = ACTIONS(602),
    [anon_sym_synchronized] = ACTIONS(602),
    [anon_sym_throw] = ACTIONS(602),
    [anon_sym_try] = ACTIONS(602),
    [anon_sym_if] = ACTIONS(602),
    [anon_sym_else] = ACTIONS(602),
    [anon_sym_for] = ACTIONS(602),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_open] = ACTIONS(602),
    [anon_sym_module] = ACTIONS(602),
    [anon_sym_static] = ACTIONS(602),
    [anon_sym_package] = ACTIONS(602),
    [anon_sym_import] = ACTIONS(602),
    [anon_sym_enum] = ACTIONS(602),
    [anon_sym_public] = ACTIONS(602),
    [anon_sym_protected] = ACTIONS(602),
    [anon_sym_private] = ACTIONS(602),
    [anon_sym_abstract] = ACTIONS(602),
    [anon_sym_final] = ACTIONS(602),
    [anon_sym_strictfp] = ACTIONS(602),
    [anon_sym_native] = ACTIONS(602),
    [anon_sym_transient] = ACTIONS(602),
    [anon_sym_volatile] = ACTIONS(602),
    [anon_sym_ATinterface] = ACTIONS(600),
    [anon_sym_interface] = ACTIONS(602),
    [anon_sym_byte] = ACTIONS(602),
    [anon_sym_short] = ACTIONS(602),
    [anon_sym_int] = ACTIONS(602),
    [anon_sym_long] = ACTIONS(602),
    [anon_sym_char] = ACTIONS(602),
    [anon_sym_float] = ACTIONS(602),
    [anon_sym_double] = ACTIONS(602),
    [sym_boolean_type] = ACTIONS(602),
    [sym_void_type] = ACTIONS(602),
    [sym_this] = ACTIONS(602),
    [sym_super] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(604),
    [sym_identifier] = ACTIONS(606),
    [sym_decimal_integer_literal] = ACTIONS(606),
    [sym_hex_integer_literal] = ACTIONS(606),
    [sym_octal_integer_literal] = ACTIONS(604),
    [sym_binary_integer_literal] = ACTIONS(604),
    [sym_decimal_floating_point_literal] = ACTIONS(604),
    [sym_hex_floating_point_literal] = ACTIONS(606),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_character_literal] = ACTIONS(604),
    [sym_string_literal] = ACTIONS(604),
    [sym_null_literal] = ACTIONS(606),
    [anon_sym_LPAREN] = ACTIONS(604),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(606),
    [anon_sym_DASH] = ACTIONS(606),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_TILDE] = ACTIONS(604),
    [anon_sym_PLUS_PLUS] = ACTIONS(604),
    [anon_sym_DASH_DASH] = ACTIONS(604),
    [anon_sym_new] = ACTIONS(606),
    [anon_sym_class] = ACTIONS(606),
    [anon_sym_SEMI] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(604),
    [anon_sym_assert] = ACTIONS(606),
    [anon_sym_switch] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(606),
    [anon_sym_default] = ACTIONS(606),
    [anon_sym_do] = ACTIONS(606),
    [anon_sym_while] = ACTIONS(606),
    [anon_sym_break] = ACTIONS(606),
    [anon_sym_continue] = ACTIONS(606),
    [anon_sym_return] = ACTIONS(606),
    [anon_sym_synchronized] = ACTIONS(606),
    [anon_sym_throw] = ACTIONS(606),
    [anon_sym_try] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(606),
    [anon_sym_else] = ACTIONS(606),
    [anon_sym_for] = ACTIONS(606),
    [anon_sym_AT] = ACTIONS(606),
    [anon_sym_open] = ACTIONS(606),
    [anon_sym_module] = ACTIONS(606),
    [anon_sym_static] = ACTIONS(606),
    [anon_sym_package] = ACTIONS(606),
    [anon_sym_import] = ACTIONS(606),
    [anon_sym_enum] = ACTIONS(606),
    [anon_sym_public] = ACTIONS(606),
    [anon_sym_protected] = ACTIONS(606),
    [anon_sym_private] = ACTIONS(606),
    [anon_sym_abstract] = ACTIONS(606),
    [anon_sym_final] = ACTIONS(606),
    [anon_sym_strictfp] = ACTIONS(606),
    [anon_sym_native] = ACTIONS(606),
    [anon_sym_transient] = ACTIONS(606),
    [anon_sym_volatile] = ACTIONS(606),
    [anon_sym_ATinterface] = ACTIONS(604),
    [anon_sym_interface] = ACTIONS(606),
    [anon_sym_byte] = ACTIONS(606),
    [anon_sym_short] = ACTIONS(606),
    [anon_sym_int] = ACTIONS(606),
    [anon_sym_long] = ACTIONS(606),
    [anon_sym_char] = ACTIONS(606),
    [anon_sym_float] = ACTIONS(606),
    [anon_sym_double] = ACTIONS(606),
    [sym_boolean_type] = ACTIONS(606),
    [sym_void_type] = ACTIONS(606),
    [sym_this] = ACTIONS(606),
    [sym_super] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(608),
    [sym_identifier] = ACTIONS(610),
    [sym_decimal_integer_literal] = ACTIONS(610),
    [sym_hex_integer_literal] = ACTIONS(610),
    [sym_octal_integer_literal] = ACTIONS(608),
    [sym_binary_integer_literal] = ACTIONS(608),
    [sym_decimal_floating_point_literal] = ACTIONS(608),
    [sym_hex_floating_point_literal] = ACTIONS(610),
    [sym_true] = ACTIONS(610),
    [sym_false] = ACTIONS(610),
    [sym_character_literal] = ACTIONS(608),
    [sym_string_literal] = ACTIONS(608),
    [sym_null_literal] = ACTIONS(610),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_LT] = ACTIONS(608),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(610),
    [anon_sym_BANG] = ACTIONS(608),
    [anon_sym_TILDE] = ACTIONS(608),
    [anon_sym_PLUS_PLUS] = ACTIONS(608),
    [anon_sym_DASH_DASH] = ACTIONS(608),
    [anon_sym_new] = ACTIONS(610),
    [anon_sym_class] = ACTIONS(610),
    [anon_sym_SEMI] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(608),
    [anon_sym_RBRACE] = ACTIONS(608),
    [anon_sym_assert] = ACTIONS(610),
    [anon_sym_switch] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(610),
    [anon_sym_default] = ACTIONS(610),
    [anon_sym_do] = ACTIONS(610),
    [anon_sym_while] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(610),
    [anon_sym_continue] = ACTIONS(610),
    [anon_sym_return] = ACTIONS(610),
    [anon_sym_synchronized] = ACTIONS(610),
    [anon_sym_throw] = ACTIONS(610),
    [anon_sym_try] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(610),
    [anon_sym_for] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_open] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_package] = ACTIONS(610),
    [anon_sym_import] = ACTIONS(610),
    [anon_sym_enum] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_abstract] = ACTIONS(610),
    [anon_sym_final] = ACTIONS(610),
    [anon_sym_strictfp] = ACTIONS(610),
    [anon_sym_native] = ACTIONS(610),
    [anon_sym_transient] = ACTIONS(610),
    [anon_sym_volatile] = ACTIONS(610),
    [anon_sym_ATinterface] = ACTIONS(608),
    [anon_sym_interface] = ACTIONS(610),
    [anon_sym_byte] = ACTIONS(610),
    [anon_sym_short] = ACTIONS(610),
    [anon_sym_int] = ACTIONS(610),
    [anon_sym_long] = ACTIONS(610),
    [anon_sym_char] = ACTIONS(610),
    [anon_sym_float] = ACTIONS(610),
    [anon_sym_double] = ACTIONS(610),
    [sym_boolean_type] = ACTIONS(610),
    [sym_void_type] = ACTIONS(610),
    [sym_this] = ACTIONS(610),
    [sym_super] = ACTIONS(610),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(429),
    [sym_cast_expression] = STATE(429),
    [sym_assignment_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_instanceof_expression] = STATE(429),
    [sym_lambda_expression] = STATE(429),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym_array_initializer] = STATE(852),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(612),
    [sym_identifier] = ACTIONS(614),
    [sym_decimal_integer_literal] = ACTIONS(614),
    [sym_hex_integer_literal] = ACTIONS(614),
    [sym_octal_integer_literal] = ACTIONS(612),
    [sym_binary_integer_literal] = ACTIONS(612),
    [sym_decimal_floating_point_literal] = ACTIONS(612),
    [sym_hex_floating_point_literal] = ACTIONS(614),
    [sym_true] = ACTIONS(614),
    [sym_false] = ACTIONS(614),
    [sym_character_literal] = ACTIONS(612),
    [sym_string_literal] = ACTIONS(612),
    [sym_null_literal] = ACTIONS(614),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(614),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(612),
    [anon_sym_DASH_DASH] = ACTIONS(612),
    [anon_sym_new] = ACTIONS(614),
    [anon_sym_class] = ACTIONS(614),
    [anon_sym_SEMI] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(612),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_assert] = ACTIONS(614),
    [anon_sym_switch] = ACTIONS(614),
    [anon_sym_case] = ACTIONS(614),
    [anon_sym_default] = ACTIONS(614),
    [anon_sym_do] = ACTIONS(614),
    [anon_sym_while] = ACTIONS(614),
    [anon_sym_break] = ACTIONS(614),
    [anon_sym_continue] = ACTIONS(614),
    [anon_sym_return] = ACTIONS(614),
    [anon_sym_synchronized] = ACTIONS(614),
    [anon_sym_throw] = ACTIONS(614),
    [anon_sym_try] = ACTIONS(614),
    [anon_sym_if] = ACTIONS(614),
    [anon_sym_else] = ACTIONS(614),
    [anon_sym_for] = ACTIONS(614),
    [anon_sym_AT] = ACTIONS(614),
    [anon_sym_open] = ACTIONS(614),
    [anon_sym_module] = ACTIONS(614),
    [anon_sym_static] = ACTIONS(614),
    [anon_sym_package] = ACTIONS(614),
    [anon_sym_import] = ACTIONS(614),
    [anon_sym_enum] = ACTIONS(614),
    [anon_sym_public] = ACTIONS(614),
    [anon_sym_protected] = ACTIONS(614),
    [anon_sym_private] = ACTIONS(614),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_final] = ACTIONS(614),
    [anon_sym_strictfp] = ACTIONS(614),
    [anon_sym_native] = ACTIONS(614),
    [anon_sym_transient] = ACTIONS(614),
    [anon_sym_volatile] = ACTIONS(614),
    [anon_sym_ATinterface] = ACTIONS(612),
    [anon_sym_interface] = ACTIONS(614),
    [anon_sym_byte] = ACTIONS(614),
    [anon_sym_short] = ACTIONS(614),
    [anon_sym_int] = ACTIONS(614),
    [anon_sym_long] = ACTIONS(614),
    [anon_sym_char] = ACTIONS(614),
    [anon_sym_float] = ACTIONS(614),
    [anon_sym_double] = ACTIONS(614),
    [sym_boolean_type] = ACTIONS(614),
    [sym_void_type] = ACTIONS(614),
    [sym_this] = ACTIONS(614),
    [sym_super] = ACTIONS(614),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [ts_builtin_sym_end] = ACTIONS(616),
    [sym_identifier] = ACTIONS(618),
    [sym_decimal_integer_literal] = ACTIONS(618),
    [sym_hex_integer_literal] = ACTIONS(618),
    [sym_octal_integer_literal] = ACTIONS(616),
    [sym_binary_integer_literal] = ACTIONS(616),
    [sym_decimal_floating_point_literal] = ACTIONS(616),
    [sym_hex_floating_point_literal] = ACTIONS(618),
    [sym_true] = ACTIONS(618),
    [sym_false] = ACTIONS(618),
    [sym_character_literal] = ACTIONS(616),
    [sym_string_literal] = ACTIONS(616),
    [sym_null_literal] = ACTIONS(618),
    [anon_sym_LPAREN] = ACTIONS(616),
    [anon_sym_LT] = ACTIONS(616),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_BANG] = ACTIONS(616),
    [anon_sym_TILDE] = ACTIONS(616),
    [anon_sym_PLUS_PLUS] = ACTIONS(616),
    [anon_sym_DASH_DASH] = ACTIONS(616),
    [anon_sym_new] = ACTIONS(618),
    [anon_sym_class] = ACTIONS(618),
    [anon_sym_SEMI] = ACTIONS(616),
    [anon_sym_LBRACE] = ACTIONS(616),
    [anon_sym_RBRACE] = ACTIONS(616),
    [anon_sym_assert] = ACTIONS(618),
    [anon_sym_switch] = ACTIONS(618),
    [anon_sym_case] = ACTIONS(618),
    [anon_sym_default] = ACTIONS(618),
    [anon_sym_do] = ACTIONS(618),
    [anon_sym_while] = ACTIONS(618),
    [anon_sym_break] = ACTIONS(618),
    [anon_sym_continue] = ACTIONS(618),
    [anon_sym_return] = ACTIONS(618),
    [anon_sym_synchronized] = ACTIONS(618),
    [anon_sym_throw] = ACTIONS(618),
    [anon_sym_try] = ACTIONS(618),
    [anon_sym_if] = ACTIONS(618),
    [anon_sym_else] = ACTIONS(618),
    [anon_sym_for] = ACTIONS(618),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_open] = ACTIONS(618),
    [anon_sym_module] = ACTIONS(618),
    [anon_sym_static] = ACTIONS(618),
    [anon_sym_package] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(618),
    [anon_sym_enum] = ACTIONS(618),
    [anon_sym_public] = ACTIONS(618),
    [anon_sym_protected] = ACTIONS(618),
    [anon_sym_private] = ACTIONS(618),
    [anon_sym_abstract] = ACTIONS(618),
    [anon_sym_final] = ACTIONS(618),
    [anon_sym_strictfp] = ACTIONS(618),
    [anon_sym_native] = ACTIONS(618),
    [anon_sym_transient] = ACTIONS(618),
    [anon_sym_volatile] = ACTIONS(618),
    [anon_sym_ATinterface] = ACTIONS(616),
    [anon_sym_interface] = ACTIONS(618),
    [anon_sym_byte] = ACTIONS(618),
    [anon_sym_short] = ACTIONS(618),
    [anon_sym_int] = ACTIONS(618),
    [anon_sym_long] = ACTIONS(618),
    [anon_sym_char] = ACTIONS(618),
    [anon_sym_float] = ACTIONS(618),
    [anon_sym_double] = ACTIONS(618),
    [sym_boolean_type] = ACTIONS(618),
    [sym_void_type] = ACTIONS(618),
    [sym_this] = ACTIONS(618),
    [sym_super] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [ts_builtin_sym_end] = ACTIONS(620),
    [sym_identifier] = ACTIONS(622),
    [sym_decimal_integer_literal] = ACTIONS(622),
    [sym_hex_integer_literal] = ACTIONS(622),
    [sym_octal_integer_literal] = ACTIONS(620),
    [sym_binary_integer_literal] = ACTIONS(620),
    [sym_decimal_floating_point_literal] = ACTIONS(620),
    [sym_hex_floating_point_literal] = ACTIONS(622),
    [sym_true] = ACTIONS(622),
    [sym_false] = ACTIONS(622),
    [sym_character_literal] = ACTIONS(620),
    [sym_string_literal] = ACTIONS(620),
    [sym_null_literal] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_DASH] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(620),
    [anon_sym_DASH_DASH] = ACTIONS(620),
    [anon_sym_new] = ACTIONS(622),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_assert] = ACTIONS(622),
    [anon_sym_switch] = ACTIONS(622),
    [anon_sym_case] = ACTIONS(622),
    [anon_sym_default] = ACTIONS(622),
    [anon_sym_do] = ACTIONS(622),
    [anon_sym_while] = ACTIONS(622),
    [anon_sym_break] = ACTIONS(622),
    [anon_sym_continue] = ACTIONS(622),
    [anon_sym_return] = ACTIONS(622),
    [anon_sym_synchronized] = ACTIONS(622),
    [anon_sym_throw] = ACTIONS(622),
    [anon_sym_try] = ACTIONS(622),
    [anon_sym_if] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(622),
    [anon_sym_for] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(622),
    [anon_sym_open] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(622),
    [anon_sym_static] = ACTIONS(622),
    [anon_sym_package] = ACTIONS(622),
    [anon_sym_import] = ACTIONS(622),
    [anon_sym_enum] = ACTIONS(622),
    [anon_sym_public] = ACTIONS(622),
    [anon_sym_protected] = ACTIONS(622),
    [anon_sym_private] = ACTIONS(622),
    [anon_sym_abstract] = ACTIONS(622),
    [anon_sym_final] = ACTIONS(622),
    [anon_sym_strictfp] = ACTIONS(622),
    [anon_sym_native] = ACTIONS(622),
    [anon_sym_transient] = ACTIONS(622),
    [anon_sym_volatile] = ACTIONS(622),
    [anon_sym_ATinterface] = ACTIONS(620),
    [anon_sym_interface] = ACTIONS(622),
    [anon_sym_byte] = ACTIONS(622),
    [anon_sym_short] = ACTIONS(622),
    [anon_sym_int] = ACTIONS(622),
    [anon_sym_long] = ACTIONS(622),
    [anon_sym_char] = ACTIONS(622),
    [anon_sym_float] = ACTIONS(622),
    [anon_sym_double] = ACTIONS(622),
    [sym_boolean_type] = ACTIONS(622),
    [sym_void_type] = ACTIONS(622),
    [sym_this] = ACTIONS(622),
    [sym_super] = ACTIONS(622),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(624),
    [sym_identifier] = ACTIONS(626),
    [sym_decimal_integer_literal] = ACTIONS(626),
    [sym_hex_integer_literal] = ACTIONS(626),
    [sym_octal_integer_literal] = ACTIONS(624),
    [sym_binary_integer_literal] = ACTIONS(624),
    [sym_decimal_floating_point_literal] = ACTIONS(624),
    [sym_hex_floating_point_literal] = ACTIONS(626),
    [sym_true] = ACTIONS(626),
    [sym_false] = ACTIONS(626),
    [sym_character_literal] = ACTIONS(624),
    [sym_string_literal] = ACTIONS(624),
    [sym_null_literal] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(624),
    [anon_sym_LT] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(626),
    [anon_sym_DASH] = ACTIONS(626),
    [anon_sym_BANG] = ACTIONS(624),
    [anon_sym_TILDE] = ACTIONS(624),
    [anon_sym_PLUS_PLUS] = ACTIONS(624),
    [anon_sym_DASH_DASH] = ACTIONS(624),
    [anon_sym_new] = ACTIONS(626),
    [anon_sym_class] = ACTIONS(626),
    [anon_sym_SEMI] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(624),
    [anon_sym_assert] = ACTIONS(626),
    [anon_sym_switch] = ACTIONS(626),
    [anon_sym_case] = ACTIONS(626),
    [anon_sym_default] = ACTIONS(626),
    [anon_sym_do] = ACTIONS(626),
    [anon_sym_while] = ACTIONS(626),
    [anon_sym_break] = ACTIONS(626),
    [anon_sym_continue] = ACTIONS(626),
    [anon_sym_return] = ACTIONS(626),
    [anon_sym_synchronized] = ACTIONS(626),
    [anon_sym_throw] = ACTIONS(626),
    [anon_sym_try] = ACTIONS(626),
    [anon_sym_if] = ACTIONS(626),
    [anon_sym_else] = ACTIONS(626),
    [anon_sym_for] = ACTIONS(626),
    [anon_sym_AT] = ACTIONS(626),
    [anon_sym_open] = ACTIONS(626),
    [anon_sym_module] = ACTIONS(626),
    [anon_sym_static] = ACTIONS(626),
    [anon_sym_package] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(626),
    [anon_sym_enum] = ACTIONS(626),
    [anon_sym_public] = ACTIONS(626),
    [anon_sym_protected] = ACTIONS(626),
    [anon_sym_private] = ACTIONS(626),
    [anon_sym_abstract] = ACTIONS(626),
    [anon_sym_final] = ACTIONS(626),
    [anon_sym_strictfp] = ACTIONS(626),
    [anon_sym_native] = ACTIONS(626),
    [anon_sym_transient] = ACTIONS(626),
    [anon_sym_volatile] = ACTIONS(626),
    [anon_sym_ATinterface] = ACTIONS(624),
    [anon_sym_interface] = ACTIONS(626),
    [anon_sym_byte] = ACTIONS(626),
    [anon_sym_short] = ACTIONS(626),
    [anon_sym_int] = ACTIONS(626),
    [anon_sym_long] = ACTIONS(626),
    [anon_sym_char] = ACTIONS(626),
    [anon_sym_float] = ACTIONS(626),
    [anon_sym_double] = ACTIONS(626),
    [sym_boolean_type] = ACTIONS(626),
    [sym_void_type] = ACTIONS(626),
    [sym_this] = ACTIONS(626),
    [sym_super] = ACTIONS(626),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(628),
    [sym_identifier] = ACTIONS(630),
    [sym_decimal_integer_literal] = ACTIONS(630),
    [sym_hex_integer_literal] = ACTIONS(630),
    [sym_octal_integer_literal] = ACTIONS(628),
    [sym_binary_integer_literal] = ACTIONS(628),
    [sym_decimal_floating_point_literal] = ACTIONS(628),
    [sym_hex_floating_point_literal] = ACTIONS(630),
    [sym_true] = ACTIONS(630),
    [sym_false] = ACTIONS(630),
    [sym_character_literal] = ACTIONS(628),
    [sym_string_literal] = ACTIONS(628),
    [sym_null_literal] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(628),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_BANG] = ACTIONS(628),
    [anon_sym_TILDE] = ACTIONS(628),
    [anon_sym_PLUS_PLUS] = ACTIONS(628),
    [anon_sym_DASH_DASH] = ACTIONS(628),
    [anon_sym_new] = ACTIONS(630),
    [anon_sym_class] = ACTIONS(630),
    [anon_sym_SEMI] = ACTIONS(628),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_RBRACE] = ACTIONS(628),
    [anon_sym_assert] = ACTIONS(630),
    [anon_sym_switch] = ACTIONS(630),
    [anon_sym_case] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_do] = ACTIONS(630),
    [anon_sym_while] = ACTIONS(630),
    [anon_sym_break] = ACTIONS(630),
    [anon_sym_continue] = ACTIONS(630),
    [anon_sym_return] = ACTIONS(630),
    [anon_sym_synchronized] = ACTIONS(630),
    [anon_sym_throw] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_else] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(630),
    [anon_sym_open] = ACTIONS(630),
    [anon_sym_module] = ACTIONS(630),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_package] = ACTIONS(630),
    [anon_sym_import] = ACTIONS(630),
    [anon_sym_enum] = ACTIONS(630),
    [anon_sym_public] = ACTIONS(630),
    [anon_sym_protected] = ACTIONS(630),
    [anon_sym_private] = ACTIONS(630),
    [anon_sym_abstract] = ACTIONS(630),
    [anon_sym_final] = ACTIONS(630),
    [anon_sym_strictfp] = ACTIONS(630),
    [anon_sym_native] = ACTIONS(630),
    [anon_sym_transient] = ACTIONS(630),
    [anon_sym_volatile] = ACTIONS(630),
    [anon_sym_ATinterface] = ACTIONS(628),
    [anon_sym_interface] = ACTIONS(630),
    [anon_sym_byte] = ACTIONS(630),
    [anon_sym_short] = ACTIONS(630),
    [anon_sym_int] = ACTIONS(630),
    [anon_sym_long] = ACTIONS(630),
    [anon_sym_char] = ACTIONS(630),
    [anon_sym_float] = ACTIONS(630),
    [anon_sym_double] = ACTIONS(630),
    [sym_boolean_type] = ACTIONS(630),
    [sym_void_type] = ACTIONS(630),
    [sym_this] = ACTIONS(630),
    [sym_super] = ACTIONS(630),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(632),
    [sym_identifier] = ACTIONS(634),
    [sym_decimal_integer_literal] = ACTIONS(634),
    [sym_hex_integer_literal] = ACTIONS(634),
    [sym_octal_integer_literal] = ACTIONS(632),
    [sym_binary_integer_literal] = ACTIONS(632),
    [sym_decimal_floating_point_literal] = ACTIONS(632),
    [sym_hex_floating_point_literal] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_character_literal] = ACTIONS(632),
    [sym_string_literal] = ACTIONS(632),
    [sym_null_literal] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(632),
    [anon_sym_LT] = ACTIONS(632),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_BANG] = ACTIONS(632),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_PLUS_PLUS] = ACTIONS(632),
    [anon_sym_DASH_DASH] = ACTIONS(632),
    [anon_sym_new] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(634),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_assert] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_case] = ACTIONS(634),
    [anon_sym_default] = ACTIONS(634),
    [anon_sym_do] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_break] = ACTIONS(634),
    [anon_sym_continue] = ACTIONS(634),
    [anon_sym_return] = ACTIONS(634),
    [anon_sym_synchronized] = ACTIONS(634),
    [anon_sym_throw] = ACTIONS(634),
    [anon_sym_try] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(634),
    [anon_sym_open] = ACTIONS(634),
    [anon_sym_module] = ACTIONS(634),
    [anon_sym_static] = ACTIONS(634),
    [anon_sym_package] = ACTIONS(634),
    [anon_sym_import] = ACTIONS(634),
    [anon_sym_enum] = ACTIONS(634),
    [anon_sym_public] = ACTIONS(634),
    [anon_sym_protected] = ACTIONS(634),
    [anon_sym_private] = ACTIONS(634),
    [anon_sym_abstract] = ACTIONS(634),
    [anon_sym_final] = ACTIONS(634),
    [anon_sym_strictfp] = ACTIONS(634),
    [anon_sym_native] = ACTIONS(634),
    [anon_sym_transient] = ACTIONS(634),
    [anon_sym_volatile] = ACTIONS(634),
    [anon_sym_ATinterface] = ACTIONS(632),
    [anon_sym_interface] = ACTIONS(634),
    [anon_sym_byte] = ACTIONS(634),
    [anon_sym_short] = ACTIONS(634),
    [anon_sym_int] = ACTIONS(634),
    [anon_sym_long] = ACTIONS(634),
    [anon_sym_char] = ACTIONS(634),
    [anon_sym_float] = ACTIONS(634),
    [anon_sym_double] = ACTIONS(634),
    [sym_boolean_type] = ACTIONS(634),
    [sym_void_type] = ACTIONS(634),
    [sym_this] = ACTIONS(634),
    [sym_super] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [sym_decimal_integer_literal] = ACTIONS(638),
    [sym_hex_integer_literal] = ACTIONS(638),
    [sym_octal_integer_literal] = ACTIONS(636),
    [sym_binary_integer_literal] = ACTIONS(636),
    [sym_decimal_floating_point_literal] = ACTIONS(636),
    [sym_hex_floating_point_literal] = ACTIONS(638),
    [sym_true] = ACTIONS(638),
    [sym_false] = ACTIONS(638),
    [sym_character_literal] = ACTIONS(636),
    [sym_string_literal] = ACTIONS(636),
    [sym_null_literal] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(636),
    [anon_sym_TILDE] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_new] = ACTIONS(638),
    [anon_sym_class] = ACTIONS(638),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_assert] = ACTIONS(638),
    [anon_sym_switch] = ACTIONS(638),
    [anon_sym_case] = ACTIONS(638),
    [anon_sym_default] = ACTIONS(638),
    [anon_sym_do] = ACTIONS(638),
    [anon_sym_while] = ACTIONS(638),
    [anon_sym_break] = ACTIONS(638),
    [anon_sym_continue] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(638),
    [anon_sym_synchronized] = ACTIONS(638),
    [anon_sym_throw] = ACTIONS(638),
    [anon_sym_try] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_else] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(638),
    [anon_sym_open] = ACTIONS(638),
    [anon_sym_module] = ACTIONS(638),
    [anon_sym_static] = ACTIONS(638),
    [anon_sym_package] = ACTIONS(638),
    [anon_sym_import] = ACTIONS(638),
    [anon_sym_enum] = ACTIONS(638),
    [anon_sym_public] = ACTIONS(638),
    [anon_sym_protected] = ACTIONS(638),
    [anon_sym_private] = ACTIONS(638),
    [anon_sym_abstract] = ACTIONS(638),
    [anon_sym_final] = ACTIONS(638),
    [anon_sym_strictfp] = ACTIONS(638),
    [anon_sym_native] = ACTIONS(638),
    [anon_sym_transient] = ACTIONS(638),
    [anon_sym_volatile] = ACTIONS(638),
    [anon_sym_ATinterface] = ACTIONS(636),
    [anon_sym_interface] = ACTIONS(638),
    [anon_sym_byte] = ACTIONS(638),
    [anon_sym_short] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_long] = ACTIONS(638),
    [anon_sym_char] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_double] = ACTIONS(638),
    [sym_boolean_type] = ACTIONS(638),
    [sym_void_type] = ACTIONS(638),
    [sym_this] = ACTIONS(638),
    [sym_super] = ACTIONS(638),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(640),
    [sym_identifier] = ACTIONS(642),
    [sym_decimal_integer_literal] = ACTIONS(642),
    [sym_hex_integer_literal] = ACTIONS(642),
    [sym_octal_integer_literal] = ACTIONS(640),
    [sym_binary_integer_literal] = ACTIONS(640),
    [sym_decimal_floating_point_literal] = ACTIONS(640),
    [sym_hex_floating_point_literal] = ACTIONS(642),
    [sym_true] = ACTIONS(642),
    [sym_false] = ACTIONS(642),
    [sym_character_literal] = ACTIONS(640),
    [sym_string_literal] = ACTIONS(640),
    [sym_null_literal] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(642),
    [anon_sym_DASH] = ACTIONS(642),
    [anon_sym_BANG] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(640),
    [anon_sym_PLUS_PLUS] = ACTIONS(640),
    [anon_sym_DASH_DASH] = ACTIONS(640),
    [anon_sym_new] = ACTIONS(642),
    [anon_sym_class] = ACTIONS(642),
    [anon_sym_SEMI] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_assert] = ACTIONS(642),
    [anon_sym_switch] = ACTIONS(642),
    [anon_sym_case] = ACTIONS(642),
    [anon_sym_default] = ACTIONS(642),
    [anon_sym_do] = ACTIONS(642),
    [anon_sym_while] = ACTIONS(642),
    [anon_sym_break] = ACTIONS(642),
    [anon_sym_continue] = ACTIONS(642),
    [anon_sym_return] = ACTIONS(642),
    [anon_sym_synchronized] = ACTIONS(642),
    [anon_sym_throw] = ACTIONS(642),
    [anon_sym_try] = ACTIONS(642),
    [anon_sym_if] = ACTIONS(642),
    [anon_sym_else] = ACTIONS(642),
    [anon_sym_for] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(642),
    [anon_sym_open] = ACTIONS(642),
    [anon_sym_module] = ACTIONS(642),
    [anon_sym_static] = ACTIONS(642),
    [anon_sym_package] = ACTIONS(642),
    [anon_sym_import] = ACTIONS(642),
    [anon_sym_enum] = ACTIONS(642),
    [anon_sym_public] = ACTIONS(642),
    [anon_sym_protected] = ACTIONS(642),
    [anon_sym_private] = ACTIONS(642),
    [anon_sym_abstract] = ACTIONS(642),
    [anon_sym_final] = ACTIONS(642),
    [anon_sym_strictfp] = ACTIONS(642),
    [anon_sym_native] = ACTIONS(642),
    [anon_sym_transient] = ACTIONS(642),
    [anon_sym_volatile] = ACTIONS(642),
    [anon_sym_ATinterface] = ACTIONS(640),
    [anon_sym_interface] = ACTIONS(642),
    [anon_sym_byte] = ACTIONS(642),
    [anon_sym_short] = ACTIONS(642),
    [anon_sym_int] = ACTIONS(642),
    [anon_sym_long] = ACTIONS(642),
    [anon_sym_char] = ACTIONS(642),
    [anon_sym_float] = ACTIONS(642),
    [anon_sym_double] = ACTIONS(642),
    [sym_boolean_type] = ACTIONS(642),
    [sym_void_type] = ACTIONS(642),
    [sym_this] = ACTIONS(642),
    [sym_super] = ACTIONS(642),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(644),
    [sym_identifier] = ACTIONS(646),
    [sym_decimal_integer_literal] = ACTIONS(646),
    [sym_hex_integer_literal] = ACTIONS(646),
    [sym_octal_integer_literal] = ACTIONS(644),
    [sym_binary_integer_literal] = ACTIONS(644),
    [sym_decimal_floating_point_literal] = ACTIONS(644),
    [sym_hex_floating_point_literal] = ACTIONS(646),
    [sym_true] = ACTIONS(646),
    [sym_false] = ACTIONS(646),
    [sym_character_literal] = ACTIONS(644),
    [sym_string_literal] = ACTIONS(644),
    [sym_null_literal] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(644),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_DASH] = ACTIONS(646),
    [anon_sym_BANG] = ACTIONS(644),
    [anon_sym_TILDE] = ACTIONS(644),
    [anon_sym_PLUS_PLUS] = ACTIONS(644),
    [anon_sym_DASH_DASH] = ACTIONS(644),
    [anon_sym_new] = ACTIONS(646),
    [anon_sym_class] = ACTIONS(646),
    [anon_sym_SEMI] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(644),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_assert] = ACTIONS(646),
    [anon_sym_switch] = ACTIONS(646),
    [anon_sym_case] = ACTIONS(646),
    [anon_sym_default] = ACTIONS(646),
    [anon_sym_do] = ACTIONS(646),
    [anon_sym_while] = ACTIONS(646),
    [anon_sym_break] = ACTIONS(646),
    [anon_sym_continue] = ACTIONS(646),
    [anon_sym_return] = ACTIONS(646),
    [anon_sym_synchronized] = ACTIONS(646),
    [anon_sym_throw] = ACTIONS(646),
    [anon_sym_try] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(646),
    [anon_sym_else] = ACTIONS(646),
    [anon_sym_for] = ACTIONS(646),
    [anon_sym_AT] = ACTIONS(646),
    [anon_sym_open] = ACTIONS(646),
    [anon_sym_module] = ACTIONS(646),
    [anon_sym_static] = ACTIONS(646),
    [anon_sym_package] = ACTIONS(646),
    [anon_sym_import] = ACTIONS(646),
    [anon_sym_enum] = ACTIONS(646),
    [anon_sym_public] = ACTIONS(646),
    [anon_sym_protected] = ACTIONS(646),
    [anon_sym_private] = ACTIONS(646),
    [anon_sym_abstract] = ACTIONS(646),
    [anon_sym_final] = ACTIONS(646),
    [anon_sym_strictfp] = ACTIONS(646),
    [anon_sym_native] = ACTIONS(646),
    [anon_sym_transient] = ACTIONS(646),
    [anon_sym_volatile] = ACTIONS(646),
    [anon_sym_ATinterface] = ACTIONS(644),
    [anon_sym_interface] = ACTIONS(646),
    [anon_sym_byte] = ACTIONS(646),
    [anon_sym_short] = ACTIONS(646),
    [anon_sym_int] = ACTIONS(646),
    [anon_sym_long] = ACTIONS(646),
    [anon_sym_char] = ACTIONS(646),
    [anon_sym_float] = ACTIONS(646),
    [anon_sym_double] = ACTIONS(646),
    [sym_boolean_type] = ACTIONS(646),
    [sym_void_type] = ACTIONS(646),
    [sym_this] = ACTIONS(646),
    [sym_super] = ACTIONS(646),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(648),
    [sym_identifier] = ACTIONS(650),
    [sym_decimal_integer_literal] = ACTIONS(650),
    [sym_hex_integer_literal] = ACTIONS(650),
    [sym_octal_integer_literal] = ACTIONS(648),
    [sym_binary_integer_literal] = ACTIONS(648),
    [sym_decimal_floating_point_literal] = ACTIONS(648),
    [sym_hex_floating_point_literal] = ACTIONS(650),
    [sym_true] = ACTIONS(650),
    [sym_false] = ACTIONS(650),
    [sym_character_literal] = ACTIONS(648),
    [sym_string_literal] = ACTIONS(648),
    [sym_null_literal] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(648),
    [anon_sym_TILDE] = ACTIONS(648),
    [anon_sym_PLUS_PLUS] = ACTIONS(648),
    [anon_sym_DASH_DASH] = ACTIONS(648),
    [anon_sym_new] = ACTIONS(650),
    [anon_sym_class] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(648),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_assert] = ACTIONS(650),
    [anon_sym_switch] = ACTIONS(650),
    [anon_sym_case] = ACTIONS(650),
    [anon_sym_default] = ACTIONS(650),
    [anon_sym_do] = ACTIONS(650),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_break] = ACTIONS(650),
    [anon_sym_continue] = ACTIONS(650),
    [anon_sym_return] = ACTIONS(650),
    [anon_sym_synchronized] = ACTIONS(650),
    [anon_sym_throw] = ACTIONS(650),
    [anon_sym_try] = ACTIONS(650),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_open] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(650),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_package] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(650),
    [anon_sym_enum] = ACTIONS(650),
    [anon_sym_public] = ACTIONS(650),
    [anon_sym_protected] = ACTIONS(650),
    [anon_sym_private] = ACTIONS(650),
    [anon_sym_abstract] = ACTIONS(650),
    [anon_sym_final] = ACTIONS(650),
    [anon_sym_strictfp] = ACTIONS(650),
    [anon_sym_native] = ACTIONS(650),
    [anon_sym_transient] = ACTIONS(650),
    [anon_sym_volatile] = ACTIONS(650),
    [anon_sym_ATinterface] = ACTIONS(648),
    [anon_sym_interface] = ACTIONS(650),
    [anon_sym_byte] = ACTIONS(650),
    [anon_sym_short] = ACTIONS(650),
    [anon_sym_int] = ACTIONS(650),
    [anon_sym_long] = ACTIONS(650),
    [anon_sym_char] = ACTIONS(650),
    [anon_sym_float] = ACTIONS(650),
    [anon_sym_double] = ACTIONS(650),
    [sym_boolean_type] = ACTIONS(650),
    [sym_void_type] = ACTIONS(650),
    [sym_this] = ACTIONS(650),
    [sym_super] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(392),
    [sym_cast_expression] = STATE(392),
    [sym_assignment_expression] = STATE(392),
    [sym_binary_expression] = STATE(392),
    [sym_instanceof_expression] = STATE(392),
    [sym_lambda_expression] = STATE(392),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(392),
    [sym_unary_expression] = STATE(392),
    [sym_update_expression] = STATE(392),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym_block] = STATE(391),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym_identifier] = ACTIONS(654),
    [sym_decimal_integer_literal] = ACTIONS(654),
    [sym_hex_integer_literal] = ACTIONS(654),
    [sym_octal_integer_literal] = ACTIONS(652),
    [sym_binary_integer_literal] = ACTIONS(652),
    [sym_decimal_floating_point_literal] = ACTIONS(652),
    [sym_hex_floating_point_literal] = ACTIONS(654),
    [sym_true] = ACTIONS(654),
    [sym_false] = ACTIONS(654),
    [sym_character_literal] = ACTIONS(652),
    [sym_string_literal] = ACTIONS(652),
    [sym_null_literal] = ACTIONS(654),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [anon_sym_new] = ACTIONS(654),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_assert] = ACTIONS(654),
    [anon_sym_switch] = ACTIONS(654),
    [anon_sym_case] = ACTIONS(654),
    [anon_sym_default] = ACTIONS(654),
    [anon_sym_do] = ACTIONS(654),
    [anon_sym_while] = ACTIONS(654),
    [anon_sym_break] = ACTIONS(654),
    [anon_sym_continue] = ACTIONS(654),
    [anon_sym_return] = ACTIONS(654),
    [anon_sym_synchronized] = ACTIONS(654),
    [anon_sym_throw] = ACTIONS(654),
    [anon_sym_try] = ACTIONS(654),
    [anon_sym_if] = ACTIONS(654),
    [anon_sym_else] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_open] = ACTIONS(654),
    [anon_sym_module] = ACTIONS(654),
    [anon_sym_static] = ACTIONS(654),
    [anon_sym_package] = ACTIONS(654),
    [anon_sym_import] = ACTIONS(654),
    [anon_sym_enum] = ACTIONS(654),
    [anon_sym_public] = ACTIONS(654),
    [anon_sym_protected] = ACTIONS(654),
    [anon_sym_private] = ACTIONS(654),
    [anon_sym_abstract] = ACTIONS(654),
    [anon_sym_final] = ACTIONS(654),
    [anon_sym_strictfp] = ACTIONS(654),
    [anon_sym_native] = ACTIONS(654),
    [anon_sym_transient] = ACTIONS(654),
    [anon_sym_volatile] = ACTIONS(654),
    [anon_sym_ATinterface] = ACTIONS(652),
    [anon_sym_interface] = ACTIONS(654),
    [anon_sym_byte] = ACTIONS(654),
    [anon_sym_short] = ACTIONS(654),
    [anon_sym_int] = ACTIONS(654),
    [anon_sym_long] = ACTIONS(654),
    [anon_sym_char] = ACTIONS(654),
    [anon_sym_float] = ACTIONS(654),
    [anon_sym_double] = ACTIONS(654),
    [sym_boolean_type] = ACTIONS(654),
    [sym_void_type] = ACTIONS(654),
    [sym_this] = ACTIONS(654),
    [sym_super] = ACTIONS(654),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(656),
    [sym_identifier] = ACTIONS(658),
    [sym_decimal_integer_literal] = ACTIONS(658),
    [sym_hex_integer_literal] = ACTIONS(658),
    [sym_octal_integer_literal] = ACTIONS(656),
    [sym_binary_integer_literal] = ACTIONS(656),
    [sym_decimal_floating_point_literal] = ACTIONS(656),
    [sym_hex_floating_point_literal] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_character_literal] = ACTIONS(656),
    [sym_string_literal] = ACTIONS(656),
    [sym_null_literal] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(656),
    [anon_sym_LT] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_BANG] = ACTIONS(656),
    [anon_sym_TILDE] = ACTIONS(656),
    [anon_sym_PLUS_PLUS] = ACTIONS(656),
    [anon_sym_DASH_DASH] = ACTIONS(656),
    [anon_sym_new] = ACTIONS(658),
    [anon_sym_class] = ACTIONS(658),
    [anon_sym_SEMI] = ACTIONS(656),
    [anon_sym_LBRACE] = ACTIONS(656),
    [anon_sym_RBRACE] = ACTIONS(656),
    [anon_sym_assert] = ACTIONS(658),
    [anon_sym_switch] = ACTIONS(658),
    [anon_sym_case] = ACTIONS(658),
    [anon_sym_default] = ACTIONS(658),
    [anon_sym_do] = ACTIONS(658),
    [anon_sym_while] = ACTIONS(658),
    [anon_sym_break] = ACTIONS(658),
    [anon_sym_continue] = ACTIONS(658),
    [anon_sym_return] = ACTIONS(658),
    [anon_sym_synchronized] = ACTIONS(658),
    [anon_sym_throw] = ACTIONS(658),
    [anon_sym_try] = ACTIONS(658),
    [anon_sym_if] = ACTIONS(658),
    [anon_sym_else] = ACTIONS(658),
    [anon_sym_for] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(658),
    [anon_sym_open] = ACTIONS(658),
    [anon_sym_module] = ACTIONS(658),
    [anon_sym_static] = ACTIONS(658),
    [anon_sym_package] = ACTIONS(658),
    [anon_sym_import] = ACTIONS(658),
    [anon_sym_enum] = ACTIONS(658),
    [anon_sym_public] = ACTIONS(658),
    [anon_sym_protected] = ACTIONS(658),
    [anon_sym_private] = ACTIONS(658),
    [anon_sym_abstract] = ACTIONS(658),
    [anon_sym_final] = ACTIONS(658),
    [anon_sym_strictfp] = ACTIONS(658),
    [anon_sym_native] = ACTIONS(658),
    [anon_sym_transient] = ACTIONS(658),
    [anon_sym_volatile] = ACTIONS(658),
    [anon_sym_ATinterface] = ACTIONS(656),
    [anon_sym_interface] = ACTIONS(658),
    [anon_sym_byte] = ACTIONS(658),
    [anon_sym_short] = ACTIONS(658),
    [anon_sym_int] = ACTIONS(658),
    [anon_sym_long] = ACTIONS(658),
    [anon_sym_char] = ACTIONS(658),
    [anon_sym_float] = ACTIONS(658),
    [anon_sym_double] = ACTIONS(658),
    [sym_boolean_type] = ACTIONS(658),
    [sym_void_type] = ACTIONS(658),
    [sym_this] = ACTIONS(658),
    [sym_super] = ACTIONS(658),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(660),
    [sym_identifier] = ACTIONS(662),
    [sym_decimal_integer_literal] = ACTIONS(662),
    [sym_hex_integer_literal] = ACTIONS(662),
    [sym_octal_integer_literal] = ACTIONS(660),
    [sym_binary_integer_literal] = ACTIONS(660),
    [sym_decimal_floating_point_literal] = ACTIONS(660),
    [sym_hex_floating_point_literal] = ACTIONS(662),
    [sym_true] = ACTIONS(662),
    [sym_false] = ACTIONS(662),
    [sym_character_literal] = ACTIONS(660),
    [sym_string_literal] = ACTIONS(660),
    [sym_null_literal] = ACTIONS(662),
    [anon_sym_LPAREN] = ACTIONS(660),
    [anon_sym_LT] = ACTIONS(660),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(660),
    [anon_sym_TILDE] = ACTIONS(660),
    [anon_sym_PLUS_PLUS] = ACTIONS(660),
    [anon_sym_DASH_DASH] = ACTIONS(660),
    [anon_sym_new] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(662),
    [anon_sym_SEMI] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(660),
    [anon_sym_RBRACE] = ACTIONS(660),
    [anon_sym_assert] = ACTIONS(662),
    [anon_sym_switch] = ACTIONS(662),
    [anon_sym_case] = ACTIONS(662),
    [anon_sym_default] = ACTIONS(662),
    [anon_sym_do] = ACTIONS(662),
    [anon_sym_while] = ACTIONS(662),
    [anon_sym_break] = ACTIONS(662),
    [anon_sym_continue] = ACTIONS(662),
    [anon_sym_return] = ACTIONS(662),
    [anon_sym_synchronized] = ACTIONS(662),
    [anon_sym_throw] = ACTIONS(662),
    [anon_sym_try] = ACTIONS(662),
    [anon_sym_if] = ACTIONS(662),
    [anon_sym_else] = ACTIONS(662),
    [anon_sym_for] = ACTIONS(662),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_open] = ACTIONS(662),
    [anon_sym_module] = ACTIONS(662),
    [anon_sym_static] = ACTIONS(662),
    [anon_sym_package] = ACTIONS(662),
    [anon_sym_import] = ACTIONS(662),
    [anon_sym_enum] = ACTIONS(662),
    [anon_sym_public] = ACTIONS(662),
    [anon_sym_protected] = ACTIONS(662),
    [anon_sym_private] = ACTIONS(662),
    [anon_sym_abstract] = ACTIONS(662),
    [anon_sym_final] = ACTIONS(662),
    [anon_sym_strictfp] = ACTIONS(662),
    [anon_sym_native] = ACTIONS(662),
    [anon_sym_transient] = ACTIONS(662),
    [anon_sym_volatile] = ACTIONS(662),
    [anon_sym_ATinterface] = ACTIONS(660),
    [anon_sym_interface] = ACTIONS(662),
    [anon_sym_byte] = ACTIONS(662),
    [anon_sym_short] = ACTIONS(662),
    [anon_sym_int] = ACTIONS(662),
    [anon_sym_long] = ACTIONS(662),
    [anon_sym_char] = ACTIONS(662),
    [anon_sym_float] = ACTIONS(662),
    [anon_sym_double] = ACTIONS(662),
    [sym_boolean_type] = ACTIONS(662),
    [sym_void_type] = ACTIONS(662),
    [sym_this] = ACTIONS(662),
    [sym_super] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(664),
    [sym_identifier] = ACTIONS(666),
    [sym_decimal_integer_literal] = ACTIONS(666),
    [sym_hex_integer_literal] = ACTIONS(666),
    [sym_octal_integer_literal] = ACTIONS(664),
    [sym_binary_integer_literal] = ACTIONS(664),
    [sym_decimal_floating_point_literal] = ACTIONS(664),
    [sym_hex_floating_point_literal] = ACTIONS(666),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_character_literal] = ACTIONS(664),
    [sym_string_literal] = ACTIONS(664),
    [sym_null_literal] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(666),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_TILDE] = ACTIONS(664),
    [anon_sym_PLUS_PLUS] = ACTIONS(664),
    [anon_sym_DASH_DASH] = ACTIONS(664),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(666),
    [anon_sym_SEMI] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_assert] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(666),
    [anon_sym_case] = ACTIONS(666),
    [anon_sym_default] = ACTIONS(666),
    [anon_sym_do] = ACTIONS(666),
    [anon_sym_while] = ACTIONS(666),
    [anon_sym_break] = ACTIONS(666),
    [anon_sym_continue] = ACTIONS(666),
    [anon_sym_return] = ACTIONS(666),
    [anon_sym_synchronized] = ACTIONS(666),
    [anon_sym_throw] = ACTIONS(666),
    [anon_sym_try] = ACTIONS(666),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_else] = ACTIONS(666),
    [anon_sym_for] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(666),
    [anon_sym_open] = ACTIONS(666),
    [anon_sym_module] = ACTIONS(666),
    [anon_sym_static] = ACTIONS(666),
    [anon_sym_package] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(666),
    [anon_sym_enum] = ACTIONS(666),
    [anon_sym_public] = ACTIONS(666),
    [anon_sym_protected] = ACTIONS(666),
    [anon_sym_private] = ACTIONS(666),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_final] = ACTIONS(666),
    [anon_sym_strictfp] = ACTIONS(666),
    [anon_sym_native] = ACTIONS(666),
    [anon_sym_transient] = ACTIONS(666),
    [anon_sym_volatile] = ACTIONS(666),
    [anon_sym_ATinterface] = ACTIONS(664),
    [anon_sym_interface] = ACTIONS(666),
    [anon_sym_byte] = ACTIONS(666),
    [anon_sym_short] = ACTIONS(666),
    [anon_sym_int] = ACTIONS(666),
    [anon_sym_long] = ACTIONS(666),
    [anon_sym_char] = ACTIONS(666),
    [anon_sym_float] = ACTIONS(666),
    [anon_sym_double] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(666),
    [sym_void_type] = ACTIONS(666),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(666),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(668),
    [sym_identifier] = ACTIONS(670),
    [sym_decimal_integer_literal] = ACTIONS(670),
    [sym_hex_integer_literal] = ACTIONS(670),
    [sym_octal_integer_literal] = ACTIONS(668),
    [sym_binary_integer_literal] = ACTIONS(668),
    [sym_decimal_floating_point_literal] = ACTIONS(668),
    [sym_hex_floating_point_literal] = ACTIONS(670),
    [sym_true] = ACTIONS(670),
    [sym_false] = ACTIONS(670),
    [sym_character_literal] = ACTIONS(668),
    [sym_string_literal] = ACTIONS(668),
    [sym_null_literal] = ACTIONS(670),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(670),
    [anon_sym_DASH] = ACTIONS(670),
    [anon_sym_BANG] = ACTIONS(668),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_PLUS_PLUS] = ACTIONS(668),
    [anon_sym_DASH_DASH] = ACTIONS(668),
    [anon_sym_new] = ACTIONS(670),
    [anon_sym_class] = ACTIONS(670),
    [anon_sym_SEMI] = ACTIONS(668),
    [anon_sym_LBRACE] = ACTIONS(668),
    [anon_sym_RBRACE] = ACTIONS(668),
    [anon_sym_assert] = ACTIONS(670),
    [anon_sym_switch] = ACTIONS(670),
    [anon_sym_case] = ACTIONS(670),
    [anon_sym_default] = ACTIONS(670),
    [anon_sym_do] = ACTIONS(670),
    [anon_sym_while] = ACTIONS(670),
    [anon_sym_break] = ACTIONS(670),
    [anon_sym_continue] = ACTIONS(670),
    [anon_sym_return] = ACTIONS(670),
    [anon_sym_synchronized] = ACTIONS(670),
    [anon_sym_throw] = ACTIONS(670),
    [anon_sym_try] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_else] = ACTIONS(670),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_AT] = ACTIONS(670),
    [anon_sym_open] = ACTIONS(670),
    [anon_sym_module] = ACTIONS(670),
    [anon_sym_static] = ACTIONS(670),
    [anon_sym_package] = ACTIONS(670),
    [anon_sym_import] = ACTIONS(670),
    [anon_sym_enum] = ACTIONS(670),
    [anon_sym_public] = ACTIONS(670),
    [anon_sym_protected] = ACTIONS(670),
    [anon_sym_private] = ACTIONS(670),
    [anon_sym_abstract] = ACTIONS(670),
    [anon_sym_final] = ACTIONS(670),
    [anon_sym_strictfp] = ACTIONS(670),
    [anon_sym_native] = ACTIONS(670),
    [anon_sym_transient] = ACTIONS(670),
    [anon_sym_volatile] = ACTIONS(670),
    [anon_sym_ATinterface] = ACTIONS(668),
    [anon_sym_interface] = ACTIONS(670),
    [anon_sym_byte] = ACTIONS(670),
    [anon_sym_short] = ACTIONS(670),
    [anon_sym_int] = ACTIONS(670),
    [anon_sym_long] = ACTIONS(670),
    [anon_sym_char] = ACTIONS(670),
    [anon_sym_float] = ACTIONS(670),
    [anon_sym_double] = ACTIONS(670),
    [sym_boolean_type] = ACTIONS(670),
    [sym_void_type] = ACTIONS(670),
    [sym_this] = ACTIONS(670),
    [sym_super] = ACTIONS(670),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(672),
    [sym_identifier] = ACTIONS(674),
    [sym_decimal_integer_literal] = ACTIONS(674),
    [sym_hex_integer_literal] = ACTIONS(674),
    [sym_octal_integer_literal] = ACTIONS(672),
    [sym_binary_integer_literal] = ACTIONS(672),
    [sym_decimal_floating_point_literal] = ACTIONS(672),
    [sym_hex_floating_point_literal] = ACTIONS(674),
    [sym_true] = ACTIONS(674),
    [sym_false] = ACTIONS(674),
    [sym_character_literal] = ACTIONS(672),
    [sym_string_literal] = ACTIONS(672),
    [sym_null_literal] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_BANG] = ACTIONS(672),
    [anon_sym_TILDE] = ACTIONS(672),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_new] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(674),
    [anon_sym_SEMI] = ACTIONS(672),
    [anon_sym_LBRACE] = ACTIONS(672),
    [anon_sym_RBRACE] = ACTIONS(672),
    [anon_sym_assert] = ACTIONS(674),
    [anon_sym_switch] = ACTIONS(674),
    [anon_sym_case] = ACTIONS(674),
    [anon_sym_default] = ACTIONS(674),
    [anon_sym_do] = ACTIONS(674),
    [anon_sym_while] = ACTIONS(674),
    [anon_sym_break] = ACTIONS(674),
    [anon_sym_continue] = ACTIONS(674),
    [anon_sym_return] = ACTIONS(674),
    [anon_sym_synchronized] = ACTIONS(674),
    [anon_sym_throw] = ACTIONS(674),
    [anon_sym_try] = ACTIONS(674),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_else] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(674),
    [anon_sym_open] = ACTIONS(674),
    [anon_sym_module] = ACTIONS(674),
    [anon_sym_static] = ACTIONS(674),
    [anon_sym_package] = ACTIONS(674),
    [anon_sym_import] = ACTIONS(674),
    [anon_sym_enum] = ACTIONS(674),
    [anon_sym_public] = ACTIONS(674),
    [anon_sym_protected] = ACTIONS(674),
    [anon_sym_private] = ACTIONS(674),
    [anon_sym_abstract] = ACTIONS(674),
    [anon_sym_final] = ACTIONS(674),
    [anon_sym_strictfp] = ACTIONS(674),
    [anon_sym_native] = ACTIONS(674),
    [anon_sym_transient] = ACTIONS(674),
    [anon_sym_volatile] = ACTIONS(674),
    [anon_sym_ATinterface] = ACTIONS(672),
    [anon_sym_interface] = ACTIONS(674),
    [anon_sym_byte] = ACTIONS(674),
    [anon_sym_short] = ACTIONS(674),
    [anon_sym_int] = ACTIONS(674),
    [anon_sym_long] = ACTIONS(674),
    [anon_sym_char] = ACTIONS(674),
    [anon_sym_float] = ACTIONS(674),
    [anon_sym_double] = ACTIONS(674),
    [sym_boolean_type] = ACTIONS(674),
    [sym_void_type] = ACTIONS(674),
    [sym_this] = ACTIONS(674),
    [sym_super] = ACTIONS(674),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(676),
    [sym_identifier] = ACTIONS(678),
    [sym_decimal_integer_literal] = ACTIONS(678),
    [sym_hex_integer_literal] = ACTIONS(678),
    [sym_octal_integer_literal] = ACTIONS(676),
    [sym_binary_integer_literal] = ACTIONS(676),
    [sym_decimal_floating_point_literal] = ACTIONS(676),
    [sym_hex_floating_point_literal] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_character_literal] = ACTIONS(676),
    [sym_string_literal] = ACTIONS(676),
    [sym_null_literal] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_BANG] = ACTIONS(676),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_PLUS_PLUS] = ACTIONS(676),
    [anon_sym_DASH_DASH] = ACTIONS(676),
    [anon_sym_new] = ACTIONS(678),
    [anon_sym_class] = ACTIONS(678),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_RBRACE] = ACTIONS(676),
    [anon_sym_assert] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_case] = ACTIONS(678),
    [anon_sym_default] = ACTIONS(678),
    [anon_sym_do] = ACTIONS(678),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_break] = ACTIONS(678),
    [anon_sym_continue] = ACTIONS(678),
    [anon_sym_return] = ACTIONS(678),
    [anon_sym_synchronized] = ACTIONS(678),
    [anon_sym_throw] = ACTIONS(678),
    [anon_sym_try] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_else] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(678),
    [anon_sym_open] = ACTIONS(678),
    [anon_sym_module] = ACTIONS(678),
    [anon_sym_static] = ACTIONS(678),
    [anon_sym_package] = ACTIONS(678),
    [anon_sym_import] = ACTIONS(678),
    [anon_sym_enum] = ACTIONS(678),
    [anon_sym_public] = ACTIONS(678),
    [anon_sym_protected] = ACTIONS(678),
    [anon_sym_private] = ACTIONS(678),
    [anon_sym_abstract] = ACTIONS(678),
    [anon_sym_final] = ACTIONS(678),
    [anon_sym_strictfp] = ACTIONS(678),
    [anon_sym_native] = ACTIONS(678),
    [anon_sym_transient] = ACTIONS(678),
    [anon_sym_volatile] = ACTIONS(678),
    [anon_sym_ATinterface] = ACTIONS(676),
    [anon_sym_interface] = ACTIONS(678),
    [anon_sym_byte] = ACTIONS(678),
    [anon_sym_short] = ACTIONS(678),
    [anon_sym_int] = ACTIONS(678),
    [anon_sym_long] = ACTIONS(678),
    [anon_sym_char] = ACTIONS(678),
    [anon_sym_float] = ACTIONS(678),
    [anon_sym_double] = ACTIONS(678),
    [sym_boolean_type] = ACTIONS(678),
    [sym_void_type] = ACTIONS(678),
    [sym_this] = ACTIONS(678),
    [sym_super] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(414),
    [sym_cast_expression] = STATE(414),
    [sym_assignment_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_instanceof_expression] = STATE(414),
    [sym_lambda_expression] = STATE(414),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_update_expression] = STATE(414),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(413),
    [sym_cast_expression] = STATE(413),
    [sym_assignment_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_instanceof_expression] = STATE(413),
    [sym_lambda_expression] = STATE(413),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(682),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(445),
    [sym_cast_expression] = STATE(445),
    [sym_assignment_expression] = STATE(445),
    [sym_binary_expression] = STATE(445),
    [sym_instanceof_expression] = STATE(445),
    [sym_lambda_expression] = STATE(445),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(445),
    [sym_unary_expression] = STATE(445),
    [sym_update_expression] = STATE(445),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(411),
    [sym_cast_expression] = STATE(411),
    [sym_assignment_expression] = STATE(411),
    [sym_binary_expression] = STATE(411),
    [sym_instanceof_expression] = STATE(411),
    [sym_lambda_expression] = STATE(411),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(411),
    [sym_unary_expression] = STATE(411),
    [sym_update_expression] = STATE(411),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(686),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(688),
    [sym_identifier] = ACTIONS(690),
    [sym_decimal_integer_literal] = ACTIONS(690),
    [sym_hex_integer_literal] = ACTIONS(690),
    [sym_octal_integer_literal] = ACTIONS(688),
    [sym_binary_integer_literal] = ACTIONS(688),
    [sym_decimal_floating_point_literal] = ACTIONS(688),
    [sym_hex_floating_point_literal] = ACTIONS(690),
    [sym_true] = ACTIONS(690),
    [sym_false] = ACTIONS(690),
    [sym_character_literal] = ACTIONS(688),
    [sym_string_literal] = ACTIONS(688),
    [sym_null_literal] = ACTIONS(690),
    [anon_sym_LPAREN] = ACTIONS(688),
    [anon_sym_PLUS] = ACTIONS(690),
    [anon_sym_DASH] = ACTIONS(690),
    [anon_sym_BANG] = ACTIONS(688),
    [anon_sym_TILDE] = ACTIONS(688),
    [anon_sym_PLUS_PLUS] = ACTIONS(688),
    [anon_sym_DASH_DASH] = ACTIONS(688),
    [anon_sym_new] = ACTIONS(690),
    [anon_sym_class] = ACTIONS(690),
    [anon_sym_SEMI] = ACTIONS(688),
    [anon_sym_LBRACE] = ACTIONS(688),
    [anon_sym_RBRACE] = ACTIONS(688),
    [anon_sym_assert] = ACTIONS(690),
    [anon_sym_switch] = ACTIONS(690),
    [anon_sym_case] = ACTIONS(690),
    [anon_sym_default] = ACTIONS(690),
    [anon_sym_do] = ACTIONS(690),
    [anon_sym_while] = ACTIONS(690),
    [anon_sym_break] = ACTIONS(690),
    [anon_sym_continue] = ACTIONS(690),
    [anon_sym_return] = ACTIONS(690),
    [anon_sym_synchronized] = ACTIONS(690),
    [anon_sym_throw] = ACTIONS(690),
    [anon_sym_try] = ACTIONS(690),
    [anon_sym_if] = ACTIONS(690),
    [anon_sym_else] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(690),
    [anon_sym_AT] = ACTIONS(690),
    [anon_sym_open] = ACTIONS(690),
    [anon_sym_module] = ACTIONS(690),
    [anon_sym_static] = ACTIONS(690),
    [anon_sym_package] = ACTIONS(690),
    [anon_sym_import] = ACTIONS(690),
    [anon_sym_enum] = ACTIONS(690),
    [anon_sym_public] = ACTIONS(690),
    [anon_sym_protected] = ACTIONS(690),
    [anon_sym_private] = ACTIONS(690),
    [anon_sym_abstract] = ACTIONS(690),
    [anon_sym_final] = ACTIONS(690),
    [anon_sym_strictfp] = ACTIONS(690),
    [anon_sym_native] = ACTIONS(690),
    [anon_sym_transient] = ACTIONS(690),
    [anon_sym_volatile] = ACTIONS(690),
    [anon_sym_ATinterface] = ACTIONS(688),
    [anon_sym_interface] = ACTIONS(690),
    [anon_sym_byte] = ACTIONS(690),
    [anon_sym_short] = ACTIONS(690),
    [anon_sym_int] = ACTIONS(690),
    [anon_sym_long] = ACTIONS(690),
    [anon_sym_char] = ACTIONS(690),
    [anon_sym_float] = ACTIONS(690),
    [anon_sym_double] = ACTIONS(690),
    [sym_boolean_type] = ACTIONS(690),
    [sym_void_type] = ACTIONS(690),
    [sym_this] = ACTIONS(690),
    [sym_super] = ACTIONS(690),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(692),
    [sym_identifier] = ACTIONS(694),
    [sym_decimal_integer_literal] = ACTIONS(694),
    [sym_hex_integer_literal] = ACTIONS(694),
    [sym_octal_integer_literal] = ACTIONS(692),
    [sym_binary_integer_literal] = ACTIONS(692),
    [sym_decimal_floating_point_literal] = ACTIONS(692),
    [sym_hex_floating_point_literal] = ACTIONS(694),
    [sym_true] = ACTIONS(694),
    [sym_false] = ACTIONS(694),
    [sym_character_literal] = ACTIONS(692),
    [sym_string_literal] = ACTIONS(692),
    [sym_null_literal] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(692),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(692),
    [anon_sym_TILDE] = ACTIONS(692),
    [anon_sym_PLUS_PLUS] = ACTIONS(692),
    [anon_sym_DASH_DASH] = ACTIONS(692),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_class] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(692),
    [anon_sym_LBRACE] = ACTIONS(692),
    [anon_sym_RBRACE] = ACTIONS(692),
    [anon_sym_assert] = ACTIONS(694),
    [anon_sym_switch] = ACTIONS(694),
    [anon_sym_case] = ACTIONS(694),
    [anon_sym_default] = ACTIONS(694),
    [anon_sym_do] = ACTIONS(694),
    [anon_sym_while] = ACTIONS(694),
    [anon_sym_break] = ACTIONS(694),
    [anon_sym_continue] = ACTIONS(694),
    [anon_sym_return] = ACTIONS(694),
    [anon_sym_synchronized] = ACTIONS(694),
    [anon_sym_throw] = ACTIONS(694),
    [anon_sym_try] = ACTIONS(694),
    [anon_sym_if] = ACTIONS(694),
    [anon_sym_else] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_open] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(694),
    [anon_sym_static] = ACTIONS(694),
    [anon_sym_package] = ACTIONS(694),
    [anon_sym_import] = ACTIONS(694),
    [anon_sym_enum] = ACTIONS(694),
    [anon_sym_public] = ACTIONS(694),
    [anon_sym_protected] = ACTIONS(694),
    [anon_sym_private] = ACTIONS(694),
    [anon_sym_abstract] = ACTIONS(694),
    [anon_sym_final] = ACTIONS(694),
    [anon_sym_strictfp] = ACTIONS(694),
    [anon_sym_native] = ACTIONS(694),
    [anon_sym_transient] = ACTIONS(694),
    [anon_sym_volatile] = ACTIONS(694),
    [anon_sym_ATinterface] = ACTIONS(692),
    [anon_sym_interface] = ACTIONS(694),
    [anon_sym_byte] = ACTIONS(694),
    [anon_sym_short] = ACTIONS(694),
    [anon_sym_int] = ACTIONS(694),
    [anon_sym_long] = ACTIONS(694),
    [anon_sym_char] = ACTIONS(694),
    [anon_sym_float] = ACTIONS(694),
    [anon_sym_double] = ACTIONS(694),
    [sym_boolean_type] = ACTIONS(694),
    [sym_void_type] = ACTIONS(694),
    [sym_this] = ACTIONS(694),
    [sym_super] = ACTIONS(694),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(696),
    [sym_identifier] = ACTIONS(698),
    [sym_decimal_integer_literal] = ACTIONS(698),
    [sym_hex_integer_literal] = ACTIONS(698),
    [sym_octal_integer_literal] = ACTIONS(696),
    [sym_binary_integer_literal] = ACTIONS(696),
    [sym_decimal_floating_point_literal] = ACTIONS(696),
    [sym_hex_floating_point_literal] = ACTIONS(698),
    [sym_true] = ACTIONS(698),
    [sym_false] = ACTIONS(698),
    [sym_character_literal] = ACTIONS(696),
    [sym_string_literal] = ACTIONS(696),
    [sym_null_literal] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_PLUS_PLUS] = ACTIONS(696),
    [anon_sym_DASH_DASH] = ACTIONS(696),
    [anon_sym_new] = ACTIONS(698),
    [anon_sym_class] = ACTIONS(698),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_assert] = ACTIONS(698),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_case] = ACTIONS(698),
    [anon_sym_default] = ACTIONS(698),
    [anon_sym_do] = ACTIONS(698),
    [anon_sym_while] = ACTIONS(698),
    [anon_sym_break] = ACTIONS(698),
    [anon_sym_continue] = ACTIONS(698),
    [anon_sym_return] = ACTIONS(698),
    [anon_sym_synchronized] = ACTIONS(698),
    [anon_sym_throw] = ACTIONS(698),
    [anon_sym_try] = ACTIONS(698),
    [anon_sym_if] = ACTIONS(698),
    [anon_sym_else] = ACTIONS(698),
    [anon_sym_for] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(698),
    [anon_sym_open] = ACTIONS(698),
    [anon_sym_module] = ACTIONS(698),
    [anon_sym_static] = ACTIONS(698),
    [anon_sym_package] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(698),
    [anon_sym_enum] = ACTIONS(698),
    [anon_sym_public] = ACTIONS(698),
    [anon_sym_protected] = ACTIONS(698),
    [anon_sym_private] = ACTIONS(698),
    [anon_sym_abstract] = ACTIONS(698),
    [anon_sym_final] = ACTIONS(698),
    [anon_sym_strictfp] = ACTIONS(698),
    [anon_sym_native] = ACTIONS(698),
    [anon_sym_transient] = ACTIONS(698),
    [anon_sym_volatile] = ACTIONS(698),
    [anon_sym_ATinterface] = ACTIONS(696),
    [anon_sym_interface] = ACTIONS(698),
    [anon_sym_byte] = ACTIONS(698),
    [anon_sym_short] = ACTIONS(698),
    [anon_sym_int] = ACTIONS(698),
    [anon_sym_long] = ACTIONS(698),
    [anon_sym_char] = ACTIONS(698),
    [anon_sym_float] = ACTIONS(698),
    [anon_sym_double] = ACTIONS(698),
    [sym_boolean_type] = ACTIONS(698),
    [sym_void_type] = ACTIONS(698),
    [sym_this] = ACTIONS(698),
    [sym_super] = ACTIONS(698),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(700),
    [sym_identifier] = ACTIONS(702),
    [sym_decimal_integer_literal] = ACTIONS(702),
    [sym_hex_integer_literal] = ACTIONS(702),
    [sym_octal_integer_literal] = ACTIONS(700),
    [sym_binary_integer_literal] = ACTIONS(700),
    [sym_decimal_floating_point_literal] = ACTIONS(700),
    [sym_hex_floating_point_literal] = ACTIONS(702),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_character_literal] = ACTIONS(700),
    [sym_string_literal] = ACTIONS(700),
    [sym_null_literal] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(702),
    [anon_sym_BANG] = ACTIONS(700),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_PLUS_PLUS] = ACTIONS(700),
    [anon_sym_DASH_DASH] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(702),
    [anon_sym_class] = ACTIONS(702),
    [anon_sym_SEMI] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_assert] = ACTIONS(702),
    [anon_sym_switch] = ACTIONS(702),
    [anon_sym_case] = ACTIONS(702),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_do] = ACTIONS(702),
    [anon_sym_while] = ACTIONS(702),
    [anon_sym_break] = ACTIONS(702),
    [anon_sym_continue] = ACTIONS(702),
    [anon_sym_return] = ACTIONS(702),
    [anon_sym_synchronized] = ACTIONS(702),
    [anon_sym_throw] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_else] = ACTIONS(702),
    [anon_sym_for] = ACTIONS(702),
    [anon_sym_AT] = ACTIONS(702),
    [anon_sym_open] = ACTIONS(702),
    [anon_sym_module] = ACTIONS(702),
    [anon_sym_static] = ACTIONS(702),
    [anon_sym_package] = ACTIONS(702),
    [anon_sym_import] = ACTIONS(702),
    [anon_sym_enum] = ACTIONS(702),
    [anon_sym_public] = ACTIONS(702),
    [anon_sym_protected] = ACTIONS(702),
    [anon_sym_private] = ACTIONS(702),
    [anon_sym_abstract] = ACTIONS(702),
    [anon_sym_final] = ACTIONS(702),
    [anon_sym_strictfp] = ACTIONS(702),
    [anon_sym_native] = ACTIONS(702),
    [anon_sym_transient] = ACTIONS(702),
    [anon_sym_volatile] = ACTIONS(702),
    [anon_sym_ATinterface] = ACTIONS(700),
    [anon_sym_interface] = ACTIONS(702),
    [anon_sym_byte] = ACTIONS(702),
    [anon_sym_short] = ACTIONS(702),
    [anon_sym_int] = ACTIONS(702),
    [anon_sym_long] = ACTIONS(702),
    [anon_sym_char] = ACTIONS(702),
    [anon_sym_float] = ACTIONS(702),
    [anon_sym_double] = ACTIONS(702),
    [sym_boolean_type] = ACTIONS(702),
    [sym_void_type] = ACTIONS(702),
    [sym_this] = ACTIONS(702),
    [sym_super] = ACTIONS(702),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(704),
    [sym_identifier] = ACTIONS(706),
    [sym_decimal_integer_literal] = ACTIONS(706),
    [sym_hex_integer_literal] = ACTIONS(706),
    [sym_octal_integer_literal] = ACTIONS(704),
    [sym_binary_integer_literal] = ACTIONS(704),
    [sym_decimal_floating_point_literal] = ACTIONS(704),
    [sym_hex_floating_point_literal] = ACTIONS(706),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_character_literal] = ACTIONS(704),
    [sym_string_literal] = ACTIONS(704),
    [sym_null_literal] = ACTIONS(706),
    [anon_sym_LPAREN] = ACTIONS(704),
    [anon_sym_PLUS] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(706),
    [anon_sym_BANG] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(704),
    [anon_sym_PLUS_PLUS] = ACTIONS(704),
    [anon_sym_DASH_DASH] = ACTIONS(704),
    [anon_sym_new] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(706),
    [anon_sym_SEMI] = ACTIONS(704),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_RBRACE] = ACTIONS(704),
    [anon_sym_assert] = ACTIONS(706),
    [anon_sym_switch] = ACTIONS(706),
    [anon_sym_case] = ACTIONS(706),
    [anon_sym_default] = ACTIONS(706),
    [anon_sym_do] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_break] = ACTIONS(706),
    [anon_sym_continue] = ACTIONS(706),
    [anon_sym_return] = ACTIONS(706),
    [anon_sym_synchronized] = ACTIONS(706),
    [anon_sym_throw] = ACTIONS(706),
    [anon_sym_try] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(706),
    [anon_sym_else] = ACTIONS(706),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_open] = ACTIONS(706),
    [anon_sym_module] = ACTIONS(706),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_package] = ACTIONS(706),
    [anon_sym_import] = ACTIONS(706),
    [anon_sym_enum] = ACTIONS(706),
    [anon_sym_public] = ACTIONS(706),
    [anon_sym_protected] = ACTIONS(706),
    [anon_sym_private] = ACTIONS(706),
    [anon_sym_abstract] = ACTIONS(706),
    [anon_sym_final] = ACTIONS(706),
    [anon_sym_strictfp] = ACTIONS(706),
    [anon_sym_native] = ACTIONS(706),
    [anon_sym_transient] = ACTIONS(706),
    [anon_sym_volatile] = ACTIONS(706),
    [anon_sym_ATinterface] = ACTIONS(704),
    [anon_sym_interface] = ACTIONS(706),
    [anon_sym_byte] = ACTIONS(706),
    [anon_sym_short] = ACTIONS(706),
    [anon_sym_int] = ACTIONS(706),
    [anon_sym_long] = ACTIONS(706),
    [anon_sym_char] = ACTIONS(706),
    [anon_sym_float] = ACTIONS(706),
    [anon_sym_double] = ACTIONS(706),
    [sym_boolean_type] = ACTIONS(706),
    [sym_void_type] = ACTIONS(706),
    [sym_this] = ACTIONS(706),
    [sym_super] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(708),
    [sym_identifier] = ACTIONS(710),
    [sym_decimal_integer_literal] = ACTIONS(710),
    [sym_hex_integer_literal] = ACTIONS(710),
    [sym_octal_integer_literal] = ACTIONS(708),
    [sym_binary_integer_literal] = ACTIONS(708),
    [sym_decimal_floating_point_literal] = ACTIONS(708),
    [sym_hex_floating_point_literal] = ACTIONS(710),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_character_literal] = ACTIONS(708),
    [sym_string_literal] = ACTIONS(708),
    [sym_null_literal] = ACTIONS(710),
    [anon_sym_LPAREN] = ACTIONS(708),
    [anon_sym_PLUS] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(710),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(708),
    [anon_sym_PLUS_PLUS] = ACTIONS(708),
    [anon_sym_DASH_DASH] = ACTIONS(708),
    [anon_sym_new] = ACTIONS(710),
    [anon_sym_class] = ACTIONS(710),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_assert] = ACTIONS(710),
    [anon_sym_switch] = ACTIONS(710),
    [anon_sym_case] = ACTIONS(710),
    [anon_sym_default] = ACTIONS(710),
    [anon_sym_do] = ACTIONS(710),
    [anon_sym_while] = ACTIONS(710),
    [anon_sym_break] = ACTIONS(710),
    [anon_sym_continue] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(710),
    [anon_sym_synchronized] = ACTIONS(710),
    [anon_sym_throw] = ACTIONS(710),
    [anon_sym_try] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(710),
    [anon_sym_else] = ACTIONS(710),
    [anon_sym_for] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_open] = ACTIONS(710),
    [anon_sym_module] = ACTIONS(710),
    [anon_sym_static] = ACTIONS(710),
    [anon_sym_package] = ACTIONS(710),
    [anon_sym_import] = ACTIONS(710),
    [anon_sym_enum] = ACTIONS(710),
    [anon_sym_public] = ACTIONS(710),
    [anon_sym_protected] = ACTIONS(710),
    [anon_sym_private] = ACTIONS(710),
    [anon_sym_abstract] = ACTIONS(710),
    [anon_sym_final] = ACTIONS(710),
    [anon_sym_strictfp] = ACTIONS(710),
    [anon_sym_native] = ACTIONS(710),
    [anon_sym_transient] = ACTIONS(710),
    [anon_sym_volatile] = ACTIONS(710),
    [anon_sym_ATinterface] = ACTIONS(708),
    [anon_sym_interface] = ACTIONS(710),
    [anon_sym_byte] = ACTIONS(710),
    [anon_sym_short] = ACTIONS(710),
    [anon_sym_int] = ACTIONS(710),
    [anon_sym_long] = ACTIONS(710),
    [anon_sym_char] = ACTIONS(710),
    [anon_sym_float] = ACTIONS(710),
    [anon_sym_double] = ACTIONS(710),
    [sym_boolean_type] = ACTIONS(710),
    [sym_void_type] = ACTIONS(710),
    [sym_this] = ACTIONS(710),
    [sym_super] = ACTIONS(710),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(712),
    [sym_identifier] = ACTIONS(714),
    [sym_decimal_integer_literal] = ACTIONS(714),
    [sym_hex_integer_literal] = ACTIONS(714),
    [sym_octal_integer_literal] = ACTIONS(712),
    [sym_binary_integer_literal] = ACTIONS(712),
    [sym_decimal_floating_point_literal] = ACTIONS(712),
    [sym_hex_floating_point_literal] = ACTIONS(714),
    [sym_true] = ACTIONS(714),
    [sym_false] = ACTIONS(714),
    [sym_character_literal] = ACTIONS(712),
    [sym_string_literal] = ACTIONS(712),
    [sym_null_literal] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(712),
    [anon_sym_PLUS] = ACTIONS(714),
    [anon_sym_DASH] = ACTIONS(714),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(712),
    [anon_sym_DASH_DASH] = ACTIONS(712),
    [anon_sym_new] = ACTIONS(714),
    [anon_sym_class] = ACTIONS(714),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_RBRACE] = ACTIONS(712),
    [anon_sym_assert] = ACTIONS(714),
    [anon_sym_switch] = ACTIONS(714),
    [anon_sym_case] = ACTIONS(714),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_do] = ACTIONS(714),
    [anon_sym_while] = ACTIONS(714),
    [anon_sym_break] = ACTIONS(714),
    [anon_sym_continue] = ACTIONS(714),
    [anon_sym_return] = ACTIONS(714),
    [anon_sym_synchronized] = ACTIONS(714),
    [anon_sym_throw] = ACTIONS(714),
    [anon_sym_try] = ACTIONS(714),
    [anon_sym_if] = ACTIONS(714),
    [anon_sym_else] = ACTIONS(714),
    [anon_sym_for] = ACTIONS(714),
    [anon_sym_AT] = ACTIONS(714),
    [anon_sym_open] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(714),
    [anon_sym_static] = ACTIONS(714),
    [anon_sym_package] = ACTIONS(714),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_enum] = ACTIONS(714),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_abstract] = ACTIONS(714),
    [anon_sym_final] = ACTIONS(714),
    [anon_sym_strictfp] = ACTIONS(714),
    [anon_sym_native] = ACTIONS(714),
    [anon_sym_transient] = ACTIONS(714),
    [anon_sym_volatile] = ACTIONS(714),
    [anon_sym_ATinterface] = ACTIONS(712),
    [anon_sym_interface] = ACTIONS(714),
    [anon_sym_byte] = ACTIONS(714),
    [anon_sym_short] = ACTIONS(714),
    [anon_sym_int] = ACTIONS(714),
    [anon_sym_long] = ACTIONS(714),
    [anon_sym_char] = ACTIONS(714),
    [anon_sym_float] = ACTIONS(714),
    [anon_sym_double] = ACTIONS(714),
    [sym_boolean_type] = ACTIONS(714),
    [sym_void_type] = ACTIONS(714),
    [sym_this] = ACTIONS(714),
    [sym_super] = ACTIONS(714),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(716),
    [sym_identifier] = ACTIONS(718),
    [sym_decimal_integer_literal] = ACTIONS(718),
    [sym_hex_integer_literal] = ACTIONS(718),
    [sym_octal_integer_literal] = ACTIONS(716),
    [sym_binary_integer_literal] = ACTIONS(716),
    [sym_decimal_floating_point_literal] = ACTIONS(716),
    [sym_hex_floating_point_literal] = ACTIONS(718),
    [sym_true] = ACTIONS(718),
    [sym_false] = ACTIONS(718),
    [sym_character_literal] = ACTIONS(716),
    [sym_string_literal] = ACTIONS(716),
    [sym_null_literal] = ACTIONS(718),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_PLUS] = ACTIONS(718),
    [anon_sym_DASH] = ACTIONS(718),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(716),
    [anon_sym_PLUS_PLUS] = ACTIONS(716),
    [anon_sym_DASH_DASH] = ACTIONS(716),
    [anon_sym_new] = ACTIONS(718),
    [anon_sym_class] = ACTIONS(718),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_assert] = ACTIONS(718),
    [anon_sym_switch] = ACTIONS(718),
    [anon_sym_case] = ACTIONS(718),
    [anon_sym_default] = ACTIONS(718),
    [anon_sym_do] = ACTIONS(718),
    [anon_sym_while] = ACTIONS(718),
    [anon_sym_break] = ACTIONS(718),
    [anon_sym_continue] = ACTIONS(718),
    [anon_sym_return] = ACTIONS(718),
    [anon_sym_synchronized] = ACTIONS(718),
    [anon_sym_throw] = ACTIONS(718),
    [anon_sym_try] = ACTIONS(718),
    [anon_sym_if] = ACTIONS(718),
    [anon_sym_else] = ACTIONS(718),
    [anon_sym_for] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(718),
    [anon_sym_open] = ACTIONS(718),
    [anon_sym_module] = ACTIONS(718),
    [anon_sym_static] = ACTIONS(718),
    [anon_sym_package] = ACTIONS(718),
    [anon_sym_import] = ACTIONS(718),
    [anon_sym_enum] = ACTIONS(718),
    [anon_sym_public] = ACTIONS(718),
    [anon_sym_protected] = ACTIONS(718),
    [anon_sym_private] = ACTIONS(718),
    [anon_sym_abstract] = ACTIONS(718),
    [anon_sym_final] = ACTIONS(718),
    [anon_sym_strictfp] = ACTIONS(718),
    [anon_sym_native] = ACTIONS(718),
    [anon_sym_transient] = ACTIONS(718),
    [anon_sym_volatile] = ACTIONS(718),
    [anon_sym_ATinterface] = ACTIONS(716),
    [anon_sym_interface] = ACTIONS(718),
    [anon_sym_byte] = ACTIONS(718),
    [anon_sym_short] = ACTIONS(718),
    [anon_sym_int] = ACTIONS(718),
    [anon_sym_long] = ACTIONS(718),
    [anon_sym_char] = ACTIONS(718),
    [anon_sym_float] = ACTIONS(718),
    [anon_sym_double] = ACTIONS(718),
    [sym_boolean_type] = ACTIONS(718),
    [sym_void_type] = ACTIONS(718),
    [sym_this] = ACTIONS(718),
    [sym_super] = ACTIONS(718),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(720),
    [sym_identifier] = ACTIONS(722),
    [sym_decimal_integer_literal] = ACTIONS(722),
    [sym_hex_integer_literal] = ACTIONS(722),
    [sym_octal_integer_literal] = ACTIONS(720),
    [sym_binary_integer_literal] = ACTIONS(720),
    [sym_decimal_floating_point_literal] = ACTIONS(720),
    [sym_hex_floating_point_literal] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_character_literal] = ACTIONS(720),
    [sym_string_literal] = ACTIONS(720),
    [sym_null_literal] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_PLUS_PLUS] = ACTIONS(720),
    [anon_sym_DASH_DASH] = ACTIONS(720),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_class] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_assert] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_case] = ACTIONS(722),
    [anon_sym_default] = ACTIONS(722),
    [anon_sym_do] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_break] = ACTIONS(722),
    [anon_sym_continue] = ACTIONS(722),
    [anon_sym_return] = ACTIONS(722),
    [anon_sym_synchronized] = ACTIONS(722),
    [anon_sym_throw] = ACTIONS(722),
    [anon_sym_try] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_AT] = ACTIONS(722),
    [anon_sym_open] = ACTIONS(722),
    [anon_sym_module] = ACTIONS(722),
    [anon_sym_static] = ACTIONS(722),
    [anon_sym_package] = ACTIONS(722),
    [anon_sym_import] = ACTIONS(722),
    [anon_sym_enum] = ACTIONS(722),
    [anon_sym_public] = ACTIONS(722),
    [anon_sym_protected] = ACTIONS(722),
    [anon_sym_private] = ACTIONS(722),
    [anon_sym_abstract] = ACTIONS(722),
    [anon_sym_final] = ACTIONS(722),
    [anon_sym_strictfp] = ACTIONS(722),
    [anon_sym_native] = ACTIONS(722),
    [anon_sym_transient] = ACTIONS(722),
    [anon_sym_volatile] = ACTIONS(722),
    [anon_sym_ATinterface] = ACTIONS(720),
    [anon_sym_interface] = ACTIONS(722),
    [anon_sym_byte] = ACTIONS(722),
    [anon_sym_short] = ACTIONS(722),
    [anon_sym_int] = ACTIONS(722),
    [anon_sym_long] = ACTIONS(722),
    [anon_sym_char] = ACTIONS(722),
    [anon_sym_float] = ACTIONS(722),
    [anon_sym_double] = ACTIONS(722),
    [sym_boolean_type] = ACTIONS(722),
    [sym_void_type] = ACTIONS(722),
    [sym_this] = ACTIONS(722),
    [sym_super] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(724),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(726),
    [sym_identifier] = ACTIONS(728),
    [sym_decimal_integer_literal] = ACTIONS(728),
    [sym_hex_integer_literal] = ACTIONS(728),
    [sym_octal_integer_literal] = ACTIONS(726),
    [sym_binary_integer_literal] = ACTIONS(726),
    [sym_decimal_floating_point_literal] = ACTIONS(726),
    [sym_hex_floating_point_literal] = ACTIONS(728),
    [sym_true] = ACTIONS(728),
    [sym_false] = ACTIONS(728),
    [sym_character_literal] = ACTIONS(726),
    [sym_string_literal] = ACTIONS(726),
    [sym_null_literal] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_PLUS] = ACTIONS(728),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_BANG] = ACTIONS(726),
    [anon_sym_TILDE] = ACTIONS(726),
    [anon_sym_PLUS_PLUS] = ACTIONS(726),
    [anon_sym_DASH_DASH] = ACTIONS(726),
    [anon_sym_new] = ACTIONS(728),
    [anon_sym_class] = ACTIONS(728),
    [anon_sym_SEMI] = ACTIONS(726),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_RBRACE] = ACTIONS(726),
    [anon_sym_assert] = ACTIONS(728),
    [anon_sym_switch] = ACTIONS(728),
    [anon_sym_case] = ACTIONS(728),
    [anon_sym_default] = ACTIONS(728),
    [anon_sym_do] = ACTIONS(728),
    [anon_sym_while] = ACTIONS(728),
    [anon_sym_break] = ACTIONS(728),
    [anon_sym_continue] = ACTIONS(728),
    [anon_sym_return] = ACTIONS(728),
    [anon_sym_synchronized] = ACTIONS(728),
    [anon_sym_throw] = ACTIONS(728),
    [anon_sym_try] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_else] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_AT] = ACTIONS(728),
    [anon_sym_open] = ACTIONS(728),
    [anon_sym_module] = ACTIONS(728),
    [anon_sym_static] = ACTIONS(728),
    [anon_sym_package] = ACTIONS(728),
    [anon_sym_import] = ACTIONS(728),
    [anon_sym_enum] = ACTIONS(728),
    [anon_sym_public] = ACTIONS(728),
    [anon_sym_protected] = ACTIONS(728),
    [anon_sym_private] = ACTIONS(728),
    [anon_sym_abstract] = ACTIONS(728),
    [anon_sym_final] = ACTIONS(728),
    [anon_sym_strictfp] = ACTIONS(728),
    [anon_sym_native] = ACTIONS(728),
    [anon_sym_transient] = ACTIONS(728),
    [anon_sym_volatile] = ACTIONS(728),
    [anon_sym_ATinterface] = ACTIONS(726),
    [anon_sym_interface] = ACTIONS(728),
    [anon_sym_byte] = ACTIONS(728),
    [anon_sym_short] = ACTIONS(728),
    [anon_sym_int] = ACTIONS(728),
    [anon_sym_long] = ACTIONS(728),
    [anon_sym_char] = ACTIONS(728),
    [anon_sym_float] = ACTIONS(728),
    [anon_sym_double] = ACTIONS(728),
    [sym_boolean_type] = ACTIONS(728),
    [sym_void_type] = ACTIONS(728),
    [sym_this] = ACTIONS(728),
    [sym_super] = ACTIONS(728),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym_identifier] = ACTIONS(732),
    [sym_decimal_integer_literal] = ACTIONS(732),
    [sym_hex_integer_literal] = ACTIONS(732),
    [sym_octal_integer_literal] = ACTIONS(730),
    [sym_binary_integer_literal] = ACTIONS(730),
    [sym_decimal_floating_point_literal] = ACTIONS(730),
    [sym_hex_floating_point_literal] = ACTIONS(732),
    [sym_true] = ACTIONS(732),
    [sym_false] = ACTIONS(732),
    [sym_character_literal] = ACTIONS(730),
    [sym_string_literal] = ACTIONS(730),
    [sym_null_literal] = ACTIONS(732),
    [anon_sym_LPAREN] = ACTIONS(730),
    [anon_sym_PLUS] = ACTIONS(732),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_BANG] = ACTIONS(730),
    [anon_sym_TILDE] = ACTIONS(730),
    [anon_sym_PLUS_PLUS] = ACTIONS(730),
    [anon_sym_DASH_DASH] = ACTIONS(730),
    [anon_sym_new] = ACTIONS(732),
    [anon_sym_class] = ACTIONS(732),
    [anon_sym_SEMI] = ACTIONS(730),
    [anon_sym_LBRACE] = ACTIONS(730),
    [anon_sym_RBRACE] = ACTIONS(730),
    [anon_sym_assert] = ACTIONS(732),
    [anon_sym_switch] = ACTIONS(732),
    [anon_sym_case] = ACTIONS(732),
    [anon_sym_default] = ACTIONS(732),
    [anon_sym_do] = ACTIONS(732),
    [anon_sym_while] = ACTIONS(732),
    [anon_sym_break] = ACTIONS(732),
    [anon_sym_continue] = ACTIONS(732),
    [anon_sym_return] = ACTIONS(732),
    [anon_sym_synchronized] = ACTIONS(732),
    [anon_sym_throw] = ACTIONS(732),
    [anon_sym_try] = ACTIONS(732),
    [anon_sym_if] = ACTIONS(732),
    [anon_sym_else] = ACTIONS(732),
    [anon_sym_for] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(732),
    [anon_sym_open] = ACTIONS(732),
    [anon_sym_module] = ACTIONS(732),
    [anon_sym_static] = ACTIONS(732),
    [anon_sym_package] = ACTIONS(732),
    [anon_sym_import] = ACTIONS(732),
    [anon_sym_enum] = ACTIONS(732),
    [anon_sym_public] = ACTIONS(732),
    [anon_sym_protected] = ACTIONS(732),
    [anon_sym_private] = ACTIONS(732),
    [anon_sym_abstract] = ACTIONS(732),
    [anon_sym_final] = ACTIONS(732),
    [anon_sym_strictfp] = ACTIONS(732),
    [anon_sym_native] = ACTIONS(732),
    [anon_sym_transient] = ACTIONS(732),
    [anon_sym_volatile] = ACTIONS(732),
    [anon_sym_ATinterface] = ACTIONS(730),
    [anon_sym_interface] = ACTIONS(732),
    [anon_sym_byte] = ACTIONS(732),
    [anon_sym_short] = ACTIONS(732),
    [anon_sym_int] = ACTIONS(732),
    [anon_sym_long] = ACTIONS(732),
    [anon_sym_char] = ACTIONS(732),
    [anon_sym_float] = ACTIONS(732),
    [anon_sym_double] = ACTIONS(732),
    [sym_boolean_type] = ACTIONS(732),
    [sym_void_type] = ACTIONS(732),
    [sym_this] = ACTIONS(732),
    [sym_super] = ACTIONS(732),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(734),
    [sym_identifier] = ACTIONS(736),
    [sym_decimal_integer_literal] = ACTIONS(736),
    [sym_hex_integer_literal] = ACTIONS(736),
    [sym_octal_integer_literal] = ACTIONS(734),
    [sym_binary_integer_literal] = ACTIONS(734),
    [sym_decimal_floating_point_literal] = ACTIONS(734),
    [sym_hex_floating_point_literal] = ACTIONS(736),
    [sym_true] = ACTIONS(736),
    [sym_false] = ACTIONS(736),
    [sym_character_literal] = ACTIONS(734),
    [sym_string_literal] = ACTIONS(734),
    [sym_null_literal] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(734),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_BANG] = ACTIONS(734),
    [anon_sym_TILDE] = ACTIONS(734),
    [anon_sym_PLUS_PLUS] = ACTIONS(734),
    [anon_sym_DASH_DASH] = ACTIONS(734),
    [anon_sym_new] = ACTIONS(736),
    [anon_sym_class] = ACTIONS(736),
    [anon_sym_SEMI] = ACTIONS(734),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_RBRACE] = ACTIONS(734),
    [anon_sym_assert] = ACTIONS(736),
    [anon_sym_switch] = ACTIONS(736),
    [anon_sym_case] = ACTIONS(736),
    [anon_sym_default] = ACTIONS(736),
    [anon_sym_do] = ACTIONS(736),
    [anon_sym_while] = ACTIONS(736),
    [anon_sym_break] = ACTIONS(736),
    [anon_sym_continue] = ACTIONS(736),
    [anon_sym_return] = ACTIONS(736),
    [anon_sym_synchronized] = ACTIONS(736),
    [anon_sym_throw] = ACTIONS(736),
    [anon_sym_try] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_else] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(736),
    [anon_sym_open] = ACTIONS(736),
    [anon_sym_module] = ACTIONS(736),
    [anon_sym_static] = ACTIONS(736),
    [anon_sym_package] = ACTIONS(736),
    [anon_sym_import] = ACTIONS(736),
    [anon_sym_enum] = ACTIONS(736),
    [anon_sym_public] = ACTIONS(736),
    [anon_sym_protected] = ACTIONS(736),
    [anon_sym_private] = ACTIONS(736),
    [anon_sym_abstract] = ACTIONS(736),
    [anon_sym_final] = ACTIONS(736),
    [anon_sym_strictfp] = ACTIONS(736),
    [anon_sym_native] = ACTIONS(736),
    [anon_sym_transient] = ACTIONS(736),
    [anon_sym_volatile] = ACTIONS(736),
    [anon_sym_ATinterface] = ACTIONS(734),
    [anon_sym_interface] = ACTIONS(736),
    [anon_sym_byte] = ACTIONS(736),
    [anon_sym_short] = ACTIONS(736),
    [anon_sym_int] = ACTIONS(736),
    [anon_sym_long] = ACTIONS(736),
    [anon_sym_char] = ACTIONS(736),
    [anon_sym_float] = ACTIONS(736),
    [anon_sym_double] = ACTIONS(736),
    [sym_boolean_type] = ACTIONS(736),
    [sym_void_type] = ACTIONS(736),
    [sym_this] = ACTIONS(736),
    [sym_super] = ACTIONS(736),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym_identifier] = ACTIONS(740),
    [sym_decimal_integer_literal] = ACTIONS(740),
    [sym_hex_integer_literal] = ACTIONS(740),
    [sym_octal_integer_literal] = ACTIONS(738),
    [sym_binary_integer_literal] = ACTIONS(738),
    [sym_decimal_floating_point_literal] = ACTIONS(738),
    [sym_hex_floating_point_literal] = ACTIONS(740),
    [sym_true] = ACTIONS(740),
    [sym_false] = ACTIONS(740),
    [sym_character_literal] = ACTIONS(738),
    [sym_string_literal] = ACTIONS(738),
    [sym_null_literal] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(738),
    [anon_sym_TILDE] = ACTIONS(738),
    [anon_sym_PLUS_PLUS] = ACTIONS(738),
    [anon_sym_DASH_DASH] = ACTIONS(738),
    [anon_sym_new] = ACTIONS(740),
    [anon_sym_class] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_assert] = ACTIONS(740),
    [anon_sym_switch] = ACTIONS(740),
    [anon_sym_case] = ACTIONS(740),
    [anon_sym_default] = ACTIONS(740),
    [anon_sym_do] = ACTIONS(740),
    [anon_sym_while] = ACTIONS(740),
    [anon_sym_break] = ACTIONS(740),
    [anon_sym_continue] = ACTIONS(740),
    [anon_sym_return] = ACTIONS(740),
    [anon_sym_synchronized] = ACTIONS(740),
    [anon_sym_throw] = ACTIONS(740),
    [anon_sym_try] = ACTIONS(740),
    [anon_sym_if] = ACTIONS(740),
    [anon_sym_else] = ACTIONS(740),
    [anon_sym_for] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_open] = ACTIONS(740),
    [anon_sym_module] = ACTIONS(740),
    [anon_sym_static] = ACTIONS(740),
    [anon_sym_package] = ACTIONS(740),
    [anon_sym_import] = ACTIONS(740),
    [anon_sym_enum] = ACTIONS(740),
    [anon_sym_public] = ACTIONS(740),
    [anon_sym_protected] = ACTIONS(740),
    [anon_sym_private] = ACTIONS(740),
    [anon_sym_abstract] = ACTIONS(740),
    [anon_sym_final] = ACTIONS(740),
    [anon_sym_strictfp] = ACTIONS(740),
    [anon_sym_native] = ACTIONS(740),
    [anon_sym_transient] = ACTIONS(740),
    [anon_sym_volatile] = ACTIONS(740),
    [anon_sym_ATinterface] = ACTIONS(738),
    [anon_sym_interface] = ACTIONS(740),
    [anon_sym_byte] = ACTIONS(740),
    [anon_sym_short] = ACTIONS(740),
    [anon_sym_int] = ACTIONS(740),
    [anon_sym_long] = ACTIONS(740),
    [anon_sym_char] = ACTIONS(740),
    [anon_sym_float] = ACTIONS(740),
    [anon_sym_double] = ACTIONS(740),
    [sym_boolean_type] = ACTIONS(740),
    [sym_void_type] = ACTIONS(740),
    [sym_this] = ACTIONS(740),
    [sym_super] = ACTIONS(740),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(742),
    [sym_identifier] = ACTIONS(744),
    [sym_decimal_integer_literal] = ACTIONS(744),
    [sym_hex_integer_literal] = ACTIONS(744),
    [sym_octal_integer_literal] = ACTIONS(742),
    [sym_binary_integer_literal] = ACTIONS(742),
    [sym_decimal_floating_point_literal] = ACTIONS(742),
    [sym_hex_floating_point_literal] = ACTIONS(744),
    [sym_true] = ACTIONS(744),
    [sym_false] = ACTIONS(744),
    [sym_character_literal] = ACTIONS(742),
    [sym_string_literal] = ACTIONS(742),
    [sym_null_literal] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(742),
    [anon_sym_PLUS] = ACTIONS(744),
    [anon_sym_DASH] = ACTIONS(744),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_TILDE] = ACTIONS(742),
    [anon_sym_PLUS_PLUS] = ACTIONS(742),
    [anon_sym_DASH_DASH] = ACTIONS(742),
    [anon_sym_new] = ACTIONS(744),
    [anon_sym_class] = ACTIONS(744),
    [anon_sym_SEMI] = ACTIONS(742),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_RBRACE] = ACTIONS(742),
    [anon_sym_assert] = ACTIONS(744),
    [anon_sym_switch] = ACTIONS(744),
    [anon_sym_case] = ACTIONS(744),
    [anon_sym_default] = ACTIONS(744),
    [anon_sym_do] = ACTIONS(744),
    [anon_sym_while] = ACTIONS(744),
    [anon_sym_break] = ACTIONS(744),
    [anon_sym_continue] = ACTIONS(744),
    [anon_sym_return] = ACTIONS(744),
    [anon_sym_synchronized] = ACTIONS(744),
    [anon_sym_throw] = ACTIONS(744),
    [anon_sym_try] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_else] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_AT] = ACTIONS(744),
    [anon_sym_open] = ACTIONS(744),
    [anon_sym_module] = ACTIONS(744),
    [anon_sym_static] = ACTIONS(744),
    [anon_sym_package] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(744),
    [anon_sym_enum] = ACTIONS(744),
    [anon_sym_public] = ACTIONS(744),
    [anon_sym_protected] = ACTIONS(744),
    [anon_sym_private] = ACTIONS(744),
    [anon_sym_abstract] = ACTIONS(744),
    [anon_sym_final] = ACTIONS(744),
    [anon_sym_strictfp] = ACTIONS(744),
    [anon_sym_native] = ACTIONS(744),
    [anon_sym_transient] = ACTIONS(744),
    [anon_sym_volatile] = ACTIONS(744),
    [anon_sym_ATinterface] = ACTIONS(742),
    [anon_sym_interface] = ACTIONS(744),
    [anon_sym_byte] = ACTIONS(744),
    [anon_sym_short] = ACTIONS(744),
    [anon_sym_int] = ACTIONS(744),
    [anon_sym_long] = ACTIONS(744),
    [anon_sym_char] = ACTIONS(744),
    [anon_sym_float] = ACTIONS(744),
    [anon_sym_double] = ACTIONS(744),
    [sym_boolean_type] = ACTIONS(744),
    [sym_void_type] = ACTIONS(744),
    [sym_this] = ACTIONS(744),
    [sym_super] = ACTIONS(744),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [sym_identifier] = ACTIONS(748),
    [sym_decimal_integer_literal] = ACTIONS(748),
    [sym_hex_integer_literal] = ACTIONS(748),
    [sym_octal_integer_literal] = ACTIONS(746),
    [sym_binary_integer_literal] = ACTIONS(746),
    [sym_decimal_floating_point_literal] = ACTIONS(746),
    [sym_hex_floating_point_literal] = ACTIONS(748),
    [sym_true] = ACTIONS(748),
    [sym_false] = ACTIONS(748),
    [sym_character_literal] = ACTIONS(746),
    [sym_string_literal] = ACTIONS(746),
    [sym_null_literal] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_BANG] = ACTIONS(746),
    [anon_sym_TILDE] = ACTIONS(746),
    [anon_sym_PLUS_PLUS] = ACTIONS(746),
    [anon_sym_DASH_DASH] = ACTIONS(746),
    [anon_sym_new] = ACTIONS(748),
    [anon_sym_class] = ACTIONS(748),
    [anon_sym_SEMI] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_assert] = ACTIONS(748),
    [anon_sym_switch] = ACTIONS(748),
    [anon_sym_case] = ACTIONS(748),
    [anon_sym_default] = ACTIONS(748),
    [anon_sym_do] = ACTIONS(748),
    [anon_sym_while] = ACTIONS(748),
    [anon_sym_break] = ACTIONS(748),
    [anon_sym_continue] = ACTIONS(748),
    [anon_sym_return] = ACTIONS(748),
    [anon_sym_synchronized] = ACTIONS(748),
    [anon_sym_throw] = ACTIONS(748),
    [anon_sym_try] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_else] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_AT] = ACTIONS(748),
    [anon_sym_open] = ACTIONS(748),
    [anon_sym_module] = ACTIONS(748),
    [anon_sym_static] = ACTIONS(748),
    [anon_sym_package] = ACTIONS(748),
    [anon_sym_import] = ACTIONS(748),
    [anon_sym_enum] = ACTIONS(748),
    [anon_sym_public] = ACTIONS(748),
    [anon_sym_protected] = ACTIONS(748),
    [anon_sym_private] = ACTIONS(748),
    [anon_sym_abstract] = ACTIONS(748),
    [anon_sym_final] = ACTIONS(748),
    [anon_sym_strictfp] = ACTIONS(748),
    [anon_sym_native] = ACTIONS(748),
    [anon_sym_transient] = ACTIONS(748),
    [anon_sym_volatile] = ACTIONS(748),
    [anon_sym_ATinterface] = ACTIONS(746),
    [anon_sym_interface] = ACTIONS(748),
    [anon_sym_byte] = ACTIONS(748),
    [anon_sym_short] = ACTIONS(748),
    [anon_sym_int] = ACTIONS(748),
    [anon_sym_long] = ACTIONS(748),
    [anon_sym_char] = ACTIONS(748),
    [anon_sym_float] = ACTIONS(748),
    [anon_sym_double] = ACTIONS(748),
    [sym_boolean_type] = ACTIONS(748),
    [sym_void_type] = ACTIONS(748),
    [sym_this] = ACTIONS(748),
    [sym_super] = ACTIONS(748),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(750),
    [sym_identifier] = ACTIONS(752),
    [sym_decimal_integer_literal] = ACTIONS(752),
    [sym_hex_integer_literal] = ACTIONS(752),
    [sym_octal_integer_literal] = ACTIONS(750),
    [sym_binary_integer_literal] = ACTIONS(750),
    [sym_decimal_floating_point_literal] = ACTIONS(750),
    [sym_hex_floating_point_literal] = ACTIONS(752),
    [sym_true] = ACTIONS(752),
    [sym_false] = ACTIONS(752),
    [sym_character_literal] = ACTIONS(750),
    [sym_string_literal] = ACTIONS(750),
    [sym_null_literal] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(750),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_DASH] = ACTIONS(752),
    [anon_sym_BANG] = ACTIONS(750),
    [anon_sym_TILDE] = ACTIONS(750),
    [anon_sym_PLUS_PLUS] = ACTIONS(750),
    [anon_sym_DASH_DASH] = ACTIONS(750),
    [anon_sym_new] = ACTIONS(752),
    [anon_sym_class] = ACTIONS(752),
    [anon_sym_SEMI] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_RBRACE] = ACTIONS(750),
    [anon_sym_assert] = ACTIONS(752),
    [anon_sym_switch] = ACTIONS(752),
    [anon_sym_case] = ACTIONS(752),
    [anon_sym_default] = ACTIONS(752),
    [anon_sym_do] = ACTIONS(752),
    [anon_sym_while] = ACTIONS(752),
    [anon_sym_break] = ACTIONS(752),
    [anon_sym_continue] = ACTIONS(752),
    [anon_sym_return] = ACTIONS(752),
    [anon_sym_synchronized] = ACTIONS(752),
    [anon_sym_throw] = ACTIONS(752),
    [anon_sym_try] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_else] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(752),
    [anon_sym_open] = ACTIONS(752),
    [anon_sym_module] = ACTIONS(752),
    [anon_sym_static] = ACTIONS(752),
    [anon_sym_package] = ACTIONS(752),
    [anon_sym_import] = ACTIONS(752),
    [anon_sym_enum] = ACTIONS(752),
    [anon_sym_public] = ACTIONS(752),
    [anon_sym_protected] = ACTIONS(752),
    [anon_sym_private] = ACTIONS(752),
    [anon_sym_abstract] = ACTIONS(752),
    [anon_sym_final] = ACTIONS(752),
    [anon_sym_strictfp] = ACTIONS(752),
    [anon_sym_native] = ACTIONS(752),
    [anon_sym_transient] = ACTIONS(752),
    [anon_sym_volatile] = ACTIONS(752),
    [anon_sym_ATinterface] = ACTIONS(750),
    [anon_sym_interface] = ACTIONS(752),
    [anon_sym_byte] = ACTIONS(752),
    [anon_sym_short] = ACTIONS(752),
    [anon_sym_int] = ACTIONS(752),
    [anon_sym_long] = ACTIONS(752),
    [anon_sym_char] = ACTIONS(752),
    [anon_sym_float] = ACTIONS(752),
    [anon_sym_double] = ACTIONS(752),
    [sym_boolean_type] = ACTIONS(752),
    [sym_void_type] = ACTIONS(752),
    [sym_this] = ACTIONS(752),
    [sym_super] = ACTIONS(752),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(754),
    [sym_identifier] = ACTIONS(756),
    [sym_decimal_integer_literal] = ACTIONS(756),
    [sym_hex_integer_literal] = ACTIONS(756),
    [sym_octal_integer_literal] = ACTIONS(754),
    [sym_binary_integer_literal] = ACTIONS(754),
    [sym_decimal_floating_point_literal] = ACTIONS(754),
    [sym_hex_floating_point_literal] = ACTIONS(756),
    [sym_true] = ACTIONS(756),
    [sym_false] = ACTIONS(756),
    [sym_character_literal] = ACTIONS(754),
    [sym_string_literal] = ACTIONS(754),
    [sym_null_literal] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(754),
    [anon_sym_PLUS] = ACTIONS(756),
    [anon_sym_DASH] = ACTIONS(756),
    [anon_sym_BANG] = ACTIONS(754),
    [anon_sym_TILDE] = ACTIONS(754),
    [anon_sym_PLUS_PLUS] = ACTIONS(754),
    [anon_sym_DASH_DASH] = ACTIONS(754),
    [anon_sym_new] = ACTIONS(756),
    [anon_sym_class] = ACTIONS(756),
    [anon_sym_SEMI] = ACTIONS(754),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_RBRACE] = ACTIONS(754),
    [anon_sym_assert] = ACTIONS(756),
    [anon_sym_switch] = ACTIONS(756),
    [anon_sym_case] = ACTIONS(756),
    [anon_sym_default] = ACTIONS(756),
    [anon_sym_do] = ACTIONS(756),
    [anon_sym_while] = ACTIONS(756),
    [anon_sym_break] = ACTIONS(756),
    [anon_sym_continue] = ACTIONS(756),
    [anon_sym_return] = ACTIONS(756),
    [anon_sym_synchronized] = ACTIONS(756),
    [anon_sym_throw] = ACTIONS(756),
    [anon_sym_try] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_else] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(756),
    [anon_sym_open] = ACTIONS(756),
    [anon_sym_module] = ACTIONS(756),
    [anon_sym_static] = ACTIONS(756),
    [anon_sym_package] = ACTIONS(756),
    [anon_sym_import] = ACTIONS(756),
    [anon_sym_enum] = ACTIONS(756),
    [anon_sym_public] = ACTIONS(756),
    [anon_sym_protected] = ACTIONS(756),
    [anon_sym_private] = ACTIONS(756),
    [anon_sym_abstract] = ACTIONS(756),
    [anon_sym_final] = ACTIONS(756),
    [anon_sym_strictfp] = ACTIONS(756),
    [anon_sym_native] = ACTIONS(756),
    [anon_sym_transient] = ACTIONS(756),
    [anon_sym_volatile] = ACTIONS(756),
    [anon_sym_ATinterface] = ACTIONS(754),
    [anon_sym_interface] = ACTIONS(756),
    [anon_sym_byte] = ACTIONS(756),
    [anon_sym_short] = ACTIONS(756),
    [anon_sym_int] = ACTIONS(756),
    [anon_sym_long] = ACTIONS(756),
    [anon_sym_char] = ACTIONS(756),
    [anon_sym_float] = ACTIONS(756),
    [anon_sym_double] = ACTIONS(756),
    [sym_boolean_type] = ACTIONS(756),
    [sym_void_type] = ACTIONS(756),
    [sym_this] = ACTIONS(756),
    [sym_super] = ACTIONS(756),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(758),
    [sym_identifier] = ACTIONS(760),
    [sym_decimal_integer_literal] = ACTIONS(760),
    [sym_hex_integer_literal] = ACTIONS(760),
    [sym_octal_integer_literal] = ACTIONS(758),
    [sym_binary_integer_literal] = ACTIONS(758),
    [sym_decimal_floating_point_literal] = ACTIONS(758),
    [sym_hex_floating_point_literal] = ACTIONS(760),
    [sym_true] = ACTIONS(760),
    [sym_false] = ACTIONS(760),
    [sym_character_literal] = ACTIONS(758),
    [sym_string_literal] = ACTIONS(758),
    [sym_null_literal] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_BANG] = ACTIONS(758),
    [anon_sym_TILDE] = ACTIONS(758),
    [anon_sym_PLUS_PLUS] = ACTIONS(758),
    [anon_sym_DASH_DASH] = ACTIONS(758),
    [anon_sym_new] = ACTIONS(760),
    [anon_sym_class] = ACTIONS(760),
    [anon_sym_SEMI] = ACTIONS(758),
    [anon_sym_LBRACE] = ACTIONS(758),
    [anon_sym_RBRACE] = ACTIONS(758),
    [anon_sym_assert] = ACTIONS(760),
    [anon_sym_switch] = ACTIONS(760),
    [anon_sym_case] = ACTIONS(760),
    [anon_sym_default] = ACTIONS(760),
    [anon_sym_do] = ACTIONS(760),
    [anon_sym_while] = ACTIONS(760),
    [anon_sym_break] = ACTIONS(760),
    [anon_sym_continue] = ACTIONS(760),
    [anon_sym_return] = ACTIONS(760),
    [anon_sym_synchronized] = ACTIONS(760),
    [anon_sym_throw] = ACTIONS(760),
    [anon_sym_try] = ACTIONS(760),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_else] = ACTIONS(760),
    [anon_sym_for] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(760),
    [anon_sym_open] = ACTIONS(760),
    [anon_sym_module] = ACTIONS(760),
    [anon_sym_static] = ACTIONS(760),
    [anon_sym_package] = ACTIONS(760),
    [anon_sym_import] = ACTIONS(760),
    [anon_sym_enum] = ACTIONS(760),
    [anon_sym_public] = ACTIONS(760),
    [anon_sym_protected] = ACTIONS(760),
    [anon_sym_private] = ACTIONS(760),
    [anon_sym_abstract] = ACTIONS(760),
    [anon_sym_final] = ACTIONS(760),
    [anon_sym_strictfp] = ACTIONS(760),
    [anon_sym_native] = ACTIONS(760),
    [anon_sym_transient] = ACTIONS(760),
    [anon_sym_volatile] = ACTIONS(760),
    [anon_sym_ATinterface] = ACTIONS(758),
    [anon_sym_interface] = ACTIONS(760),
    [anon_sym_byte] = ACTIONS(760),
    [anon_sym_short] = ACTIONS(760),
    [anon_sym_int] = ACTIONS(760),
    [anon_sym_long] = ACTIONS(760),
    [anon_sym_char] = ACTIONS(760),
    [anon_sym_float] = ACTIONS(760),
    [anon_sym_double] = ACTIONS(760),
    [sym_boolean_type] = ACTIONS(760),
    [sym_void_type] = ACTIONS(760),
    [sym_this] = ACTIONS(760),
    [sym_super] = ACTIONS(760),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(762),
    [sym_identifier] = ACTIONS(764),
    [sym_decimal_integer_literal] = ACTIONS(764),
    [sym_hex_integer_literal] = ACTIONS(764),
    [sym_octal_integer_literal] = ACTIONS(762),
    [sym_binary_integer_literal] = ACTIONS(762),
    [sym_decimal_floating_point_literal] = ACTIONS(762),
    [sym_hex_floating_point_literal] = ACTIONS(764),
    [sym_true] = ACTIONS(764),
    [sym_false] = ACTIONS(764),
    [sym_character_literal] = ACTIONS(762),
    [sym_string_literal] = ACTIONS(762),
    [sym_null_literal] = ACTIONS(764),
    [anon_sym_LPAREN] = ACTIONS(762),
    [anon_sym_PLUS] = ACTIONS(764),
    [anon_sym_DASH] = ACTIONS(764),
    [anon_sym_BANG] = ACTIONS(762),
    [anon_sym_TILDE] = ACTIONS(762),
    [anon_sym_PLUS_PLUS] = ACTIONS(762),
    [anon_sym_DASH_DASH] = ACTIONS(762),
    [anon_sym_new] = ACTIONS(764),
    [anon_sym_class] = ACTIONS(764),
    [anon_sym_SEMI] = ACTIONS(762),
    [anon_sym_LBRACE] = ACTIONS(762),
    [anon_sym_RBRACE] = ACTIONS(762),
    [anon_sym_assert] = ACTIONS(764),
    [anon_sym_switch] = ACTIONS(764),
    [anon_sym_case] = ACTIONS(764),
    [anon_sym_default] = ACTIONS(764),
    [anon_sym_do] = ACTIONS(764),
    [anon_sym_while] = ACTIONS(764),
    [anon_sym_break] = ACTIONS(764),
    [anon_sym_continue] = ACTIONS(764),
    [anon_sym_return] = ACTIONS(764),
    [anon_sym_synchronized] = ACTIONS(764),
    [anon_sym_throw] = ACTIONS(764),
    [anon_sym_try] = ACTIONS(764),
    [anon_sym_if] = ACTIONS(764),
    [anon_sym_else] = ACTIONS(764),
    [anon_sym_for] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(764),
    [anon_sym_open] = ACTIONS(764),
    [anon_sym_module] = ACTIONS(764),
    [anon_sym_static] = ACTIONS(764),
    [anon_sym_package] = ACTIONS(764),
    [anon_sym_import] = ACTIONS(764),
    [anon_sym_enum] = ACTIONS(764),
    [anon_sym_public] = ACTIONS(764),
    [anon_sym_protected] = ACTIONS(764),
    [anon_sym_private] = ACTIONS(764),
    [anon_sym_abstract] = ACTIONS(764),
    [anon_sym_final] = ACTIONS(764),
    [anon_sym_strictfp] = ACTIONS(764),
    [anon_sym_native] = ACTIONS(764),
    [anon_sym_transient] = ACTIONS(764),
    [anon_sym_volatile] = ACTIONS(764),
    [anon_sym_ATinterface] = ACTIONS(762),
    [anon_sym_interface] = ACTIONS(764),
    [anon_sym_byte] = ACTIONS(764),
    [anon_sym_short] = ACTIONS(764),
    [anon_sym_int] = ACTIONS(764),
    [anon_sym_long] = ACTIONS(764),
    [anon_sym_char] = ACTIONS(764),
    [anon_sym_float] = ACTIONS(764),
    [anon_sym_double] = ACTIONS(764),
    [sym_boolean_type] = ACTIONS(764),
    [sym_void_type] = ACTIONS(764),
    [sym_this] = ACTIONS(764),
    [sym_super] = ACTIONS(764),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(766),
    [sym_identifier] = ACTIONS(768),
    [sym_decimal_integer_literal] = ACTIONS(768),
    [sym_hex_integer_literal] = ACTIONS(768),
    [sym_octal_integer_literal] = ACTIONS(766),
    [sym_binary_integer_literal] = ACTIONS(766),
    [sym_decimal_floating_point_literal] = ACTIONS(766),
    [sym_hex_floating_point_literal] = ACTIONS(768),
    [sym_true] = ACTIONS(768),
    [sym_false] = ACTIONS(768),
    [sym_character_literal] = ACTIONS(766),
    [sym_string_literal] = ACTIONS(766),
    [sym_null_literal] = ACTIONS(768),
    [anon_sym_LPAREN] = ACTIONS(766),
    [anon_sym_PLUS] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(766),
    [anon_sym_TILDE] = ACTIONS(766),
    [anon_sym_PLUS_PLUS] = ACTIONS(766),
    [anon_sym_DASH_DASH] = ACTIONS(766),
    [anon_sym_new] = ACTIONS(768),
    [anon_sym_class] = ACTIONS(768),
    [anon_sym_SEMI] = ACTIONS(766),
    [anon_sym_LBRACE] = ACTIONS(766),
    [anon_sym_RBRACE] = ACTIONS(766),
    [anon_sym_assert] = ACTIONS(768),
    [anon_sym_switch] = ACTIONS(768),
    [anon_sym_case] = ACTIONS(768),
    [anon_sym_default] = ACTIONS(768),
    [anon_sym_do] = ACTIONS(768),
    [anon_sym_while] = ACTIONS(768),
    [anon_sym_break] = ACTIONS(768),
    [anon_sym_continue] = ACTIONS(768),
    [anon_sym_return] = ACTIONS(768),
    [anon_sym_synchronized] = ACTIONS(768),
    [anon_sym_throw] = ACTIONS(768),
    [anon_sym_try] = ACTIONS(768),
    [anon_sym_if] = ACTIONS(768),
    [anon_sym_else] = ACTIONS(768),
    [anon_sym_for] = ACTIONS(768),
    [anon_sym_AT] = ACTIONS(768),
    [anon_sym_open] = ACTIONS(768),
    [anon_sym_module] = ACTIONS(768),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_package] = ACTIONS(768),
    [anon_sym_import] = ACTIONS(768),
    [anon_sym_enum] = ACTIONS(768),
    [anon_sym_public] = ACTIONS(768),
    [anon_sym_protected] = ACTIONS(768),
    [anon_sym_private] = ACTIONS(768),
    [anon_sym_abstract] = ACTIONS(768),
    [anon_sym_final] = ACTIONS(768),
    [anon_sym_strictfp] = ACTIONS(768),
    [anon_sym_native] = ACTIONS(768),
    [anon_sym_transient] = ACTIONS(768),
    [anon_sym_volatile] = ACTIONS(768),
    [anon_sym_ATinterface] = ACTIONS(766),
    [anon_sym_interface] = ACTIONS(768),
    [anon_sym_byte] = ACTIONS(768),
    [anon_sym_short] = ACTIONS(768),
    [anon_sym_int] = ACTIONS(768),
    [anon_sym_long] = ACTIONS(768),
    [anon_sym_char] = ACTIONS(768),
    [anon_sym_float] = ACTIONS(768),
    [anon_sym_double] = ACTIONS(768),
    [sym_boolean_type] = ACTIONS(768),
    [sym_void_type] = ACTIONS(768),
    [sym_this] = ACTIONS(768),
    [sym_super] = ACTIONS(768),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(770),
    [sym_identifier] = ACTIONS(772),
    [sym_decimal_integer_literal] = ACTIONS(772),
    [sym_hex_integer_literal] = ACTIONS(772),
    [sym_octal_integer_literal] = ACTIONS(770),
    [sym_binary_integer_literal] = ACTIONS(770),
    [sym_decimal_floating_point_literal] = ACTIONS(770),
    [sym_hex_floating_point_literal] = ACTIONS(772),
    [sym_true] = ACTIONS(772),
    [sym_false] = ACTIONS(772),
    [sym_character_literal] = ACTIONS(770),
    [sym_string_literal] = ACTIONS(770),
    [sym_null_literal] = ACTIONS(772),
    [anon_sym_LPAREN] = ACTIONS(770),
    [anon_sym_PLUS] = ACTIONS(772),
    [anon_sym_DASH] = ACTIONS(772),
    [anon_sym_BANG] = ACTIONS(770),
    [anon_sym_TILDE] = ACTIONS(770),
    [anon_sym_PLUS_PLUS] = ACTIONS(770),
    [anon_sym_DASH_DASH] = ACTIONS(770),
    [anon_sym_new] = ACTIONS(772),
    [anon_sym_class] = ACTIONS(772),
    [anon_sym_SEMI] = ACTIONS(770),
    [anon_sym_LBRACE] = ACTIONS(770),
    [anon_sym_RBRACE] = ACTIONS(770),
    [anon_sym_assert] = ACTIONS(772),
    [anon_sym_switch] = ACTIONS(772),
    [anon_sym_case] = ACTIONS(772),
    [anon_sym_default] = ACTIONS(772),
    [anon_sym_do] = ACTIONS(772),
    [anon_sym_while] = ACTIONS(772),
    [anon_sym_break] = ACTIONS(772),
    [anon_sym_continue] = ACTIONS(772),
    [anon_sym_return] = ACTIONS(772),
    [anon_sym_synchronized] = ACTIONS(772),
    [anon_sym_throw] = ACTIONS(772),
    [anon_sym_try] = ACTIONS(772),
    [anon_sym_if] = ACTIONS(772),
    [anon_sym_else] = ACTIONS(772),
    [anon_sym_for] = ACTIONS(772),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_open] = ACTIONS(772),
    [anon_sym_module] = ACTIONS(772),
    [anon_sym_static] = ACTIONS(772),
    [anon_sym_package] = ACTIONS(772),
    [anon_sym_import] = ACTIONS(772),
    [anon_sym_enum] = ACTIONS(772),
    [anon_sym_public] = ACTIONS(772),
    [anon_sym_protected] = ACTIONS(772),
    [anon_sym_private] = ACTIONS(772),
    [anon_sym_abstract] = ACTIONS(772),
    [anon_sym_final] = ACTIONS(772),
    [anon_sym_strictfp] = ACTIONS(772),
    [anon_sym_native] = ACTIONS(772),
    [anon_sym_transient] = ACTIONS(772),
    [anon_sym_volatile] = ACTIONS(772),
    [anon_sym_ATinterface] = ACTIONS(770),
    [anon_sym_interface] = ACTIONS(772),
    [anon_sym_byte] = ACTIONS(772),
    [anon_sym_short] = ACTIONS(772),
    [anon_sym_int] = ACTIONS(772),
    [anon_sym_long] = ACTIONS(772),
    [anon_sym_char] = ACTIONS(772),
    [anon_sym_float] = ACTIONS(772),
    [anon_sym_double] = ACTIONS(772),
    [sym_boolean_type] = ACTIONS(772),
    [sym_void_type] = ACTIONS(772),
    [sym_this] = ACTIONS(772),
    [sym_super] = ACTIONS(772),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(774),
    [sym_identifier] = ACTIONS(776),
    [sym_decimal_integer_literal] = ACTIONS(776),
    [sym_hex_integer_literal] = ACTIONS(776),
    [sym_octal_integer_literal] = ACTIONS(774),
    [sym_binary_integer_literal] = ACTIONS(774),
    [sym_decimal_floating_point_literal] = ACTIONS(774),
    [sym_hex_floating_point_literal] = ACTIONS(776),
    [sym_true] = ACTIONS(776),
    [sym_false] = ACTIONS(776),
    [sym_character_literal] = ACTIONS(774),
    [sym_string_literal] = ACTIONS(774),
    [sym_null_literal] = ACTIONS(776),
    [anon_sym_LPAREN] = ACTIONS(774),
    [anon_sym_PLUS] = ACTIONS(776),
    [anon_sym_DASH] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(774),
    [anon_sym_TILDE] = ACTIONS(774),
    [anon_sym_PLUS_PLUS] = ACTIONS(774),
    [anon_sym_DASH_DASH] = ACTIONS(774),
    [anon_sym_new] = ACTIONS(776),
    [anon_sym_class] = ACTIONS(776),
    [anon_sym_SEMI] = ACTIONS(774),
    [anon_sym_LBRACE] = ACTIONS(774),
    [anon_sym_RBRACE] = ACTIONS(774),
    [anon_sym_assert] = ACTIONS(776),
    [anon_sym_switch] = ACTIONS(776),
    [anon_sym_case] = ACTIONS(776),
    [anon_sym_default] = ACTIONS(776),
    [anon_sym_do] = ACTIONS(776),
    [anon_sym_while] = ACTIONS(776),
    [anon_sym_break] = ACTIONS(776),
    [anon_sym_continue] = ACTIONS(776),
    [anon_sym_return] = ACTIONS(776),
    [anon_sym_synchronized] = ACTIONS(776),
    [anon_sym_throw] = ACTIONS(776),
    [anon_sym_try] = ACTIONS(776),
    [anon_sym_if] = ACTIONS(776),
    [anon_sym_else] = ACTIONS(776),
    [anon_sym_for] = ACTIONS(776),
    [anon_sym_AT] = ACTIONS(776),
    [anon_sym_open] = ACTIONS(776),
    [anon_sym_module] = ACTIONS(776),
    [anon_sym_static] = ACTIONS(776),
    [anon_sym_package] = ACTIONS(776),
    [anon_sym_import] = ACTIONS(776),
    [anon_sym_enum] = ACTIONS(776),
    [anon_sym_public] = ACTIONS(776),
    [anon_sym_protected] = ACTIONS(776),
    [anon_sym_private] = ACTIONS(776),
    [anon_sym_abstract] = ACTIONS(776),
    [anon_sym_final] = ACTIONS(776),
    [anon_sym_strictfp] = ACTIONS(776),
    [anon_sym_native] = ACTIONS(776),
    [anon_sym_transient] = ACTIONS(776),
    [anon_sym_volatile] = ACTIONS(776),
    [anon_sym_ATinterface] = ACTIONS(774),
    [anon_sym_interface] = ACTIONS(776),
    [anon_sym_byte] = ACTIONS(776),
    [anon_sym_short] = ACTIONS(776),
    [anon_sym_int] = ACTIONS(776),
    [anon_sym_long] = ACTIONS(776),
    [anon_sym_char] = ACTIONS(776),
    [anon_sym_float] = ACTIONS(776),
    [anon_sym_double] = ACTIONS(776),
    [sym_boolean_type] = ACTIONS(776),
    [sym_void_type] = ACTIONS(776),
    [sym_this] = ACTIONS(776),
    [sym_super] = ACTIONS(776),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(778),
    [sym_identifier] = ACTIONS(780),
    [sym_decimal_integer_literal] = ACTIONS(780),
    [sym_hex_integer_literal] = ACTIONS(780),
    [sym_octal_integer_literal] = ACTIONS(778),
    [sym_binary_integer_literal] = ACTIONS(778),
    [sym_decimal_floating_point_literal] = ACTIONS(778),
    [sym_hex_floating_point_literal] = ACTIONS(780),
    [sym_true] = ACTIONS(780),
    [sym_false] = ACTIONS(780),
    [sym_character_literal] = ACTIONS(778),
    [sym_string_literal] = ACTIONS(778),
    [sym_null_literal] = ACTIONS(780),
    [anon_sym_LPAREN] = ACTIONS(778),
    [anon_sym_PLUS] = ACTIONS(780),
    [anon_sym_DASH] = ACTIONS(780),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_TILDE] = ACTIONS(778),
    [anon_sym_PLUS_PLUS] = ACTIONS(778),
    [anon_sym_DASH_DASH] = ACTIONS(778),
    [anon_sym_new] = ACTIONS(780),
    [anon_sym_class] = ACTIONS(780),
    [anon_sym_SEMI] = ACTIONS(778),
    [anon_sym_LBRACE] = ACTIONS(778),
    [anon_sym_RBRACE] = ACTIONS(778),
    [anon_sym_assert] = ACTIONS(780),
    [anon_sym_switch] = ACTIONS(780),
    [anon_sym_case] = ACTIONS(780),
    [anon_sym_default] = ACTIONS(780),
    [anon_sym_do] = ACTIONS(780),
    [anon_sym_while] = ACTIONS(780),
    [anon_sym_break] = ACTIONS(780),
    [anon_sym_continue] = ACTIONS(780),
    [anon_sym_return] = ACTIONS(780),
    [anon_sym_synchronized] = ACTIONS(780),
    [anon_sym_throw] = ACTIONS(780),
    [anon_sym_try] = ACTIONS(780),
    [anon_sym_if] = ACTIONS(780),
    [anon_sym_else] = ACTIONS(780),
    [anon_sym_for] = ACTIONS(780),
    [anon_sym_AT] = ACTIONS(780),
    [anon_sym_open] = ACTIONS(780),
    [anon_sym_module] = ACTIONS(780),
    [anon_sym_static] = ACTIONS(780),
    [anon_sym_package] = ACTIONS(780),
    [anon_sym_import] = ACTIONS(780),
    [anon_sym_enum] = ACTIONS(780),
    [anon_sym_public] = ACTIONS(780),
    [anon_sym_protected] = ACTIONS(780),
    [anon_sym_private] = ACTIONS(780),
    [anon_sym_abstract] = ACTIONS(780),
    [anon_sym_final] = ACTIONS(780),
    [anon_sym_strictfp] = ACTIONS(780),
    [anon_sym_native] = ACTIONS(780),
    [anon_sym_transient] = ACTIONS(780),
    [anon_sym_volatile] = ACTIONS(780),
    [anon_sym_ATinterface] = ACTIONS(778),
    [anon_sym_interface] = ACTIONS(780),
    [anon_sym_byte] = ACTIONS(780),
    [anon_sym_short] = ACTIONS(780),
    [anon_sym_int] = ACTIONS(780),
    [anon_sym_long] = ACTIONS(780),
    [anon_sym_char] = ACTIONS(780),
    [anon_sym_float] = ACTIONS(780),
    [anon_sym_double] = ACTIONS(780),
    [sym_boolean_type] = ACTIONS(780),
    [sym_void_type] = ACTIONS(780),
    [sym_this] = ACTIONS(780),
    [sym_super] = ACTIONS(780),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(782),
    [sym_identifier] = ACTIONS(784),
    [sym_decimal_integer_literal] = ACTIONS(784),
    [sym_hex_integer_literal] = ACTIONS(784),
    [sym_octal_integer_literal] = ACTIONS(782),
    [sym_binary_integer_literal] = ACTIONS(782),
    [sym_decimal_floating_point_literal] = ACTIONS(782),
    [sym_hex_floating_point_literal] = ACTIONS(784),
    [sym_true] = ACTIONS(784),
    [sym_false] = ACTIONS(784),
    [sym_character_literal] = ACTIONS(782),
    [sym_string_literal] = ACTIONS(782),
    [sym_null_literal] = ACTIONS(784),
    [anon_sym_LPAREN] = ACTIONS(782),
    [anon_sym_PLUS] = ACTIONS(784),
    [anon_sym_DASH] = ACTIONS(784),
    [anon_sym_BANG] = ACTIONS(782),
    [anon_sym_TILDE] = ACTIONS(782),
    [anon_sym_PLUS_PLUS] = ACTIONS(782),
    [anon_sym_DASH_DASH] = ACTIONS(782),
    [anon_sym_new] = ACTIONS(784),
    [anon_sym_class] = ACTIONS(784),
    [anon_sym_SEMI] = ACTIONS(782),
    [anon_sym_LBRACE] = ACTIONS(782),
    [anon_sym_RBRACE] = ACTIONS(782),
    [anon_sym_assert] = ACTIONS(784),
    [anon_sym_switch] = ACTIONS(784),
    [anon_sym_case] = ACTIONS(784),
    [anon_sym_default] = ACTIONS(784),
    [anon_sym_do] = ACTIONS(784),
    [anon_sym_while] = ACTIONS(784),
    [anon_sym_break] = ACTIONS(784),
    [anon_sym_continue] = ACTIONS(784),
    [anon_sym_return] = ACTIONS(784),
    [anon_sym_synchronized] = ACTIONS(784),
    [anon_sym_throw] = ACTIONS(784),
    [anon_sym_try] = ACTIONS(784),
    [anon_sym_if] = ACTIONS(784),
    [anon_sym_else] = ACTIONS(784),
    [anon_sym_for] = ACTIONS(784),
    [anon_sym_AT] = ACTIONS(784),
    [anon_sym_open] = ACTIONS(784),
    [anon_sym_module] = ACTIONS(784),
    [anon_sym_static] = ACTIONS(784),
    [anon_sym_package] = ACTIONS(784),
    [anon_sym_import] = ACTIONS(784),
    [anon_sym_enum] = ACTIONS(784),
    [anon_sym_public] = ACTIONS(784),
    [anon_sym_protected] = ACTIONS(784),
    [anon_sym_private] = ACTIONS(784),
    [anon_sym_abstract] = ACTIONS(784),
    [anon_sym_final] = ACTIONS(784),
    [anon_sym_strictfp] = ACTIONS(784),
    [anon_sym_native] = ACTIONS(784),
    [anon_sym_transient] = ACTIONS(784),
    [anon_sym_volatile] = ACTIONS(784),
    [anon_sym_ATinterface] = ACTIONS(782),
    [anon_sym_interface] = ACTIONS(784),
    [anon_sym_byte] = ACTIONS(784),
    [anon_sym_short] = ACTIONS(784),
    [anon_sym_int] = ACTIONS(784),
    [anon_sym_long] = ACTIONS(784),
    [anon_sym_char] = ACTIONS(784),
    [anon_sym_float] = ACTIONS(784),
    [anon_sym_double] = ACTIONS(784),
    [sym_boolean_type] = ACTIONS(784),
    [sym_void_type] = ACTIONS(784),
    [sym_this] = ACTIONS(784),
    [sym_super] = ACTIONS(784),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(447),
    [sym_cast_expression] = STATE(447),
    [sym_assignment_expression] = STATE(447),
    [sym_binary_expression] = STATE(447),
    [sym_instanceof_expression] = STATE(447),
    [sym_lambda_expression] = STATE(447),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(447),
    [sym_unary_expression] = STATE(447),
    [sym_update_expression] = STATE(447),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(786),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(788),
    [sym_identifier] = ACTIONS(790),
    [sym_decimal_integer_literal] = ACTIONS(790),
    [sym_hex_integer_literal] = ACTIONS(790),
    [sym_octal_integer_literal] = ACTIONS(788),
    [sym_binary_integer_literal] = ACTIONS(788),
    [sym_decimal_floating_point_literal] = ACTIONS(788),
    [sym_hex_floating_point_literal] = ACTIONS(790),
    [sym_true] = ACTIONS(790),
    [sym_false] = ACTIONS(790),
    [sym_character_literal] = ACTIONS(788),
    [sym_string_literal] = ACTIONS(788),
    [sym_null_literal] = ACTIONS(790),
    [anon_sym_LPAREN] = ACTIONS(788),
    [anon_sym_PLUS] = ACTIONS(790),
    [anon_sym_DASH] = ACTIONS(790),
    [anon_sym_BANG] = ACTIONS(788),
    [anon_sym_TILDE] = ACTIONS(788),
    [anon_sym_PLUS_PLUS] = ACTIONS(788),
    [anon_sym_DASH_DASH] = ACTIONS(788),
    [anon_sym_new] = ACTIONS(790),
    [anon_sym_class] = ACTIONS(790),
    [anon_sym_SEMI] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(788),
    [anon_sym_RBRACE] = ACTIONS(788),
    [anon_sym_assert] = ACTIONS(790),
    [anon_sym_switch] = ACTIONS(790),
    [anon_sym_case] = ACTIONS(790),
    [anon_sym_default] = ACTIONS(790),
    [anon_sym_do] = ACTIONS(790),
    [anon_sym_while] = ACTIONS(790),
    [anon_sym_break] = ACTIONS(790),
    [anon_sym_continue] = ACTIONS(790),
    [anon_sym_return] = ACTIONS(790),
    [anon_sym_synchronized] = ACTIONS(790),
    [anon_sym_throw] = ACTIONS(790),
    [anon_sym_try] = ACTIONS(790),
    [anon_sym_if] = ACTIONS(790),
    [anon_sym_else] = ACTIONS(790),
    [anon_sym_for] = ACTIONS(790),
    [anon_sym_AT] = ACTIONS(790),
    [anon_sym_open] = ACTIONS(790),
    [anon_sym_module] = ACTIONS(790),
    [anon_sym_static] = ACTIONS(790),
    [anon_sym_package] = ACTIONS(790),
    [anon_sym_import] = ACTIONS(790),
    [anon_sym_enum] = ACTIONS(790),
    [anon_sym_public] = ACTIONS(790),
    [anon_sym_protected] = ACTIONS(790),
    [anon_sym_private] = ACTIONS(790),
    [anon_sym_abstract] = ACTIONS(790),
    [anon_sym_final] = ACTIONS(790),
    [anon_sym_strictfp] = ACTIONS(790),
    [anon_sym_native] = ACTIONS(790),
    [anon_sym_transient] = ACTIONS(790),
    [anon_sym_volatile] = ACTIONS(790),
    [anon_sym_ATinterface] = ACTIONS(788),
    [anon_sym_interface] = ACTIONS(790),
    [anon_sym_byte] = ACTIONS(790),
    [anon_sym_short] = ACTIONS(790),
    [anon_sym_int] = ACTIONS(790),
    [anon_sym_long] = ACTIONS(790),
    [anon_sym_char] = ACTIONS(790),
    [anon_sym_float] = ACTIONS(790),
    [anon_sym_double] = ACTIONS(790),
    [sym_boolean_type] = ACTIONS(790),
    [sym_void_type] = ACTIONS(790),
    [sym_this] = ACTIONS(790),
    [sym_super] = ACTIONS(790),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(792),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(794),
    [sym_identifier] = ACTIONS(796),
    [sym_decimal_integer_literal] = ACTIONS(796),
    [sym_hex_integer_literal] = ACTIONS(796),
    [sym_octal_integer_literal] = ACTIONS(794),
    [sym_binary_integer_literal] = ACTIONS(794),
    [sym_decimal_floating_point_literal] = ACTIONS(794),
    [sym_hex_floating_point_literal] = ACTIONS(796),
    [sym_true] = ACTIONS(796),
    [sym_false] = ACTIONS(796),
    [sym_character_literal] = ACTIONS(794),
    [sym_string_literal] = ACTIONS(794),
    [sym_null_literal] = ACTIONS(796),
    [anon_sym_LPAREN] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(796),
    [anon_sym_DASH] = ACTIONS(796),
    [anon_sym_BANG] = ACTIONS(794),
    [anon_sym_TILDE] = ACTIONS(794),
    [anon_sym_PLUS_PLUS] = ACTIONS(794),
    [anon_sym_DASH_DASH] = ACTIONS(794),
    [anon_sym_new] = ACTIONS(796),
    [anon_sym_class] = ACTIONS(796),
    [anon_sym_SEMI] = ACTIONS(794),
    [anon_sym_LBRACE] = ACTIONS(794),
    [anon_sym_RBRACE] = ACTIONS(794),
    [anon_sym_assert] = ACTIONS(796),
    [anon_sym_switch] = ACTIONS(796),
    [anon_sym_case] = ACTIONS(796),
    [anon_sym_default] = ACTIONS(796),
    [anon_sym_do] = ACTIONS(796),
    [anon_sym_while] = ACTIONS(796),
    [anon_sym_break] = ACTIONS(796),
    [anon_sym_continue] = ACTIONS(796),
    [anon_sym_return] = ACTIONS(796),
    [anon_sym_synchronized] = ACTIONS(796),
    [anon_sym_throw] = ACTIONS(796),
    [anon_sym_try] = ACTIONS(796),
    [anon_sym_if] = ACTIONS(796),
    [anon_sym_else] = ACTIONS(796),
    [anon_sym_for] = ACTIONS(796),
    [anon_sym_AT] = ACTIONS(796),
    [anon_sym_open] = ACTIONS(796),
    [anon_sym_module] = ACTIONS(796),
    [anon_sym_static] = ACTIONS(796),
    [anon_sym_package] = ACTIONS(796),
    [anon_sym_import] = ACTIONS(796),
    [anon_sym_enum] = ACTIONS(796),
    [anon_sym_public] = ACTIONS(796),
    [anon_sym_protected] = ACTIONS(796),
    [anon_sym_private] = ACTIONS(796),
    [anon_sym_abstract] = ACTIONS(796),
    [anon_sym_final] = ACTIONS(796),
    [anon_sym_strictfp] = ACTIONS(796),
    [anon_sym_native] = ACTIONS(796),
    [anon_sym_transient] = ACTIONS(796),
    [anon_sym_volatile] = ACTIONS(796),
    [anon_sym_ATinterface] = ACTIONS(794),
    [anon_sym_interface] = ACTIONS(796),
    [anon_sym_byte] = ACTIONS(796),
    [anon_sym_short] = ACTIONS(796),
    [anon_sym_int] = ACTIONS(796),
    [anon_sym_long] = ACTIONS(796),
    [anon_sym_char] = ACTIONS(796),
    [anon_sym_float] = ACTIONS(796),
    [anon_sym_double] = ACTIONS(796),
    [sym_boolean_type] = ACTIONS(796),
    [sym_void_type] = ACTIONS(796),
    [sym_this] = ACTIONS(796),
    [sym_super] = ACTIONS(796),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(798),
    [sym_identifier] = ACTIONS(800),
    [sym_decimal_integer_literal] = ACTIONS(800),
    [sym_hex_integer_literal] = ACTIONS(800),
    [sym_octal_integer_literal] = ACTIONS(798),
    [sym_binary_integer_literal] = ACTIONS(798),
    [sym_decimal_floating_point_literal] = ACTIONS(798),
    [sym_hex_floating_point_literal] = ACTIONS(800),
    [sym_true] = ACTIONS(800),
    [sym_false] = ACTIONS(800),
    [sym_character_literal] = ACTIONS(798),
    [sym_string_literal] = ACTIONS(798),
    [sym_null_literal] = ACTIONS(800),
    [anon_sym_LPAREN] = ACTIONS(798),
    [anon_sym_PLUS] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(798),
    [anon_sym_TILDE] = ACTIONS(798),
    [anon_sym_PLUS_PLUS] = ACTIONS(798),
    [anon_sym_DASH_DASH] = ACTIONS(798),
    [anon_sym_new] = ACTIONS(800),
    [anon_sym_class] = ACTIONS(800),
    [anon_sym_SEMI] = ACTIONS(798),
    [anon_sym_LBRACE] = ACTIONS(798),
    [anon_sym_RBRACE] = ACTIONS(798),
    [anon_sym_assert] = ACTIONS(800),
    [anon_sym_switch] = ACTIONS(800),
    [anon_sym_case] = ACTIONS(800),
    [anon_sym_default] = ACTIONS(800),
    [anon_sym_do] = ACTIONS(800),
    [anon_sym_while] = ACTIONS(800),
    [anon_sym_break] = ACTIONS(800),
    [anon_sym_continue] = ACTIONS(800),
    [anon_sym_return] = ACTIONS(800),
    [anon_sym_synchronized] = ACTIONS(800),
    [anon_sym_throw] = ACTIONS(800),
    [anon_sym_try] = ACTIONS(800),
    [anon_sym_if] = ACTIONS(800),
    [anon_sym_else] = ACTIONS(800),
    [anon_sym_for] = ACTIONS(800),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_open] = ACTIONS(800),
    [anon_sym_module] = ACTIONS(800),
    [anon_sym_static] = ACTIONS(800),
    [anon_sym_package] = ACTIONS(800),
    [anon_sym_import] = ACTIONS(800),
    [anon_sym_enum] = ACTIONS(800),
    [anon_sym_public] = ACTIONS(800),
    [anon_sym_protected] = ACTIONS(800),
    [anon_sym_private] = ACTIONS(800),
    [anon_sym_abstract] = ACTIONS(800),
    [anon_sym_final] = ACTIONS(800),
    [anon_sym_strictfp] = ACTIONS(800),
    [anon_sym_native] = ACTIONS(800),
    [anon_sym_transient] = ACTIONS(800),
    [anon_sym_volatile] = ACTIONS(800),
    [anon_sym_ATinterface] = ACTIONS(798),
    [anon_sym_interface] = ACTIONS(800),
    [anon_sym_byte] = ACTIONS(800),
    [anon_sym_short] = ACTIONS(800),
    [anon_sym_int] = ACTIONS(800),
    [anon_sym_long] = ACTIONS(800),
    [anon_sym_char] = ACTIONS(800),
    [anon_sym_float] = ACTIONS(800),
    [anon_sym_double] = ACTIONS(800),
    [sym_boolean_type] = ACTIONS(800),
    [sym_void_type] = ACTIONS(800),
    [sym_this] = ACTIONS(800),
    [sym_super] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(802),
    [sym_identifier] = ACTIONS(804),
    [sym_decimal_integer_literal] = ACTIONS(804),
    [sym_hex_integer_literal] = ACTIONS(804),
    [sym_octal_integer_literal] = ACTIONS(802),
    [sym_binary_integer_literal] = ACTIONS(802),
    [sym_decimal_floating_point_literal] = ACTIONS(802),
    [sym_hex_floating_point_literal] = ACTIONS(804),
    [sym_true] = ACTIONS(804),
    [sym_false] = ACTIONS(804),
    [sym_character_literal] = ACTIONS(802),
    [sym_string_literal] = ACTIONS(802),
    [sym_null_literal] = ACTIONS(804),
    [anon_sym_LPAREN] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(804),
    [anon_sym_DASH] = ACTIONS(804),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_TILDE] = ACTIONS(802),
    [anon_sym_PLUS_PLUS] = ACTIONS(802),
    [anon_sym_DASH_DASH] = ACTIONS(802),
    [anon_sym_new] = ACTIONS(804),
    [anon_sym_class] = ACTIONS(804),
    [anon_sym_SEMI] = ACTIONS(802),
    [anon_sym_LBRACE] = ACTIONS(802),
    [anon_sym_RBRACE] = ACTIONS(802),
    [anon_sym_assert] = ACTIONS(804),
    [anon_sym_switch] = ACTIONS(804),
    [anon_sym_case] = ACTIONS(804),
    [anon_sym_default] = ACTIONS(804),
    [anon_sym_do] = ACTIONS(804),
    [anon_sym_while] = ACTIONS(804),
    [anon_sym_break] = ACTIONS(804),
    [anon_sym_continue] = ACTIONS(804),
    [anon_sym_return] = ACTIONS(804),
    [anon_sym_synchronized] = ACTIONS(804),
    [anon_sym_throw] = ACTIONS(804),
    [anon_sym_try] = ACTIONS(804),
    [anon_sym_if] = ACTIONS(804),
    [anon_sym_else] = ACTIONS(804),
    [anon_sym_for] = ACTIONS(804),
    [anon_sym_AT] = ACTIONS(804),
    [anon_sym_open] = ACTIONS(804),
    [anon_sym_module] = ACTIONS(804),
    [anon_sym_static] = ACTIONS(804),
    [anon_sym_package] = ACTIONS(804),
    [anon_sym_import] = ACTIONS(804),
    [anon_sym_enum] = ACTIONS(804),
    [anon_sym_public] = ACTIONS(804),
    [anon_sym_protected] = ACTIONS(804),
    [anon_sym_private] = ACTIONS(804),
    [anon_sym_abstract] = ACTIONS(804),
    [anon_sym_final] = ACTIONS(804),
    [anon_sym_strictfp] = ACTIONS(804),
    [anon_sym_native] = ACTIONS(804),
    [anon_sym_transient] = ACTIONS(804),
    [anon_sym_volatile] = ACTIONS(804),
    [anon_sym_ATinterface] = ACTIONS(802),
    [anon_sym_interface] = ACTIONS(804),
    [anon_sym_byte] = ACTIONS(804),
    [anon_sym_short] = ACTIONS(804),
    [anon_sym_int] = ACTIONS(804),
    [anon_sym_long] = ACTIONS(804),
    [anon_sym_char] = ACTIONS(804),
    [anon_sym_float] = ACTIONS(804),
    [anon_sym_double] = ACTIONS(804),
    [sym_boolean_type] = ACTIONS(804),
    [sym_void_type] = ACTIONS(804),
    [sym_this] = ACTIONS(804),
    [sym_super] = ACTIONS(804),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(806),
    [sym_identifier] = ACTIONS(808),
    [sym_decimal_integer_literal] = ACTIONS(808),
    [sym_hex_integer_literal] = ACTIONS(808),
    [sym_octal_integer_literal] = ACTIONS(806),
    [sym_binary_integer_literal] = ACTIONS(806),
    [sym_decimal_floating_point_literal] = ACTIONS(806),
    [sym_hex_floating_point_literal] = ACTIONS(808),
    [sym_true] = ACTIONS(808),
    [sym_false] = ACTIONS(808),
    [sym_character_literal] = ACTIONS(806),
    [sym_string_literal] = ACTIONS(806),
    [sym_null_literal] = ACTIONS(808),
    [anon_sym_LPAREN] = ACTIONS(806),
    [anon_sym_PLUS] = ACTIONS(808),
    [anon_sym_DASH] = ACTIONS(808),
    [anon_sym_BANG] = ACTIONS(806),
    [anon_sym_TILDE] = ACTIONS(806),
    [anon_sym_PLUS_PLUS] = ACTIONS(806),
    [anon_sym_DASH_DASH] = ACTIONS(806),
    [anon_sym_new] = ACTIONS(808),
    [anon_sym_class] = ACTIONS(808),
    [anon_sym_SEMI] = ACTIONS(806),
    [anon_sym_LBRACE] = ACTIONS(806),
    [anon_sym_RBRACE] = ACTIONS(806),
    [anon_sym_assert] = ACTIONS(808),
    [anon_sym_switch] = ACTIONS(808),
    [anon_sym_case] = ACTIONS(808),
    [anon_sym_default] = ACTIONS(808),
    [anon_sym_do] = ACTIONS(808),
    [anon_sym_while] = ACTIONS(808),
    [anon_sym_break] = ACTIONS(808),
    [anon_sym_continue] = ACTIONS(808),
    [anon_sym_return] = ACTIONS(808),
    [anon_sym_synchronized] = ACTIONS(808),
    [anon_sym_throw] = ACTIONS(808),
    [anon_sym_try] = ACTIONS(808),
    [anon_sym_if] = ACTIONS(808),
    [anon_sym_else] = ACTIONS(808),
    [anon_sym_for] = ACTIONS(808),
    [anon_sym_AT] = ACTIONS(808),
    [anon_sym_open] = ACTIONS(808),
    [anon_sym_module] = ACTIONS(808),
    [anon_sym_static] = ACTIONS(808),
    [anon_sym_package] = ACTIONS(808),
    [anon_sym_import] = ACTIONS(808),
    [anon_sym_enum] = ACTIONS(808),
    [anon_sym_public] = ACTIONS(808),
    [anon_sym_protected] = ACTIONS(808),
    [anon_sym_private] = ACTIONS(808),
    [anon_sym_abstract] = ACTIONS(808),
    [anon_sym_final] = ACTIONS(808),
    [anon_sym_strictfp] = ACTIONS(808),
    [anon_sym_native] = ACTIONS(808),
    [anon_sym_transient] = ACTIONS(808),
    [anon_sym_volatile] = ACTIONS(808),
    [anon_sym_ATinterface] = ACTIONS(806),
    [anon_sym_interface] = ACTIONS(808),
    [anon_sym_byte] = ACTIONS(808),
    [anon_sym_short] = ACTIONS(808),
    [anon_sym_int] = ACTIONS(808),
    [anon_sym_long] = ACTIONS(808),
    [anon_sym_char] = ACTIONS(808),
    [anon_sym_float] = ACTIONS(808),
    [anon_sym_double] = ACTIONS(808),
    [sym_boolean_type] = ACTIONS(808),
    [sym_void_type] = ACTIONS(808),
    [sym_this] = ACTIONS(808),
    [sym_super] = ACTIONS(808),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(810),
    [sym_identifier] = ACTIONS(812),
    [sym_decimal_integer_literal] = ACTIONS(812),
    [sym_hex_integer_literal] = ACTIONS(812),
    [sym_octal_integer_literal] = ACTIONS(810),
    [sym_binary_integer_literal] = ACTIONS(810),
    [sym_decimal_floating_point_literal] = ACTIONS(810),
    [sym_hex_floating_point_literal] = ACTIONS(812),
    [sym_true] = ACTIONS(812),
    [sym_false] = ACTIONS(812),
    [sym_character_literal] = ACTIONS(810),
    [sym_string_literal] = ACTIONS(810),
    [sym_null_literal] = ACTIONS(812),
    [anon_sym_LPAREN] = ACTIONS(810),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_BANG] = ACTIONS(810),
    [anon_sym_TILDE] = ACTIONS(810),
    [anon_sym_PLUS_PLUS] = ACTIONS(810),
    [anon_sym_DASH_DASH] = ACTIONS(810),
    [anon_sym_new] = ACTIONS(812),
    [anon_sym_class] = ACTIONS(812),
    [anon_sym_SEMI] = ACTIONS(810),
    [anon_sym_LBRACE] = ACTIONS(810),
    [anon_sym_RBRACE] = ACTIONS(810),
    [anon_sym_assert] = ACTIONS(812),
    [anon_sym_switch] = ACTIONS(812),
    [anon_sym_case] = ACTIONS(812),
    [anon_sym_default] = ACTIONS(812),
    [anon_sym_do] = ACTIONS(812),
    [anon_sym_while] = ACTIONS(812),
    [anon_sym_break] = ACTIONS(812),
    [anon_sym_continue] = ACTIONS(812),
    [anon_sym_return] = ACTIONS(812),
    [anon_sym_synchronized] = ACTIONS(812),
    [anon_sym_throw] = ACTIONS(812),
    [anon_sym_try] = ACTIONS(812),
    [anon_sym_if] = ACTIONS(812),
    [anon_sym_else] = ACTIONS(812),
    [anon_sym_for] = ACTIONS(812),
    [anon_sym_AT] = ACTIONS(812),
    [anon_sym_open] = ACTIONS(812),
    [anon_sym_module] = ACTIONS(812),
    [anon_sym_static] = ACTIONS(812),
    [anon_sym_package] = ACTIONS(812),
    [anon_sym_import] = ACTIONS(812),
    [anon_sym_enum] = ACTIONS(812),
    [anon_sym_public] = ACTIONS(812),
    [anon_sym_protected] = ACTIONS(812),
    [anon_sym_private] = ACTIONS(812),
    [anon_sym_abstract] = ACTIONS(812),
    [anon_sym_final] = ACTIONS(812),
    [anon_sym_strictfp] = ACTIONS(812),
    [anon_sym_native] = ACTIONS(812),
    [anon_sym_transient] = ACTIONS(812),
    [anon_sym_volatile] = ACTIONS(812),
    [anon_sym_ATinterface] = ACTIONS(810),
    [anon_sym_interface] = ACTIONS(812),
    [anon_sym_byte] = ACTIONS(812),
    [anon_sym_short] = ACTIONS(812),
    [anon_sym_int] = ACTIONS(812),
    [anon_sym_long] = ACTIONS(812),
    [anon_sym_char] = ACTIONS(812),
    [anon_sym_float] = ACTIONS(812),
    [anon_sym_double] = ACTIONS(812),
    [sym_boolean_type] = ACTIONS(812),
    [sym_void_type] = ACTIONS(812),
    [sym_this] = ACTIONS(812),
    [sym_super] = ACTIONS(812),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(416),
    [sym_cast_expression] = STATE(416),
    [sym_assignment_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_instanceof_expression] = STATE(416),
    [sym_lambda_expression] = STATE(416),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(814),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(816),
    [sym_identifier] = ACTIONS(818),
    [sym_decimal_integer_literal] = ACTIONS(818),
    [sym_hex_integer_literal] = ACTIONS(818),
    [sym_octal_integer_literal] = ACTIONS(816),
    [sym_binary_integer_literal] = ACTIONS(816),
    [sym_decimal_floating_point_literal] = ACTIONS(816),
    [sym_hex_floating_point_literal] = ACTIONS(818),
    [sym_true] = ACTIONS(818),
    [sym_false] = ACTIONS(818),
    [sym_character_literal] = ACTIONS(816),
    [sym_string_literal] = ACTIONS(816),
    [sym_null_literal] = ACTIONS(818),
    [anon_sym_LPAREN] = ACTIONS(816),
    [anon_sym_PLUS] = ACTIONS(818),
    [anon_sym_DASH] = ACTIONS(818),
    [anon_sym_BANG] = ACTIONS(816),
    [anon_sym_TILDE] = ACTIONS(816),
    [anon_sym_PLUS_PLUS] = ACTIONS(816),
    [anon_sym_DASH_DASH] = ACTIONS(816),
    [anon_sym_new] = ACTIONS(818),
    [anon_sym_class] = ACTIONS(818),
    [anon_sym_SEMI] = ACTIONS(816),
    [anon_sym_LBRACE] = ACTIONS(816),
    [anon_sym_RBRACE] = ACTIONS(816),
    [anon_sym_assert] = ACTIONS(818),
    [anon_sym_switch] = ACTIONS(818),
    [anon_sym_case] = ACTIONS(818),
    [anon_sym_default] = ACTIONS(818),
    [anon_sym_do] = ACTIONS(818),
    [anon_sym_while] = ACTIONS(818),
    [anon_sym_break] = ACTIONS(818),
    [anon_sym_continue] = ACTIONS(818),
    [anon_sym_return] = ACTIONS(818),
    [anon_sym_synchronized] = ACTIONS(818),
    [anon_sym_throw] = ACTIONS(818),
    [anon_sym_try] = ACTIONS(818),
    [anon_sym_if] = ACTIONS(818),
    [anon_sym_else] = ACTIONS(818),
    [anon_sym_for] = ACTIONS(818),
    [anon_sym_AT] = ACTIONS(818),
    [anon_sym_open] = ACTIONS(818),
    [anon_sym_module] = ACTIONS(818),
    [anon_sym_static] = ACTIONS(818),
    [anon_sym_package] = ACTIONS(818),
    [anon_sym_import] = ACTIONS(818),
    [anon_sym_enum] = ACTIONS(818),
    [anon_sym_public] = ACTIONS(818),
    [anon_sym_protected] = ACTIONS(818),
    [anon_sym_private] = ACTIONS(818),
    [anon_sym_abstract] = ACTIONS(818),
    [anon_sym_final] = ACTIONS(818),
    [anon_sym_strictfp] = ACTIONS(818),
    [anon_sym_native] = ACTIONS(818),
    [anon_sym_transient] = ACTIONS(818),
    [anon_sym_volatile] = ACTIONS(818),
    [anon_sym_ATinterface] = ACTIONS(816),
    [anon_sym_interface] = ACTIONS(818),
    [anon_sym_byte] = ACTIONS(818),
    [anon_sym_short] = ACTIONS(818),
    [anon_sym_int] = ACTIONS(818),
    [anon_sym_long] = ACTIONS(818),
    [anon_sym_char] = ACTIONS(818),
    [anon_sym_float] = ACTIONS(818),
    [anon_sym_double] = ACTIONS(818),
    [sym_boolean_type] = ACTIONS(818),
    [sym_void_type] = ACTIONS(818),
    [sym_this] = ACTIONS(818),
    [sym_super] = ACTIONS(818),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(820),
    [sym_identifier] = ACTIONS(822),
    [sym_decimal_integer_literal] = ACTIONS(822),
    [sym_hex_integer_literal] = ACTIONS(822),
    [sym_octal_integer_literal] = ACTIONS(820),
    [sym_binary_integer_literal] = ACTIONS(820),
    [sym_decimal_floating_point_literal] = ACTIONS(820),
    [sym_hex_floating_point_literal] = ACTIONS(822),
    [sym_true] = ACTIONS(822),
    [sym_false] = ACTIONS(822),
    [sym_character_literal] = ACTIONS(820),
    [sym_string_literal] = ACTIONS(820),
    [sym_null_literal] = ACTIONS(822),
    [anon_sym_LPAREN] = ACTIONS(820),
    [anon_sym_PLUS] = ACTIONS(822),
    [anon_sym_DASH] = ACTIONS(822),
    [anon_sym_BANG] = ACTIONS(820),
    [anon_sym_TILDE] = ACTIONS(820),
    [anon_sym_PLUS_PLUS] = ACTIONS(820),
    [anon_sym_DASH_DASH] = ACTIONS(820),
    [anon_sym_new] = ACTIONS(822),
    [anon_sym_class] = ACTIONS(822),
    [anon_sym_SEMI] = ACTIONS(820),
    [anon_sym_LBRACE] = ACTIONS(820),
    [anon_sym_RBRACE] = ACTIONS(820),
    [anon_sym_assert] = ACTIONS(822),
    [anon_sym_switch] = ACTIONS(822),
    [anon_sym_case] = ACTIONS(822),
    [anon_sym_default] = ACTIONS(822),
    [anon_sym_do] = ACTIONS(822),
    [anon_sym_while] = ACTIONS(822),
    [anon_sym_break] = ACTIONS(822),
    [anon_sym_continue] = ACTIONS(822),
    [anon_sym_return] = ACTIONS(822),
    [anon_sym_synchronized] = ACTIONS(822),
    [anon_sym_throw] = ACTIONS(822),
    [anon_sym_try] = ACTIONS(822),
    [anon_sym_if] = ACTIONS(822),
    [anon_sym_else] = ACTIONS(822),
    [anon_sym_for] = ACTIONS(822),
    [anon_sym_AT] = ACTIONS(822),
    [anon_sym_open] = ACTIONS(822),
    [anon_sym_module] = ACTIONS(822),
    [anon_sym_static] = ACTIONS(822),
    [anon_sym_package] = ACTIONS(822),
    [anon_sym_import] = ACTIONS(822),
    [anon_sym_enum] = ACTIONS(822),
    [anon_sym_public] = ACTIONS(822),
    [anon_sym_protected] = ACTIONS(822),
    [anon_sym_private] = ACTIONS(822),
    [anon_sym_abstract] = ACTIONS(822),
    [anon_sym_final] = ACTIONS(822),
    [anon_sym_strictfp] = ACTIONS(822),
    [anon_sym_native] = ACTIONS(822),
    [anon_sym_transient] = ACTIONS(822),
    [anon_sym_volatile] = ACTIONS(822),
    [anon_sym_ATinterface] = ACTIONS(820),
    [anon_sym_interface] = ACTIONS(822),
    [anon_sym_byte] = ACTIONS(822),
    [anon_sym_short] = ACTIONS(822),
    [anon_sym_int] = ACTIONS(822),
    [anon_sym_long] = ACTIONS(822),
    [anon_sym_char] = ACTIONS(822),
    [anon_sym_float] = ACTIONS(822),
    [anon_sym_double] = ACTIONS(822),
    [sym_boolean_type] = ACTIONS(822),
    [sym_void_type] = ACTIONS(822),
    [sym_this] = ACTIONS(822),
    [sym_super] = ACTIONS(822),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(824),
    [sym_identifier] = ACTIONS(826),
    [sym_decimal_integer_literal] = ACTIONS(826),
    [sym_hex_integer_literal] = ACTIONS(826),
    [sym_octal_integer_literal] = ACTIONS(824),
    [sym_binary_integer_literal] = ACTIONS(824),
    [sym_decimal_floating_point_literal] = ACTIONS(824),
    [sym_hex_floating_point_literal] = ACTIONS(826),
    [sym_true] = ACTIONS(826),
    [sym_false] = ACTIONS(826),
    [sym_character_literal] = ACTIONS(824),
    [sym_string_literal] = ACTIONS(824),
    [sym_null_literal] = ACTIONS(826),
    [anon_sym_LPAREN] = ACTIONS(824),
    [anon_sym_PLUS] = ACTIONS(826),
    [anon_sym_DASH] = ACTIONS(826),
    [anon_sym_BANG] = ACTIONS(824),
    [anon_sym_TILDE] = ACTIONS(824),
    [anon_sym_PLUS_PLUS] = ACTIONS(824),
    [anon_sym_DASH_DASH] = ACTIONS(824),
    [anon_sym_new] = ACTIONS(826),
    [anon_sym_class] = ACTIONS(826),
    [anon_sym_SEMI] = ACTIONS(824),
    [anon_sym_LBRACE] = ACTIONS(824),
    [anon_sym_RBRACE] = ACTIONS(824),
    [anon_sym_assert] = ACTIONS(826),
    [anon_sym_switch] = ACTIONS(826),
    [anon_sym_case] = ACTIONS(826),
    [anon_sym_default] = ACTIONS(826),
    [anon_sym_do] = ACTIONS(826),
    [anon_sym_while] = ACTIONS(826),
    [anon_sym_break] = ACTIONS(826),
    [anon_sym_continue] = ACTIONS(826),
    [anon_sym_return] = ACTIONS(826),
    [anon_sym_synchronized] = ACTIONS(826),
    [anon_sym_throw] = ACTIONS(826),
    [anon_sym_try] = ACTIONS(826),
    [anon_sym_if] = ACTIONS(826),
    [anon_sym_else] = ACTIONS(826),
    [anon_sym_for] = ACTIONS(826),
    [anon_sym_AT] = ACTIONS(826),
    [anon_sym_open] = ACTIONS(826),
    [anon_sym_module] = ACTIONS(826),
    [anon_sym_static] = ACTIONS(826),
    [anon_sym_package] = ACTIONS(826),
    [anon_sym_import] = ACTIONS(826),
    [anon_sym_enum] = ACTIONS(826),
    [anon_sym_public] = ACTIONS(826),
    [anon_sym_protected] = ACTIONS(826),
    [anon_sym_private] = ACTIONS(826),
    [anon_sym_abstract] = ACTIONS(826),
    [anon_sym_final] = ACTIONS(826),
    [anon_sym_strictfp] = ACTIONS(826),
    [anon_sym_native] = ACTIONS(826),
    [anon_sym_transient] = ACTIONS(826),
    [anon_sym_volatile] = ACTIONS(826),
    [anon_sym_ATinterface] = ACTIONS(824),
    [anon_sym_interface] = ACTIONS(826),
    [anon_sym_byte] = ACTIONS(826),
    [anon_sym_short] = ACTIONS(826),
    [anon_sym_int] = ACTIONS(826),
    [anon_sym_long] = ACTIONS(826),
    [anon_sym_char] = ACTIONS(826),
    [anon_sym_float] = ACTIONS(826),
    [anon_sym_double] = ACTIONS(826),
    [sym_boolean_type] = ACTIONS(826),
    [sym_void_type] = ACTIONS(826),
    [sym_this] = ACTIONS(826),
    [sym_super] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(828),
    [sym_identifier] = ACTIONS(830),
    [sym_decimal_integer_literal] = ACTIONS(830),
    [sym_hex_integer_literal] = ACTIONS(830),
    [sym_octal_integer_literal] = ACTIONS(828),
    [sym_binary_integer_literal] = ACTIONS(828),
    [sym_decimal_floating_point_literal] = ACTIONS(828),
    [sym_hex_floating_point_literal] = ACTIONS(830),
    [sym_true] = ACTIONS(830),
    [sym_false] = ACTIONS(830),
    [sym_character_literal] = ACTIONS(828),
    [sym_string_literal] = ACTIONS(828),
    [sym_null_literal] = ACTIONS(830),
    [anon_sym_LPAREN] = ACTIONS(828),
    [anon_sym_PLUS] = ACTIONS(830),
    [anon_sym_DASH] = ACTIONS(830),
    [anon_sym_BANG] = ACTIONS(828),
    [anon_sym_TILDE] = ACTIONS(828),
    [anon_sym_PLUS_PLUS] = ACTIONS(828),
    [anon_sym_DASH_DASH] = ACTIONS(828),
    [anon_sym_new] = ACTIONS(830),
    [anon_sym_class] = ACTIONS(830),
    [anon_sym_SEMI] = ACTIONS(828),
    [anon_sym_LBRACE] = ACTIONS(828),
    [anon_sym_RBRACE] = ACTIONS(828),
    [anon_sym_assert] = ACTIONS(830),
    [anon_sym_switch] = ACTIONS(830),
    [anon_sym_case] = ACTIONS(830),
    [anon_sym_default] = ACTIONS(830),
    [anon_sym_do] = ACTIONS(830),
    [anon_sym_while] = ACTIONS(830),
    [anon_sym_break] = ACTIONS(830),
    [anon_sym_continue] = ACTIONS(830),
    [anon_sym_return] = ACTIONS(830),
    [anon_sym_synchronized] = ACTIONS(830),
    [anon_sym_throw] = ACTIONS(830),
    [anon_sym_try] = ACTIONS(830),
    [anon_sym_if] = ACTIONS(830),
    [anon_sym_else] = ACTIONS(830),
    [anon_sym_for] = ACTIONS(830),
    [anon_sym_AT] = ACTIONS(830),
    [anon_sym_open] = ACTIONS(830),
    [anon_sym_module] = ACTIONS(830),
    [anon_sym_static] = ACTIONS(830),
    [anon_sym_package] = ACTIONS(830),
    [anon_sym_import] = ACTIONS(830),
    [anon_sym_enum] = ACTIONS(830),
    [anon_sym_public] = ACTIONS(830),
    [anon_sym_protected] = ACTIONS(830),
    [anon_sym_private] = ACTIONS(830),
    [anon_sym_abstract] = ACTIONS(830),
    [anon_sym_final] = ACTIONS(830),
    [anon_sym_strictfp] = ACTIONS(830),
    [anon_sym_native] = ACTIONS(830),
    [anon_sym_transient] = ACTIONS(830),
    [anon_sym_volatile] = ACTIONS(830),
    [anon_sym_ATinterface] = ACTIONS(828),
    [anon_sym_interface] = ACTIONS(830),
    [anon_sym_byte] = ACTIONS(830),
    [anon_sym_short] = ACTIONS(830),
    [anon_sym_int] = ACTIONS(830),
    [anon_sym_long] = ACTIONS(830),
    [anon_sym_char] = ACTIONS(830),
    [anon_sym_float] = ACTIONS(830),
    [anon_sym_double] = ACTIONS(830),
    [sym_boolean_type] = ACTIONS(830),
    [sym_void_type] = ACTIONS(830),
    [sym_this] = ACTIONS(830),
    [sym_super] = ACTIONS(830),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(832),
    [sym_identifier] = ACTIONS(834),
    [sym_decimal_integer_literal] = ACTIONS(834),
    [sym_hex_integer_literal] = ACTIONS(834),
    [sym_octal_integer_literal] = ACTIONS(832),
    [sym_binary_integer_literal] = ACTIONS(832),
    [sym_decimal_floating_point_literal] = ACTIONS(832),
    [sym_hex_floating_point_literal] = ACTIONS(834),
    [sym_true] = ACTIONS(834),
    [sym_false] = ACTIONS(834),
    [sym_character_literal] = ACTIONS(832),
    [sym_string_literal] = ACTIONS(832),
    [sym_null_literal] = ACTIONS(834),
    [anon_sym_LPAREN] = ACTIONS(832),
    [anon_sym_PLUS] = ACTIONS(834),
    [anon_sym_DASH] = ACTIONS(834),
    [anon_sym_BANG] = ACTIONS(832),
    [anon_sym_TILDE] = ACTIONS(832),
    [anon_sym_PLUS_PLUS] = ACTIONS(832),
    [anon_sym_DASH_DASH] = ACTIONS(832),
    [anon_sym_new] = ACTIONS(834),
    [anon_sym_class] = ACTIONS(834),
    [anon_sym_SEMI] = ACTIONS(832),
    [anon_sym_LBRACE] = ACTIONS(832),
    [anon_sym_RBRACE] = ACTIONS(832),
    [anon_sym_assert] = ACTIONS(834),
    [anon_sym_switch] = ACTIONS(834),
    [anon_sym_case] = ACTIONS(834),
    [anon_sym_default] = ACTIONS(834),
    [anon_sym_do] = ACTIONS(834),
    [anon_sym_while] = ACTIONS(834),
    [anon_sym_break] = ACTIONS(834),
    [anon_sym_continue] = ACTIONS(834),
    [anon_sym_return] = ACTIONS(834),
    [anon_sym_synchronized] = ACTIONS(834),
    [anon_sym_throw] = ACTIONS(834),
    [anon_sym_try] = ACTIONS(834),
    [anon_sym_if] = ACTIONS(834),
    [anon_sym_else] = ACTIONS(834),
    [anon_sym_for] = ACTIONS(834),
    [anon_sym_AT] = ACTIONS(834),
    [anon_sym_open] = ACTIONS(834),
    [anon_sym_module] = ACTIONS(834),
    [anon_sym_static] = ACTIONS(834),
    [anon_sym_package] = ACTIONS(834),
    [anon_sym_import] = ACTIONS(834),
    [anon_sym_enum] = ACTIONS(834),
    [anon_sym_public] = ACTIONS(834),
    [anon_sym_protected] = ACTIONS(834),
    [anon_sym_private] = ACTIONS(834),
    [anon_sym_abstract] = ACTIONS(834),
    [anon_sym_final] = ACTIONS(834),
    [anon_sym_strictfp] = ACTIONS(834),
    [anon_sym_native] = ACTIONS(834),
    [anon_sym_transient] = ACTIONS(834),
    [anon_sym_volatile] = ACTIONS(834),
    [anon_sym_ATinterface] = ACTIONS(832),
    [anon_sym_interface] = ACTIONS(834),
    [anon_sym_byte] = ACTIONS(834),
    [anon_sym_short] = ACTIONS(834),
    [anon_sym_int] = ACTIONS(834),
    [anon_sym_long] = ACTIONS(834),
    [anon_sym_char] = ACTIONS(834),
    [anon_sym_float] = ACTIONS(834),
    [anon_sym_double] = ACTIONS(834),
    [sym_boolean_type] = ACTIONS(834),
    [sym_void_type] = ACTIONS(834),
    [sym_this] = ACTIONS(834),
    [sym_super] = ACTIONS(834),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(419),
    [sym_cast_expression] = STATE(419),
    [sym_assignment_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_instanceof_expression] = STATE(419),
    [sym_lambda_expression] = STATE(419),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(836),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(838),
    [sym_identifier] = ACTIONS(840),
    [sym_decimal_integer_literal] = ACTIONS(840),
    [sym_hex_integer_literal] = ACTIONS(840),
    [sym_octal_integer_literal] = ACTIONS(838),
    [sym_binary_integer_literal] = ACTIONS(838),
    [sym_decimal_floating_point_literal] = ACTIONS(838),
    [sym_hex_floating_point_literal] = ACTIONS(840),
    [sym_true] = ACTIONS(840),
    [sym_false] = ACTIONS(840),
    [sym_character_literal] = ACTIONS(838),
    [sym_string_literal] = ACTIONS(838),
    [sym_null_literal] = ACTIONS(840),
    [anon_sym_LPAREN] = ACTIONS(838),
    [anon_sym_PLUS] = ACTIONS(840),
    [anon_sym_DASH] = ACTIONS(840),
    [anon_sym_BANG] = ACTIONS(838),
    [anon_sym_TILDE] = ACTIONS(838),
    [anon_sym_PLUS_PLUS] = ACTIONS(838),
    [anon_sym_DASH_DASH] = ACTIONS(838),
    [anon_sym_new] = ACTIONS(840),
    [anon_sym_class] = ACTIONS(840),
    [anon_sym_SEMI] = ACTIONS(838),
    [anon_sym_LBRACE] = ACTIONS(838),
    [anon_sym_RBRACE] = ACTIONS(838),
    [anon_sym_assert] = ACTIONS(840),
    [anon_sym_switch] = ACTIONS(840),
    [anon_sym_case] = ACTIONS(840),
    [anon_sym_default] = ACTIONS(840),
    [anon_sym_do] = ACTIONS(840),
    [anon_sym_while] = ACTIONS(840),
    [anon_sym_break] = ACTIONS(840),
    [anon_sym_continue] = ACTIONS(840),
    [anon_sym_return] = ACTIONS(840),
    [anon_sym_synchronized] = ACTIONS(840),
    [anon_sym_throw] = ACTIONS(840),
    [anon_sym_try] = ACTIONS(840),
    [anon_sym_if] = ACTIONS(840),
    [anon_sym_else] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(840),
    [anon_sym_AT] = ACTIONS(840),
    [anon_sym_open] = ACTIONS(840),
    [anon_sym_module] = ACTIONS(840),
    [anon_sym_static] = ACTIONS(840),
    [anon_sym_package] = ACTIONS(840),
    [anon_sym_import] = ACTIONS(840),
    [anon_sym_enum] = ACTIONS(840),
    [anon_sym_public] = ACTIONS(840),
    [anon_sym_protected] = ACTIONS(840),
    [anon_sym_private] = ACTIONS(840),
    [anon_sym_abstract] = ACTIONS(840),
    [anon_sym_final] = ACTIONS(840),
    [anon_sym_strictfp] = ACTIONS(840),
    [anon_sym_native] = ACTIONS(840),
    [anon_sym_transient] = ACTIONS(840),
    [anon_sym_volatile] = ACTIONS(840),
    [anon_sym_ATinterface] = ACTIONS(838),
    [anon_sym_interface] = ACTIONS(840),
    [anon_sym_byte] = ACTIONS(840),
    [anon_sym_short] = ACTIONS(840),
    [anon_sym_int] = ACTIONS(840),
    [anon_sym_long] = ACTIONS(840),
    [anon_sym_char] = ACTIONS(840),
    [anon_sym_float] = ACTIONS(840),
    [anon_sym_double] = ACTIONS(840),
    [sym_boolean_type] = ACTIONS(840),
    [sym_void_type] = ACTIONS(840),
    [sym_this] = ACTIONS(840),
    [sym_super] = ACTIONS(840),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(842),
    [sym_identifier] = ACTIONS(844),
    [sym_decimal_integer_literal] = ACTIONS(844),
    [sym_hex_integer_literal] = ACTIONS(844),
    [sym_octal_integer_literal] = ACTIONS(842),
    [sym_binary_integer_literal] = ACTIONS(842),
    [sym_decimal_floating_point_literal] = ACTIONS(842),
    [sym_hex_floating_point_literal] = ACTIONS(844),
    [sym_true] = ACTIONS(844),
    [sym_false] = ACTIONS(844),
    [sym_character_literal] = ACTIONS(842),
    [sym_string_literal] = ACTIONS(842),
    [sym_null_literal] = ACTIONS(844),
    [anon_sym_LPAREN] = ACTIONS(842),
    [anon_sym_PLUS] = ACTIONS(844),
    [anon_sym_DASH] = ACTIONS(844),
    [anon_sym_BANG] = ACTIONS(842),
    [anon_sym_TILDE] = ACTIONS(842),
    [anon_sym_PLUS_PLUS] = ACTIONS(842),
    [anon_sym_DASH_DASH] = ACTIONS(842),
    [anon_sym_new] = ACTIONS(844),
    [anon_sym_class] = ACTIONS(844),
    [anon_sym_SEMI] = ACTIONS(842),
    [anon_sym_LBRACE] = ACTIONS(842),
    [anon_sym_RBRACE] = ACTIONS(842),
    [anon_sym_assert] = ACTIONS(844),
    [anon_sym_switch] = ACTIONS(844),
    [anon_sym_case] = ACTIONS(844),
    [anon_sym_default] = ACTIONS(844),
    [anon_sym_do] = ACTIONS(844),
    [anon_sym_while] = ACTIONS(844),
    [anon_sym_break] = ACTIONS(844),
    [anon_sym_continue] = ACTIONS(844),
    [anon_sym_return] = ACTIONS(844),
    [anon_sym_synchronized] = ACTIONS(844),
    [anon_sym_throw] = ACTIONS(844),
    [anon_sym_try] = ACTIONS(844),
    [anon_sym_if] = ACTIONS(844),
    [anon_sym_else] = ACTIONS(844),
    [anon_sym_for] = ACTIONS(844),
    [anon_sym_AT] = ACTIONS(844),
    [anon_sym_open] = ACTIONS(844),
    [anon_sym_module] = ACTIONS(844),
    [anon_sym_static] = ACTIONS(844),
    [anon_sym_package] = ACTIONS(844),
    [anon_sym_import] = ACTIONS(844),
    [anon_sym_enum] = ACTIONS(844),
    [anon_sym_public] = ACTIONS(844),
    [anon_sym_protected] = ACTIONS(844),
    [anon_sym_private] = ACTIONS(844),
    [anon_sym_abstract] = ACTIONS(844),
    [anon_sym_final] = ACTIONS(844),
    [anon_sym_strictfp] = ACTIONS(844),
    [anon_sym_native] = ACTIONS(844),
    [anon_sym_transient] = ACTIONS(844),
    [anon_sym_volatile] = ACTIONS(844),
    [anon_sym_ATinterface] = ACTIONS(842),
    [anon_sym_interface] = ACTIONS(844),
    [anon_sym_byte] = ACTIONS(844),
    [anon_sym_short] = ACTIONS(844),
    [anon_sym_int] = ACTIONS(844),
    [anon_sym_long] = ACTIONS(844),
    [anon_sym_char] = ACTIONS(844),
    [anon_sym_float] = ACTIONS(844),
    [anon_sym_double] = ACTIONS(844),
    [sym_boolean_type] = ACTIONS(844),
    [sym_void_type] = ACTIONS(844),
    [sym_this] = ACTIONS(844),
    [sym_super] = ACTIONS(844),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(846),
    [sym_identifier] = ACTIONS(848),
    [sym_decimal_integer_literal] = ACTIONS(848),
    [sym_hex_integer_literal] = ACTIONS(848),
    [sym_octal_integer_literal] = ACTIONS(846),
    [sym_binary_integer_literal] = ACTIONS(846),
    [sym_decimal_floating_point_literal] = ACTIONS(846),
    [sym_hex_floating_point_literal] = ACTIONS(848),
    [sym_true] = ACTIONS(848),
    [sym_false] = ACTIONS(848),
    [sym_character_literal] = ACTIONS(846),
    [sym_string_literal] = ACTIONS(846),
    [sym_null_literal] = ACTIONS(848),
    [anon_sym_LPAREN] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(848),
    [anon_sym_DASH] = ACTIONS(848),
    [anon_sym_BANG] = ACTIONS(846),
    [anon_sym_TILDE] = ACTIONS(846),
    [anon_sym_PLUS_PLUS] = ACTIONS(846),
    [anon_sym_DASH_DASH] = ACTIONS(846),
    [anon_sym_new] = ACTIONS(848),
    [anon_sym_class] = ACTIONS(848),
    [anon_sym_SEMI] = ACTIONS(846),
    [anon_sym_LBRACE] = ACTIONS(846),
    [anon_sym_RBRACE] = ACTIONS(846),
    [anon_sym_assert] = ACTIONS(848),
    [anon_sym_switch] = ACTIONS(848),
    [anon_sym_case] = ACTIONS(848),
    [anon_sym_default] = ACTIONS(848),
    [anon_sym_do] = ACTIONS(848),
    [anon_sym_while] = ACTIONS(848),
    [anon_sym_break] = ACTIONS(848),
    [anon_sym_continue] = ACTIONS(848),
    [anon_sym_return] = ACTIONS(848),
    [anon_sym_synchronized] = ACTIONS(848),
    [anon_sym_throw] = ACTIONS(848),
    [anon_sym_try] = ACTIONS(848),
    [anon_sym_if] = ACTIONS(848),
    [anon_sym_else] = ACTIONS(848),
    [anon_sym_for] = ACTIONS(848),
    [anon_sym_AT] = ACTIONS(848),
    [anon_sym_open] = ACTIONS(848),
    [anon_sym_module] = ACTIONS(848),
    [anon_sym_static] = ACTIONS(848),
    [anon_sym_package] = ACTIONS(848),
    [anon_sym_import] = ACTIONS(848),
    [anon_sym_enum] = ACTIONS(848),
    [anon_sym_public] = ACTIONS(848),
    [anon_sym_protected] = ACTIONS(848),
    [anon_sym_private] = ACTIONS(848),
    [anon_sym_abstract] = ACTIONS(848),
    [anon_sym_final] = ACTIONS(848),
    [anon_sym_strictfp] = ACTIONS(848),
    [anon_sym_native] = ACTIONS(848),
    [anon_sym_transient] = ACTIONS(848),
    [anon_sym_volatile] = ACTIONS(848),
    [anon_sym_ATinterface] = ACTIONS(846),
    [anon_sym_interface] = ACTIONS(848),
    [anon_sym_byte] = ACTIONS(848),
    [anon_sym_short] = ACTIONS(848),
    [anon_sym_int] = ACTIONS(848),
    [anon_sym_long] = ACTIONS(848),
    [anon_sym_char] = ACTIONS(848),
    [anon_sym_float] = ACTIONS(848),
    [anon_sym_double] = ACTIONS(848),
    [sym_boolean_type] = ACTIONS(848),
    [sym_void_type] = ACTIONS(848),
    [sym_this] = ACTIONS(848),
    [sym_super] = ACTIONS(848),
    [sym_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(850),
    [sym_identifier] = ACTIONS(852),
    [sym_decimal_integer_literal] = ACTIONS(852),
    [sym_hex_integer_literal] = ACTIONS(852),
    [sym_octal_integer_literal] = ACTIONS(850),
    [sym_binary_integer_literal] = ACTIONS(850),
    [sym_decimal_floating_point_literal] = ACTIONS(850),
    [sym_hex_floating_point_literal] = ACTIONS(852),
    [sym_true] = ACTIONS(852),
    [sym_false] = ACTIONS(852),
    [sym_character_literal] = ACTIONS(850),
    [sym_string_literal] = ACTIONS(850),
    [sym_null_literal] = ACTIONS(852),
    [anon_sym_LPAREN] = ACTIONS(850),
    [anon_sym_PLUS] = ACTIONS(852),
    [anon_sym_DASH] = ACTIONS(852),
    [anon_sym_BANG] = ACTIONS(850),
    [anon_sym_TILDE] = ACTIONS(850),
    [anon_sym_PLUS_PLUS] = ACTIONS(850),
    [anon_sym_DASH_DASH] = ACTIONS(850),
    [anon_sym_new] = ACTIONS(852),
    [anon_sym_class] = ACTIONS(852),
    [anon_sym_SEMI] = ACTIONS(850),
    [anon_sym_LBRACE] = ACTIONS(850),
    [anon_sym_RBRACE] = ACTIONS(850),
    [anon_sym_assert] = ACTIONS(852),
    [anon_sym_switch] = ACTIONS(852),
    [anon_sym_case] = ACTIONS(852),
    [anon_sym_default] = ACTIONS(852),
    [anon_sym_do] = ACTIONS(852),
    [anon_sym_while] = ACTIONS(852),
    [anon_sym_break] = ACTIONS(852),
    [anon_sym_continue] = ACTIONS(852),
    [anon_sym_return] = ACTIONS(852),
    [anon_sym_synchronized] = ACTIONS(852),
    [anon_sym_throw] = ACTIONS(852),
    [anon_sym_try] = ACTIONS(852),
    [anon_sym_if] = ACTIONS(852),
    [anon_sym_else] = ACTIONS(852),
    [anon_sym_for] = ACTIONS(852),
    [anon_sym_AT] = ACTIONS(852),
    [anon_sym_open] = ACTIONS(852),
    [anon_sym_module] = ACTIONS(852),
    [anon_sym_static] = ACTIONS(852),
    [anon_sym_package] = ACTIONS(852),
    [anon_sym_import] = ACTIONS(852),
    [anon_sym_enum] = ACTIONS(852),
    [anon_sym_public] = ACTIONS(852),
    [anon_sym_protected] = ACTIONS(852),
    [anon_sym_private] = ACTIONS(852),
    [anon_sym_abstract] = ACTIONS(852),
    [anon_sym_final] = ACTIONS(852),
    [anon_sym_strictfp] = ACTIONS(852),
    [anon_sym_native] = ACTIONS(852),
    [anon_sym_transient] = ACTIONS(852),
    [anon_sym_volatile] = ACTIONS(852),
    [anon_sym_ATinterface] = ACTIONS(850),
    [anon_sym_interface] = ACTIONS(852),
    [anon_sym_byte] = ACTIONS(852),
    [anon_sym_short] = ACTIONS(852),
    [anon_sym_int] = ACTIONS(852),
    [anon_sym_long] = ACTIONS(852),
    [anon_sym_char] = ACTIONS(852),
    [anon_sym_float] = ACTIONS(852),
    [anon_sym_double] = ACTIONS(852),
    [sym_boolean_type] = ACTIONS(852),
    [sym_void_type] = ACTIONS(852),
    [sym_this] = ACTIONS(852),
    [sym_super] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(854),
    [sym_identifier] = ACTIONS(856),
    [sym_decimal_integer_literal] = ACTIONS(856),
    [sym_hex_integer_literal] = ACTIONS(856),
    [sym_octal_integer_literal] = ACTIONS(854),
    [sym_binary_integer_literal] = ACTIONS(854),
    [sym_decimal_floating_point_literal] = ACTIONS(854),
    [sym_hex_floating_point_literal] = ACTIONS(856),
    [sym_true] = ACTIONS(856),
    [sym_false] = ACTIONS(856),
    [sym_character_literal] = ACTIONS(854),
    [sym_string_literal] = ACTIONS(854),
    [sym_null_literal] = ACTIONS(856),
    [anon_sym_LPAREN] = ACTIONS(854),
    [anon_sym_PLUS] = ACTIONS(856),
    [anon_sym_DASH] = ACTIONS(856),
    [anon_sym_BANG] = ACTIONS(854),
    [anon_sym_TILDE] = ACTIONS(854),
    [anon_sym_PLUS_PLUS] = ACTIONS(854),
    [anon_sym_DASH_DASH] = ACTIONS(854),
    [anon_sym_new] = ACTIONS(856),
    [anon_sym_class] = ACTIONS(856),
    [anon_sym_SEMI] = ACTIONS(854),
    [anon_sym_LBRACE] = ACTIONS(854),
    [anon_sym_RBRACE] = ACTIONS(854),
    [anon_sym_assert] = ACTIONS(856),
    [anon_sym_switch] = ACTIONS(856),
    [anon_sym_case] = ACTIONS(856),
    [anon_sym_default] = ACTIONS(856),
    [anon_sym_do] = ACTIONS(856),
    [anon_sym_while] = ACTIONS(856),
    [anon_sym_break] = ACTIONS(856),
    [anon_sym_continue] = ACTIONS(856),
    [anon_sym_return] = ACTIONS(856),
    [anon_sym_synchronized] = ACTIONS(856),
    [anon_sym_throw] = ACTIONS(856),
    [anon_sym_try] = ACTIONS(856),
    [anon_sym_if] = ACTIONS(856),
    [anon_sym_else] = ACTIONS(856),
    [anon_sym_for] = ACTIONS(856),
    [anon_sym_AT] = ACTIONS(856),
    [anon_sym_open] = ACTIONS(856),
    [anon_sym_module] = ACTIONS(856),
    [anon_sym_static] = ACTIONS(856),
    [anon_sym_package] = ACTIONS(856),
    [anon_sym_import] = ACTIONS(856),
    [anon_sym_enum] = ACTIONS(856),
    [anon_sym_public] = ACTIONS(856),
    [anon_sym_protected] = ACTIONS(856),
    [anon_sym_private] = ACTIONS(856),
    [anon_sym_abstract] = ACTIONS(856),
    [anon_sym_final] = ACTIONS(856),
    [anon_sym_strictfp] = ACTIONS(856),
    [anon_sym_native] = ACTIONS(856),
    [anon_sym_transient] = ACTIONS(856),
    [anon_sym_volatile] = ACTIONS(856),
    [anon_sym_ATinterface] = ACTIONS(854),
    [anon_sym_interface] = ACTIONS(856),
    [anon_sym_byte] = ACTIONS(856),
    [anon_sym_short] = ACTIONS(856),
    [anon_sym_int] = ACTIONS(856),
    [anon_sym_long] = ACTIONS(856),
    [anon_sym_char] = ACTIONS(856),
    [anon_sym_float] = ACTIONS(856),
    [anon_sym_double] = ACTIONS(856),
    [sym_boolean_type] = ACTIONS(856),
    [sym_void_type] = ACTIONS(856),
    [sym_this] = ACTIONS(856),
    [sym_super] = ACTIONS(856),
    [sym_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(858),
    [sym_identifier] = ACTIONS(860),
    [sym_decimal_integer_literal] = ACTIONS(860),
    [sym_hex_integer_literal] = ACTIONS(860),
    [sym_octal_integer_literal] = ACTIONS(858),
    [sym_binary_integer_literal] = ACTIONS(858),
    [sym_decimal_floating_point_literal] = ACTIONS(858),
    [sym_hex_floating_point_literal] = ACTIONS(860),
    [sym_true] = ACTIONS(860),
    [sym_false] = ACTIONS(860),
    [sym_character_literal] = ACTIONS(858),
    [sym_string_literal] = ACTIONS(858),
    [sym_null_literal] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(858),
    [anon_sym_PLUS] = ACTIONS(860),
    [anon_sym_DASH] = ACTIONS(860),
    [anon_sym_BANG] = ACTIONS(858),
    [anon_sym_TILDE] = ACTIONS(858),
    [anon_sym_PLUS_PLUS] = ACTIONS(858),
    [anon_sym_DASH_DASH] = ACTIONS(858),
    [anon_sym_new] = ACTIONS(860),
    [anon_sym_class] = ACTIONS(860),
    [anon_sym_SEMI] = ACTIONS(858),
    [anon_sym_LBRACE] = ACTIONS(858),
    [anon_sym_RBRACE] = ACTIONS(858),
    [anon_sym_assert] = ACTIONS(860),
    [anon_sym_switch] = ACTIONS(860),
    [anon_sym_case] = ACTIONS(860),
    [anon_sym_default] = ACTIONS(860),
    [anon_sym_do] = ACTIONS(860),
    [anon_sym_while] = ACTIONS(860),
    [anon_sym_break] = ACTIONS(860),
    [anon_sym_continue] = ACTIONS(860),
    [anon_sym_return] = ACTIONS(860),
    [anon_sym_synchronized] = ACTIONS(860),
    [anon_sym_throw] = ACTIONS(860),
    [anon_sym_try] = ACTIONS(860),
    [anon_sym_if] = ACTIONS(860),
    [anon_sym_else] = ACTIONS(860),
    [anon_sym_for] = ACTIONS(860),
    [anon_sym_AT] = ACTIONS(860),
    [anon_sym_open] = ACTIONS(860),
    [anon_sym_module] = ACTIONS(860),
    [anon_sym_static] = ACTIONS(860),
    [anon_sym_package] = ACTIONS(860),
    [anon_sym_import] = ACTIONS(860),
    [anon_sym_enum] = ACTIONS(860),
    [anon_sym_public] = ACTIONS(860),
    [anon_sym_protected] = ACTIONS(860),
    [anon_sym_private] = ACTIONS(860),
    [anon_sym_abstract] = ACTIONS(860),
    [anon_sym_final] = ACTIONS(860),
    [anon_sym_strictfp] = ACTIONS(860),
    [anon_sym_native] = ACTIONS(860),
    [anon_sym_transient] = ACTIONS(860),
    [anon_sym_volatile] = ACTIONS(860),
    [anon_sym_ATinterface] = ACTIONS(858),
    [anon_sym_interface] = ACTIONS(860),
    [anon_sym_byte] = ACTIONS(860),
    [anon_sym_short] = ACTIONS(860),
    [anon_sym_int] = ACTIONS(860),
    [anon_sym_long] = ACTIONS(860),
    [anon_sym_char] = ACTIONS(860),
    [anon_sym_float] = ACTIONS(860),
    [anon_sym_double] = ACTIONS(860),
    [sym_boolean_type] = ACTIONS(860),
    [sym_void_type] = ACTIONS(860),
    [sym_this] = ACTIONS(860),
    [sym_super] = ACTIONS(860),
    [sym_comment] = ACTIONS(3),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(862),
    [sym_identifier] = ACTIONS(864),
    [sym_decimal_integer_literal] = ACTIONS(864),
    [sym_hex_integer_literal] = ACTIONS(864),
    [sym_octal_integer_literal] = ACTIONS(862),
    [sym_binary_integer_literal] = ACTIONS(862),
    [sym_decimal_floating_point_literal] = ACTIONS(862),
    [sym_hex_floating_point_literal] = ACTIONS(864),
    [sym_true] = ACTIONS(864),
    [sym_false] = ACTIONS(864),
    [sym_character_literal] = ACTIONS(862),
    [sym_string_literal] = ACTIONS(862),
    [sym_null_literal] = ACTIONS(864),
    [anon_sym_LPAREN] = ACTIONS(862),
    [anon_sym_PLUS] = ACTIONS(864),
    [anon_sym_DASH] = ACTIONS(864),
    [anon_sym_BANG] = ACTIONS(862),
    [anon_sym_TILDE] = ACTIONS(862),
    [anon_sym_PLUS_PLUS] = ACTIONS(862),
    [anon_sym_DASH_DASH] = ACTIONS(862),
    [anon_sym_new] = ACTIONS(864),
    [anon_sym_class] = ACTIONS(864),
    [anon_sym_SEMI] = ACTIONS(862),
    [anon_sym_LBRACE] = ACTIONS(862),
    [anon_sym_RBRACE] = ACTIONS(862),
    [anon_sym_assert] = ACTIONS(864),
    [anon_sym_switch] = ACTIONS(864),
    [anon_sym_case] = ACTIONS(864),
    [anon_sym_default] = ACTIONS(864),
    [anon_sym_do] = ACTIONS(864),
    [anon_sym_while] = ACTIONS(864),
    [anon_sym_break] = ACTIONS(864),
    [anon_sym_continue] = ACTIONS(864),
    [anon_sym_return] = ACTIONS(864),
    [anon_sym_synchronized] = ACTIONS(864),
    [anon_sym_throw] = ACTIONS(864),
    [anon_sym_try] = ACTIONS(864),
    [anon_sym_if] = ACTIONS(864),
    [anon_sym_else] = ACTIONS(864),
    [anon_sym_for] = ACTIONS(864),
    [anon_sym_AT] = ACTIONS(864),
    [anon_sym_open] = ACTIONS(864),
    [anon_sym_module] = ACTIONS(864),
    [anon_sym_static] = ACTIONS(864),
    [anon_sym_package] = ACTIONS(864),
    [anon_sym_import] = ACTIONS(864),
    [anon_sym_enum] = ACTIONS(864),
    [anon_sym_public] = ACTIONS(864),
    [anon_sym_protected] = ACTIONS(864),
    [anon_sym_private] = ACTIONS(864),
    [anon_sym_abstract] = ACTIONS(864),
    [anon_sym_final] = ACTIONS(864),
    [anon_sym_strictfp] = ACTIONS(864),
    [anon_sym_native] = ACTIONS(864),
    [anon_sym_transient] = ACTIONS(864),
    [anon_sym_volatile] = ACTIONS(864),
    [anon_sym_ATinterface] = ACTIONS(862),
    [anon_sym_interface] = ACTIONS(864),
    [anon_sym_byte] = ACTIONS(864),
    [anon_sym_short] = ACTIONS(864),
    [anon_sym_int] = ACTIONS(864),
    [anon_sym_long] = ACTIONS(864),
    [anon_sym_char] = ACTIONS(864),
    [anon_sym_float] = ACTIONS(864),
    [anon_sym_double] = ACTIONS(864),
    [sym_boolean_type] = ACTIONS(864),
    [sym_void_type] = ACTIONS(864),
    [sym_this] = ACTIONS(864),
    [sym_super] = ACTIONS(864),
    [sym_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(866),
    [sym_identifier] = ACTIONS(868),
    [sym_decimal_integer_literal] = ACTIONS(868),
    [sym_hex_integer_literal] = ACTIONS(868),
    [sym_octal_integer_literal] = ACTIONS(866),
    [sym_binary_integer_literal] = ACTIONS(866),
    [sym_decimal_floating_point_literal] = ACTIONS(866),
    [sym_hex_floating_point_literal] = ACTIONS(868),
    [sym_true] = ACTIONS(868),
    [sym_false] = ACTIONS(868),
    [sym_character_literal] = ACTIONS(866),
    [sym_string_literal] = ACTIONS(866),
    [sym_null_literal] = ACTIONS(868),
    [anon_sym_LPAREN] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(868),
    [anon_sym_DASH] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(866),
    [anon_sym_TILDE] = ACTIONS(866),
    [anon_sym_PLUS_PLUS] = ACTIONS(866),
    [anon_sym_DASH_DASH] = ACTIONS(866),
    [anon_sym_new] = ACTIONS(868),
    [anon_sym_class] = ACTIONS(868),
    [anon_sym_SEMI] = ACTIONS(866),
    [anon_sym_LBRACE] = ACTIONS(866),
    [anon_sym_RBRACE] = ACTIONS(866),
    [anon_sym_assert] = ACTIONS(868),
    [anon_sym_switch] = ACTIONS(868),
    [anon_sym_case] = ACTIONS(868),
    [anon_sym_default] = ACTIONS(868),
    [anon_sym_do] = ACTIONS(868),
    [anon_sym_while] = ACTIONS(868),
    [anon_sym_break] = ACTIONS(868),
    [anon_sym_continue] = ACTIONS(868),
    [anon_sym_return] = ACTIONS(868),
    [anon_sym_synchronized] = ACTIONS(868),
    [anon_sym_throw] = ACTIONS(868),
    [anon_sym_try] = ACTIONS(868),
    [anon_sym_if] = ACTIONS(868),
    [anon_sym_else] = ACTIONS(868),
    [anon_sym_for] = ACTIONS(868),
    [anon_sym_AT] = ACTIONS(868),
    [anon_sym_open] = ACTIONS(868),
    [anon_sym_module] = ACTIONS(868),
    [anon_sym_static] = ACTIONS(868),
    [anon_sym_package] = ACTIONS(868),
    [anon_sym_import] = ACTIONS(868),
    [anon_sym_enum] = ACTIONS(868),
    [anon_sym_public] = ACTIONS(868),
    [anon_sym_protected] = ACTIONS(868),
    [anon_sym_private] = ACTIONS(868),
    [anon_sym_abstract] = ACTIONS(868),
    [anon_sym_final] = ACTIONS(868),
    [anon_sym_strictfp] = ACTIONS(868),
    [anon_sym_native] = ACTIONS(868),
    [anon_sym_transient] = ACTIONS(868),
    [anon_sym_volatile] = ACTIONS(868),
    [anon_sym_ATinterface] = ACTIONS(866),
    [anon_sym_interface] = ACTIONS(868),
    [anon_sym_byte] = ACTIONS(868),
    [anon_sym_short] = ACTIONS(868),
    [anon_sym_int] = ACTIONS(868),
    [anon_sym_long] = ACTIONS(868),
    [anon_sym_char] = ACTIONS(868),
    [anon_sym_float] = ACTIONS(868),
    [anon_sym_double] = ACTIONS(868),
    [sym_boolean_type] = ACTIONS(868),
    [sym_void_type] = ACTIONS(868),
    [sym_this] = ACTIONS(868),
    [sym_super] = ACTIONS(868),
    [sym_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(870),
    [sym_identifier] = ACTIONS(872),
    [sym_decimal_integer_literal] = ACTIONS(872),
    [sym_hex_integer_literal] = ACTIONS(872),
    [sym_octal_integer_literal] = ACTIONS(870),
    [sym_binary_integer_literal] = ACTIONS(870),
    [sym_decimal_floating_point_literal] = ACTIONS(870),
    [sym_hex_floating_point_literal] = ACTIONS(872),
    [sym_true] = ACTIONS(872),
    [sym_false] = ACTIONS(872),
    [sym_character_literal] = ACTIONS(870),
    [sym_string_literal] = ACTIONS(870),
    [sym_null_literal] = ACTIONS(872),
    [anon_sym_LPAREN] = ACTIONS(870),
    [anon_sym_PLUS] = ACTIONS(872),
    [anon_sym_DASH] = ACTIONS(872),
    [anon_sym_BANG] = ACTIONS(870),
    [anon_sym_TILDE] = ACTIONS(870),
    [anon_sym_PLUS_PLUS] = ACTIONS(870),
    [anon_sym_DASH_DASH] = ACTIONS(870),
    [anon_sym_new] = ACTIONS(872),
    [anon_sym_class] = ACTIONS(872),
    [anon_sym_SEMI] = ACTIONS(870),
    [anon_sym_LBRACE] = ACTIONS(870),
    [anon_sym_RBRACE] = ACTIONS(870),
    [anon_sym_assert] = ACTIONS(872),
    [anon_sym_switch] = ACTIONS(872),
    [anon_sym_case] = ACTIONS(872),
    [anon_sym_default] = ACTIONS(872),
    [anon_sym_do] = ACTIONS(872),
    [anon_sym_while] = ACTIONS(872),
    [anon_sym_break] = ACTIONS(872),
    [anon_sym_continue] = ACTIONS(872),
    [anon_sym_return] = ACTIONS(872),
    [anon_sym_synchronized] = ACTIONS(872),
    [anon_sym_throw] = ACTIONS(872),
    [anon_sym_try] = ACTIONS(872),
    [anon_sym_if] = ACTIONS(872),
    [anon_sym_else] = ACTIONS(872),
    [anon_sym_for] = ACTIONS(872),
    [anon_sym_AT] = ACTIONS(872),
    [anon_sym_open] = ACTIONS(872),
    [anon_sym_module] = ACTIONS(872),
    [anon_sym_static] = ACTIONS(872),
    [anon_sym_package] = ACTIONS(872),
    [anon_sym_import] = ACTIONS(872),
    [anon_sym_enum] = ACTIONS(872),
    [anon_sym_public] = ACTIONS(872),
    [anon_sym_protected] = ACTIONS(872),
    [anon_sym_private] = ACTIONS(872),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_final] = ACTIONS(872),
    [anon_sym_strictfp] = ACTIONS(872),
    [anon_sym_native] = ACTIONS(872),
    [anon_sym_transient] = ACTIONS(872),
    [anon_sym_volatile] = ACTIONS(872),
    [anon_sym_ATinterface] = ACTIONS(870),
    [anon_sym_interface] = ACTIONS(872),
    [anon_sym_byte] = ACTIONS(872),
    [anon_sym_short] = ACTIONS(872),
    [anon_sym_int] = ACTIONS(872),
    [anon_sym_long] = ACTIONS(872),
    [anon_sym_char] = ACTIONS(872),
    [anon_sym_float] = ACTIONS(872),
    [anon_sym_double] = ACTIONS(872),
    [sym_boolean_type] = ACTIONS(872),
    [sym_void_type] = ACTIONS(872),
    [sym_this] = ACTIONS(872),
    [sym_super] = ACTIONS(872),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(874),
    [sym_identifier] = ACTIONS(876),
    [sym_decimal_integer_literal] = ACTIONS(876),
    [sym_hex_integer_literal] = ACTIONS(876),
    [sym_octal_integer_literal] = ACTIONS(874),
    [sym_binary_integer_literal] = ACTIONS(874),
    [sym_decimal_floating_point_literal] = ACTIONS(874),
    [sym_hex_floating_point_literal] = ACTIONS(876),
    [sym_true] = ACTIONS(876),
    [sym_false] = ACTIONS(876),
    [sym_character_literal] = ACTIONS(874),
    [sym_string_literal] = ACTIONS(874),
    [sym_null_literal] = ACTIONS(876),
    [anon_sym_LPAREN] = ACTIONS(874),
    [anon_sym_PLUS] = ACTIONS(876),
    [anon_sym_DASH] = ACTIONS(876),
    [anon_sym_BANG] = ACTIONS(874),
    [anon_sym_TILDE] = ACTIONS(874),
    [anon_sym_PLUS_PLUS] = ACTIONS(874),
    [anon_sym_DASH_DASH] = ACTIONS(874),
    [anon_sym_new] = ACTIONS(876),
    [anon_sym_class] = ACTIONS(876),
    [anon_sym_SEMI] = ACTIONS(874),
    [anon_sym_LBRACE] = ACTIONS(874),
    [anon_sym_RBRACE] = ACTIONS(874),
    [anon_sym_assert] = ACTIONS(876),
    [anon_sym_switch] = ACTIONS(876),
    [anon_sym_case] = ACTIONS(876),
    [anon_sym_default] = ACTIONS(876),
    [anon_sym_do] = ACTIONS(876),
    [anon_sym_while] = ACTIONS(876),
    [anon_sym_break] = ACTIONS(876),
    [anon_sym_continue] = ACTIONS(876),
    [anon_sym_return] = ACTIONS(876),
    [anon_sym_synchronized] = ACTIONS(876),
    [anon_sym_throw] = ACTIONS(876),
    [anon_sym_try] = ACTIONS(876),
    [anon_sym_if] = ACTIONS(876),
    [anon_sym_else] = ACTIONS(876),
    [anon_sym_for] = ACTIONS(876),
    [anon_sym_AT] = ACTIONS(876),
    [anon_sym_open] = ACTIONS(876),
    [anon_sym_module] = ACTIONS(876),
    [anon_sym_static] = ACTIONS(876),
    [anon_sym_package] = ACTIONS(876),
    [anon_sym_import] = ACTIONS(876),
    [anon_sym_enum] = ACTIONS(876),
    [anon_sym_public] = ACTIONS(876),
    [anon_sym_protected] = ACTIONS(876),
    [anon_sym_private] = ACTIONS(876),
    [anon_sym_abstract] = ACTIONS(876),
    [anon_sym_final] = ACTIONS(876),
    [anon_sym_strictfp] = ACTIONS(876),
    [anon_sym_native] = ACTIONS(876),
    [anon_sym_transient] = ACTIONS(876),
    [anon_sym_volatile] = ACTIONS(876),
    [anon_sym_ATinterface] = ACTIONS(874),
    [anon_sym_interface] = ACTIONS(876),
    [anon_sym_byte] = ACTIONS(876),
    [anon_sym_short] = ACTIONS(876),
    [anon_sym_int] = ACTIONS(876),
    [anon_sym_long] = ACTIONS(876),
    [anon_sym_char] = ACTIONS(876),
    [anon_sym_float] = ACTIONS(876),
    [anon_sym_double] = ACTIONS(876),
    [sym_boolean_type] = ACTIONS(876),
    [sym_void_type] = ACTIONS(876),
    [sym_this] = ACTIONS(876),
    [sym_super] = ACTIONS(876),
    [sym_comment] = ACTIONS(3),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(878),
    [sym_identifier] = ACTIONS(880),
    [sym_decimal_integer_literal] = ACTIONS(880),
    [sym_hex_integer_literal] = ACTIONS(880),
    [sym_octal_integer_literal] = ACTIONS(878),
    [sym_binary_integer_literal] = ACTIONS(878),
    [sym_decimal_floating_point_literal] = ACTIONS(878),
    [sym_hex_floating_point_literal] = ACTIONS(880),
    [sym_true] = ACTIONS(880),
    [sym_false] = ACTIONS(880),
    [sym_character_literal] = ACTIONS(878),
    [sym_string_literal] = ACTIONS(878),
    [sym_null_literal] = ACTIONS(880),
    [anon_sym_LPAREN] = ACTIONS(878),
    [anon_sym_PLUS] = ACTIONS(880),
    [anon_sym_DASH] = ACTIONS(880),
    [anon_sym_BANG] = ACTIONS(878),
    [anon_sym_TILDE] = ACTIONS(878),
    [anon_sym_PLUS_PLUS] = ACTIONS(878),
    [anon_sym_DASH_DASH] = ACTIONS(878),
    [anon_sym_new] = ACTIONS(880),
    [anon_sym_class] = ACTIONS(880),
    [anon_sym_SEMI] = ACTIONS(878),
    [anon_sym_LBRACE] = ACTIONS(878),
    [anon_sym_RBRACE] = ACTIONS(878),
    [anon_sym_assert] = ACTIONS(880),
    [anon_sym_switch] = ACTIONS(880),
    [anon_sym_case] = ACTIONS(880),
    [anon_sym_default] = ACTIONS(880),
    [anon_sym_do] = ACTIONS(880),
    [anon_sym_while] = ACTIONS(880),
    [anon_sym_break] = ACTIONS(880),
    [anon_sym_continue] = ACTIONS(880),
    [anon_sym_return] = ACTIONS(880),
    [anon_sym_synchronized] = ACTIONS(880),
    [anon_sym_throw] = ACTIONS(880),
    [anon_sym_try] = ACTIONS(880),
    [anon_sym_if] = ACTIONS(880),
    [anon_sym_else] = ACTIONS(880),
    [anon_sym_for] = ACTIONS(880),
    [anon_sym_AT] = ACTIONS(880),
    [anon_sym_open] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(880),
    [anon_sym_static] = ACTIONS(880),
    [anon_sym_package] = ACTIONS(880),
    [anon_sym_import] = ACTIONS(880),
    [anon_sym_enum] = ACTIONS(880),
    [anon_sym_public] = ACTIONS(880),
    [anon_sym_protected] = ACTIONS(880),
    [anon_sym_private] = ACTIONS(880),
    [anon_sym_abstract] = ACTIONS(880),
    [anon_sym_final] = ACTIONS(880),
    [anon_sym_strictfp] = ACTIONS(880),
    [anon_sym_native] = ACTIONS(880),
    [anon_sym_transient] = ACTIONS(880),
    [anon_sym_volatile] = ACTIONS(880),
    [anon_sym_ATinterface] = ACTIONS(878),
    [anon_sym_interface] = ACTIONS(880),
    [anon_sym_byte] = ACTIONS(880),
    [anon_sym_short] = ACTIONS(880),
    [anon_sym_int] = ACTIONS(880),
    [anon_sym_long] = ACTIONS(880),
    [anon_sym_char] = ACTIONS(880),
    [anon_sym_float] = ACTIONS(880),
    [anon_sym_double] = ACTIONS(880),
    [sym_boolean_type] = ACTIONS(880),
    [sym_void_type] = ACTIONS(880),
    [sym_this] = ACTIONS(880),
    [sym_super] = ACTIONS(880),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(447),
    [sym_cast_expression] = STATE(447),
    [sym_assignment_expression] = STATE(447),
    [sym_binary_expression] = STATE(447),
    [sym_instanceof_expression] = STATE(447),
    [sym_lambda_expression] = STATE(447),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(447),
    [sym_unary_expression] = STATE(447),
    [sym_update_expression] = STATE(447),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(882),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(884),
    [sym_identifier] = ACTIONS(886),
    [sym_decimal_integer_literal] = ACTIONS(886),
    [sym_hex_integer_literal] = ACTIONS(886),
    [sym_octal_integer_literal] = ACTIONS(884),
    [sym_binary_integer_literal] = ACTIONS(884),
    [sym_decimal_floating_point_literal] = ACTIONS(884),
    [sym_hex_floating_point_literal] = ACTIONS(886),
    [sym_true] = ACTIONS(886),
    [sym_false] = ACTIONS(886),
    [sym_character_literal] = ACTIONS(884),
    [sym_string_literal] = ACTIONS(884),
    [sym_null_literal] = ACTIONS(886),
    [anon_sym_LPAREN] = ACTIONS(884),
    [anon_sym_PLUS] = ACTIONS(886),
    [anon_sym_DASH] = ACTIONS(886),
    [anon_sym_BANG] = ACTIONS(884),
    [anon_sym_TILDE] = ACTIONS(884),
    [anon_sym_PLUS_PLUS] = ACTIONS(884),
    [anon_sym_DASH_DASH] = ACTIONS(884),
    [anon_sym_new] = ACTIONS(886),
    [anon_sym_class] = ACTIONS(886),
    [anon_sym_SEMI] = ACTIONS(884),
    [anon_sym_LBRACE] = ACTIONS(884),
    [anon_sym_RBRACE] = ACTIONS(884),
    [anon_sym_assert] = ACTIONS(886),
    [anon_sym_switch] = ACTIONS(886),
    [anon_sym_case] = ACTIONS(886),
    [anon_sym_default] = ACTIONS(886),
    [anon_sym_do] = ACTIONS(886),
    [anon_sym_while] = ACTIONS(886),
    [anon_sym_break] = ACTIONS(886),
    [anon_sym_continue] = ACTIONS(886),
    [anon_sym_return] = ACTIONS(886),
    [anon_sym_synchronized] = ACTIONS(886),
    [anon_sym_throw] = ACTIONS(886),
    [anon_sym_try] = ACTIONS(886),
    [anon_sym_if] = ACTIONS(886),
    [anon_sym_else] = ACTIONS(886),
    [anon_sym_for] = ACTIONS(886),
    [anon_sym_AT] = ACTIONS(886),
    [anon_sym_open] = ACTIONS(886),
    [anon_sym_module] = ACTIONS(886),
    [anon_sym_static] = ACTIONS(886),
    [anon_sym_package] = ACTIONS(886),
    [anon_sym_import] = ACTIONS(886),
    [anon_sym_enum] = ACTIONS(886),
    [anon_sym_public] = ACTIONS(886),
    [anon_sym_protected] = ACTIONS(886),
    [anon_sym_private] = ACTIONS(886),
    [anon_sym_abstract] = ACTIONS(886),
    [anon_sym_final] = ACTIONS(886),
    [anon_sym_strictfp] = ACTIONS(886),
    [anon_sym_native] = ACTIONS(886),
    [anon_sym_transient] = ACTIONS(886),
    [anon_sym_volatile] = ACTIONS(886),
    [anon_sym_ATinterface] = ACTIONS(884),
    [anon_sym_interface] = ACTIONS(886),
    [anon_sym_byte] = ACTIONS(886),
    [anon_sym_short] = ACTIONS(886),
    [anon_sym_int] = ACTIONS(886),
    [anon_sym_long] = ACTIONS(886),
    [anon_sym_char] = ACTIONS(886),
    [anon_sym_float] = ACTIONS(886),
    [anon_sym_double] = ACTIONS(886),
    [sym_boolean_type] = ACTIONS(886),
    [sym_void_type] = ACTIONS(886),
    [sym_this] = ACTIONS(886),
    [sym_super] = ACTIONS(886),
    [sym_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(888),
    [sym_identifier] = ACTIONS(890),
    [sym_decimal_integer_literal] = ACTIONS(890),
    [sym_hex_integer_literal] = ACTIONS(890),
    [sym_octal_integer_literal] = ACTIONS(888),
    [sym_binary_integer_literal] = ACTIONS(888),
    [sym_decimal_floating_point_literal] = ACTIONS(888),
    [sym_hex_floating_point_literal] = ACTIONS(890),
    [sym_true] = ACTIONS(890),
    [sym_false] = ACTIONS(890),
    [sym_character_literal] = ACTIONS(888),
    [sym_string_literal] = ACTIONS(888),
    [sym_null_literal] = ACTIONS(890),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_PLUS] = ACTIONS(890),
    [anon_sym_DASH] = ACTIONS(890),
    [anon_sym_BANG] = ACTIONS(888),
    [anon_sym_TILDE] = ACTIONS(888),
    [anon_sym_PLUS_PLUS] = ACTIONS(888),
    [anon_sym_DASH_DASH] = ACTIONS(888),
    [anon_sym_new] = ACTIONS(890),
    [anon_sym_class] = ACTIONS(890),
    [anon_sym_SEMI] = ACTIONS(888),
    [anon_sym_LBRACE] = ACTIONS(888),
    [anon_sym_RBRACE] = ACTIONS(888),
    [anon_sym_assert] = ACTIONS(890),
    [anon_sym_switch] = ACTIONS(890),
    [anon_sym_case] = ACTIONS(890),
    [anon_sym_default] = ACTIONS(890),
    [anon_sym_do] = ACTIONS(890),
    [anon_sym_while] = ACTIONS(890),
    [anon_sym_break] = ACTIONS(890),
    [anon_sym_continue] = ACTIONS(890),
    [anon_sym_return] = ACTIONS(890),
    [anon_sym_synchronized] = ACTIONS(890),
    [anon_sym_throw] = ACTIONS(890),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_if] = ACTIONS(890),
    [anon_sym_else] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(890),
    [anon_sym_AT] = ACTIONS(890),
    [anon_sym_open] = ACTIONS(890),
    [anon_sym_module] = ACTIONS(890),
    [anon_sym_static] = ACTIONS(890),
    [anon_sym_package] = ACTIONS(890),
    [anon_sym_import] = ACTIONS(890),
    [anon_sym_enum] = ACTIONS(890),
    [anon_sym_public] = ACTIONS(890),
    [anon_sym_protected] = ACTIONS(890),
    [anon_sym_private] = ACTIONS(890),
    [anon_sym_abstract] = ACTIONS(890),
    [anon_sym_final] = ACTIONS(890),
    [anon_sym_strictfp] = ACTIONS(890),
    [anon_sym_native] = ACTIONS(890),
    [anon_sym_transient] = ACTIONS(890),
    [anon_sym_volatile] = ACTIONS(890),
    [anon_sym_ATinterface] = ACTIONS(888),
    [anon_sym_interface] = ACTIONS(890),
    [anon_sym_byte] = ACTIONS(890),
    [anon_sym_short] = ACTIONS(890),
    [anon_sym_int] = ACTIONS(890),
    [anon_sym_long] = ACTIONS(890),
    [anon_sym_char] = ACTIONS(890),
    [anon_sym_float] = ACTIONS(890),
    [anon_sym_double] = ACTIONS(890),
    [sym_boolean_type] = ACTIONS(890),
    [sym_void_type] = ACTIONS(890),
    [sym_this] = ACTIONS(890),
    [sym_super] = ACTIONS(890),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(892),
    [sym_identifier] = ACTIONS(894),
    [sym_decimal_integer_literal] = ACTIONS(894),
    [sym_hex_integer_literal] = ACTIONS(894),
    [sym_octal_integer_literal] = ACTIONS(892),
    [sym_binary_integer_literal] = ACTIONS(892),
    [sym_decimal_floating_point_literal] = ACTIONS(892),
    [sym_hex_floating_point_literal] = ACTIONS(894),
    [sym_true] = ACTIONS(894),
    [sym_false] = ACTIONS(894),
    [sym_character_literal] = ACTIONS(892),
    [sym_string_literal] = ACTIONS(892),
    [sym_null_literal] = ACTIONS(894),
    [anon_sym_LPAREN] = ACTIONS(892),
    [anon_sym_PLUS] = ACTIONS(894),
    [anon_sym_DASH] = ACTIONS(894),
    [anon_sym_BANG] = ACTIONS(892),
    [anon_sym_TILDE] = ACTIONS(892),
    [anon_sym_PLUS_PLUS] = ACTIONS(892),
    [anon_sym_DASH_DASH] = ACTIONS(892),
    [anon_sym_new] = ACTIONS(894),
    [anon_sym_class] = ACTIONS(894),
    [anon_sym_SEMI] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(892),
    [anon_sym_RBRACE] = ACTIONS(892),
    [anon_sym_assert] = ACTIONS(894),
    [anon_sym_switch] = ACTIONS(894),
    [anon_sym_case] = ACTIONS(894),
    [anon_sym_default] = ACTIONS(894),
    [anon_sym_do] = ACTIONS(894),
    [anon_sym_while] = ACTIONS(894),
    [anon_sym_break] = ACTIONS(894),
    [anon_sym_continue] = ACTIONS(894),
    [anon_sym_return] = ACTIONS(894),
    [anon_sym_synchronized] = ACTIONS(894),
    [anon_sym_throw] = ACTIONS(894),
    [anon_sym_try] = ACTIONS(894),
    [anon_sym_if] = ACTIONS(894),
    [anon_sym_else] = ACTIONS(894),
    [anon_sym_for] = ACTIONS(894),
    [anon_sym_AT] = ACTIONS(894),
    [anon_sym_open] = ACTIONS(894),
    [anon_sym_module] = ACTIONS(894),
    [anon_sym_static] = ACTIONS(894),
    [anon_sym_package] = ACTIONS(894),
    [anon_sym_import] = ACTIONS(894),
    [anon_sym_enum] = ACTIONS(894),
    [anon_sym_public] = ACTIONS(894),
    [anon_sym_protected] = ACTIONS(894),
    [anon_sym_private] = ACTIONS(894),
    [anon_sym_abstract] = ACTIONS(894),
    [anon_sym_final] = ACTIONS(894),
    [anon_sym_strictfp] = ACTIONS(894),
    [anon_sym_native] = ACTIONS(894),
    [anon_sym_transient] = ACTIONS(894),
    [anon_sym_volatile] = ACTIONS(894),
    [anon_sym_ATinterface] = ACTIONS(892),
    [anon_sym_interface] = ACTIONS(894),
    [anon_sym_byte] = ACTIONS(894),
    [anon_sym_short] = ACTIONS(894),
    [anon_sym_int] = ACTIONS(894),
    [anon_sym_long] = ACTIONS(894),
    [anon_sym_char] = ACTIONS(894),
    [anon_sym_float] = ACTIONS(894),
    [anon_sym_double] = ACTIONS(894),
    [sym_boolean_type] = ACTIONS(894),
    [sym_void_type] = ACTIONS(894),
    [sym_this] = ACTIONS(894),
    [sym_super] = ACTIONS(894),
    [sym_comment] = ACTIONS(3),
  },
  [177] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(434),
    [sym_cast_expression] = STATE(434),
    [sym_assignment_expression] = STATE(434),
    [sym_binary_expression] = STATE(434),
    [sym_instanceof_expression] = STATE(434),
    [sym_lambda_expression] = STATE(434),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(434),
    [sym_unary_expression] = STATE(434),
    [sym_update_expression] = STATE(434),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(896),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [178] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(420),
    [sym_cast_expression] = STATE(420),
    [sym_assignment_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_instanceof_expression] = STATE(420),
    [sym_lambda_expression] = STATE(420),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_update_expression] = STATE(420),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(898),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(446),
    [sym_cast_expression] = STATE(446),
    [sym_assignment_expression] = STATE(446),
    [sym_binary_expression] = STATE(446),
    [sym_instanceof_expression] = STATE(446),
    [sym_lambda_expression] = STATE(446),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(446),
    [sym_unary_expression] = STATE(446),
    [sym_update_expression] = STATE(446),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(900),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(902),
    [sym_identifier] = ACTIONS(904),
    [sym_decimal_integer_literal] = ACTIONS(904),
    [sym_hex_integer_literal] = ACTIONS(904),
    [sym_octal_integer_literal] = ACTIONS(902),
    [sym_binary_integer_literal] = ACTIONS(902),
    [sym_decimal_floating_point_literal] = ACTIONS(902),
    [sym_hex_floating_point_literal] = ACTIONS(904),
    [sym_true] = ACTIONS(904),
    [sym_false] = ACTIONS(904),
    [sym_character_literal] = ACTIONS(902),
    [sym_string_literal] = ACTIONS(902),
    [sym_null_literal] = ACTIONS(904),
    [anon_sym_LPAREN] = ACTIONS(902),
    [anon_sym_PLUS] = ACTIONS(904),
    [anon_sym_DASH] = ACTIONS(904),
    [anon_sym_BANG] = ACTIONS(902),
    [anon_sym_TILDE] = ACTIONS(902),
    [anon_sym_PLUS_PLUS] = ACTIONS(902),
    [anon_sym_DASH_DASH] = ACTIONS(902),
    [anon_sym_new] = ACTIONS(904),
    [anon_sym_class] = ACTIONS(904),
    [anon_sym_SEMI] = ACTIONS(902),
    [anon_sym_LBRACE] = ACTIONS(902),
    [anon_sym_RBRACE] = ACTIONS(902),
    [anon_sym_assert] = ACTIONS(904),
    [anon_sym_switch] = ACTIONS(904),
    [anon_sym_case] = ACTIONS(904),
    [anon_sym_default] = ACTIONS(904),
    [anon_sym_do] = ACTIONS(904),
    [anon_sym_while] = ACTIONS(904),
    [anon_sym_break] = ACTIONS(904),
    [anon_sym_continue] = ACTIONS(904),
    [anon_sym_return] = ACTIONS(904),
    [anon_sym_synchronized] = ACTIONS(904),
    [anon_sym_throw] = ACTIONS(904),
    [anon_sym_try] = ACTIONS(904),
    [anon_sym_if] = ACTIONS(904),
    [anon_sym_else] = ACTIONS(906),
    [anon_sym_for] = ACTIONS(904),
    [anon_sym_AT] = ACTIONS(904),
    [anon_sym_open] = ACTIONS(904),
    [anon_sym_module] = ACTIONS(904),
    [anon_sym_static] = ACTIONS(904),
    [anon_sym_package] = ACTIONS(904),
    [anon_sym_import] = ACTIONS(904),
    [anon_sym_enum] = ACTIONS(904),
    [anon_sym_public] = ACTIONS(904),
    [anon_sym_protected] = ACTIONS(904),
    [anon_sym_private] = ACTIONS(904),
    [anon_sym_abstract] = ACTIONS(904),
    [anon_sym_final] = ACTIONS(904),
    [anon_sym_strictfp] = ACTIONS(904),
    [anon_sym_native] = ACTIONS(904),
    [anon_sym_transient] = ACTIONS(904),
    [anon_sym_volatile] = ACTIONS(904),
    [anon_sym_ATinterface] = ACTIONS(902),
    [anon_sym_interface] = ACTIONS(904),
    [anon_sym_byte] = ACTIONS(904),
    [anon_sym_short] = ACTIONS(904),
    [anon_sym_int] = ACTIONS(904),
    [anon_sym_long] = ACTIONS(904),
    [anon_sym_char] = ACTIONS(904),
    [anon_sym_float] = ACTIONS(904),
    [anon_sym_double] = ACTIONS(904),
    [sym_boolean_type] = ACTIONS(904),
    [sym_void_type] = ACTIONS(904),
    [sym_this] = ACTIONS(904),
    [sym_super] = ACTIONS(904),
    [sym_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(461),
    [sym_identifier] = ACTIONS(463),
    [sym_decimal_integer_literal] = ACTIONS(463),
    [sym_hex_integer_literal] = ACTIONS(463),
    [sym_octal_integer_literal] = ACTIONS(461),
    [sym_binary_integer_literal] = ACTIONS(461),
    [sym_decimal_floating_point_literal] = ACTIONS(461),
    [sym_hex_floating_point_literal] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_character_literal] = ACTIONS(461),
    [sym_string_literal] = ACTIONS(461),
    [sym_null_literal] = ACTIONS(463),
    [anon_sym_LPAREN] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(461),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_new] = ACTIONS(463),
    [anon_sym_class] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(461),
    [anon_sym_LBRACE] = ACTIONS(461),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_assert] = ACTIONS(463),
    [anon_sym_switch] = ACTIONS(463),
    [anon_sym_case] = ACTIONS(463),
    [anon_sym_default] = ACTIONS(463),
    [anon_sym_do] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_break] = ACTIONS(463),
    [anon_sym_continue] = ACTIONS(463),
    [anon_sym_return] = ACTIONS(463),
    [anon_sym_synchronized] = ACTIONS(463),
    [anon_sym_throw] = ACTIONS(463),
    [anon_sym_try] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_else] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(463),
    [anon_sym_open] = ACTIONS(463),
    [anon_sym_module] = ACTIONS(463),
    [anon_sym_static] = ACTIONS(463),
    [anon_sym_package] = ACTIONS(463),
    [anon_sym_import] = ACTIONS(463),
    [anon_sym_enum] = ACTIONS(463),
    [anon_sym_public] = ACTIONS(463),
    [anon_sym_protected] = ACTIONS(463),
    [anon_sym_private] = ACTIONS(463),
    [anon_sym_abstract] = ACTIONS(463),
    [anon_sym_final] = ACTIONS(463),
    [anon_sym_strictfp] = ACTIONS(463),
    [anon_sym_native] = ACTIONS(463),
    [anon_sym_transient] = ACTIONS(463),
    [anon_sym_volatile] = ACTIONS(463),
    [anon_sym_ATinterface] = ACTIONS(461),
    [anon_sym_interface] = ACTIONS(463),
    [anon_sym_byte] = ACTIONS(463),
    [anon_sym_short] = ACTIONS(463),
    [anon_sym_int] = ACTIONS(463),
    [anon_sym_long] = ACTIONS(463),
    [anon_sym_char] = ACTIONS(463),
    [anon_sym_float] = ACTIONS(463),
    [anon_sym_double] = ACTIONS(463),
    [sym_boolean_type] = ACTIONS(463),
    [sym_void_type] = ACTIONS(463),
    [sym_this] = ACTIONS(463),
    [sym_super] = ACTIONS(463),
    [sym_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(908),
    [sym_identifier] = ACTIONS(910),
    [sym_decimal_integer_literal] = ACTIONS(910),
    [sym_hex_integer_literal] = ACTIONS(910),
    [sym_octal_integer_literal] = ACTIONS(908),
    [sym_binary_integer_literal] = ACTIONS(908),
    [sym_decimal_floating_point_literal] = ACTIONS(908),
    [sym_hex_floating_point_literal] = ACTIONS(910),
    [sym_true] = ACTIONS(910),
    [sym_false] = ACTIONS(910),
    [sym_character_literal] = ACTIONS(908),
    [sym_string_literal] = ACTIONS(908),
    [sym_null_literal] = ACTIONS(910),
    [anon_sym_LPAREN] = ACTIONS(908),
    [anon_sym_PLUS] = ACTIONS(910),
    [anon_sym_DASH] = ACTIONS(910),
    [anon_sym_BANG] = ACTIONS(908),
    [anon_sym_TILDE] = ACTIONS(908),
    [anon_sym_PLUS_PLUS] = ACTIONS(908),
    [anon_sym_DASH_DASH] = ACTIONS(908),
    [anon_sym_new] = ACTIONS(910),
    [anon_sym_class] = ACTIONS(910),
    [anon_sym_SEMI] = ACTIONS(908),
    [anon_sym_LBRACE] = ACTIONS(908),
    [anon_sym_RBRACE] = ACTIONS(908),
    [anon_sym_assert] = ACTIONS(910),
    [anon_sym_switch] = ACTIONS(910),
    [anon_sym_case] = ACTIONS(910),
    [anon_sym_default] = ACTIONS(910),
    [anon_sym_do] = ACTIONS(910),
    [anon_sym_while] = ACTIONS(910),
    [anon_sym_break] = ACTIONS(910),
    [anon_sym_continue] = ACTIONS(910),
    [anon_sym_return] = ACTIONS(910),
    [anon_sym_synchronized] = ACTIONS(910),
    [anon_sym_throw] = ACTIONS(910),
    [anon_sym_try] = ACTIONS(910),
    [anon_sym_if] = ACTIONS(910),
    [anon_sym_else] = ACTIONS(910),
    [anon_sym_for] = ACTIONS(910),
    [anon_sym_AT] = ACTIONS(910),
    [anon_sym_open] = ACTIONS(910),
    [anon_sym_module] = ACTIONS(910),
    [anon_sym_static] = ACTIONS(910),
    [anon_sym_package] = ACTIONS(910),
    [anon_sym_import] = ACTIONS(910),
    [anon_sym_enum] = ACTIONS(910),
    [anon_sym_public] = ACTIONS(910),
    [anon_sym_protected] = ACTIONS(910),
    [anon_sym_private] = ACTIONS(910),
    [anon_sym_abstract] = ACTIONS(910),
    [anon_sym_final] = ACTIONS(910),
    [anon_sym_strictfp] = ACTIONS(910),
    [anon_sym_native] = ACTIONS(910),
    [anon_sym_transient] = ACTIONS(910),
    [anon_sym_volatile] = ACTIONS(910),
    [anon_sym_ATinterface] = ACTIONS(908),
    [anon_sym_interface] = ACTIONS(910),
    [anon_sym_byte] = ACTIONS(910),
    [anon_sym_short] = ACTIONS(910),
    [anon_sym_int] = ACTIONS(910),
    [anon_sym_long] = ACTIONS(910),
    [anon_sym_char] = ACTIONS(910),
    [anon_sym_float] = ACTIONS(910),
    [anon_sym_double] = ACTIONS(910),
    [sym_boolean_type] = ACTIONS(910),
    [sym_void_type] = ACTIONS(910),
    [sym_this] = ACTIONS(910),
    [sym_super] = ACTIONS(910),
    [sym_comment] = ACTIONS(3),
  },
  [183] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(456),
    [sym_cast_expression] = STATE(456),
    [sym_assignment_expression] = STATE(456),
    [sym_binary_expression] = STATE(456),
    [sym_instanceof_expression] = STATE(456),
    [sym_lambda_expression] = STATE(456),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(456),
    [sym_unary_expression] = STATE(456),
    [sym_update_expression] = STATE(456),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(912),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [184] = {
    [ts_builtin_sym_end] = ACTIONS(453),
    [sym_identifier] = ACTIONS(455),
    [sym_decimal_integer_literal] = ACTIONS(455),
    [sym_hex_integer_literal] = ACTIONS(455),
    [sym_octal_integer_literal] = ACTIONS(453),
    [sym_binary_integer_literal] = ACTIONS(453),
    [sym_decimal_floating_point_literal] = ACTIONS(453),
    [sym_hex_floating_point_literal] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_character_literal] = ACTIONS(453),
    [sym_string_literal] = ACTIONS(453),
    [sym_null_literal] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(455),
    [anon_sym_DASH] = ACTIONS(455),
    [anon_sym_BANG] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_PLUS_PLUS] = ACTIONS(453),
    [anon_sym_DASH_DASH] = ACTIONS(453),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_class] = ACTIONS(455),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_LBRACE] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(453),
    [anon_sym_assert] = ACTIONS(455),
    [anon_sym_switch] = ACTIONS(455),
    [anon_sym_case] = ACTIONS(455),
    [anon_sym_default] = ACTIONS(455),
    [anon_sym_do] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_break] = ACTIONS(455),
    [anon_sym_continue] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(455),
    [anon_sym_synchronized] = ACTIONS(455),
    [anon_sym_throw] = ACTIONS(455),
    [anon_sym_try] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_else] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_AT] = ACTIONS(455),
    [anon_sym_open] = ACTIONS(455),
    [anon_sym_module] = ACTIONS(455),
    [anon_sym_static] = ACTIONS(455),
    [anon_sym_package] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(455),
    [anon_sym_enum] = ACTIONS(455),
    [anon_sym_public] = ACTIONS(455),
    [anon_sym_protected] = ACTIONS(455),
    [anon_sym_private] = ACTIONS(455),
    [anon_sym_abstract] = ACTIONS(455),
    [anon_sym_final] = ACTIONS(455),
    [anon_sym_strictfp] = ACTIONS(455),
    [anon_sym_native] = ACTIONS(455),
    [anon_sym_transient] = ACTIONS(455),
    [anon_sym_volatile] = ACTIONS(455),
    [anon_sym_ATinterface] = ACTIONS(453),
    [anon_sym_interface] = ACTIONS(455),
    [anon_sym_byte] = ACTIONS(455),
    [anon_sym_short] = ACTIONS(455),
    [anon_sym_int] = ACTIONS(455),
    [anon_sym_long] = ACTIONS(455),
    [anon_sym_char] = ACTIONS(455),
    [anon_sym_float] = ACTIONS(455),
    [anon_sym_double] = ACTIONS(455),
    [sym_boolean_type] = ACTIONS(455),
    [sym_void_type] = ACTIONS(455),
    [sym_this] = ACTIONS(455),
    [sym_super] = ACTIONS(455),
    [sym_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(914),
    [sym_identifier] = ACTIONS(916),
    [sym_decimal_integer_literal] = ACTIONS(916),
    [sym_hex_integer_literal] = ACTIONS(916),
    [sym_octal_integer_literal] = ACTIONS(914),
    [sym_binary_integer_literal] = ACTIONS(914),
    [sym_decimal_floating_point_literal] = ACTIONS(914),
    [sym_hex_floating_point_literal] = ACTIONS(916),
    [sym_true] = ACTIONS(916),
    [sym_false] = ACTIONS(916),
    [sym_character_literal] = ACTIONS(914),
    [sym_string_literal] = ACTIONS(914),
    [sym_null_literal] = ACTIONS(916),
    [anon_sym_LPAREN] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(916),
    [anon_sym_DASH] = ACTIONS(916),
    [anon_sym_BANG] = ACTIONS(914),
    [anon_sym_TILDE] = ACTIONS(914),
    [anon_sym_PLUS_PLUS] = ACTIONS(914),
    [anon_sym_DASH_DASH] = ACTIONS(914),
    [anon_sym_new] = ACTIONS(916),
    [anon_sym_class] = ACTIONS(916),
    [anon_sym_SEMI] = ACTIONS(914),
    [anon_sym_LBRACE] = ACTIONS(914),
    [anon_sym_RBRACE] = ACTIONS(914),
    [anon_sym_assert] = ACTIONS(916),
    [anon_sym_switch] = ACTIONS(916),
    [anon_sym_case] = ACTIONS(916),
    [anon_sym_default] = ACTIONS(916),
    [anon_sym_do] = ACTIONS(916),
    [anon_sym_while] = ACTIONS(916),
    [anon_sym_break] = ACTIONS(916),
    [anon_sym_continue] = ACTIONS(916),
    [anon_sym_return] = ACTIONS(916),
    [anon_sym_synchronized] = ACTIONS(916),
    [anon_sym_throw] = ACTIONS(916),
    [anon_sym_try] = ACTIONS(916),
    [anon_sym_if] = ACTIONS(916),
    [anon_sym_else] = ACTIONS(916),
    [anon_sym_for] = ACTIONS(916),
    [anon_sym_AT] = ACTIONS(916),
    [anon_sym_open] = ACTIONS(916),
    [anon_sym_module] = ACTIONS(916),
    [anon_sym_static] = ACTIONS(916),
    [anon_sym_package] = ACTIONS(916),
    [anon_sym_import] = ACTIONS(916),
    [anon_sym_enum] = ACTIONS(916),
    [anon_sym_public] = ACTIONS(916),
    [anon_sym_protected] = ACTIONS(916),
    [anon_sym_private] = ACTIONS(916),
    [anon_sym_abstract] = ACTIONS(916),
    [anon_sym_final] = ACTIONS(916),
    [anon_sym_strictfp] = ACTIONS(916),
    [anon_sym_native] = ACTIONS(916),
    [anon_sym_transient] = ACTIONS(916),
    [anon_sym_volatile] = ACTIONS(916),
    [anon_sym_ATinterface] = ACTIONS(914),
    [anon_sym_interface] = ACTIONS(916),
    [anon_sym_byte] = ACTIONS(916),
    [anon_sym_short] = ACTIONS(916),
    [anon_sym_int] = ACTIONS(916),
    [anon_sym_long] = ACTIONS(916),
    [anon_sym_char] = ACTIONS(916),
    [anon_sym_float] = ACTIONS(916),
    [anon_sym_double] = ACTIONS(916),
    [sym_boolean_type] = ACTIONS(916),
    [sym_void_type] = ACTIONS(916),
    [sym_this] = ACTIONS(916),
    [sym_super] = ACTIONS(916),
    [sym_comment] = ACTIONS(3),
  },
  [186] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(421),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(918),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(920),
    [sym_identifier] = ACTIONS(922),
    [sym_decimal_integer_literal] = ACTIONS(922),
    [sym_hex_integer_literal] = ACTIONS(922),
    [sym_octal_integer_literal] = ACTIONS(920),
    [sym_binary_integer_literal] = ACTIONS(920),
    [sym_decimal_floating_point_literal] = ACTIONS(920),
    [sym_hex_floating_point_literal] = ACTIONS(922),
    [sym_true] = ACTIONS(922),
    [sym_false] = ACTIONS(922),
    [sym_character_literal] = ACTIONS(920),
    [sym_string_literal] = ACTIONS(920),
    [sym_null_literal] = ACTIONS(922),
    [anon_sym_LPAREN] = ACTIONS(920),
    [anon_sym_PLUS] = ACTIONS(922),
    [anon_sym_DASH] = ACTIONS(922),
    [anon_sym_BANG] = ACTIONS(920),
    [anon_sym_TILDE] = ACTIONS(920),
    [anon_sym_PLUS_PLUS] = ACTIONS(920),
    [anon_sym_DASH_DASH] = ACTIONS(920),
    [anon_sym_new] = ACTIONS(922),
    [anon_sym_class] = ACTIONS(922),
    [anon_sym_SEMI] = ACTIONS(920),
    [anon_sym_LBRACE] = ACTIONS(920),
    [anon_sym_RBRACE] = ACTIONS(920),
    [anon_sym_assert] = ACTIONS(922),
    [anon_sym_switch] = ACTIONS(922),
    [anon_sym_case] = ACTIONS(922),
    [anon_sym_default] = ACTIONS(922),
    [anon_sym_do] = ACTIONS(922),
    [anon_sym_while] = ACTIONS(922),
    [anon_sym_break] = ACTIONS(922),
    [anon_sym_continue] = ACTIONS(922),
    [anon_sym_return] = ACTIONS(922),
    [anon_sym_synchronized] = ACTIONS(922),
    [anon_sym_throw] = ACTIONS(922),
    [anon_sym_try] = ACTIONS(922),
    [anon_sym_if] = ACTIONS(922),
    [anon_sym_else] = ACTIONS(922),
    [anon_sym_for] = ACTIONS(922),
    [anon_sym_AT] = ACTIONS(922),
    [anon_sym_open] = ACTIONS(922),
    [anon_sym_module] = ACTIONS(922),
    [anon_sym_static] = ACTIONS(922),
    [anon_sym_package] = ACTIONS(922),
    [anon_sym_import] = ACTIONS(922),
    [anon_sym_enum] = ACTIONS(922),
    [anon_sym_public] = ACTIONS(922),
    [anon_sym_protected] = ACTIONS(922),
    [anon_sym_private] = ACTIONS(922),
    [anon_sym_abstract] = ACTIONS(922),
    [anon_sym_final] = ACTIONS(922),
    [anon_sym_strictfp] = ACTIONS(922),
    [anon_sym_native] = ACTIONS(922),
    [anon_sym_transient] = ACTIONS(922),
    [anon_sym_volatile] = ACTIONS(922),
    [anon_sym_ATinterface] = ACTIONS(920),
    [anon_sym_interface] = ACTIONS(922),
    [anon_sym_byte] = ACTIONS(922),
    [anon_sym_short] = ACTIONS(922),
    [anon_sym_int] = ACTIONS(922),
    [anon_sym_long] = ACTIONS(922),
    [anon_sym_char] = ACTIONS(922),
    [anon_sym_float] = ACTIONS(922),
    [anon_sym_double] = ACTIONS(922),
    [sym_boolean_type] = ACTIONS(922),
    [sym_void_type] = ACTIONS(922),
    [sym_this] = ACTIONS(922),
    [sym_super] = ACTIONS(922),
    [sym_comment] = ACTIONS(3),
  },
  [188] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(410),
    [sym_cast_expression] = STATE(410),
    [sym_assignment_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_instanceof_expression] = STATE(410),
    [sym_lambda_expression] = STATE(410),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_update_expression] = STATE(410),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(924),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(926),
    [sym_identifier] = ACTIONS(928),
    [sym_decimal_integer_literal] = ACTIONS(928),
    [sym_hex_integer_literal] = ACTIONS(928),
    [sym_octal_integer_literal] = ACTIONS(926),
    [sym_binary_integer_literal] = ACTIONS(926),
    [sym_decimal_floating_point_literal] = ACTIONS(926),
    [sym_hex_floating_point_literal] = ACTIONS(928),
    [sym_true] = ACTIONS(928),
    [sym_false] = ACTIONS(928),
    [sym_character_literal] = ACTIONS(926),
    [sym_string_literal] = ACTIONS(926),
    [sym_null_literal] = ACTIONS(928),
    [anon_sym_LPAREN] = ACTIONS(926),
    [anon_sym_PLUS] = ACTIONS(928),
    [anon_sym_DASH] = ACTIONS(928),
    [anon_sym_BANG] = ACTIONS(926),
    [anon_sym_TILDE] = ACTIONS(926),
    [anon_sym_PLUS_PLUS] = ACTIONS(926),
    [anon_sym_DASH_DASH] = ACTIONS(926),
    [anon_sym_new] = ACTIONS(928),
    [anon_sym_class] = ACTIONS(928),
    [anon_sym_SEMI] = ACTIONS(926),
    [anon_sym_LBRACE] = ACTIONS(926),
    [anon_sym_RBRACE] = ACTIONS(926),
    [anon_sym_assert] = ACTIONS(928),
    [anon_sym_switch] = ACTIONS(928),
    [anon_sym_case] = ACTIONS(928),
    [anon_sym_default] = ACTIONS(928),
    [anon_sym_do] = ACTIONS(928),
    [anon_sym_while] = ACTIONS(928),
    [anon_sym_break] = ACTIONS(928),
    [anon_sym_continue] = ACTIONS(928),
    [anon_sym_return] = ACTIONS(928),
    [anon_sym_synchronized] = ACTIONS(928),
    [anon_sym_throw] = ACTIONS(928),
    [anon_sym_try] = ACTIONS(928),
    [anon_sym_if] = ACTIONS(928),
    [anon_sym_else] = ACTIONS(928),
    [anon_sym_for] = ACTIONS(928),
    [anon_sym_AT] = ACTIONS(928),
    [anon_sym_open] = ACTIONS(928),
    [anon_sym_module] = ACTIONS(928),
    [anon_sym_static] = ACTIONS(928),
    [anon_sym_package] = ACTIONS(928),
    [anon_sym_import] = ACTIONS(928),
    [anon_sym_enum] = ACTIONS(928),
    [anon_sym_public] = ACTIONS(928),
    [anon_sym_protected] = ACTIONS(928),
    [anon_sym_private] = ACTIONS(928),
    [anon_sym_abstract] = ACTIONS(928),
    [anon_sym_final] = ACTIONS(928),
    [anon_sym_strictfp] = ACTIONS(928),
    [anon_sym_native] = ACTIONS(928),
    [anon_sym_transient] = ACTIONS(928),
    [anon_sym_volatile] = ACTIONS(928),
    [anon_sym_ATinterface] = ACTIONS(926),
    [anon_sym_interface] = ACTIONS(928),
    [anon_sym_byte] = ACTIONS(928),
    [anon_sym_short] = ACTIONS(928),
    [anon_sym_int] = ACTIONS(928),
    [anon_sym_long] = ACTIONS(928),
    [anon_sym_char] = ACTIONS(928),
    [anon_sym_float] = ACTIONS(928),
    [anon_sym_double] = ACTIONS(928),
    [sym_boolean_type] = ACTIONS(928),
    [sym_void_type] = ACTIONS(928),
    [sym_this] = ACTIONS(928),
    [sym_super] = ACTIONS(928),
    [sym_comment] = ACTIONS(3),
  },
  [190] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(418),
    [sym_cast_expression] = STATE(418),
    [sym_assignment_expression] = STATE(418),
    [sym_binary_expression] = STATE(418),
    [sym_instanceof_expression] = STATE(418),
    [sym_lambda_expression] = STATE(418),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(418),
    [sym_unary_expression] = STATE(418),
    [sym_update_expression] = STATE(418),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(930),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [ts_builtin_sym_end] = ACTIONS(932),
    [sym_identifier] = ACTIONS(934),
    [sym_decimal_integer_literal] = ACTIONS(934),
    [sym_hex_integer_literal] = ACTIONS(934),
    [sym_octal_integer_literal] = ACTIONS(932),
    [sym_binary_integer_literal] = ACTIONS(932),
    [sym_decimal_floating_point_literal] = ACTIONS(932),
    [sym_hex_floating_point_literal] = ACTIONS(934),
    [sym_true] = ACTIONS(934),
    [sym_false] = ACTIONS(934),
    [sym_character_literal] = ACTIONS(932),
    [sym_string_literal] = ACTIONS(932),
    [sym_null_literal] = ACTIONS(934),
    [anon_sym_LPAREN] = ACTIONS(932),
    [anon_sym_PLUS] = ACTIONS(934),
    [anon_sym_DASH] = ACTIONS(934),
    [anon_sym_BANG] = ACTIONS(932),
    [anon_sym_TILDE] = ACTIONS(932),
    [anon_sym_PLUS_PLUS] = ACTIONS(932),
    [anon_sym_DASH_DASH] = ACTIONS(932),
    [anon_sym_new] = ACTIONS(934),
    [anon_sym_class] = ACTIONS(934),
    [anon_sym_SEMI] = ACTIONS(932),
    [anon_sym_LBRACE] = ACTIONS(932),
    [anon_sym_RBRACE] = ACTIONS(932),
    [anon_sym_assert] = ACTIONS(934),
    [anon_sym_switch] = ACTIONS(934),
    [anon_sym_case] = ACTIONS(934),
    [anon_sym_default] = ACTIONS(934),
    [anon_sym_do] = ACTIONS(934),
    [anon_sym_while] = ACTIONS(934),
    [anon_sym_break] = ACTIONS(934),
    [anon_sym_continue] = ACTIONS(934),
    [anon_sym_return] = ACTIONS(934),
    [anon_sym_synchronized] = ACTIONS(934),
    [anon_sym_throw] = ACTIONS(934),
    [anon_sym_try] = ACTIONS(934),
    [anon_sym_if] = ACTIONS(934),
    [anon_sym_else] = ACTIONS(934),
    [anon_sym_for] = ACTIONS(934),
    [anon_sym_AT] = ACTIONS(934),
    [anon_sym_open] = ACTIONS(934),
    [anon_sym_module] = ACTIONS(934),
    [anon_sym_static] = ACTIONS(934),
    [anon_sym_package] = ACTIONS(934),
    [anon_sym_import] = ACTIONS(934),
    [anon_sym_enum] = ACTIONS(934),
    [anon_sym_public] = ACTIONS(934),
    [anon_sym_protected] = ACTIONS(934),
    [anon_sym_private] = ACTIONS(934),
    [anon_sym_abstract] = ACTIONS(934),
    [anon_sym_final] = ACTIONS(934),
    [anon_sym_strictfp] = ACTIONS(934),
    [anon_sym_native] = ACTIONS(934),
    [anon_sym_transient] = ACTIONS(934),
    [anon_sym_volatile] = ACTIONS(934),
    [anon_sym_ATinterface] = ACTIONS(932),
    [anon_sym_interface] = ACTIONS(934),
    [anon_sym_byte] = ACTIONS(934),
    [anon_sym_short] = ACTIONS(934),
    [anon_sym_int] = ACTIONS(934),
    [anon_sym_long] = ACTIONS(934),
    [anon_sym_char] = ACTIONS(934),
    [anon_sym_float] = ACTIONS(934),
    [anon_sym_double] = ACTIONS(934),
    [sym_boolean_type] = ACTIONS(934),
    [sym_void_type] = ACTIONS(934),
    [sym_this] = ACTIONS(934),
    [sym_super] = ACTIONS(934),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [ts_builtin_sym_end] = ACTIONS(936),
    [sym_identifier] = ACTIONS(938),
    [sym_decimal_integer_literal] = ACTIONS(938),
    [sym_hex_integer_literal] = ACTIONS(938),
    [sym_octal_integer_literal] = ACTIONS(936),
    [sym_binary_integer_literal] = ACTIONS(936),
    [sym_decimal_floating_point_literal] = ACTIONS(936),
    [sym_hex_floating_point_literal] = ACTIONS(938),
    [sym_true] = ACTIONS(938),
    [sym_false] = ACTIONS(938),
    [sym_character_literal] = ACTIONS(936),
    [sym_string_literal] = ACTIONS(936),
    [sym_null_literal] = ACTIONS(938),
    [anon_sym_LPAREN] = ACTIONS(936),
    [anon_sym_PLUS] = ACTIONS(938),
    [anon_sym_DASH] = ACTIONS(938),
    [anon_sym_BANG] = ACTIONS(936),
    [anon_sym_TILDE] = ACTIONS(936),
    [anon_sym_PLUS_PLUS] = ACTIONS(936),
    [anon_sym_DASH_DASH] = ACTIONS(936),
    [anon_sym_new] = ACTIONS(938),
    [anon_sym_class] = ACTIONS(938),
    [anon_sym_SEMI] = ACTIONS(936),
    [anon_sym_LBRACE] = ACTIONS(936),
    [anon_sym_RBRACE] = ACTIONS(936),
    [anon_sym_assert] = ACTIONS(938),
    [anon_sym_switch] = ACTIONS(938),
    [anon_sym_case] = ACTIONS(938),
    [anon_sym_default] = ACTIONS(938),
    [anon_sym_do] = ACTIONS(938),
    [anon_sym_while] = ACTIONS(938),
    [anon_sym_break] = ACTIONS(938),
    [anon_sym_continue] = ACTIONS(938),
    [anon_sym_return] = ACTIONS(938),
    [anon_sym_synchronized] = ACTIONS(938),
    [anon_sym_throw] = ACTIONS(938),
    [anon_sym_try] = ACTIONS(938),
    [anon_sym_if] = ACTIONS(938),
    [anon_sym_else] = ACTIONS(938),
    [anon_sym_for] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(938),
    [anon_sym_open] = ACTIONS(938),
    [anon_sym_module] = ACTIONS(938),
    [anon_sym_static] = ACTIONS(938),
    [anon_sym_package] = ACTIONS(938),
    [anon_sym_import] = ACTIONS(938),
    [anon_sym_enum] = ACTIONS(938),
    [anon_sym_public] = ACTIONS(938),
    [anon_sym_protected] = ACTIONS(938),
    [anon_sym_private] = ACTIONS(938),
    [anon_sym_abstract] = ACTIONS(938),
    [anon_sym_final] = ACTIONS(938),
    [anon_sym_strictfp] = ACTIONS(938),
    [anon_sym_native] = ACTIONS(938),
    [anon_sym_transient] = ACTIONS(938),
    [anon_sym_volatile] = ACTIONS(938),
    [anon_sym_ATinterface] = ACTIONS(936),
    [anon_sym_interface] = ACTIONS(938),
    [anon_sym_byte] = ACTIONS(938),
    [anon_sym_short] = ACTIONS(938),
    [anon_sym_int] = ACTIONS(938),
    [anon_sym_long] = ACTIONS(938),
    [anon_sym_char] = ACTIONS(938),
    [anon_sym_float] = ACTIONS(938),
    [anon_sym_double] = ACTIONS(938),
    [sym_boolean_type] = ACTIONS(938),
    [sym_void_type] = ACTIONS(938),
    [sym_this] = ACTIONS(938),
    [sym_super] = ACTIONS(938),
    [sym_comment] = ACTIONS(3),
  },
  [193] = {
    [ts_builtin_sym_end] = ACTIONS(940),
    [sym_identifier] = ACTIONS(942),
    [sym_decimal_integer_literal] = ACTIONS(942),
    [sym_hex_integer_literal] = ACTIONS(942),
    [sym_octal_integer_literal] = ACTIONS(940),
    [sym_binary_integer_literal] = ACTIONS(940),
    [sym_decimal_floating_point_literal] = ACTIONS(940),
    [sym_hex_floating_point_literal] = ACTIONS(942),
    [sym_true] = ACTIONS(942),
    [sym_false] = ACTIONS(942),
    [sym_character_literal] = ACTIONS(940),
    [sym_string_literal] = ACTIONS(940),
    [sym_null_literal] = ACTIONS(942),
    [anon_sym_LPAREN] = ACTIONS(940),
    [anon_sym_PLUS] = ACTIONS(942),
    [anon_sym_DASH] = ACTIONS(942),
    [anon_sym_BANG] = ACTIONS(940),
    [anon_sym_TILDE] = ACTIONS(940),
    [anon_sym_PLUS_PLUS] = ACTIONS(940),
    [anon_sym_DASH_DASH] = ACTIONS(940),
    [anon_sym_new] = ACTIONS(942),
    [anon_sym_class] = ACTIONS(942),
    [anon_sym_SEMI] = ACTIONS(940),
    [anon_sym_LBRACE] = ACTIONS(940),
    [anon_sym_RBRACE] = ACTIONS(940),
    [anon_sym_assert] = ACTIONS(942),
    [anon_sym_switch] = ACTIONS(942),
    [anon_sym_case] = ACTIONS(942),
    [anon_sym_default] = ACTIONS(942),
    [anon_sym_do] = ACTIONS(942),
    [anon_sym_while] = ACTIONS(942),
    [anon_sym_break] = ACTIONS(942),
    [anon_sym_continue] = ACTIONS(942),
    [anon_sym_return] = ACTIONS(942),
    [anon_sym_synchronized] = ACTIONS(942),
    [anon_sym_throw] = ACTIONS(942),
    [anon_sym_try] = ACTIONS(942),
    [anon_sym_if] = ACTIONS(942),
    [anon_sym_else] = ACTIONS(942),
    [anon_sym_for] = ACTIONS(942),
    [anon_sym_AT] = ACTIONS(942),
    [anon_sym_open] = ACTIONS(942),
    [anon_sym_module] = ACTIONS(942),
    [anon_sym_static] = ACTIONS(942),
    [anon_sym_package] = ACTIONS(942),
    [anon_sym_import] = ACTIONS(942),
    [anon_sym_enum] = ACTIONS(942),
    [anon_sym_public] = ACTIONS(942),
    [anon_sym_protected] = ACTIONS(942),
    [anon_sym_private] = ACTIONS(942),
    [anon_sym_abstract] = ACTIONS(942),
    [anon_sym_final] = ACTIONS(942),
    [anon_sym_strictfp] = ACTIONS(942),
    [anon_sym_native] = ACTIONS(942),
    [anon_sym_transient] = ACTIONS(942),
    [anon_sym_volatile] = ACTIONS(942),
    [anon_sym_ATinterface] = ACTIONS(940),
    [anon_sym_interface] = ACTIONS(942),
    [anon_sym_byte] = ACTIONS(942),
    [anon_sym_short] = ACTIONS(942),
    [anon_sym_int] = ACTIONS(942),
    [anon_sym_long] = ACTIONS(942),
    [anon_sym_char] = ACTIONS(942),
    [anon_sym_float] = ACTIONS(942),
    [anon_sym_double] = ACTIONS(942),
    [sym_boolean_type] = ACTIONS(942),
    [sym_void_type] = ACTIONS(942),
    [sym_this] = ACTIONS(942),
    [sym_super] = ACTIONS(942),
    [sym_comment] = ACTIONS(3),
  },
  [194] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(435),
    [sym_cast_expression] = STATE(435),
    [sym_assignment_expression] = STATE(435),
    [sym_binary_expression] = STATE(435),
    [sym_instanceof_expression] = STATE(435),
    [sym_lambda_expression] = STATE(435),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(435),
    [sym_unary_expression] = STATE(435),
    [sym_update_expression] = STATE(435),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_SEMI] = ACTIONS(944),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [195] = {
    [ts_builtin_sym_end] = ACTIONS(946),
    [sym_identifier] = ACTIONS(948),
    [sym_decimal_integer_literal] = ACTIONS(948),
    [sym_hex_integer_literal] = ACTIONS(948),
    [sym_octal_integer_literal] = ACTIONS(946),
    [sym_binary_integer_literal] = ACTIONS(946),
    [sym_decimal_floating_point_literal] = ACTIONS(946),
    [sym_hex_floating_point_literal] = ACTIONS(948),
    [sym_true] = ACTIONS(948),
    [sym_false] = ACTIONS(948),
    [sym_character_literal] = ACTIONS(946),
    [sym_string_literal] = ACTIONS(946),
    [sym_null_literal] = ACTIONS(948),
    [anon_sym_LPAREN] = ACTIONS(946),
    [anon_sym_PLUS] = ACTIONS(948),
    [anon_sym_DASH] = ACTIONS(948),
    [anon_sym_BANG] = ACTIONS(946),
    [anon_sym_TILDE] = ACTIONS(946),
    [anon_sym_PLUS_PLUS] = ACTIONS(946),
    [anon_sym_DASH_DASH] = ACTIONS(946),
    [anon_sym_new] = ACTIONS(948),
    [anon_sym_class] = ACTIONS(948),
    [anon_sym_SEMI] = ACTIONS(946),
    [anon_sym_LBRACE] = ACTIONS(946),
    [anon_sym_RBRACE] = ACTIONS(946),
    [anon_sym_assert] = ACTIONS(948),
    [anon_sym_switch] = ACTIONS(948),
    [anon_sym_case] = ACTIONS(948),
    [anon_sym_default] = ACTIONS(948),
    [anon_sym_do] = ACTIONS(948),
    [anon_sym_while] = ACTIONS(948),
    [anon_sym_break] = ACTIONS(948),
    [anon_sym_continue] = ACTIONS(948),
    [anon_sym_return] = ACTIONS(948),
    [anon_sym_synchronized] = ACTIONS(948),
    [anon_sym_throw] = ACTIONS(948),
    [anon_sym_try] = ACTIONS(948),
    [anon_sym_if] = ACTIONS(948),
    [anon_sym_else] = ACTIONS(948),
    [anon_sym_for] = ACTIONS(948),
    [anon_sym_AT] = ACTIONS(948),
    [anon_sym_open] = ACTIONS(948),
    [anon_sym_module] = ACTIONS(948),
    [anon_sym_static] = ACTIONS(948),
    [anon_sym_package] = ACTIONS(948),
    [anon_sym_import] = ACTIONS(948),
    [anon_sym_enum] = ACTIONS(948),
    [anon_sym_public] = ACTIONS(948),
    [anon_sym_protected] = ACTIONS(948),
    [anon_sym_private] = ACTIONS(948),
    [anon_sym_abstract] = ACTIONS(948),
    [anon_sym_final] = ACTIONS(948),
    [anon_sym_strictfp] = ACTIONS(948),
    [anon_sym_native] = ACTIONS(948),
    [anon_sym_transient] = ACTIONS(948),
    [anon_sym_volatile] = ACTIONS(948),
    [anon_sym_ATinterface] = ACTIONS(946),
    [anon_sym_interface] = ACTIONS(948),
    [anon_sym_byte] = ACTIONS(948),
    [anon_sym_short] = ACTIONS(948),
    [anon_sym_int] = ACTIONS(948),
    [anon_sym_long] = ACTIONS(948),
    [anon_sym_char] = ACTIONS(948),
    [anon_sym_float] = ACTIONS(948),
    [anon_sym_double] = ACTIONS(948),
    [sym_boolean_type] = ACTIONS(948),
    [sym_void_type] = ACTIONS(948),
    [sym_this] = ACTIONS(948),
    [sym_super] = ACTIONS(948),
    [sym_comment] = ACTIONS(3),
  },
  [196] = {
    [ts_builtin_sym_end] = ACTIONS(950),
    [sym_identifier] = ACTIONS(952),
    [sym_decimal_integer_literal] = ACTIONS(952),
    [sym_hex_integer_literal] = ACTIONS(952),
    [sym_octal_integer_literal] = ACTIONS(950),
    [sym_binary_integer_literal] = ACTIONS(950),
    [sym_decimal_floating_point_literal] = ACTIONS(950),
    [sym_hex_floating_point_literal] = ACTIONS(952),
    [sym_true] = ACTIONS(952),
    [sym_false] = ACTIONS(952),
    [sym_character_literal] = ACTIONS(950),
    [sym_string_literal] = ACTIONS(950),
    [sym_null_literal] = ACTIONS(952),
    [anon_sym_LPAREN] = ACTIONS(950),
    [anon_sym_PLUS] = ACTIONS(952),
    [anon_sym_DASH] = ACTIONS(952),
    [anon_sym_BANG] = ACTIONS(950),
    [anon_sym_TILDE] = ACTIONS(950),
    [anon_sym_PLUS_PLUS] = ACTIONS(950),
    [anon_sym_DASH_DASH] = ACTIONS(950),
    [anon_sym_new] = ACTIONS(952),
    [anon_sym_class] = ACTIONS(952),
    [anon_sym_SEMI] = ACTIONS(950),
    [anon_sym_LBRACE] = ACTIONS(950),
    [anon_sym_RBRACE] = ACTIONS(950),
    [anon_sym_assert] = ACTIONS(952),
    [anon_sym_switch] = ACTIONS(952),
    [anon_sym_case] = ACTIONS(952),
    [anon_sym_default] = ACTIONS(952),
    [anon_sym_do] = ACTIONS(952),
    [anon_sym_while] = ACTIONS(952),
    [anon_sym_break] = ACTIONS(952),
    [anon_sym_continue] = ACTIONS(952),
    [anon_sym_return] = ACTIONS(952),
    [anon_sym_synchronized] = ACTIONS(952),
    [anon_sym_throw] = ACTIONS(952),
    [anon_sym_try] = ACTIONS(952),
    [anon_sym_if] = ACTIONS(952),
    [anon_sym_else] = ACTIONS(952),
    [anon_sym_for] = ACTIONS(952),
    [anon_sym_AT] = ACTIONS(952),
    [anon_sym_open] = ACTIONS(952),
    [anon_sym_module] = ACTIONS(952),
    [anon_sym_static] = ACTIONS(952),
    [anon_sym_package] = ACTIONS(952),
    [anon_sym_import] = ACTIONS(952),
    [anon_sym_enum] = ACTIONS(952),
    [anon_sym_public] = ACTIONS(952),
    [anon_sym_protected] = ACTIONS(952),
    [anon_sym_private] = ACTIONS(952),
    [anon_sym_abstract] = ACTIONS(952),
    [anon_sym_final] = ACTIONS(952),
    [anon_sym_strictfp] = ACTIONS(952),
    [anon_sym_native] = ACTIONS(952),
    [anon_sym_transient] = ACTIONS(952),
    [anon_sym_volatile] = ACTIONS(952),
    [anon_sym_ATinterface] = ACTIONS(950),
    [anon_sym_interface] = ACTIONS(952),
    [anon_sym_byte] = ACTIONS(952),
    [anon_sym_short] = ACTIONS(952),
    [anon_sym_int] = ACTIONS(952),
    [anon_sym_long] = ACTIONS(952),
    [anon_sym_char] = ACTIONS(952),
    [anon_sym_float] = ACTIONS(952),
    [anon_sym_double] = ACTIONS(952),
    [sym_boolean_type] = ACTIONS(952),
    [sym_void_type] = ACTIONS(952),
    [sym_this] = ACTIONS(952),
    [sym_super] = ACTIONS(952),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [ts_builtin_sym_end] = ACTIONS(954),
    [sym_identifier] = ACTIONS(956),
    [sym_decimal_integer_literal] = ACTIONS(956),
    [sym_hex_integer_literal] = ACTIONS(956),
    [sym_octal_integer_literal] = ACTIONS(954),
    [sym_binary_integer_literal] = ACTIONS(954),
    [sym_decimal_floating_point_literal] = ACTIONS(954),
    [sym_hex_floating_point_literal] = ACTIONS(956),
    [sym_true] = ACTIONS(956),
    [sym_false] = ACTIONS(956),
    [sym_character_literal] = ACTIONS(954),
    [sym_string_literal] = ACTIONS(954),
    [sym_null_literal] = ACTIONS(956),
    [anon_sym_LPAREN] = ACTIONS(954),
    [anon_sym_PLUS] = ACTIONS(956),
    [anon_sym_DASH] = ACTIONS(956),
    [anon_sym_BANG] = ACTIONS(954),
    [anon_sym_TILDE] = ACTIONS(954),
    [anon_sym_PLUS_PLUS] = ACTIONS(954),
    [anon_sym_DASH_DASH] = ACTIONS(954),
    [anon_sym_new] = ACTIONS(956),
    [anon_sym_class] = ACTIONS(956),
    [anon_sym_SEMI] = ACTIONS(954),
    [anon_sym_LBRACE] = ACTIONS(954),
    [anon_sym_RBRACE] = ACTIONS(954),
    [anon_sym_assert] = ACTIONS(956),
    [anon_sym_switch] = ACTIONS(956),
    [anon_sym_case] = ACTIONS(956),
    [anon_sym_default] = ACTIONS(956),
    [anon_sym_do] = ACTIONS(956),
    [anon_sym_while] = ACTIONS(956),
    [anon_sym_break] = ACTIONS(956),
    [anon_sym_continue] = ACTIONS(956),
    [anon_sym_return] = ACTIONS(956),
    [anon_sym_synchronized] = ACTIONS(956),
    [anon_sym_throw] = ACTIONS(956),
    [anon_sym_try] = ACTIONS(956),
    [anon_sym_if] = ACTIONS(956),
    [anon_sym_else] = ACTIONS(956),
    [anon_sym_for] = ACTIONS(956),
    [anon_sym_AT] = ACTIONS(956),
    [anon_sym_open] = ACTIONS(956),
    [anon_sym_module] = ACTIONS(956),
    [anon_sym_static] = ACTIONS(956),
    [anon_sym_package] = ACTIONS(956),
    [anon_sym_import] = ACTIONS(956),
    [anon_sym_enum] = ACTIONS(956),
    [anon_sym_public] = ACTIONS(956),
    [anon_sym_protected] = ACTIONS(956),
    [anon_sym_private] = ACTIONS(956),
    [anon_sym_abstract] = ACTIONS(956),
    [anon_sym_final] = ACTIONS(956),
    [anon_sym_strictfp] = ACTIONS(956),
    [anon_sym_native] = ACTIONS(956),
    [anon_sym_transient] = ACTIONS(956),
    [anon_sym_volatile] = ACTIONS(956),
    [anon_sym_ATinterface] = ACTIONS(954),
    [anon_sym_interface] = ACTIONS(956),
    [anon_sym_byte] = ACTIONS(956),
    [anon_sym_short] = ACTIONS(956),
    [anon_sym_int] = ACTIONS(956),
    [anon_sym_long] = ACTIONS(956),
    [anon_sym_char] = ACTIONS(956),
    [anon_sym_float] = ACTIONS(956),
    [anon_sym_double] = ACTIONS(956),
    [sym_boolean_type] = ACTIONS(956),
    [sym_void_type] = ACTIONS(956),
    [sym_this] = ACTIONS(956),
    [sym_super] = ACTIONS(956),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [ts_builtin_sym_end] = ACTIONS(958),
    [sym_identifier] = ACTIONS(960),
    [sym_decimal_integer_literal] = ACTIONS(960),
    [sym_hex_integer_literal] = ACTIONS(960),
    [sym_octal_integer_literal] = ACTIONS(958),
    [sym_binary_integer_literal] = ACTIONS(958),
    [sym_decimal_floating_point_literal] = ACTIONS(958),
    [sym_hex_floating_point_literal] = ACTIONS(960),
    [sym_true] = ACTIONS(960),
    [sym_false] = ACTIONS(960),
    [sym_character_literal] = ACTIONS(958),
    [sym_string_literal] = ACTIONS(958),
    [sym_null_literal] = ACTIONS(960),
    [anon_sym_LPAREN] = ACTIONS(958),
    [anon_sym_PLUS] = ACTIONS(960),
    [anon_sym_DASH] = ACTIONS(960),
    [anon_sym_BANG] = ACTIONS(958),
    [anon_sym_TILDE] = ACTIONS(958),
    [anon_sym_PLUS_PLUS] = ACTIONS(958),
    [anon_sym_DASH_DASH] = ACTIONS(958),
    [anon_sym_new] = ACTIONS(960),
    [anon_sym_class] = ACTIONS(960),
    [anon_sym_SEMI] = ACTIONS(958),
    [anon_sym_LBRACE] = ACTIONS(958),
    [anon_sym_RBRACE] = ACTIONS(958),
    [anon_sym_assert] = ACTIONS(960),
    [anon_sym_switch] = ACTIONS(960),
    [anon_sym_case] = ACTIONS(960),
    [anon_sym_default] = ACTIONS(960),
    [anon_sym_do] = ACTIONS(960),
    [anon_sym_while] = ACTIONS(960),
    [anon_sym_break] = ACTIONS(960),
    [anon_sym_continue] = ACTIONS(960),
    [anon_sym_return] = ACTIONS(960),
    [anon_sym_synchronized] = ACTIONS(960),
    [anon_sym_throw] = ACTIONS(960),
    [anon_sym_try] = ACTIONS(960),
    [anon_sym_if] = ACTIONS(960),
    [anon_sym_else] = ACTIONS(960),
    [anon_sym_for] = ACTIONS(960),
    [anon_sym_AT] = ACTIONS(960),
    [anon_sym_open] = ACTIONS(960),
    [anon_sym_module] = ACTIONS(960),
    [anon_sym_static] = ACTIONS(960),
    [anon_sym_package] = ACTIONS(960),
    [anon_sym_import] = ACTIONS(960),
    [anon_sym_enum] = ACTIONS(960),
    [anon_sym_public] = ACTIONS(960),
    [anon_sym_protected] = ACTIONS(960),
    [anon_sym_private] = ACTIONS(960),
    [anon_sym_abstract] = ACTIONS(960),
    [anon_sym_final] = ACTIONS(960),
    [anon_sym_strictfp] = ACTIONS(960),
    [anon_sym_native] = ACTIONS(960),
    [anon_sym_transient] = ACTIONS(960),
    [anon_sym_volatile] = ACTIONS(960),
    [anon_sym_ATinterface] = ACTIONS(958),
    [anon_sym_interface] = ACTIONS(960),
    [anon_sym_byte] = ACTIONS(960),
    [anon_sym_short] = ACTIONS(960),
    [anon_sym_int] = ACTIONS(960),
    [anon_sym_long] = ACTIONS(960),
    [anon_sym_char] = ACTIONS(960),
    [anon_sym_float] = ACTIONS(960),
    [anon_sym_double] = ACTIONS(960),
    [sym_boolean_type] = ACTIONS(960),
    [sym_void_type] = ACTIONS(960),
    [sym_this] = ACTIONS(960),
    [sym_super] = ACTIONS(960),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [ts_builtin_sym_end] = ACTIONS(962),
    [sym_identifier] = ACTIONS(964),
    [sym_decimal_integer_literal] = ACTIONS(964),
    [sym_hex_integer_literal] = ACTIONS(964),
    [sym_octal_integer_literal] = ACTIONS(962),
    [sym_binary_integer_literal] = ACTIONS(962),
    [sym_decimal_floating_point_literal] = ACTIONS(962),
    [sym_hex_floating_point_literal] = ACTIONS(964),
    [sym_true] = ACTIONS(964),
    [sym_false] = ACTIONS(964),
    [sym_character_literal] = ACTIONS(962),
    [sym_string_literal] = ACTIONS(962),
    [sym_null_literal] = ACTIONS(964),
    [anon_sym_LPAREN] = ACTIONS(962),
    [anon_sym_PLUS] = ACTIONS(964),
    [anon_sym_DASH] = ACTIONS(964),
    [anon_sym_BANG] = ACTIONS(962),
    [anon_sym_TILDE] = ACTIONS(962),
    [anon_sym_PLUS_PLUS] = ACTIONS(962),
    [anon_sym_DASH_DASH] = ACTIONS(962),
    [anon_sym_new] = ACTIONS(964),
    [anon_sym_class] = ACTIONS(964),
    [anon_sym_SEMI] = ACTIONS(962),
    [anon_sym_LBRACE] = ACTIONS(962),
    [anon_sym_RBRACE] = ACTIONS(962),
    [anon_sym_assert] = ACTIONS(964),
    [anon_sym_switch] = ACTIONS(964),
    [anon_sym_case] = ACTIONS(964),
    [anon_sym_default] = ACTIONS(964),
    [anon_sym_do] = ACTIONS(964),
    [anon_sym_while] = ACTIONS(964),
    [anon_sym_break] = ACTIONS(964),
    [anon_sym_continue] = ACTIONS(964),
    [anon_sym_return] = ACTIONS(964),
    [anon_sym_synchronized] = ACTIONS(964),
    [anon_sym_throw] = ACTIONS(964),
    [anon_sym_try] = ACTIONS(964),
    [anon_sym_if] = ACTIONS(964),
    [anon_sym_else] = ACTIONS(964),
    [anon_sym_for] = ACTIONS(964),
    [anon_sym_AT] = ACTIONS(964),
    [anon_sym_open] = ACTIONS(964),
    [anon_sym_module] = ACTIONS(964),
    [anon_sym_static] = ACTIONS(964),
    [anon_sym_package] = ACTIONS(964),
    [anon_sym_import] = ACTIONS(964),
    [anon_sym_enum] = ACTIONS(964),
    [anon_sym_public] = ACTIONS(964),
    [anon_sym_protected] = ACTIONS(964),
    [anon_sym_private] = ACTIONS(964),
    [anon_sym_abstract] = ACTIONS(964),
    [anon_sym_final] = ACTIONS(964),
    [anon_sym_strictfp] = ACTIONS(964),
    [anon_sym_native] = ACTIONS(964),
    [anon_sym_transient] = ACTIONS(964),
    [anon_sym_volatile] = ACTIONS(964),
    [anon_sym_ATinterface] = ACTIONS(962),
    [anon_sym_interface] = ACTIONS(964),
    [anon_sym_byte] = ACTIONS(964),
    [anon_sym_short] = ACTIONS(964),
    [anon_sym_int] = ACTIONS(964),
    [anon_sym_long] = ACTIONS(964),
    [anon_sym_char] = ACTIONS(964),
    [anon_sym_float] = ACTIONS(964),
    [anon_sym_double] = ACTIONS(964),
    [sym_boolean_type] = ACTIONS(964),
    [sym_void_type] = ACTIONS(964),
    [sym_this] = ACTIONS(964),
    [sym_super] = ACTIONS(964),
    [sym_comment] = ACTIONS(3),
  },
  [200] = {
    [ts_builtin_sym_end] = ACTIONS(966),
    [sym_identifier] = ACTIONS(968),
    [sym_decimal_integer_literal] = ACTIONS(968),
    [sym_hex_integer_literal] = ACTIONS(968),
    [sym_octal_integer_literal] = ACTIONS(966),
    [sym_binary_integer_literal] = ACTIONS(966),
    [sym_decimal_floating_point_literal] = ACTIONS(966),
    [sym_hex_floating_point_literal] = ACTIONS(968),
    [sym_true] = ACTIONS(968),
    [sym_false] = ACTIONS(968),
    [sym_character_literal] = ACTIONS(966),
    [sym_string_literal] = ACTIONS(966),
    [sym_null_literal] = ACTIONS(968),
    [anon_sym_LPAREN] = ACTIONS(966),
    [anon_sym_PLUS] = ACTIONS(968),
    [anon_sym_DASH] = ACTIONS(968),
    [anon_sym_BANG] = ACTIONS(966),
    [anon_sym_TILDE] = ACTIONS(966),
    [anon_sym_PLUS_PLUS] = ACTIONS(966),
    [anon_sym_DASH_DASH] = ACTIONS(966),
    [anon_sym_new] = ACTIONS(968),
    [anon_sym_class] = ACTIONS(968),
    [anon_sym_SEMI] = ACTIONS(966),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_RBRACE] = ACTIONS(966),
    [anon_sym_assert] = ACTIONS(968),
    [anon_sym_switch] = ACTIONS(968),
    [anon_sym_case] = ACTIONS(968),
    [anon_sym_default] = ACTIONS(968),
    [anon_sym_do] = ACTIONS(968),
    [anon_sym_while] = ACTIONS(968),
    [anon_sym_break] = ACTIONS(968),
    [anon_sym_continue] = ACTIONS(968),
    [anon_sym_return] = ACTIONS(968),
    [anon_sym_synchronized] = ACTIONS(968),
    [anon_sym_throw] = ACTIONS(968),
    [anon_sym_try] = ACTIONS(968),
    [anon_sym_if] = ACTIONS(968),
    [anon_sym_else] = ACTIONS(968),
    [anon_sym_for] = ACTIONS(968),
    [anon_sym_AT] = ACTIONS(968),
    [anon_sym_open] = ACTIONS(968),
    [anon_sym_module] = ACTIONS(968),
    [anon_sym_static] = ACTIONS(968),
    [anon_sym_package] = ACTIONS(968),
    [anon_sym_import] = ACTIONS(968),
    [anon_sym_enum] = ACTIONS(968),
    [anon_sym_public] = ACTIONS(968),
    [anon_sym_protected] = ACTIONS(968),
    [anon_sym_private] = ACTIONS(968),
    [anon_sym_abstract] = ACTIONS(968),
    [anon_sym_final] = ACTIONS(968),
    [anon_sym_strictfp] = ACTIONS(968),
    [anon_sym_native] = ACTIONS(968),
    [anon_sym_transient] = ACTIONS(968),
    [anon_sym_volatile] = ACTIONS(968),
    [anon_sym_ATinterface] = ACTIONS(966),
    [anon_sym_interface] = ACTIONS(968),
    [anon_sym_byte] = ACTIONS(968),
    [anon_sym_short] = ACTIONS(968),
    [anon_sym_int] = ACTIONS(968),
    [anon_sym_long] = ACTIONS(968),
    [anon_sym_char] = ACTIONS(968),
    [anon_sym_float] = ACTIONS(968),
    [anon_sym_double] = ACTIONS(968),
    [sym_boolean_type] = ACTIONS(968),
    [sym_void_type] = ACTIONS(968),
    [sym_this] = ACTIONS(968),
    [sym_super] = ACTIONS(968),
    [sym_comment] = ACTIONS(3),
  },
  [201] = {
    [ts_builtin_sym_end] = ACTIONS(970),
    [sym_identifier] = ACTIONS(972),
    [sym_decimal_integer_literal] = ACTIONS(972),
    [sym_hex_integer_literal] = ACTIONS(972),
    [sym_octal_integer_literal] = ACTIONS(970),
    [sym_binary_integer_literal] = ACTIONS(970),
    [sym_decimal_floating_point_literal] = ACTIONS(970),
    [sym_hex_floating_point_literal] = ACTIONS(972),
    [sym_true] = ACTIONS(972),
    [sym_false] = ACTIONS(972),
    [sym_character_literal] = ACTIONS(970),
    [sym_string_literal] = ACTIONS(970),
    [sym_null_literal] = ACTIONS(972),
    [anon_sym_LPAREN] = ACTIONS(970),
    [anon_sym_PLUS] = ACTIONS(972),
    [anon_sym_DASH] = ACTIONS(972),
    [anon_sym_BANG] = ACTIONS(970),
    [anon_sym_TILDE] = ACTIONS(970),
    [anon_sym_PLUS_PLUS] = ACTIONS(970),
    [anon_sym_DASH_DASH] = ACTIONS(970),
    [anon_sym_new] = ACTIONS(972),
    [anon_sym_class] = ACTIONS(972),
    [anon_sym_SEMI] = ACTIONS(970),
    [anon_sym_LBRACE] = ACTIONS(970),
    [anon_sym_RBRACE] = ACTIONS(970),
    [anon_sym_assert] = ACTIONS(972),
    [anon_sym_switch] = ACTIONS(972),
    [anon_sym_case] = ACTIONS(972),
    [anon_sym_default] = ACTIONS(972),
    [anon_sym_do] = ACTIONS(972),
    [anon_sym_while] = ACTIONS(972),
    [anon_sym_break] = ACTIONS(972),
    [anon_sym_continue] = ACTIONS(972),
    [anon_sym_return] = ACTIONS(972),
    [anon_sym_synchronized] = ACTIONS(972),
    [anon_sym_throw] = ACTIONS(972),
    [anon_sym_try] = ACTIONS(972),
    [anon_sym_if] = ACTIONS(972),
    [anon_sym_else] = ACTIONS(972),
    [anon_sym_for] = ACTIONS(972),
    [anon_sym_AT] = ACTIONS(972),
    [anon_sym_open] = ACTIONS(972),
    [anon_sym_module] = ACTIONS(972),
    [anon_sym_static] = ACTIONS(972),
    [anon_sym_package] = ACTIONS(972),
    [anon_sym_import] = ACTIONS(972),
    [anon_sym_enum] = ACTIONS(972),
    [anon_sym_public] = ACTIONS(972),
    [anon_sym_protected] = ACTIONS(972),
    [anon_sym_private] = ACTIONS(972),
    [anon_sym_abstract] = ACTIONS(972),
    [anon_sym_final] = ACTIONS(972),
    [anon_sym_strictfp] = ACTIONS(972),
    [anon_sym_native] = ACTIONS(972),
    [anon_sym_transient] = ACTIONS(972),
    [anon_sym_volatile] = ACTIONS(972),
    [anon_sym_ATinterface] = ACTIONS(970),
    [anon_sym_interface] = ACTIONS(972),
    [anon_sym_byte] = ACTIONS(972),
    [anon_sym_short] = ACTIONS(972),
    [anon_sym_int] = ACTIONS(972),
    [anon_sym_long] = ACTIONS(972),
    [anon_sym_char] = ACTIONS(972),
    [anon_sym_float] = ACTIONS(972),
    [anon_sym_double] = ACTIONS(972),
    [sym_boolean_type] = ACTIONS(972),
    [sym_void_type] = ACTIONS(972),
    [sym_this] = ACTIONS(972),
    [sym_super] = ACTIONS(972),
    [sym_comment] = ACTIONS(3),
  },
  [202] = {
    [ts_builtin_sym_end] = ACTIONS(974),
    [sym_identifier] = ACTIONS(976),
    [sym_decimal_integer_literal] = ACTIONS(976),
    [sym_hex_integer_literal] = ACTIONS(976),
    [sym_octal_integer_literal] = ACTIONS(974),
    [sym_binary_integer_literal] = ACTIONS(974),
    [sym_decimal_floating_point_literal] = ACTIONS(974),
    [sym_hex_floating_point_literal] = ACTIONS(976),
    [sym_true] = ACTIONS(976),
    [sym_false] = ACTIONS(976),
    [sym_character_literal] = ACTIONS(974),
    [sym_string_literal] = ACTIONS(974),
    [sym_null_literal] = ACTIONS(976),
    [anon_sym_LPAREN] = ACTIONS(974),
    [anon_sym_PLUS] = ACTIONS(976),
    [anon_sym_DASH] = ACTIONS(976),
    [anon_sym_BANG] = ACTIONS(974),
    [anon_sym_TILDE] = ACTIONS(974),
    [anon_sym_PLUS_PLUS] = ACTIONS(974),
    [anon_sym_DASH_DASH] = ACTIONS(974),
    [anon_sym_new] = ACTIONS(976),
    [anon_sym_class] = ACTIONS(976),
    [anon_sym_SEMI] = ACTIONS(974),
    [anon_sym_LBRACE] = ACTIONS(974),
    [anon_sym_RBRACE] = ACTIONS(974),
    [anon_sym_assert] = ACTIONS(976),
    [anon_sym_switch] = ACTIONS(976),
    [anon_sym_case] = ACTIONS(976),
    [anon_sym_default] = ACTIONS(976),
    [anon_sym_do] = ACTIONS(976),
    [anon_sym_while] = ACTIONS(976),
    [anon_sym_break] = ACTIONS(976),
    [anon_sym_continue] = ACTIONS(976),
    [anon_sym_return] = ACTIONS(976),
    [anon_sym_synchronized] = ACTIONS(976),
    [anon_sym_throw] = ACTIONS(976),
    [anon_sym_try] = ACTIONS(976),
    [anon_sym_if] = ACTIONS(976),
    [anon_sym_else] = ACTIONS(976),
    [anon_sym_for] = ACTIONS(976),
    [anon_sym_AT] = ACTIONS(976),
    [anon_sym_open] = ACTIONS(976),
    [anon_sym_module] = ACTIONS(976),
    [anon_sym_static] = ACTIONS(976),
    [anon_sym_package] = ACTIONS(976),
    [anon_sym_import] = ACTIONS(976),
    [anon_sym_enum] = ACTIONS(976),
    [anon_sym_public] = ACTIONS(976),
    [anon_sym_protected] = ACTIONS(976),
    [anon_sym_private] = ACTIONS(976),
    [anon_sym_abstract] = ACTIONS(976),
    [anon_sym_final] = ACTIONS(976),
    [anon_sym_strictfp] = ACTIONS(976),
    [anon_sym_native] = ACTIONS(976),
    [anon_sym_transient] = ACTIONS(976),
    [anon_sym_volatile] = ACTIONS(976),
    [anon_sym_ATinterface] = ACTIONS(974),
    [anon_sym_interface] = ACTIONS(976),
    [anon_sym_byte] = ACTIONS(976),
    [anon_sym_short] = ACTIONS(976),
    [anon_sym_int] = ACTIONS(976),
    [anon_sym_long] = ACTIONS(976),
    [anon_sym_char] = ACTIONS(976),
    [anon_sym_float] = ACTIONS(976),
    [anon_sym_double] = ACTIONS(976),
    [sym_boolean_type] = ACTIONS(976),
    [sym_void_type] = ACTIONS(976),
    [sym_this] = ACTIONS(976),
    [sym_super] = ACTIONS(976),
    [sym_comment] = ACTIONS(3),
  },
  [203] = {
    [ts_builtin_sym_end] = ACTIONS(978),
    [sym_identifier] = ACTIONS(980),
    [sym_decimal_integer_literal] = ACTIONS(980),
    [sym_hex_integer_literal] = ACTIONS(980),
    [sym_octal_integer_literal] = ACTIONS(978),
    [sym_binary_integer_literal] = ACTIONS(978),
    [sym_decimal_floating_point_literal] = ACTIONS(978),
    [sym_hex_floating_point_literal] = ACTIONS(980),
    [sym_true] = ACTIONS(980),
    [sym_false] = ACTIONS(980),
    [sym_character_literal] = ACTIONS(978),
    [sym_string_literal] = ACTIONS(978),
    [sym_null_literal] = ACTIONS(980),
    [anon_sym_LPAREN] = ACTIONS(978),
    [anon_sym_PLUS] = ACTIONS(980),
    [anon_sym_DASH] = ACTIONS(980),
    [anon_sym_BANG] = ACTIONS(978),
    [anon_sym_TILDE] = ACTIONS(978),
    [anon_sym_PLUS_PLUS] = ACTIONS(978),
    [anon_sym_DASH_DASH] = ACTIONS(978),
    [anon_sym_new] = ACTIONS(980),
    [anon_sym_class] = ACTIONS(980),
    [anon_sym_SEMI] = ACTIONS(978),
    [anon_sym_LBRACE] = ACTIONS(978),
    [anon_sym_RBRACE] = ACTIONS(978),
    [anon_sym_assert] = ACTIONS(980),
    [anon_sym_switch] = ACTIONS(980),
    [anon_sym_case] = ACTIONS(980),
    [anon_sym_default] = ACTIONS(980),
    [anon_sym_do] = ACTIONS(980),
    [anon_sym_while] = ACTIONS(980),
    [anon_sym_break] = ACTIONS(980),
    [anon_sym_continue] = ACTIONS(980),
    [anon_sym_return] = ACTIONS(980),
    [anon_sym_synchronized] = ACTIONS(980),
    [anon_sym_throw] = ACTIONS(980),
    [anon_sym_try] = ACTIONS(980),
    [anon_sym_if] = ACTIONS(980),
    [anon_sym_else] = ACTIONS(980),
    [anon_sym_for] = ACTIONS(980),
    [anon_sym_AT] = ACTIONS(980),
    [anon_sym_open] = ACTIONS(980),
    [anon_sym_module] = ACTIONS(980),
    [anon_sym_static] = ACTIONS(980),
    [anon_sym_package] = ACTIONS(980),
    [anon_sym_import] = ACTIONS(980),
    [anon_sym_enum] = ACTIONS(980),
    [anon_sym_public] = ACTIONS(980),
    [anon_sym_protected] = ACTIONS(980),
    [anon_sym_private] = ACTIONS(980),
    [anon_sym_abstract] = ACTIONS(980),
    [anon_sym_final] = ACTIONS(980),
    [anon_sym_strictfp] = ACTIONS(980),
    [anon_sym_native] = ACTIONS(980),
    [anon_sym_transient] = ACTIONS(980),
    [anon_sym_volatile] = ACTIONS(980),
    [anon_sym_ATinterface] = ACTIONS(978),
    [anon_sym_interface] = ACTIONS(980),
    [anon_sym_byte] = ACTIONS(980),
    [anon_sym_short] = ACTIONS(980),
    [anon_sym_int] = ACTIONS(980),
    [anon_sym_long] = ACTIONS(980),
    [anon_sym_char] = ACTIONS(980),
    [anon_sym_float] = ACTIONS(980),
    [anon_sym_double] = ACTIONS(980),
    [sym_boolean_type] = ACTIONS(980),
    [sym_void_type] = ACTIONS(980),
    [sym_this] = ACTIONS(980),
    [sym_super] = ACTIONS(980),
    [sym_comment] = ACTIONS(3),
  },
  [204] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(425),
    [sym_cast_expression] = STATE(425),
    [sym_assignment_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_instanceof_expression] = STATE(425),
    [sym_lambda_expression] = STATE(425),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [205] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(387),
    [sym_cast_expression] = STATE(387),
    [sym_assignment_expression] = STATE(387),
    [sym_binary_expression] = STATE(387),
    [sym_instanceof_expression] = STATE(387),
    [sym_lambda_expression] = STATE(387),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(387),
    [sym_unary_expression] = STATE(387),
    [sym_update_expression] = STATE(387),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [206] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(430),
    [sym_cast_expression] = STATE(430),
    [sym_assignment_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_instanceof_expression] = STATE(430),
    [sym_lambda_expression] = STATE(430),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [207] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(433),
    [sym_cast_expression] = STATE(433),
    [sym_assignment_expression] = STATE(433),
    [sym_binary_expression] = STATE(433),
    [sym_instanceof_expression] = STATE(433),
    [sym_lambda_expression] = STATE(433),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(433),
    [sym_unary_expression] = STATE(433),
    [sym_update_expression] = STATE(433),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [208] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(431),
    [sym_cast_expression] = STATE(431),
    [sym_assignment_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_instanceof_expression] = STATE(431),
    [sym_lambda_expression] = STATE(431),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [209] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(394),
    [sym_cast_expression] = STATE(394),
    [sym_assignment_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_instanceof_expression] = STATE(394),
    [sym_lambda_expression] = STATE(394),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [210] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(388),
    [sym_cast_expression] = STATE(388),
    [sym_assignment_expression] = STATE(388),
    [sym_binary_expression] = STATE(388),
    [sym_instanceof_expression] = STATE(388),
    [sym_lambda_expression] = STATE(388),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(388),
    [sym_unary_expression] = STATE(388),
    [sym_update_expression] = STATE(388),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [211] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(377),
    [sym_cast_expression] = STATE(377),
    [sym_assignment_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_instanceof_expression] = STATE(377),
    [sym_lambda_expression] = STATE(377),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_update_expression] = STATE(377),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [212] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(437),
    [sym_cast_expression] = STATE(437),
    [sym_assignment_expression] = STATE(437),
    [sym_binary_expression] = STATE(437),
    [sym_instanceof_expression] = STATE(437),
    [sym_lambda_expression] = STATE(437),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(437),
    [sym_unary_expression] = STATE(437),
    [sym_update_expression] = STATE(437),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [213] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(389),
    [sym_cast_expression] = STATE(389),
    [sym_assignment_expression] = STATE(389),
    [sym_binary_expression] = STATE(389),
    [sym_instanceof_expression] = STATE(389),
    [sym_lambda_expression] = STATE(389),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(389),
    [sym_unary_expression] = STATE(389),
    [sym_update_expression] = STATE(389),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [214] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(455),
    [sym_cast_expression] = STATE(455),
    [sym_assignment_expression] = STATE(455),
    [sym_binary_expression] = STATE(455),
    [sym_instanceof_expression] = STATE(455),
    [sym_lambda_expression] = STATE(455),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(455),
    [sym_unary_expression] = STATE(455),
    [sym_update_expression] = STATE(455),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [215] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(380),
    [sym_cast_expression] = STATE(380),
    [sym_assignment_expression] = STATE(380),
    [sym_binary_expression] = STATE(380),
    [sym_instanceof_expression] = STATE(380),
    [sym_lambda_expression] = STATE(380),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(380),
    [sym_unary_expression] = STATE(380),
    [sym_update_expression] = STATE(380),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [216] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(379),
    [sym_cast_expression] = STATE(379),
    [sym_assignment_expression] = STATE(379),
    [sym_binary_expression] = STATE(379),
    [sym_instanceof_expression] = STATE(379),
    [sym_lambda_expression] = STATE(379),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(379),
    [sym_unary_expression] = STATE(379),
    [sym_update_expression] = STATE(379),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [217] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(436),
    [sym_cast_expression] = STATE(436),
    [sym_assignment_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_instanceof_expression] = STATE(436),
    [sym_lambda_expression] = STATE(436),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [218] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(441),
    [sym_cast_expression] = STATE(441),
    [sym_assignment_expression] = STATE(441),
    [sym_binary_expression] = STATE(441),
    [sym_instanceof_expression] = STATE(441),
    [sym_lambda_expression] = STATE(441),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(441),
    [sym_unary_expression] = STATE(441),
    [sym_update_expression] = STATE(441),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [219] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(374),
    [sym_cast_expression] = STATE(374),
    [sym_assignment_expression] = STATE(374),
    [sym_binary_expression] = STATE(374),
    [sym_instanceof_expression] = STATE(374),
    [sym_lambda_expression] = STATE(374),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(374),
    [sym_unary_expression] = STATE(374),
    [sym_update_expression] = STATE(374),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [220] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(447),
    [sym_cast_expression] = STATE(447),
    [sym_assignment_expression] = STATE(447),
    [sym_binary_expression] = STATE(447),
    [sym_instanceof_expression] = STATE(447),
    [sym_lambda_expression] = STATE(447),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(447),
    [sym_unary_expression] = STATE(447),
    [sym_update_expression] = STATE(447),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [221] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(386),
    [sym_cast_expression] = STATE(386),
    [sym_assignment_expression] = STATE(386),
    [sym_binary_expression] = STATE(386),
    [sym_instanceof_expression] = STATE(386),
    [sym_lambda_expression] = STATE(386),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(386),
    [sym_unary_expression] = STATE(386),
    [sym_update_expression] = STATE(386),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [222] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(373),
    [sym_cast_expression] = STATE(373),
    [sym_assignment_expression] = STATE(373),
    [sym_binary_expression] = STATE(373),
    [sym_instanceof_expression] = STATE(373),
    [sym_lambda_expression] = STATE(373),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(373),
    [sym_unary_expression] = STATE(373),
    [sym_update_expression] = STATE(373),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [223] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(444),
    [sym_cast_expression] = STATE(444),
    [sym_assignment_expression] = STATE(444),
    [sym_binary_expression] = STATE(444),
    [sym_instanceof_expression] = STATE(444),
    [sym_lambda_expression] = STATE(444),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(444),
    [sym_unary_expression] = STATE(444),
    [sym_update_expression] = STATE(444),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [224] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(424),
    [sym_cast_expression] = STATE(424),
    [sym_assignment_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_instanceof_expression] = STATE(424),
    [sym_lambda_expression] = STATE(424),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [225] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(448),
    [sym_cast_expression] = STATE(448),
    [sym_assignment_expression] = STATE(448),
    [sym_binary_expression] = STATE(448),
    [sym_instanceof_expression] = STATE(448),
    [sym_lambda_expression] = STATE(448),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(448),
    [sym_unary_expression] = STATE(448),
    [sym_update_expression] = STATE(448),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [226] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(385),
    [sym_cast_expression] = STATE(385),
    [sym_assignment_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_instanceof_expression] = STATE(385),
    [sym_lambda_expression] = STATE(385),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_update_expression] = STATE(385),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [227] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(428),
    [sym_cast_expression] = STATE(428),
    [sym_assignment_expression] = STATE(428),
    [sym_binary_expression] = STATE(428),
    [sym_instanceof_expression] = STATE(428),
    [sym_lambda_expression] = STATE(428),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(428),
    [sym_unary_expression] = STATE(428),
    [sym_update_expression] = STATE(428),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [228] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(378),
    [sym_cast_expression] = STATE(378),
    [sym_assignment_expression] = STATE(378),
    [sym_binary_expression] = STATE(378),
    [sym_instanceof_expression] = STATE(378),
    [sym_lambda_expression] = STATE(378),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(378),
    [sym_unary_expression] = STATE(378),
    [sym_update_expression] = STATE(378),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [229] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(383),
    [sym_cast_expression] = STATE(383),
    [sym_assignment_expression] = STATE(383),
    [sym_binary_expression] = STATE(383),
    [sym_instanceof_expression] = STATE(383),
    [sym_lambda_expression] = STATE(383),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(383),
    [sym_unary_expression] = STATE(383),
    [sym_update_expression] = STATE(383),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [230] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(454),
    [sym_cast_expression] = STATE(454),
    [sym_assignment_expression] = STATE(454),
    [sym_binary_expression] = STATE(454),
    [sym_instanceof_expression] = STATE(454),
    [sym_lambda_expression] = STATE(454),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(454),
    [sym_unary_expression] = STATE(454),
    [sym_update_expression] = STATE(454),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [231] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(426),
    [sym_cast_expression] = STATE(426),
    [sym_assignment_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_instanceof_expression] = STATE(426),
    [sym_lambda_expression] = STATE(426),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [232] = {
    [sym__literal] = STATE(312),
    [sym__expression] = STATE(451),
    [sym_cast_expression] = STATE(451),
    [sym_assignment_expression] = STATE(451),
    [sym_binary_expression] = STATE(451),
    [sym_instanceof_expression] = STATE(451),
    [sym_lambda_expression] = STATE(451),
    [sym_inferred_parameters] = STATE(906),
    [sym_ternary_expression] = STATE(451),
    [sym_unary_expression] = STATE(451),
    [sym_update_expression] = STATE(451),
    [sym__primary] = STATE(312),
    [sym_array_creation_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_class_literal] = STATE(312),
    [sym_object_creation_expression] = STATE(312),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(261),
    [sym_array_access] = STATE(261),
    [sym_method_invocation] = STATE(312),
    [sym_method_reference] = STATE(312),
    [sym__annotation] = STATE(472),
    [sym_marker_annotation] = STATE(472),
    [sym_annotation] = STATE(472),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(556),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(556),
    [sym_integral_type] = STATE(556),
    [sym_floating_point_type] = STATE(556),
    [sym_formal_parameters] = STATE(906),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [sym_identifier] = ACTIONS(447),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(443),
    [anon_sym_module] = ACTIONS(443),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(475),
    [sym_void_type] = ACTIONS(475),
    [sym_this] = ACTIONS(9),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [233] = {
    [sym__literal] = STATE(772),
    [sym__primary] = STATE(772),
    [sym_array_creation_expression] = STATE(772),
    [sym_parenthesized_expression] = STATE(772),
    [sym_class_literal] = STATE(772),
    [sym_object_creation_expression] = STATE(772),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(623),
    [sym_array_access] = STATE(772),
    [sym_method_invocation] = STATE(772),
    [sym_method_reference] = STATE(772),
    [sym_resource] = STATE(848),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(501),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(524),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(524),
    [sym_integral_type] = STATE(524),
    [sym_floating_point_type] = STATE(524),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(982),
    [sym_decimal_integer_literal] = ACTIONS(984),
    [sym_hex_integer_literal] = ACTIONS(984),
    [sym_octal_integer_literal] = ACTIONS(986),
    [sym_binary_integer_literal] = ACTIONS(986),
    [sym_decimal_floating_point_literal] = ACTIONS(986),
    [sym_hex_floating_point_literal] = ACTIONS(984),
    [sym_true] = ACTIONS(984),
    [sym_false] = ACTIONS(984),
    [sym_character_literal] = ACTIONS(986),
    [sym_string_literal] = ACTIONS(986),
    [sym_null_literal] = ACTIONS(984),
    [anon_sym_LPAREN] = ACTIONS(988),
    [anon_sym_RPAREN] = ACTIONS(990),
    [anon_sym_new] = ACTIONS(992),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(994),
    [anon_sym_module] = ACTIONS(994),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(996),
    [sym_void_type] = ACTIONS(996),
    [sym_this] = ACTIONS(984),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [234] = {
    [sym__literal] = STATE(772),
    [sym__primary] = STATE(772),
    [sym_array_creation_expression] = STATE(772),
    [sym_parenthesized_expression] = STATE(772),
    [sym_class_literal] = STATE(772),
    [sym_object_creation_expression] = STATE(772),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(623),
    [sym_array_access] = STATE(772),
    [sym_method_invocation] = STATE(772),
    [sym_method_reference] = STATE(772),
    [sym_resource] = STATE(848),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(501),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(524),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(524),
    [sym_integral_type] = STATE(524),
    [sym_floating_point_type] = STATE(524),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(982),
    [sym_decimal_integer_literal] = ACTIONS(984),
    [sym_hex_integer_literal] = ACTIONS(984),
    [sym_octal_integer_literal] = ACTIONS(986),
    [sym_binary_integer_literal] = ACTIONS(986),
    [sym_decimal_floating_point_literal] = ACTIONS(986),
    [sym_hex_floating_point_literal] = ACTIONS(984),
    [sym_true] = ACTIONS(984),
    [sym_false] = ACTIONS(984),
    [sym_character_literal] = ACTIONS(986),
    [sym_string_literal] = ACTIONS(986),
    [sym_null_literal] = ACTIONS(984),
    [anon_sym_LPAREN] = ACTIONS(988),
    [anon_sym_RPAREN] = ACTIONS(998),
    [anon_sym_new] = ACTIONS(992),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(994),
    [anon_sym_module] = ACTIONS(994),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(996),
    [sym_void_type] = ACTIONS(996),
    [sym_this] = ACTIONS(984),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [235] = {
    [sym_identifier] = ACTIONS(1000),
    [sym_decimal_integer_literal] = ACTIONS(1000),
    [sym_hex_integer_literal] = ACTIONS(1000),
    [sym_octal_integer_literal] = ACTIONS(1002),
    [sym_binary_integer_literal] = ACTIONS(1002),
    [sym_decimal_floating_point_literal] = ACTIONS(1002),
    [sym_hex_floating_point_literal] = ACTIONS(1000),
    [sym_true] = ACTIONS(1000),
    [sym_false] = ACTIONS(1000),
    [sym_character_literal] = ACTIONS(1002),
    [sym_string_literal] = ACTIONS(1002),
    [sym_null_literal] = ACTIONS(1000),
    [anon_sym_LPAREN] = ACTIONS(1002),
    [anon_sym_PLUS] = ACTIONS(1000),
    [anon_sym_DASH] = ACTIONS(1000),
    [anon_sym_BANG] = ACTIONS(1002),
    [anon_sym_TILDE] = ACTIONS(1002),
    [anon_sym_PLUS_PLUS] = ACTIONS(1002),
    [anon_sym_DASH_DASH] = ACTIONS(1002),
    [anon_sym_new] = ACTIONS(1000),
    [anon_sym_class] = ACTIONS(1000),
    [anon_sym_SEMI] = ACTIONS(1002),
    [anon_sym_LBRACE] = ACTIONS(1002),
    [anon_sym_RBRACE] = ACTIONS(1002),
    [anon_sym_assert] = ACTIONS(1000),
    [anon_sym_switch] = ACTIONS(1000),
    [anon_sym_case] = ACTIONS(1000),
    [anon_sym_default] = ACTIONS(1000),
    [anon_sym_do] = ACTIONS(1000),
    [anon_sym_while] = ACTIONS(1000),
    [anon_sym_break] = ACTIONS(1000),
    [anon_sym_continue] = ACTIONS(1000),
    [anon_sym_return] = ACTIONS(1000),
    [anon_sym_synchronized] = ACTIONS(1000),
    [anon_sym_throw] = ACTIONS(1000),
    [anon_sym_try] = ACTIONS(1000),
    [anon_sym_if] = ACTIONS(1000),
    [anon_sym_for] = ACTIONS(1000),
    [anon_sym_AT] = ACTIONS(1000),
    [anon_sym_open] = ACTIONS(1000),
    [anon_sym_module] = ACTIONS(1000),
    [anon_sym_static] = ACTIONS(1000),
    [anon_sym_package] = ACTIONS(1000),
    [anon_sym_import] = ACTIONS(1000),
    [anon_sym_enum] = ACTIONS(1000),
    [anon_sym_public] = ACTIONS(1000),
    [anon_sym_protected] = ACTIONS(1000),
    [anon_sym_private] = ACTIONS(1000),
    [anon_sym_abstract] = ACTIONS(1000),
    [anon_sym_final] = ACTIONS(1000),
    [anon_sym_strictfp] = ACTIONS(1000),
    [anon_sym_native] = ACTIONS(1000),
    [anon_sym_transient] = ACTIONS(1000),
    [anon_sym_volatile] = ACTIONS(1000),
    [anon_sym_ATinterface] = ACTIONS(1002),
    [anon_sym_interface] = ACTIONS(1000),
    [anon_sym_byte] = ACTIONS(1000),
    [anon_sym_short] = ACTIONS(1000),
    [anon_sym_int] = ACTIONS(1000),
    [anon_sym_long] = ACTIONS(1000),
    [anon_sym_char] = ACTIONS(1000),
    [anon_sym_float] = ACTIONS(1000),
    [anon_sym_double] = ACTIONS(1000),
    [sym_boolean_type] = ACTIONS(1000),
    [sym_void_type] = ACTIONS(1000),
    [sym_this] = ACTIONS(1000),
    [sym_super] = ACTIONS(1000),
    [sym_comment] = ACTIONS(3),
  },
  [236] = {
    [sym_identifier] = ACTIONS(1004),
    [sym_decimal_integer_literal] = ACTIONS(1004),
    [sym_hex_integer_literal] = ACTIONS(1004),
    [sym_octal_integer_literal] = ACTIONS(1006),
    [sym_binary_integer_literal] = ACTIONS(1006),
    [sym_decimal_floating_point_literal] = ACTIONS(1006),
    [sym_hex_floating_point_literal] = ACTIONS(1004),
    [sym_true] = ACTIONS(1004),
    [sym_false] = ACTIONS(1004),
    [sym_character_literal] = ACTIONS(1006),
    [sym_string_literal] = ACTIONS(1006),
    [sym_null_literal] = ACTIONS(1004),
    [anon_sym_LPAREN] = ACTIONS(1006),
    [anon_sym_PLUS] = ACTIONS(1004),
    [anon_sym_DASH] = ACTIONS(1004),
    [anon_sym_BANG] = ACTIONS(1006),
    [anon_sym_TILDE] = ACTIONS(1006),
    [anon_sym_PLUS_PLUS] = ACTIONS(1006),
    [anon_sym_DASH_DASH] = ACTIONS(1006),
    [anon_sym_new] = ACTIONS(1004),
    [anon_sym_class] = ACTIONS(1004),
    [anon_sym_SEMI] = ACTIONS(1006),
    [anon_sym_LBRACE] = ACTIONS(1006),
    [anon_sym_RBRACE] = ACTIONS(1006),
    [anon_sym_assert] = ACTIONS(1004),
    [anon_sym_switch] = ACTIONS(1004),
    [anon_sym_case] = ACTIONS(1004),
    [anon_sym_default] = ACTIONS(1004),
    [anon_sym_do] = ACTIONS(1004),
    [anon_sym_while] = ACTIONS(1004),
    [anon_sym_break] = ACTIONS(1004),
    [anon_sym_continue] = ACTIONS(1004),
    [anon_sym_return] = ACTIONS(1004),
    [anon_sym_synchronized] = ACTIONS(1004),
    [anon_sym_throw] = ACTIONS(1004),
    [anon_sym_try] = ACTIONS(1004),
    [anon_sym_if] = ACTIONS(1004),
    [anon_sym_for] = ACTIONS(1004),
    [anon_sym_AT] = ACTIONS(1004),
    [anon_sym_open] = ACTIONS(1004),
    [anon_sym_module] = ACTIONS(1004),
    [anon_sym_static] = ACTIONS(1004),
    [anon_sym_package] = ACTIONS(1004),
    [anon_sym_import] = ACTIONS(1004),
    [anon_sym_enum] = ACTIONS(1004),
    [anon_sym_public] = ACTIONS(1004),
    [anon_sym_protected] = ACTIONS(1004),
    [anon_sym_private] = ACTIONS(1004),
    [anon_sym_abstract] = ACTIONS(1004),
    [anon_sym_final] = ACTIONS(1004),
    [anon_sym_strictfp] = ACTIONS(1004),
    [anon_sym_native] = ACTIONS(1004),
    [anon_sym_transient] = ACTIONS(1004),
    [anon_sym_volatile] = ACTIONS(1004),
    [anon_sym_ATinterface] = ACTIONS(1006),
    [anon_sym_interface] = ACTIONS(1004),
    [anon_sym_byte] = ACTIONS(1004),
    [anon_sym_short] = ACTIONS(1004),
    [anon_sym_int] = ACTIONS(1004),
    [anon_sym_long] = ACTIONS(1004),
    [anon_sym_char] = ACTIONS(1004),
    [anon_sym_float] = ACTIONS(1004),
    [anon_sym_double] = ACTIONS(1004),
    [sym_boolean_type] = ACTIONS(1004),
    [sym_void_type] = ACTIONS(1004),
    [sym_this] = ACTIONS(1004),
    [sym_super] = ACTIONS(1004),
    [sym_comment] = ACTIONS(3),
  },
  [237] = {
    [sym__literal] = STATE(772),
    [sym__primary] = STATE(772),
    [sym_array_creation_expression] = STATE(772),
    [sym_parenthesized_expression] = STATE(772),
    [sym_class_literal] = STATE(772),
    [sym_object_creation_expression] = STATE(772),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(623),
    [sym_array_access] = STATE(772),
    [sym_method_invocation] = STATE(772),
    [sym_method_reference] = STATE(772),
    [sym_resource] = STATE(848),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(501),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(524),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(524),
    [sym_integral_type] = STATE(524),
    [sym_floating_point_type] = STATE(524),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(982),
    [sym_decimal_integer_literal] = ACTIONS(984),
    [sym_hex_integer_literal] = ACTIONS(984),
    [sym_octal_integer_literal] = ACTIONS(986),
    [sym_binary_integer_literal] = ACTIONS(986),
    [sym_decimal_floating_point_literal] = ACTIONS(986),
    [sym_hex_floating_point_literal] = ACTIONS(984),
    [sym_true] = ACTIONS(984),
    [sym_false] = ACTIONS(984),
    [sym_character_literal] = ACTIONS(986),
    [sym_string_literal] = ACTIONS(986),
    [sym_null_literal] = ACTIONS(984),
    [anon_sym_LPAREN] = ACTIONS(988),
    [anon_sym_new] = ACTIONS(992),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(994),
    [anon_sym_module] = ACTIONS(994),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(996),
    [sym_void_type] = ACTIONS(996),
    [sym_this] = ACTIONS(984),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [238] = {
    [sym__literal] = STATE(772),
    [sym__primary] = STATE(772),
    [sym_array_creation_expression] = STATE(772),
    [sym_parenthesized_expression] = STATE(772),
    [sym_class_literal] = STATE(772),
    [sym_object_creation_expression] = STATE(772),
    [sym__unqualified_object_creation_expression] = STATE(307),
    [sym_field_access] = STATE(623),
    [sym_array_access] = STATE(772),
    [sym_method_invocation] = STATE(772),
    [sym_method_reference] = STATE(772),
    [sym_resource] = STATE(717),
    [sym__annotation] = STATE(469),
    [sym_marker_annotation] = STATE(469),
    [sym_annotation] = STATE(469),
    [sym_modifiers] = STATE(501),
    [sym__type] = STATE(904),
    [sym__unannotated_type] = STATE(524),
    [sym_annotated_type] = STATE(904),
    [sym_scoped_type_identifier] = STATE(528),
    [sym_generic_type] = STATE(552),
    [sym_array_type] = STATE(524),
    [sym_integral_type] = STATE(524),
    [sym_floating_point_type] = STATE(524),
    [aux_sym_dimensions_expr_repeat1] = STATE(472),
    [aux_sym_modifiers_repeat1] = STATE(399),
    [sym_identifier] = ACTIONS(982),
    [sym_decimal_integer_literal] = ACTIONS(984),
    [sym_hex_integer_literal] = ACTIONS(984),
    [sym_octal_integer_literal] = ACTIONS(986),
    [sym_binary_integer_literal] = ACTIONS(986),
    [sym_decimal_floating_point_literal] = ACTIONS(986),
    [sym_hex_floating_point_literal] = ACTIONS(984),
    [sym_true] = ACTIONS(984),
    [sym_false] = ACTIONS(984),
    [sym_character_literal] = ACTIONS(986),
    [sym_string_literal] = ACTIONS(986),
    [sym_null_literal] = ACTIONS(984),
    [anon_sym_LPAREN] = ACTIONS(988),
    [anon_sym_new] = ACTIONS(992),
    [anon_sym_default] = ACTIONS(439),
    [anon_sym_synchronized] = ACTIONS(439),
    [anon_sym_AT] = ACTIONS(441),
    [anon_sym_open] = ACTIONS(994),
    [anon_sym_module] = ACTIONS(994),
    [anon_sym_static] = ACTIONS(439),
    [anon_sym_public] = ACTIONS(439),
    [anon_sym_protected] = ACTIONS(439),
    [anon_sym_private] = ACTIONS(439),
    [anon_sym_abstract] = ACTIONS(439),
    [anon_sym_final] = ACTIONS(439),
    [anon_sym_strictfp] = ACTIONS(439),
    [anon_sym_native] = ACTIONS(439),
    [anon_sym_transient] = ACTIONS(439),
    [anon_sym_volatile] = ACTIONS(439),
    [anon_sym_byte] = ACTIONS(71),
    [anon_sym_short] = ACTIONS(71),
    [anon_sym_int] = ACTIONS(71),
    [anon_sym_long] = ACTIONS(71),
    [anon_sym_char] = ACTIONS(71),
    [anon_sym_float] = ACTIONS(73),
    [anon_sym_double] = ACTIONS(73),
    [sym_boolean_type] = ACTIONS(996),
    [sym_void_type] = ACTIONS(996),
    [sym_this] = ACTIONS(984),
    [sym_super] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
  },
  [239] = {
    [sym_identifier] = ACTIONS(1008),
    [sym_decimal_integer_literal] = ACTIONS(1008),
    [sym_hex_integer_literal] = ACTIONS(1008),
    [sym_octal_integer_literal] = ACTIONS(1010),
    [sym_binary_integer_literal] = ACTIONS(1010),
    [sym_decimal_floating_point_literal] = ACTIONS(1010),
    [sym_hex_floating_point_literal] = ACTIONS(1008),
    [sym_true] = ACTIONS(1008),
    [sym_false] = ACTIONS(1008),
    [sym_character_literal] = ACTIONS(1010),
    [sym_string_literal] = ACTIONS(1010),
    [sym_null_literal] = ACTIONS(1008),
    [anon_sym_LPAREN] = ACTIONS(1010),
    [anon_sym_PLUS] = ACTIONS(1008),
    [anon_sym_DASH] = ACTIONS(1008),
    [anon_sym_BANG] = ACTIONS(1010),
    [anon_sym_TILDE] = ACTIONS(1010),
    [anon_sym_PLUS_PLUS] = ACTIONS(1010),
    [anon_sym_DASH_DASH] = ACTIONS(1010),
    [anon_sym_new] = ACTIONS(1008),
    [anon_sym_class] = ACTIONS(1008),
    [anon_sym_SEMI] = ACTIONS(1010),
    [anon_sym_LBRACE] = ACTIONS(1010),
    [anon_sym_RBRACE] = ACTIONS(1010),
    [anon_sym_assert] = ACTIONS(1008),
    [anon_sym_switch] = ACTIONS(1008),
    [anon_sym_default] = ACTIONS(1008),
    [anon_sym_do] = ACTIONS(1008),
    [anon_sym_while] = ACTIONS(1008),
    [anon_sym_break] = ACTIONS(1008),
    [anon_sym_continue] = ACTIONS(1008),
    [anon_sym_return] = ACTIONS(1008),
    [anon_sym_synchronized] = ACTIONS(1008),
    [anon_sym_throw] = ACTIONS(1008),
    [anon_sym_try] = ACTIONS(1008),
    [anon_sym_if] = ACTIONS(1008),
    [anon_sym_for] = ACTIONS(1008),
    [anon_sym_AT] = ACTIONS(1008),
    [anon_sym_open] = ACTIONS(1008),
    [anon_sym_module] = ACTIONS(1008),
    [anon_sym_static] = ACTIONS(1008),
    [anon_sym_package] = ACTIONS(1008),
    [anon_sym_import] = ACTIONS(1008),
    [anon_sym_enum] = ACTIONS(1008),
    [anon_sym_public] = ACTIONS(1008),
    [anon_sym_protected] = ACTIONS(1008),
    [anon_sym_private] = ACTIONS(1008),
    [anon_sym_abstract] = ACTIONS(1008),
    [anon_sym_final] = ACTIONS(1008),
    [anon_sym_strictfp] = ACTIONS(1008),
    [anon_sym_native] = ACTIONS(1008),
    [anon_sym_transient] = ACTIONS(1008),
    [anon_sym_volatile] = ACTIONS(1008),
    [anon_sym_ATinterface] = ACTIONS(1010),
    [anon_sym_interface] = ACTIONS(1008),
    [anon_sym_byte] = ACTIONS(1008),
    [anon_sym_short] = ACTIONS(1008),
    [anon_sym_int] = ACTIONS(1008),
    [anon_sym_long] = ACTIONS(1008),
    [anon_sym_char] = ACTIONS(1008),
    [anon_sym_float] = ACTIONS(1008),
    [anon_sym_double] = ACTIONS(1008),
    [sym_boolean_type] = ACTIONS(1008),
    [sym_void_type] = ACTIONS(1008),
    [sym_this] = ACTIONS(1008),
    [sym_super] = ACTIONS(1008),
    [sym_comment] = ACTIONS(3),
  },
  [240] = {
    [sym_identifier] = ACTIONS(1012),
    [sym_decimal_integer_literal] = ACTIONS(1012),
    [sym_hex_integer_literal] = ACTIONS(1012),
    [sym_octal_integer_literal] = ACTIONS(1014),
    [sym_binary_integer_literal] = ACTIONS(1014),
    [sym_decimal_floating_point_literal] = ACTIONS(1014),
    [sym_hex_floating_point_literal] = ACTIONS(1012),
    [sym_true] = ACTIONS(1012),
    [sym_false] = ACTIONS(1012),
    [sym_character_literal] = ACTIONS(1014),
    [sym_string_literal] = ACTIONS(1014),
    [sym_null_literal] = ACTIONS(1012),
    [anon_sym_LPAREN] = ACTIONS(1014),
    [anon_sym_PLUS] = ACTIONS(1012),
    [anon_sym_DASH] = ACTIONS(1012),
    [anon_sym_BANG] = ACTIONS(1014),
    [anon_sym_TILDE] = ACTIONS(1014),
    [anon_sym_PLUS_PLUS] = ACTIONS(1014),
    [anon_sym_DASH_DASH] = ACTIONS(1014),
    [anon_sym_new] = ACTIONS(1012),
    [anon_sym_class] = ACTIONS(1012),
    [anon_sym_SEMI] = ACTIONS(1014),
    [anon_sym_LBRACE] = ACTIONS(1014),
    [anon_sym_RBRACE] = ACTIONS(1014),
    [anon_sym_assert] = ACTIONS(1012),
    [anon_sym_switch] = ACTIONS(1012),
    [anon_sym_default] = ACTIONS(1012),
    [anon_sym_do] = ACTIONS(1012),
    [anon_sym_while] = ACTIONS(1012),
    [anon_sym_break] = ACTIONS(1012),
    [anon_sym_continue] = ACTIONS(1012),
    [anon_sym_return] = ACTIONS(1012),
    [anon_sym_synchronized] = ACTIONS(1012),
    [anon_sym_throw] = ACTIONS(1012),
    [anon_sym_try] = ACTIONS(1012),
    [anon_sym_if] = ACTIONS(1012),
    [anon_sym_for] = ACTIONS(1012),
    [anon_sym_AT] = ACTIONS(1012),
    [anon_sym_open] = ACTIONS(1012),
    [anon_sym_module] = ACTIONS(1012),
    [anon_sym_static] = ACTIONS(1012),
    [anon_sym_package] = ACTIONS(1012),
    [anon_sym_import] = ACTIONS(1012),
    [anon_sym_enum] = ACTIONS(1012),
    [anon_sym_public] = ACTIONS(1012),
    [anon_sym_protected] = ACTIONS(1012),
    [anon_sym_private] = ACTIONS(1012),
    [anon_sym_abstract] = ACTIONS(1012),
    [anon_sym_final] = ACTIONS(1012),
    [anon_sym_strictfp] = ACTIONS(1012),
    [anon_sym_native] = ACTIONS(1012),
    [anon_sym_transient] = ACTIONS(1012),
    [anon_sym_volatile] = ACTIONS(1012),
    [anon_sym_ATinterface] = ACTIONS(1014),
    [anon_sym_interface] = ACTIONS(1012),
    [anon_sym_byte] = ACTIONS(1012),
    [anon_sym_short] = ACTIONS(1012),
    [anon_sym_int] = ACTIONS(1012),
    [anon_sym_long] = ACTIONS(1012),
    [anon_sym_char] = ACTIONS(1012),
    [anon_sym_float] = ACTIONS(1012),
    [anon_sym_double] = ACTIONS(1012),
    [sym_boolean_type] = ACTIONS(1012),
    [sym_void_type] = ACTIONS(1012),
    [sym_this] = ACTIONS(1012),
    [sym_super] = ACTIONS(1012),
    [sym_comment] = ACTIONS(3),
  },
  [241] = {
    [sym_identifier] = ACTIONS(1016),
    [sym_decimal_integer_literal] = ACTIONS(1016),
    [sym_hex_integer_literal] = ACTIONS(1016),
    [sym_octal_integer_literal] = ACTIONS(1018),
    [sym_binary_integer_literal] = ACTIONS(1018),
    [sym_decimal_floating_point_literal] = ACTIONS(1018),
    [sym_hex_floating_point_literal] = ACTIONS(1016),
    [sym_true] = ACTIONS(1016),
    [sym_false] = ACTIONS(1016),
    [sym_character_literal] = ACTIONS(1018),
    [sym_string_literal] = ACTIONS(1018),
    [sym_null_literal] = ACTIONS(1016),
    [anon_sym_LPAREN] = ACTIONS(1018),
    [anon_sym_PLUS] = ACTIONS(1016),
    [anon_sym_DASH] = ACTIONS(1016),
    [anon_sym_BANG] = ACTIONS(1018),
    [anon_sym_TILDE] = ACTIONS(1018),
    [anon_sym_PLUS_PLUS] = ACTIONS(1018),
    [anon_sym_DASH_DASH] = ACTIONS(1018),
    [anon_sym_new] = ACTIONS(1016),
    [anon_sym_class] = ACTIONS(1016),
    [anon_sym_SEMI] = ACTIONS(1018),
    [anon_sym_LBRACE] = ACTIONS(1018),
    [anon_sym_RBRACE] = ACTIONS(1018),
    [anon_sym_assert] = ACTIONS(1016),
    [anon_sym_switch] = ACTIONS(1016),
    [anon_sym_default] = ACTIONS(1016),
    [anon_sym_do] = ACTIONS(1016),
    [anon_sym_while] = ACTIONS(1016),
    [anon_sym_break] = ACTIONS(1016),
    [anon_sym_continue] = ACTIONS(1016),
    [anon_sym_return] = ACTIONS(1016),
    [anon_sym_synchronized] = ACTIONS(1016),
    [anon_sym_throw] = ACTIONS(1016),
    [anon_sym_try] = ACTIONS(1016),
    [anon_sym_if] = ACTIONS(1016),
    [anon_sym_for] = ACTIONS(1016),
    [anon_sym_AT] = ACTIONS(1016),
    [anon_sym_open] = ACTIONS(1016),
    [anon_sym_module] = ACTIONS(1016),
    [anon_sym_static] = ACTIONS(1016),
    [anon_sym_package] = ACTIONS(1016),
    [anon_sym_import] = ACTIONS(1016),
    [anon_sym_enum] = ACTIONS(1016),
    [anon_sym_public] = ACTIONS(1016),
    [anon_sym_protected] = ACTIONS(1016),
    [anon_sym_private] = ACTIONS(1016),
    [anon_sym_abstract] = ACTIONS(1016),
    [anon_sym_final] = ACTIONS(1016),
    [anon_sym_strictfp] = ACTIONS(1016),
    [anon_sym_native] = ACTIONS(1016),
    [anon_sym_transient] = ACTIONS(1016),
    [anon_sym_volatile] = ACTIONS(1016),
    [anon_sym_ATinterface] = ACTIONS(1018),
    [anon_sym_interface] = ACTIONS(1016),
    [anon_sym_byte] = ACTIONS(1016),
    [anon_sym_short] = ACTIONS(1016),
    [anon_sym_int] = ACTIONS(1016),
    [anon_sym_long] = ACTIONS(1016),
    [anon_sym_char] = ACTIONS(1016),
    [anon_sym_float] = ACTIONS(1016),
    [anon_sym_double] = ACTIONS(1016),
    [sym_boolean_type] = ACTIONS(1016),
    [sym_void_type] = ACTIONS(1016),
    [sym_this] = ACTIONS(1016),
    [sym_super] = ACTIONS(1016),
    [sym_comment] = ACTIONS(3),
  },
  [242] = {
    [sym_identifier] = ACTIONS(1020),
    [sym_decimal_integer_literal] = ACTIONS(1020),
    [sym_hex_integer_literal] = ACTIONS(1020),
    [sym_octal_integer_literal] = ACTIONS(1022),
    [sym_binary_integer_literal] = ACTIONS(1022),
    [sym_decimal_floating_point_literal] = ACTIONS(1022),
    [sym_hex_floating_point_literal] = ACTIONS(1020),
    [sym_true] = ACTIONS(1020),
    [sym_false] = ACTIONS(1020),
    [sym_character_literal] = ACTIONS(1022),
    [sym_string_literal] = ACTIONS(1022),
    [sym_null_literal] = ACTIONS(1020),
    [anon_sym_LPAREN] = ACTIONS(1022),
    [anon_sym_PLUS] = ACTIONS(1020),
    [anon_sym_DASH] = ACTIONS(1020),
    [anon_sym_BANG] = ACTIONS(1022),
    [anon_sym_TILDE] = ACTIONS(1022),
    [anon_sym_PLUS_PLUS] = ACTIONS(1022),
    [anon_sym_DASH_DASH] = ACTIONS(1022),
    [anon_sym_new] = ACTIONS(1020),
    [anon_sym_class] = ACTIONS(1020),
    [anon_sym_SEMI] = ACTIONS(1022),
    [anon_sym_LBRACE] = ACTIONS(1022),
    [anon_sym_RBRACE] = ACTIONS(1022),
    [anon_sym_assert] = ACTIONS(1020),
    [anon_sym_switch] = ACTIONS(1020),
    [anon_sym_default] = ACTIONS(1020),
    [anon_sym_do] = ACTIONS(1020),
    [anon_sym_while] = ACTIONS(1020),
    [anon_sym_break] = ACTIONS(1020),
    [anon_sym_continue] = ACTIONS(1020),
    [anon_sym_return] = ACTIONS(1020),
    [anon_sym_synchronized] = ACTIONS(1020),
    [anon_sym_throw] = ACTIONS(1020),
    [anon_sym_try] = ACTIONS(1020),
    [anon_sym_if] = ACTIONS(1020),
    [anon_sym_for] = ACTIONS(1020),
    [anon_sym_AT] = ACTIONS(1020),
    [anon_sym_open] = ACTIONS(1020),
    [anon_sym_module] = ACTIONS(1020),
    [anon_sym_static] = ACTIONS(1020),
    [anon_sym_package] = ACTIONS(1020),
    [anon_sym_import] = ACTIONS(1020),
    [anon_sym_enum] = ACTIONS(1020),
    [anon_sym_public] = ACTIONS(1020),
    [anon_sym_protected] = ACTIONS(1020),
    [anon_sym_private] = ACTIONS(1020),
    [anon_sym_abstract] = ACTIONS(1020),
    [anon_sym_final] = ACTIONS(1020),
    [anon_sym_strictfp] = ACTIONS(1020),
    [anon_sym_native] = ACTIONS(1020),
    [anon_sym_transient] = ACTIONS(1020),
    [anon_sym_volatile] = ACTIONS(1020),
    [anon_sym_ATinterface] = ACTIONS(1022),
    [anon_sym_interface] = ACTIONS(1020),
    [anon_sym_byte] = ACTIONS(1020),
    [anon_sym_short] = ACTIONS(1020),
    [anon_sym_int] = ACTIONS(1020),
    [anon_sym_long] = ACTIONS(1020),
    [anon_sym_char] = ACTIONS(1020),
    [anon_sym_float] = ACTIONS(1020),
    [anon_sym_double] = ACTIONS(1020),
    [sym_boolean_type] = ACTIONS(1020),
    [sym_void_type] = ACTIONS(1020),
    [sym_this] = ACTIONS(1020),
    [sym_super] = ACTIONS(1020),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1024), 1,
      sym_identifier,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1028), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_RBRACE,
    ACTIONS(1032), 1,
      anon_sym_static,
    STATE(449), 1,
      sym_modifiers,
    STATE(477), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(657), 1,
      sym__constructor_declarator,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1034), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(508), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(244), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [107] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1024), 1,
      sym_identifier,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1032), 1,
      anon_sym_static,
    ACTIONS(1036), 1,
      anon_sym_SEMI,
    ACTIONS(1038), 1,
      anon_sym_RBRACE,
    STATE(449), 1,
      sym_modifiers,
    STATE(477), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(657), 1,
      sym__constructor_declarator,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1034), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(508), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(246), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [214] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1024), 1,
      sym_identifier,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1032), 1,
      anon_sym_static,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
    ACTIONS(1042), 1,
      anon_sym_RBRACE,
    STATE(449), 1,
      sym_modifiers,
    STATE(477), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(657), 1,
      sym__constructor_declarator,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1034), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(508), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(247), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [321] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      sym_identifier,
    ACTIONS(1047), 1,
      anon_sym_LT,
    ACTIONS(1050), 1,
      anon_sym_class,
    ACTIONS(1053), 1,
      anon_sym_SEMI,
    ACTIONS(1056), 1,
      anon_sym_LBRACE,
    ACTIONS(1059), 1,
      anon_sym_RBRACE,
    ACTIONS(1064), 1,
      anon_sym_AT,
    ACTIONS(1067), 1,
      anon_sym_static,
    ACTIONS(1070), 1,
      anon_sym_enum,
    ACTIONS(1073), 1,
      anon_sym_ATinterface,
    ACTIONS(1076), 1,
      anon_sym_interface,
    STATE(449), 1,
      sym_modifiers,
    STATE(477), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(657), 1,
      sym__constructor_declarator,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(1082), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1085), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(508), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(1079), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(246), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(1061), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [428] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1024), 1,
      sym_identifier,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1032), 1,
      anon_sym_static,
    ACTIONS(1036), 1,
      anon_sym_SEMI,
    ACTIONS(1088), 1,
      anon_sym_RBRACE,
    STATE(449), 1,
      sym_modifiers,
    STATE(477), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(657), 1,
      sym__constructor_declarator,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1034), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(508), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(246), 10,
      sym_block,
      sym_enum_declaration,
      sym_class_declaration,
      sym_static_initializer,
      sym_constructor_declaration,
      sym_field_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_method_declaration,
      aux_sym_enum_body_declarations_repeat1,
    ACTIONS(33), 11,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [535] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1098), 1,
      anon_sym_EQ,
    ACTIONS(1102), 1,
      anon_sym_LT,
    ACTIONS(1105), 1,
      anon_sym_DASH_GT,
    ACTIONS(1110), 1,
      anon_sym_DOT,
    ACTIONS(1114), 1,
      anon_sym_AT,
    STATE(342), 1,
      sym_argument_list,
    STATE(490), 1,
      sym_type_arguments,
    ACTIONS(1107), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1090), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(1100), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1094), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COLON,
    ACTIONS(1096), 14,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [617] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1098), 1,
      anon_sym_EQ,
    ACTIONS(1102), 1,
      anon_sym_LT,
    ACTIONS(1105), 1,
      anon_sym_DASH_GT,
    ACTIONS(1116), 1,
      anon_sym_AMP,
    ACTIONS(1119), 1,
      anon_sym_RPAREN,
    ACTIONS(1123), 1,
      anon_sym_COMMA,
    ACTIONS(1125), 1,
      anon_sym_DOT,
    STATE(342), 1,
      sym_argument_list,
    STATE(490), 1,
      sym_type_arguments,
    STATE(787), 1,
      aux_sym_inferred_parameters_repeat1,
    ACTIONS(1107), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1114), 2,
      anon_sym_AT,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1090), 4,
      anon_sym_open,
      anon_sym_module,
      sym_this,
      sym_identifier,
    ACTIONS(1096), 9,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1100), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1094), 12,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [706] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 1,
      sym_identifier,
    ACTIONS(1132), 1,
      anon_sym_LT,
    ACTIONS(1135), 1,
      anon_sym_class,
    ACTIONS(1138), 1,
      anon_sym_SEMI,
    ACTIONS(1141), 1,
      anon_sym_RBRACE,
    ACTIONS(1146), 1,
      anon_sym_AT,
    ACTIONS(1149), 1,
      anon_sym_enum,
    ACTIONS(1152), 1,
      anon_sym_ATinterface,
    ACTIONS(1155), 1,
      anon_sym_interface,
    STATE(460), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(1161), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1164), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(509), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(1158), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(250), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(1143), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [802] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1169), 1,
      anon_sym_SEMI,
    ACTIONS(1171), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1173), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(509), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(250), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [898] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(65), 1,
      anon_sym_enum,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1026), 1,
      anon_sym_LT,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1175), 1,
      anon_sym_SEMI,
    ACTIONS(1177), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      sym_modifiers,
    STATE(473), 1,
      sym_type_parameters,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(714), 1,
      sym__method_header,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1173), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(509), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(251), 7,
      sym_enum_declaration,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      sym_method_declaration,
      aux_sym_interface_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [994] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1098), 1,
      anon_sym_EQ,
    ACTIONS(1102), 1,
      anon_sym_LT,
    ACTIONS(1105), 1,
      anon_sym_DASH_GT,
    ACTIONS(1110), 1,
      anon_sym_DOT,
    ACTIONS(1114), 1,
      anon_sym_AT,
    ACTIONS(1179), 1,
      anon_sym_COLON,
    STATE(342), 1,
      sym_argument_list,
    STATE(490), 1,
      sym_type_arguments,
    ACTIONS(1107), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1090), 3,
      anon_sym_open,
      anon_sym_module,
      sym_identifier,
    ACTIONS(1096), 10,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
    ACTIONS(1100), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1094), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(322), 1,
      sym_argument_list,
    ACTIONS(1181), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1183), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1132] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(335), 1,
      sym_argument_list,
    ACTIONS(1185), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1187), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1190] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(303), 1,
      sym_argument_list,
    ACTIONS(1189), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1191), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1248] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(314), 1,
      sym_argument_list,
    ACTIONS(1193), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1195), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1306] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      anon_sym_EQ,
    STATE(311), 1,
      sym_argument_list,
    ACTIONS(1203), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1197), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1199), 18,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1368] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      anon_sym_EQ,
    ACTIONS(1205), 1,
      sym_identifier,
    STATE(311), 1,
      sym_argument_list,
    STATE(726), 1,
      sym_scoped_identifier,
    ACTIONS(1207), 2,
      anon_sym_open,
      anon_sym_module,
    ACTIONS(1203), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1199), 13,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
    ACTIONS(1197), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
  [1435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1185), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1187), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1487] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 1,
      anon_sym_EQ,
    ACTIONS(1100), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1094), 14,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1096), 18,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1211), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1595] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1102), 1,
      anon_sym_LT,
    ACTIONS(1105), 1,
      anon_sym_DASH_GT,
    ACTIONS(1110), 1,
      anon_sym_DOT,
    ACTIONS(1114), 1,
      anon_sym_AT,
    ACTIONS(1213), 1,
      anon_sym_EQ,
    STATE(342), 1,
      sym_argument_list,
    STATE(490), 1,
      sym_type_arguments,
    ACTIONS(1107), 2,
      anon_sym_LBRACK,
      anon_sym_COLON_COLON,
    ACTIONS(1096), 11,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1100), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1094), 12,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
  [1667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1189), 15,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON,
    ACTIONS(1191), 29,
      anon_sym_RPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [1719] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_RBRACE,
    STATE(485), 1,
      sym_modifiers,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1217), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(519), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(266), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1799] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_class,
    ACTIONS(55), 1,
      anon_sym_AT,
    ACTIONS(67), 1,
      anon_sym_ATinterface,
    ACTIONS(69), 1,
      anon_sym_interface,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_RBRACE,
    STATE(485), 1,
      sym_modifiers,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1217), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(519), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(267), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(33), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1879] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1221), 1,
      sym_identifier,
    ACTIONS(1224), 1,
      anon_sym_class,
    ACTIONS(1227), 1,
      anon_sym_RBRACE,
    ACTIONS(1232), 1,
      anon_sym_AT,
    ACTIONS(1235), 1,
      anon_sym_ATinterface,
    ACTIONS(1238), 1,
      anon_sym_interface,
    STATE(485), 1,
      sym_modifiers,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    ACTIONS(1244), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1247), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(340), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(519), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(1241), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    STATE(267), 6,
      sym_class_declaration,
      sym_annotation_type_declaration,
      sym_annotation_type_element_declaration,
      sym_interface_declaration,
      sym_constant_declaration,
      aux_sym_annotation_type_body_repeat1,
    ACTIONS(1229), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [1959] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    ACTIONS(1201), 1,
      anon_sym_EQ,
    ACTIONS(1250), 1,
      anon_sym_module,
    STATE(311), 1,
      sym_argument_list,
    ACTIONS(1203), 11,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
    ACTIONS(1197), 13,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
    ACTIONS(1199), 14,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_instanceof,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
  [2019] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1256), 1,
      anon_sym_LBRACK,
    STATE(276), 1,
      aux_sym_dimensions_repeat1,
    STATE(329), 1,
      sym_dimensions,
    STATE(272), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(597), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1252), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1254), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2080] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1256), 1,
      anon_sym_LBRACK,
    STATE(276), 1,
      aux_sym_dimensions_repeat1,
    STATE(324), 1,
      sym_dimensions,
    STATE(272), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(597), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1258), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1260), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2141] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      anon_sym_RPAREN,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1167), 1,
      sym_identifier,
    STATE(279), 1,
      sym_receiver_parameter,
    STATE(399), 1,
      aux_sym_modifiers_repeat1,
    STATE(479), 1,
      aux_sym_dimensions_expr_repeat1,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(506), 1,
      sym_modifiers,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1262), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(704), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(469), 3,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
    STATE(525), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(439), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2216] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      anon_sym_LBRACK,
    ACTIONS(1271), 1,
      anon_sym_AT,
    STATE(272), 2,
      sym_dimensions_expr,
      aux_sym_array_creation_expression_repeat1,
    STATE(614), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1264), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1266), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1274), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2317] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1280), 7,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_ATinterface,
    ACTIONS(1278), 31,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_to,
      anon_sym_with,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2363] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 1,
      anon_sym_LBRACK,
    ACTIONS(1289), 1,
      anon_sym_AT,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1282), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1284), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2417] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1296), 1,
      anon_sym_LBRACK,
    STATE(275), 1,
      aux_sym_dimensions_repeat1,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1292), 9,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
      anon_sym_COLON,
    ACTIONS(1294), 22,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2471] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1296), 1,
      anon_sym_LBRACK,
    STATE(276), 1,
      aux_sym_dimensions_repeat1,
    STATE(364), 1,
      sym_dimensions,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1298), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1300), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2526] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1296), 1,
      anon_sym_LBRACK,
    STATE(276), 1,
      aux_sym_dimensions_repeat1,
    STATE(364), 1,
      sym_dimensions,
    STATE(582), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_dimensions_expr_repeat1,
    ACTIONS(1302), 8,
      anon_sym_AMP,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_GT_GT,
    ACTIONS(1304), 21,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_instanceof,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_RBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [2581] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1167), 1,
      sym_identifier,
    ACTIONS(1306), 1,
      anon_sym_RPAREN,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(506), 1,
      sym_modifiers,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1308), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(753), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(399), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(535), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(439), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2648] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1167), 1,
      sym_identifier,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(496), 1,
      sym_modifiers,
    STATE(497), 1,
      sym_generic_type,
    STATE(694), 1,
      sym_catch_type,
    STATE(893), 1,
      sym_catch_formal_parameter,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1310), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(399), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(532), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(439), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2714] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_AT,
    ACTIONS(1167), 1,
      sym_identifier,
    STATE(487), 1,
      sym_scoped_type_identifier,
    STATE(497), 1,
      sym_generic_type,
    STATE(506), 1,
      sym_modifiers,
    ACTIONS(73), 2,
      anon_sym_float,
      anon_sym_double,
    ACTIONS(1308), 2,
      sym_boolean_type,
      sym_void_type,
    STATE(834), 2,
      sym_formal_parameter,
      sym_spread_parameter,
    STATE(399), 4,
      sym__annotation,
      sym_marker_annotation,
      sym_annotation,
      aux_sym_modifiers_repeat1,
    STATE(535), 4,
      sym__unannotated_type,
      sym_array_type,
      sym_integral_type,
      sym_floating_point_type,
    ACTIONS(71), 5,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
    ACTIONS(439), 12,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_static,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
  [2778] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 1,
      anon_sym_LPAREN,
    ACTIONS(1318), 1,
      anon_sym_DOT,
    STATE(306), 1,
      sym_annotation_argument_list,
    ACTIONS(1316), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1312), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 12,
      sym_octal_integer_literal,
      sym_binary_integer_literal,
      sym_decimal_floating_point_literal,
      sym_character_literal,
      sym_string_literal,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
      anon_sym_AT,
    ACTIONS(710), 23,
      sym_decimal_integer_literal,
      sym_hex_integer_literal,
      sym_hex_floating_point_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      anon_sym_open,
      anon_sym_module,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_this,
      sym_super,
      sym_identifier,
  [2870] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1314), 1,
      anon_sym_LPAREN,
    ACTIONS(1324), 1,
      anon_sym_DOT,
    STATE(310), 1,
      sym_annotation_argument_list,
    ACTIONS(1322), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1320), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [2919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 12,
      sym_octal_integer_literal,
      sym_binary_integer_literal,
      sym_decimal_floating_point_literal,
      sym_character_literal,
      sym_string_literal,
      anon_sym_LPAREN,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_SEMI,
      anon_sym_AT,
    ACTIONS(934), 23,
      sym_decimal_integer_literal,
      sym_hex_integer_literal,
      sym_hex_floating_point_literal,
      sym_true,
      sym_false,
      sym_null_literal,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_new,
      anon_sym_open,
      anon_sym_module,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_this,
      sym_super,
      sym_identifier,
  [2962] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      anon_sym_LPAREN,
    ACTIONS(1328), 1,
      anon_sym_DOT,
    STATE(348), 1,
      sym_annotation_argument_list,
    ACTIONS(1322), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1320), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [3010] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      anon_sym_LPAREN,
    ACTIONS(1330), 1,
      anon_sym_DOT,
    STATE(361), 1,
      sym_annotation_argument_list,
    ACTIONS(1316), 2,
      anon_sym_LT,
      anon_sym_ATinterface,
    ACTIONS(1312), 29,
      anon_sym_class,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_AT,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_enum,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_interface,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [3058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
    ACTIONS(1274), 25,
      anon_sym_default,
      anon_sym_synchronized,
      anon_sym_open,
      anon_sym_module,
      anon_sym_static,
      anon_sym_package,
      anon_sym_public,
      anon_sym_protected,
      anon_sym_private,
      anon_sym_abstract,
      anon_sym_final,
      anon_sym_strictfp,
      anon_sym_native,
      anon_sym_transient,
      anon_sym_volatile,
      anon_sym_byte,
      anon_sym_short,
      anon_sym_int,
      anon_sym_long,
      anon_sym_char,
      anon_sym_float,
      anon_sym_double,
      sym_boolean_type,
      sym_void_type,
      sym_identifier,
  [3100] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 1,
      