#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1170
#define LARGE_STATE_COUNT 22
#define SYMBOL_COUNT 196
#define ALIAS_COUNT 4
#define TOKEN_COUNT 90
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 33
#define MAX_ALIAS_SEQUENCE_LENGTH 9

enum {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  anon_sym_package = 4,
  anon_sym_import = 5,
  anon_sym_DOT = 6,
  sym_blank_identifier = 7,
  anon_sym_LPAREN = 8,
  anon_sym_RPAREN = 9,
  anon_sym_const = 10,
  anon_sym_COMMA = 11,
  anon_sym_EQ = 12,
  anon_sym_var = 13,
  anon_sym_func = 14,
  anon_sym_DOT_DOT_DOT = 15,
  anon_sym_type = 16,
  anon_sym_STAR = 17,
  anon_sym_LBRACK = 18,
  anon_sym_RBRACK = 19,
  anon_sym_struct = 20,
  anon_sym_LBRACE = 21,
  anon_sym_RBRACE = 22,
  anon_sym_interface = 23,
  anon_sym_map = 24,
  anon_sym_chan = 25,
  anon_sym_LT_DASH = 26,
  anon_sym_COLON_EQ = 27,
  anon_sym_PLUS_PLUS = 28,
  anon_sym_DASH_DASH = 29,
  anon_sym_STAR_EQ = 30,
  anon_sym_SLASH_EQ = 31,
  anon_sym_PERCENT_EQ = 32,
  anon_sym_LT_LT_EQ = 33,
  anon_sym_GT_GT_EQ = 34,
  anon_sym_AMP_EQ = 35,
  anon_sym_AMP_CARET_EQ = 36,
  anon_sym_PLUS_EQ = 37,
  anon_sym_DASH_EQ = 38,
  anon_sym_PIPE_EQ = 39,
  anon_sym_CARET_EQ = 40,
  anon_sym_COLON = 41,
  anon_sym_fallthrough = 42,
  anon_sym_break = 43,
  anon_sym_continue = 44,
  anon_sym_goto = 45,
  anon_sym_return = 46,
  anon_sym_go = 47,
  anon_sym_defer = 48,
  anon_sym_if = 49,
  anon_sym_else = 50,
  anon_sym_for = 51,
  anon_sym_range = 52,
  anon_sym_switch = 53,
  anon_sym_case = 54,
  anon_sym_default = 55,
  anon_sym_select = 56,
  anon_sym_new = 57,
  anon_sym_make = 58,
  anon_sym_PLUS = 59,
  anon_sym_DASH = 60,
  anon_sym_BANG = 61,
  anon_sym_CARET = 62,
  anon_sym_AMP = 63,
  anon_sym_SLASH = 64,
  anon_sym_PERCENT = 65,
  anon_sym_LT_LT = 66,
  anon_sym_GT_GT = 67,
  anon_sym_AMP_CARET = 68,
  anon_sym_PIPE = 69,
  anon_sym_EQ_EQ = 70,
  anon_sym_BANG_EQ = 71,
  anon_sym_LT = 72,
  anon_sym_LT_EQ = 73,
  anon_sym_GT = 74,
  anon_sym_GT_EQ = 75,
  anon_sym_AMP_AMP = 76,
  anon_sym_PIPE_PIPE = 77,
  sym_raw_string_literal = 78,
  anon_sym_DQUOTE = 79,
  aux_sym_interpreted_string_literal_token1 = 80,
  sym_escape_sequence = 81,
  sym_int_literal = 82,
  sym_float_literal = 83,
  sym_imaginary_literal = 84,
  sym_rune_literal = 85,
  sym_nil = 86,
  sym_true = 87,
  sym_false = 88,
  sym_comment = 89,
  sym_source_file = 90,
  sym_package_clause = 91,
  sym_import_declaration = 92,
  sym_import_spec = 93,
  sym_dot = 94,
  sym_import_spec_list = 95,
  sym__declaration = 96,
  sym_const_declaration = 97,
  sym_const_spec = 98,
  sym_var_declaration = 99,
  sym_var_spec = 100,
  sym_function_declaration = 101,
  sym_method_declaration = 102,
  sym_parameter_list = 103,
  sym_parameter_declaration = 104,
  sym_variadic_parameter_declaration = 105,
  sym_type_alias = 106,
  sym_type_declaration = 107,
  sym_type_spec = 108,
  sym_expression_list = 109,
  sym_parenthesized_type = 110,
  sym__simple_type = 111,
  sym_pointer_type = 112,
  sym_array_type = 113,
  sym_implicit_length_array_type = 114,
  sym_slice_type = 115,
  sym_struct_type = 116,
  sym_field_declaration_list = 117,
  sym_field_declaration = 118,
  sym_interface_type = 119,
  sym_method_spec_list = 120,
  sym_method_spec = 121,
  sym_map_type = 122,
  sym_channel_type = 123,
  sym_function_type = 124,
  sym_block = 125,
  sym__statement_list = 126,
  sym__statement = 127,
  sym_empty_statement = 128,
  sym__simple_statement = 129,
  sym_send_statement = 130,
  sym_receive_statement = 131,
  sym_inc_statement = 132,
  sym_dec_statement = 133,
  sym_assignment_statement = 134,
  sym_short_var_declaration = 135,
  sym_labeled_statement = 136,
  sym_empty_labeled_statement = 137,
  sym_fallthrough_statement = 138,
  sym_break_statement = 139,
  sym_continue_statement = 140,
  sym_goto_statement = 141,
  sym_return_statement = 142,
  sym_go_statement = 143,
  sym_defer_statement = 144,
  sym_if_statement = 145,
  sym_for_statement = 146,
  sym_for_clause = 147,
  sym_range_clause = 148,
  sym_expression_switch_statement = 149,
  sym_expression_case = 150,
  sym_default_case = 151,
  sym_type_switch_statement = 152,
  sym__type_switch_header = 153,
  sym_type_case = 154,
  sym_select_statement = 155,
  sym_communication_case = 156,
  sym__expression = 157,
  sym_parenthesized_expression = 158,
  sym_call_expression = 159,
  sym_variadic_argument = 160,
  sym_special_argument_list = 161,
  sym_argument_list = 162,
  sym_selector_expression = 163,
  sym_index_expression = 164,
  sym_slice_expression = 165,
  sym_type_assertion_expression = 166,
  sym_type_conversion_expression = 167,
  sym_composite_literal = 168,
  sym_literal_value = 169,
  sym_keyed_element = 170,
  sym_element = 171,
  sym_func_literal = 172,
  sym_unary_expression = 173,
  sym_binary_expression = 174,
  sym_qualified_type = 175,
  sym_interpreted_string_literal = 176,
  aux_sym_source_file_repeat1 = 177,
  aux_sym_import_spec_list_repeat1 = 178,
  aux_sym_const_declaration_repeat1 = 179,
  aux_sym_const_spec_repeat1 = 180,
  aux_sym_var_declaration_repeat1 = 181,
  aux_sym_parameter_list_repeat1 = 182,
  aux_sym_type_declaration_repeat1 = 183,
  aux_sym_field_name_list_repeat1 = 184,
  aux_sym_expression_list_repeat1 = 185,
  aux_sym_field_declaration_list_repeat1 = 186,
  aux_sym_method_spec_list_repeat1 = 187,
  aux_sym__statement_list_repeat1 = 188,
  aux_sym_expression_switch_statement_repeat1 = 189,
  aux_sym_type_switch_statement_repeat1 = 190,
  aux_sym_type_case_repeat1 = 191,
  aux_sym_select_statement_repeat1 = 192,
  aux_sym_argument_list_repeat1 = 193,
  aux_sym_literal_value_repeat1 = 194,
  aux_sym_interpreted_string_literal_repeat1 = 195,
  alias_sym_field_identifier = 196,
  alias_sym_label_name = 197,
  alias_sym_package_identifier = 198,
  alias_sym_type_identifier = 199,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [sym_blank_identifier] = "blank_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_const] = "const",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_type] = "type",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_struct] = "struct",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_interface] = "interface",
  [anon_sym_map] = "map",
  [anon_sym_chan] = "chan",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_AMP_CARET_EQ] = "&^=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_COLON] = ":",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_return] = "return",
  [anon_sym_go] = "go",
  [anon_sym_defer] = "defer",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_range] = "range",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_select] = "select",
  [anon_sym_new] = "identifier",
  [anon_sym_make] = "identifier",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_CARET] = "&^",
  [anon_sym_PIPE] = "|",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_imaginary_literal] = "imaginary_literal",
  [sym_rune_literal] = "rune_literal",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_dot] = "dot",
  [sym_import_spec_list] = "import_spec_list",
  [sym__declaration] = "_declaration",
  [sym_const_declaration] = "const_declaration",
  [sym_const_spec] = "const_spec",
  [sym_var_declaration] = "var_declaration",
  [sym_var_spec] = "var_spec",
  [sym_function_declaration] = "function_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_type_alias] = "type_alias",
  [sym_type_declaration] = "type_declaration",
  [sym_type_spec] = "type_spec",
  [sym_expression_list] = "expression_list",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym__simple_type] = "_simple_type",
  [sym_pointer_type] = "pointer_type",
  [sym_array_type] = "array_type",
  [sym_implicit_length_array_type] = "implicit_length_array_type",
  [sym_slice_type] = "slice_type",
  [sym_struct_type] = "struct_type",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_type] = "interface_type",
  [sym_method_spec_list] = "method_spec_list",
  [sym_method_spec] = "method_spec",
  [sym_map_type] = "map_type",
  [sym_channel_type] = "channel_type",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym__statement_list] = "_statement_list",
  [sym__statement] = "_statement",
  [sym_empty_statement] = "empty_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_send_statement] = "send_statement",
  [sym_receive_statement] = "receive_statement",
  [sym_inc_statement] = "inc_statement",
  [sym_dec_statement] = "dec_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_short_var_declaration] = "short_var_declaration",
  [sym_labeled_statement] = "labeled_statement",
  [sym_empty_labeled_statement] = "labeled_statement",
  [sym_fallthrough_statement] = "fallthrough_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_return_statement] = "return_statement",
  [sym_go_statement] = "go_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_clause] = "for_clause",
  [sym_range_clause] = "range_clause",
  [sym_expression_switch_statement] = "expression_switch_statement",
  [sym_expression_case] = "expression_case",
  [sym_default_case] = "default_case",
  [sym_type_switch_statement] = "type_switch_statement",
  [sym__type_switch_header] = "_type_switch_header",
  [sym_type_case] = "type_case",
  [sym_select_statement] = "select_statement",
  [sym_communication_case] = "communication_case",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call_expression] = "call_expression",
  [sym_variadic_argument] = "variadic_argument",
  [sym_special_argument_list] = "argument_list",
  [sym_argument_list] = "argument_list",
  [sym_selector_expression] = "selector_expression",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_type_assertion_expression] = "type_assertion_expression",
  [sym_type_conversion_expression] = "type_conversion_expression",
  [sym_composite_literal] = "composite_literal",
  [sym_literal_value] = "literal_value",
  [sym_keyed_element] = "keyed_element",
  [sym_element] = "element",
  [sym_func_literal] = "func_literal",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_qualified_type] = "qualified_type",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_import_spec_list_repeat1] = "import_spec_list_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_const_spec_repeat1] = "const_spec_repeat1",
  [aux_sym_var_declaration_repeat1] = "var_declaration_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_field_name_list_repeat1] = "field_name_list_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_method_spec_list_repeat1] = "method_spec_list_repeat1",
  [aux_sym__statement_list_repeat1] = "_statement_list_repeat1",
  [aux_sym_expression_switch_statement_repeat1] = "expression_switch_statement_repeat1",
  [aux_sym_type_switch_statement_repeat1] = "type_switch_statement_repeat1",
  [aux_sym_type_case_repeat1] = "type_case_repeat1",
  [aux_sym_select_statement_repeat1] = "select_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_literal_value_repeat1] = "literal_value_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_label_name] = "label_name",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_blank_identifier] = sym_blank_identifier,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_chan] = anon_sym_chan,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_AMP_CARET_EQ] = anon_sym_AMP_CARET_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_new] = sym_identifier,
  [anon_sym_make] = sym_identifier,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_CARET] = anon_sym_AMP_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_imaginary_literal] = sym_imaginary_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_dot] = sym_dot,
  [sym_import_spec_list] = sym_import_spec_list,
  [sym__declaration] = sym__declaration,
  [sym_const_declaration] = sym_const_declaration,
  [sym_const_spec] = sym_const_spec,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_spec] = sym_var_spec,
  [sym_function_declaration] = sym_function_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_type_alias] = sym_type_alias,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_spec] = sym_type_spec,
  [sym_expression_list] = sym_expression_list,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym__simple_type] = sym__simple_type,
  [sym_pointer_type] = sym_pointer_type,
  [sym_array_type] = sym_array_type,
  [sym_implicit_length_array_type] = sym_implicit_length_array_type,
  [sym_slice_type] = sym_slice_type,
  [sym_struct_type] = sym_struct_type,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_interface_type] = sym_interface_type,
  [sym_method_spec_list] = sym_method_spec_list,
  [sym_method_spec] = sym_method_spec,
  [sym_map_type] = sym_map_type,
  [sym_channel_type] = sym_channel_type,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym__statement_list] = sym__statement_list,
  [sym__statement] = sym__statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_send_statement] = sym_send_statement,
  [sym_receive_statement] = sym_receive_statement,
  [sym_inc_statement] = sym_inc_statement,
  [sym_dec_statement] = sym_dec_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_short_var_declaration] = sym_short_var_declaration,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_empty_labeled_statement] = sym_labeled_statement,
  [sym_fallthrough_statement] = sym_fallthrough_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_go_statement] = sym_go_statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_clause] = sym_for_clause,
  [sym_range_clause] = sym_range_clause,
  [sym_expression_switch_statement] = sym_expression_switch_statement,
  [sym_expression_case] = sym_expression_case,
  [sym_default_case] = sym_default_case,
  [sym_type_switch_statement] = sym_type_switch_statement,
  [sym__type_switch_header] = sym__type_switch_header,
  [sym_type_case] = sym_type_case,
  [sym_select_statement] = sym_select_statement,
  [sym_communication_case] = sym_communication_case,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_variadic_argument] = sym_variadic_argument,
  [sym_special_argument_list] = sym_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_selector_expression] = sym_selector_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_type_assertion_expression] = sym_type_assertion_expression,
  [sym_type_conversion_expression] = sym_type_conversion_expression,
  [sym_composite_literal] = sym_composite_literal,
  [sym_literal_value] = sym_literal_value,
  [sym_keyed_element] = sym_keyed_element,
  [sym_element] = sym_element,
  [sym_func_literal] = sym_func_literal,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_qualified_type] = sym_qualified_type,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_import_spec_list_repeat1] = aux_sym_import_spec_list_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_const_spec_repeat1] = aux_sym_const_spec_repeat1,
  [aux_sym_var_declaration_repeat1] = aux_sym_var_declaration_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_field_name_list_repeat1] = aux_sym_field_name_list_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_method_spec_list_repeat1] = aux_sym_method_spec_list_repeat1,
  [aux_sym__statement_list_repeat1] = aux_sym__statement_list_repeat1,
  [aux_sym_expression_switch_statement_repeat1] = aux_sym_expression_switch_statement_repeat1,
  [aux_sym_type_switch_statement_repeat1] = aux_sym_type_switch_statement_repeat1,
  [aux_sym_type_case_repeat1] = aux_sym_type_case_repeat1,
  [aux_sym_select_statement_repeat1] = aux_sym_select_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_literal_value_repeat1] = aux_sym_literal_value_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_label_name] = alias_sym_label_name,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_blank_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_make] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_imaginary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_length_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type] = {
    .visible = true,
    .named = true,
  },
  [sym_method_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_channel_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_list] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_send_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_receive_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_inc_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_short_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_go_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_range_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_case] = {
    .visible = true,
    .named = true,
  },
  [sym_default_case] = {
    .visible = true,
    .named = true,
  },
  [sym_type_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__type_switch_header] = {
    .visible = false,
    .named = true,
  },
  [sym_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_communication_case] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_special_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_composite_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_func_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type] = {
    .visible = true,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_name_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_method_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_capacity = 5,
  field_channel = 6,
  field_communication = 7,
  field_condition = 8,
  field_consequence = 9,
  field_element = 10,
  field_end = 11,
  field_field = 12,
  field_function = 13,
  field_index = 14,
  field_initializer = 15,
  field_key = 16,
  field_label = 17,
  field_left = 18,
  field_length = 19,
  field_name = 20,
  field_operand = 21,
  field_operator = 22,
  field_package = 23,
  field_parameters = 24,
  field_path = 25,
  field_receiver = 26,
  field_result = 27,
  field_right = 28,
  field_start = 29,
  field_tag = 30,
  field_type = 31,
  field_update = 32,
  field_value = 33,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_capacity] = "capacity",
  [field_channel] = "channel",
  [field_communication] = "communication",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_end] = "end",
  [field_field] = "field",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_receiver] = "receiver",
  [field_result] = "result",
  [field_right] = "right",
  [field_start] = "start",
  [field_tag] = "tag",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[97] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 9, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 11, .length = 2},
  [15] = {.index = 13, .length = 2},
  [16] = {.index = 15, .length = 2},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 15, .length = 2},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 17, .length = 1},
  [24] = {.index = 25, .length = 1},
  [25] = {.index = 26, .length = 1},
  [26] = {.index = 27, .length = 2},
  [27] = {.index = 29, .length = 1},
  [28] = {.index = 30, .length = 1},
  [29] = {.index = 31, .length = 2},
  [30] = {.index = 33, .length = 3},
  [31] = {.index = 36, .length = 2},
  [32] = {.index = 38, .length = 2},
  [33] = {.index = 40, .length = 2},
  [34] = {.index = 42, .length = 2},
  [35] = {.index = 44, .length = 3},
  [36] = {.index = 47, .length = 1},
  [37] = {.index = 48, .length = 3},
  [38] = {.index = 51, .length = 3},
  [39] = {.index = 54, .length = 3},
  [40] = {.index = 57, .length = 3},
  [41] = {.index = 60, .length = 2},
  [42] = {.index = 62, .length = 1},
  [43] = {.index = 63, .length = 2},
  [44] = {.index = 47, .length = 1},
  [45] = {.index = 65, .length = 2},
  [46] = {.index = 15, .length = 2},
  [47] = {.index = 65, .length = 2},
  [49] = {.index = 67, .length = 2},
  [50] = {.index = 69, .length = 1},
  [51] = {.index = 70, .length = 1},
  [52] = {.index = 71, .length = 1},
  [53] = {.index = 72, .length = 3},
  [54] = {.index = 75, .length = 1},
  [55] = {.index = 76, .length = 2},
  [56] = {.index = 78, .length = 1},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 81, .length = 3},
  [59] = {.index = 84, .length = 3},
  [60] = {.index = 60, .length = 2},
  [61] = {.index = 87, .length = 4},
  [62] = {.index = 91, .length = 4},
  [63] = {.index = 95, .length = 4},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 99, .length = 2},
  [67] = {.index = 101, .length = 3},
  [68] = {.index = 44, .length = 3},
  [69] = {.index = 104, .length = 3},
  [70] = {.index = 107, .length = 2},
  [71] = {.index = 109, .length = 3},
  [72] = {.index = 112, .length = 3},
  [73] = {.index = 115, .length = 2},
  [74] = {.index = 117, .length = 2},
  [75] = {.index = 119, .length = 2},
  [76] = {.index = 121, .length = 2},
  [77] = {.index = 123, .length = 1},
  [78] = {.index = 124, .length = 1},
  [80] = {.index = 125, .length = 2},
  [81] = {.index = 127, .length = 2},
  [82] = {.index = 129, .length = 2},
  [83] = {.index = 131, .length = 4},
  [84] = {.index = 135, .length = 5},
  [85] = {.index = 140, .length = 4},
  [86] = {.index = 144, .length = 3},
  [87] = {.index = 147, .length = 2},
  [88] = {.index = 149, .length = 1},
  [89] = {.index = 150, .length = 3},
  [90] = {.index = 153, .length = 4},
  [91] = {.index = 157, .length = 2},
  [92] = {.index = 159, .length = 3},
  [93] = {.index = 162, .length = 2},
  [94] = {.index = 164, .length = 2},
  [95] = {.index = 166, .length = 4},
  [96] = {.index = 170, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_path, 0},
  [1] =
    {field_name, 0},
  [2] =
    {field_parameters, 1},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_value, 1},
  [6] =
    {field_body, 1},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_body, 1},
    {field_type, 0},
  [11] =
    {field_name, 0},
    {field_path, 1},
  [13] =
    {field_name, 0},
    {field_name, 1},
  [15] =
    {field_name, 0},
    {field_type, 1},
  [17] =
    {field_type, 0},
  [18] =
    {field_name, 1},
    {field_parameters, 2},
  [20] =
    {field_parameters, 1},
    {field_result, 2},
  [22] =
    {field_body, 2},
    {field_parameters, 1},
  [24] =
    {field_element, 2},
  [25] =
    {field_label, 0},
  [26] =
    {field_value, 2},
  [27] =
    {field_condition, 1},
    {field_consequence, 2},
  [29] =
    {field_right, 1},
  [30] =
    {field_body, 2},
  [31] =
    {field_name, 2},
    {field_package, 0},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_left, 0},
    {field_right, 2},
  [38] =
    {field_field, 2},
    {field_operand, 0},
  [40] =
    {field_channel, 0},
    {field_value, 2},
  [42] =
    {field_name, 0},
    {field_value, 2},
  [44] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
  [47] =
    {field_type, 1},
  [48] =
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [51] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [54] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [57] =
    {field_body, 3},
    {field_parameters, 1},
    {field_result, 2},
  [60] =
    {field_name, 0},
    {field_type, 2},
  [62] =
    {field_element, 3},
  [63] =
    {field_element, 3},
    {field_length, 1},
  [65] =
    {field_tag, 1},
    {field_type, 0},
  [67] =
    {field_name, 0},
    {field_parameters, 1},
  [69] =
    {field_update, 2},
  [70] =
    {field_condition, 1},
  [71] =
    {field_initializer, 0},
  [72] =
    {field_alias, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [75] =
    {field_right, 0},
  [76] =
    {field_operand, 2},
    {field_type, 0},
  [78] =
    {field_operand, 0},
  [79] =
    {field_index, 2},
    {field_operand, 0},
  [81] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 3},
  [84] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 3},
  [87] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [91] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [95] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [99] =
    {field_tag, 2},
    {field_type, 1},
  [101] =
    {field_name, 0},
    {field_tag, 2},
    {field_type, 1},
  [104] =
    {field_name, 0},
    {field_parameters, 1},
    {field_result, 2},
  [107] =
    {field_key, 2},
    {field_value, 4},
  [109] =
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [112] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [115] =
    {field_condition, 1},
    {field_update, 3},
  [117] =
    {field_left, 0},
    {field_right, 3},
  [119] =
    {field_initializer, 0},
    {field_update, 3},
  [121] =
    {field_condition, 2},
    {field_initializer, 0},
  [123] =
    {field_initializer, 1},
  [124] =
    {field_communication, 1},
  [125] =
    {field_operand, 0},
    {field_type, 3},
  [127] =
    {field_end, 3},
    {field_operand, 0},
  [129] =
    {field_operand, 0},
    {field_start, 2},
  [131] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
    {field_value, 4},
  [135] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [140] =
    {field_name, 0},
    {field_name, 1},
    {field_tag, 3},
    {field_type, 2},
  [144] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [147] =
    {field_initializer, 1},
    {field_value, 3},
  [149] =
    {field_value, 0},
  [150] =
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [153] =
    {field_alternative, 6},
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [157] =
    {field_type, 1},
    {field_type, 2},
  [159] =
    {field_capacity, 5},
    {field_end, 3},
    {field_operand, 0},
  [162] =
    {field_alias, 0},
    {field_value, 2},
  [164] =
    {field_initializer, 0},
    {field_value, 2},
  [166] =
    {field_capacity, 6},
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [170] =
    {field_alias, 2},
    {field_initializer, 0},
    {field_value, 4},
};

static TSSymbol ts_alias_sequences[97][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [1] = alias_sym_package_identifier,
  },
  [8] = {
    [1] = alias_sym_label_name,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [14] = {
    [0] = alias_sym_package_identifier,
  },
  [21] = {
    [0] = alias_sym_type_identifier,
  },
  [23] = {
    [0] = alias_sym_type_identifier,
  },
  [24] = {
    [0] = alias_sym_label_name,
  },
  [29] = {
    [0] = alias_sym_package_identifier,
    [2] = alias_sym_type_identifier,
  },
  [32] = {
    [2] = alias_sym_field_identifier,
  },
  [39] = {
    [2] = alias_sym_field_identifier,
  },
  [41] = {
    [0] = alias_sym_type_identifier,
  },
  [44] = {
    [1] = alias_sym_type_identifier,
  },
  [45] = {
    [0] = alias_sym_type_identifier,
  },
  [46] = {
    [0] = alias_sym_field_identifier,
  },
  [48] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [0] = alias_sym_field_identifier,
  },
  [62] = {
    [2] = alias_sym_field_identifier,
  },
  [63] = {
    [2] = alias_sym_field_identifier,
  },
  [64] = {
    [1] = alias_sym_type_identifier,
  },
  [66] = {
    [1] = alias_sym_field_identifier,
  },
  [67] = {
    [0] = alias_sym_field_identifier,
  },
  [68] = {
    [0] = alias_sym_field_identifier,
  },
  [69] = {
    [0] = alias_sym_field_identifier,
  },
  [79] = {
    [0] = alias_sym_field_identifier,
  },
  [84] = {
    [2] = alias_sym_field_identifier,
  },
  [85] = {
    [0] = alias_sym_field_identifier,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(103);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(107);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(100);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == ']') ADVANCE(76);
      if (lookahead == '^') ADVANCE(105);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(107);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(100);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(105);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(111);
      if (lookahead == '&') ADVANCE(108);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(109);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(126);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(104);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '/') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(139);
      if (lookahead != 0) ADVANCE(140);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(107);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(100);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(107);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == '<') ADVANCE(125);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(111);
      if (lookahead == '&') ADVANCE(108);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(64);
      if (lookahead == '/') ADVANCE(109);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(126);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == ']') ADVANCE(76);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '%') ADVANCE(111);
      if (lookahead == '&') ADVANCE(108);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(109);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(129);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '\'') ADVANCE(154);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(156);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(79);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(72);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(147);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 21:
      if (lookahead == 'U') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 22:
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(9);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(148);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(149);
      END_STATE();
    case 25:
      if (lookahead == '`') ADVANCE(134);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(150);
      END_STATE();
    case 27:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(148);
      END_STATE();
    case 28:
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      END_STATE();
    case 29:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(9);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(149);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(31);
      END_STATE();
    case 34:
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't' ||
          lookahead == 'v') ADVANCE(9);
      if (lookahead == 'U') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(48);
      if (lookahead == 'x') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(33);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(15);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(150);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(147);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 57:
      if (eof) ADVANCE(60);
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead == '!') ADVANCE(102);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(13);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '^') ADVANCE(104);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(57)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 58:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(103);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(107);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(97);
      if (lookahead == ',') ADVANCE(69);
      if (lookahead == '-') ADVANCE(100);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(110);
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(128);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == ']') ADVANCE(76);
      if (lookahead == '^') ADVANCE(105);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(119);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 59:
      if (eof) ADVANCE(60);
      if (lookahead == '!') ADVANCE(102);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '&') ADVANCE(106);
      if (lookahead == '\'') ADVANCE(22);
      if (lookahead == '(') ADVANCE(67);
      if (lookahead == ')') ADVANCE(68);
      if (lookahead == '*') ADVANCE(73);
      if (lookahead == '+') ADVANCE(96);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == ':') ADVANCE(94);
      if (lookahead == ';') ADVANCE(62);
      if (lookahead == '<') ADVANCE(13);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == ']') ADVANCE(76);
      if (lookahead == '^') ADVANCE(104);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      if (lookahead == '`') ADVANCE(25);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_AMP_CARET_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(81);
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(82);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '=') ADVANCE(88);
      if (lookahead == '^') ADVANCE(118);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '^') ADVANCE(117);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(156);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(156);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '|') ADVANCE(132);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(132);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(79);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(79);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(130);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(138);
      if (lookahead == '/') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(23);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(24);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(17);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'i') ADVANCE(153);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'i') ADVANCE(153);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(152);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(30);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(26);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(153);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == '_') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(26);
      if (lookahead == 'i') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_imaginary_literal);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(156);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'v') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_blank_identifier);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'm') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(29);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 't') ADVANCE(36);
      if (lookahead == 'w') ADVANCE(37);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'y') ADVANCE(39);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(40);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(42);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(44);
      END_STATE();
    case 20:
      if (lookahead == 'f') ADVANCE(45);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(47);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_go);
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 27:
      if (lookahead == 'p') ADVANCE(51);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 29:
      if (lookahead == 'k') ADVANCE(53);
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 30:
      if (lookahead == 'w') ADVANCE(55);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(56);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 43:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 44:
      if (lookahead == 's') ADVANCE(69);
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(74);
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(76);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 57:
      if (lookahead == 'k') ADVANCE(81);
      END_STATE();
    case 58:
      if (lookahead == 'g') ADVANCE(82);
      END_STATE();
    case 59:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 66:
      if (lookahead == 'k') ADVANCE(89);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_chan);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 71:
      if (lookahead == 'u') ADVANCE(92);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_make);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(98);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(103);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(105);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 94:
      if (lookahead == 'h') ADVANCE(106);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 97:
      if (lookahead == 'f') ADVANCE(108);
      END_STATE();
    case 98:
      if (lookahead == 'g') ADVANCE(109);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_range);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 103:
      if (lookahead == 'h') ADVANCE(113);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(120);
      END_STATE();
    case 117:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(122);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 122:
      if (lookahead == 'g') ADVANCE(124);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 124:
      if (lookahead == 'h') ADVANCE(125);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 59},
  [2] = {.lex_state = 59},
  [3] = {.lex_state = 59},
  [4] = {.lex_state = 59},
  [5] = {.lex_state = 59},
  [6] = {.lex_state = 59},
  [7] = {.lex_state = 59},
  [8] = {.lex_state = 59},
  [9] = {.lex_state = 59},
  [10] = {.lex_state = 59},
  [11] = {.lex_state = 59},
  [12] = {.lex_state = 59},
  [13] = {.lex_state = 59},
  [14] = {.lex_state = 59},
  [15] = {.lex_state = 59},
  [16] = {.lex_state = 59},
  [17] = {.lex_state = 59},
  [18] = {.lex_state = 59},
  [19] = {.lex_state = 59},
  [20] = {.lex_state = 59},
  [21] = {.lex_state = 59},
  [22] = {.lex_state = 59},
  [23] = {.lex_state = 59},
  [24] = {.lex_state = 59},
  [25] = {.lex_state = 59},
  [26] = {.lex_state = 59},
  [27] = {.lex_state = 57},
  [28] = {.lex_state = 59},
  [29] = {.lex_state = 57},
  [30] = {.lex_state = 57},
  [31] = {.lex_state = 57},
  [32] = {.lex_state = 59},
  [33] = {.lex_state = 59},
  [34] = {.lex_state = 59},
  [35] = {.lex_state = 59},
  [36] = {.lex_state = 59},
  [37] = {.lex_state = 59},
  [38] = {.lex_state = 59},
  [39] = {.lex_state = 59},
  [40] = {.lex_state = 59},
  [41] = {.lex_state = 59},
  [42] = {.lex_state = 59},
  [43] = {.lex_state = 59},
  [44] = {.lex_state = 59},
  [45] = {.lex_state = 59},
  [46] = {.lex_state = 59},
  [47] = {.lex_state = 59},
  [48] = {.lex_state = 59},
  [49] = {.lex_state = 59},
  [50] = {.lex_state = 59},
  [51] = {.lex_state = 59},
  [52] = {.lex_state = 59},
  [53] = {.lex_state = 59},
  [54] = {.lex_state = 59},
  [55] = {.lex_state = 59},
  [56] = {.lex_state = 59},
  [57] = {.lex_state = 59},
  [58] = {.lex_state = 59},
  [59] = {.lex_state = 59},
  [60] = {.lex_state = 59},
  [61] = {.lex_state = 59},
  [62] = {.lex_state = 59},
  [63] = {.lex_state = 59},
  [64] = {.lex_state = 59},
  [65] = {.lex_state = 59},
  [66] = {.lex_state = 59},
  [67] = {.lex_state = 59},
  [68] = {.lex_state = 59},
  [69] = {.lex_state = 59},
  [70] = {.lex_state = 59},
  [71] = {.lex_state = 59},
  [72] = {.lex_state = 59},
  [73] = {.lex_state = 59},
  [74] = {.lex_state = 59},
  [75] = {.lex_state = 59},
  [76] = {.lex_state = 59},
  [77] = {.lex_state = 59},
  [78] = {.lex_state = 59},
  [79] = {.lex_state = 59},
  [80] = {.lex_state = 59},
  [81] = {.lex_state = 59},
  [82] = {.lex_state = 59},
  [83] = {.lex_state = 59},
  [84] = {.lex_state = 59},
  [85] = {.lex_state = 59},
  [86] = {.lex_state = 59},
  [87] = {.lex_state = 59},
  [88] = {.lex_state = 59},
  [89] = {.lex_state = 59},
  [90] = {.lex_state = 59},
  [91] = {.lex_state = 59},
  [92] = {.lex_state = 59},
  [93] = {.lex_state = 59},
  [94] = {.lex_state = 59},
  [95] = {.lex_state = 59},
  [96] = {.lex_state = 59},
  [97] = {.lex_state = 59},
  [98] = {.lex_state = 59},
  [99] = {.lex_state = 59},
  [100] = {.lex_state = 59},
  [101] = {.lex_state = 59},
  [102] = {.lex_state = 59},
  [103] = {.lex_state = 59},
  [104] = {.lex_state = 59},
  [105] = {.lex_state = 59},
  [106] = {.lex_state = 59},
  [107] = {.lex_state = 59},
  [108] = {.lex_state = 59},
  [109] = {.lex_state = 59},
  [110] = {.lex_state = 59},
  [111] = {.lex_state = 59},
  [112] = {.lex_state = 59},
  [113] = {.lex_state = 59},
  [114] = {.lex_state = 59},
  [115] = {.lex_state = 59},
  [116] = {.lex_state = 59},
  [117] = {.lex_state = 59},
  [118] = {.lex_state = 59},
  [119] = {.lex_state = 59},
  [120] = {.lex_state = 59},
  [121] = {.lex_state = 59},
  [122] = {.lex_state = 59},
  [123] = {.lex_state = 59},
  [124] = {.lex_state = 59},
  [125] = {.lex_state = 59},
  [126] = {.lex_state = 59},
  [127] = {.lex_state = 59},
  [128] = {.lex_state = 59},
  [129] = {.lex_state = 59},
  [130] = {.lex_state = 59},
  [131] = {.lex_state = 59},
  [132] = {.lex_state = 59},
  [133] = {.lex_state = 59},
  [134] = {.lex_state = 59},
  [135] = {.lex_state = 59},
  [136] = {.lex_state = 59},
  [137] = {.lex_state = 59},
  [138] = {.lex_state = 59},
  [139] = {.lex_state = 59},
  [140] = {.lex_state = 59},
  [141] = {.lex_state = 59},
  [142] = {.lex_state = 59},
  [143] = {.lex_state = 59},
  [144] = {.lex_state = 59},
  [145] = {.lex_state = 59},
  [146] = {.lex_state = 59},
  [147] = {.lex_state = 59},
  [148] = {.lex_state = 59},
  [149] = {.lex_state = 59},
  [150] = {.lex_state = 59},
  [151] = {.lex_state = 59},
  [152] = {.lex_state = 59},
  [153] = {.lex_state = 59},
  [154] = {.lex_state = 59},
  [155] = {.lex_state = 59},
  [156] = {.lex_state = 59},
  [157] = {.lex_state = 59},
  [158] = {.lex_state = 59},
  [159] = {.lex_state = 59},
  [160] = {.lex_state = 59},
  [161] = {.lex_state = 59},
  [162] = {.lex_state = 59},
  [163] = {.lex_state = 59},
  [164] = {.lex_state = 59},
  [165] = {.lex_state = 59},
  [166] = {.lex_state = 59},
  [167] = {.lex_state = 59},
  [168] = {.lex_state = 59},
  [169] = {.lex_state = 59},
  [170] = {.lex_state = 59},
  [171] = {.lex_state = 59},
  [172] = {.lex_state = 59},
  [173] = {.lex_state = 59},
  [174] = {.lex_state = 59},
  [175] = {.lex_state = 59},
  [176] = {.lex_state = 59},
  [177] = {.lex_state = 59},
  [178] = {.lex_state = 59},
  [179] = {.lex_state = 59},
  [180] = {.lex_state = 59},
  [181] = {.lex_state = 59},
  [182] = {.lex_state = 59},
  [183] = {.lex_state = 59},
  [184] = {.lex_state = 59},
  [185] = {.lex_state = 59},
  [186] = {.lex_state = 59},
  [187] = {.lex_state = 59},
  [188] = {.lex_state = 59},
  [189] = {.lex_state = 59},
  [190] = {.lex_state = 59},
  [191] = {.lex_state = 59},
  [192] = {.lex_state = 59},
  [193] = {.lex_state = 59},
  [194] = {.lex_state = 59},
  [195] = {.lex_state = 59},
  [196] = {.lex_state = 59},
  [197] = {.lex_state = 59},
  [198] = {.lex_state = 59},
  [199] = {.lex_state = 59},
  [200] = {.lex_state = 59},
  [201] = {.lex_state = 59},
  [202] = {.lex_state = 59},
  [203] = {.lex_state = 59},
  [204] = {.lex_state = 59},
  [205] = {.lex_state = 59},
  [206] = {.lex_state = 59},
  [207] = {.lex_state = 59},
  [208] = {.lex_state = 59},
  [209] = {.lex_state = 59},
  [210] = {.lex_state = 59},
  [211] = {.lex_state = 59},
  [212] = {.lex_state = 59},
  [213] = {.lex_state = 59},
  [214] = {.lex_state = 59},
  [215] = {.lex_state = 59},
  [216] = {.lex_state = 59},
  [217] = {.lex_state = 59},
  [218] = {.lex_state = 59},
  [219] = {.lex_state = 59},
  [220] = {.lex_state = 59},
  [221] = {.lex_state = 59},
  [222] = {.lex_state = 59},
  [223] = {.lex_state = 59},
  [224] = {.lex_state = 59},
  [225] = {.lex_state = 59},
  [226] = {.lex_state = 59},
  [227] = {.lex_state = 59},
  [228] = {.lex_state = 59},
  [229] = {.lex_state = 59},
  [230] = {.lex_state = 59},
  [231] = {.lex_state = 59},
  [232] = {.lex_state = 59},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 57},
  [235] = {.lex_state = 57},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 57},
  [238] = {.lex_state = 57},
  [239] = {.lex_state = 57},
  [240] = {.lex_state = 57},
  [241] = {.lex_state = 57},
  [242] = {.lex_state = 57},
  [243] = {.lex_state = 57},
  [244] = {.lex_state = 57},
  [245] = {.lex_state = 57},
  [246] = {.lex_state = 57},
  [247] = {.lex_state = 57},
  [248] = {.lex_state = 57},
  [249] = {.lex_state = 57},
  [250] = {.lex_state = 57},
  [251] = {.lex_state = 57},
  [252] = {.lex_state = 57},
  [253] = {.lex_state = 57},
  [254] = {.lex_state = 57},
  [255] = {.lex_state = 57},
  [256] = {.lex_state = 57},
  [257] = {.lex_state = 57},
  [258] = {.lex_state = 57},
  [259] = {.lex_state = 57},
  [260] = {.lex_state = 57},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 57},
  [263] = {.lex_state = 57},
  [264] = {.lex_state = 57},
  [265] = {.lex_state = 57},
  [266] = {.lex_state = 57},
  [267] = {.lex_state = 57},
  [268] = {.lex_state = 57},
  [269] = {.lex_state = 57},
  [270] = {.lex_state = 57},
  [271] = {.lex_state = 57},
  [272] = {.lex_state = 57},
  [273] = {.lex_state = 57},
  [274] = {.lex_state = 57},
  [275] = {.lex_state = 57},
  [276] = {.lex_state = 57},
  [277] = {.lex_state = 57},
  [278] = {.lex_state = 57},
  [279] = {.lex_state = 57},
  [280] = {.lex_state = 57},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 57},
  [283] = {.lex_state = 57},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 59},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 4},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 4},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 1},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 4},
  [328] = {.lex_state = 4},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 4},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 4},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 4},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 4},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 4},
  [345] = {.lex_state = 4},
  [346] = {.lex_state = 4},
  [347] = {.lex_state = 4},
  [348] = {.lex_state = 4},
  [349] = {.lex_state = 4},
  [350] = {.lex_state = 4},
  [351] = {.lex_state = 4},
  [352] = {.lex_state = 4},
  [353] = {.lex_state = 4},
  [354] = {.lex_state = 4},
  [355] = {.lex_state = 4},
  [356] = {.lex_state = 4},
  [357] = {.lex_state = 4},
  [358] = {.lex_state = 4},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 4},
  [361] = {.lex_state = 4},
  [362] = {.lex_state = 4},
  [363] = {.lex_state = 4},
  [364] = {.lex_state = 4},
  [365] = {.lex_state = 4},
  [366] = {.lex_state = 4},
  [367] = {.lex_state = 4},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 5},
  [404] = {.lex_state = 5},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 6},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 6},
  [414] = {.lex_state = 6},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 6},
  [417] = {.lex_state = 6},
  [418] = {.lex_state = 6},
  [419] = {.lex_state = 6},
  [420] = {.lex_state = 6},
  [421] = {.lex_state = 6},
  [422] = {.lex_state = 6},
  [423] = {.lex_state = 6},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 6},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 6},
  [432] = {.lex_state = 6},
  [433] = {.lex_state = 6},
  [434] = {.lex_state = 6},
  [435] = {.lex_state = 6},
  [436] = {.lex_state = 6},
  [437] = {.lex_state = 6},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 6},
  [440] = {.lex_state = 6},
  [441] = {.lex_state = 6},
  [442] = {.lex_state = 6},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 6},
  [446] = {.lex_state = 2},
  [447] = {.lex_state = 6},
  [448] = {.lex_state = 6},
  [449] = {.lex_state = 6},
  [450] = {.lex_state = 2},
  [451] = {.lex_state = 57},
  [452] = {.lex_state = 2},
  [453] = {.lex_state = 57},
  [454] = {.lex_state = 7},
  [455] = {.lex_state = 2},
  [456] = {.lex_state = 2},
  [457] = {.lex_state = 2},
  [458] = {.lex_state = 7},
  [459] = {.lex_state = 2},
  [460] = {.lex_state = 2},
  [461] = {.lex_state = 2},
  [462] = {.lex_state = 57},
  [463] = {.lex_state = 2},
  [464] = {.lex_state = 57},
  [465] = {.lex_state = 2},
  [466] = {.lex_state = 2},
  [467] = {.lex_state = 2},
  [468] = {.lex_state = 2},
  [469] = {.lex_state = 2},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 2},
  [472] = {.lex_state = 2},
  [473] = {.lex_state = 2},
  [474] = {.lex_state = 2},
  [475] = {.lex_state = 7},
  [476] = {.lex_state = 2},
  [477] = {.lex_state = 2},
  [478] = {.lex_state = 2},
  [479] = {.lex_state = 2},
  [480] = {.lex_state = 2},
  [481] = {.lex_state = 2},
  [482] = {.lex_state = 2},
  [483] = {.lex_state = 2},
  [484] = {.lex_state = 2},
  [485] = {.lex_state = 2},
  [486] = {.lex_state = 2},
  [487] = {.lex_state = 7},
  [488] = {.lex_state = 2},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 7},
  [491] = {.lex_state = 2},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 2},
  [494] = {.lex_state = 2},
  [495] = {.lex_state = 2},
  [496] = {.lex_state = 2},
  [497] = {.lex_state = 2},
  [498] = {.lex_state = 2},
  [499] = {.lex_state = 2},
  [500] = {.lex_state = 2},
  [501] = {.lex_state = 7},
  [502] = {.lex_state = 2},
  [503] = {.lex_state = 7},
  [504] = {.lex_state = 7},
  [505] = {.lex_state = 7},
  [506] = {.lex_state = 2},
  [507] = {.lex_state = 2},
  [508] = {.lex_state = 6},
  [509] = {.lex_state = 7},
  [510] = {.lex_state = 6},
  [511] = {.lex_state = 6},
  [512] = {.lex_state = 6},
  [513] = {.lex_state = 6},
  [514] = {.lex_state = 7},
  [515] = {.lex_state = 6},
  [516] = {.lex_state = 7},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 6},
  [519] = {.lex_state = 6},
  [520] = {.lex_state = 7},
  [521] = {.lex_state = 7},
  [522] = {.lex_state = 7},
  [523] = {.lex_state = 7},
  [524] = {.lex_state = 7},
  [525] = {.lex_state = 7},
  [526] = {.lex_state = 7},
  [527] = {.lex_state = 7},
  [528] = {.lex_state = 7},
  [529] = {.lex_state = 7},
  [530] = {.lex_state = 6},
  [531] = {.lex_state = 7},
  [532] = {.lex_state = 7},
  [533] = {.lex_state = 7},
  [534] = {.lex_state = 7},
  [535] = {.lex_state = 7},
  [536] = {.lex_state = 7},
  [537] = {.lex_state = 7},
  [538] = {.lex_state = 7},
  [539] = {.lex_state = 7},
  [540] = {.lex_state = 7},
  [541] = {.lex_state = 7},
  [542] = {.lex_state = 7},
  [543] = {.lex_state = 6},
  [544] = {.lex_state = 7},
  [545] = {.lex_state = 7},
  [546] = {.lex_state = 7},
  [547] = {.lex_state = 7},
  [548] = {.lex_state = 7},
  [549] = {.lex_state = 7},
  [550] = {.lex_state = 7},
  [551] = {.lex_state = 6},
  [552] = {.lex_state = 6},
  [553] = {.lex_state = 6},
  [554] = {.lex_state = 6},
  [555] = {.lex_state = 6},
  [556] = {.lex_state = 6},
  [557] = {.lex_state = 6},
  [558] = {.lex_state = 6},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 6},
  [561] = {.lex_state = 6},
  [562] = {.lex_state = 6},
  [563] = {.lex_state = 6},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 6},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 6},
  [570] = {.lex_state = 6},
  [571] = {.lex_state = 6},
  [572] = {.lex_state = 6},
  [573] = {.lex_state = 6},
  [574] = {.lex_state = 6},
  [575] = {.lex_state = 6},
  [576] = {.lex_state = 6},
  [577] = {.lex_state = 6},
  [578] = {.lex_state = 6},
  [579] = {.lex_state = 6},
  [580] = {.lex_state = 6},
  [581] = {.lex_state = 6},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 6},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 6},
  [586] = {.lex_state = 6},
  [587] = {.lex_state = 6},
  [588] = {.lex_state = 6},
  [589] = {.lex_state = 6},
  [590] = {.lex_state = 6},
  [591] = {.lex_state = 6},
  [592] = {.lex_state = 6},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 6},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 6},
  [597] = {.lex_state = 6},
  [598] = {.lex_state = 6},
  [599] = {.lex_state = 6},
  [600] = {.lex_state = 6},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 6},
  [603] = {.lex_state = 6},
  [604] = {.lex_state = 6},
  [605] = {.lex_state = 6},
  [606] = {.lex_state = 6},
  [607] = {.lex_state = 6},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 6},
  [610] = {.lex_state = 6},
  [611] = {.lex_state = 6},
  [612] = {.lex_state = 6},
  [613] = {.lex_state = 6},
  [614] = {.lex_state = 6},
  [615] = {.lex_state = 6},
  [616] = {.lex_state = 6},
  [617] = {.lex_state = 6},
  [618] = {.lex_state = 6},
  [619] = {.lex_state = 6},
  [620] = {.lex_state = 6},
  [621] = {.lex_state = 6},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 6},
  [624] = {.lex_state = 6},
  [625] = {.lex_state = 6},
  [626] = {.lex_state = 6},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 6},
  [629] = {.lex_state = 6},
  [630] = {.lex_state = 6},
  [631] = {.lex_state = 6},
  [632] = {.lex_state = 6},
  [633] = {.lex_state = 6},
  [634] = {.lex_state = 6},
  [635] = {.lex_state = 57},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 6},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 57},
  [710] = {.lex_state = 57},
  [711] = {.lex_state = 57},
  [712] = {.lex_state = 57},
  [713] = {.lex_state = 57},
  [714] = {.lex_state = 57},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 57},
  [735] = {.lex_state = 57},
  [736] = {.lex_state = 57},
  [737] = {.lex_state = 57},
  [738] = {.lex_state = 57},
  [739] = {.lex_state = 57},
  [740] = {.lex_state = 57},
  [741] = {.lex_state = 57},
  [742] = {.lex_state = 57},
  [743] = {.lex_state = 57},
  [744] = {.lex_state = 57},
  [745] = {.lex_state = 57},
  [746] = {.lex_state = 57},
  [747] = {.lex_state = 57},
  [748] = {.lex_state = 57},
  [749] = {.lex_state = 57},
  [750] = {.lex_state = 57},
  [751] = {.lex_state = 57},
  [752] = {.lex_state = 57},
  [753] = {.lex_state = 57},
  [754] = {.lex_state = 57},
  [755] = {.lex_state = 57},
  [756] = {.lex_state = 57},
  [757] = {.lex_state = 57},
  [758] = {.lex_state = 57},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 57},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 57},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 57},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 57},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 57},
  [786] = {.lex_state = 57},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 57},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 57},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 57},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 57},
  [805] = {.lex_state = 57},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 57},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 57},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 57},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 57},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 57},
  [817] = {.lex_state = 57},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 57},
  [820] = {.lex_state = 57},
  [821] = {.lex_state = 57},
  [822] = {.lex_state = 57},
  [823] = {.lex_state = 57},
  [824] = {.lex_state = 57},
  [825] = {.lex_state = 57},
  [826] = {.lex_state = 57},
  [827] = {.lex_state = 57},
  [828] = {.lex_state = 57},
  [829] = {.lex_state = 57},
  [830] = {.lex_state = 57},
  [831] = {.lex_state = 57},
  [832] = {.lex_state = 57},
  [833] = {.lex_state = 57},
  [834] = {.lex_state = 57},
  [835] = {.lex_state = 57},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 57},
  [838] = {.lex_state = 57},
  [839] = {.lex_state = 57},
  [840] = {.lex_state = 57},
  [841] = {.lex_state = 57},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 57},
  [844] = {.lex_state = 57},
  [845] = {.lex_state = 57},
  [846] = {.lex_state = 57},
  [847] = {.lex_state = 57},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 57},
  [851] = {.lex_state = 57},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 57},
  [856] = {.lex_state = 57},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 57},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 57},
  [863] = {.lex_state = 57},
  [864] = {.lex_state = 57},
  [865] = {.lex_state = 57},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 57},
  [868] = {.lex_state = 57},
  [869] = {.lex_state = 57},
  [870] = {.lex_state = 57},
  [871] = {.lex_state = 57},
  [872] = {.lex_state = 57},
  [873] = {.lex_state = 57},
  [874] = {.lex_state = 57},
  [875] = {.lex_state = 57},
  [876] = {.lex_state = 57},
  [877] = {.lex_state = 57},
  [878] = {.lex_state = 57},
  [879] = {.lex_state = 57},
  [880] = {.lex_state = 57},
  [881] = {.lex_state = 3},
  [882] = {.lex_state = 3},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 3},
  [885] = {.lex_state = 3},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 3},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 3},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 57},
  [893] = {.lex_state = 57},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 3},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 3},
  [898] = {.lex_state = 3},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 57},
  [901] = {.lex_state = 57},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 57},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 57},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 57},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 57},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 57},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 3},
  [920] = {.lex_state = 57},
  [921] = {.lex_state = 57},
  [922] = {.lex_state = 3},
  [923] = {.lex_state = 3},
  [924] = {.lex_state = 57},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 57},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 57},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 57},
  [933] = {.lex_state = 3},
  [934] = {.lex_state = 57},
  [935] = {.lex_state = 57},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 3},
  [940] = {.lex_state = 3},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 57},
  [944] = {.lex_state = 57},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 57},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 57},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 57},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 57},
  [985] = {.lex_state = 57},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 57},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 57},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 57},
  [1029] = {.lex_state = 57},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 57},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 57},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 57},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 57},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 57},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 57},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_blank_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_chan] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_fallthrough] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_range] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_make] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [sym_imaginary_literal] = ACTIONS(1),
    [sym_rune_literal] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1135),
    [sym_package_clause] = STATE(251),
    [sym_import_declaration] = STATE(251),
    [sym__declaration] = STATE(1065),
    [sym_const_declaration] = STATE(1065),
    [sym_var_declaration] = STATE(1065),
    [sym_function_declaration] = STATE(251),
    [sym_method_declaration] = STATE(251),
    [sym_type_declaration] = STATE(1065),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(1065),
    [sym__statement] = STATE(1065),
    [sym_empty_statement] = STATE(1065),
    [sym__simple_statement] = STATE(1065),
    [sym_send_statement] = STATE(1065),
    [sym_inc_statement] = STATE(1065),
    [sym_dec_statement] = STATE(1065),
    [sym_assignment_statement] = STATE(1065),
    [sym_short_var_declaration] = STATE(1065),
    [sym_labeled_statement] = STATE(1065),
    [sym_fallthrough_statement] = STATE(1065),
    [sym_break_statement] = STATE(1065),
    [sym_continue_statement] = STATE(1065),
    [sym_goto_statement] = STATE(1065),
    [sym_return_statement] = STATE(1065),
    [sym_go_statement] = STATE(1065),
    [sym_defer_statement] = STATE(1065),
    [sym_if_statement] = STATE(1065),
    [sym_for_statement] = STATE(1065),
    [sym_expression_switch_statement] = STATE(1065),
    [sym_type_switch_statement] = STATE(1065),
    [sym_select_statement] = STATE(1065),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_package_clause] = STATE(251),
    [sym_import_declaration] = STATE(251),
    [sym__declaration] = STATE(1065),
    [sym_const_declaration] = STATE(1065),
    [sym_var_declaration] = STATE(1065),
    [sym_function_declaration] = STATE(251),
    [sym_method_declaration] = STATE(251),
    [sym_type_declaration] = STATE(1065),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(1065),
    [sym__statement] = STATE(1065),
    [sym_empty_statement] = STATE(1065),
    [sym__simple_statement] = STATE(1065),
    [sym_send_statement] = STATE(1065),
    [sym_inc_statement] = STATE(1065),
    [sym_dec_statement] = STATE(1065),
    [sym_assignment_statement] = STATE(1065),
    [sym_short_var_declaration] = STATE(1065),
    [sym_labeled_statement] = STATE(1065),
    [sym_fallthrough_statement] = STATE(1065),
    [sym_break_statement] = STATE(1065),
    [sym_continue_statement] = STATE(1065),
    [sym_goto_statement] = STATE(1065),
    [sym_return_statement] = STATE(1065),
    [sym_go_statement] = STATE(1065),
    [sym_defer_statement] = STATE(1065),
    [sym_if_statement] = STATE(1065),
    [sym_for_statement] = STATE(1065),
    [sym_expression_switch_statement] = STATE(1065),
    [sym_type_switch_statement] = STATE(1065),
    [sym_select_statement] = STATE(1065),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(73),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_package_clause] = STATE(251),
    [sym_import_declaration] = STATE(251),
    [sym__declaration] = STATE(1065),
    [sym_const_declaration] = STATE(1065),
    [sym_var_declaration] = STATE(1065),
    [sym_function_declaration] = STATE(251),
    [sym_method_declaration] = STATE(251),
    [sym_type_declaration] = STATE(1065),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(1065),
    [sym__statement] = STATE(1065),
    [sym_empty_statement] = STATE(1065),
    [sym__simple_statement] = STATE(1065),
    [sym_send_statement] = STATE(1065),
    [sym_inc_statement] = STATE(1065),
    [sym_dec_statement] = STATE(1065),
    [sym_assignment_statement] = STATE(1065),
    [sym_short_var_declaration] = STATE(1065),
    [sym_labeled_statement] = STATE(1065),
    [sym_fallthrough_statement] = STATE(1065),
    [sym_break_statement] = STATE(1065),
    [sym_continue_statement] = STATE(1065),
    [sym_goto_statement] = STATE(1065),
    [sym_return_statement] = STATE(1065),
    [sym_go_statement] = STATE(1065),
    [sym_defer_statement] = STATE(1065),
    [sym_if_statement] = STATE(1065),
    [sym_for_statement] = STATE(1065),
    [sym_expression_switch_statement] = STATE(1065),
    [sym_type_switch_statement] = STATE(1065),
    [sym_select_statement] = STATE(1065),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(75),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(80),
    [anon_sym_package] = ACTIONS(83),
    [anon_sym_import] = ACTIONS(86),
    [anon_sym_LPAREN] = ACTIONS(89),
    [anon_sym_const] = ACTIONS(92),
    [anon_sym_var] = ACTIONS(95),
    [anon_sym_func] = ACTIONS(98),
    [anon_sym_type] = ACTIONS(101),
    [anon_sym_STAR] = ACTIONS(104),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_struct] = ACTIONS(110),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_interface] = ACTIONS(116),
    [anon_sym_map] = ACTIONS(119),
    [anon_sym_chan] = ACTIONS(122),
    [anon_sym_LT_DASH] = ACTIONS(125),
    [anon_sym_fallthrough] = ACTIONS(128),
    [anon_sym_break] = ACTIONS(131),
    [anon_sym_continue] = ACTIONS(134),
    [anon_sym_goto] = ACTIONS(137),
    [anon_sym_return] = ACTIONS(140),
    [anon_sym_go] = ACTIONS(143),
    [anon_sym_defer] = ACTIONS(146),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(152),
    [anon_sym_switch] = ACTIONS(155),
    [anon_sym_select] = ACTIONS(158),
    [anon_sym_new] = ACTIONS(161),
    [anon_sym_make] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(164),
    [anon_sym_DASH] = ACTIONS(164),
    [anon_sym_BANG] = ACTIONS(164),
    [anon_sym_CARET] = ACTIONS(164),
    [anon_sym_AMP] = ACTIONS(164),
    [sym_raw_string_literal] = ACTIONS(167),
    [anon_sym_DQUOTE] = ACTIONS(170),
    [sym_int_literal] = ACTIONS(173),
    [sym_float_literal] = ACTIONS(173),
    [sym_imaginary_literal] = ACTIONS(167),
    [sym_rune_literal] = ACTIONS(167),
    [sym_nil] = ACTIONS(173),
    [sym_true] = ACTIONS(173),
    [sym_false] = ACTIONS(173),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(988),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(988),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(180),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(182),
    [anon_sym_default] = ACTIONS(182),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(978),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(978),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(186),
    [anon_sym_default] = ACTIONS(186),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(990),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(990),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(190),
    [anon_sym_default] = ACTIONS(190),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(986),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(986),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(192),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(194),
    [anon_sym_default] = ACTIONS(194),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(963),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(963),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(198),
    [anon_sym_default] = ACTIONS(198),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__declaration] = STATE(843),
    [sym_const_declaration] = STATE(843),
    [sym_var_declaration] = STATE(843),
    [sym_type_declaration] = STATE(843),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(843),
    [sym__statement] = STATE(843),
    [sym_empty_statement] = STATE(843),
    [sym__simple_statement] = STATE(843),
    [sym_send_statement] = STATE(843),
    [sym_inc_statement] = STATE(843),
    [sym_dec_statement] = STATE(843),
    [sym_assignment_statement] = STATE(843),
    [sym_short_var_declaration] = STATE(843),
    [sym_labeled_statement] = STATE(843),
    [sym_empty_labeled_statement] = STATE(976),
    [sym_fallthrough_statement] = STATE(843),
    [sym_break_statement] = STATE(843),
    [sym_continue_statement] = STATE(843),
    [sym_goto_statement] = STATE(843),
    [sym_return_statement] = STATE(843),
    [sym_go_statement] = STATE(843),
    [sym_defer_statement] = STATE(843),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_expression_switch_statement] = STATE(843),
    [sym_type_switch_statement] = STATE(843),
    [sym_select_statement] = STATE(843),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(200),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(202),
    [anon_sym_default] = ACTIONS(202),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__declaration] = STATE(843),
    [sym_const_declaration] = STATE(843),
    [sym_var_declaration] = STATE(843),
    [sym_type_declaration] = STATE(843),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(843),
    [sym__statement] = STATE(843),
    [sym_empty_statement] = STATE(843),
    [sym__simple_statement] = STATE(843),
    [sym_send_statement] = STATE(843),
    [sym_inc_statement] = STATE(843),
    [sym_dec_statement] = STATE(843),
    [sym_assignment_statement] = STATE(843),
    [sym_short_var_declaration] = STATE(843),
    [sym_labeled_statement] = STATE(843),
    [sym_empty_labeled_statement] = STATE(959),
    [sym_fallthrough_statement] = STATE(843),
    [sym_break_statement] = STATE(843),
    [sym_continue_statement] = STATE(843),
    [sym_goto_statement] = STATE(843),
    [sym_return_statement] = STATE(843),
    [sym_go_statement] = STATE(843),
    [sym_defer_statement] = STATE(843),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_expression_switch_statement] = STATE(843),
    [sym_type_switch_statement] = STATE(843),
    [sym_select_statement] = STATE(843),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(204),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(206),
    [anon_sym_default] = ACTIONS(206),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1159),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1159),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(208),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1132),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1132),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(210),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1106),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1106),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(212),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1136),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1136),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__declaration] = STATE(872),
    [sym_const_declaration] = STATE(872),
    [sym_var_declaration] = STATE(872),
    [sym_type_declaration] = STATE(872),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(872),
    [sym__statement] = STATE(872),
    [sym_empty_statement] = STATE(872),
    [sym__simple_statement] = STATE(872),
    [sym_send_statement] = STATE(872),
    [sym_inc_statement] = STATE(872),
    [sym_dec_statement] = STATE(872),
    [sym_assignment_statement] = STATE(872),
    [sym_short_var_declaration] = STATE(872),
    [sym_labeled_statement] = STATE(872),
    [sym_fallthrough_statement] = STATE(872),
    [sym_break_statement] = STATE(872),
    [sym_continue_statement] = STATE(872),
    [sym_goto_statement] = STATE(872),
    [sym_return_statement] = STATE(872),
    [sym_go_statement] = STATE(872),
    [sym_defer_statement] = STATE(872),
    [sym_if_statement] = STATE(872),
    [sym_for_statement] = STATE(872),
    [sym_expression_switch_statement] = STATE(872),
    [sym_type_switch_statement] = STATE(872),
    [sym_select_statement] = STATE(872),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(218),
    [anon_sym_default] = ACTIONS(218),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1114),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1114),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1128),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1128),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__declaration] = STATE(816),
    [sym_const_declaration] = STATE(816),
    [sym_var_declaration] = STATE(816),
    [sym_type_declaration] = STATE(816),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(816),
    [sym__statement_list] = STATE(1103),
    [sym__statement] = STATE(816),
    [sym_empty_statement] = STATE(816),
    [sym__simple_statement] = STATE(816),
    [sym_send_statement] = STATE(816),
    [sym_inc_statement] = STATE(816),
    [sym_dec_statement] = STATE(816),
    [sym_assignment_statement] = STATE(816),
    [sym_short_var_declaration] = STATE(816),
    [sym_labeled_statement] = STATE(816),
    [sym_empty_labeled_statement] = STATE(1103),
    [sym_fallthrough_statement] = STATE(816),
    [sym_break_statement] = STATE(816),
    [sym_continue_statement] = STATE(816),
    [sym_goto_statement] = STATE(816),
    [sym_return_statement] = STATE(816),
    [sym_go_statement] = STATE(816),
    [sym_defer_statement] = STATE(816),
    [sym_if_statement] = STATE(816),
    [sym_for_statement] = STATE(816),
    [sym_expression_switch_statement] = STATE(816),
    [sym_type_switch_statement] = STATE(816),
    [sym_select_statement] = STATE(816),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(176),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__declaration] = STATE(843),
    [sym_const_declaration] = STATE(843),
    [sym_var_declaration] = STATE(843),
    [sym_type_declaration] = STATE(843),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(843),
    [sym__statement] = STATE(843),
    [sym_empty_statement] = STATE(843),
    [sym__simple_statement] = STATE(843),
    [sym_send_statement] = STATE(843),
    [sym_inc_statement] = STATE(843),
    [sym_dec_statement] = STATE(843),
    [sym_assignment_statement] = STATE(843),
    [sym_short_var_declaration] = STATE(843),
    [sym_labeled_statement] = STATE(843),
    [sym_fallthrough_statement] = STATE(843),
    [sym_break_statement] = STATE(843),
    [sym_continue_statement] = STATE(843),
    [sym_goto_statement] = STATE(843),
    [sym_return_statement] = STATE(843),
    [sym_go_statement] = STATE(843),
    [sym_defer_statement] = STATE(843),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_expression_switch_statement] = STATE(843),
    [sym_type_switch_statement] = STATE(843),
    [sym_select_statement] = STATE(843),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__declaration] = STATE(872),
    [sym_const_declaration] = STATE(872),
    [sym_var_declaration] = STATE(872),
    [sym_type_declaration] = STATE(872),
    [sym_expression_list] = STATE(724),
    [sym_parenthesized_type] = STATE(1094),
    [sym__simple_type] = STATE(1094),
    [sym_pointer_type] = STATE(1094),
    [sym_array_type] = STATE(957),
    [sym_implicit_length_array_type] = STATE(1063),
    [sym_slice_type] = STATE(957),
    [sym_struct_type] = STATE(957),
    [sym_interface_type] = STATE(1094),
    [sym_map_type] = STATE(957),
    [sym_channel_type] = STATE(1094),
    [sym_function_type] = STATE(1094),
    [sym_block] = STATE(872),
    [sym__statement] = STATE(872),
    [sym_empty_statement] = STATE(872),
    [sym__simple_statement] = STATE(872),
    [sym_send_statement] = STATE(872),
    [sym_inc_statement] = STATE(872),
    [sym_dec_statement] = STATE(872),
    [sym_assignment_statement] = STATE(872),
    [sym_short_var_declaration] = STATE(872),
    [sym_labeled_statement] = STATE(872),
    [sym_fallthrough_statement] = STATE(872),
    [sym_break_statement] = STATE(872),
    [sym_continue_statement] = STATE(872),
    [sym_goto_statement] = STATE(872),
    [sym_return_statement] = STATE(872),
    [sym_go_statement] = STATE(872),
    [sym_defer_statement] = STATE(872),
    [sym_if_statement] = STATE(872),
    [sym_for_statement] = STATE(872),
    [sym_expression_switch_statement] = STATE(872),
    [sym_type_switch_statement] = STATE(872),
    [sym_select_statement] = STATE(872),
    [sym__expression] = STATE(261),
    [sym_parenthesized_expression] = STATE(261),
    [sym_call_expression] = STATE(261),
    [sym_selector_expression] = STATE(261),
    [sym_index_expression] = STATE(261),
    [sym_slice_expression] = STATE(261),
    [sym_type_assertion_expression] = STATE(261),
    [sym_type_conversion_expression] = STATE(261),
    [sym_composite_literal] = STATE(261),
    [sym_func_literal] = STATE(261),
    [sym_unary_expression] = STATE(261),
    [sym_binary_expression] = STATE(261),
    [sym_qualified_type] = STATE(957),
    [sym_interpreted_string_literal] = STATE(261),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(178),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(25),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(39),
    [anon_sym_fallthrough] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(43),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_goto] = ACTIONS(47),
    [anon_sym_return] = ACTIONS(49),
    [anon_sym_go] = ACTIONS(51),
    [anon_sym_defer] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_switch] = ACTIONS(59),
    [anon_sym_select] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_make] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_AMP] = ACTIONS(65),
    [sym_raw_string_literal] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [sym_int_literal] = ACTIONS(71),
    [sym_float_literal] = ACTIONS(71),
    [sym_imaginary_literal] = ACTIONS(67),
    [sym_rune_literal] = ACTIONS(67),
    [sym_nil] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression_list] = STATE(721),
    [sym_parenthesized_type] = STATE(1166),
    [sym__simple_type] = STATE(1166),
    [sym_pointer_type] = STATE(1166),
    [sym_array_type] = STATE(991),
    [sym_implicit_length_array_type] = STATE(1058),
    [sym_slice_type] = STATE(991),
    [sym_struct_type] = STATE(991),
    [sym_interface_type] = STATE(1166),
    [sym_map_type] = STATE(991),
    [sym_channel_type] = STATE(1166),
    [sym_function_type] = STATE(1166),
    [sym_block] = STATE(840),
    [sym__simple_statement] = STATE(1134),
    [sym_send_statement] = STATE(1134),
    [sym_inc_statement] = STATE(1134),
    [sym_dec_statement] = STATE(1134),
    [sym_assignment_statement] = STATE(1134),
    [sym_short_var_declaration] = STATE(1134),
    [sym_for_clause] = STATE(1059),
    [sym_range_clause] = STATE(1059),
    [sym__expression] = STATE(313),
    [sym_parenthesized_expression] = STATE(313),
    [sym_call_expression] = STATE(313),
    [sym_selector_expression] = STATE(313),
    [sym_index_expression] = STATE(313),
    [sym_slice_expression] = STATE(313),
    [sym_type_assertion_expression] = STATE(313),
    [sym_type_conversion_expression] = STATE(313),
    [sym_composite_literal] = STATE(313),
    [sym_func_literal] = STATE(313),
    [sym_unary_expression] = STATE(313),
    [sym_binary_expression] = STATE(313),
    [sym_qualified_type] = STATE(991),
    [sym_interpreted_string_literal] = STATE(313),
    [sym_identifier] = ACTIONS(226),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_LPAREN] = ACTIONS(230),
    [anon_sym_func] = ACTIONS(232),
    [anon_sym_STAR] = ACTIONS(234),
    [anon_sym_LBRACK] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_map] = ACTIONS(35),
    [anon_sym_chan] = ACTIONS(37),
    [anon_sym_LT_DASH] = ACTIONS(236),
    [anon_sym_range] = ACTIONS(238),
    [anon_sym_new] = ACTIONS(240),
    [anon_sym_make] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(242),
    [anon_sym_DASH] = ACTIONS(242),
    [anon_sym_BANG] = ACTIONS(242),
    [anon_sym_CARET] = ACTIONS(242),
    [anon_sym_AMP] = ACTIONS(242),
    [sym_raw_string_literal] = ACTIONS(244),
    [anon_sym_DQUOTE] = ACTIONS(246),
    [sym_int_literal] = ACTIONS(248),
    [sym_float_literal] = ACTIONS(248),
    [sym_imaginary_literal] = ACTIONS(244),
    [sym_rune_literal] = ACTIONS(244),
    [sym_nil] = ACTIONS(248),
    [sym_true] = ACTIONS(248),
    [sym_false] = ACTIONS(248),
    [sym_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(250), 1,
      anon_sym_LBRACE,
    STATE(725), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    STATE(1145), 1,
      sym__type_switch_header,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(252), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(254), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1138), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(326), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [110] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(256), 1,
      anon_sym_LBRACE,
    STATE(723), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(258), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(260), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1144), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(332), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [217] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(262), 1,
      anon_sym_LBRACE,
    STATE(723), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(258), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(260), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1130), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(332), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [324] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(264), 1,
      anon_sym_LBRACE,
    STATE(723), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(258), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(260), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1093), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(332), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [431] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(266), 1,
      anon_sym_LBRACE,
    STATE(723), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(258), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(260), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1104), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(332), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [538] = 16,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(278), 1,
      anon_sym_STAR,
    ACTIONS(280), 1,
      anon_sym_LBRACK,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(284), 1,
      anon_sym_LBRACE,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      anon_sym_LT_DASH,
    ACTIONS(294), 1,
      sym_comment,
    STATE(271), 1,
      sym_block,
    ACTIONS(268), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(234), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(272), 33,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [630] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(726), 1,
      sym_expression_list,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(296), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(298), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1127), 6,
      sym__simple_statement,
      sym_send_statement,
      sym_inc_statement,
      sym_dec_statement,
      sym_assignment_statement,
      sym_short_var_declaration,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(322), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [734] = 16,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(278), 1,
      anon_sym_STAR,
    ACTIONS(280), 1,
      anon_sym_LBRACK,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(284), 1,
      anon_sym_LBRACE,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      anon_sym_LT_DASH,
    ACTIONS(294), 1,
      sym_comment,
    STATE(262), 1,
      sym_block,
    ACTIONS(300), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(237), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(302), 33,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [826] = 14,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(306), 1,
      sym_identifier,
    ACTIONS(311), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      anon_sym_func,
    ACTIONS(317), 1,
      anon_sym_STAR,
    ACTIONS(320), 1,
      anon_sym_LBRACK,
    ACTIONS(323), 1,
      anon_sym_struct,
    ACTIONS(326), 1,
      anon_sym_interface,
    ACTIONS(329), 1,
      anon_sym_map,
    ACTIONS(332), 1,
      anon_sym_chan,
    ACTIONS(335), 1,
      anon_sym_LT_DASH,
    ACTIONS(304), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    STATE(258), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
    ACTIONS(309), 34,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_type,
      anon_sym_LBRACE,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [913] = 22,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(340), 1,
      anon_sym_LF,
    ACTIONS(344), 1,
      anon_sym_LPAREN,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(348), 1,
      anon_sym_STAR,
    ACTIONS(350), 1,
      anon_sym_LBRACK,
    ACTIONS(352), 1,
      anon_sym_LT_DASH,
    ACTIONS(360), 1,
      anon_sym_DQUOTE,
    STATE(844), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(342), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(356), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(358), 8,
      sym_raw_string_literal,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1016] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(372), 1,
      anon_sym_RBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1122] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(386), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(975), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1228] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1334] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(390), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1440] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1546] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(394), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(953), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1652] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(958), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1758] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(398), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1864] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(400), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1970] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2076] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(404), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1008), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2182] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2288] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(408), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2394] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(410), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2500] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(412), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2606] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1002), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2712] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2818] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(418), 1,
      anon_sym_RBRACE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1006), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2924] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    STATE(969), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1089), 2,
      sym_keyed_element,
      sym_element,
    ACTIONS(380), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(384), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(562), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3027] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1035), 1,
      sym_expression_list,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1156), 2,
      sym_send_statement,
      sym_receive_statement,
    ACTIONS(434), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(438), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(454), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3127] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(442), 1,
      anon_sym_RPAREN,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3226] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(454), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3325] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(456), 1,
      anon_sym_RPAREN,
    STATE(1001), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(458), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(460), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(530), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3424] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3523] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1030), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(466), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(468), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(569), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3622] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(470), 1,
      anon_sym_range,
    STATE(1032), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(472), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(474), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(511), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3721] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(476), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3820] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(478), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3919] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(480), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(482), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(484), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(486), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(619), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4018] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4117] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(490), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4216] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1034), 1,
      sym_literal_value,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(492), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(494), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(598), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4315] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(496), 1,
      anon_sym_RPAREN,
    STATE(961), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(498), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(500), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(512), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4414] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(502), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4513] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(504), 1,
      anon_sym_RPAREN,
    STATE(977), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(506), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(508), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(543), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4612] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(510), 1,
      anon_sym_RPAREN,
    STATE(956), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(512), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(514), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(515), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4711] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(516), 1,
      anon_sym_RPAREN,
    STATE(1000), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(518), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(520), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(513), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4810] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(470), 1,
      anon_sym_range,
    STATE(1031), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(472), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(474), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(511), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4909] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(526), 1,
      anon_sym_LBRACE,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    STATE(1153), 1,
      sym_expression_list,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(534), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(519), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5008] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(536), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5107] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(538), 1,
      anon_sym_RPAREN,
    STATE(1009), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(540), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(542), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(508), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5206] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(544), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5305] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5404] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(548), 1,
      anon_sym_RPAREN,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5503] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(550), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5599] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(556), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(558), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(560), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(614), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5695] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(562), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(564), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(566), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(576), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5791] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(841), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5887] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(839), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5983] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(580), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(582), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(584), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(600), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6079] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(586), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6175] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(588), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6271] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(590), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(592), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(594), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(570), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6367] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(596), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6463] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(598), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(600), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(602), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(586), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6559] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(604), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(606), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(608), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(630), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6655] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6751] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1032), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(612), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(614), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(556), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6847] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(616), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(618), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(620), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(571), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6943] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1031), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(612), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(614), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(556), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7039] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(622), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(624), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(626), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(583), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7135] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(628), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7231] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(484), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(486), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(619), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7327] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(856), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7423] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(878), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7519] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(630), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(632), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(634), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(602), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7615] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(636), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(640), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(572), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7711] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(642), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(644), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(646), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(585), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7807] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(875), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7903] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(865), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7999] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1049), 1,
      sym_variadic_argument,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(450), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(452), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(563), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8095] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(648), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(650), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(652), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(592), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8191] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(654), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(656), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(658), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(610), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8287] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(660), 1,
      anon_sym_SEMI,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(662), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(664), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(606), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8383] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(666), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(668), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(670), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(581), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8479] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(672), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8575] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(674), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(676), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(678), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(574), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8671] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1031), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(680), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(682), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(566), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8767] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(684), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(686), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(688), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(580), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8863] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(690), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8959] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1031), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(472), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(474), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(511), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9055] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1032), 1,
      sym_expression_list,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(472), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(474), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(511), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9151] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(692), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(694), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(696), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(575), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9247] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(869), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9343] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(698), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(700), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(702), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(599), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9439] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(704), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9535] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(706), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9631] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(708), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(710), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(712), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(578), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9727] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(714), 1,
      anon_sym_SEMI,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(716), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(718), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(624), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9823] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(870), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9919] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(867), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10015] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(720), 1,
      anon_sym_RBRACK,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(722), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(724), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(590), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10111] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(876), 1,
      sym_expression_list,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(576), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(358), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(450), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10207] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    STATE(1152), 1,
      sym_expression_list,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(472), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(474), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(511), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10303] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10399] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10495] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(730), 1,
      anon_sym_COLON,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(732), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(734), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(588), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10591] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(736), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(738), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(505), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10684] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(740), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(742), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(475), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10777] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(744), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(746), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(577), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10870] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(762), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(766), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(372), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10963] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(768), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(770), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(374), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11056] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(772), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(774), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(375), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11149] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(776), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(778), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(376), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11242] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(780), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(782), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(369), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11335] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(784), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(786), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(594), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11428] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(788), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(790), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(370), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11521] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(792), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(794), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(591), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11614] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(798), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(800), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(286), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11707] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(802), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(804), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(632), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11800] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(806), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(808), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(373), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11893] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(810), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(812), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(293), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11986] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(814), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(816), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(485), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12079] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(818), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(820), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(292), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12172] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(822), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(824), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(291), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12265] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(826), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(828), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(290), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12358] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(830), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(832), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(289), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12451] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(834), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(836), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(644), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12544] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(838), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(840), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(460), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12637] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(842), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(844), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(629), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12730] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(848), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(850), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(335), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12823] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(852), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(854), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(461), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12916] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(856), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(858), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(463), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13009] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(860), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(862), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(457), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13102] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(848), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(850), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(335), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13195] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(864), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(866), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(459), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13288] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(868), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(870), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(409), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13381] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(872), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(874), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(470), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13474] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13567] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(882), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(884), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(628), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13660] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(886), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(888), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(633), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13753] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(890), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(892), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(617), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13846] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(788), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(790), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1167), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(370), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13939] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(798), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(800), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(286), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14032] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(894), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(896), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(625), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14125] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(898), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(900), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(634), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14218] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(902), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(904), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(573), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14311] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(740), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(742), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(475), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14404] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14497] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(906), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(908), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(596), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14590] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(910), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(912), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(589), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14683] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(748), 1,
      sym_identifier,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_func,
    ACTIONS(754), 1,
      anon_sym_STAR,
    ACTIONS(756), 1,
      anon_sym_LT_DASH,
    ACTIONS(764), 1,
      anon_sym_DQUOTE,
    STATE(1033), 1,
      sym_implicit_length_array_type,
    ACTIONS(758), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(788), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(760), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(790), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(1023), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(370), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14776] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(914), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(916), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(612), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14869] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(918), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(920), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(615), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14962] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(922), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(924), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(456), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15055] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(740), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(742), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(475), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15148] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(922), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(924), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(456), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15241] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(926), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(928), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(609), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15334] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(930), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(932), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(490), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15427] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(934), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(936), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(504), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15520] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(938), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(940), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(503), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15613] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(420), 1,
      sym_identifier,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    ACTIONS(424), 1,
      anon_sym_func,
    ACTIONS(426), 1,
      anon_sym_STAR,
    ACTIONS(428), 1,
      anon_sym_LT_DASH,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    STATE(1070), 1,
      sym_implicit_length_array_type,
    ACTIONS(430), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(942), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(432), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(944), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(945), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1168), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(501), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15706] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(946), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(948), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(603), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15799] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(922), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(924), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(456), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15892] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(950), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(952), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(493), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15985] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16078] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(954), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(956), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(492), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16171] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16264] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(958), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(960), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(631), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16357] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(962), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(964), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(327), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16450] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(966), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(968), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(331), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16543] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(970), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(972), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(329), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16636] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(974), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(976), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(621), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16729] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(978), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(980), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(597), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16822] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(346), 1,
      anon_sym_func,
    ACTIONS(568), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      anon_sym_STAR,
    ACTIONS(572), 1,
      anon_sym_LT_DASH,
    ACTIONS(578), 1,
      anon_sym_DQUOTE,
    STATE(1086), 1,
      sym_implicit_length_array_type,
    ACTIONS(354), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(982), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(574), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(984), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(966), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1165), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(452), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16915] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(986), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(988), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(605), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17008] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(990), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(992), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(328), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17101] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(994), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(996), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(579), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17194] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(998), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1000), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(330), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17287] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1002), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1004), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(618), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17380] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_STAR,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(39), 1,
      anon_sym_LT_DASH,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(178), 1,
      anon_sym_func,
    ACTIONS(796), 1,
      sym_identifier,
    STATE(1063), 1,
      sym_implicit_length_array_type,
    ACTIONS(63), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(798), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(65), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(800), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(957), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1094), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(286), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17473] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(552), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(554), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(587), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17566] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1006), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1008), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(626), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17659] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1010), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1012), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(607), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17752] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1014), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1016), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(623), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17845] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1018), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1020), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(551), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17938] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1022), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1024), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(616), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18031] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1026), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1028), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(552), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18124] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18217] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1030), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1032), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(620), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18310] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1034), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1036), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(449), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18403] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18496] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    ACTIONS(464), 1,
      sym_identifier,
    ACTIONS(880), 1,
      anon_sym_STAR,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1038), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1040), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1073), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(611), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18589] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1042), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1044), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(557), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18682] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18775] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(868), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(870), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(409), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18868] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1046), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1048), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(448), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18961] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1050), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1052), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(445), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19054] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19147] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1054), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1056), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(447), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19240] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(868), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(870), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(409), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19333] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1058), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1060), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(553), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19426] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(846), 1,
      anon_sym_chan,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19519] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(230), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      anon_sym_func,
    ACTIONS(234), 1,
      anon_sym_STAR,
    ACTIONS(236), 1,
      anon_sym_LT_DASH,
    ACTIONS(246), 1,
      anon_sym_DQUOTE,
    STATE(1058), 1,
      sym_implicit_length_array_type,
    ACTIONS(240), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(848), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(242), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(850), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(991), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1166), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(335), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19612] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(876), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(878), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1090), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(411), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19705] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1062), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1064), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(604), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19798] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1066), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1068), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(561), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19891] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(368), 1,
      anon_sym_STAR,
    ACTIONS(374), 1,
      anon_sym_LT_DASH,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      sym_identifier,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1070), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(378), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1072), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(613), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19984] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1074), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1076), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(554), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20077] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(440), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_STAR,
    ACTIONS(446), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1078), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(448), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1080), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(555), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20170] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(364), 1,
      anon_sym_LPAREN,
    ACTIONS(366), 1,
      anon_sym_func,
    ACTIONS(382), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      sym_identifier,
    ACTIONS(524), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    STATE(1060), 1,
      sym_implicit_length_array_type,
    ACTIONS(376), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(1082), 3,
      sym_raw_string_literal,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(1084), 5,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
    STATE(930), 5,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
      sym_qualified_type,
    STATE(1162), 6,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    STATE(560), 13,
      sym__expression,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20263] = 8,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    ACTIONS(1096), 1,
      anon_sym_LBRACE,
    ACTIONS(1098), 1,
      anon_sym_COLON,
    STATE(300), 1,
      sym_literal_value,
    ACTIONS(1088), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [20328] = 5,
    ACTIONS(284), 1,
      anon_sym_LBRACE,
    ACTIONS(294), 1,
      sym_comment,
    STATE(264), 1,
      sym_block,
    ACTIONS(1100), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1102), 43,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20387] = 4,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1108), 1,
      anon_sym_DOT,
    ACTIONS(1104), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1106), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20444] = 8,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    ACTIONS(1096), 1,
      anon_sym_LBRACE,
    ACTIONS(1110), 1,
      anon_sym_COLON,
    STATE(300), 1,
      sym_literal_value,
    ACTIONS(1088), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [20509] = 5,
    ACTIONS(284), 1,
      anon_sym_LBRACE,
    ACTIONS(294), 1,
      sym_comment,
    STATE(245), 1,
      sym_block,
    ACTIONS(1112), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1114), 43,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20568] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1116), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1118), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20622] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1120), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1122), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20676] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1124), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1126), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20730] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1128), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1130), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20784] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1132), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1134), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20838] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1136), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1138), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20892] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1140), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1142), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [20946] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1144), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1146), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21000] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1148), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1150), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21054] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1152), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1154), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21108] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1156), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1158), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21162] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1160), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1162), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21216] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1164), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1166), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21270] = 5,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1168), 1,
      ts_builtin_sym_end,
    ACTIONS(1172), 1,
      anon_sym_LF,
    ACTIONS(1174), 1,
      anon_sym_SEMI,
    ACTIONS(1170), 43,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21328] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1177), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1179), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21382] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1181), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1183), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21436] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1185), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1187), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21490] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1189), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1191), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21544] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1193), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1195), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21598] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1197), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1199), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21652] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1201), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1203), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21706] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1205), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1207), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21760] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1209), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1211), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21814] = 18,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_LF,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1221), 1,
      anon_sym_COMMA,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1229), 1,
      anon_sym_LT_DASH,
    ACTIONS(1231), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1233), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1239), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1241), 1,
      anon_sym_PIPE_PIPE,
    STATE(298), 1,
      sym_argument_list,
    STATE(720), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1215), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1235), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1237), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1225), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1223), 13,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [21898] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1243), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1245), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [21952] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1247), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1249), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22006] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1251), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1253), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22060] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1255), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1257), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22114] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1259), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1261), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22168] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1263), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1265), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22222] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1255), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1257), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22276] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1267), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1269), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22330] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1271), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1273), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22384] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1275), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1277), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22438] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1279), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1281), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22492] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1283), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1285), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22546] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1255), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1257), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22600] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1287), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1289), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22654] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1291), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1293), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22708] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1295), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1297), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22762] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1299), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1301), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22816] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1303), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1305), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22870] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1307), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1309), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [22924] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    ACTIONS(1096), 1,
      anon_sym_LBRACE,
    STATE(300), 1,
      sym_literal_value,
    ACTIONS(1088), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [22986] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1311), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1313), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [23040] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1315), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(1317), 44,
      anon_sym_SEMI,
      anon_sym_package,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_struct,
      anon_sym_LBRACE,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_LT_DASH,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_identifier,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
  [23094] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_LF,
    ACTIONS(1166), 44,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23147] = 5,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1319), 1,
      anon_sym_LPAREN,
    STATE(298), 1,
      sym_special_argument_list,
    ACTIONS(1088), 42,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23204] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1321), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1323), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23265] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1307), 1,
      anon_sym_LF,
    ACTIONS(1309), 44,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_imaginary_literal,
      sym_rune_literal,
    ACTIONS(1325), 29,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      sym_identifier,
      sym_int_literal,
      sym_float_literal,
      sym_nil,
      sym_true,
      sym_false,
  [23371] = 11,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1239), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1327), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1235), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1237), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1225), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 22,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
  [23440] = 10,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1327), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1235), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1237), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1225), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23507] = 9,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1327), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1235), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1225), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 29,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23572] = 8,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1327), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1225), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23635] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1217), 1,
      anon_sym_DOT,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1227), 1,
      anon_sym_LBRACK,
    ACTIONS(1327), 1,
      anon_sym_LF,
    STATE(298), 1,
      sym_argument_list,
    ACTIONS(1329), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23696] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1331), 1,
      anon_sym_LF,
    ACTIONS(1333), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23748] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1335), 1,
      anon_sym_LF,
    ACTIONS(1337), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23800] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1339), 1,
      anon_sym_LF,
    ACTIONS(1341), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23852] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1343), 1,
      anon_sym_LF,
    ACTIONS(1345), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23904] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1347), 1,
      anon_sym_LF,
    ACTIONS(1349), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [23956] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_LF,
    ACTIONS(1353), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24008] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_LF,
    ACTIONS(1357), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24060] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1303), 1,
      anon_sym_LF,
    ACTIONS(1305), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24112] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_LF,
    ACTIONS(1361), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24164] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_LF,
    ACTIONS(1365), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24216] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_LF,
    ACTIONS(1369), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24268] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_LF,
    ACTIONS(1373), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24320] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1375), 1,
      anon_sym_LF,
    ACTIONS(1377), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24372] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1379), 1,
      anon_sym_LF,
    ACTIONS(1381), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24424] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_LF,
    ACTIONS(1187), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24476] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1383), 1,
      anon_sym_LF,
    ACTIONS(1385), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24528] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1387), 1,
      anon_sym_LF,
    ACTIONS(1389), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24580] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_LF,
    ACTIONS(1393), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24632] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1395), 1,
      anon_sym_LF,
    ACTIONS(1397), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24684] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(1213), 1,
      anon_sym_SEMI,
    ACTIONS(1223), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    ACTIONS(1409), 1,
      anon_sym_LT_DASH,
    ACTIONS(1413), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1415), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1423), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1425), 1,
      anon_sym_PIPE_PIPE,
    STATE(340), 1,
      sym_argument_list,
    STATE(720), 1,
      aux_sym_expression_list_repeat1,
    STATE(850), 1,
      sym_block,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1411), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [24772] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1427), 1,
      anon_sym_LF,
    ACTIONS(1429), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24824] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_LF,
    ACTIONS(1433), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24876] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1435), 1,
      anon_sym_LF,
    ACTIONS(1437), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24928] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1439), 1,
      anon_sym_LF,
    ACTIONS(1441), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [24980] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1443), 1,
      anon_sym_LF,
    ACTIONS(1445), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25032] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1447), 1,
      anon_sym_LF,
    ACTIONS(1449), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25084] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1451), 1,
      anon_sym_LF,
    ACTIONS(1453), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25136] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1455), 1,
      anon_sym_LF,
    ACTIONS(1457), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25188] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(1213), 1,
      anon_sym_SEMI,
    ACTIONS(1223), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    ACTIONS(1409), 1,
      anon_sym_LT_DASH,
    ACTIONS(1413), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1415), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1423), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1425), 1,
      anon_sym_PIPE_PIPE,
    STATE(340), 1,
      sym_argument_list,
    STATE(720), 1,
      aux_sym_expression_list_repeat1,
    STATE(820), 1,
      sym_block,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1411), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [25276] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1459), 1,
      anon_sym_LF,
    ACTIONS(1461), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25328] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_LF,
    ACTIONS(1465), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25380] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LF,
    ACTIONS(1469), 43,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25432] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_SEMI,
    ACTIONS(1223), 1,
      anon_sym_EQ,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    ACTIONS(1409), 1,
      anon_sym_LT_DASH,
    ACTIONS(1413), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1415), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1423), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1425), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1471), 1,
      anon_sym_DOT,
    ACTIONS(1473), 1,
      anon_sym_LBRACE,
    STATE(340), 1,
      sym_argument_list,
    STATE(720), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1411), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [25517] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    ACTIONS(1423), 1,
      anon_sym_AMP_AMP,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [25585] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1329), 7,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25645] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1329), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25707] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1329), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1327), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25765] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25831] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_LBRACE,
    ACTIONS(1223), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    ACTIONS(1413), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1415), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1423), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1425), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1475), 1,
      anon_sym_LT_DASH,
    STATE(340), 1,
      sym_argument_list,
    STATE(720), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1421), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1417), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1419), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1405), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1411), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [25913] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 1,
      anon_sym_LPAREN,
    STATE(340), 1,
      sym_special_argument_list,
    ACTIONS(1088), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [25967] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    STATE(352), 1,
      sym_literal_value,
    ACTIONS(1088), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 25,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26023] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      anon_sym_DOT,
    ACTIONS(1401), 1,
      anon_sym_LPAREN,
    ACTIONS(1407), 1,
      anon_sym_LBRACK,
    STATE(340), 1,
      sym_argument_list,
    ACTIONS(1323), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1321), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1391), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1375), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26179] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1343), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1339), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1347), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1455), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1363), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1331), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1431), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1459), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26571] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1164), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26620] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1451), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1351), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1467), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1443), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1435), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1355), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1463), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1303), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1395), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1185), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1439), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1367), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27208] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1447), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1335), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1359), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1427), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1383), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1307), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1387), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1379), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1371), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27649] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    ACTIONS(1485), 1,
      anon_sym_LBRACE,
    STATE(383), 1,
      sym_literal_value,
    ACTIONS(1088), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 20,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27703] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_EQ,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    ACTIONS(1501), 1,
      anon_sym_AMP_AMP,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1499), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1495), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1497), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1491), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 14,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [27766] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1323), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1321), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27819] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 1,
      anon_sym_LPAREN,
    STATE(382), 1,
      sym_special_argument_list,
    ACTIONS(1088), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 21,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27868] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1329), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1327), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27921] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    ACTIONS(1501), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1507), 1,
      anon_sym_EQ,
    ACTIONS(1509), 1,
      anon_sym_PIPE_PIPE,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1499), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1495), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1497), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1491), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1505), 13,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [27986] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1329), 7,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1491), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28041] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1329), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1495), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1491), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28098] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1329), 1,
      anon_sym_EQ,
    ACTIONS(1487), 1,
      anon_sym_DOT,
    ACTIONS(1489), 1,
      anon_sym_LPAREN,
    ACTIONS(1493), 1,
      anon_sym_LBRACK,
    STATE(382), 1,
      sym_argument_list,
    ACTIONS(1499), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1495), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1497), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1491), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 15,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1463), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1383), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1459), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1467), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1164), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1347), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1355), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1367), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1391), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1351), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1339), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1363), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1375), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1303), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1447), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1395), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1379), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1427), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1435), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1451), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1439), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1185), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1343), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1455), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1431), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1443), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1331), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29347] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1335), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29391] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1307), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1387), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1371), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1359), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29567] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1329), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1327), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29616] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_LPAREN,
    STATE(433), 1,
      sym_special_argument_list,
    ACTIONS(1088), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 23,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29661] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1323), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1321), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1375), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1335), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29790] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1331), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1387), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1443), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1431), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1455), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1307), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1343), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1463), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1439), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1185), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1435), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1383), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1379), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1164), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1303), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30390] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1363), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1447), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1467), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1459), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30550] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1347), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30590] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1371), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1451), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30670] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1427), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1355), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1367), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30790] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    STATE(437), 1,
      sym_literal_value,
    ACTIONS(1482), 2,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(1088), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1395), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30878] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1339), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1359), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1351), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30998] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 8,
      anon_sym_DOT,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1391), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31038] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1329), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 11,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31092] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    ACTIONS(1529), 1,
      anon_sym_LBRACE,
    STATE(482), 1,
      sym_literal_value,
    ACTIONS(1088), 25,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31138] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1329), 5,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31188] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31246] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
  [31306] = 14,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1541), 1,
      anon_sym_COMMA,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1553), 1,
      anon_sym_PIPE_PIPE,
    STATE(483), 1,
      sym_argument_list,
    STATE(766), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1223), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31366] = 20,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1557), 1,
      anon_sym_LF,
    ACTIONS(1561), 1,
      anon_sym_DOT,
    ACTIONS(1563), 1,
      anon_sym_LPAREN,
    ACTIONS(1565), 1,
      anon_sym_COMMA,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1569), 1,
      anon_sym_STAR,
    ACTIONS(1571), 1,
      anon_sym_LBRACK,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1581), 1,
      anon_sym_LT_DASH,
    ACTIONS(1583), 1,
      sym_raw_string_literal,
    ACTIONS(1585), 1,
      anon_sym_DQUOTE,
    STATE(640), 1,
      aux_sym_field_name_list_repeat1,
    STATE(1026), 1,
      sym_interpreted_string_literal,
    ACTIONS(1559), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(809), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [31438] = 12,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1505), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1553), 1,
      anon_sym_PIPE_PIPE,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1507), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31493] = 17,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1589), 1,
      anon_sym_LF,
    ACTIONS(1593), 1,
      anon_sym_LPAREN,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1597), 1,
      anon_sym_EQ,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1601), 1,
      anon_sym_STAR,
    ACTIONS(1603), 1,
      anon_sym_LBRACK,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1609), 1,
      anon_sym_LT_DASH,
    STATE(711), 1,
      aux_sym_const_spec_repeat1,
    ACTIONS(1591), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(1096), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [31558] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1223), 1,
      anon_sym_EQ,
    ACTIONS(1409), 1,
      anon_sym_LT_DASH,
    ACTIONS(1411), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    ACTIONS(1621), 1,
      anon_sym_COLON,
    ACTIONS(1627), 1,
      anon_sym_PIPE,
    ACTIONS(1633), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1635), 1,
      anon_sym_PIPE_PIPE,
    STATE(525), 1,
      sym_argument_list,
    STATE(808), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1625), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1631), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1623), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1617), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31627] = 5,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1086), 1,
      anon_sym_LF,
    ACTIONS(1637), 1,
      anon_sym_LPAREN,
    STATE(483), 1,
      sym_special_argument_list,
    ACTIONS(1088), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31668] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1321), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1323), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31713] = 8,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31760] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    ACTIONS(1639), 1,
      anon_sym_LBRACE,
    STATE(526), 1,
      sym_literal_value,
    ACTIONS(1088), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 18,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31805] = 7,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1329), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31850] = 11,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1329), 6,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31903] = 10,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1329), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [31954] = 17,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1593), 1,
      anon_sym_LPAREN,
    ACTIONS(1595), 1,
      anon_sym_COMMA,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1601), 1,
      anon_sym_STAR,
    ACTIONS(1603), 1,
      anon_sym_LBRACK,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1609), 1,
      anon_sym_LT_DASH,
    ACTIONS(1641), 1,
      anon_sym_LF,
    ACTIONS(1645), 1,
      anon_sym_EQ,
    STATE(453), 1,
      aux_sym_const_spec_repeat1,
    ACTIONS(1643), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    STATE(1155), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [32019] = 9,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_LF,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1329), 13,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32068] = 14,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_LF,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1569), 1,
      anon_sym_STAR,
    ACTIONS(1571), 1,
      anon_sym_LBRACK,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1581), 1,
      anon_sym_LT_DASH,
    ACTIONS(1647), 1,
      anon_sym_LPAREN,
    ACTIONS(309), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
    STATE(754), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [32127] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1303), 1,
      anon_sym_LF,
    ACTIONS(1305), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32163] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1395), 1,
      anon_sym_LF,
    ACTIONS(1397), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32199] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1335), 1,
      anon_sym_LF,
    ACTIONS(1337), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32235] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1375), 1,
      anon_sym_LF,
    ACTIONS(1377), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32271] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1439), 1,
      anon_sym_LF,
    ACTIONS(1441), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32307] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1507), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1505), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [32367] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_LF,
    ACTIONS(1465), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32403] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1387), 1,
      anon_sym_LF,
    ACTIONS(1389), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32439] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1339), 1,
      anon_sym_LF,
    ACTIONS(1341), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32475] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1447), 1,
      anon_sym_LF,
    ACTIONS(1449), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32511] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1323), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1321), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32555] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1435), 1,
      anon_sym_LF,
    ACTIONS(1437), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32591] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1383), 1,
      anon_sym_LF,
    ACTIONS(1385), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32627] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_LF,
    ACTIONS(1373), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32663] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_LF,
    ACTIONS(1361), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32699] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_LF,
    ACTIONS(1365), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32735] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1343), 1,
      anon_sym_LF,
    ACTIONS(1345), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32771] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_LF,
    ACTIONS(1357), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32807] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1347), 1,
      anon_sym_LF,
    ACTIONS(1349), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32843] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_LF,
    ACTIONS(1393), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32879] = 12,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1651), 1,
      anon_sym_LF,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1653), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [32933] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1455), 1,
      anon_sym_LF,
    ACTIONS(1457), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32969] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1655), 1,
      anon_sym_LPAREN,
    STATE(525), 1,
      sym_special_argument_list,
    ACTIONS(1088), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 19,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33009] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1185), 1,
      anon_sym_LF,
    ACTIONS(1187), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33045] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_LF,
    ACTIONS(1369), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33081] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1329), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1327), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33125] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1427), 1,
      anon_sym_LF,
    ACTIONS(1429), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33161] = 12,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1657), 1,
      anon_sym_LF,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1659), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33215] = 12,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1537), 1,
      anon_sym_DOT,
    ACTIONS(1539), 1,
      anon_sym_LPAREN,
    ACTIONS(1545), 1,
      anon_sym_LBRACK,
    ACTIONS(1551), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1553), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1661), 1,
      anon_sym_LF,
    STATE(483), 1,
      sym_argument_list,
    ACTIONS(1547), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1663), 4,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(1549), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1543), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33269] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_LF,
    ACTIONS(1353), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33305] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1379), 1,
      anon_sym_LF,
    ACTIONS(1381), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33341] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_LF,
    ACTIONS(1469), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33377] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1459), 1,
      anon_sym_LF,
    ACTIONS(1461), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33413] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1451), 1,
      anon_sym_LF,
    ACTIONS(1453), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33449] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1331), 1,
      anon_sym_LF,
    ACTIONS(1333), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33485] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1443), 1,
      anon_sym_LF,
    ACTIONS(1445), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33521] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    ACTIONS(1627), 1,
      anon_sym_PIPE,
    ACTIONS(1633), 1,
      anon_sym_AMP_AMP,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1625), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1631), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1623), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1327), 4,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1617), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33579] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_LF,
    ACTIONS(1433), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33615] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    ACTIONS(1627), 1,
      anon_sym_PIPE,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_EQ,
      anon_sym_COLON,
    ACTIONS(1625), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1631), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1623), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1629), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1327), 5,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1617), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33671] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    ACTIONS(1627), 1,
      anon_sym_PIPE,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1625), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1623), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1329), 4,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1617), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 9,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33723] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_DOT,
    ACTIONS(1613), 1,
      anon_sym_LPAREN,
    ACTIONS(1619), 1,
      anon_sym_LBRACK,
    STATE(525), 1,
      sym_argument_list,
    ACTIONS(1625), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1329), 5,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1617), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 12,
      anon_sym_COMMA,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33771] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1307), 1,
      anon_sym_LF,
    ACTIONS(1309), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33807] = 3,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1164), 1,
      anon_sym_LF,
    ACTIONS(1166), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33843] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1665), 1,
      anon_sym_RPAREN,
    ACTIONS(1667), 1,
      anon_sym_COMMA,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    STATE(1019), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [33906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1439), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33941] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    STATE(437), 1,
      sym_literal_value,
    ACTIONS(1088), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33984] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    STATE(808), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1411), 2,
      anon_sym_SEMI,
      anon_sym_COLON,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34045] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1687), 1,
      anon_sym_RPAREN,
    ACTIONS(1689), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(982), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34108] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1691), 1,
      anon_sym_RPAREN,
    ACTIONS(1693), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(993), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1367), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34206] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1695), 1,
      anon_sym_RPAREN,
    ACTIONS(1697), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(974), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1391), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34304] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1699), 1,
      anon_sym_LPAREN,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(304), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
    STATE(775), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [34359] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_LBRACE,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    ACTIONS(1707), 1,
      anon_sym_COLON,
    STATE(437), 1,
      sym_literal_value,
    ACTIONS(1088), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 17,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34404] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    ACTIONS(1709), 1,
      anon_sym_DOT,
    ACTIONS(1713), 1,
      anon_sym_LBRACE,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    STATE(808), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1351), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1339), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1375), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1185), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34607] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1166), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1164), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1347), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1355), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1363), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1447), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1335), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34817] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1729), 1,
      anon_sym_RPAREN,
    ACTIONS(1731), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(941), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [34880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1395), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1379), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1383), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34985] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1435), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35020] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1307), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35055] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1387), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35090] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1371), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1303), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1359), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1427), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35230] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1467), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1459), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35300] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1733), 1,
      anon_sym_RPAREN,
    ACTIONS(1735), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(979), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1451), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35398] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1331), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35433] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1443), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1431), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1455), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35538] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1343), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 7,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1463), 20,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35608] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1329), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 12,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35654] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1327), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35708] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1327), 5,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35760] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 9,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35810] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1329), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 12,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35856] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_LBRACE,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1737), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    STATE(1018), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [35916] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1329), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(1327), 9,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [35966] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_DOT,
    ACTIONS(1482), 1,
      anon_sym_LPAREN,
    STATE(437), 1,
      sym_literal_value,
    ACTIONS(1088), 5,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1086), 18,
      anon_sym_COMMA,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [36006] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1743), 1,
      anon_sym_RPAREN,
    ACTIONS(1745), 1,
      anon_sym_COMMA,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(1014), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36066] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1327), 5,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36118] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1327), 4,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_COLON_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36172] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1751), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1749), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36230] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      anon_sym_DOT,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1669), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1753), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36288] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1755), 1,
      anon_sym_RPAREN,
    ACTIONS(1757), 1,
      anon_sym_COMMA,
    STATE(946), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36348] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1104), 1,
      anon_sym_RPAREN,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1759), 1,
      anon_sym_DOT,
    ACTIONS(1761), 1,
      anon_sym_COMMA,
    ACTIONS(1764), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(642), 1,
      aux_sym_const_spec_repeat1,
    STATE(1078), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36410] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_SEMI,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1615), 1,
      anon_sym_COMMA,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1766), 1,
      anon_sym_DOT,
    STATE(433), 1,
      sym_argument_list,
    STATE(808), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36470] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1768), 1,
      anon_sym_RPAREN,
    ACTIONS(1770), 1,
      anon_sym_COMMA,
    STATE(1010), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36530] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1772), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [36587] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1774), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36642] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1776), 1,
      anon_sym_RBRACK,
    ACTIONS(1778), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36699] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1780), 1,
      anon_sym_RBRACK,
    ACTIONS(1782), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36756] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1784), 1,
      anon_sym_RBRACK,
    ACTIONS(1786), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36813] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1788), 1,
      anon_sym_RPAREN,
    ACTIONS(1790), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36870] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1792), 1,
      anon_sym_RBRACK,
    ACTIONS(1794), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36927] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1796), 1,
      anon_sym_RBRACK,
    ACTIONS(1798), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [36984] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1800), 1,
      anon_sym_RBRACK,
    ACTIONS(1802), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37041] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1804), 1,
      anon_sym_RPAREN,
    ACTIONS(1806), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37098] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1808), 1,
      anon_sym_RBRACK,
    ACTIONS(1810), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37155] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1812), 1,
      anon_sym_RPAREN,
    ACTIONS(1814), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37212] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1816), 1,
      anon_sym_RBRACK,
    ACTIONS(1818), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37269] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1820), 1,
      anon_sym_RBRACK,
    ACTIONS(1822), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37326] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1824), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37383] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1826), 1,
      anon_sym_RBRACK,
    ACTIONS(1828), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37440] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1830), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [37497] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1832), 1,
      anon_sym_RBRACK,
    ACTIONS(1834), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37554] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1836), 1,
      anon_sym_RBRACK,
    ACTIONS(1838), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37611] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1505), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37666] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1840), 1,
      anon_sym_RBRACK,
    ACTIONS(1842), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37723] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1844), 1,
      anon_sym_RPAREN,
    ACTIONS(1846), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37780] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1848), 1,
      anon_sym_RBRACK,
    ACTIONS(1850), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37837] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1852), 1,
      anon_sym_RPAREN,
    ACTIONS(1854), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37894] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1856), 1,
      anon_sym_RBRACK,
    ACTIONS(1858), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [37951] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1860), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [38008] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1651), 2,
      anon_sym_SEMI,
      anon_sym_COLON,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38063] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1862), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [38120] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1505), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38175] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    STATE(811), 1,
      sym_block,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38232] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1864), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38287] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1866), 1,
      anon_sym_RBRACK,
    ACTIONS(1868), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38344] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1870), 1,
      anon_sym_RBRACK,
    ACTIONS(1872), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38401] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1874), 1,
      anon_sym_RPAREN,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [38458] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1876), 1,
      anon_sym_RBRACK,
    ACTIONS(1878), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38515] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1880), 1,
      anon_sym_RPAREN,
    ACTIONS(1882), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38572] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1884), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38626] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1651), 1,
      anon_sym_LBRACE,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38680] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1886), 1,
      anon_sym_SEMI,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38734] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1888), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38788] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1892), 1,
      anon_sym_COMMA,
    ACTIONS(1894), 1,
      anon_sym_EQ,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    STATE(622), 1,
      aux_sym_const_spec_repeat1,
    STATE(790), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [38844] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1902), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38898] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1904), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [38952] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1906), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39006] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1908), 1,
      anon_sym_LBRACE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39060] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1910), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39114] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1912), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39168] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1914), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39222] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    ACTIONS(1725), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1727), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1916), 1,
      anon_sym_LBRACE,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1717), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1723), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1715), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1721), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1711), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39276] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1918), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39330] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1920), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39384] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1922), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39438] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1924), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39492] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1926), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39546] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1892), 1,
      anon_sym_COMMA,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    ACTIONS(1928), 1,
      anon_sym_EQ,
    STATE(722), 1,
      aux_sym_const_spec_repeat1,
    STATE(807), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [39602] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1930), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39656] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1932), 1,
      anon_sym_SEMI,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39710] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1934), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39764] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1936), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39818] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(304), 1,
      anon_sym_RPAREN,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1947), 1,
      anon_sym_LBRACE,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    STATE(413), 1,
      sym_block,
    STATE(891), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [39874] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1951), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39928] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1953), 1,
      anon_sym_COLON,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [39982] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1955), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40036] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1957), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40090] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1959), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40144] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1961), 1,
      anon_sym_RBRACK,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40198] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1519), 1,
      anon_sym_DOT,
    ACTIONS(1677), 1,
      anon_sym_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1685), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1963), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1675), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1681), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1673), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1679), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1671), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40252] = 14,
    ACTIONS(294), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1569), 1,
      anon_sym_STAR,
    ACTIONS(1571), 1,
      anon_sym_LBRACK,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1581), 1,
      anon_sym_LT_DASH,
    ACTIONS(1647), 1,
      anon_sym_LPAREN,
    ACTIONS(1965), 1,
      anon_sym_LF,
    ACTIONS(1967), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    STATE(985), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40306] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1739), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1747), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(1079), 2,
      sym_parameter_declaration,
      sym_variadic_parameter_declaration,
    STATE(1045), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40360] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(1969), 1,
      anon_sym_LBRACE,
    STATE(360), 1,
      sym_block,
    STATE(1004), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40413] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(1971), 1,
      anon_sym_LBRACE,
    STATE(529), 1,
      sym_block,
    STATE(950), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40466] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    STATE(295), 1,
      sym_block,
    STATE(1003), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40519] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    ACTIONS(1973), 1,
      anon_sym_COMMA,
    STATE(728), 1,
      aux_sym_field_name_list_repeat1,
    STATE(814), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40572] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(1975), 1,
      anon_sym_LBRACE,
    STATE(404), 1,
      sym_block,
    STATE(1016), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40625] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1892), 1,
      anon_sym_COMMA,
    STATE(722), 1,
      aux_sym_const_spec_repeat1,
    STATE(1083), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40678] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(1977), 1,
      sym_identifier,
    STATE(295), 1,
      sym_block,
    STATE(1003), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40731] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_LPAREN,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    ACTIONS(1527), 1,
      anon_sym_PIPE,
    ACTIONS(1535), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1649), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1979), 1,
      anon_sym_DOT,
    STATE(433), 1,
      sym_argument_list,
    ACTIONS(1525), 2,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(1533), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1523), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(1531), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1521), 5,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
  [40782] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(304), 2,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
    STATE(775), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40833] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1938), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    ACTIONS(1981), 1,
      anon_sym_LBRACE,
    STATE(467), 1,
      sym_block,
    STATE(947), 11,
      sym_parameter_list,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40886] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1983), 1,
      anon_sym_type,
    STATE(1100), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40936] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1985), 1,
      anon_sym_type,
    STATE(1150), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [40986] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    ACTIONS(1987), 1,
      anon_sym_EQ,
    STATE(838), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41036] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1989), 1,
      anon_sym_type,
    STATE(1100), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41086] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1991), 1,
      anon_sym_type,
    STATE(1100), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41136] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    STATE(788), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41183] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1151), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41230] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(765), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41277] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1085), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41324] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(1999), 1,
      anon_sym_LT_DASH,
    STATE(272), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41371] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1158), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41418] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(1999), 1,
      anon_sym_LT_DASH,
    STATE(274), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41465] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(788), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41512] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1123), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41559] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(1999), 1,
      anon_sym_LT_DASH,
    STATE(256), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41606] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    STATE(776), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41653] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    STATE(739), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41700] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(2001), 1,
      anon_sym_LT_DASH,
    STATE(268), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41747] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1011), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41794] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(779), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41841] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(2003), 1,
      anon_sym_LT_DASH,
    STATE(737), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41888] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(776), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41935] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(2005), 1,
      anon_sym_LT_DASH,
    STATE(768), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [41982] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1119), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42029] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(2001), 1,
      anon_sym_LT_DASH,
    STATE(242), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42076] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(276), 1,
      anon_sym_func,
    ACTIONS(282), 1,
      anon_sym_struct,
    ACTIONS(286), 1,
      anon_sym_interface,
    ACTIONS(288), 1,
      anon_sym_map,
    ACTIONS(290), 1,
      anon_sym_chan,
    ACTIONS(1993), 1,
      anon_sym_LPAREN,
    ACTIONS(1995), 1,
      anon_sym_STAR,
    ACTIONS(1997), 1,
      anon_sym_LBRACK,
    ACTIONS(1999), 1,
      anon_sym_LT_DASH,
    STATE(277), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42123] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(2007), 1,
      anon_sym_chan,
    STATE(760), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42170] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    STATE(740), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42217] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    STATE(744), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42264] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR,
    ACTIONS(1898), 1,
      anon_sym_LBRACK,
    ACTIONS(1900), 1,
      anon_sym_LT_DASH,
    ACTIONS(2009), 1,
      anon_sym_chan,
    STATE(747), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42311] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(35), 1,
      anon_sym_map,
    ACTIONS(37), 1,
      anon_sym_chan,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    ACTIONS(1941), 1,
      anon_sym_func,
    ACTIONS(1943), 1,
      anon_sym_STAR,
    ACTIONS(1945), 1,
      anon_sym_LBRACK,
    ACTIONS(1949), 1,
      anon_sym_LT_DASH,
    STATE(779), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42358] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(33), 1,
      anon_sym_interface,
    ACTIONS(1587), 1,
      sym_identifier,
    ACTIONS(1599), 1,
      anon_sym_func,
    ACTIONS(1605), 1,
      anon_sym_map,
    ACTIONS(1607), 1,
      anon_sym_chan,
    ACTIONS(1701), 1,
      anon_sym_STAR,
    ACTIONS(1703), 1,
      anon_sym_LBRACK,
    ACTIONS(1705), 1,
      anon_sym_LT_DASH,
    ACTIONS(1741), 1,
      anon_sym_LPAREN,
    STATE(1116), 11,
      sym_parenthesized_type,
      sym__simple_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
      sym_qualified_type,
  [42405] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
    ACTIONS(1567), 1,
      anon_sym_func,
    ACTIONS(1573), 1,
      anon_sym_struct,
    ACTIONS(1575), 1,
      anon_sym_interface,
    ACTIONS(1577), 1,
      anon_sym_map,
    ACTIONS(1579), 1,
      anon_sym_chan,
    ACTIONS(1890), 1,
      anon_sym_LPAREN,
    ACTIONS(1896), 1,
      anon_sym_STAR