#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 2969
#define LARGE_STATE_COUNT 664
#define SYMBOL_COUNT 389
#define ALIAS_COUNT 1
#define TOKEN_COUNT 171
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 11

enum {
  sym_identifier = 1,
  anon_sym_extern = 2,
  anon_sym_alias = 3,
  anon_sym_SEMI = 4,
  anon_sym_using = 5,
  anon_sym_static = 6,
  anon_sym_EQ = 7,
  anon_sym_COLON_COLON = 8,
  anon_sym_LT = 9,
  anon_sym_COMMA = 10,
  anon_sym_GT = 11,
  anon_sym_DOT = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_field = 15,
  anon_sym_event = 16,
  anon_sym_method = 17,
  anon_sym_param = 18,
  anon_sym_property = 19,
  anon_sym_return = 20,
  anon_sym_type = 21,
  anon_sym_COLON = 22,
  anon_sym_LPAREN = 23,
  anon_sym_RPAREN = 24,
  anon_sym_assembly = 25,
  anon_sym_module = 26,
  anon_sym_abstract = 27,
  anon_sym_async = 28,
  anon_sym_const = 29,
  anon_sym_fixed = 30,
  anon_sym_internal = 31,
  anon_sym_new = 32,
  anon_sym_override = 33,
  anon_sym_partial = 34,
  anon_sym_private = 35,
  anon_sym_protected = 36,
  anon_sym_public = 37,
  anon_sym_readonly = 38,
  anon_sym_ref = 39,
  anon_sym_sealed = 40,
  anon_sym_unsafe = 41,
  anon_sym_virtual = 42,
  anon_sym_volatile = 43,
  anon_sym_out = 44,
  anon_sym_in = 45,
  anon_sym_this = 46,
  anon_sym_params = 47,
  anon_sym_base = 48,
  anon_sym_LBRACE = 49,
  anon_sym_RBRACE = 50,
  anon_sym_EQ_GT = 51,
  anon_sym_implicit = 52,
  anon_sym_explicit = 53,
  anon_sym_operator = 54,
  anon_sym_TILDE = 55,
  anon_sym_where = 56,
  anon_sym_class = 57,
  anon_sym_struct = 58,
  anon_sym_unmanaged = 59,
  anon_sym_BANG = 60,
  anon_sym_PLUS_PLUS = 61,
  anon_sym_DASH_DASH = 62,
  anon_sym_true = 63,
  anon_sym_false = 64,
  anon_sym_PLUS = 65,
  anon_sym_DASH = 66,
  anon_sym_STAR = 67,
  anon_sym_SLASH = 68,
  anon_sym_PERCENT = 69,
  anon_sym_CARET = 70,
  anon_sym_PIPE = 71,
  anon_sym_AMP = 72,
  anon_sym_LT_LT = 73,
  anon_sym_GT_GT = 74,
  anon_sym_EQ_EQ = 75,
  anon_sym_BANG_EQ = 76,
  anon_sym_GT_EQ = 77,
  anon_sym_LT_EQ = 78,
  anon_sym_get = 79,
  anon_sym_set = 80,
  anon_sym_add = 81,
  anon_sym_remove = 82,
  anon_sym_enum = 83,
  anon_sym_interface = 84,
  anon_sym_delegate = 85,
  anon_sym_namespace = 86,
  anon_sym_var = 87,
  anon_sym_QMARK = 88,
  sym_predefined_type = 89,
  anon_sym_break = 90,
  anon_sym_checked = 91,
  anon_sym_unchecked = 92,
  anon_sym_continue = 93,
  anon_sym_do = 94,
  anon_sym_while = 95,
  anon_sym_for = 96,
  anon_sym_await = 97,
  anon_sym_foreach = 98,
  anon_sym_goto = 99,
  anon_sym_case = 100,
  anon_sym_default = 101,
  anon_sym_if = 102,
  anon_sym_else = 103,
  anon_sym_lock = 104,
  anon_sym_switch = 105,
  sym_discard = 106,
  anon_sym_when = 107,
  anon_sym_throw = 108,
  anon_sym_try = 109,
  anon_sym_catch = 110,
  anon_sym_finally = 111,
  anon_sym_yield = 112,
  anon_sym_PLUS_EQ = 113,
  anon_sym_DASH_EQ = 114,
  anon_sym_STAR_EQ = 115,
  anon_sym_SLASH_EQ = 116,
  anon_sym_PERCENT_EQ = 117,
  anon_sym_AMP_EQ = 118,
  anon_sym_CARET_EQ = 119,
  anon_sym_PIPE_EQ = 120,
  anon_sym_LT_LT_EQ = 121,
  anon_sym_GT_GT_EQ = 122,
  anon_sym_QMARK_QMARK_EQ = 123,
  anon_sym_stackalloc = 124,
  anon_sym_DOLLAR_DQUOTE = 125,
  anon_sym_DQUOTE = 126,
  anon_sym_DOLLAR_AT_DQUOTE = 127,
  anon_sym_LBRACE_LBRACE = 128,
  aux_sym_interpolated_string_text_token1 = 129,
  aux_sym_interpolated_verbatim_string_text_token1 = 130,
  anon_sym_DQUOTE_DQUOTE = 131,
  aux_sym_interpolation_format_clause_token1 = 132,
  anon_sym_is = 133,
  anon_sym___makeref = 134,
  anon_sym_DASH_GT = 135,
  anon_sym_from = 136,
  anon_sym_join = 137,
  anon_sym_on = 138,
  anon_sym_equals = 139,
  anon_sym_into = 140,
  anon_sym_let = 141,
  anon_sym_orderby = 142,
  anon_sym_ascending = 143,
  anon_sym_descending = 144,
  anon_sym_group = 145,
  anon_sym_by = 146,
  anon_sym_select = 147,
  anon_sym_DOT_DOT = 148,
  anon_sym___reftype = 149,
  anon_sym___refvalue = 150,
  anon_sym_sizeof = 151,
  anon_sym_typeof = 152,
  anon_sym_AMP_AMP = 153,
  anon_sym_PIPE_PIPE = 154,
  anon_sym_QMARK_QMARK = 155,
  anon_sym_as = 156,
  sym_global = 157,
  anon_sym_SQUOTE = 158,
  aux_sym_character_literal_token1 = 159,
  sym_escape_sequence = 160,
  sym_integer_literal = 161,
  sym_null_literal = 162,
  sym_real_literal = 163,
  aux_sym_string_literal_token1 = 164,
  sym_verbatim_string_literal = 165,
  sym_comment = 166,
  sym_void_keyword = 167,
  aux_sym_preprocessor_call_token1 = 168,
  sym_preprocessor_directive = 169,
  sym__preproc_directive_end = 170,
  sym_compilation_unit = 171,
  sym__declaration = 172,
  sym_extern_alias_directive = 173,
  sym_using_directive = 174,
  sym_name_equals = 175,
  sym__name = 176,
  sym_alias_qualified_name = 177,
  sym__simple_name = 178,
  sym_generic_name = 179,
  sym_type_argument_list = 180,
  sym_qualified_name = 181,
  sym_attribute_list = 182,
  sym_attribute_target_specifier = 183,
  sym_attribute = 184,
  sym_attribute_argument_list = 185,
  sym_attribute_argument = 186,
  sym_global_attribute_list = 187,
  sym_name_colon = 188,
  sym_event_field_declaration = 189,
  sym_modifier = 190,
  sym_variable_declaration = 191,
  sym_variable_declarator = 192,
  sym_bracketed_argument_list = 193,
  sym_tuple_pattern = 194,
  sym_argument = 195,
  sym_equals_value_clause = 196,
  sym_field_declaration = 197,
  sym_constructor_declaration = 198,
  sym_parameter_list = 199,
  sym__formal_parameter_list = 200,
  sym_parameter = 201,
  sym_parameter_modifier = 202,
  sym_parameter_array = 203,
  sym_constructor_initializer = 204,
  sym_argument_list = 205,
  sym_block = 206,
  sym_arrow_expression_clause = 207,
  sym_conversion_operator_declaration = 208,
  sym__function_body = 209,
  sym_destructor_declaration = 210,
  sym_method_declaration = 211,
  sym_explicit_interface_specifier = 212,
  sym_type_parameter_list = 213,
  sym_type_parameter = 214,
  sym_type_parameter_constraints_clause = 215,
  sym_type_parameter_constraint = 216,
  sym_constructor_constraint = 217,
  sym_type_constraint = 218,
  sym_operator_declaration = 219,
  sym__overloadable_operator = 220,
  sym_event_declaration = 221,
  sym_accessor_list = 222,
  sym_accessor_declaration = 223,
  sym_indexer_declaration = 224,
  sym_bracketed_parameter_list = 225,
  sym_property_declaration = 226,
  sym_enum_declaration = 227,
  sym_base_list = 228,
  sym_enum_member_declaration_list = 229,
  sym_enum_member_declaration = 230,
  sym_class_declaration = 231,
  sym_declaration_list = 232,
  sym_interface_declaration = 233,
  sym_struct_declaration = 234,
  sym_delegate_declaration = 235,
  sym_namespace_declaration = 236,
  sym__type = 237,
  sym_implicit_type = 238,
  sym_array_type = 239,
  sym_array_rank_specifier = 240,
  sym_nullable_type = 241,
  sym_pointer_type = 242,
  sym_tuple_type = 243,
  sym_tuple_element = 244,
  sym__statement = 245,
  sym_break_statement = 246,
  sym_checked_statement = 247,
  sym_continue_statement = 248,
  sym_do_statement = 249,
  sym_empty_statement = 250,
  sym_expression_statement = 251,
  sym_fixed_statement = 252,
  sym_for_statement = 253,
  sym_for_each_statement = 254,
  sym_goto_statement = 255,
  sym_if_statement = 256,
  sym_labeled_statement = 257,
  sym_local_declaration_statement = 258,
  sym_local_function_statement = 259,
  sym_lock_statement = 260,
  sym_return_statement = 261,
  sym_switch_statement = 262,
  sym_switch_body = 263,
  sym_switch_section = 264,
  sym_case_pattern_switch_label = 265,
  sym__pattern = 266,
  sym_constant_pattern = 267,
  sym_declaration_pattern = 268,
  sym__variable_designation = 269,
  sym_parenthesized_variable_designation = 270,
  sym_var_pattern = 271,
  sym_when_clause = 272,
  sym_case_switch_label = 273,
  sym_default_switch_label = 274,
  sym_throw_statement = 275,
  sym_try_statement = 276,
  sym_catch_clause = 277,
  sym_catch_declaration = 278,
  sym_catch_filter_clause = 279,
  sym_finally_clause = 280,
  sym_unsafe_statement = 281,
  sym_using_statement = 282,
  sym_while_statement = 283,
  sym_yield_statement = 284,
  sym_anonymous_method_expression = 285,
  sym_lambda_expression = 286,
  sym_anonymous_object_creation_expression = 287,
  sym__anonymous_object_member_declarator = 288,
  sym_array_creation_expression = 289,
  sym_initializer_expression = 290,
  sym_assignment_expression = 291,
  sym_assignment_operator = 292,
  sym_await_expression = 293,
  sym_cast_expression = 294,
  sym_checked_expression = 295,
  sym_conditional_access_expression = 296,
  sym_conditional_expression = 297,
  sym_declaration_expression = 298,
  sym_default_expression = 299,
  sym_element_access_expression = 300,
  sym_element_binding_expression = 301,
  sym_implicit_array_creation_expression = 302,
  sym_implicit_stack_alloc_array_creation_expression = 303,
  sym_base_expression = 304,
  sym_this_expression = 305,
  sym_interpolated_string_expression = 306,
  sym__interpolated_string_content = 307,
  sym__interpolated_verbatim_string_content = 308,
  sym_interpolated_string_text = 309,
  sym_interpolated_verbatim_string_text = 310,
  sym_interpolation = 311,
  sym_interpolation_alignment_clause = 312,
  sym_interpolation_format_clause = 313,
  sym_invocation_expression = 314,
  sym_is_pattern_expression = 315,
  sym_make_ref_expression = 316,
  sym_member_access_expression = 317,
  sym_member_binding_expression = 318,
  sym_object_creation_expression = 319,
  sym_parenthesized_expression = 320,
  sym_postfix_unary_expression = 321,
  sym_prefix_unary_expression = 322,
  sym_query_expression = 323,
  sym_from_clause = 324,
  sym__query_body = 325,
  sym__query_clause = 326,
  sym_join_clause = 327,
  sym_join_into_clause = 328,
  sym_let_clause = 329,
  sym_order_by_clause = 330,
  sym__ordering = 331,
  sym_where_clause = 332,
  sym__select_or_group_clause = 333,
  sym_group_clause = 334,
  sym_select_clause = 335,
  sym_query_continuation = 336,
  sym_range_expression = 337,
  sym_ref_expression = 338,
  sym_ref_type_expression = 339,
  sym_ref_value_expression = 340,
  sym_size_of_expression = 341,
  sym_stack_alloc_array_creation_expression = 342,
  sym_switch_expression = 343,
  sym_switch_expression_arm = 344,
  sym_throw_expression = 345,
  sym_tuple_expression = 346,
  sym_type_of_expression = 347,
  sym__expression = 348,
  sym_binary_expression = 349,
  sym__literal = 350,
  sym_boolean_literal = 351,
  sym_character_literal = 352,
  sym_string_literal = 353,
  sym__reserved_identifier = 354,
  sym_preprocessor_call = 355,
  aux_sym_compilation_unit_repeat1 = 356,
  aux_sym_type_argument_list_repeat1 = 357,
  aux_sym_type_argument_list_repeat2 = 358,
  aux_sym_attribute_list_repeat1 = 359,
  aux_sym_attribute_argument_list_repeat1 = 360,
  aux_sym_event_field_declaration_repeat1 = 361,
  aux_sym_event_field_declaration_repeat2 = 362,
  aux_sym_variable_declaration_repeat1 = 363,
  aux_sym_bracketed_argument_list_repeat1 = 364,
  aux_sym_tuple_pattern_repeat1 = 365,
  aux_sym__formal_parameter_list_repeat1 = 366,
  aux_sym_block_repeat1 = 367,
  aux_sym_method_declaration_repeat1 = 368,
  aux_sym_type_parameter_list_repeat1 = 369,
  aux_sym_type_parameter_constraints_clause_repeat1 = 370,
  aux_sym_accessor_list_repeat1 = 371,
  aux_sym_bracketed_parameter_list_repeat1 = 372,
  aux_sym_enum_member_declaration_list_repeat1 = 373,
  aux_sym_array_rank_specifier_repeat1 = 374,
  aux_sym_tuple_type_repeat1 = 375,
  aux_sym_for_statement_repeat1 = 376,
  aux_sym_switch_body_repeat1 = 377,
  aux_sym_switch_section_repeat1 = 378,
  aux_sym_parenthesized_variable_designation_repeat1 = 379,
  aux_sym_try_statement_repeat1 = 380,
  aux_sym_anonymous_object_creation_expression_repeat1 = 381,
  aux_sym_interpolated_string_expression_repeat1 = 382,
  aux_sym_interpolated_string_expression_repeat2 = 383,
  aux_sym__query_body_repeat1 = 384,
  aux_sym_order_by_clause_repeat1 = 385,
  aux_sym_switch_expression_repeat1 = 386,
  aux_sym_string_literal_repeat1 = 387,
  aux_sym_preprocessor_call_repeat1 = 388,
  alias_sym_label_name = 389,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_extern] = "extern",
  [anon_sym_alias] = "alias",
  [anon_sym_SEMI] = ";",
  [anon_sym_using] = "using",
  [anon_sym_static] = "static",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LT] = "<",
  [anon_sym_COMMA] = ",",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_field] = "field",
  [anon_sym_event] = "event",
  [anon_sym_method] = "method",
  [anon_sym_param] = "param",
  [anon_sym_property] = "property",
  [anon_sym_return] = "return",
  [anon_sym_type] = "type",
  [anon_sym_COLON] = ":",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_assembly] = "assembly",
  [anon_sym_module] = "module",
  [anon_sym_abstract] = "abstract",
  [anon_sym_async] = "async",
  [anon_sym_const] = "const",
  [anon_sym_fixed] = "fixed",
  [anon_sym_internal] = "internal",
  [anon_sym_new] = "new",
  [anon_sym_override] = "override",
  [anon_sym_partial] = "partial",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_public] = "public",
  [anon_sym_readonly] = "readonly",
  [anon_sym_ref] = "ref",
  [anon_sym_sealed] = "sealed",
  [anon_sym_unsafe] = "unsafe",
  [anon_sym_virtual] = "virtual",
  [anon_sym_volatile] = "volatile",
  [anon_sym_out] = "out",
  [anon_sym_in] = "in",
  [anon_sym_this] = "this",
  [anon_sym_params] = "params",
  [anon_sym_base] = "base",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_implicit] = "implicit",
  [anon_sym_explicit] = "explicit",
  [anon_sym_operator] = "operator",
  [anon_sym_TILDE] = "~",
  [anon_sym_where] = "where",
  [anon_sym_class] = "class",
  [anon_sym_struct] = "struct",
  [anon_sym_unmanaged] = "unmanaged",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_add] = "add",
  [anon_sym_remove] = "remove",
  [anon_sym_enum] = "enum",
  [anon_sym_interface] = "interface",
  [anon_sym_delegate] = "delegate",
  [anon_sym_namespace] = "namespace",
  [anon_sym_var] = "var",
  [anon_sym_QMARK] = "?",
  [sym_predefined_type] = "predefined_type",
  [anon_sym_break] = "break",
  [anon_sym_checked] = "checked",
  [anon_sym_unchecked] = "unchecked",
  [anon_sym_continue] = "continue",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_for] = "for",
  [anon_sym_await] = "await",
  [anon_sym_foreach] = "foreach",
  [anon_sym_goto] = "goto",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_lock] = "lock",
  [anon_sym_switch] = "switch",
  [sym_discard] = "discard",
  [anon_sym_when] = "when",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_QMARK_QMARK_EQ] = "??=",
  [anon_sym_stackalloc] = "stackalloc",
  [anon_sym_DOLLAR_DQUOTE] = "$\"",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR_AT_DQUOTE] = "$@\"",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [aux_sym_interpolated_string_text_token1] = "interpolated_string_text_token1",
  [aux_sym_interpolated_verbatim_string_text_token1] = "interpolated_verbatim_string_text_token1",
  [anon_sym_DQUOTE_DQUOTE] = "\"\"",
  [aux_sym_interpolation_format_clause_token1] = "interpolation_format_clause_token1",
  [anon_sym_is] = "is",
  [anon_sym___makeref] = "__makeref",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_from] = "from",
  [anon_sym_join] = "join",
  [anon_sym_on] = "on",
  [anon_sym_equals] = "equals",
  [anon_sym_into] = "into",
  [anon_sym_let] = "let",
  [anon_sym_orderby] = "orderby",
  [anon_sym_ascending] = "ascending",
  [anon_sym_descending] = "descending",
  [anon_sym_group] = "group",
  [anon_sym_by] = "by",
  [anon_sym_select] = "select",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym___reftype] = "__reftype",
  [anon_sym___refvalue] = "__refvalue",
  [anon_sym_sizeof] = "sizeof",
  [anon_sym_typeof] = "typeof",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_QMARK_QMARK] = "??",
  [anon_sym_as] = "as",
  [sym_global] = "global",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_character_literal_token1] = "character_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_integer_literal] = "integer_literal",
  [sym_null_literal] = "null_literal",
  [sym_real_literal] = "real_literal",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_verbatim_string_literal] = "verbatim_string_literal",
  [sym_comment] = "comment",
  [sym_void_keyword] = "void_keyword",
  [aux_sym_preprocessor_call_token1] = "preprocessor_call_token1",
  [sym_preprocessor_directive] = "preprocessor_directive",
  [sym__preproc_directive_end] = "_preproc_directive_end",
  [sym_compilation_unit] = "compilation_unit",
  [sym__declaration] = "_declaration",
  [sym_extern_alias_directive] = "extern_alias_directive",
  [sym_using_directive] = "using_directive",
  [sym_name_equals] = "name_equals",
  [sym__name] = "_name",
  [sym_alias_qualified_name] = "alias_qualified_name",
  [sym__simple_name] = "_simple_name",
  [sym_generic_name] = "generic_name",
  [sym_type_argument_list] = "type_argument_list",
  [sym_qualified_name] = "qualified_name",
  [sym_attribute_list] = "attribute_list",
  [sym_attribute_target_specifier] = "attribute_target_specifier",
  [sym_attribute] = "attribute",
  [sym_attribute_argument_list] = "attribute_argument_list",
  [sym_attribute_argument] = "attribute_argument",
  [sym_global_attribute_list] = "global_attribute_list",
  [sym_name_colon] = "name_colon",
  [sym_event_field_declaration] = "event_field_declaration",
  [sym_modifier] = "modifier",
  [sym_variable_declaration] = "variable_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_bracketed_argument_list] = "bracketed_argument_list",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_argument] = "argument",
  [sym_equals_value_clause] = "equals_value_clause",
  [sym_field_declaration] = "field_declaration",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym_parameter_list] = "parameter_list",
  [sym__formal_parameter_list] = "_formal_parameter_list",
  [sym_parameter] = "parameter",
  [sym_parameter_modifier] = "parameter_modifier",
  [sym_parameter_array] = "parameter_array",
  [sym_constructor_initializer] = "constructor_initializer",
  [sym_argument_list] = "argument_list",
  [sym_block] = "block",
  [sym_arrow_expression_clause] = "arrow_expression_clause",
  [sym_conversion_operator_declaration] = "conversion_operator_declaration",
  [sym__function_body] = "_function_body",
  [sym_destructor_declaration] = "destructor_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_explicit_interface_specifier] = "explicit_interface_specifier",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_type_parameter] = "type_parameter",
  [sym_type_parameter_constraints_clause] = "type_parameter_constraints_clause",
  [sym_type_parameter_constraint] = "type_parameter_constraint",
  [sym_constructor_constraint] = "constructor_constraint",
  [sym_type_constraint] = "type_constraint",
  [sym_operator_declaration] = "operator_declaration",
  [sym__overloadable_operator] = "_overloadable_operator",
  [sym_event_declaration] = "event_declaration",
  [sym_accessor_list] = "accessor_list",
  [sym_accessor_declaration] = "accessor_declaration",
  [sym_indexer_declaration] = "indexer_declaration",
  [sym_bracketed_parameter_list] = "bracketed_parameter_list",
  [sym_property_declaration] = "property_declaration",
  [sym_enum_declaration] = "enum_declaration",
  [sym_base_list] = "base_list",
  [sym_enum_member_declaration_list] = "enum_member_declaration_list",
  [sym_enum_member_declaration] = "enum_member_declaration",
  [sym_class_declaration] = "class_declaration",
  [sym_declaration_list] = "declaration_list",
  [sym_interface_declaration] = "interface_declaration",
  [sym_struct_declaration] = "struct_declaration",
  [sym_delegate_declaration] = "delegate_declaration",
  [sym_namespace_declaration] = "namespace_declaration",
  [sym__type] = "_type",
  [sym_implicit_type] = "implicit_type",
  [sym_array_type] = "array_type",
  [sym_array_rank_specifier] = "array_rank_specifier",
  [sym_nullable_type] = "nullable_type",
  [sym_pointer_type] = "pointer_type",
  [sym_tuple_type] = "tuple_type",
  [sym_tuple_element] = "tuple_element",
  [sym__statement] = "_statement",
  [sym_break_statement] = "break_statement",
  [sym_checked_statement] = "checked_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_do_statement] = "do_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_fixed_statement] = "fixed_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_each_statement] = "for_each_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_if_statement] = "if_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_local_declaration_statement] = "local_declaration_statement",
  [sym_local_function_statement] = "local_function_statement",
  [sym_lock_statement] = "lock_statement",
  [sym_return_statement] = "return_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_section] = "switch_section",
  [sym_case_pattern_switch_label] = "case_pattern_switch_label",
  [sym__pattern] = "_pattern",
  [sym_constant_pattern] = "constant_pattern",
  [sym_declaration_pattern] = "declaration_pattern",
  [sym__variable_designation] = "_variable_designation",
  [sym_parenthesized_variable_designation] = "parenthesized_variable_designation",
  [sym_var_pattern] = "var_pattern",
  [sym_when_clause] = "when_clause",
  [sym_case_switch_label] = "case_switch_label",
  [sym_default_switch_label] = "default_switch_label",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_declaration] = "catch_declaration",
  [sym_catch_filter_clause] = "catch_filter_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_unsafe_statement] = "unsafe_statement",
  [sym_using_statement] = "using_statement",
  [sym_while_statement] = "while_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_anonymous_method_expression] = "anonymous_method_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_anonymous_object_creation_expression] = "anonymous_object_creation_expression",
  [sym__anonymous_object_member_declarator] = "_anonymous_object_member_declarator",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_initializer_expression] = "initializer_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_assignment_operator] = "assignment_operator",
  [sym_await_expression] = "await_expression",
  [sym_cast_expression] = "cast_expression",
  [sym_checked_expression] = "checked_expression",
  [sym_conditional_access_expression] = "conditional_access_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_declaration_expression] = "declaration_expression",
  [sym_default_expression] = "default_expression",
  [sym_element_access_expression] = "element_access_expression",
  [sym_element_binding_expression] = "element_binding_expression",
  [sym_implicit_array_creation_expression] = "implicit_array_creation_expression",
  [sym_implicit_stack_alloc_array_creation_expression] = "implicit_stack_alloc_array_creation_expression",
  [sym_base_expression] = "base_expression",
  [sym_this_expression] = "this_expression",
  [sym_interpolated_string_expression] = "interpolated_string_expression",
  [sym__interpolated_string_content] = "_interpolated_string_content",
  [sym__interpolated_verbatim_string_content] = "_interpolated_verbatim_string_content",
  [sym_interpolated_string_text] = "interpolated_string_text",
  [sym_interpolated_verbatim_string_text] = "interpolated_verbatim_string_text",
  [sym_interpolation] = "interpolation",
  [sym_interpolation_alignment_clause] = "interpolation_alignment_clause",
  [sym_interpolation_format_clause] = "interpolation_format_clause",
  [sym_invocation_expression] = "invocation_expression",
  [sym_is_pattern_expression] = "is_pattern_expression",
  [sym_make_ref_expression] = "make_ref_expression",
  [sym_member_access_expression] = "member_access_expression",
  [sym_member_binding_expression] = "member_binding_expression",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_postfix_unary_expression] = "postfix_unary_expression",
  [sym_prefix_unary_expression] = "prefix_unary_expression",
  [sym_query_expression] = "query_expression",
  [sym_from_clause] = "from_clause",
  [sym__query_body] = "_query_body",
  [sym__query_clause] = "_query_clause",
  [sym_join_clause] = "join_clause",
  [sym_join_into_clause] = "join_into_clause",
  [sym_let_clause] = "let_clause",
  [sym_order_by_clause] = "order_by_clause",
  [sym__ordering] = "_ordering",
  [sym_where_clause] = "where_clause",
  [sym__select_or_group_clause] = "_select_or_group_clause",
  [sym_group_clause] = "group_clause",
  [sym_select_clause] = "select_clause",
  [sym_query_continuation] = "query_continuation",
  [sym_range_expression] = "range_expression",
  [sym_ref_expression] = "ref_expression",
  [sym_ref_type_expression] = "ref_type_expression",
  [sym_ref_value_expression] = "ref_value_expression",
  [sym_size_of_expression] = "size_of_expression",
  [sym_stack_alloc_array_creation_expression] = "stack_alloc_array_creation_expression",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_expression_arm] = "switch_expression_arm",
  [sym_throw_expression] = "throw_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_type_of_expression] = "type_of_expression",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__literal] = "_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym__reserved_identifier] = "identifier",
  [sym_preprocessor_call] = "preprocessor_call",
  [aux_sym_compilation_unit_repeat1] = "compilation_unit_repeat1",
  [aux_sym_type_argument_list_repeat1] = "type_argument_list_repeat1",
  [aux_sym_type_argument_list_repeat2] = "type_argument_list_repeat2",
  [aux_sym_attribute_list_repeat1] = "attribute_list_repeat1",
  [aux_sym_attribute_argument_list_repeat1] = "attribute_argument_list_repeat1",
  [aux_sym_event_field_declaration_repeat1] = "event_field_declaration_repeat1",
  [aux_sym_event_field_declaration_repeat2] = "event_field_declaration_repeat2",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_bracketed_argument_list_repeat1] = "bracketed_argument_list_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym__formal_parameter_list_repeat1] = "_formal_parameter_list_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_method_declaration_repeat1] = "method_declaration_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_type_parameter_constraints_clause_repeat1] = "type_parameter_constraints_clause_repeat1",
  [aux_sym_accessor_list_repeat1] = "accessor_list_repeat1",
  [aux_sym_bracketed_parameter_list_repeat1] = "bracketed_parameter_list_repeat1",
  [aux_sym_enum_member_declaration_list_repeat1] = "enum_member_declaration_list_repeat1",
  [aux_sym_array_rank_specifier_repeat1] = "array_rank_specifier_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_switch_section_repeat1] = "switch_section_repeat1",
  [aux_sym_parenthesized_variable_designation_repeat1] = "parenthesized_variable_designation_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_anonymous_object_creation_expression_repeat1] = "anonymous_object_creation_expression_repeat1",
  [aux_sym_interpolated_string_expression_repeat1] = "interpolated_string_expression_repeat1",
  [aux_sym_interpolated_string_expression_repeat2] = "interpolated_string_expression_repeat2",
  [aux_sym__query_body_repeat1] = "_query_body_repeat1",
  [aux_sym_order_by_clause_repeat1] = "order_by_clause_repeat1",
  [aux_sym_switch_expression_repeat1] = "switch_expression_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_preprocessor_call_repeat1] = "preprocessor_call_repeat1",
  [alias_sym_label_name] = "label_name",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_method] = anon_sym_method,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_assembly] = anon_sym_assembly,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_fixed] = anon_sym_fixed,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_partial] = anon_sym_partial,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_sealed] = anon_sym_sealed,
  [anon_sym_unsafe] = anon_sym_unsafe,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_out] = anon_sym_out,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_this] = anon_sym_this,
  [anon_sym_params] = anon_sym_params,
  [anon_sym_base] = anon_sym_base,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_implicit] = anon_sym_implicit,
  [anon_sym_explicit] = anon_sym_explicit,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_unmanaged] = anon_sym_unmanaged,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_remove] = anon_sym_remove,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_delegate] = anon_sym_delegate,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_predefined_type] = sym_predefined_type,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_checked] = anon_sym_checked,
  [anon_sym_unchecked] = anon_sym_unchecked,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_lock] = anon_sym_lock,
  [anon_sym_switch] = anon_sym_switch,
  [sym_discard] = sym_discard,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_stackalloc] = anon_sym_stackalloc,
  [anon_sym_DOLLAR_DQUOTE] = anon_sym_DOLLAR_DQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DOLLAR_AT_DQUOTE] = anon_sym_DOLLAR_AT_DQUOTE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [aux_sym_interpolated_string_text_token1] = aux_sym_interpolated_string_text_token1,
  [aux_sym_interpolated_verbatim_string_text_token1] = aux_sym_interpolated_verbatim_string_text_token1,
  [anon_sym_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE,
  [aux_sym_interpolation_format_clause_token1] = aux_sym_interpolation_format_clause_token1,
  [anon_sym_is] = anon_sym_is,
  [anon_sym___makeref] = anon_sym___makeref,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_join] = anon_sym_join,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_equals] = anon_sym_equals,
  [anon_sym_into] = anon_sym_into,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_orderby] = anon_sym_orderby,
  [anon_sym_ascending] = anon_sym_ascending,
  [anon_sym_descending] = anon_sym_descending,
  [anon_sym_group] = anon_sym_group,
  [anon_sym_by] = anon_sym_by,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym___reftype] = anon_sym___reftype,
  [anon_sym___refvalue] = anon_sym___refvalue,
  [anon_sym_sizeof] = anon_sym_sizeof,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_as] = anon_sym_as,
  [sym_global] = sym_global,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_character_literal_token1] = aux_sym_character_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_integer_literal] = sym_integer_literal,
  [sym_null_literal] = sym_null_literal,
  [sym_real_literal] = sym_real_literal,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_verbatim_string_literal] = sym_verbatim_string_literal,
  [sym_comment] = sym_comment,
  [sym_void_keyword] = sym_void_keyword,
  [aux_sym_preprocessor_call_token1] = aux_sym_preprocessor_call_token1,
  [sym_preprocessor_directive] = sym_preprocessor_directive,
  [sym__preproc_directive_end] = sym__preproc_directive_end,
  [sym_compilation_unit] = sym_compilation_unit,
  [sym__declaration] = sym__declaration,
  [sym_extern_alias_directive] = sym_extern_alias_directive,
  [sym_using_directive] = sym_using_directive,
  [sym_name_equals] = sym_name_equals,
  [sym__name] = sym__name,
  [sym_alias_qualified_name] = sym_alias_qualified_name,
  [sym__simple_name] = sym__simple_name,
  [sym_generic_name] = sym_generic_name,
  [sym_type_argument_list] = sym_type_argument_list,
  [sym_qualified_name] = sym_qualified_name,
  [sym_attribute_list] = sym_attribute_list,
  [sym_attribute_target_specifier] = sym_attribute_target_specifier,
  [sym_attribute] = sym_attribute,
  [sym_attribute_argument_list] = sym_attribute_argument_list,
  [sym_attribute_argument] = sym_attribute_argument,
  [sym_global_attribute_list] = sym_global_attribute_list,
  [sym_name_colon] = sym_name_colon,
  [sym_event_field_declaration] = sym_event_field_declaration,
  [sym_modifier] = sym_modifier,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_bracketed_argument_list] = sym_bracketed_argument_list,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_argument] = sym_argument,
  [sym_equals_value_clause] = sym_equals_value_clause,
  [sym_field_declaration] = sym_field_declaration,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym_parameter_list] = sym_parameter_list,
  [sym__formal_parameter_list] = sym__formal_parameter_list,
  [sym_parameter] = sym_parameter,
  [sym_parameter_modifier] = sym_parameter_modifier,
  [sym_parameter_array] = sym_parameter_array,
  [sym_constructor_initializer] = sym_constructor_initializer,
  [sym_argument_list] = sym_argument_list,
  [sym_block] = sym_block,
  [sym_arrow_expression_clause] = sym_arrow_expression_clause,
  [sym_conversion_operator_declaration] = sym_conversion_operator_declaration,
  [sym__function_body] = sym__function_body,
  [sym_destructor_declaration] = sym_destructor_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_explicit_interface_specifier] = sym_explicit_interface_specifier,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_parameter_constraints_clause] = sym_type_parameter_constraints_clause,
  [sym_type_parameter_constraint] = sym_type_parameter_constraint,
  [sym_constructor_constraint] = sym_constructor_constraint,
  [sym_type_constraint] = sym_type_constraint,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__overloadable_operator] = sym__overloadable_operator,
  [sym_event_declaration] = sym_event_declaration,
  [sym_accessor_list] = sym_accessor_list,
  [sym_accessor_declaration] = sym_accessor_declaration,
  [sym_indexer_declaration] = sym_indexer_declaration,
  [sym_bracketed_parameter_list] = sym_bracketed_parameter_list,
  [sym_property_declaration] = sym_property_declaration,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_base_list] = sym_base_list,
  [sym_enum_member_declaration_list] = sym_enum_member_declaration_list,
  [sym_enum_member_declaration] = sym_enum_member_declaration,
  [sym_class_declaration] = sym_class_declaration,
  [sym_declaration_list] = sym_declaration_list,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym_delegate_declaration] = sym_delegate_declaration,
  [sym_namespace_declaration] = sym_namespace_declaration,
  [sym__type] = sym__type,
  [sym_implicit_type] = sym_implicit_type,
  [sym_array_type] = sym_array_type,
  [sym_array_rank_specifier] = sym_array_rank_specifier,
  [sym_nullable_type] = sym_nullable_type,
  [sym_pointer_type] = sym_pointer_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_tuple_element] = sym_tuple_element,
  [sym__statement] = sym__statement,
  [sym_break_statement] = sym_break_statement,
  [sym_checked_statement] = sym_checked_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_fixed_statement] = sym_fixed_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_each_statement] = sym_for_each_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_local_declaration_statement] = sym_local_declaration_statement,
  [sym_local_function_statement] = sym_local_function_statement,
  [sym_lock_statement] = sym_lock_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_section] = sym_switch_section,
  [sym_case_pattern_switch_label] = sym_case_pattern_switch_label,
  [sym__pattern] = sym__pattern,
  [sym_constant_pattern] = sym_constant_pattern,
  [sym_declaration_pattern] = sym_declaration_pattern,
  [sym__variable_designation] = sym__variable_designation,
  [sym_parenthesized_variable_designation] = sym_parenthesized_variable_designation,
  [sym_var_pattern] = sym_var_pattern,
  [sym_when_clause] = sym_when_clause,
  [sym_case_switch_label] = sym_case_switch_label,
  [sym_default_switch_label] = sym_default_switch_label,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_declaration] = sym_catch_declaration,
  [sym_catch_filter_clause] = sym_catch_filter_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_unsafe_statement] = sym_unsafe_statement,
  [sym_using_statement] = sym_using_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_anonymous_method_expression] = sym_anonymous_method_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_anonymous_object_creation_expression] = sym_anonymous_object_creation_expression,
  [sym__anonymous_object_member_declarator] = sym__anonymous_object_member_declarator,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_initializer_expression] = sym_initializer_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_assignment_operator] = sym_assignment_operator,
  [sym_await_expression] = sym_await_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_checked_expression] = sym_checked_expression,
  [sym_conditional_access_expression] = sym_conditional_access_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_declaration_expression] = sym_declaration_expression,
  [sym_default_expression] = sym_default_expression,
  [sym_element_access_expression] = sym_element_access_expression,
  [sym_element_binding_expression] = sym_element_binding_expression,
  [sym_implicit_array_creation_expression] = sym_implicit_array_creation_expression,
  [sym_implicit_stack_alloc_array_creation_expression] = sym_implicit_stack_alloc_array_creation_expression,
  [sym_base_expression] = sym_base_expression,
  [sym_this_expression] = sym_this_expression,
  [sym_interpolated_string_expression] = sym_interpolated_string_expression,
  [sym__interpolated_string_content] = sym__interpolated_string_content,
  [sym__interpolated_verbatim_string_content] = sym__interpolated_verbatim_string_content,
  [sym_interpolated_string_text] = sym_interpolated_string_text,
  [sym_interpolated_verbatim_string_text] = sym_interpolated_verbatim_string_text,
  [sym_interpolation] = sym_interpolation,
  [sym_interpolation_alignment_clause] = sym_interpolation_alignment_clause,
  [sym_interpolation_format_clause] = sym_interpolation_format_clause,
  [sym_invocation_expression] = sym_invocation_expression,
  [sym_is_pattern_expression] = sym_is_pattern_expression,
  [sym_make_ref_expression] = sym_make_ref_expression,
  [sym_member_access_expression] = sym_member_access_expression,
  [sym_member_binding_expression] = sym_member_binding_expression,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_postfix_unary_expression] = sym_postfix_unary_expression,
  [sym_prefix_unary_expression] = sym_prefix_unary_expression,
  [sym_query_expression] = sym_query_expression,
  [sym_from_clause] = sym_from_clause,
  [sym__query_body] = sym__query_body,
  [sym__query_clause] = sym__query_clause,
  [sym_join_clause] = sym_join_clause,
  [sym_join_into_clause] = sym_join_into_clause,
  [sym_let_clause] = sym_let_clause,
  [sym_order_by_clause] = sym_order_by_clause,
  [sym__ordering] = sym__ordering,
  [sym_where_clause] = sym_where_clause,
  [sym__select_or_group_clause] = sym__select_or_group_clause,
  [sym_group_clause] = sym_group_clause,
  [sym_select_clause] = sym_select_clause,
  [sym_query_continuation] = sym_query_continuation,
  [sym_range_expression] = sym_range_expression,
  [sym_ref_expression] = sym_ref_expression,
  [sym_ref_type_expression] = sym_ref_type_expression,
  [sym_ref_value_expression] = sym_ref_value_expression,
  [sym_size_of_expression] = sym_size_of_expression,
  [sym_stack_alloc_array_creation_expression] = sym_stack_alloc_array_creation_expression,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_expression_arm] = sym_switch_expression_arm,
  [sym_throw_expression] = sym_throw_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_type_of_expression] = sym_type_of_expression,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__literal] = sym__literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym__reserved_identifier] = sym_identifier,
  [sym_preprocessor_call] = sym_preprocessor_call,
  [aux_sym_compilation_unit_repeat1] = aux_sym_compilation_unit_repeat1,
  [aux_sym_type_argument_list_repeat1] = aux_sym_type_argument_list_repeat1,
  [aux_sym_type_argument_list_repeat2] = aux_sym_type_argument_list_repeat2,
  [aux_sym_attribute_list_repeat1] = aux_sym_attribute_list_repeat1,
  [aux_sym_attribute_argument_list_repeat1] = aux_sym_attribute_argument_list_repeat1,
  [aux_sym_event_field_declaration_repeat1] = aux_sym_event_field_declaration_repeat1,
  [aux_sym_event_field_declaration_repeat2] = aux_sym_event_field_declaration_repeat2,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_bracketed_argument_list_repeat1] = aux_sym_bracketed_argument_list_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym__formal_parameter_list_repeat1] = aux_sym__formal_parameter_list_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_method_declaration_repeat1] = aux_sym_method_declaration_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_type_parameter_constraints_clause_repeat1] = aux_sym_type_parameter_constraints_clause_repeat1,
  [aux_sym_accessor_list_repeat1] = aux_sym_accessor_list_repeat1,
  [aux_sym_bracketed_parameter_list_repeat1] = aux_sym_bracketed_parameter_list_repeat1,
  [aux_sym_enum_member_declaration_list_repeat1] = aux_sym_enum_member_declaration_list_repeat1,
  [aux_sym_array_rank_specifier_repeat1] = aux_sym_array_rank_specifier_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_switch_section_repeat1] = aux_sym_switch_section_repeat1,
  [aux_sym_parenthesized_variable_designation_repeat1] = aux_sym_parenthesized_variable_designation_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_anonymous_object_creation_expression_repeat1] = aux_sym_anonymous_object_creation_expression_repeat1,
  [aux_sym_interpolated_string_expression_repeat1] = aux_sym_interpolated_string_expression_repeat1,
  [aux_sym_interpolated_string_expression_repeat2] = aux_sym_interpolated_string_expression_repeat2,
  [aux_sym__query_body_repeat1] = aux_sym__query_body_repeat1,
  [aux_sym_order_by_clause_repeat1] = aux_sym_order_by_clause_repeat1,
  [aux_sym_switch_expression_repeat1] = aux_sym_switch_expression_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_preprocessor_call_repeat1] = aux_sym_preprocessor_call_repeat1,
  [alias_sym_label_name] = alias_sym_label_name,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_method] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assembly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fixed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_partial] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sealed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsafe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_this] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_params] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_base] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_explicit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unmanaged] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_remove] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_checked] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unchecked] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stackalloc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_AT_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpolated_string_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpolated_verbatim_string_text_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpolation_format_clause_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___makeref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_join] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_equals] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_into] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_orderby] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ascending] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_descending] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_group] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___reftype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___refvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sizeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [sym_global] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_real_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_verbatim_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_void_keyword] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_preprocessor_call_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_preprocessor_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__preproc_directive_end] = {
    .visible = false,
    .named = true,
  },
  [sym_compilation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_extern_alias_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_using_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_name_equals] = {
    .visible = true,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym_alias_qualified_name] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_name] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_target_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_global_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_name_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_event_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_bracketed_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_value_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_array] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_expression_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conversion_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_destructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_interface_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_constraints_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_type_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__overloadable_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_event_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessor_list] = {
    .visible = true,
    .named = true,
  },
  [sym_accessor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_indexer_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_bracketed_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_property_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_base_list] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_delegate_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_implicit_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_rank_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_nullable_type] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_element] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_checked_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_fixed_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_local_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_lock_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_section] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_designation] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_variable_designation] = {
    .visible = true,
    .named = true,
  },
  [sym_var_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_when_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_default_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_filter_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_unsafe_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_method_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__anonymous_object_member_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_checked_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_default_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_element_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_element_binding_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_stack_alloc_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_base_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_this_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolated_string_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__interpolated_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolated_verbatim_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolated_string_text] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolated_verbatim_string_text] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_alignment_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_format_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_invocation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_is_pattern_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_make_ref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_binding_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_query_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__query_body] = {
    .visible = false,
    .named = true,
  },
  [sym__query_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_join_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_join_into_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_let_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__ordering] = {
    .visible = false,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__select_or_group_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_select_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_query_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_value_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_size_of_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_stack_alloc_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_of_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__reserved_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_preprocessor_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_compilation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_event_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_event_field_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bracketed_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__formal_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_method_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_constraints_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_accessor_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bracketed_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_member_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_rank_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_variable_designation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_object_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpolated_string_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpolated_string_expression_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__query_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preprocessor_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_label_name] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_accessors = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_bases = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_expression = 8,
  field_function = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_parameters = 14,
  field_pattern = 15,
  field_rank = 16,
  field_right = 17,
  field_subscript = 18,
  field_type = 19,
  field_type_parameters = 20,
  field_update = 21,
  field_value = 22,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_accessors] = "accessors",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_bases] = "bases",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_expression] = "expression",
  [field_function] = "function",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_rank] = "rank",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_type] = "type",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[165] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 3},
  [8] = {.index = 12, .length = 3},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 3},
  [11] = {.index = 20, .length = 1},
  [12] = {.index = 21, .length = 3},
  [13] = {.index = 24, .length = 3},
  [14] = {.index = 27, .length = 2},
  [15] = {.index = 29, .length = 1},
  [16] = {.index = 30, .length = 3},
  [17] = {.index = 33, .length = 4},
  [18] = {.index = 37, .length = 1},
  [19] = {.index = 38, .length = 2},
  [20] = {.index = 40, .length = 2},
  [21] = {.index = 42, .length = 3},
  [22] = {.index = 45, .length = 3},
  [23] = {.index = 48, .length = 3},
  [24] = {.index = 51, .length = 2},
  [25] = {.index = 53, .length = 3},
  [26] = {.index = 56, .length = 1},
  [27] = {.index = 57, .length = 2},
  [28] = {.index = 59, .length = 3},
  [29] = {.index = 62, .length = 3},
  [30] = {.index = 65, .length = 4},
  [31] = {.index = 69, .length = 3},
  [32] = {.index = 72, .length = 3},
  [33] = {.index = 75, .length = 3},
  [34] = {.index = 78, .length = 1},
  [35] = {.index = 79, .length = 1},
  [36] = {.index = 80, .length = 4},
  [37] = {.index = 84, .length = 5},
  [38] = {.index = 89, .length = 4},
  [39] = {.index = 93, .length = 2},
  [40] = {.index = 95, .length = 2},
  [41] = {.index = 97, .length = 1},
  [42] = {.index = 98, .length = 2},
  [43] = {.index = 100, .length = 3},
  [44] = {.index = 103, .length = 2},
  [45] = {.index = 105, .length = 2},
  [46] = {.index = 107, .length = 2},
  [47] = {.index = 109, .length = 3},
  [48] = {.index = 112, .length = 4},
  [49] = {.index = 116, .length = 1},
  [50] = {.index = 117, .length = 3},
  [51] = {.index = 120, .length = 3},
  [52] = {.index = 123, .length = 2},
  [53] = {.index = 125, .length = 3},
  [54] = {.index = 128, .length = 3},
  [55] = {.index = 131, .length = 3},
  [56] = {.index = 134, .length = 2},
  [57] = {.index = 136, .length = 3},
  [58] = {.index = 139, .length = 4},
  [59] = {.index = 143, .length = 3},
  [60] = {.index = 146, .length = 3},
  [61] = {.index = 149, .length = 2},
  [62] = {.index = 151, .length = 3},
  [63] = {.index = 154, .length = 4},
  [64] = {.index = 158, .length = 2},
  [65] = {.index = 160, .length = 4},
  [68] = {.index = 164, .length = 5},
  [69] = {.index = 169, .length = 4},
  [70] = {.index = 173, .length = 5},
  [71] = {.index = 178, .length = 2},
  [72] = {.index = 180, .length = 1},
  [73] = {.index = 181, .length = 3},
  [74] = {.index = 184, .length = 1},
  [75] = {.index = 185, .length = 1},
  [76] = {.index = 186, .length = 4},
  [77] = {.index = 190, .length = 3},
  [78] = {.index = 193, .length = 1},
  [79] = {.index = 194, .length = 2},
  [80] = {.index = 196, .length = 3},
  [81] = {.index = 199, .length = 3},
  [82] = {.index = 202, .length = 4},
  [83] = {.index = 206, .length = 3},
  [84] = {.index = 209, .length = 3},
  [85] = {.index = 212, .length = 3},
  [86] = {.index = 215, .length = 4},
  [87] = {.index = 219, .length = 5},
  [88] = {.index = 224, .length = 4},
  [89] = {.index = 228, .length = 3},
  [90] = {.index = 231, .length = 4},
  [91] = {.index = 235, .length = 3},
  [92] = {.index = 238, .length = 3},
  [93] = {.index = 241, .length = 2},
  [94] = {.index = 243, .length = 3},
  [95] = {.index = 246, .length = 3},
  [96] = {.index = 249, .length = 3},
  [97] = {.index = 252, .length = 2},
  [98] = {.index = 254, .length = 3},
  [99] = {.index = 257, .length = 4},
  [100] = {.index = 261, .length = 3},
  [101] = {.index = 264, .length = 3},
  [102] = {.index = 267, .length = 2},
  [103] = {.index = 269, .length = 5},
  [104] = {.index = 274, .length = 3},
  [105] = {.index = 277, .length = 4},
  [106] = {.index = 281, .length = 4},
  [107] = {.index = 285, .length = 4},
  [108] = {.index = 289, .length = 5},
  [109] = {.index = 294, .length = 4},
  [110] = {.index = 298, .length = 5},
  [111] = {.index = 303, .length = 4},
  [112] = {.index = 307, .length = 3},
  [113] = {.index = 310, .length = 2},
  [114] = {.index = 312, .length = 3},
  [115] = {.index = 315, .length = 3},
  [116] = {.index = 318, .length = 4},
  [117] = {.index = 322, .length = 3},
  [118] = {.index = 325, .length = 3},
  [119] = {.index = 328, .length = 3},
  [120] = {.index = 331, .length = 4},
  [121] = {.index = 335, .length = 5},
  [122] = {.index = 340, .length = 4},
  [123] = {.index = 344, .length = 3},
  [124] = {.index = 347, .length = 4},
  [125] = {.index = 351, .length = 3},
  [126] = {.index = 354, .length = 3},
  [127] = {.index = 357, .length = 1},
  [128] = {.index = 358, .length = 2},
  [129] = {.index = 360, .length = 2},
  [130] = {.index = 362, .length = 2},
  [131] = {.index = 364, .length = 5},
  [132] = {.index = 369, .length = 4},
  [133] = {.index = 373, .length = 4},
  [134] = {.index = 377, .length = 4},
  [135] = {.index = 381, .length = 5},
  [136] = {.index = 386, .length = 4},
  [137] = {.index = 390, .length = 5},
  [138] = {.index = 395, .length = 4},
  [139] = {.index = 399, .length = 3},
  [140] = {.index = 402, .length = 1},
  [141] = {.index = 403, .length = 5},
  [142] = {.index = 408, .length = 4},
  [143] = {.index = 412, .length = 2},
  [144] = {.index = 414, .length = 2},
  [145] = {.index = 416, .length = 2},
  [146] = {.index = 418, .length = 3},
  [147] = {.index = 421, .length = 3},
  [148] = {.index = 424, .length = 3},
  [149] = {.index = 427, .length = 3},
  [150] = {.index = 430, .length = 3},
  [151] = {.index = 433, .length = 3},
  [152] = {.index = 436, .length = 3},
  [153] = {.index = 439, .length = 3},
  [154] = {.index = 442, .length = 4},
  [155] = {.index = 446, .length = 4},
  [156] = {.index = 450, .length = 4},
  [157] = {.index = 454, .length = 4},
  [158] = {.index = 458, .length = 4},
  [159] = {.index = 462, .length = 4},
  [160] = {.index = 466, .length = 4},
  [161] = {.index = 470, .length = 5},
  [162] = {.index = 475, .length = 5},
  [163] = {.index = 480, .length = 5},
  [164] = {.index = 485, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_type, 0},
  [2] =
    {field_rank, 1},
    {field_type, 0},
  [4] =
    {field_name, 1},
    {field_type, 0},
  [6] =
    {field_body, 2},
    {field_name, 1},
  [8] =
    {field_body, 0},
  [9] =
    {field_body, 2, .inherited = true},
    {field_name, 0},
    {field_parameters, 1},
  [12] =
    {field_accessors, 2},
    {field_name, 1},
    {field_type, 0},
  [15] =
    {field_name, 2},
    {field_type, 1},
  [17] =
    {field_accessors, 3},
    {field_name, 2},
    {field_type, 1},
  [20] =
    {field_body, 3, .inherited = true},
  [21] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [24] =
    {field_bases, 2},
    {field_body, 3},
    {field_name, 1},
  [27] =
    {field_body, 3},
    {field_name, 1},
  [29] =
    {field_name, 1},
  [30] =
    {field_body, 3, .inherited = true},
    {field_name, 0},
    {field_parameters, 1},
  [33] =
    {field_body, 3, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
    {field_type, 0},
  [37] =
    {field_type, 1},
  [38] =
    {field_expression, 0},
    {field_subscript, 1},
  [40] =
    {field_arguments, 1},
    {field_function, 0},
  [42] =
    {field_accessors, 3},
    {field_parameters, 2},
    {field_type, 0},
  [45] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 2},
  [48] =
    {field_accessors, 3},
    {field_name, 2},
    {field_type, 0},
  [51] =
    {field_body, 3},
    {field_name, 2},
  [53] =
    {field_body, 3, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [56] =
    {field_body, 4, .inherited = true},
  [57] =
    {field_name, 3},
    {field_type, 1},
  [59] =
    {field_accessors, 4},
    {field_name, 3},
    {field_type, 1},
  [62] =
    {field_body, 4, .inherited = true},
    {field_parameters, 3},
    {field_type, 2},
  [65] =
    {field_bases, 3},
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [69] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [72] =
    {field_bases, 2},
    {field_body, 4},
    {field_name, 1},
  [75] =
    {field_name, 2},
    {field_parameters, 3},
    {field_type, 1},
  [78] =
    {field_name, 2},
  [79] =
    {field_body, 1},
  [80] =
    {field_body, 4, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
    {field_type, 0},
  [84] =
    {field_body, 4, .inherited = true},
    {field_name, 1},
    {field_parameters, 3},
    {field_type, 0},
    {field_type_parameters, 2},
  [89] =
    {field_body, 4, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
    {field_type, 0},
  [93] =
    {field_arguments, 2},
    {field_type, 1},
  [95] =
    {field_initializer, 2},
    {field_type, 1},
  [97] =
    {field_body, 2},
  [98] =
    {field_expression, 0},
    {field_name, 2},
  [100] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [103] =
    {field_condition, 0},
    {field_value, 2},
  [105] =
    {field_expression, 0},
    {field_pattern, 2},
  [107] =
    {field_left, 0},
    {field_right, 2},
  [109] =
    {field_parameters, 2},
    {field_type, 0},
    {field_value, 3},
  [112] =
    {field_body, 4, .inherited = true},
    {field_operator, 2},
    {field_parameters, 3},
    {field_type, 0},
  [116] =
    {field_body, 1, .inherited = true},
  [117] =
    {field_accessors, 4},
    {field_parameters, 3},
    {field_type, 0},
  [120] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 3},
  [123] =
    {field_name, 3},
    {field_type, 2},
  [125] =
    {field_accessors, 4},
    {field_name, 3},
    {field_type, 2},
  [128] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [131] =
    {field_bases, 3},
    {field_body, 4},
    {field_name, 2},
  [134] =
    {field_body, 4},
    {field_name, 2},
  [136] =
    {field_body, 4, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [139] =
    {field_body, 4, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
    {field_type, 1},
  [143] =
    {field_accessors, 4},
    {field_parameters, 3},
    {field_type, 1},
  [146] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 3},
  [149] =
    {field_body, 4},
    {field_name, 3},
  [151] =
    {field_body, 4, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [154] =
    {field_bases, 3},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [158] =
    {field_name, 0},
    {field_value, 2},
  [160] =
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 1},
    {field_type_parameters, 3},
  [164] =
    {field_body, 5, .inherited = true},
    {field_name, 1},
    {field_parameters, 3},
    {field_type, 0},
    {field_type_parameters, 2},
  [169] =
    {field_body, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
    {field_type, 0},
  [173] =
    {field_body, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 0},
    {field_type_parameters, 3},
  [178] =
    {field_type, 1},
    {field_value, 3},
  [180] =
    {field_body, 3},
  [181] =
    {field_arguments, 2},
    {field_initializer, 3},
    {field_type, 1},
  [184] =
    {field_type, 2},
  [185] =
    {field_body, 2, .inherited = true},
  [186] =
    {field_accessors, 2},
    {field_name, 1},
    {field_type, 0},
    {field_value, 4},
  [190] =
    {field_parameters, 3},
    {field_type, 0},
    {field_value, 4},
  [193] =
    {field_body, 5, .inherited = true},
  [194] =
    {field_name, 4},
    {field_type, 2},
  [196] =
    {field_accessors, 5},
    {field_name, 4},
    {field_type, 2},
  [199] =
    {field_body, 5, .inherited = true},
    {field_parameters, 4},
    {field_type, 3},
  [202] =
    {field_bases, 4},
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [206] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [209] =
    {field_bases, 3},
    {field_body, 5},
    {field_name, 2},
  [212] =
    {field_name, 3},
    {field_parameters, 4},
    {field_type, 2},
  [215] =
    {field_body, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
    {field_type, 1},
  [219] =
    {field_body, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 1},
    {field_type_parameters, 3},
  [224] =
    {field_body, 5, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
    {field_type, 1},
  [228] =
    {field_parameters, 3},
    {field_type, 1},
    {field_value, 4},
  [231] =
    {field_body, 5, .inherited = true},
    {field_operator, 3},
    {field_parameters, 4},
    {field_type, 1},
  [235] =
    {field_accessors, 5},
    {field_parameters, 4},
    {field_type, 1},
  [238] =
    {field_name, 3},
    {field_type, 1},
    {field_value, 4},
  [241] =
    {field_name, 4},
    {field_type, 3},
  [243] =
    {field_accessors, 5},
    {field_name, 4},
    {field_type, 3},
  [246] =
    {field_body, 5},
    {field_name, 3},
    {field_type_parameters, 4},
  [249] =
    {field_bases, 4},
    {field_body, 5},
    {field_name, 3},
  [252] =
    {field_body, 5},
    {field_name, 3},
  [254] =
    {field_body, 5, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [257] =
    {field_body, 5, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
    {field_type, 2},
  [261] =
    {field_accessors, 5},
    {field_parameters, 4},
    {field_type, 2},
  [264] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 4},
  [267] =
    {field_name, 1},
    {field_value, 3},
  [269] =
    {field_body, 6, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 0},
    {field_type_parameters, 3},
  [274] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [277] =
    {field_accessors, 3},
    {field_name, 2},
    {field_type, 0},
    {field_value, 5},
  [281] =
    {field_bases, 4},
    {field_body, 6},
    {field_name, 2},
    {field_type_parameters, 3},
  [285] =
    {field_name, 3},
    {field_parameters, 5},
    {field_type, 2},
    {field_type_parameters, 4},
  [289] =
    {field_body, 6, .inherited = true},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 1},
    {field_type_parameters, 3},
  [294] =
    {field_body, 6, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
    {field_type, 1},
  [298] =
    {field_body, 6, .inherited = true},
    {field_name, 3},
    {field_parameters, 5},
    {field_type, 1},
    {field_type_parameters, 4},
  [303] =
    {field_accessors, 3},
    {field_name, 2},
    {field_type, 1},
    {field_value, 5},
  [307] =
    {field_parameters, 4},
    {field_type, 1},
    {field_value, 5},
  [310] =
    {field_name, 5},
    {field_type, 3},
  [312] =
    {field_accessors, 6},
    {field_name, 5},
    {field_type, 3},
  [315] =
    {field_body, 6, .inherited = true},
    {field_parameters, 5},
    {field_type, 4},
  [318] =
    {field_bases, 5},
    {field_body, 6},
    {field_name, 3},
    {field_type_parameters, 4},
  [322] =
    {field_body, 6},
    {field_name, 3},
    {field_type_parameters, 4},
  [325] =
    {field_bases, 4},
    {field_body, 6},
    {field_name, 3},
  [328] =
    {field_name, 4},
    {field_parameters, 5},
    {field_type, 3},
  [331] =
    {field_body, 6, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
    {field_type, 2},
  [335] =
    {field_body, 6, .inherited = true},
    {field_name, 3},
    {field_parameters, 5},
    {field_type, 2},
    {field_type_parameters, 4},
  [340] =
    {field_body, 6, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
    {field_type, 2},
  [344] =
    {field_parameters, 4},
    {field_type, 2},
    {field_value, 5},
  [347] =
    {field_body, 6, .inherited = true},
    {field_operator, 4},
    {field_parameters, 5},
    {field_type, 2},
  [351] =
    {field_accessors, 6},
    {field_parameters, 5},
    {field_type, 2},
  [354] =
    {field_name, 4},
    {field_type, 2},
    {field_value, 5},
  [357] =
    {field_body, 4},
  [358] =
    {field_condition, 2},
    {field_consequence, 4},
  [360] =
    {field_body, 4},
    {field_value, 2},
  [362] =
    {field_type, 4},
    {field_value, 2},
  [364] =
    {field_body, 7, .inherited = true},
    {field_name, 3},
    {field_parameters, 5},
    {field_type, 1},
    {field_type_parameters, 4},
  [369] =
    {field_accessors, 4},
    {field_name, 3},
    {field_type, 1},
    {field_value, 6},
  [373] =
    {field_bases, 5},
    {field_body, 7},
    {field_name, 3},
    {field_type_parameters, 4},
  [377] =
    {field_name, 4},
    {field_parameters, 6},
    {field_type, 3},
    {field_type_parameters, 5},
  [381] =
    {field_body, 7, .inherited = true},
    {field_name, 3},
    {field_parameters, 5},
    {field_type, 2},
    {field_type_parameters, 4},
  [386] =
    {field_body, 7, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
    {field_type, 2},
  [390] =
    {field_body, 7, .inherited = true},
    {field_name, 4},
    {field_parameters, 6},
    {field_type, 2},
    {field_type_parameters, 5},
  [395] =
    {field_accessors, 4},
    {field_name, 3},
    {field_type, 2},
    {field_value, 6},
  [399] =
    {field_parameters, 5},
    {field_type, 2},
    {field_value, 6},
  [402] =
    {field_body, 5},
  [403] =
    {field_body, 8, .inherited = true},
    {field_name, 4},
    {field_parameters, 6},
    {field_type, 2},
    {field_type_parameters, 5},
  [408] =
    {field_accessors, 5},
    {field_name, 4},
    {field_type, 2},
    {field_value, 7},
  [412] =
    {field_body, 6},
    {field_update, 4},
  [414] =
    {field_body, 6},
    {field_condition, 3},
  [416] =
    {field_body, 6},
    {field_initializer, 2},
  [418] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [421] =
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [424] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5},
  [427] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [430] =
    {field_body, 7},
    {field_initializer, 2},
    {field_update, 5},
  [433] =
    {field_body, 7},
    {field_condition, 4},
    {field_initializer, 2},
  [436] =
    {field_body, 7},
    {field_initializer, 2},
    {field_initializer, 3},
  [439] =
    {field_body, 7},
    {field_left, 3},
    {field_right, 5},
  [442] =
    {field_body, 7},
    {field_left, 3},
    {field_right, 5},
    {field_type, 2},
  [446] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6},
  [450] =
    {field_body, 8},
    {field_initializer, 2},
    {field_update, 5},
    {field_update, 6},
  [454] =
    {field_body, 8},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
  [458] =
    {field_body, 8},
    {field_initializer, 2},
    {field_initializer, 3},
    {field_update, 6},
  [462] =
    {field_body, 8},
    {field_condition, 5},
    {field_initializer, 2},
    {field_initializer, 3},
  [466] =
    {field_body, 8},
    {field_left, 4},
    {field_right, 6},
    {field_type, 3},
  [470] =
    {field_body, 9},
    {field_condition, 4},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
  [475] =
    {field_body, 9},
    {field_initializer, 2},
    {field_initializer, 3},
    {field_update, 6},
    {field_update, 7},
  [480] =
    {field_body, 9},
    {field_condition, 5},
    {field_initializer, 2},
    {field_initializer, 3},
    {field_update, 7},
  [485] =
    {field_body, 10},
    {field_condition, 5},
    {field_initializer, 2},
    {field_initializer, 3},
    {field_update, 7},
    {field_update, 8},
};

static TSSymbol ts_alias_sequences[165][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [66] = {
    [1] = alias_sym_label_name,
  },
  [67] = {
    [0] = alias_sym_label_name,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(111);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(77);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(160);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(52);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '@') ADVANCE(9);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '^') ADVANCE(83);
      if (lookahead == '_') ADVANCE(143);
      if (lookahead == '{') ADVANCE(64);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(65);
      if (lookahead == '~') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(12)
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(118);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '{') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(114);
      if (lookahead != 0) ADVANCE(120);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(13)
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(176);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(172);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(77);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(160);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(52);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '@') ADVANCE(9);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '^') ADVANCE(83);
      if (lookahead == '_') ADVANCE(143);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(65);
      if (lookahead == '~') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(77);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(60);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(52);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '@') ADVANCE(40);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '^') ADVANCE(83);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(65);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(4)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(86);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(72);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '/') ADVANCE(78);
      if (lookahead == '<') ADVANCE(49);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '@') ADVANCE(40);
      if (lookahead == '^') ADVANCE(82);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '~') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(68);
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '&') ADVANCE(86);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(72);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(56);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '0') ADVANCE(160);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '?') ADVANCE(96);
      if (lookahead == '@') ADVANCE(9);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '^') ADVANCE(82);
      if (lookahead == '_') ADVANCE(143);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '}') ADVANCE(65);
      if (lookahead == '~') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(111);
      if (lookahead == '#') ADVANCE(126);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(122);
      if (lookahead != 0) ADVANCE(128);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(109);
      if (lookahead == '@') ADVANCE(10);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(11);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(112);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(179);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '{') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(162);
      if (lookahead == '@') ADVANCE(185);
      if (lookahead == '_') ADVANCE(144);
      if (lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(163);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == ':') ADVANCE(21);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(47);
      if (lookahead == '=') ADVANCE(45);
      if (lookahead == '>') ADVANCE(51);
      if (lookahead == '?') ADVANCE(96);
      if (lookahead == '@') ADVANCE(40);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(15)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(154);
      if (lookahead == '/') ADVANCE(153);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(152);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(135);
      if (lookahead == '/') ADVANCE(132);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(131);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(20);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '/') ADVANCE(181);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 21:
      if (lookahead == ':') ADVANCE(46);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(92);
      END_STATE();
    case 23:
      if (lookahead == '>') ADVANCE(138);
      END_STATE();
    case 24:
      if (lookahead == 'U') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(30);
      if (lookahead != 0) ADVANCE(155);
      END_STATE();
    case 25:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(171);
      END_STATE();
    case 26:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(164);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(169);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(171);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(155);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(158);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 39:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(196);
      END_STATE();
    case 40:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 41:
      if (eof) ADVANCE(42);
      if (lookahead == '!') ADVANCE(69);
      if (lookahead == '#') ADVANCE(39);
      if (lookahead == '%') ADVANCE(81);
      if (lookahead == '&') ADVANCE(87);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(77);
      if (lookahead == '+') ADVANCE(73);
      if (lookahead == ',') ADVANCE(50);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(59);
      if (lookahead == ';') ADVANCE(43);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == '>') ADVANCE(52);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '@') ADVANCE(40);
      if (lookahead == '[') ADVANCE(57);
      if (lookahead == ']') ADVANCE(58);
      if (lookahead == '^') ADVANCE(83);
      if (lookahead == '{') ADVANCE(63);
      if (lookahead == '|') ADVANCE(85);
      if (lookahead == '}') ADVANCE(65);
      if (lookahead == '~') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(41)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(91);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(94);
      if (lookahead == '>') ADVANCE(90);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(139);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(169);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(46);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(113);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(93);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(70);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(70);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(71);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(138);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '|') ADVANCE(141);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(140);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(142);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DQUOTE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(129);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOLLAR_AT_DQUOTE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (lookahead == '#') ADVANCE(118);
      if (lookahead == '/') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(120);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (lookahead == '*') ADVANCE(116);
      if (lookahead == '/') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(120);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (lookahead == '*') ADVANCE(117);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (lookahead == '/') ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(116);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(120);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(119);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(120);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_interpolated_string_text_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead == '\n') ADVANCE(128);
      if (lookahead == '"' ||
          lookahead == '{') ADVANCE(183);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead == '#') ADVANCE(126);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(128);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead == '*') ADVANCE(124);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(128);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead == '*') ADVANCE(125);
      if (lookahead == '"' ||
          lookahead == '{') ADVANCE(19);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead == '/') ADVANCE(128);
      if (lookahead == '"' ||
          lookahead == '{') ADVANCE(19);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(128);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_interpolated_verbatim_string_text_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '{') ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead == '\n') ADVANCE(137);
      if (lookahead == '"' ||
          lookahead == '}') ADVANCE(183);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead == '#') ADVANCE(135);
      if (lookahead == '/') ADVANCE(132);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(131);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead == '*') ADVANCE(133);
      if (lookahead == '/') ADVANCE(130);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead == '*') ADVANCE(134);
      if (lookahead == '"' ||
          lookahead == '}') ADVANCE(19);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead == '/') ADVANCE(137);
      if (lookahead == '"' ||
          lookahead == '}') ADVANCE(19);
      if (lookahead != 0) ADVANCE(133);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_interpolation_format_clause_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'L') ADVANCE(148);
      if (lookahead == 'U') ADVANCE(147);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(147);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(145);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(143);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == 'L') ADVANCE(148);
      if (lookahead == 'U') ADVANCE(147);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == 'u') ADVANCE(147);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(146);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'M' ||
          lookahead == 'd' ||
          lookahead == 'f' ||
          lookahead == 'm') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(196);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(155);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(156);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(157);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_integer_literal);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(38);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(191);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(190);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(194);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(190);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'L') ADVANCE(167);
      if (lookahead == 'U') ADVANCE(166);
      if (lookahead == 'l') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_integer_literal);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_real_literal);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(190);
      if (('D' <= lookahead && lookahead <= 'F') ||
          lookahead == 'M' ||
          ('d' <= lookahead && lookahead <= 'f') ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_real_literal);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'M' ||
          lookahead == 'd' ||
          lookahead == 'f' ||
          lookahead == 'm') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '#') ADVANCE(176);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '*') ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(174);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_verbatim_string_literal);
      if (lookahead == '"') ADVANCE(11);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_verbatim_string_literal);
      if (lookahead == '"') ADVANCE(186);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(162);
      if (lookahead == '@') ADVANCE(185);
      if (lookahead == '_') ADVANCE(144);
      if (lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(163);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '"') ADVANCE(186);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '"') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(11);
      if (lookahead != 0) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '*') ADVANCE(189);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '/') ADVANCE(181);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_preprocessor_call_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_preprocessor_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(196);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'g') ADVANCE(8);
      if (lookahead == 'i') ADVANCE(9);
      if (lookahead == 'j') ADVANCE(10);
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'p') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      if (lookahead == 'u') ADVANCE(19);
      if (lookahead == 'v') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      if (lookahead == 'y') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_discard);
      if (lookahead == '_') ADVANCE(23);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(24);
      if (lookahead == 'd') ADVANCE(25);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(32);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'h') ADVANCE(34);
      if (lookahead == 'l') ADVANCE(35);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      if (lookahead == 'q') ADVANCE(41);
      if (lookahead == 'v') ADVANCE(42);
      if (lookahead == 'x') ADVANCE(43);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == 'l') ADVANCE(46);
      if (lookahead == 'o') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'l') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(53);
      if (lookahead == 'm') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(60);
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'e') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      END_STATE();
    case 14:
      if (lookahead == 'b') ADVANCE(65);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == 'p') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == 'u') ADVANCE(69);
      if (lookahead == 'v') ADVANCE(70);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'r') ADVANCE(72);
      if (lookahead == 'u') ADVANCE(73);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 17:
      if (lookahead == 'b') ADVANCE(75);
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'h') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      if (lookahead == 'w') ADVANCE(80);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(81);
      if (lookahead == 'r') ADVANCE(82);
      if (lookahead == 'y') ADVANCE(83);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(84);
      if (lookahead == 'l') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(86);
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(88);
      if (lookahead == 'i') ADVANCE(89);
      if (lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(91);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(92);
      END_STATE();
    case 23:
      if (lookahead == 'm') ADVANCE(93);
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(95);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(96);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'c') ADVANCE(98);
      if (lookahead == 's') ADVANCE(99);
      if (lookahead == 'y') ADVANCE(100);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_by);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(108);
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'f') ADVANCE(113);
      if (lookahead == 'l') ADVANCE(114);
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(117);
      END_STATE();
    case 40:
      if (lookahead == 'u') ADVANCE(118);
      END_STATE();
    case 41:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(121);
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(124);
      if (lookahead == 'n') ADVANCE(125);
      if (lookahead == 'x') ADVANCE(126);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(131);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 54:
      if (lookahead == 'p') ADVANCE(134);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(138);
      if (lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(141);
      END_STATE();
    case 62:
      if (lookahead == 'm') ADVANCE(142);
      END_STATE();
    case 63:
      if (lookahead == 'w') ADVANCE(143);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 65:
      if (lookahead == 'j') ADVANCE(145);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 68:
      if (lookahead == 'd') ADVANCE(147);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 71:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(151);
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 73:
      if (lookahead == 'b') ADVANCE(153);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == 'f') ADVANCE(155);
      if (lookahead == 'm') ADVANCE(156);
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 75:
      if (lookahead == 'y') ADVANCE(158);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(159);
      if (lookahead == 'l') ADVANCE(160);
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(162);
      END_STATE();
    case 78:
      if (lookahead == 'z') ADVANCE(163);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(164);
      if (lookahead == 'r') ADVANCE(165);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 82:
      if (lookahead == 'u') ADVANCE(169);
      if (lookahead == 'y') ADVANCE(170);
      END_STATE();
    case 83:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(174);
      if (lookahead == 'm') ADVANCE(175);
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 87:
      if (lookahead == 'h') ADVANCE(177);
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 88:
      if (lookahead == 'r') ADVANCE(179);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(181);
      if (lookahead == 'l') ADVANCE(182);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(183);
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(186);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_add);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(189);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(192);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(196);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(198);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 109:
      if (lookahead == 'c') ADVANCE(199);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(201);
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(204);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 115:
      if (lookahead == 'c') ADVANCE(206);
      END_STATE();
    case 116:
      if (lookahead == 'b') ADVANCE(207);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 118:
      if (lookahead == 'm') ADVANCE(209);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(210);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 121:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 123:
      if (lookahead == 's') ADVANCE(214);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(216);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(218);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 129:
      if (lookahead == 'm') ADVANCE(220);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 131:
      if (lookahead == 'b') ADVANCE(221);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(222);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(223);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_predefined_type);
      if (lookahead == 'e') ADVANCE(225);
      if (lookahead == 'o') ADVANCE(226);
      END_STATE();
    case 136:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 138:
      if (lookahead == 'k') ADVANCE(228);
      END_STATE();
    case 139:
      if (lookahead == 'g') ADVANCE(195);
      END_STATE();
    case 140:
      if (lookahead == 'h') ADVANCE(229);
      END_STATE();
    case 141:
      if (lookahead == 'u') ADVANCE(230);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 144:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 146:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_out);
      END_STATE();
    case 149:
      if (lookahead == 'r') ADVANCE(236);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(237);
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 151:
      if (lookahead == 'v') ADVANCE(239);
      END_STATE();
    case 152:
      if (lookahead == 'p') ADVANCE(240);
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 153:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 154:
      if (lookahead == 'd') ADVANCE(243);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(244);
      END_STATE();
    case 157:
      if (lookahead == 'u') ADVANCE(245);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(246);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(247);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(248);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(249);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(251);
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(253);
      if (lookahead == 'u') ADVANCE(254);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 168:
      if (lookahead == 'o') ADVANCE(257);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 173:
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 174:
      if (lookahead == 'h') ADVANCE(261);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(262);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(263);
      END_STATE();
    case 177:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(265);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(266);
      END_STATE();
    case 181:
      if (lookahead == 'd') ADVANCE(267);
      END_STATE();
    case 182:
      if (lookahead == 'a') ADVANCE(268);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(269);
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 184:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 185:
      if (lookahead == 'l') ADVANCE(272);
      END_STATE();
    case 186:
      if (lookahead == 'k') ADVANCE(273);
      END_STATE();
    case 187:
      if (lookahead == 'f') ADVANCE(274);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(275);
      END_STATE();
    case 189:
      if (lookahead == 's') ADVANCE(276);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 191:
      if (lookahead == 'm') ADVANCE(278);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(279);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(280);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_base);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_predefined_type);
      END_STATE();
    case 196:
      if (lookahead == 'k') ADVANCE(281);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 198:
      if (lookahead == 'h') ADVANCE(282);
      END_STATE();
    case 199:
      if (lookahead == 'k') ADVANCE(283);
      END_STATE();
    case 200:
      if (lookahead == 's') ADVANCE(284);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(285);
      END_STATE();
    case 202:
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 203:
      if (lookahead == 'm') ADVANCE(287);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(288);
      END_STATE();
    case 205:
      if (lookahead == 'g') ADVANCE(289);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 207:
      if (lookahead == 'l') ADVANCE(291);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 210:
      if (lookahead == 'l') ADVANCE(292);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 212:
      if (lookahead == 'i') ADVANCE(294);
      END_STATE();
    case 213:
      if (lookahead == 'r') ADVANCE(295);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(296);
      END_STATE();
    case 215:
      if (lookahead == 'd') ADVANCE(297);
      END_STATE();
    case 216:
      if (lookahead == 'l') ADVANCE(298);
      END_STATE();
    case 217:
      if (lookahead == 'd') ADVANCE(299);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 219:
      if (lookahead == 'a') ADVANCE(300);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 221:
      if (lookahead == 'a') ADVANCE(301);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 223:
      if (lookahead == 'p') ADVANCE(302);
      END_STATE();
    case 224:
      if (lookahead == 'i') ADVANCE(303);
      END_STATE();
    case 225:
      if (lookahead == 'r') ADVANCE(304);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_into);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_join);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_lock);
      END_STATE();
    case 229:
      if (lookahead == 'o') ADVANCE(305);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(306);
      END_STATE();
    case 231:
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 233:
      if (lookahead == 'c') ADVANCE(308);
      END_STATE();
    case 234:
      if (lookahead == 'a') ADVANCE(309);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(310);
      END_STATE();
    case 236:
      if (lookahead == 'r') ADVANCE(311);
      END_STATE();
    case 237:
      if (lookahead == 'm') ADVANCE(312);
      END_STATE();
    case 238:
      if (lookahead == 'i') ADVANCE(313);
      END_STATE();
    case 239:
      if (lookahead == 'a') ADVANCE(314);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 242:
      if (lookahead == 'i') ADVANCE(317);
      END_STATE();
    case 243:
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 244:
      if (lookahead == 'v') ADVANCE(319);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 248:
      if (lookahead == 'c') ADVANCE(322);
      END_STATE();
    case 249:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 250:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 251:
      if (lookahead == 'k') ADVANCE(324);
      END_STATE();
    case 252:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 254:
      if (lookahead == 'c') ADVANCE(327);
      END_STATE();
    case 255:
      if (lookahead == 'c') ADVANCE(328);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_this);
      END_STATE();
    case 257:
      if (lookahead == 'w') ADVANCE(329);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 260:
      if (lookahead == 'g') ADVANCE(195);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(331);
      END_STATE();
    case 262:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 263:
      if (lookahead == 'f') ADVANCE(333);
      END_STATE();
    case 264:
      if (lookahead == 'r') ADVANCE(334);
      END_STATE();
    case 265:
      if (lookahead == 'g') ADVANCE(335);
      END_STATE();
    case 266:
      if (lookahead == 'u') ADVANCE(336);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_void_keyword);
      END_STATE();
    case 268:
      if (lookahead == 't') ADVANCE(337);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 272:
      if (lookahead == 'd') ADVANCE(340);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(342);
      if (lookahead == 'v') ADVANCE(343);
      END_STATE();
    case 275:
      if (lookahead == 'a') ADVANCE(344);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 277:
      if (lookahead == 'd') ADVANCE(345);
      END_STATE();
    case 278:
      if (lookahead == 'b') ADVANCE(346);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(347);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 286:
      if (lookahead == 'n') ADVANCE(348);
      END_STATE();
    case 287:
      if (lookahead == 'a') ADVANCE(349);
      END_STATE();
    case 288:
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 289:
      if (lookahead == 'a') ADVANCE(351);
      END_STATE();
    case 290:
      if (lookahead == 'n') ADVANCE(352);
      END_STATE();
    case 291:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 292:
      if (lookahead == 's') ADVANCE(353);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 294:
      if (lookahead == 'c') ADVANCE(354);
      END_STATE();
    case 295:
      if (lookahead == 'n') ADVANCE(355);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_field);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(356);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_fixed);
      END_STATE();
    case 300:
      if (lookahead == 'c') ADVANCE(357);
      END_STATE();
    case 301:
      if (lookahead == 'l') ADVANCE(358);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_group);
      END_STATE();
    case 303:
      if (lookahead == 'c') ADVANCE(359);
      END_STATE();
    case 304:
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 'n') ADVANCE(361);
      END_STATE();
    case 305:
      if (lookahead == 'd') ADVANCE(362);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(363);
      END_STATE();
    case 307:
      if (lookahead == 'p') ADVANCE(364);
      END_STATE();
    case 308:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 310:
      if (lookahead == 'b') ADVANCE(366);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(367);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_param);
      if (lookahead == 's') ADVANCE(368);
      END_STATE();
    case 313:
      if (lookahead == 'a') ADVANCE(369);
      END_STATE();
    case 314:
      if (lookahead == 't') ADVANCE(370);
      END_STATE();
    case 315:
      if (lookahead == 'r') ADVANCE(371);
      END_STATE();
    case 316:
      if (lookahead == 'c') ADVANCE(372);
      END_STATE();
    case 317:
      if (lookahead == 'c') ADVANCE(373);
      END_STATE();
    case 318:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 320:
      if (lookahead == 'n') ADVANCE(376);
      END_STATE();
    case 321:
      if (lookahead == 'd') ADVANCE(377);
      END_STATE();
    case 322:
      if (lookahead == 't') ADVANCE(378);
      END_STATE();
    case 323:
      if (lookahead == 'f') ADVANCE(379);
      END_STATE();
    case 324:
      if (lookahead == 'a') ADVANCE(380);
      END_STATE();
    case 325:
      if (lookahead == 'c') ADVANCE(381);
      END_STATE();
    case 326:
      if (lookahead == 'g') ADVANCE(195);
      END_STATE();
    case 327:
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 328:
      if (lookahead == 'h') ADVANCE(383);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 330:
      if (lookahead == 'f') ADVANCE(384);
      END_STATE();
    case 331:
      if (lookahead == 'c') ADVANCE(385);
      END_STATE();
    case 332:
      if (lookahead == 'a') ADVANCE(386);
      END_STATE();
    case 333:
      if (lookahead == 'e') ADVANCE(387);
      END_STATE();
    case 334:
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 336:
      if (lookahead == 'a') ADVANCE(388);
      END_STATE();
    case 337:
      if (lookahead == 'i') ADVANCE(389);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 341:
      if (lookahead == 'r') ADVANCE(390);
      END_STATE();
    case 342:
      if (lookahead == 'y') ADVANCE(391);
      END_STATE();
    case 343:
      if (lookahead == 'a') ADVANCE(392);
      END_STATE();
    case 344:
      if (lookahead == 'c') ADVANCE(393);
      END_STATE();
    case 345:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 346:
      if (lookahead == 'l') ADVANCE(395);
      END_STATE();
    case 347:
      if (lookahead == 'd') ADVANCE(396);
      END_STATE();
    case 348:
      if (lookahead == 'u') ADVANCE(397);
      END_STATE();
    case 349:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 350:
      if (lookahead == 't') ADVANCE(398);
      END_STATE();
    case 351:
      if (lookahead == 't') ADVANCE(399);
      END_STATE();
    case 352:
      if (lookahead == 'd') ADVANCE(400);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_equals);
      END_STATE();
    case 354:
      if (lookahead == 'i') ADVANCE(401);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 356:
      if (lookahead == 'y') ADVANCE(402);
      END_STATE();
    case 357:
      if (lookahead == 'h') ADVANCE(403);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_global);
      END_STATE();
    case 359:
      if (lookahead == 'i') ADVANCE(404);
      END_STATE();
    case 360:
      if (lookahead == 'a') ADVANCE(405);
      END_STATE();
    case 361:
      if (lookahead == 'a') ADVANCE(406);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_method);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 364:
      if (lookahead == 'a') ADVANCE(407);
      END_STATE();
    case 365:
      if (lookahead == 'o') ADVANCE(408);
      END_STATE();
    case 366:
      if (lookahead == 'y') ADVANCE(409);
      END_STATE();
    case 367:
      if (lookahead == 'd') ADVANCE(410);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_params);
      END_STATE();
    case 369:
      if (lookahead == 'l') ADVANCE(411);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(412);
      END_STATE();
    case 371:
      if (lookahead == 't') ADVANCE(413);
      END_STATE();
    case 372:
      if (lookahead == 't') ADVANCE(414);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 374:
      if (lookahead == 'l') ADVANCE(415);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_remove);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_sealed);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_sizeof);
      END_STATE();
    case 380:
      if (lookahead == 'l') ADVANCE(416);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 385:
      if (lookahead == 'k') ADVANCE(417);
      END_STATE();
    case 386:
      if (lookahead == 'g') ADVANCE(418);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_unsafe);
      END_STATE();
    case 388:
      if (lookahead == 'l') ADVANCE(419);
      END_STATE();
    case 389:
      if (lookahead == 'l') ADVANCE(420);
      END_STATE();
    case 390:
      if (lookahead == 'e') ADVANCE(421);
      END_STATE();
    case 391:
      if (lookahead == 'p') ADVANCE(422);
      END_STATE();
    case 392:
      if (lookahead == 'l') ADVANCE(423);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(424);
      END_STATE();
    case 394:
      if (lookahead == 'n') ADVANCE(425);
      END_STATE();
    case 395:
      if (lookahead == 'y') ADVANCE(426);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_checked);
      END_STATE();
    case 397:
      if (lookahead == 'e') ADVANCE(427);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 399:
      if (lookahead == 'e') ADVANCE(428);
      END_STATE();
    case 400:
      if (lookahead == 'i') ADVANCE(429);
      END_STATE();
    case 401:
      if (lookahead == 't') ADVANCE(430);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(431);
      END_STATE();
    case 405:
      if (lookahead == 'c') ADVANCE(432);
      END_STATE();
    case 406:
      if (lookahead == 'l') ADVANCE(433);
      END_STATE();
    case 407:
      if (lookahead == 'c') ADVANCE(434);
      END_STATE();
    case 408:
      if (lookahead == 'r') ADVANCE(435);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_orderby);
      END_STATE();
    case 410:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_partial);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 413:
      if (lookahead == 'y') ADVANCE(437);
      END_STATE();
    case 414:
      if (lookahead == 'e') ADVANCE(438);
      END_STATE();
    case 415:
      if (lookahead == 'y') ADVANCE(439);
      END_STATE();
    case 416:
      if (lookahead == 'l') ADVANCE(440);
      END_STATE();
    case 417:
      if (lookahead == 'e') ADVANCE(441);
      END_STATE();
    case 418:
      if (lookahead == 'e') ADVANCE(442);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_virtual);
      END_STATE();
    case 420:
      if (lookahead == 'e') ADVANCE(443);
      END_STATE();
    case 421:
      if (lookahead == 'f') ADVANCE(444);
      END_STATE();
    case 422:
      if (lookahead == 'e') ADVANCE(445);
      END_STATE();
    case 423:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 425:
      if (lookahead == 'g') ADVANCE(447);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_assembly);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_delegate);
      END_STATE();
    case 429:
      if (lookahead == 'n') ADVANCE(448);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_explicit);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_implicit);
      END_STATE();
    case 432:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 434:
      if (lookahead == 'e') ADVANCE(450);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 438:
      if (lookahead == 'd') ADVANCE(451);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 440:
      if (lookahead == 'o') ADVANCE(452);
      END_STATE();
    case 441:
      if (lookahead == 'd') ADVANCE(453);
      END_STATE();
    case 442:
      if (lookahead == 'd') ADVANCE(454);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym___makeref);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym___reftype);
      END_STATE();
    case 446:
      if (lookahead == 'e') ADVANCE(455);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_ascending);
      END_STATE();
    case 448:
      if (lookahead == 'g') ADVANCE(456);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 452:
      if (lookahead == 'c') ADVANCE(457);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_unchecked);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_unmanaged);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym___refvalue);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_descending);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_stackalloc);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 41},
  [2] = {.lex_state = 6},
  [3] = {.lex_state = 6},
  [4] = {.lex_state = 6},
  [5] = {.lex_state = 6},
  [6] = {.lex_state = 6},
  [7] = {.lex_state = 6},
  [8] = {.lex_state = 6},
  [9] = {.lex_state = 6},
  [10] = {.lex_state = 6},
  [11] = {.lex_state = 6},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 6},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 6},
  [22] = {.lex_state = 6},
  [23] = {.lex_state = 6},
  [24] = {.lex_state = 6},
  [25] = {.lex_state = 6},
  [26] = {.lex_state = 6},
  [27] = {.lex_state = 6},
  [28] = {.lex_state = 6},
  [29] = {.lex_state = 6},
  [30] = {.lex_state = 6},
  [31] = {.lex_state = 6},
  [32] = {.lex_state = 6},
  [33] = {.lex_state = 6},
  [34] = {.lex_state = 6},
  [35] = {.lex_state = 6},
  [36] = {.lex_state = 6},
  [37] = {.lex_state = 6},
  [38] = {.lex_state = 6},
  [39] = {.lex_state = 6},
  [40] = {.lex_state = 6},
  [41] = {.lex_state = 6},
  [42] = {.lex_state = 6},
  [43] = {.lex_state = 6},
  [44] = {.lex_state = 6},
  [45] = {.lex_state = 6},
  [46] = {.lex_state = 6},
  [47] = {.lex_state = 6},
  [48] = {.lex_state = 6},
  [49] = {.lex_state = 6},
  [50] = {.lex_state = 6},
  [51] = {.lex_state = 6},
  [52] = {.lex_state = 6},
  [53] = {.lex_state = 6},
  [54] = {.lex_state = 6},
  [55] = {.lex_state = 6},
  [56] = {.lex_state = 6},
  [57] = {.lex_state = 6},
  [58] = {.lex_state = 6},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 6},
  [62] = {.lex_state = 6},
  [63] = {.lex_state = 6},
  [64] = {.lex_state = 6},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 6},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 6},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 6},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 6},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 6},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 6},
  [80] = {.lex_state = 6},
  [81] = {.lex_state = 6},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 6},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 3},
  [86] = {.lex_state = 3},
  [87] = {.lex_state = 3},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 6},
  [99] = {.lex_state = 6},
  [100] = {.lex_state = 6},
  [101] = {.lex_state = 6},
  [102] = {.lex_state = 6},
  [103] = {.lex_state = 6},
  [104] = {.lex_state = 6},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 6},
  [107] = {.lex_state = 6},
  [108] = {.lex_state = 6},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 6},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 6},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 6},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 6},
  [123] = {.lex_state = 6},
  [124] = {.lex_state = 6},
  [125] = {.lex_state = 6},
  [126] = {.lex_state = 6},
  [127] = {.lex_state = 6},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 6},
  [131] = {.lex_state = 6},
  [132] = {.lex_state = 6},
  [133] = {.lex_state = 6},
  [134] = {.lex_state = 6},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 6},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 6},
  [140] = {.lex_state = 6},
  [141] = {.lex_state = 6},
  [142] = {.lex_state = 6},
  [143] = {.lex_state = 6},
  [144] = {.lex_state = 6},
  [145] = {.lex_state = 6},
  [146] = {.lex_state = 6},
  [147] = {.lex_state = 6},
  [148] = {.lex_state = 6},
  [149] = {.lex_state = 6},
  [150] = {.lex_state = 6},
  [151] = {.lex_state = 6},
  [152] = {.lex_state = 6},
  [153] = {.lex_state = 6},
  [154] = {.lex_state = 6},
  [155] = {.lex_state = 6},
  [156] = {.lex_state = 6},
  [157] = {.lex_state = 6},
  [158] = {.lex_state = 6},
  [159] = {.lex_state = 6},
  [160] = {.lex_state = 6},
  [161] = {.lex_state = 6},
  [162] = {.lex_state = 6},
  [163] = {.lex_state = 6},
  [164] = {.lex_state = 6},
  [165] = {.lex_state = 6},
  [166] = {.lex_state = 6},
  [167] = {.lex_state = 6},
  [168] = {.lex_state = 6},
  [169] = {.lex_state = 6},
  [170] = {.lex_state = 6},
  [171] = {.lex_state = 6},
  [172] = {.lex_state = 6},
  [173] = {.lex_state = 6},
  [174] = {.lex_state = 6},
  [175] = {.lex_state = 6},
  [176] = {.lex_state = 6},
  [177] = {.lex_state = 6},
  [178] = {.lex_state = 6},
  [179] = {.lex_state = 6},
  [180] = {.lex_state = 6},
  [181] = {.lex_state = 6},
  [182] = {.lex_state = 6},
  [183] = {.lex_state = 6},
  [184] = {.lex_state = 6},
  [185] = {.lex_state = 6},
  [186] = {.lex_state = 6},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 6},
  [189] = {.lex_state = 6},
  [190] = {.lex_state = 6},
  [191] = {.lex_state = 6},
  [192] = {.lex_state = 6},
  [193] = {.lex_state = 6},
  [194] = {.lex_state = 6},
  [195] = {.lex_state = 6},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 6},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 6},
  [214] = {.lex_state = 6},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 6},
  [217] = {.lex_state = 6},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 6},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 6},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 6},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 6},
  [238] = {.lex_state = 6},
  [239] = {.lex_state = 6},
  [240] = {.lex_state = 6},
  [241] = {.lex_state = 6},
  [242] = {.lex_state = 6},
  [243] = {.lex_state = 6},
  [244] = {.lex_state = 6},
  [245] = {.lex_state = 6},
  [246] = {.lex_state = 6},
  [247] = {.lex_state = 6},
  [248] = {.lex_state = 6},
  [249] = {.lex_state = 6},
  [250] = {.lex_state = 6},
  [251] = {.lex_state = 6},
  [252] = {.lex_state = 6},
  [253] = {.lex_state = 6},
  [254] = {.lex_state = 6},
  [255] = {.lex_state = 6},
  [256] = {.lex_state = 6},
  [257] = {.lex_state = 6},
  [258] = {.lex_state = 6},
  [259] = {.lex_state = 6},
  [260] = {.lex_state = 6},
  [261] = {.lex_state = 6},
  [262] = {.lex_state = 6},
  [263] = {.lex_state = 6},
  [264] = {.lex_state = 6},
  [265] = {.lex_state = 6},
  [266] = {.lex_state = 6},
  [267] = {.lex_state = 6},
  [268] = {.lex_state = 6},
  [269] = {.lex_state = 6},
  [270] = {.lex_state = 6},
  [271] = {.lex_state = 6},
  [272] = {.lex_state = 6},
  [273] = {.lex_state = 6},
  [274] = {.lex_state = 6},
  [275] = {.lex_state = 6},
  [276] = {.lex_state = 6},
  [277] = {.lex_state = 6},
  [278] = {.lex_state = 6},
  [279] = {.lex_state = 6},
  [280] = {.lex_state = 6},
  [281] = {.lex_state = 6},
  [282] = {.lex_state = 6},
  [283] = {.lex_state = 6},
  [284] = {.lex_state = 6},
  [285] = {.lex_state = 6},
  [286] = {.lex_state = 6},
  [287] = {.lex_state = 6},
  [288] = {.lex_state = 6},
  [289] = {.lex_state = 6},
  [290] = {.lex_state = 6},
  [291] = {.lex_state = 6},
  [292] = {.lex_state = 6},
  [293] = {.lex_state = 6},
  [294] = {.lex_state = 6},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 6},
  [298] = {.lex_state = 6},
  [299] = {.lex_state = 6},
  [300] = {.lex_state = 6},
  [301] = {.lex_state = 6},
  [302] = {.lex_state = 6},
  [303] = {.lex_state = 6},
  [304] = {.lex_state = 6},
  [305] = {.lex_state = 6},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 6},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 6},
  [313] = {.lex_state = 6},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 6},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 6},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 6},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 6},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 6},
  [328] = {.lex_state = 6},
  [329] = {.lex_state = 6},
  [330] = {.lex_state = 6},
  [331] = {.lex_state = 6},
  [332] = {.lex_state = 6},
  [333] = {.lex_state = 6},
  [334] = {.lex_state = 6},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 6},
  [337] = {.lex_state = 6},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 6},
  [340] = {.lex_state = 6},
  [341] = {.lex_state = 6},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 6},
  [344] = {.lex_state = 6},
  [345] = {.lex_state = 6},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 6},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 6},
  [350] = {.lex_state = 6},
  [351] = {.lex_state = 6},
  [352] = {.lex_state = 6},
  [353] = {.lex_state = 6},
  [354] = {.lex_state = 6},
  [355] = {.lex_state = 6},
  [356] = {.lex_state = 6},
  [357] = {.lex_state = 6},
  [358] = {.lex_state = 6},
  [359] = {.lex_state = 6},
  [360] = {.lex_state = 6},
  [361] = {.lex_state = 6},
  [362] = {.lex_state = 6},
  [363] = {.lex_state = 6},
  [364] = {.lex_state = 6},
  [365] = {.lex_state = 6},
  [366] = {.lex_state = 6},
  [367] = {.lex_state = 6},
  [368] = {.lex_state = 6},
  [369] = {.lex_state = 6},
  [370] = {.lex_state = 6},
  [371] = {.lex_state = 6},
  [372] = {.lex_state = 6},
  [373] = {.lex_state = 6},
  [374] = {.lex_state = 6},
  [375] = {.lex_state = 6},
  [376] = {.lex_state = 6},
  [377] = {.lex_state = 6},
  [378] = {.lex_state = 6},
  [379] = {.lex_state = 6},
  [380] = {.lex_state = 6},
  [381] = {.lex_state = 6},
  [382] = {.lex_state = 6},
  [383] = {.lex_state = 6},
  [384] = {.lex_state = 6},
  [385] = {.lex_state = 6},
  [386] = {.lex_state = 6},
  [387] = {.lex_state = 6},
  [388] = {.lex_state = 6},
  [389] = {.lex_state = 6},
  [390] = {.lex_state = 6},
  [391] = {.lex_state = 6},
  [392] = {.lex_state = 6},
  [393] = {.lex_state = 6},
  [394] = {.lex_state = 6},
  [395] = {.lex_state = 6},
  [396] = {.lex_state = 6},
  [397] = {.lex_state = 6},
  [398] = {.lex_state = 6},
  [399] = {.lex_state = 6},
  [400] = {.lex_state = 6},
  [401] = {.lex_state = 6},
  [402] = {.lex_state = 6},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 6},
  [405] = {.lex_state = 6},
  [406] = {.lex_state = 6},
  [407] = {.lex_state = 6},
  [408] = {.lex_state = 6},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 6},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 6},
  [414] = {.lex_state = 6},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 6},
  [417] = {.lex_state = 6},
  [418] = {.lex_state = 6},
  [419] = {.lex_state = 6},
  [420] = {.lex_state = 6},
  [421] = {.lex_state = 6},
  [422] = {.lex_state = 6},
  [423] = {.lex_state = 6},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 6},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 6},
  [432] = {.lex_state = 6},
  [433] = {.lex_state = 6},
  [434] = {.lex_state = 6},
  [435] = {.lex_state = 6},
  [436] = {.lex_state = 6},
  [437] = {.lex_state = 6},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 6},
  [440] = {.lex_state = 6},
  [441] = {.lex_state = 6},
  [442] = {.lex_state = 6},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 6},
  [446] = {.lex_state = 6},
  [447] = {.lex_state = 6},
  [448] = {.lex_state = 6},
  [449] = {.lex_state = 6},
  [450] = {.lex_state = 6},
  [451] = {.lex_state = 6},
  [452] = {.lex_state = 6},
  [453] = {.lex_state = 6},
  [454] = {.lex_state = 6},
  [455] = {.lex_state = 6},
  [456] = {.lex_state = 6},
  [457] = {.lex_state = 6},
  [458] = {.lex_state = 6},
  [459] = {.lex_state = 6},
  [460] = {.lex_state = 6},
  [461] = {.lex_state = 6},
  [462] = {.lex_state = 6},
  [463] = {.lex_state = 6},
  [464] = {.lex_state = 6},
  [465] = {.lex_state = 6},
  [466] = {.lex_state = 6},
  [467] = {.lex_state = 6},
  [468] = {.lex_state = 6},
  [469] = {.lex_state = 6},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 6},
  [472] = {.lex_state = 6},
  [473] = {.lex_state = 6},
  [474] = {.lex_state = 6},
  [475] = {.lex_state = 6},
  [476] = {.lex_state = 6},
  [477] = {.lex_state = 6},
  [478] = {.lex_state = 6},
  [479] = {.lex_state = 6},
  [480] = {.lex_state = 6},
  [481] = {.lex_state = 6},
  [482] = {.lex_state = 6},
  [483] = {.lex_state = 6},
  [484] = {.lex_state = 6},
  [485] = {.lex_state = 6},
  [486] = {.lex_state = 6},
  [487] = {.lex_state = 6},
  [488] = {.lex_state = 6},
  [489] = {.lex_state = 6},
  [490] = {.lex_state = 6},
  [491] = {.lex_state = 6},
  [492] = {.lex_state = 6},
  [493] = {.lex_state = 6},
  [494] = {.lex_state = 6},
  [495] = {.lex_state = 6},
  [496] = {.lex_state = 6},
  [497] = {.lex_state = 41},
  [498] = {.lex_state = 41},
  [499] = {.lex_state = 41},
  [500] = {.lex_state = 41},
  [501] = {.lex_state = 41},
  [502] = {.lex_state = 41},
  [503] = {.lex_state = 41},
  [504] = {.lex_state = 41},
  [505] = {.lex_state = 41},
  [506] = {.lex_state = 41},
  [507] = {.lex_state = 41},
  [508] = {.lex_state = 41},
  [509] = {.lex_state = 41},
  [510] = {.lex_state = 4},
  [511] = {.lex_state = 41},
  [512] = {.lex_state = 4},
  [513] = {.lex_state = 41},
  [514] = {.lex_state = 4},
  [515] = {.lex_state = 41},
  [516] = {.lex_state = 41},
  [517] = {.lex_state = 41},
  [518] = {.lex_state = 41},
  [519] = {.lex_state = 41},
  [520] = {.lex_state = 41},
  [521] = {.lex_state = 41},
  [522] = {.lex_state = 41},
  [523] = {.lex_state = 41},
  [524] = {.lex_state = 41},
  [525] = {.lex_state = 4},
  [526] = {.lex_state = 41},
  [527] = {.lex_state = 41},
  [528] = {.lex_state = 41},
  [529] = {.lex_state = 41},
  [530] = {.lex_state = 41},
  [531] = {.lex_state = 41},
  [532] = {.lex_state = 41},
  [533] = {.lex_state = 41},
  [534] = {.lex_state = 41},
  [535] = {.lex_state = 41},
  [536] = {.lex_state = 41},
  [537] = {.lex_state = 41},
  [538] = {.lex_state = 41},
  [539] = {.lex_state = 41},
  [540] = {.lex_state = 41},
  [541] = {.lex_state = 41},
  [542] = {.lex_state = 41},
  [543] = {.lex_state = 41},
  [544] = {.lex_state = 41},
  [545] = {.lex_state = 41},
  [546] = {.lex_state = 4},
  [547] = {.lex_state = 4},
  [548] = {.lex_state = 4},
  [549] = {.lex_state = 41},
  [550] = {.lex_state = 41},
  [551] = {.lex_state = 41},
  [552] = {.lex_state = 41},
  [553] = {.lex_state = 41},
  [554] = {.lex_state = 41},
  [555] = {.lex_state = 41},
  [556] = {.lex_state = 41},
  [557] = {.lex_state = 41},
  [558] = {.lex_state = 41},
  [559] = {.lex_state = 41},
  [560] = {.lex_state = 41},
  [561] = {.lex_state = 41},
  [562] = {.lex_state = 41},
  [563] = {.lex_state = 41},
  [564] = {.lex_state = 41},
  [565] = {.lex_state = 41},
  [566] = {.lex_state = 41},
  [567] = {.lex_state = 41},
  [568] = {.lex_state = 41},
  [569] = {.lex_state = 41},
  [570] = {.lex_state = 41},
  [571] = {.lex_state = 41},
  [572] = {.lex_state = 41},
  [573] = {.lex_state = 41},
  [574] = {.lex_state = 41},
  [575] = {.lex_state = 41},
  [576] = {.lex_state = 41},
  [577] = {.lex_state = 41},
  [578] = {.lex_state = 41},
  [579] = {.lex_state = 41},
  [580] = {.lex_state = 41},
  [581] = {.lex_state = 41},
  [582] = {.lex_state = 41},
  [583] = {.lex_state = 41},
  [584] = {.lex_state = 41},
  [585] = {.lex_state = 41},
  [586] = {.lex_state = 41},
  [587] = {.lex_state = 41},
  [588] = {.lex_state = 41},
  [589] = {.lex_state = 41},
  [590] = {.lex_state = 41},
  [591] = {.lex_state = 41},
  [592] = {.lex_state = 41},
  [593] = {.lex_state = 41},
  [594] = {.lex_state = 41},
  [595] = {.lex_state = 41},
  [596] = {.lex_state = 41},
  [597] = {.lex_state = 41},
  [598] = {.lex_state = 41},
  [599] = {.lex_state = 41},
  [600] = {.lex_state = 41},
  [601] = {.lex_state = 41},
  [602] = {.lex_state = 41},
  [603] = {.lex_state = 41},
  [604] = {.lex_state = 41},
  [605] = {.lex_state = 41},
  [606] = {.lex_state = 41},
  [607] = {.lex_state = 41},
  [608] = {.lex_state = 41},
  [609] = {.lex_state = 41},
  [610] = {.lex_state = 41},
  [611] = {.lex_state = 41},
  [612] = {.lex_state = 41},
  [613] = {.lex_state = 41},
  [614] = {.lex_state = 41},
  [615] = {.lex_state = 41},
  [616] = {.lex_state = 41},
  [617] = {.lex_state = 41},
  [618] = {.lex_state = 41},
  [619] = {.lex_state = 41},
  [620] = {.lex_state = 41},
  [621] = {.lex_state = 41},
  [622] = {.lex_state = 41},
  [623] = {.lex_state = 41},
  [624] = {.lex_state = 41},
  [625] = {.lex_state = 41},
  [626] = {.lex_state = 41},
  [627] = {.lex_state = 41},
  [628] = {.lex_state = 41},
  [629] = {.lex_state = 41},
  [630] = {.lex_state = 41},
  [631] = {.lex_state = 41},
  [632] = {.lex_state = 41},
  [633] = {.lex_state = 41},
  [634] = {.lex_state = 41},
  [635] = {.lex_state = 41},
  [636] = {.lex_state = 41},
  [637] = {.lex_state = 41},
  [638] = {.lex_state = 41},
  [639] = {.lex_state = 41},
  [640] = {.lex_state = 41},
  [641] = {.lex_state = 41},
  [642] = {.lex_state = 41},
  [643] = {.lex_state = 41},
  [644] = {.lex_state = 41},
  [645] = {.lex_state = 41},
  [646] = {.lex_state = 41},
  [647] = {.lex_state = 41},
  [648] = {.lex_state = 41},
  [649] = {.lex_state = 41},
  [650] = {.lex_state = 41},
  [651] = {.lex_state = 41},
  [652] = {.lex_state = 41},
  [653] = {.lex_state = 41},
  [654] = {.lex_state = 41},
  [655] = {.lex_state = 41},
  [656] = {.lex_state = 41},
  [657] = {.lex_state = 41},
  [658] = {.lex_state = 41},
  [659] = {.lex_state = 41},
  [660] = {.lex_state = 41},
  [661] = {.lex_state = 41},
  [662] = {.lex_state = 41},
  [663] = {.lex_state = 41},
  [664] = {.lex_state = 4},
  [665] = {.lex_state = 41},
  [666] = {.lex_state = 41},
  [667] = {.lex_state = 41},
  [668] = {.lex_state = 41},
  [669] = {.lex_state = 4},
  [670] = {.lex_state = 4},
  [671] = {.lex_state = 41},
  [672] = {.lex_state = 41},
  [673] = {.lex_state = 41},
  [674] = {.lex_state = 41},
  [675] = {.lex_state = 41},
  [676] = {.lex_state = 41},
  [677] = {.lex_state = 41},
  [678] = {.lex_state = 41},
  [679] = {.lex_state = 41},
  [680] = {.lex_state = 41},
  [681] = {.lex_state = 41},
  [682] = {.lex_state = 41},
  [683] = {.lex_state = 41},
  [684] = {.lex_state = 41},
  [685] = {.lex_state = 41},
  [686] = {.lex_state = 41},
  [687] = {.lex_state = 41},
  [688] = {.lex_state = 41},
  [689] = {.lex_state = 41},
  [690] = {.lex_state = 41},
  [691] = {.lex_state = 41},
  [692] = {.lex_state = 41},
  [693] = {.lex_state = 41},
  [694] = {.lex_state = 41},
  [695] = {.lex_state = 41},
  [696] = {.lex_state = 41},
  [697] = {.lex_state = 41},
  [698] = {.lex_state = 41},
  [699] = {.lex_state = 4},
  [700] = {.lex_state = 41},
  [701] = {.lex_state = 41},
  [702] = {.lex_state = 41},
  [703] = {.lex_state = 41},
  [704] = {.lex_state = 41},
  [705] = {.lex_state = 41},
  [706] = {.lex_state = 41},
  [707] = {.lex_state = 41},
  [708] = {.lex_state = 41},
  [709] = {.lex_state = 41},
  [710] = {.lex_state = 41},
  [711] = {.lex_state = 4},
  [712] = {.lex_state = 41},
  [713] = {.lex_state = 41},
  [714] = {.lex_state = 41},
  [715] = {.lex_state = 41},
  [716] = {.lex_state = 41},
  [717] = {.lex_state = 41},
  [718] = {.lex_state = 41},
  [719] = {.lex_state = 41},
  [720] = {.lex_state = 41},
  [721] = {.lex_state = 41},
  [722] = {.lex_state = 41},
  [723] = {.lex_state = 41},
  [724] = {.lex_state = 41},
  [725] = {.lex_state = 41},
  [726] = {.lex_state = 41},
  [727] = {.lex_state = 41},
  [728] = {.lex_state = 41},
  [729] = {.lex_state = 41},
  [730] = {.lex_state = 41},
  [731] = {.lex_state = 41},
  [732] = {.lex_state = 41},
  [733] = {.lex_state = 41},
  [734] = {.lex_state = 41},
  [735] = {.lex_state = 41},
  [736] = {.lex_state = 41},
  [737] = {.lex_state = 41},
  [738] = {.lex_state = 41},
  [739] = {.lex_state = 41},
  [740] = {.lex_state = 4},
  [741] = {.lex_state = 4},
  [742] = {.lex_state = 41},
  [743] = {.lex_state = 41},
  [744] = {.lex_state = 41},
  [745] = {.lex_state = 41},
  [746] = {.lex_state = 41},
  [747] = {.lex_state = 41},
  [748] = {.lex_state = 41},
  [749] = {.lex_state = 41},
  [750] = {.lex_state = 41},
  [751] = {.lex_state = 41},
  [752] = {.lex_state = 41},
  [753] = {.lex_state = 41},
  [754] = {.lex_state = 41},
  [755] = {.lex_state = 41},
  [756] = {.lex_state = 41},
  [757] = {.lex_state = 41},
  [758] = {.lex_state = 41},
  [759] = {.lex_state = 41},
  [760] = {.lex_state = 41},
  [761] = {.lex_state = 41},
  [762] = {.lex_state = 41},
  [763] = {.lex_state = 41},
  [764] = {.lex_state = 41},
  [765] = {.lex_state = 41},
  [766] = {.lex_state = 41},
  [767] = {.lex_state = 41},
  [768] = {.lex_state = 41},
  [769] = {.lex_state = 41},
  [770] = {.lex_state = 41},
  [771] = {.lex_state = 41},
  [772] = {.lex_state = 41},
  [773] = {.lex_state = 41},
  [774] = {.lex_state = 41},
  [775] = {.lex_state = 41},
  [776] = {.lex_state = 41},
  [777] = {.lex_state = 41},
  [778] = {.lex_state = 41},
  [779] = {.lex_state = 41},
  [780] = {.lex_state = 41},
  [781] = {.lex_state = 41},
  [782] = {.lex_state = 41},
  [783] = {.lex_state = 41},
  [784] = {.lex_state = 41},
  [785] = {.lex_state = 41},
  [786] = {.lex_state = 41},
  [787] = {.lex_state = 41},
  [788] = {.lex_state = 41},
  [789] = {.lex_state = 41},
  [790] = {.lex_state = 41},
  [791] = {.lex_state = 41},
  [792] = {.lex_state = 41},
  [793] = {.lex_state = 41},
  [794] = {.lex_state = 41},
  [795] = {.lex_state = 41},
  [796] = {.lex_state = 41},
  [797] = {.lex_state = 41},
  [798] = {.lex_state = 41},
  [799] = {.lex_state = 41},
  [800] = {.lex_state = 41},
  [801] = {.lex_state = 41},
  [802] = {.lex_state = 41},
  [803] = {.lex_state = 41},
  [804] = {.lex_state = 41},
  [805] = {.lex_state = 41},
  [806] = {.lex_state = 41},
  [807] = {.lex_state = 41},
  [808] = {.lex_state = 41},
  [809] = {.lex_state = 41},
  [810] = {.lex_state = 41},
  [811] = {.lex_state = 41},
  [812] = {.lex_state = 41},
  [813] = {.lex_state = 41},
  [814] = {.lex_state = 41},
  [815] = {.lex_state = 41},
  [816] = {.lex_state = 41},
  [817] = {.lex_state = 41},
  [818] = {.lex_state = 41},
  [819] = {.lex_state = 41},
  [820] = {.lex_state = 41},
  [821] = {.lex_state = 41},
  [822] = {.lex_state = 41},
  [823] = {.lex_state = 41},
  [824] = {.lex_state = 41},
  [825] = {.lex_state = 41},
  [826] = {.lex_state = 41},
  [827] = {.lex_state = 4},
  [828] = {.lex_state = 41},
  [829] = {.lex_state = 4},
  [830] = {.lex_state = 41},
  [831] = {.lex_state = 41},
  [832] = {.lex_state = 4},
  [833] = {.lex_state = 41},
  [834] = {.lex_state = 4},
  [835] = {.lex_state = 41},
  [836] = {.lex_state = 4},
  [837] = {.lex_state = 41},
  [838] = {.lex_state = 41},
  [839] = {.lex_state = 41},
  [840] = {.lex_state = 41},
  [841] = {.lex_state = 4},
  [842] = {.lex_state = 41},
  [843] = {.lex_state = 41},
  [844] = {.lex_state = 41},
  [845] = {.lex_state = 41},
  [846] = {.lex_state = 41},
  [847] = {.lex_state = 41},
  [848] = {.lex_state = 41},
  [849] = {.lex_state = 41},
  [850] = {.lex_state = 41},
  [851] = {.lex_state = 41},
  [852] = {.lex_state = 41},
  [853] = {.lex_state = 41},
  [854] = {.lex_state = 41},
  [855] = {.lex_state = 41},
  [856] = {.lex_state = 41},
  [857] = {.lex_state = 41},
  [858] = {.lex_state = 41},
  [859] = {.lex_state = 41},
  [860] = {.lex_state = 41},
  [861] = {.lex_state = 41},
  [862] = {.lex_state = 41},
  [863] = {.lex_state = 41},
  [864] = {.lex_state = 41},
  [865] = {.lex_state = 41},
  [866] = {.lex_state = 41},
  [867] = {.lex_state = 41},
  [868] = {.lex_state = 41},
  [869] = {.lex_state = 41},
  [870] = {.lex_state = 41},
  [871] = {.lex_state = 41},
  [872] = {.lex_state = 41},
  [873] = {.lex_state = 41},
  [874] = {.lex_state = 41},
  [875] = {.lex_state = 4},
  [876] = {.lex_state = 41},
  [877] = {.lex_state = 41},
  [878] = {.lex_state = 41},
  [879] = {.lex_state = 41},
  [880] = {.lex_state = 41},
  [881] = {.lex_state = 41},
  [882] = {.lex_state = 41},
  [883] = {.lex_state = 41},
  [884] = {.lex_state = 41},
  [885] = {.lex_state = 41},
  [886] = {.lex_state = 41},
  [887] = {.lex_state = 41},
  [888] = {.lex_state = 41},
  [889] = {.lex_state = 41},
  [890] = {.lex_state = 41},
  [891] = {.lex_state = 41},
  [892] = {.lex_state = 41},
  [893] = {.lex_state = 41},
  [894] = {.lex_state = 41},
  [895] = {.lex_state = 41},
  [896] = {.lex_state = 41},
  [897] = {.lex_state = 41},
  [898] = {.lex_state = 41},
  [899] = {.lex_state = 41},
  [900] = {.lex_state = 41},
  [901] = {.lex_state = 41},
  [902] = {.lex_state = 41},
  [903] = {.lex_state = 41},
  [904] = {.lex_state = 4},
  [905] = {.lex_state = 41},
  [906] = {.lex_state = 41},
  [907] = {.lex_state = 41},
  [908] = {.lex_state = 41},
  [909] = {.lex_state = 41},
  [910] = {.lex_state = 41},
  [911] = {.lex_state = 41},
  [912] = {.lex_state = 4},
  [913] = {.lex_state = 41},
  [914] = {.lex_state = 41},
  [915] = {.lex_state = 41},
  [916] = {.lex_state = 41},
  [917] = {.lex_state = 41},
  [918] = {.lex_state = 41},
  [919] = {.lex_state = 41},
  [920] = {.lex_state = 41},
  [921] = {.lex_state = 4},
  [922] = {.lex_state = 41},
  [923] = {.lex_state = 41},
  [924] = {.lex_state = 41},
  [925] = {.lex_state = 41},
  [926] = {.lex_state = 4},
  [927] = {.lex_state = 41},
  [928] = {.lex_state = 41},
  [929] = {.lex_state = 41},
  [930] = {.lex_state = 41},
  [931] = {.lex_state = 41},
  [932] = {.lex_state = 41},
  [933] = {.lex_state = 41},
  [934] = {.lex_state = 41},
  [935] = {.lex_state = 41},
  [936] = {.lex_state = 41},
  [937] = {.lex_state = 41},
  [938] = {.lex_state = 41},
  [939] = {.lex_state = 41},
  [940] = {.lex_state = 41},
  [941] = {.lex_state = 41},
  [942] = {.lex_state = 41},
  [943] = {.lex_state = 41},
  [944] = {.lex_state = 41},
  [945] = {.lex_state = 41},
  [946] = {.lex_state = 41},
  [947] = {.lex_state = 41},
  [948] = {.lex_state = 41},
  [949] = {.lex_state = 41},
  [950] = {.lex_state = 41},
  [951] = {.lex_state = 41},
  [952] = {.lex_state = 41},
  [953] = {.lex_state = 41},
  [954] = {.lex_state = 41},
  [955] = {.lex_state = 41},
  [956] = {.lex_state = 41},
  [957] = {.lex_state = 41},
  [958] = {.lex_state = 41},
  [959] = {.lex_state = 41},
  [960] = {.lex_state = 41},
  [961] = {.lex_state = 41},
  [962] = {.lex_state = 41},
  [963] = {.lex_state = 41},
  [964] = {.lex_state = 41},
  [965] = {.lex_state = 41},
  [966] = {.lex_state = 41},
  [967] = {.lex_state = 41},
  [968] = {.lex_state = 41},
  [969] = {.lex_state = 41},
  [970] = {.lex_state = 41},
  [971] = {.lex_state = 4},
  [972] = {.lex_state = 41},
  [973] = {.lex_state = 41},
  [974] = {.lex_state = 41},
  [975] = {.lex_state = 41},
  [976] = {.lex_state = 41},
  [977] = {.lex_state = 41},
  [978] = {.lex_state = 41},
  [979] = {.lex_state = 41},
  [980] = {.lex_state = 4},
  [981] = {.lex_state = 41},
  [982] = {.lex_state = 41},
  [983] = {.lex_state = 41},
  [984] = {.lex_state = 6},
  [985] = {.lex_state = 41},
  [986] = {.lex_state = 41},
  [987] = {.lex_state = 41},
  [988] = {.lex_state = 41},
  [989] = {.lex_state = 41},
  [990] = {.lex_state = 41},
  [991] = {.lex_state = 41},
  [992] = {.lex_state = 41},
  [993] = {.lex_state = 41},
  [994] = {.lex_state = 41},
  [995] = {.lex_state = 41},
  [996] = {.lex_state = 41},
  [997] = {.lex_state = 41},
  [998] = {.lex_state = 41},
  [999] = {.lex_state = 41},
  [1000] = {.lex_state = 41},
  [1001] = {.lex_state = 41},
  [1002] = {.lex_state = 41},
  [1003] = {.lex_state = 41},
  [1004] = {.lex_state = 41},
  [1005] = {.lex_state = 41},
  [1006] = {.lex_state = 41},
  [1007] = {.lex_state = 41},
  [1008] = {.lex_state = 41},
  [1009] = {.lex_state = 41},
  [1010] = {.lex_state = 41},
  [1011] = {.lex_state = 41},
  [1012] = {.lex_state = 41},
  [1013] = {.lex_state = 41},
  [1014] = {.lex_state = 41},
  [1015] = {.lex_state = 41},
  [1016] = {.lex_state = 41},
  [1017] = {.lex_state = 41},
  [1018] = {.lex_state = 41},
  [1019] = {.lex_state = 41},
  [1020] = {.lex_state = 41},
  [1021] = {.lex_state = 41},
  [1022] = {.lex_state = 41},
  [1023] = {.lex_state = 41},
  [1024] = {.lex_state = 41},
  [1025] = {.lex_state = 41},
  [1026] = {.lex_state = 41},
  [1027] = {.lex_state = 41},
  [1028] = {.lex_state = 41},
  [1029] = {.lex_state = 4},
  [1030] = {.lex_state = 41},
  [1031] = {.lex_state = 41},
  [1032] = {.lex_state = 41},
  [1033] = {.lex_state = 41},
  [1034] = {.lex_state = 41},
  [1035] = {.lex_state = 41},
  [1036] = {.lex_state = 41},
  [1037] = {.lex_state = 41},
  [1038] = {.lex_state = 41},
  [1039] = {.lex_state = 41},
  [1040] = {.lex_state = 41},
  [1041] = {.lex_state = 41},
  [1042] = {.lex_state = 41},
  [1043] = {.lex_state = 41},
  [1044] = {.lex_state = 41},
  [1045] = {.lex_state = 41},
  [1046] = {.lex_state = 41},
  [1047] = {.lex_state = 41},
  [1048] = {.lex_state = 41},
  [1049] = {.lex_state = 41},
  [1050] = {.lex_state = 4},
  [1051] = {.lex_state = 41},
  [1052] = {.lex_state = 41},
  [1053] = {.lex_state = 41},
  [1054] = {.lex_state = 41},
  [1055] = {.lex_state = 41},
  [1056] = {.lex_state = 41},
  [1057] = {.lex_state = 41},
  [1058] = {.lex_state = 41},
  [1059] = {.lex_state = 41},
  [1060] = {.lex_state = 41},
  [1061] = {.lex_state = 41},
  [1062] = {.lex_state = 41},
  [1063] = {.lex_state = 41},
  [1064] = {.lex_state = 41},
  [1065] = {.lex_state = 41},
  [1066] = {.lex_state = 41},
  [1067] = {.lex_state = 41},
  [1068] = {.lex_state = 41},
  [1069] = {.lex_state = 41},
  [1070] = {.lex_state = 41},
  [1071] = {.lex_state = 41},
  [1072] = {.lex_state = 41},
  [1073] = {.lex_state = 41},
  [1074] = {.lex_state = 6},
  [1075] = {.lex_state = 41},
  [1076] = {.lex_state = 6},
  [1077] = {.lex_state = 41},
  [1078] = {.lex_state = 4},
  [1079] = {.lex_state = 41},
  [1080] = {.lex_state = 41},
  [1081] = {.lex_state = 41},
  [1082] = {.lex_state = 41},
  [1083] = {.lex_state = 41},
  [1084] = {.lex_state = 41},
  [1085] = {.lex_state = 41},
  [1086] = {.lex_state = 41},
  [1087] = {.lex_state = 41},
  [1088] = {.lex_state = 41},
  [1089] = {.lex_state = 41},
  [1090] = {.lex_state = 41},
  [1091] = {.lex_state = 41},
  [1092] = {.lex_state = 41},
  [1093] = {.lex_state = 41},
  [1094] = {.lex_state = 41},
  [1095] = {.lex_state = 41},
  [1096] = {.lex_state = 41},
  [1097] = {.lex_state = 41},
  [1098] = {.lex_state = 41},
  [1099] = {.lex_state = 41},
  [1100] = {.lex_state = 41},
  [1101] = {.lex_state = 41},
  [1102] = {.lex_state = 41},
  [1103] = {.lex_state = 41},
  [1104] = {.lex_state = 41},
  [1105] = {.lex_state = 41},
  [1106] = {.lex_state = 41},
  [1107] = {.lex_state = 41},
  [1108] = {.lex_state = 41},
  [1109] = {.lex_state = 41},
  [1110] = {.lex_state = 41},
  [1111] = {.lex_state = 41},
  [1112] = {.lex_state = 41},
  [1113] = {.lex_state = 41},
  [1114] = {.lex_state = 41},
  [1115] = {.lex_state = 41},
  [1116] = {.lex_state = 41},
  [1117] = {.lex_state = 41},
  [1118] = {.lex_state = 41},
  [1119] = {.lex_state = 41},
  [1120] = {.lex_state = 41},
  [1121] = {.lex_state = 41},
  [1122] = {.lex_state = 41},
  [1123] = {.lex_state = 41},
  [1124] = {.lex_state = 41},
  [1125] = {.lex_state = 41},
  [1126] = {.lex_state = 41},
  [1127] = {.lex_state = 41},
  [1128] = {.lex_state = 41},
  [1129] = {.lex_state = 41},
  [1130] = {.lex_state = 41},
  [1131] = {.lex_state = 41},
  [1132] = {.lex_state = 41},
  [1133] = {.lex_state = 41},
  [1134] = {.lex_state = 41},
  [1135] = {.lex_state = 41},
  [1136] = {.lex_state = 41},
  [1137] = {.lex_state = 41},
  [1138] = {.lex_state = 41},
  [1139] = {.lex_state = 41},
  [1140] = {.lex_state = 41},
  [1141] = {.lex_state = 41},
  [1142] = {.lex_state = 41},
  [1143] = {.lex_state = 41},
  [1144] = {.lex_state = 41},
  [1145] = {.lex_state = 41},
  [1146] = {.lex_state = 41},
  [1147] = {.lex_state = 41},
  [1148] = {.lex_state = 41},
  [1149] = {.lex_state = 41},
  [1150] = {.lex_state = 41},
  [1151] = {.lex_state = 41},
  [1152] = {.lex_state = 41},
  [1153] = {.lex_state = 41},
  [1154] = {.lex_state = 41},
  [1155] = {.lex_state = 41},
  [1156] = {.lex_state = 41},
  [1157] = {.lex_state = 41},
  [1158] = {.lex_state = 41},
  [1159] = {.lex_state = 41},
  [1160] = {.lex_state = 41},
  [1161] = {.lex_state = 41},
  [1162] = {.lex_state = 41},
  [1163] = {.lex_state = 41},
  [1164] = {.lex_state = 41},
  [1165] = {.lex_state = 41},
  [1166] = {.lex_state = 41},
  [1167] = {.lex_state = 41},
  [1168] = {.lex_state = 41},
  [1169] = {.lex_state = 41},
  [1170] = {.lex_state = 41},
  [1171] = {.lex_state = 41},
  [1172] = {.lex_state = 41},
  [1173] = {.lex_state = 41},
  [1174] = {.lex_state = 41},
  [1175] = {.lex_state = 41},
  [1176] = {.lex_state = 41},
  [1177] = {.lex_state = 41},
  [1178] = {.lex_state = 41},
  [1179] = {.lex_state = 41},
  [1180] = {.lex_state = 41},
  [1181] = {.lex_state = 41},
  [1182] = {.lex_state = 41},
  [1183] = {.lex_state = 41},
  [1184] = {.lex_state = 41},
  [1185] = {.lex_state = 41},
  [1186] = {.lex_state = 41},
  [1187] = {.lex_state = 41},
  [1188] = {.lex_state = 41},
  [1189] = {.lex_state = 41},
  [1190] = {.lex_state = 41},
  [1191] = {.lex_state = 41},
  [1192] = {.lex_state = 41},
  [1193] = {.lex_state = 41},
  [1194] = {.lex_state = 41},
  [1195] = {.lex_state = 41},
  [1196] = {.lex_state = 41},
  [1197] = {.lex_state = 41},
  [1198] = {.lex_state = 41},
  [1199] = {.lex_state = 41},
  [1200] = {.lex_state = 41},
  [1201] = {.lex_state = 41},
  [1202] = {.lex_state = 41},
  [1203] = {.lex_state = 41},
  [1204] = {.lex_state = 41},
  [1205] = {.lex_state = 41},
  [1206] = {.lex_state = 41},
  [1207] = {.lex_state = 41},
  [1208] = {.lex_state = 41},
  [1209] = {.lex_state = 41},
  [1210] = {.lex_state = 41},
  [1211] = {.lex_state = 41},
  [1212] = {.lex_state = 41},
  [1213] = {.lex_state = 41},
  [1214] = {.lex_state = 41},
  [1215] = {.lex_state = 41},
  [1216] = {.lex_state = 41},
  [1217] = {.lex_state = 41},
  [1218] = {.lex_state = 41},
  [1219] = {.lex_state = 41},
  [1220] = {.lex_state = 41},
  [1221] = {.lex_state = 41},
  [1222] = {.lex_state = 41},
  [1223] = {.lex_state = 41},
  [1224] = {.lex_state = 41},
  [1225] = {.lex_state = 41},
  [1226] = {.lex_state = 41},
  [1227] = {.lex_state = 41},
  [1228] = {.lex_state = 41},
  [1229] = {.lex_state = 41},
  [1230] = {.lex_state = 41},
  [1231] = {.lex_state = 41},
  [1232] = {.lex_state = 41},
  [1233] = {.lex_state = 41},
  [1234] = {.lex_state = 41},
  [1235] = {.lex_state = 41},
  [1236] = {.lex_state = 41},
  [1237] = {.lex_state = 41},
  [1238] = {.lex_state = 41},
  [1239] = {.lex_state = 41},
  [1240] = {.lex_state = 41},
  [1241] = {.lex_state = 41},
  [1242] = {.lex_state = 41},
  [1243] = {.lex_state = 41},
  [1244] = {.lex_state = 41},
  [1245] = {.lex_state = 41},
  [1246] = {.lex_state = 41},
  [1247] = {.lex_state = 41},
  [1248] = {.lex_state = 41},
  [1249] = {.lex_state = 41},
  [1250] = {.lex_state = 41},
  [1251] = {.lex_state = 41},
  [1252] = {.lex_state = 41},
  [1253] = {.lex_state = 41},
  [1254] = {.lex_state = 41},
  [1255] = {.lex_state = 41},
  [1256] = {.lex_state = 41},
  [1257] = {.lex_state = 41},
  [1258] = {.lex_state = 41},
  [1259] = {.lex_state = 41},
  [1260] = {.lex_state = 41},
  [1261] = {.lex_state = 41},
  [1262] = {.lex_state = 41},
  [1263] = {.lex_state = 41},
  [1264] = {.lex_state = 41},
  [1265] = {.lex_state = 41},
  [1266] = {.lex_state = 41},
  [1267] = {.lex_state = 41},
  [1268] = {.lex_state = 41},
  [1269] = {.lex_state = 41},
  [1270] = {.lex_state = 41},
  [1271] = {.lex_state = 41},
  [1272] = {.lex_state = 41},
  [1273] = {.lex_state = 41},
  [1274] = {.lex_state = 41},
  [1275] = {.lex_state = 41},
  [1276] = {.lex_state = 41},
  [1277] = {.lex_state = 41},
  [1278] = {.lex_state = 41},
  [1279] = {.lex_state = 41},
  [1280] = {.lex_state = 41},
  [1281] = {.lex_state = 41},
  [1282] = {.lex_state = 41},
  [1283] = {.lex_state = 41},
  [1284] = {.lex_state = 41},
  [1285] = {.lex_state = 41},
  [1286] = {.lex_state = 41},
  [1287] = {.lex_state = 41},
  [1288] = {.lex_state = 41},
  [1289] = {.lex_state = 41},
  [1290] = {.lex_state = 41},
  [1291] = {.lex_state = 41},
  [1292] = {.lex_state = 41},
  [1293] = {.lex_state = 41},
  [1294] = {.lex_state = 41},
  [1295] = {.lex_state = 41},
  [1296] = {.lex_state = 41},
  [1297] = {.lex_state = 41},
  [1298] = {.lex_state = 41},
  [1299] = {.lex_state = 41},
  [1300] = {.lex_state = 41},
  [1301] = {.lex_state = 41},
  [1302] = {.lex_state = 41},
  [1303] = {.lex_state = 41},
  [1304] = {.lex_state = 41},
  [1305] = {.lex_state = 41},
  [1306] = {.lex_state = 41},
  [1307] = {.lex_state = 41},
  [1308] = {.lex_state = 41},
  [1309] = {.lex_state = 41},
  [1310] = {.lex_state = 41},
  [1311] = {.lex_state = 41},
  [1312] = {.lex_state = 41},
  [1313] = {.lex_state = 41},
  [1314] = {.lex_state = 41},
  [1315] = {.lex_state = 41},
  [1316] = {.lex_state = 41},
  [1317] = {.lex_state = 41},
  [1318] = {.lex_state = 41},
  [1319] = {.lex_state = 41},
  [1320] = {.lex_state = 41},
  [1321] = {.lex_state = 41},
  [1322] = {.lex_state = 41},
  [1323] = {.lex_state = 41},
  [1324] = {.lex_state = 41},
  [1325] = {.lex_state = 41},
  [1326] = {.lex_state = 41},
  [1327] = {.lex_state = 41},
  [1328] = {.lex_state = 41},
  [1329] = {.lex_state = 41},
  [1330] = {.lex_state = 41},
  [1331] = {.lex_state = 41},
  [1332] = {.lex_state = 41},
  [1333] = {.lex_state = 41},
  [1334] = {.lex_state = 41},
  [1335] = {.lex_state = 41},
  [1336] = {.lex_state = 41},
  [1337] = {.lex_state = 41},
  [1338] = {.lex_state = 41},
  [1339] = {.lex_state = 41},
  [1340] = {.lex_state = 41},
  [1341] = {.lex_state = 41},
  [1342] = {.lex_state = 41},
  [1343] = {.lex_state = 41},
  [1344] = {.lex_state = 41},
  [1345] = {.lex_state = 41},
  [1346] = {.lex_state = 41},
  [1347] = {.lex_state = 41},
  [1348] = {.lex_state = 41},
  [1349] = {.lex_state = 41},
  [1350] = {.lex_state = 41},
  [1351] = {.lex_state = 41},
  [1352] = {.lex_state = 41},
  [1353] = {.lex_state = 41},
  [1354] = {.lex_state = 41},
  [1355] = {.lex_state = 41},
  [1356] = {.lex_state = 41},
  [1357] = {.lex_state = 41},
  [1358] = {.lex_state = 41},
  [1359] = {.lex_state = 41},
  [1360] = {.lex_state = 41},
  [1361] = {.lex_state = 41},
  [1362] = {.lex_state = 41},
  [1363] = {.lex_state = 41},
  [1364] = {.lex_state = 41},
  [1365] = {.lex_state = 41},
  [1366] = {.lex_state = 41},
  [1367] = {.lex_state = 41},
  [1368] = {.lex_state = 41},
  [1369] = {.lex_state = 41},
  [1370] = {.lex_state = 41},
  [1371] = {.lex_state = 41},
  [1372] = {.lex_state = 41},
  [1373] = {.lex_state = 41},
  [1374] = {.lex_state = 41},
  [1375] = {.lex_state = 41},
  [1376] = {.lex_state = 41},
  [1377] = {.lex_state = 41},
  [1378] = {.lex_state = 41},
  [1379] = {.lex_state = 41},
  [1380] = {.lex_state = 41},
  [1381] = {.lex_state = 41},
  [1382] = {.lex_state = 41},
  [1383] = {.lex_state = 41},
  [1384] = {.lex_state = 41},
  [1385] = {.lex_state = 41},
  [1386] = {.lex_state = 41},
  [1387] = {.lex_state = 41},
  [1388] = {.lex_state = 41},
  [1389] = {.lex_state = 41},
  [1390] = {.lex_state = 41},
  [1391] = {.lex_state = 41},
  [1392] = {.lex_state = 41},
  [1393] = {.lex_state = 41},
  [1394] = {.lex_state = 41},
  [1395] = {.lex_state = 41},
  [1396] = {.lex_state = 41},
  [1397] = {.lex_state = 41},
  [1398] = {.lex_state = 41},
  [1399] = {.lex_state = 41},
  [1400] = {.lex_state = 41},
  [1401] = {.lex_state = 41},
  [1402] = {.lex_state = 41},
  [1403] = {.lex_state = 41},
  [1404] = {.lex_state = 41},
  [1405] = {.lex_state = 41},
  [1406] = {.lex_state = 41},
  [1407] = {.lex_state = 41},
  [1408] = {.lex_state = 41},
  [1409] = {.lex_state = 41},
  [1410] = {.lex_state = 41},
  [1411] = {.lex_state = 41},
  [1412] = {.lex_state = 41},
  [1413] = {.lex_state = 41},
  [1414] = {.lex_state = 41},
  [1415] = {.lex_state = 41},
  [1416] = {.lex_state = 41},
  [1417] = {.lex_state = 41},
  [1418] = {.lex_state = 41},
  [1419] = {.lex_state = 41},
  [1420] = {.lex_state = 41},
  [1421] = {.lex_state = 41},
  [1422] = {.lex_state = 41},
  [1423] = {.lex_state = 41},
  [1424] = {.lex_state = 41},
  [1425] = {.lex_state = 41},
  [1426] = {.lex_state = 41},
  [1427] = {.lex_state = 41},
  [1428] = {.lex_state = 41},
  [1429] = {.lex_state = 41},
  [1430] = {.lex_state = 41},
  [1431] = {.lex_state = 41},
  [1432] = {.lex_state = 41},
  [1433] = {.lex_state = 41},
  [1434] = {.lex_state = 41},
  [1435] = {.lex_state = 41},
  [1436] = {.lex_state = 41},
  [1437] = {.lex_state = 41},
  [1438] = {.lex_state = 41},
  [1439] = {.lex_state = 41},
  [1440] = {.lex_state = 41},
  [1441] = {.lex_state = 41},
  [1442] = {.lex_state = 41},
  [1443] = {.lex_state = 41},
  [1444] = {.lex_state = 41},
  [1445] = {.lex_state = 41},
  [1446] = {.lex_state = 41},
  [1447] = {.lex_state = 41},
  [1448] = {.lex_state = 41},
  [1449] = {.lex_state = 41},
  [1450] = {.lex_state = 41},
  [1451] = {.lex_state = 41},
  [1452] = {.lex_state = 41},
  [1453] = {.lex_state = 41},
  [1454] = {.lex_state = 41},
  [1455] = {.lex_state = 41},
  [1456] = {.lex_state = 41},
  [1457] = {.lex_state = 41},
  [1458] = {.lex_state = 41},
  [1459] = {.lex_state = 41},
  [1460] = {.lex_state = 41},
  [1461] = {.lex_state = 41},
  [1462] = {.lex_state = 41},
  [1463] = {.lex_state = 41},
  [1464] = {.lex_state = 41},
  [1465] = {.lex_state = 41},
  [1466] = {.lex_state = 41},
  [1467] = {.lex_state = 41},
  [1468] = {.lex_state = 41},
  [1469] = {.lex_state = 41},
  [1470] = {.lex_state = 41},
  [1471] = {.lex_state = 41},
  [1472] = {.lex_state = 41},
  [1473] = {.lex_state = 41},
  [1474] = {.lex_state = 41},
  [1475] = {.lex_state = 41},
  [1476] = {.lex_state = 41},
  [1477] = {.lex_state = 41},
  [1478] = {.lex_state = 41},
  [1479] = {.lex_state = 41},
  [1480] = {.lex_state = 41},
  [1481] = {.lex_state = 41},
  [1482] = {.lex_state = 41},
  [1483] = {.lex_state = 41},
  [1484] = {.lex_state = 41},
  [1485] = {.lex_state = 41},
  [1486] = {.lex_state = 41},
  [1487] = {.lex_state = 41},
  [1488] = {.lex_state = 41},
  [1489] = {.lex_state = 41},
  [1490] = {.lex_state = 41},
  [1491] = {.lex_state = 41},
  [1492] = {.lex_state = 41},
  [1493] = {.lex_state = 41},
  [1494] = {.lex_state = 41},
  [1495] = {.lex_state = 41},
  [1496] = {.lex_state = 41},
  [1497] = {.lex_state = 41},
  [1498] = {.lex_state = 41},
  [1499] = {.lex_state = 41},
  [1500] = {.lex_state = 41},
  [1501] = {.lex_state = 41},
  [1502] = {.lex_state = 41},
  [1503] = {.lex_state = 41},
  [1504] = {.lex_state = 41},
  [1505] = {.lex_state = 41},
  [1506] = {.lex_state = 41},
  [1507] = {.lex_state = 41},
  [1508] = {.lex_state = 41},
  [1509] = {.lex_state = 41},
  [1510] = {.lex_state = 41},
  [1511] = {.lex_state = 41},
  [1512] = {.lex_state = 41},
  [1513] = {.lex_state = 41},
  [1514] = {.lex_state = 41},
  [1515] = {.lex_state = 41},
  [1516] = {.lex_state = 41},
  [1517] = {.lex_state = 41},
  [1518] = {.lex_state = 41},
  [1519] = {.lex_state = 41},
  [1520] = {.lex_state = 41},
  [1521] = {.lex_state = 41},
  [1522] = {.lex_state = 41},
  [1523] = {.lex_state = 41},
  [1524] = {.lex_state = 41},
  [1525] = {.lex_state = 41},
  [1526] = {.lex_state = 41},
  [1527] = {.lex_state = 41},
  [1528] = {.lex_state = 41},
  [1529] = {.lex_state = 41},
  [1530] = {.lex_state = 41},
  [1531] = {.lex_state = 41},
  [1532] = {.lex_state = 41},
  [1533] = {.lex_state = 41},
  [1534] = {.lex_state = 41},
  [1535] = {.lex_state = 41},
  [1536] = {.lex_state = 41},
  [1537] = {.lex_state = 41},
  [1538] = {.lex_state = 41},
  [1539] = {.lex_state = 41},
  [1540] = {.lex_state = 41},
  [1541] = {.lex_state = 41},
  [1542] = {.lex_state = 41},
  [1543] = {.lex_state = 41},
  [1544] = {.lex_state = 41},
  [1545] = {.lex_state = 41},
  [1546] = {.lex_state = 41},
  [1547] = {.lex_state = 41},
  [1548] = {.lex_state = 41},
  [1549] = {.lex_state = 41},
  [1550] = {.lex_state = 41},
  [1551] = {.lex_state = 41},
  [1552] = {.lex_state = 41},
  [1553] = {.lex_state = 41},
  [1554] = {.lex_state = 41},
  [1555] = {.lex_state = 41},
  [1556] = {.lex_state = 41},
  [1557] = {.lex_state = 41},
  [1558] = {.lex_state = 41},
  [1559] = {.lex_state = 41},
  [1560] = {.lex_state = 41},
  [1561] = {.lex_state = 41},
  [1562] = {.lex_state = 41},
  [1563] = {.lex_state = 41},
  [1564] = {.lex_state = 41},
  [1565] = {.lex_state = 41},
  [1566] = {.lex_state = 41},
  [1567] = {.lex_state = 41},
  [1568] = {.lex_state = 41},
  [1569] = {.lex_state = 41},
  [1570] = {.lex_state = 41},
  [1571] = {.lex_state = 41},
  [1572] = {.lex_state = 41},
  [1573] = {.lex_state = 41},
  [1574] = {.lex_state = 41},
  [1575] = {.lex_state = 41},
  [1576] = {.lex_state = 41},
  [1577] = {.lex_state = 41},
  [1578] = {.lex_state = 41},
  [1579] = {.lex_state = 41},
  [1580] = {.lex_state = 41},
  [1581] = {.lex_state = 41},
  [1582] = {.lex_state = 41},
  [1583] = {.lex_state = 41},
  [1584] = {.lex_state = 41},
  [1585] = {.lex_state = 41},
  [1586] = {.lex_state = 41},
  [1587] = {.lex_state = 41},
  [1588] = {.lex_state = 41},
  [1589] = {.lex_state = 41},
  [1590] = {.lex_state = 41},
  [1591] = {.lex_state = 41},
  [1592] = {.lex_state = 41},
  [1593] = {.lex_state = 41},
  [1594] = {.lex_state = 41},
  [1595] = {.lex_state = 41},
  [1596] = {.lex_state = 41},
  [1597] = {.lex_state = 41},
  [1598] = {.lex_state = 41},
  [1599] = {.lex_state = 41},
  [1600] = {.lex_state = 41},
  [1601] = {.lex_state = 41},
  [1602] = {.lex_state = 41},
  [1603] = {.lex_state = 41},
  [1604] = {.lex_state = 41},
  [1605] = {.lex_state = 41},
  [1606] = {.lex_state = 41},
  [1607] = {.lex_state = 41},
  [1608] = {.lex_state = 41},
  [1609] = {.lex_state = 41},
  [1610] = {.lex_state = 41},
  [1611] = {.lex_state = 41},
  [1612] = {.lex_state = 41},
  [1613] = {.lex_state = 41},
  [1614] = {.lex_state = 41},
  [1615] = {.lex_state = 41},
  [1616] = {.lex_state = 41},
  [1617] = {.lex_state = 41},
  [1618] = {.lex_state = 41},
  [1619] = {.lex_state = 41},
  [1620] = {.lex_state = 41},
  [1621] = {.lex_state = 41},
  [1622] = {.lex_state = 41},
  [1623] = {.lex_state = 41},
  [1624] = {.lex_state = 41},
  [1625] = {.lex_state = 41},
  [1626] = {.lex_state = 41},
  [1627] = {.lex_state = 41},
  [1628] = {.lex_state = 41},
  [1629] = {.lex_state = 41},
  [1630] = {.lex_state = 41},
  [1631] = {.lex_state = 41},
  [1632] = {.lex_state = 41},
  [1633] = {.lex_state = 41},
  [1634] = {.lex_state = 41},
  [1635] = {.lex_state = 41},
  [1636] = {.lex_state = 41},
  [1637] = {.lex_state = 41},
  [1638] = {.lex_state = 41},
  [1639] = {.lex_state = 41},
  [1640] = {.lex_state = 41},
  [1641] = {.lex_state = 41},
  [1642] = {.lex_state = 41},
  [1643] = {.lex_state = 41},
  [1644] = {.lex_state = 41},
  [1645] = {.lex_state = 41},
  [1646] = {.lex_state = 41},
  [1647] = {.lex_state = 41},
  [1648] = {.lex_state = 41},
  [1649] = {.lex_state = 41},
  [1650] = {.lex_state = 41},
  [1651] = {.lex_state = 41},
  [1652] = {.lex_state = 41},
  [1653] = {.lex_state = 41},
  [1654] = {.lex_state = 41},
  [1655] = {.lex_state = 41},
  [1656] = {.lex_state = 41},
  [1657] = {.lex_state = 41},
  [1658] = {.lex_state = 41},
  [1659] = {.lex_state = 41},
  [1660] = {.lex_state = 41},
  [1661] = {.lex_state = 41},
  [1662] = {.lex_state = 41},
  [1663] = {.lex_state = 41},
  [1664] = {.lex_state = 41},
  [1665] = {.lex_state = 41},
  [1666] = {.lex_state = 41},
  [1667] = {.lex_state = 41},
  [1668] = {.lex_state = 41},
  [1669] = {.lex_state = 41},
  [1670] = {.lex_state = 41},
  [1671] = {.lex_state = 41},
  [1672] = {.lex_state = 41},
  [1673] = {.lex_state = 41},
  [1674] = {.lex_state = 41},
  [1675] = {.lex_state = 41},
  [1676] = {.lex_state = 41},
  [1677] = {.lex_state = 41},
  [1678] = {.lex_state = 41},
  [1679] = {.lex_state = 41},
  [1680] = {.lex_state = 41},
  [1681] = {.lex_state = 41},
  [1682] = {.lex_state = 41},
  [1683] = {.lex_state = 41},
  [1684] = {.lex_state = 41},
  [1685] = {.lex_state = 41},
  [1686] = {.lex_state = 41},
  [1687] = {.lex_state = 41},
  [1688] = {.lex_state = 41},
  [1689] = {.lex_state = 41},
  [1690] = {.lex_state = 41},
  [1691] = {.lex_state = 41},
  [1692] = {.lex_state = 41},
  [1693] = {.lex_state = 41},
  [1694] = {.lex_state = 41},
  [1695] = {.lex_state = 41},
  [1696] = {.lex_state = 41},
  [1697] = {.lex_state = 41},
  [1698] = {.lex_state = 41},
  [1699] = {.lex_state = 41},
  [1700] = {.lex_state = 41},
  [1701] = {.lex_state = 41},
  [1702] = {.lex_state = 41},
  [1703] = {.lex_state = 41},
  [1704] = {.lex_state = 41},
  [1705] = {.lex_state = 41},
  [1706] = {.lex_state = 41},
  [1707] = {.lex_state = 41},
  [1708] = {.lex_state = 41},
  [1709] = {.lex_state = 41},
  [1710] = {.lex_state = 41},
  [1711] = {.lex_state = 41},
  [1712] = {.lex_state = 41},
  [1713] = {.lex_state = 41},
  [1714] = {.lex_state = 41},
  [1715] = {.lex_state = 41},
  [1716] = {.lex_state = 41},
  [1717] = {.lex_state = 41},
  [1718] = {.lex_state = 41},
  [1719] = {.lex_state = 41},
  [1720] = {.lex_state = 41},
  [1721] = {.lex_state = 41},
  [1722] = {.lex_state = 41},
  [1723] = {.lex_state = 41},
  [1724] = {.lex_state = 41},
  [1725] = {.lex_state = 41},
  [1726] = {.lex_state = 41},
  [1727] = {.lex_state = 41},
  [1728] = {.lex_state = 41},
  [1729] = {.lex_state = 41},
  [1730] = {.lex_state = 41},
  [1731] = {.lex_state = 41},
  [1732] = {.lex_state = 41},
  [1733] = {.lex_state = 41},
  [1734] = {.lex_state = 41},
  [1735] = {.lex_state = 41},
  [1736] = {.lex_state = 41},
  [1737] = {.lex_state = 41},
  [1738] = {.lex_state = 41},
  [1739] = {.lex_state = 41},
  [1740] = {.lex_state = 41},
  [1741] = {.lex_state = 41},
  [1742] = {.lex_state = 41},
  [1743] = {.lex_state = 41},
  [1744] = {.lex_state = 41},
  [1745] = {.lex_state = 41},
  [1746] = {.lex_state = 41},
  [1747] = {.lex_state = 41},
  [1748] = {.lex_state = 41},
  [1749] = {.lex_state = 41},
  [1750] = {.lex_state = 41},
  [1751] = {.lex_state = 41},
  [1752] = {.lex_state = 41},
  [1753] = {.lex_state = 15},
  [1754] = {.lex_state = 41},
  [1755] = {.lex_state = 5},
  [1756] = {.lex_state = 5},
  [1757] = {.lex_state = 5},
  [1758] = {.lex_state = 5},
  [1759] = {.lex_state = 41},
  [1760] = {.lex_state = 5},
  [1761] = {.lex_state = 5},
  [1762] = {.lex_state = 41},
  [1763] = {.lex_state = 15},
  [1764] = {.lex_state = 15},
  [1765] = {.lex_state = 15},
  [1766] = {.lex_state = 15},
  [1767] = {.lex_state = 15},
  [1768] = {.lex_state = 15},
  [1769] = {.lex_state = 15},
  [1770] = {.lex_state = 15},
  [1771] = {.lex_state = 15},
  [1772] = {.lex_state = 15},
  [1773] = {.lex_state = 15},
  [1774] = {.lex_state = 15},
  [1775] = {.lex_state = 41},
  [1776] = {.lex_state = 41},
  [1777] = {.lex_state = 15},
  [1778] = {.lex_state = 41},
  [1779] = {.lex_state = 41},
  [1780] = {.lex_state = 41},
  [1781] = {.lex_state = 15},
  [1782] = {.lex_state = 41},
  [1783] = {.lex_state = 41},
  [1784] = {.lex_state = 15},
  [1785] = {.lex_state = 41},
  [1786] = {.lex_state = 15},
  [1787] = {.lex_state = 41},
  [1788] = {.lex_state = 15},
  [1789] = {.lex_state = 41},
  [1790] = {.lex_state = 41},
  [1791] = {.lex_state = 15},
  [1792] = {.lex_state = 15},
  [1793] = {.lex_state = 15},
  [1794] = {.lex_state = 41},
  [1795] = {.lex_state = 41},
  [1796] = {.lex_state = 15},
  [1797] = {.lex_state = 15},
  [1798] = {.lex_state = 15},
  [1799] = {.lex_state = 41},
  [1800] = {.lex_state = 41},
  [1801] = {.lex_state = 41},
  [1802] = {.lex_state = 4},
  [1803] = {.lex_state = 41},
  [1804] = {.lex_state = 41},
  [1805] = {.lex_state = 41},
  [1806] = {.lex_state = 41},
  [1807] = {.lex_state = 41},
  [1808] = {.lex_state = 41},
  [1809] = {.lex_state = 15},
  [1810] = {.lex_state = 4},
  [1811] = {.lex_state = 41},
  [1812] = {.lex_state = 41},
  [1813] = {.lex_state = 41},
  [1814] = {.lex_state = 4},
  [1815] = {.lex_state = 15},
  [1816] = {.lex_state = 41},
  [1817] = {.lex_state = 41},
  [1818] = {.lex_state = 15},
  [1819] = {.lex_state = 41},
  [1820] = {.lex_state = 41},
  [1821] = {.lex_state = 41},
  [1822] = {.lex_state = 41},
  [1823] = {.lex_state = 41},
  [1824] = {.lex_state = 4},
  [1825] = {.lex_state = 41},
  [1826] = {.lex_state = 4},
  [1827] = {.lex_state = 41},
  [1828] = {.lex_state = 15},
  [1829] = {.lex_state = 15},
  [1830] = {.lex_state = 15},
  [1831] = {.lex_state = 4},
  [1832] = {.lex_state = 41},
  [1833] = {.lex_state = 41},
  [1834] = {.lex_state = 15},
  [1835] = {.lex_state = 41},
  [1836] = {.lex_state = 41},
  [1837] = {.lex_state = 41},
  [1838] = {.lex_state = 41},
  [1839] = {.lex_state = 41},
  [1840] = {.lex_state = 15},
  [1841] = {.lex_state = 41},
  [1842] = {.lex_state = 41},
  [1843] = {.lex_state = 41},
  [1844] = {.lex_state = 41},
  [1845] = {.lex_state = 41},
  [1846] = {.lex_state = 41},
  [1847] = {.lex_state = 41},
  [1848] = {.lex_state = 41},
  [1849] = {.lex_state = 41},
  [1850] = {.lex_state = 41},
  [1851] = {.lex_state = 41},
  [1852] = {.lex_state = 41},
  [1853] = {.lex_state = 41},
  [1854] = {.lex_state = 41},
  [1855] = {.lex_state = 41},
  [1856] = {.lex_state = 41},
  [1857] = {.lex_state = 41},
  [1858] = {.lex_state = 41},
  [1859] = {.lex_state = 41},
  [1860] = {.lex_state = 41},
  [1861] = {.lex_state = 41},
  [1862] = {.lex_state = 41},
  [1863] = {.lex_state = 41},
  [1864] = {.lex_state = 41},
  [1865] = {.lex_state = 41},
  [1866] = {.lex_state = 41},
  [1867] = {.lex_state = 41},
  [1868] = {.lex_state = 41},
  [1869] = {.lex_state = 41},
  [1870] = {.lex_state = 41},
  [1871] = {.lex_state = 41},
  [1872] = {.lex_state = 14, .external_lex_state = 1},
  [1873] = {.lex_state = 15},
  [1874] = {.lex_state = 14, .external_lex_state = 1},
  [1875] = {.lex_state = 15},
  [1876] = {.lex_state = 15},
  [1877] = {.lex_state = 15},
  [1878] = {.lex_state = 14, .external_lex_state = 1},
  [1879] = {.lex_state = 15},
  [1880] = {.lex_state = 15},
  [1881] = {.lex_state = 41},
  [1882] = {.lex_state = 15},
  [1883] = {.lex_state = 15},
  [1884] = {.lex_state = 15},
  [1885] = {.lex_state = 15},
  [1886] = {.lex_state = 15},
  [1887] = {.lex_state = 15},
  [1888] = {.lex_state = 15},
  [1889] = {.lex_state = 41},
  [1890] = {.lex_state = 15},
  [1891] = {.lex_state = 15},
  [1892] = {.lex_state = 4},
  [1893] = {.lex_state = 4},
  [1894] = {.lex_state = 4},
  [1895] = {.lex_state = 4},
  [1896] = {.lex_state = 4},
  [1897] = {.lex_state = 4},
  [1898] = {.lex_state = 41},
  [1899] = {.lex_state = 15},
  [1900] = {.lex_state = 15},
  [1901] = {.lex_state = 41},
  [1902] = {.lex_state = 41},
  [1903] = {.lex_state = 41},
  [1904] = {.lex_state = 15},
  [1905] = {.lex_state = 14, .external_lex_state = 1},
  [1906] = {.lex_state = 15},
  [1907] = {.lex_state = 14, .external_lex_state = 1},
  [1908] = {.lex_state = 15},
  [1909] = {.lex_state = 14, .external_lex_state = 1},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 15},
  [1912] = {.lex_state = 15},
  [1913] = {.lex_state = 0},
  [1914] = {.lex_state = 14, .external_lex_state = 1},
  [1915] = {.lex_state = 0},
  [1916] = {.lex_state = 0},
  [1917] = {.lex_state = 41},
  [1918] = {.lex_state = 41},
  [1919] = {.lex_state = 41},
  [1920] = {.lex_state = 41},
  [1921] = {.lex_state = 41},
  [1922] = {.lex_state = 15},
  [1923] = {.lex_state = 41},
  [1924] = {.lex_state = 15},
  [1925] = {.lex_state = 15},
  [1926] = {.lex_state = 1},
  [1927] = {.lex_state = 41},
  [1928] = {.lex_state = 41},
  [1929] = {.lex_state = 41},
  [1930] = {.lex_state = 1},
  [1931] = {.lex_state = 41},
  [1932] = {.lex_state = 41},
  [1933] = {.lex_state = 41},
  [1934] = {.lex_state = 41},
  [1935] = {.lex_state = 41},
  [1936] = {.lex_state = 41},
  [1937] = {.lex_state = 41},
  [1938] = {.lex_state = 41},
  [1939] = {.lex_state = 41},
  [1940] = {.lex_state = 41},
  [1941] = {.lex_state = 41},
  [1942] = {.lex_state = 41},
  [1943] = {.lex_state = 41},
  [1944] = {.lex_state = 41},
  [1945] = {.lex_state = 41},
  [1946] = {.lex_state = 41},
  [1947] = {.lex_state = 41},
  [1948] = {.lex_state = 41},
  [1949] = {.lex_state = 41},
  [1950] = {.lex_state = 41},
  [1951] = {.lex_state = 41},
  [1952] = {.lex_state = 41},
  [1953] = {.lex_state = 41},
  [1954] = {.lex_state = 41},
  [1955] = {.lex_state = 41},
  [1956] = {.lex_state = 41},
  [1957] = {.lex_state = 41},
  [1958] = {.lex_state = 15},
  [1959] = {.lex_state = 41},
  [1960] = {.lex_state = 41},
  [1961] = {.lex_state = 41},
  [1962] = {.lex_state = 41},
  [1963] = {.lex_state = 41},
  [1964] = {.lex_state = 1},
  [1965] = {.lex_state = 41},
  [1966] = {.lex_state = 41},
  [1967] = {.lex_state = 41},
  [1968] = {.lex_state = 41},
  [1969] = {.lex_state = 41},
  [1970] = {.lex_state = 41},
  [1971] = {.lex_state = 41},
  [1972] = {.lex_state = 41},
  [1973] = {.lex_state = 41},
  [1974] = {.lex_state = 41},
  [1975] = {.lex_state = 1},
  [1976] = {.lex_state = 41},
  [1977] = {.lex_state = 41},
  [1978] = {.lex_state = 41},
  [1979] = {.lex_state = 1},
  [1980] = {.lex_state = 41},
  [1981] = {.lex_state = 41},
  [1982] = {.lex_state = 15},
  [1983] = {.lex_state = 41},
  [1984] = {.lex_state = 41},
  [1985] = {.lex_state = 41},
  [1986] = {.lex_state = 41},
  [1987] = {.lex_state = 41},
  [1988] = {.lex_state = 41},
  [1989] = {.lex_state = 41},
  [1990] = {.lex_state = 41},
  [1991] = {.lex_state = 41},
  [1992] = {.lex_state = 41},
  [1993] = {.lex_state = 41},
  [1994] = {.lex_state = 15},
  [1995] = {.lex_state = 41},
  [1996] = {.lex_state = 41},
  [1997] = {.lex_state = 41},
  [1998] = {.lex_state = 1},
  [1999] = {.lex_state = 41},
  [2000] = {.lex_state = 41},
  [2001] = {.lex_state = 41},
  [2002] = {.lex_state = 41},
  [2003] = {.lex_state = 41},
  [2004] = {.lex_state = 41},
  [2005] = {.lex_state = 41},
  [2006] = {.lex_state = 41},
  [2007] = {.lex_state = 41},
  [2008] = {.lex_state = 15},
  [2009] = {.lex_state = 15},
  [2010] = {.lex_state = 15},
  [2011] = {.lex_state = 41},
  [2012] = {.lex_state = 41},
  [2013] = {.lex_state = 41},
  [2014] = {.lex_state = 15},
  [2015] = {.lex_state = 41},
  [2016] = {.lex_state = 15},
  [2017] = {.lex_state = 41},
  [2018] = {.lex_state = 41},
  [2019] = {.lex_state = 41},
  [2020] = {.lex_state = 41},
  [2021] = {.lex_state = 41},
  [2022] = {.lex_state = 41},
  [2023] = {.lex_state = 41},
  [2024] = {.lex_state = 41},
  [2025] = {.lex_state = 1},
  [2026] = {.lex_state = 41},
  [2027] = {.lex_state = 41},
  [2028] = {.lex_state = 41},
  [2029] = {.lex_state = 41},
  [2030] = {.lex_state = 7},
  [2031] = {.lex_state = 15},
  [2032] = {.lex_state = 41},
  [2033] = {.lex_state = 41},
  [2034] = {.lex_state = 41},
  [2035] = {.lex_state = 41},
  [2036] = {.lex_state = 41},
  [2037] = {.lex_state = 41},
  [2038] = {.lex_state = 41},
  [2039] = {.lex_state = 41},
  [2040] = {.lex_state = 7},
  [2041] = {.lex_state = 15},
  [2042] = {.lex_state = 7},
  [2043] = {.lex_state = 41},
  [2044] = {.lex_state = 15},
  [2045] = {.lex_state = 41},
  [2046] = {.lex_state = 41},
  [2047] = {.lex_state = 41},
  [2048] = {.lex_state = 41},
  [2049] = {.lex_state = 41},
  [2050] = {.lex_state = 41},
  [2051] = {.lex_state = 7},
  [2052] = {.lex_state = 7},
  [2053] = {.lex_state = 41},
  [2054] = {.lex_state = 15},
  [2055] = {.lex_state = 41},
  [2056] = {.lex_state = 41},
  [2057] = {.lex_state = 15},
  [2058] = {.lex_state = 41},
  [2059] = {.lex_state = 7},
  [2060] = {.lex_state = 15},
  [2061] = {.lex_state = 41},
  [2062] = {.lex_state = 7},
  [2063] = {.lex_state = 15},
  [2064] = {.lex_state = 41},
  [2065] = {.lex_state = 15},
  [2066] = {.lex_state = 15},
  [2067] = {.lex_state = 41},
  [2068] = {.lex_state = 0},
  [2069] = {.lex_state = 41},
  [2070] = {.lex_state = 15},
  [2071] = {.lex_state = 41},
  [2072] = {.lex_state = 4},
  [2073] = {.lex_state = 41},
  [2074] = {.lex_state = 6},
  [2075] = {.lex_state = 41},
  [2076] = {.lex_state = 4},
  [2077] = {.lex_state = 6},
  [2078] = {.lex_state = 15},
  [2079] = {.lex_state = 41},
  [2080] = {.lex_state = 41},
  [2081] = {.lex_state = 41},
  [2082] = {.lex_state = 41},
  [2083] = {.lex_state = 41},
  [2084] = {.lex_state = 4},
  [2085] = {.lex_state = 41},
  [2086] = {.lex_state = 41},
  [2087] = {.lex_state = 4},
  [2088] = {.lex_state = 41},
  [2089] = {.lex_state = 41},
  [2090] = {.lex_state = 6},
  [2091] = {.lex_state = 41},
  [2092] = {.lex_state = 41},
  [2093] = {.lex_state = 4},
  [2094] = {.lex_state = 41},
  [2095] = {.lex_state = 41},
  [2096] = {.lex_state = 15},
  [2097] = {.lex_state = 41},
  [2098] = {.lex_state = 41},
  [2099] = {.lex_state = 41},
  [2100] = {.lex_state = 41},
  [2101] = {.lex_state = 41},
  [2102] = {.lex_state = 15},
  [2103] = {.lex_state = 41},
  [2104] = {.lex_state = 41},
  [2105] = {.lex_state = 6},
  [2106] = {.lex_state = 41},
  [2107] = {.lex_state = 15},
  [2108] = {.lex_state = 41},
  [2109] = {.lex_state = 41},
  [2110] = {.lex_state = 41},
  [2111] = {.lex_state = 41},
  [2112] = {.lex_state = 41},
  [2113] = {.lex_state = 4},
  [2114] = {.lex_state = 41},
  [2115] = {.lex_state = 41},
  [2116] = {.lex_state = 41},
  [2117] = {.lex_state = 41},
  [2118] = {.lex_state = 6},
  [2119] = {.lex_state = 41},
  [2120] = {.lex_state = 41},
  [2121] = {.lex_state = 41},
  [2122] = {.lex_state = 41},
  [2123] = {.lex_state = 41},
  [2124] = {.lex_state = 41},
  [2125] = {.lex_state = 41},
  [2126] = {.lex_state = 6},
  [2127] = {.lex_state = 15},
  [2128] = {.lex_state = 41},
  [2129] = {.lex_state = 6},
  [2130] = {.lex_state = 41},
  [2131] = {.lex_state = 41},
  [2132] = {.lex_state = 41},
  [2133] = {.lex_state = 6},
  [2134] = {.lex_state = 41},
  [2135] = {.lex_state = 41},
  [2136] = {.lex_state = 41},
  [2137] = {.lex_state = 41},
  [2138] = {.lex_state = 41},
  [2139] = {.lex_state = 41},
  [2140] = {.lex_state = 41},
  [2141] = {.lex_state = 41},
  [2142] = {.lex_state = 15},
  [2143] = {.lex_state = 41},
  [2144] = {.lex_state = 41},
  [2145] = {.lex_state = 41},
  [2146] = {.lex_state = 41},
  [2147] = {.lex_state = 15},
  [2148] = {.lex_state = 15},
  [2149] = {.lex_state = 41},
  [2150] = {.lex_state = 41},
  [2151] = {.lex_state = 41},
  [2152] = {.lex_state = 15},
  [2153] = {.lex_state = 41},
  [2154] = {.lex_state = 41},
  [2155] = {.lex_state = 41},
  [2156] = {.lex_state = 41},
  [2157] = {.lex_state = 41},
  [2158] = {.lex_state = 6},
  [2159] = {.lex_state = 41},
  [2160] = {.lex_state = 4},
  [2161] = {.lex_state = 41},
  [2162] = {.lex_state = 6},
  [2163] = {.lex_state = 41},
  [2164] = {.lex_state = 41},
  [2165] = {.lex_state = 41},
  [2166] = {.lex_state = 41},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 41},
  [2169] = {.lex_state = 41},
  [2170] = {.lex_state = 15},
  [2171] = {.lex_state = 41},
  [2172] = {.lex_state = 41},
  [2173] = {.lex_state = 41},
  [2174] = {.lex_state = 15},
  [2175] = {.lex_state = 41},
  [2176] = {.lex_state = 1},
  [2177] = {.lex_state = 41},
  [2178] = {.lex_state = 41},
  [2179] = {.lex_state = 41},
  [2180] = {.lex_state = 1},
  [2181] = {.lex_state = 6},
  [2182] = {.lex_state = 6},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 41},
  [2185] = {.lex_state = 41},
  [2186] = {.lex_state = 41},
  [2187] = {.lex_state = 6},
  [2188] = {.lex_state = 41},
  [2189] = {.lex_state = 41},
  [2190] = {.lex_state = 1},
  [2191] = {.lex_state = 1},
  [2192] = {.lex_state = 41},
  [2193] = {.lex_state = 41},
  [2194] = {.lex_state = 6},
  [2195] = {.lex_state = 41},
  [2196] = {.lex_state = 41},
  [2197] = {.lex_state = 41},
  [2198] = {.lex_state = 41},
  [2199] = {.lex_state = 41},
  [2200] = {.lex_state = 41},
  [2201] = {.lex_state = 41},
  [2202] = {.lex_state = 41},
  [2203] = {.lex_state = 41},
  [2204] = {.lex_state = 41},
  [2205] = {.lex_state = 15},
  [2206] = {.lex_state = 41},
  [2207] = {.lex_state = 15},
  [2208] = {.lex_state = 41},
  [2209] = {.lex_state = 41},
  [2210] = {.lex_state = 41},
  [2211] = {.lex_state = 41},
  [2212] = {.lex_state = 41},
  [2213] = {.lex_state = 41},
  [2214] = {.lex_state = 41},
  [2215] = {.lex_state = 41},
  [2216] = {.lex_state = 41},
  [2217] = {.lex_state = 41},
  [2218] = {.lex_state = 41},
  [2219] = {.lex_state = 41},
  [2220] = {.lex_state = 41},
  [2221] = {.lex_state = 41},
  [2222] = {.lex_state = 41},
  [2223] = {.lex_state = 41},
  [2224] = {.lex_state = 41},
  [2225] = {.lex_state = 41},
  [2226] = {.lex_state = 41},
  [2227] = {.lex_state = 41},
  [2228] = {.lex_state = 41},
  [2229] = {.lex_state = 41},
  [2230] = {.lex_state = 41},
  [2231] = {.lex_state = 15},
  [2232] = {.lex_state = 41},
  [2233] = {.lex_state = 41},
  [2234] = {.lex_state = 41},
  [2235] = {.lex_state = 41},
  [2236] = {.lex_state = 41},
  [2237] = {.lex_state = 41},
  [2238] = {.lex_state = 41},
  [2239] = {.lex_state = 41},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 41},
  [2242] = {.lex_state = 41},
  [2243] = {.lex_state = 15},
  [2244] = {.lex_state = 41},
  [2245] = {.lex_state = 41},
  [2246] = {.lex_state = 41},
  [2247] = {.lex_state = 6},
  [2248] = {.lex_state = 41},
  [2249] = {.lex_state = 15},
  [2250] = {.lex_state = 41},
  [2251] = {.lex_state = 41},
  [2252] = {.lex_state = 41},
  [2253] = {.lex_state = 15},
  [2254] = {.lex_state = 41},
  [2255] = {.lex_state = 6},
  [2256] = {.lex_state = 1},
  [2257] = {.lex_state = 1},
  [2258] = {.lex_state = 41},
  [2259] = {.lex_state = 41},
  [2260] = {.lex_state = 6},
  [2261] = {.lex_state = 41},
  [2262] = {.lex_state = 41},
  [2263] = {.lex_state = 0},
  [2264] = {.lex_state = 6},
  [2265] = {.lex_state = 41},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 41},
  [2269] = {.lex_state = 41},
  [2270] = {.lex_state = 41},
  [2271] = {.lex_state = 41},
  [2272] = {.lex_state = 41},
  [2273] = {.lex_state = 41},
  [2274] = {.lex_state = 41},
  [2275] = {.lex_state = 41},
  [2276] = {.lex_state = 41},
  [2277] = {.lex_state = 41},
  [2278] = {.lex_state = 41},
  [2279] = {.lex_state = 41},
  [2280] = {.lex_state = 41},
  [2281] = {.lex_state = 15},
  [2282] = {.lex_state = 41},
  [2283] = {.lex_state = 41},
  [2284] = {.lex_state = 41},
  [2285] = {.lex_state = 41},
  [2286] = {.lex_state = 15},
  [2287] = {.lex_state = 41},
  [2288] = {.lex_state = 41},
  [2289] = {.lex_state = 15},
  [2290] = {.lex_state = 41},
  [2291] = {.lex_state = 41},
  [2292] = {.lex_state = 41},
  [2293] = {.lex_state = 15},
  [2294] = {.lex_state = 15},
  [2295] = {.lex_state = 41},
  [2296] = {.lex_state = 41},
  [2297] = {.lex_state = 6},
  [2298] = {.lex_state = 41},
  [2299] = {.lex_state = 41},
  [2300] = {.lex_state = 41},
  [2301] = {.lex_state = 41},
  [2302] = {.lex_state = 41},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 41},
  [2305] = {.lex_state = 6},
  [2306] = {.lex_state = 6},
  [2307] = {.lex_state = 6},
  [2308] = {.lex_state = 41},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 41},
  [2311] = {.lex_state = 41},
  [2312] = {.lex_state = 41},
  [2313] = {.lex_state = 41},
  [2314] = {.lex_state = 15},
  [2315] = {.lex_state = 41},
  [2316] = {.lex_state = 41},
  [2317] = {.lex_state = 41},
  [2318] = {.lex_state = 41},
  [2319] = {.lex_state = 41},
  [2320] = {.lex_state = 41},
  [2321] = {.lex_state = 41},
  [2322] = {.lex_state = 41},
  [2323] = {.lex_state = 41},
  [2324] = {.lex_state = 41},
  [2325] = {.lex_state = 41},
  [2326] = {.lex_state = 41},
  [2327] = {.lex_state = 41},
  [2328] = {.lex_state = 41},
  [2329] = {.lex_state = 0},
  [2330] = {.lex_state = 41},
  [2331] = {.lex_state = 41},
  [2332] = {.lex_state = 41},
  [2333] = {.lex_state = 0},
  [2334] = {.lex_state = 0},
  [2335] = {.lex_state = 41},
  [2336] = {.lex_state = 41},
  [2337] = {.lex_state = 41},
  [2338] = {.lex_state = 41},
  [2339] = {.lex_state = 6},
  [2340] = {.lex_state = 41},
  [2341] = {.lex_state = 0},
  [2342] = {.lex_state = 6},
  [2343] = {.lex_state = 41},
  [2344] = {.lex_state = 41},
  [2345] = {.lex_state = 41},
  [2346] = {.lex_state = 41},
  [2347] = {.lex_state = 2},
  [2348] = {.lex_state = 41},
  [2349] = {.lex_state = 41},
  [2350] = {.lex_state = 41},
  [2351] = {.lex_state = 0},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 7},
  [2354] = {.lex_state = 2},
  [2355] = {.lex_state = 7},
  [2356] = {.lex_state = 41},
  [2357] = {.lex_state = 7},
  [2358] = {.lex_state = 41},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 7},
  [2361] = {.lex_state = 41},
  [2362] = {.lex_state = 0},
  [2363] = {.lex_state = 41},
  [2364] = {.lex_state = 41},
  [2365] = {.lex_state = 41},
  [2366] = {.lex_state = 41},
  [2367] = {.lex_state = 41},
  [2368] = {.lex_state = 41},
  [2369] = {.lex_state = 41},
  [2370] = {.lex_state = 7},
  [2371] = {.lex_state = 7},
  [2372] = {.lex_state = 41},
  [2373] = {.lex_state = 2},
  [2374] = {.lex_state = 2},
  [2375] = {.lex_state = 41},
  [2376] = {.lex_state = 41},
  [2377] = {.lex_state = 41},
  [2378] = {.lex_state = 41},
  [2379] = {.lex_state = 41},
  [2380] = {.lex_state = 2},
  [2381] = {.lex_state = 41},
  [2382] = {.lex_state = 41},
  [2383] = {.lex_state = 41},
  [2384] = {.lex_state = 41},
  [2385] = {.lex_state = 41},
  [2386] = {.lex_state = 41},
  [2387] = {.lex_state = 41},
  [2388] = {.lex_state = 0},
  [2389] = {.lex_state = 41},
  [2390] = {.lex_state = 41},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 41},
  [2393] = {.lex_state = 41},
  [2394] = {.lex_state = 2},
  [2395] = {.lex_state = 41},
  [2396] = {.lex_state = 41},
  [2397] = {.lex_state = 41},
  [2398] = {.lex_state = 41},
  [2399] = {.lex_state = 0},
  [2400] = {.lex_state = 6},
  [2401] = {.lex_state = 41},
  [2402] = {.lex_state = 41},
  [2403] = {.lex_state = 41},
  [2404] = {.lex_state = 41},
  [2405] = {.lex_state = 15},
  [2406] = {.lex_state = 41},
  [2407] = {.lex_state = 41},
  [2408] = {.lex_state = 41},
  [2409] = {.lex_state = 41},
  [2410] = {.lex_state = 0},
  [2411] = {.lex_state = 41},
  [2412] = {.lex_state = 41},
  [2413] = {.lex_state = 41},
  [2414] = {.lex_state = 41},
  [2415] = {.lex_state = 41},
  [2416] = {.lex_state = 41},
  [2417] = {.lex_state = 41},
  [2418] = {.lex_state = 41},
  [2419] = {.lex_state = 15},
  [2420] = {.lex_state = 6},
  [2421] = {.lex_state = 6},
  [2422] = {.lex_state = 41},
  [2423] = {.lex_state = 4},
  [2424] = {.lex_state = 41},
  [2425] = {.lex_state = 41},
  [2426] = {.lex_state = 41},
  [2427] = {.lex_state = 41},
  [2428] = {.lex_state = 41},
  [2429] = {.lex_state = 41},
  [2430] = {.lex_state = 41},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 0},
  [2433] = {.lex_state = 41},
  [2434] = {.lex_state = 41},
  [2435] = {.lex_state = 41},
  [2436] = {.lex_state = 41},
  [2437] = {.lex_state = 41},
  [2438] = {.lex_state = 41},
  [2439] = {.lex_state = 41},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 41},
  [2442] = {.lex_state = 0},
  [2443] = {.lex_state = 41},
  [2444] = {.lex_state = 0},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 41},
  [2447] = {.lex_state = 41},
  [2448] = {.lex_state = 41},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 41},
  [2451] = {.lex_state = 41},
  [2452] = {.lex_state = 0},
  [2453] = {.lex_state = 41},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 2},
  [2457] = {.lex_state = 0},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0},
  [2460] = {.lex_state = 0},
  [2461] = {.lex_state = 0},
  [2462] = {.lex_state = 0},
  [2463] = {.lex_state = 0},
  [2464] = {.lex_state = 41},
  [2465] = {.lex_state = 41},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 0},
  [2468] = {.lex_state = 0},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 0},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 0},
  [2474] = {.lex_state = 0},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 41},
  [2479] = {.lex_state = 0},
  [2480] = {.lex_state = 6},
  [2481] = {.lex_state = 0},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 0},
  [2484] = {.lex_state = 0},
  [2485] = {.lex_state = 41},
  [2486] = {.lex_state = 41},
  [2487] = {.lex_state = 0},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 0},
  [2490] = {.lex_state = 0},
  [2491] = {.lex_state = 0},
  [2492] = {.lex_state = 0},
  [2493] = {.lex_state = 41},
  [2494] = {.lex_state = 0},
  [2495] = {.lex_state = 0},
  [2496] = {.lex_state = 41},
  [2497] = {.lex_state = 0},
  [2498] = {.lex_state = 0},
  [2499] = {.lex_state = 41},
  [2500] = {.lex_state = 6},
  [2501] = {.lex_state = 0},
  [2502] = {.lex_state = 0},
  [2503] = {.lex_state = 0},
  [2504] = {.lex_state = 0},
  [2505] = {.lex_state = 0},
  [2506] = {.lex_state = 0},
  [2507] = {.lex_state = 41},
  [2508] = {.lex_state = 0},
  [2509] = {.lex_state = 0},
  [2510] = {.lex_state = 41},
  [2511] = {.lex_state = 41},
  [2512] = {.lex_state = 0},
  [2513] = {.lex_state = 0},
  [2514] = {.lex_state = 0},
  [2515] = {.lex_state = 41},
  [2516] = {.lex_state = 41},
  [2517] = {.lex_state = 0},
  [2518] = {.lex_state = 0},
  [2519] = {.lex_state = 0},
  [2520] = {.lex_state = 0},
  [2521] = {.lex_state = 0},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 0},
  [2524] = {.lex_state = 0},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 41},
  [2527] = {.lex_state = 0},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 0},
  [2530] = {.lex_state = 41},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0},
  [2533] = {.lex_state = 6},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 2},
  [2536] = {.lex_state = 41},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 0},
  [2539] = {.lex_state = 0},
  [2540] = {.lex_state = 41},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 0},
  [2543] = {.lex_state = 0},
  [2544] = {.lex_state = 6},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 0},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 41},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 0},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 0},
  [2555] = {.lex_state = 0},
  [2556] = {.lex_state = 0},
  [2557] = {.lex_state = 0},
  [2558] = {.lex_state = 0},
  [2559] = {.lex_state = 0},
  [2560] = {.lex_state = 0},
  [2561] = {.lex_state = 0},
  [2562] = {.lex_state = 0},
  [2563] = {.lex_state = 0},
  [2564] = {.lex_state = 0},
  [2565] = {.lex_state = 41},
  [2566] = {.lex_state = 0},
  [2567] = {.lex_state = 2},
  [2568] = {.lex_state = 6},
  [2569] = {.lex_state = 0},
  [2570] = {.lex_state = 6},
  [2571] = {.lex_state = 0},
  [2572] = {.lex_state = 0},
  [2573] = {.lex_state = 0},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 0},
  [2576] = {.lex_state = 0},
  [2577] = {.lex_state = 0},
  [2578] = {.lex_state = 0},
  [2579] = {.lex_state = 6},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 0},
  [2582] = {.lex_state = 0},
  [2583] = {.lex_state = 0},
  [2584] = {.lex_state = 0},
  [2585] = {.lex_state = 0},
  [2586] = {.lex_state = 0},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 6},
  [2589] = {.lex_state = 0},
  [2590] = {.lex_state = 6},
  [2591] = {.lex_state = 0},
  [2592] = {.lex_state = 0},
  [2593] = {.lex_state = 0},
  [2594] = {.lex_state = 0},
  [2595] = {.lex_state = 0},
  [2596] = {.lex_state = 0},
  [2597] = {.lex_state = 6},
  [2598] = {.lex_state = 41},
  [2599] = {.lex_state = 0},
  [2600] = {.lex_state = 0},
  [2601] = {.lex_state = 0},
  [2602] = {.lex_state = 6},
  [2603] = {.lex_state = 6},
  [2604] = {.lex_state = 0},
  [2605] = {.lex_state = 0},
  [2606] = {.lex_state = 0},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 0},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 0},
  [2611] = {.lex_state = 0},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 41},
  [2614] = {.lex_state = 0},
  [2615] = {.lex_state = 0},
  [2616] = {.lex_state = 0},
  [2617] = {.lex_state = 0},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 41},
  [2621] = {.lex_state = 41},
  [2622] = {.lex_state = 0},
  [2623] = {.lex_state = 0},
  [2624] = {.lex_state = 0},
  [2625] = {.lex_state = 6},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 6},
  [2628] = {.lex_state = 0},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 41},
  [2632] = {.lex_state = 41},
  [2633] = {.lex_state = 0},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 41},
  [2636] = {.lex_state = 41},
  [2637] = {.lex_state = 41},
  [2638] = {.lex_state = 0},
  [2639] = {.lex_state = 0},
  [2640] = {.lex_state = 41},
  [2641] = {.lex_state = 0},
  [2642] = {.lex_state = 41},
  [2643] = {.lex_state = 41},
  [2644] = {.lex_state = 41},
  [2645] = {.lex_state = 0},
  [2646] = {.lex_state = 41},
  [2647] = {.lex_state = 41},
  [2648] = {.lex_state = 41},
  [2649] = {.lex_state = 0},
  [2650] = {.lex_state = 0},
  [2651] = {.lex_state = 41},
  [2652] = {.lex_state = 6},
  [2653] = {.lex_state = 0},
  [2654] = {.lex_state = 41},
  [2655] = {.lex_state = 41},
  [2656] = {.lex_state = 0},
  [2657] = {.lex_state = 41},
  [2658] = {.lex_state = 41},
  [2659] = {.lex_state = 0},
  [2660] = {.lex_state = 0},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 41},
  [2663] = {.lex_state = 41},
  [2664] = {.lex_state = 16},
  [2665] = {.lex_state = 41},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 0},
  [2668] = {.lex_state = 0},
  [2669] = {.lex_state = 0},
  [2670] = {.lex_state = 41},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 0},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 0},
  [2675] = {.lex_state = 41},
  [2676] = {.lex_state = 41},
  [2677] = {.lex_state = 41},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 0},
  [2680] = {.lex_state = 0},
  [2681] = {.lex_state = 41},
  [2682] = {.lex_state = 16},
  [2683] = {.lex_state = 41},
  [2684] = {.lex_state = 41},
  [2685] = {.lex_state = 0},
  [2686] = {.lex_state = 0},
  [2687] = {.lex_state = 0},
  [2688] = {.lex_state = 41},
  [2689] = {.lex_state = 41},
  [2690] = {.lex_state = 41},
  [2691] = {.lex_state = 0},
  [2692] = {.lex_state = 0},
  [2693] = {.lex_state = 41},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 41},
  [2696] = {.lex_state = 41},
  [2697] = {.lex_state = 41},
  [2698] = {.lex_state = 0},
  [2699] = {.lex_state = 0},
  [2700] = {.lex_state = 41},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 41},
  [2704] = {.lex_state = 0},
  [2705] = {.lex_state = 41},
  [2706] = {.lex_state = 0},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 41},
  [2709] = {.lex_state = 0},
  [2710] = {.lex_state = 41},
  [2711] = {.lex_state = 0},
  [2712] = {.lex_state = 41},
  [2713] = {.lex_state = 41},
  [2714] = {.lex_state = 0},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 41},
  [2718] = {.lex_state = 0},
  [2719] = {.lex_state = 0},
  [2720] = {.lex_state = 0},
  [2721] = {.lex_state = 0},
  [2722] = {.lex_state = 0},
  [2723] = {.lex_state = 41},
  [2724] = {.lex_state = 41},
  [2725] = {.lex_state = 0},
  [2726] = {.lex_state = 0},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 0},
  [2729] = {.lex_state = 0},
  [2730] = {.lex_state = 41},
  [2731] = {.lex_state = 0},
  [2732] = {.lex_state = 6},
  [2733] = {.lex_state = 0},
  [2734] = {.lex_state = 41},
  [2735] = {.lex_state = 16},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 41},
  [2738] = {.lex_state = 41},
  [2739] = {.lex_state = 0},
  [2740] = {.lex_state = 0},
  [2741] = {.lex_state = 41},
  [2742] = {.lex_state = 0},
  [2743] = {.lex_state = 41},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 41},
  [2746] = {.lex_state = 41},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 41},
  [2749] = {.lex_state = 0},
  [2750] = {.lex_state = 41},
  [2751] = {.lex_state = 41},
  [2752] = {.lex_state = 41},
  [2753] = {.lex_state = 41},
  [2754] = {.lex_state = 41},
  [2755] = {.lex_state = 41},
  [2756] = {.lex_state = 41},
  [2757] = {.lex_state = 41},
  [2758] = {.lex_state = 41},
  [2759] = {.lex_state = 41},
  [2760] = {.lex_state = 41},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 0},
  [2763] = {.lex_state = 41},
  [2764] = {.lex_state = 41},
  [2765] = {.lex_state = 41},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 41},
  [2768] = {.lex_state = 41},
  [2769] = {.lex_state = 41},
  [2770] = {.lex_state = 41},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 0},
  [2773] = {.lex_state = 41},
  [2774] = {.lex_state = 41},
  [2775] = {.lex_state = 41},
  [2776] = {.lex_state = 41},
  [2777] = {.lex_state = 0},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 0},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 41},
  [2782] = {.lex_state = 0},
  [2783] = {.lex_state = 0},
  [2784] = {.lex_state = 41},
  [2785] = {.lex_state = 41},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 41},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 41},
  [2792] = {.lex_state = 0},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 41},
  [2796] = {.lex_state = 41},
  [2797] = {.lex_state = 41},
  [2798] = {.lex_state = 41},
  [2799] = {.lex_state = 41},
  [2800] = {.lex_state = 41},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 41},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 41},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 41},
  [2809] = {.lex_state = 41},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 41},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 0},
  [2814] = {.lex_state = 41},
  [2815] = {.lex_state = 41},
  [2816] = {.lex_state = 0},
  [2817] = {.lex_state = 0},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 41},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 0},
  [2822] = {.lex_state = 0},
  [2823] = {.lex_state = 0},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 41},
  [2827] = {.lex_state = 41},
  [2828] = {.lex_state = 41},
  [2829] = {.lex_state = 0},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 0},
  [2832] = {.lex_state = 0},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 0},
  [2840] = {.lex_state = 0},
  [2841] = {.lex_state = 41},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 41},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 0},
  [2848] = {.lex_state = 41},
  [2849] = {.lex_state = 0},
  [2850] = {.lex_state = 0},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0},
  [2854] = {.lex_state = 41},
  [2855] = {.lex_state = 0},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 16},
  [2859] = {.lex_state = 0},
  [2860] = {.lex_state = 0},
  [2861] = {.lex_state = 0},
  [2862] = {.lex_state = 41},
  [2863] = {.lex_state = 0},
  [2864] = {.lex_state = 0},
  [2865] = {.lex_state = 41},
  [2866] = {.lex_state = 0},
  [2867] = {.lex_state = 41},
  [2868] = {.lex_state = 0},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 0},
  [2871] = {.lex_state = 0},
  [2872] = {.lex_state = 41},
  [2873] = {.lex_state = 41},
  [2874] = {.lex_state = 0},
  [2875] = {.lex_state = 41},
  [2876] = {.lex_state = 41},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 0},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 0},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 0},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 0},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 41},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 0},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 0},
  [2894] = {.lex_state = 41},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 41},
  [2898] = {.lex_state = 41},
  [2899] = {.lex_state = 41},
  [2900] = {.lex_state = 41},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 41},
  [2903] = {.lex_state = 41},
  [2904] = {.lex_state = 0},
  [2905] = {.lex_state = 0},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 41},
  [2910] = {.lex_state = 17},
  [2911] = {.lex_state = 41},
  [2912] = {.lex_state = 0},
  [2913] = {.lex_state = 41},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 41},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 41},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 0},
  [2922] = {.lex_state = 0},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 41},
  [2925] = {.lex_state = 41},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 41},
  [2928] = {.lex_state = 41},
  [2929] = {.lex_state = 41},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 41},
  [2932] = {.lex_state = 0},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 0},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 0},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 0},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 0},
  [2943] = {.lex_state = 41},
  [2944] = {.lex_state = 41},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 0},
  [2948] = {.lex_state = 0},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 41},
  [2954] = {.lex_state = 0},
  [2955] = {.lex_state = 41},
  [2956] = {.lex_state = 41},
  [2957] = {.lex_state = 41},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 0},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 41},
  [2963] = {.lex_state = 41},
  [2964] = {.lex_state = 0},
  [2965] = {.lex_state = 41},
  [2966] = {.lex_state = 0},
  [2967] = {(TSStateId)(-1)},
  [2968] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__preproc_directive_end = 0,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__preproc_directive_end] = sym__preproc_directive_end,
};

static bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__preproc_directive_end] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_preprocessor_call] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_field] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_method] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_assembly] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_fixed] = ACTIONS(1),
    [anon_sym_internal] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_partial] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_sealed] = ACTIONS(1),
    [anon_sym_unsafe] = ACTIONS(1),
    [anon_sym_virtual] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_out] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_this] = ACTIONS(1),
    [anon_sym_params] = ACTIONS(1),
    [anon_sym_base] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_implicit] = ACTIONS(1),
    [anon_sym_explicit] = ACTIONS(1),
    [anon_sym_operator] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_unmanaged] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_add] = ACTIONS(1),
    [anon_sym_remove] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_delegate] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_predefined_type] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_checked] = ACTIONS(1),
    [anon_sym_unchecked] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_lock] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [sym_discard] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_stackalloc] = ACTIONS(1),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym___makeref] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_join] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_equals] = ACTIONS(1),
    [anon_sym_into] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_orderby] = ACTIONS(1),
    [anon_sym_ascending] = ACTIONS(1),
    [anon_sym_descending] = ACTIONS(1),
    [anon_sym_group] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym___reftype] = ACTIONS(1),
    [anon_sym___refvalue] = ACTIONS(1),
    [anon_sym_sizeof] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [sym_global] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_integer_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [sym_real_literal] = ACTIONS(1),
    [sym_verbatim_string_literal] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(1),
    [sym_preprocessor_directive] = ACTIONS(5),
    [sym__preproc_directive_end] = ACTIONS(1),
  },
  [1] = {
    [sym_compilation_unit] = STATE(2893),
    [sym__declaration] = STATE(1523),
    [sym_extern_alias_directive] = STATE(1520),
    [sym_using_directive] = STATE(1520),
    [sym__name] = STATE(1840),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(1771),
    [sym_generic_name] = STATE(1769),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1292),
    [sym_global_attribute_list] = STATE(1520),
    [sym_event_field_declaration] = STATE(1520),
    [sym_modifier] = STATE(1722),
    [sym_variable_declaration] = STATE(2880),
    [sym_field_declaration] = STATE(1520),
    [sym_constructor_declaration] = STATE(1520),
    [sym_conversion_operator_declaration] = STATE(1520),
    [sym_destructor_declaration] = STATE(1520),
    [sym_method_declaration] = STATE(1520),
    [sym_operator_declaration] = STATE(1520),
    [sym_event_declaration] = STATE(1520),
    [sym_indexer_declaration] = STATE(1520),
    [sym_property_declaration] = STATE(1520),
    [sym_enum_declaration] = STATE(1520),
    [sym_class_declaration] = STATE(1520),
    [sym_interface_declaration] = STATE(1520),
    [sym_struct_declaration] = STATE(1520),
    [sym_delegate_declaration] = STATE(1520),
    [sym_namespace_declaration] = STATE(1520),
    [sym__type] = STATE(1798),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_preprocessor_call] = STATE(1),
    [aux_sym_compilation_unit_repeat1] = STATE(502),
    [aux_sym_event_field_declaration_repeat1] = STATE(830),
    [aux_sym_event_field_declaration_repeat2] = STATE(1017),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_extern] = ACTIONS(11),
    [anon_sym_using] = ACTIONS(13),
    [anon_sym_static] = ACTIONS(15),
    [anon_sym_LBRACK] = ACTIONS(17),
    [anon_sym_event] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(15),
    [anon_sym_async] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(15),
    [anon_sym_fixed] = ACTIONS(15),
    [anon_sym_internal] = ACTIONS(15),
    [anon_sym_new] = ACTIONS(15),
    [anon_sym_override] = ACTIONS(15),
    [anon_sym_partial] = ACTIONS(15),
    [anon_sym_private] = ACTIONS(15),
    [anon_sym_protected] = ACTIONS(15),
    [anon_sym_public] = ACTIONS(15),
    [anon_sym_readonly] = ACTIONS(15),
    [anon_sym_ref] = ACTIONS(15),
    [anon_sym_sealed] = ACTIONS(15),
    [anon_sym_unsafe] = ACTIONS(15),
    [anon_sym_virtual] = ACTIONS(15),
    [anon_sym_volatile] = ACTIONS(15),
    [anon_sym_implicit] = ACTIONS(23),
    [anon_sym_explicit] = ACTIONS(23),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_class] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_enum] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(33),
    [anon_sym_delegate] = ACTIONS(35),
    [anon_sym_namespace] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [sym_global] = ACTIONS(43),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(45),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [2] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_case_pattern_switch_label] = STATE(492),
    [sym_case_switch_label] = STATE(492),
    [sym_default_switch_label] = STATE(492),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(2),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(10),
    [aux_sym_switch_section_repeat1] = STATE(420),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_case] = ACTIONS(105),
    [anon_sym_default] = ACTIONS(107),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [3] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(3),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_extern] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(162),
    [anon_sym_static] = ACTIONS(156),
    [anon_sym_DOT] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_return] = ACTIONS(171),
    [anon_sym_LPAREN] = ACTIONS(174),
    [anon_sym_abstract] = ACTIONS(156),
    [anon_sym_async] = ACTIONS(177),
    [anon_sym_const] = ACTIONS(156),
    [anon_sym_fixed] = ACTIONS(180),
    [anon_sym_internal] = ACTIONS(156),
    [anon_sym_new] = ACTIONS(183),
    [anon_sym_override] = ACTIONS(156),
    [anon_sym_partial] = ACTIONS(156),
    [anon_sym_private] = ACTIONS(156),
    [anon_sym_protected] = ACTIONS(156),
    [anon_sym_public] = ACTIONS(156),
    [anon_sym_readonly] = ACTIONS(156),
    [anon_sym_ref] = ACTIONS(186),
    [anon_sym_sealed] = ACTIONS(156),
    [anon_sym_unsafe] = ACTIONS(189),
    [anon_sym_virtual] = ACTIONS(156),
    [anon_sym_volatile] = ACTIONS(156),
    [anon_sym_this] = ACTIONS(192),
    [anon_sym_base] = ACTIONS(195),
    [anon_sym_LBRACE] = ACTIONS(198),
    [anon_sym_RBRACE] = ACTIONS(201),
    [anon_sym_TILDE] = ACTIONS(203),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS_PLUS] = ACTIONS(203),
    [anon_sym_DASH_DASH] = ACTIONS(203),
    [anon_sym_true] = ACTIONS(206),
    [anon_sym_false] = ACTIONS(206),
    [anon_sym_PLUS] = ACTIONS(209),
    [anon_sym_DASH] = ACTIONS(209),
    [anon_sym_STAR] = ACTIONS(203),
    [anon_sym_CARET] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(203),
    [anon_sym_delegate] = ACTIONS(212),
    [anon_sym_var] = ACTIONS(215),
    [sym_predefined_type] = ACTIONS(218),
    [anon_sym_break] = ACTIONS(221),
    [anon_sym_checked] = ACTIONS(224),
    [anon_sym_unchecked] = ACTIONS(224),
    [anon_sym_continue] = ACTIONS(227),
    [anon_sym_do] = ACTIONS(230),
    [anon_sym_while] = ACTIONS(233),
    [anon_sym_for] = ACTIONS(236),
    [anon_sym_await] = ACTIONS(239),
    [anon_sym_foreach] = ACTIONS(242),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_case] = ACTIONS(248),
    [anon_sym_default] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(253),
    [anon_sym_lock] = ACTIONS(256),
    [anon_sym_switch] = ACTIONS(259),
    [anon_sym_throw] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(268),
    [anon_sym_stackalloc] = ACTIONS(271),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(280),
    [anon_sym___makeref] = ACTIONS(283),
    [anon_sym_from] = ACTIONS(286),
    [anon_sym_DOT_DOT] = ACTIONS(289),
    [anon_sym___reftype] = ACTIONS(292),
    [anon_sym___refvalue] = ACTIONS(295),
    [anon_sym_sizeof] = ACTIONS(298),
    [anon_sym_typeof] = ACTIONS(301),
    [sym_global] = ACTIONS(304),
    [anon_sym_SQUOTE] = ACTIONS(307),
    [sym_integer_literal] = ACTIONS(310),
    [sym_null_literal] = ACTIONS(310),
    [sym_real_literal] = ACTIONS(310),
    [sym_verbatim_string_literal] = ACTIONS(313),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(316),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [4] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(843),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(4),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(319),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(323),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [5] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(843),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(5),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(319),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(327),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [6] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(840),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(6),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(18),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(331),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [7] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(848),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(7),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(22),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [8] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(843),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(8),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(16),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(319),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(337),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [9] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(843),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(9),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_COMMA] = ACTIONS(319),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [10] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(10),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(341),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_case] = ACTIONS(343),
    [anon_sym_default] = ACTIONS(343),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [11] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(11),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [12] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(12),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(16),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [13] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(13),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(349),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [14] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(14),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [15] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(15),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [16] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(16),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [17] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(17),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(22),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [18] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(18),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [19] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(19),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(18),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [20] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(20),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [21] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(21),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(20),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [22] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(491),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(22),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [aux_sym_block_repeat1] = STATE(3),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_RBRACE] = ACTIONS(367),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [23] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(464),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(23),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [24] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(464),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(24),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [25] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(475),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(25),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [26] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(482),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(26),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [27] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(483),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(27),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [28] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(463),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(28),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [29] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(465),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(29),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [30] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(448),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(30),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [31] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(449),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(31),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [32] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(488),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(32),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [33] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(2915),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(33),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [34] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(425),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(34),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [35] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(466),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(35),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [36] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(450),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(36),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [37] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(455),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(37),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [38] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(474),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(38),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [39] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(431),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(39),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [40] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(433),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(40),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [41] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(467),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(41),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [42] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(483),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(42),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [43] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(482),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(43),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [44] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(446),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(44),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [45] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(445),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(45),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [46] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(475),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(46),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [47] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(2690),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(47),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [48] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(443),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(48),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [49] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(434),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(49),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [50] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(465),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(50),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [51] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(448),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(51),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [52] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(425),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(52),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [53] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(431),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(53),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [54] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(433),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(54),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [55] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(437),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(55),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [56] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(470),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(56),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [57] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(460),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(57),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [58] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(479),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(58),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [59] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(429),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(59),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [60] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(476),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(60),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [61] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(469),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(61),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [62] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(424),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(62),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [63] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(459),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(63),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [64] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(459),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(64),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [65] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(429),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(65),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [66] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(460),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(66),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [67] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(434),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(67),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [68] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(443),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(68),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [69] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(445),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(69),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [70] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(446),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(70),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [71] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(474),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(71),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [72] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(466),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(72),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [73] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(467),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(73),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [74] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(449),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(74),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [75] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(469),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(75),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [76] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(476),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(76),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [77] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(455),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(77),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [78] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(450),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(78),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [79] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1908),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(488),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(79),
    [aux_sym_event_field_declaration_repeat2] = STATE(1254),
    [sym_identifier] = ACTIONS(369),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(371),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(373),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(375),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(379),
    [anon_sym_unchecked] = ACTIONS(379),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_await] = ACTIONS(385),
    [anon_sym_foreach] = ACTIONS(387),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_lock] = ACTIONS(391),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(393),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(395),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [80] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(437),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(80),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [81] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(470),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(81),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [82] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(424),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(82),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [83] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2782),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym_block] = STATE(462),
    [sym__type] = STATE(1904),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym__statement] = STATE(479),
    [sym_break_statement] = STATE(462),
    [sym_checked_statement] = STATE(462),
    [sym_continue_statement] = STATE(462),
    [sym_do_statement] = STATE(462),
    [sym_empty_statement] = STATE(462),
    [sym_expression_statement] = STATE(462),
    [sym_fixed_statement] = STATE(462),
    [sym_for_statement] = STATE(462),
    [sym_for_each_statement] = STATE(462),
    [sym_goto_statement] = STATE(462),
    [sym_if_statement] = STATE(462),
    [sym_labeled_statement] = STATE(462),
    [sym_local_declaration_statement] = STATE(462),
    [sym_local_function_statement] = STATE(462),
    [sym_lock_statement] = STATE(462),
    [sym_return_statement] = STATE(462),
    [sym_switch_statement] = STATE(462),
    [sym_throw_statement] = STATE(462),
    [sym_try_statement] = STATE(462),
    [sym_unsafe_statement] = STATE(462),
    [sym_using_statement] = STATE(462),
    [sym_while_statement] = STATE(462),
    [sym_yield_statement] = STATE(462),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(1049),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(83),
    [aux_sym_event_field_declaration_repeat2] = STATE(1167),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_SEMI] = ACTIONS(51),
    [anon_sym_using] = ACTIONS(53),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(65),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(71),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_checked] = ACTIONS(89),
    [anon_sym_unchecked] = ACTIONS(89),
    [anon_sym_continue] = ACTIONS(91),
    [anon_sym_do] = ACTIONS(93),
    [anon_sym_while] = ACTIONS(95),
    [anon_sym_for] = ACTIONS(97),
    [anon_sym_await] = ACTIONS(99),
    [anon_sym_foreach] = ACTIONS(101),
    [anon_sym_goto] = ACTIONS(103),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_switch] = ACTIONS(113),
    [anon_sym_throw] = ACTIONS(115),
    [anon_sym_try] = ACTIONS(117),
    [anon_sym_yield] = ACTIONS(119),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(151),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [84] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2923),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(531),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(84),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(399),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(409),
    [anon_sym_in] = ACTIONS(401),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(413),
    [anon_sym_where] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(413),
    [anon_sym_DASH_DASH] = ACTIONS(413),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(415),
    [anon_sym_DASH] = ACTIONS(415),
    [anon_sym_STAR] = ACTIONS(415),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(415),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_when] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(421),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(423),
    [anon_sym_join] = ACTIONS(401),
    [anon_sym_on] = ACTIONS(401),
    [anon_sym_equals] = ACTIONS(401),
    [anon_sym_into] = ACTIONS(401),
    [anon_sym_let] = ACTIONS(401),
    [anon_sym_orderby] = ACTIONS(401),
    [anon_sym_group] = ACTIONS(401),
    [anon_sym_by] = ACTIONS(401),
    [anon_sym_select] = ACTIONS(401),
    [anon_sym_DOT_DOT] = ACTIONS(425),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [85] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2923),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(538),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(85),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(427),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(409),
    [anon_sym_in] = ACTIONS(429),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(413),
    [anon_sym_where] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(413),
    [anon_sym_DASH_DASH] = ACTIONS(413),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(415),
    [anon_sym_DASH] = ACTIONS(415),
    [anon_sym_STAR] = ACTIONS(415),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(415),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_when] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(421),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(423),
    [anon_sym_join] = ACTIONS(429),
    [anon_sym_on] = ACTIONS(429),
    [anon_sym_equals] = ACTIONS(429),
    [anon_sym_into] = ACTIONS(429),
    [anon_sym_let] = ACTIONS(429),
    [anon_sym_orderby] = ACTIONS(429),
    [anon_sym_group] = ACTIONS(429),
    [anon_sym_by] = ACTIONS(429),
    [anon_sym_select] = ACTIONS(429),
    [anon_sym_DOT_DOT] = ACTIONS(425),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [86] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(653),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(86),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(427),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(435),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_where] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(83),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(83),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(83),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_when] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_join] = ACTIONS(429),
    [anon_sym_on] = ACTIONS(429),
    [anon_sym_equals] = ACTIONS(429),
    [anon_sym_let] = ACTIONS(429),
    [anon_sym_orderby] = ACTIONS(429),
    [anon_sym_group] = ACTIONS(429),
    [anon_sym_by] = ACTIONS(429),
    [anon_sym_select] = ACTIONS(429),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [87] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(583),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(87),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(399),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(435),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_where] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(83),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(83),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(83),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_when] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_join] = ACTIONS(401),
    [anon_sym_on] = ACTIONS(401),
    [anon_sym_equals] = ACTIONS(401),
    [anon_sym_let] = ACTIONS(401),
    [anon_sym_orderby] = ACTIONS(401),
    [anon_sym_group] = ACTIONS(401),
    [anon_sym_by] = ACTIONS(401),
    [anon_sym_select] = ACTIONS(401),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [88] = {
    [sym__name] = STATE(2231),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(757),
    [sym_generic_name] = STATE(710),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(764),
    [sym_parameter_list] = STATE(2801),
    [sym__type] = STATE(2142),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(795),
    [sym_lambda_expression] = STATE(795),
    [sym_anonymous_object_creation_expression] = STATE(795),
    [sym_array_creation_expression] = STATE(795),
    [sym_initializer_expression] = STATE(795),
    [sym_assignment_expression] = STATE(795),
    [sym_await_expression] = STATE(795),
    [sym_cast_expression] = STATE(795),
    [sym_checked_expression] = STATE(795),
    [sym_conditional_access_expression] = STATE(795),
    [sym_conditional_expression] = STATE(795),
    [sym_default_expression] = STATE(795),
    [sym_element_access_expression] = STATE(795),
    [sym_element_binding_expression] = STATE(795),
    [sym_implicit_array_creation_expression] = STATE(795),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(795),
    [sym_base_expression] = STATE(795),
    [sym_this_expression] = STATE(795),
    [sym_interpolated_string_expression] = STATE(795),
    [sym_invocation_expression] = STATE(795),
    [sym_is_pattern_expression] = STATE(795),
    [sym_make_ref_expression] = STATE(795),
    [sym_member_access_expression] = STATE(795),
    [sym_member_binding_expression] = STATE(795),
    [sym_object_creation_expression] = STATE(795),
    [sym_parenthesized_expression] = STATE(795),
    [sym_postfix_unary_expression] = STATE(795),
    [sym_prefix_unary_expression] = STATE(795),
    [sym_query_expression] = STATE(795),
    [sym_from_clause] = STATE(1787),
    [sym_range_expression] = STATE(795),
    [sym_ref_expression] = STATE(795),
    [sym_ref_type_expression] = STATE(795),
    [sym_ref_value_expression] = STATE(795),
    [sym_size_of_expression] = STATE(795),
    [sym_stack_alloc_array_creation_expression] = STATE(795),
    [sym_switch_expression] = STATE(795),
    [sym_throw_expression] = STATE(795),
    [sym_tuple_expression] = STATE(795),
    [sym_type_of_expression] = STATE(795),
    [sym__expression] = STATE(686),
    [sym_binary_expression] = STATE(795),
    [sym__literal] = STATE(795),
    [sym_boolean_literal] = STATE(822),
    [sym_character_literal] = STATE(822),
    [sym_string_literal] = STATE(822),
    [sym__reserved_identifier] = STATE(795),
    [sym_preprocessor_call] = STATE(88),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_async] = ACTIONS(449),
    [anon_sym_new] = ACTIONS(451),
    [anon_sym_ref] = ACTIONS(453),
    [anon_sym_this] = ACTIONS(455),
    [anon_sym_base] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(461),
    [anon_sym_where] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_true] = ACTIONS(465),
    [anon_sym_false] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(463),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(469),
    [anon_sym_unchecked] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(471),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(477),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(483),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(487),
    [anon_sym_join] = ACTIONS(401),
    [anon_sym_into] = ACTIONS(401),
    [anon_sym_let] = ACTIONS(401),
    [anon_sym_orderby] = ACTIONS(401),
    [anon_sym_ascending] = ACTIONS(401),
    [anon_sym_descending] = ACTIONS(401),
    [anon_sym_group] = ACTIONS(401),
    [anon_sym_select] = ACTIONS(401),
    [anon_sym_DOT_DOT] = ACTIONS(489),
    [anon_sym___reftype] = ACTIONS(491),
    [anon_sym___refvalue] = ACTIONS(493),
    [anon_sym_sizeof] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(497),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(501),
    [sym_integer_literal] = ACTIONS(503),
    [sym_null_literal] = ACTIONS(503),
    [sym_real_literal] = ACTIONS(503),
    [sym_verbatim_string_literal] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [89] = {
    [sym__name] = STATE(2231),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(757),
    [sym_generic_name] = STATE(710),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(764),
    [sym_parameter_list] = STATE(2801),
    [sym__type] = STATE(2142),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(795),
    [sym_lambda_expression] = STATE(795),
    [sym_anonymous_object_creation_expression] = STATE(795),
    [sym_array_creation_expression] = STATE(795),
    [sym_initializer_expression] = STATE(795),
    [sym_assignment_expression] = STATE(795),
    [sym_await_expression] = STATE(795),
    [sym_cast_expression] = STATE(795),
    [sym_checked_expression] = STATE(795),
    [sym_conditional_access_expression] = STATE(795),
    [sym_conditional_expression] = STATE(795),
    [sym_default_expression] = STATE(795),
    [sym_element_access_expression] = STATE(795),
    [sym_element_binding_expression] = STATE(795),
    [sym_implicit_array_creation_expression] = STATE(795),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(795),
    [sym_base_expression] = STATE(795),
    [sym_this_expression] = STATE(795),
    [sym_interpolated_string_expression] = STATE(795),
    [sym_invocation_expression] = STATE(795),
    [sym_is_pattern_expression] = STATE(795),
    [sym_make_ref_expression] = STATE(795),
    [sym_member_access_expression] = STATE(795),
    [sym_member_binding_expression] = STATE(795),
    [sym_object_creation_expression] = STATE(795),
    [sym_parenthesized_expression] = STATE(795),
    [sym_postfix_unary_expression] = STATE(795),
    [sym_prefix_unary_expression] = STATE(795),
    [sym_query_expression] = STATE(795),
    [sym_from_clause] = STATE(1787),
    [sym_range_expression] = STATE(795),
    [sym_ref_expression] = STATE(795),
    [sym_ref_type_expression] = STATE(795),
    [sym_ref_value_expression] = STATE(795),
    [sym_size_of_expression] = STATE(795),
    [sym_stack_alloc_array_creation_expression] = STATE(795),
    [sym_switch_expression] = STATE(795),
    [sym_throw_expression] = STATE(795),
    [sym_tuple_expression] = STATE(795),
    [sym_type_of_expression] = STATE(795),
    [sym__expression] = STATE(672),
    [sym_binary_expression] = STATE(795),
    [sym__literal] = STATE(795),
    [sym_boolean_literal] = STATE(822),
    [sym_character_literal] = STATE(822),
    [sym_string_literal] = STATE(822),
    [sym__reserved_identifier] = STATE(795),
    [sym_preprocessor_call] = STATE(89),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_async] = ACTIONS(449),
    [anon_sym_new] = ACTIONS(451),
    [anon_sym_ref] = ACTIONS(453),
    [anon_sym_this] = ACTIONS(455),
    [anon_sym_base] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(461),
    [anon_sym_where] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_true] = ACTIONS(465),
    [anon_sym_false] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(463),
    [anon_sym_DASH] = ACTIONS(463),
    [anon_sym_STAR] = ACTIONS(463),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(463),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(469),
    [anon_sym_unchecked] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(471),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(477),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(483),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(487),
    [anon_sym_join] = ACTIONS(429),
    [anon_sym_into] = ACTIONS(429),
    [anon_sym_let] = ACTIONS(429),
    [anon_sym_orderby] = ACTIONS(429),
    [anon_sym_ascending] = ACTIONS(429),
    [anon_sym_descending] = ACTIONS(429),
    [anon_sym_group] = ACTIONS(429),
    [anon_sym_select] = ACTIONS(429),
    [anon_sym_DOT_DOT] = ACTIONS(489),
    [anon_sym___reftype] = ACTIONS(491),
    [anon_sym___refvalue] = ACTIONS(493),
    [anon_sym_sizeof] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(497),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(501),
    [sym_integer_literal] = ACTIONS(503),
    [sym_null_literal] = ACTIONS(503),
    [sym_real_literal] = ACTIONS(503),
    [sym_verbatim_string_literal] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [90] = {
    [sym__name] = STATE(2231),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(757),
    [sym_generic_name] = STATE(710),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(764),
    [sym_parameter_list] = STATE(2942),
    [sym__type] = STATE(2142),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(795),
    [sym_lambda_expression] = STATE(795),
    [sym_anonymous_object_creation_expression] = STATE(795),
    [sym_array_creation_expression] = STATE(795),
    [sym_initializer_expression] = STATE(795),
    [sym_assignment_expression] = STATE(795),
    [sym_await_expression] = STATE(795),
    [sym_cast_expression] = STATE(795),
    [sym_checked_expression] = STATE(795),
    [sym_conditional_access_expression] = STATE(795),
    [sym_conditional_expression] = STATE(795),
    [sym_default_expression] = STATE(795),
    [sym_element_access_expression] = STATE(795),
    [sym_element_binding_expression] = STATE(795),
    [sym_implicit_array_creation_expression] = STATE(795),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(795),
    [sym_base_expression] = STATE(795),
    [sym_this_expression] = STATE(795),
    [sym_interpolated_string_expression] = STATE(795),
    [sym_invocation_expression] = STATE(795),
    [sym_is_pattern_expression] = STATE(795),
    [sym_make_ref_expression] = STATE(795),
    [sym_member_access_expression] = STATE(795),
    [sym_member_binding_expression] = STATE(795),
    [sym_object_creation_expression] = STATE(795),
    [sym_parenthesized_expression] = STATE(795),
    [sym_postfix_unary_expression] = STATE(795),
    [sym_prefix_unary_expression] = STATE(795),
    [sym_query_expression] = STATE(795),
    [sym_from_clause] = STATE(1787),
    [sym_range_expression] = STATE(795),
    [sym_ref_expression] = STATE(795),
    [sym_ref_type_expression] = STATE(795),
    [sym_ref_value_expression] = STATE(795),
    [sym_size_of_expression] = STATE(795),
    [sym_stack_alloc_array_creation_expression] = STATE(795),
    [sym_switch_expression] = STATE(795),
    [sym_throw_expression] = STATE(795),
    [sym_tuple_expression] = STATE(795),
    [sym_type_of_expression] = STATE(795),
    [sym__expression] = STATE(733),
    [sym_binary_expression] = STATE(795),
    [sym__literal] = STATE(795),
    [sym_boolean_literal] = STATE(822),
    [sym_character_literal] = STATE(822),
    [sym_string_literal] = STATE(822),
    [sym__reserved_identifier] = STATE(795),
    [sym_preprocessor_call] = STATE(90),
    [sym_identifier] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(509),
    [anon_sym_async] = ACTIONS(511),
    [anon_sym_new] = ACTIONS(451),
    [anon_sym_ref] = ACTIONS(513),
    [anon_sym_this] = ACTIONS(455),
    [anon_sym_base] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_where] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS_PLUS] = ACTIONS(515),
    [anon_sym_DASH_DASH] = ACTIONS(515),
    [anon_sym_true] = ACTIONS(465),
    [anon_sym_false] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(517),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(517),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(517),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(469),
    [anon_sym_unchecked] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(519),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(521),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(477),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(483),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(523),
    [anon_sym_join] = ACTIONS(401),
    [anon_sym_let] = ACTIONS(401),
    [anon_sym_orderby] = ACTIONS(401),
    [anon_sym_ascending] = ACTIONS(401),
    [anon_sym_descending] = ACTIONS(401),
    [anon_sym_group] = ACTIONS(401),
    [anon_sym_select] = ACTIONS(401),
    [anon_sym_DOT_DOT] = ACTIONS(525),
    [anon_sym___reftype] = ACTIONS(491),
    [anon_sym___refvalue] = ACTIONS(493),
    [anon_sym_sizeof] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(497),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(501),
    [sym_integer_literal] = ACTIONS(503),
    [sym_null_literal] = ACTIONS(503),
    [sym_real_literal] = ACTIONS(503),
    [sym_verbatim_string_literal] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [91] = {
    [sym__name] = STATE(2231),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(757),
    [sym_generic_name] = STATE(710),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(764),
    [sym_parameter_list] = STATE(2942),
    [sym__type] = STATE(2142),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(795),
    [sym_lambda_expression] = STATE(795),
    [sym_anonymous_object_creation_expression] = STATE(795),
    [sym_array_creation_expression] = STATE(795),
    [sym_initializer_expression] = STATE(795),
    [sym_assignment_expression] = STATE(795),
    [sym_await_expression] = STATE(795),
    [sym_cast_expression] = STATE(795),
    [sym_checked_expression] = STATE(795),
    [sym_conditional_access_expression] = STATE(795),
    [sym_conditional_expression] = STATE(795),
    [sym_default_expression] = STATE(795),
    [sym_element_access_expression] = STATE(795),
    [sym_element_binding_expression] = STATE(795),
    [sym_implicit_array_creation_expression] = STATE(795),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(795),
    [sym_base_expression] = STATE(795),
    [sym_this_expression] = STATE(795),
    [sym_interpolated_string_expression] = STATE(795),
    [sym_invocation_expression] = STATE(795),
    [sym_is_pattern_expression] = STATE(795),
    [sym_make_ref_expression] = STATE(795),
    [sym_member_access_expression] = STATE(795),
    [sym_member_binding_expression] = STATE(795),
    [sym_object_creation_expression] = STATE(795),
    [sym_parenthesized_expression] = STATE(795),
    [sym_postfix_unary_expression] = STATE(795),
    [sym_prefix_unary_expression] = STATE(795),
    [sym_query_expression] = STATE(795),
    [sym_from_clause] = STATE(1787),
    [sym_range_expression] = STATE(795),
    [sym_ref_expression] = STATE(795),
    [sym_ref_type_expression] = STATE(795),
    [sym_ref_value_expression] = STATE(795),
    [sym_size_of_expression] = STATE(795),
    [sym_stack_alloc_array_creation_expression] = STATE(795),
    [sym_switch_expression] = STATE(795),
    [sym_throw_expression] = STATE(795),
    [sym_tuple_expression] = STATE(795),
    [sym_type_of_expression] = STATE(795),
    [sym__expression] = STATE(713),
    [sym_binary_expression] = STATE(795),
    [sym__literal] = STATE(795),
    [sym_boolean_literal] = STATE(822),
    [sym_character_literal] = STATE(822),
    [sym_string_literal] = STATE(822),
    [sym__reserved_identifier] = STATE(795),
    [sym_preprocessor_call] = STATE(91),
    [sym_identifier] = ACTIONS(507),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(509),
    [anon_sym_async] = ACTIONS(511),
    [anon_sym_new] = ACTIONS(451),
    [anon_sym_ref] = ACTIONS(513),
    [anon_sym_this] = ACTIONS(455),
    [anon_sym_base] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_where] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS_PLUS] = ACTIONS(515),
    [anon_sym_DASH_DASH] = ACTIONS(515),
    [anon_sym_true] = ACTIONS(465),
    [anon_sym_false] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(517),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(517),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(517),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(469),
    [anon_sym_unchecked] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(519),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(521),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(477),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(483),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(485),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(523),
    [anon_sym_join] = ACTIONS(429),
    [anon_sym_let] = ACTIONS(429),
    [anon_sym_orderby] = ACTIONS(429),
    [anon_sym_ascending] = ACTIONS(429),
    [anon_sym_descending] = ACTIONS(429),
    [anon_sym_group] = ACTIONS(429),
    [anon_sym_select] = ACTIONS(429),
    [anon_sym_DOT_DOT] = ACTIONS(525),
    [anon_sym___reftype] = ACTIONS(491),
    [anon_sym___refvalue] = ACTIONS(493),
    [anon_sym_sizeof] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(497),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(501),
    [sym_integer_literal] = ACTIONS(503),
    [sym_null_literal] = ACTIONS(503),
    [sym_real_literal] = ACTIONS(503),
    [sym_verbatim_string_literal] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [92] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2790),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1785),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(859),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(92),
    [sym_identifier] = ACTIONS(527),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(529),
    [anon_sym_async] = ACTIONS(531),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(533),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_EQ_GT] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(535),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS_PLUS] = ACTIONS(535),
    [anon_sym_DASH_DASH] = ACTIONS(535),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(537),
    [anon_sym_DASH] = ACTIONS(537),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(537),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(537),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_when] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(423),
    [anon_sym_into] = ACTIONS(429),
    [anon_sym_DOT_DOT] = ACTIONS(543),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [93] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2790),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1785),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(854),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(93),
    [sym_identifier] = ACTIONS(527),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(529),
    [anon_sym_async] = ACTIONS(531),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(533),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_EQ_GT] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(535),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS_PLUS] = ACTIONS(535),
    [anon_sym_DASH_DASH] = ACTIONS(535),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(537),
    [anon_sym_DASH] = ACTIONS(537),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(537),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(537),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_when] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(541),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(423),
    [anon_sym_into] = ACTIONS(401),
    [anon_sym_DOT_DOT] = ACTIONS(543),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [94] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2824),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1785),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(911),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(94),
    [sym_identifier] = ACTIONS(527),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(545),
    [anon_sym_async] = ACTIONS(547),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(549),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_EQ_GT] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(551),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_PLUS_PLUS] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(551),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_STAR] = ACTIONS(553),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(553),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(553),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_when] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(557),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(559),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [95] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2824),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1785),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(899),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(95),
    [sym_identifier] = ACTIONS(527),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(545),
    [anon_sym_async] = ACTIONS(547),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(549),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_EQ_GT] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(551),
    [anon_sym_BANG] = ACTIONS(553),
    [anon_sym_PLUS_PLUS] = ACTIONS(551),
    [anon_sym_DASH_DASH] = ACTIONS(551),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(553),
    [anon_sym_DASH] = ACTIONS(553),
    [anon_sym_STAR] = ACTIONS(553),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(553),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(553),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(555),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_when] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(557),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(559),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [96] = {
    [sym__name] = STATE(2148),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(975),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(1088),
    [sym_parameter_list] = STATE(2860),
    [sym__type] = STATE(2147),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(1108),
    [sym_lambda_expression] = STATE(1108),
    [sym_anonymous_object_creation_expression] = STATE(1108),
    [sym_array_creation_expression] = STATE(1108),
    [sym_initializer_expression] = STATE(1108),
    [sym_assignment_expression] = STATE(1108),
    [sym_await_expression] = STATE(1108),
    [sym_cast_expression] = STATE(1108),
    [sym_checked_expression] = STATE(1108),
    [sym_conditional_access_expression] = STATE(1108),
    [sym_conditional_expression] = STATE(1108),
    [sym_default_expression] = STATE(1108),
    [sym_element_access_expression] = STATE(1108),
    [sym_element_binding_expression] = STATE(1108),
    [sym_implicit_array_creation_expression] = STATE(1108),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(1108),
    [sym_base_expression] = STATE(1108),
    [sym_this_expression] = STATE(1108),
    [sym_interpolated_string_expression] = STATE(1108),
    [sym_invocation_expression] = STATE(1108),
    [sym_is_pattern_expression] = STATE(1108),
    [sym_make_ref_expression] = STATE(1108),
    [sym_member_access_expression] = STATE(1108),
    [sym_member_binding_expression] = STATE(1108),
    [sym_object_creation_expression] = STATE(1108),
    [sym_parenthesized_expression] = STATE(1108),
    [sym_postfix_unary_expression] = STATE(1108),
    [sym_prefix_unary_expression] = STATE(1108),
    [sym_query_expression] = STATE(1108),
    [sym_from_clause] = STATE(1790),
    [sym_range_expression] = STATE(1108),
    [sym_ref_expression] = STATE(1108),
    [sym_ref_type_expression] = STATE(1108),
    [sym_ref_value_expression] = STATE(1108),
    [sym_size_of_expression] = STATE(1108),
    [sym_stack_alloc_array_creation_expression] = STATE(1108),
    [sym_switch_expression] = STATE(1108),
    [sym_throw_expression] = STATE(1108),
    [sym_tuple_expression] = STATE(1108),
    [sym_type_of_expression] = STATE(1108),
    [sym__expression] = STATE(945),
    [sym_binary_expression] = STATE(1108),
    [sym__literal] = STATE(1108),
    [sym_boolean_literal] = STATE(1086),
    [sym_character_literal] = STATE(1086),
    [sym_string_literal] = STATE(1086),
    [sym__reserved_identifier] = STATE(1108),
    [sym_preprocessor_call] = STATE(96),
    [sym_identifier] = ACTIONS(561),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_DOT] = ACTIONS(563),
    [anon_sym_LBRACK] = ACTIONS(565),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(567),
    [anon_sym_async] = ACTIONS(569),
    [anon_sym_new] = ACTIONS(571),
    [anon_sym_ref] = ACTIONS(573),
    [anon_sym_in] = ACTIONS(401),
    [anon_sym_this] = ACTIONS(575),
    [anon_sym_base] = ACTIONS(577),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(581),
    [anon_sym_BANG] = ACTIONS(583),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_true] = ACTIONS(585),
    [anon_sym_false] = ACTIONS(585),
    [anon_sym_PLUS] = ACTIONS(583),
    [anon_sym_DASH] = ACTIONS(583),
    [anon_sym_STAR] = ACTIONS(583),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_PERCENT] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_delegate] = ACTIONS(587),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(401),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(589),
    [anon_sym_unchecked] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(591),
    [anon_sym_default] = ACTIONS(593),
    [anon_sym_switch] = ACTIONS(401),
    [anon_sym_throw] = ACTIONS(595),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(399),
    [anon_sym_stackalloc] = ACTIONS(597),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(601),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(603),
    [anon_sym_is] = ACTIONS(401),
    [anon_sym___makeref] = ACTIONS(605),
    [anon_sym_DASH_GT] = ACTIONS(399),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(607),
    [anon_sym___reftype] = ACTIONS(609),
    [anon_sym___refvalue] = ACTIONS(611),
    [anon_sym_sizeof] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(401),
    [anon_sym_as] = ACTIONS(401),
    [sym_global] = ACTIONS(617),
    [anon_sym_SQUOTE] = ACTIONS(619),
    [sym_integer_literal] = ACTIONS(621),
    [sym_null_literal] = ACTIONS(621),
    [sym_real_literal] = ACTIONS(621),
    [sym_verbatim_string_literal] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [97] = {
    [sym__name] = STATE(2148),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(975),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(1088),
    [sym_parameter_list] = STATE(2860),
    [sym__type] = STATE(2147),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(1108),
    [sym_lambda_expression] = STATE(1108),
    [sym_anonymous_object_creation_expression] = STATE(1108),
    [sym_array_creation_expression] = STATE(1108),
    [sym_initializer_expression] = STATE(1108),
    [sym_assignment_expression] = STATE(1108),
    [sym_await_expression] = STATE(1108),
    [sym_cast_expression] = STATE(1108),
    [sym_checked_expression] = STATE(1108),
    [sym_conditional_access_expression] = STATE(1108),
    [sym_conditional_expression] = STATE(1108),
    [sym_default_expression] = STATE(1108),
    [sym_element_access_expression] = STATE(1108),
    [sym_element_binding_expression] = STATE(1108),
    [sym_implicit_array_creation_expression] = STATE(1108),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(1108),
    [sym_base_expression] = STATE(1108),
    [sym_this_expression] = STATE(1108),
    [sym_interpolated_string_expression] = STATE(1108),
    [sym_invocation_expression] = STATE(1108),
    [sym_is_pattern_expression] = STATE(1108),
    [sym_make_ref_expression] = STATE(1108),
    [sym_member_access_expression] = STATE(1108),
    [sym_member_binding_expression] = STATE(1108),
    [sym_object_creation_expression] = STATE(1108),
    [sym_parenthesized_expression] = STATE(1108),
    [sym_postfix_unary_expression] = STATE(1108),
    [sym_prefix_unary_expression] = STATE(1108),
    [sym_query_expression] = STATE(1108),
    [sym_from_clause] = STATE(1790),
    [sym_range_expression] = STATE(1108),
    [sym_ref_expression] = STATE(1108),
    [sym_ref_type_expression] = STATE(1108),
    [sym_ref_value_expression] = STATE(1108),
    [sym_size_of_expression] = STATE(1108),
    [sym_stack_alloc_array_creation_expression] = STATE(1108),
    [sym_switch_expression] = STATE(1108),
    [sym_throw_expression] = STATE(1108),
    [sym_tuple_expression] = STATE(1108),
    [sym_type_of_expression] = STATE(1108),
    [sym__expression] = STATE(961),
    [sym_binary_expression] = STATE(1108),
    [sym__literal] = STATE(1108),
    [sym_boolean_literal] = STATE(1086),
    [sym_character_literal] = STATE(1086),
    [sym_string_literal] = STATE(1086),
    [sym__reserved_identifier] = STATE(1108),
    [sym_preprocessor_call] = STATE(97),
    [sym_identifier] = ACTIONS(561),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(563),
    [anon_sym_LBRACK] = ACTIONS(565),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(567),
    [anon_sym_async] = ACTIONS(569),
    [anon_sym_new] = ACTIONS(571),
    [anon_sym_ref] = ACTIONS(573),
    [anon_sym_in] = ACTIONS(429),
    [anon_sym_this] = ACTIONS(575),
    [anon_sym_base] = ACTIONS(577),
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_TILDE] = ACTIONS(581),
    [anon_sym_BANG] = ACTIONS(583),
    [anon_sym_PLUS_PLUS] = ACTIONS(581),
    [anon_sym_DASH_DASH] = ACTIONS(581),
    [anon_sym_true] = ACTIONS(585),
    [anon_sym_false] = ACTIONS(585),
    [anon_sym_PLUS] = ACTIONS(583),
    [anon_sym_DASH] = ACTIONS(583),
    [anon_sym_STAR] = ACTIONS(583),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(427),
    [anon_sym_delegate] = ACTIONS(587),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_QMARK] = ACTIONS(429),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(589),
    [anon_sym_unchecked] = ACTIONS(589),
    [anon_sym_await] = ACTIONS(591),
    [anon_sym_default] = ACTIONS(593),
    [anon_sym_switch] = ACTIONS(429),
    [anon_sym_throw] = ACTIONS(595),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(427),
    [anon_sym_stackalloc] = ACTIONS(597),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(601),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(603),
    [anon_sym_is] = ACTIONS(429),
    [anon_sym___makeref] = ACTIONS(605),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(607),
    [anon_sym___reftype] = ACTIONS(609),
    [anon_sym___refvalue] = ACTIONS(611),
    [anon_sym_sizeof] = ACTIONS(613),
    [anon_sym_typeof] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_as] = ACTIONS(429),
    [sym_global] = ACTIONS(617),
    [anon_sym_SQUOTE] = ACTIONS(619),
    [sym_integer_literal] = ACTIONS(621),
    [sym_null_literal] = ACTIONS(621),
    [sym_real_literal] = ACTIONS(621),
    [sym_verbatim_string_literal] = ACTIONS(623),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [98] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2831),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(1911),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(660),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(98),
    [aux_sym_event_field_declaration_repeat2] = STATE(1359),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_using] = ACTIONS(625),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(49),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(49),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_foreach] = ACTIONS(627),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [99] = {
    [sym__name] = STATE(2054),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(833),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_modifier] = STATE(1749),
    [sym_variable_declaration] = STATE(2831),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(1911),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(660),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(99),
    [aux_sym_event_field_declaration_repeat2] = STATE(1359),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_extern] = ACTIONS(49),
    [anon_sym_using] = ACTIONS(629),
    [anon_sym_static] = ACTIONS(49),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(49),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(49),
    [anon_sym_fixed] = ACTIONS(49),
    [anon_sym_internal] = ACTIONS(49),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_override] = ACTIONS(49),
    [anon_sym_partial] = ACTIONS(49),
    [anon_sym_private] = ACTIONS(49),
    [anon_sym_protected] = ACTIONS(49),
    [anon_sym_public] = ACTIONS(49),
    [anon_sym_readonly] = ACTIONS(49),
    [anon_sym_ref] = ACTIONS(69),
    [anon_sym_sealed] = ACTIONS(49),
    [anon_sym_unsafe] = ACTIONS(49),
    [anon_sym_virtual] = ACTIONS(49),
    [anon_sym_volatile] = ACTIONS(49),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_foreach] = ACTIONS(631),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [100] = {
    [sym__name] = STATE(2152),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(572),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(2170),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(647),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(100),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_extern] = ACTIONS(633),
    [anon_sym_static] = ACTIONS(633),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_abstract] = ACTIONS(633),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_const] = ACTIONS(633),
    [anon_sym_fixed] = ACTIONS(633),
    [anon_sym_internal] = ACTIONS(633),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_override] = ACTIONS(633),
    [anon_sym_partial] = ACTIONS(633),
    [anon_sym_private] = ACTIONS(633),
    [anon_sym_protected] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(633),
    [anon_sym_readonly] = ACTIONS(633),
    [anon_sym_ref] = ACTIONS(435),
    [anon_sym_sealed] = ACTIONS(633),
    [anon_sym_unsafe] = ACTIONS(633),
    [anon_sym_virtual] = ACTIONS(633),
    [anon_sym_volatile] = ACTIONS(633),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(143),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_void_keyword] = ACTIONS(633),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [101] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2673),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(2008),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2742),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(974),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(101),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [102] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2718),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(1925),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2716),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(969),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(102),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [103] = {
    [sym__name] = STATE(1906),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(1079),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_target_specifier] = STATE(2056),
    [sym_attribute] = STATE(2539),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2553),
    [sym_parameter_list] = STATE(2839),
    [sym__type] = STATE(2096),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(877),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(103),
    [sym_identifier] = ACTIONS(651),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_field] = ACTIONS(653),
    [anon_sym_event] = ACTIONS(653),
    [anon_sym_method] = ACTIONS(653),
    [anon_sym_param] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_return] = ACTIONS(653),
    [anon_sym_type] = ACTIONS(653),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(655),
    [anon_sym_out] = ACTIONS(657),
    [anon_sym_in] = ACTIONS(657),
    [anon_sym_this] = ACTIONS(73),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [104] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2718),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(2010),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2680),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(969),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(104),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [105] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2673),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(1958),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2716),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(974),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(105),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [106] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2718),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(1925),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2680),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(969),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(106),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [107] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2673),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(2014),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2742),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(974),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(107),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [108] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2718),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(2010),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2716),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(969),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(108),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [anon_sym_DOLLAR_AT_DQUOTE] = ACTIONS(127),
    [anon_sym___makeref] = ACTIONS(129),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(133),
    [anon_sym___reftype] = ACTIONS(135),
    [anon_sym___refvalue] = ACTIONS(137),
    [anon_sym_sizeof] = ACTIONS(139),
    [anon_sym_typeof] = ACTIONS(141),
    [sym_global] = ACTIONS(649),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_integer_literal] = ACTIONS(147),
    [sym_null_literal] = ACTIONS(147),
    [sym_real_literal] = ACTIONS(147),
    [sym_verbatim_string_literal] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
    [sym_preprocessor_directive] = ACTIONS(5),
  },
  [109] = {
    [sym__name] = STATE(2031),
    [sym_alias_qualified_name] = STATE(1771),
    [sym__simple_name] = STATE(934),
    [sym_generic_name] = STATE(524),
    [sym_qualified_name] = STATE(1771),
    [sym_attribute_list] = STATE(1903),
    [sym_name_colon] = STATE(148),
    [sym_bracketed_argument_list] = STATE(573),
    [sym_argument] = STATE(2673),
    [sym_parameter_list] = STATE(2839),
    [sym__formal_parameter_list] = STATE(2922),
    [sym_parameter] = STATE(2576),
    [sym_parameter_modifier] = STATE(1858),
    [sym_parameter_array] = STATE(2576),
    [sym__type] = STATE(2008),
    [sym_implicit_type] = STATE(1777),
    [sym_array_type] = STATE(1777),
    [sym_nullable_type] = STATE(1777),
    [sym_pointer_type] = STATE(1777),
    [sym_tuple_type] = STATE(1777),
    [sym_tuple_element] = STATE(2716),
    [sym_anonymous_method_expression] = STATE(649),
    [sym_lambda_expression] = STATE(649),
    [sym_anonymous_object_creation_expression] = STATE(649),
    [sym_array_creation_expression] = STATE(649),
    [sym_initializer_expression] = STATE(649),
    [sym_assignment_expression] = STATE(649),
    [sym_await_expression] = STATE(649),
    [sym_cast_expression] = STATE(649),
    [sym_checked_expression] = STATE(649),
    [sym_conditional_access_expression] = STATE(649),
    [sym_conditional_expression] = STATE(649),
    [sym_declaration_expression] = STATE(2554),
    [sym_default_expression] = STATE(649),
    [sym_element_access_expression] = STATE(649),
    [sym_element_binding_expression] = STATE(649),
    [sym_implicit_array_creation_expression] = STATE(649),
    [sym_implicit_stack_alloc_array_creation_expression] = STATE(649),
    [sym_base_expression] = STATE(649),
    [sym_this_expression] = STATE(649),
    [sym_interpolated_string_expression] = STATE(649),
    [sym_invocation_expression] = STATE(649),
    [sym_is_pattern_expression] = STATE(649),
    [sym_make_ref_expression] = STATE(649),
    [sym_member_access_expression] = STATE(649),
    [sym_member_binding_expression] = STATE(649),
    [sym_object_creation_expression] = STATE(649),
    [sym_parenthesized_expression] = STATE(649),
    [sym_postfix_unary_expression] = STATE(649),
    [sym_prefix_unary_expression] = STATE(649),
    [sym_query_expression] = STATE(649),
    [sym_from_clause] = STATE(1779),
    [sym_range_expression] = STATE(649),
    [sym_ref_expression] = STATE(649),
    [sym_ref_type_expression] = STATE(649),
    [sym_ref_value_expression] = STATE(649),
    [sym_size_of_expression] = STATE(649),
    [sym_stack_alloc_array_creation_expression] = STATE(649),
    [sym_switch_expression] = STATE(649),
    [sym_throw_expression] = STATE(649),
    [sym_tuple_expression] = STATE(649),
    [sym_type_of_expression] = STATE(649),
    [sym__expression] = STATE(974),
    [sym_binary_expression] = STATE(649),
    [sym__literal] = STATE(649),
    [sym_boolean_literal] = STATE(580),
    [sym_character_literal] = STATE(580),
    [sym_string_literal] = STATE(580),
    [sym__reserved_identifier] = STATE(649),
    [sym_preprocessor_call] = STATE(109),
    [aux_sym_event_field_declaration_repeat1] = STATE(1746),
    [sym_identifier] = ACTIONS(635),
    [anon_sym_DOT] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_async] = ACTIONS(433),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_ref] = ACTIONS(641),
    [anon_sym_out] = ACTIONS(643),
    [anon_sym_in] = ACTIONS(643),
    [anon_sym_this] = ACTIONS(645),
    [anon_sym_params] = ACTIONS(647),
    [anon_sym_base] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(79),
    [anon_sym_DASH_DASH] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(83),
    [anon_sym_DASH] = ACTIONS(83),
    [anon_sym_STAR] = ACTIONS(79),
    [anon_sym_CARET] = ACTIONS(79),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_delegate] = ACTIONS(85),
    [anon_sym_var] = ACTIONS(39),
    [sym_predefined_type] = ACTIONS(41),
    [anon_sym_checked] = ACTIONS(417),
    [anon_sym_unchecked] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(325),
    [anon_sym_throw] = ACTIONS(439),
    [anon_sym_stackalloc] = ACTIONS(121),
    [anon_sym_DOLLAR_DQUOTE] = ACTIONS(123),
    [anon_sym_DQUOTE] = ACTIONS(125),
    [an