// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AppChooser;
use Bin;
use Buildable;
use CellEditable;
use CellLayout;
use ComboBox;
use Container;
use Widget;
use ffi;
use gio;
use glib;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use libc;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct AppChooserButton(Object<ffi::GtkAppChooserButton, ffi::GtkAppChooserButtonClass>): ComboBox, Bin, Container, Widget, Buildable, CellEditable, CellLayout, AppChooser;

    match fn {
        get_type => || ffi::gtk_app_chooser_button_get_type(),
    }
}

impl AppChooserButton {
    pub fn new(content_type: &str) -> AppChooserButton {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_app_chooser_button_new(content_type.to_glib_none().0)).downcast_unchecked()
        }
    }
}

pub trait AppChooserButtonExt {
    fn append_custom_item<P: IsA<gio::Icon>>(&self, name: &str, label: &str, icon: &P);

    fn append_separator(&self);

    fn get_heading(&self) -> Option<String>;

    fn get_show_default_item(&self) -> bool;

    fn get_show_dialog_item(&self) -> bool;

    fn set_active_custom_item(&self, name: &str);

    fn set_heading(&self, heading: &str);

    fn set_show_default_item(&self, setting: bool);

    fn set_show_dialog_item(&self, setting: bool);

    fn connect_custom_item_activated<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_heading_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_show_default_item_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_show_dialog_item_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<AppChooserButton> + IsA<glib::object::Object>> AppChooserButtonExt for O {
    fn append_custom_item<P: IsA<gio::Icon>>(&self, name: &str, label: &str, icon: &P) {
        unsafe {
            ffi::gtk_app_chooser_button_append_custom_item(self.to_glib_none().0, name.to_glib_none().0, label.to_glib_none().0, icon.to_glib_none().0);
        }
    }

    fn append_separator(&self) {
        unsafe {
            ffi::gtk_app_chooser_button_append_separator(self.to_glib_none().0);
        }
    }

    fn get_heading(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_app_chooser_button_get_heading(self.to_glib_none().0))
        }
    }

    fn get_show_default_item(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_app_chooser_button_get_show_default_item(self.to_glib_none().0))
        }
    }

    fn get_show_dialog_item(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_app_chooser_button_get_show_dialog_item(self.to_glib_none().0))
        }
    }

    fn set_active_custom_item(&self, name: &str) {
        unsafe {
            ffi::gtk_app_chooser_button_set_active_custom_item(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn set_heading(&self, heading: &str) {
        unsafe {
            ffi::gtk_app_chooser_button_set_heading(self.to_glib_none().0, heading.to_glib_none().0);
        }
    }

    fn set_show_default_item(&self, setting: bool) {
        unsafe {
            ffi::gtk_app_chooser_button_set_show_default_item(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn set_show_dialog_item(&self, setting: bool) {
        unsafe {
            ffi::gtk_app_chooser_button_set_show_dialog_item(self.to_glib_none().0, setting.to_glib());
        }
    }

    fn connect_custom_item_activated<F: Fn(&Self, &str) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &str) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "custom-item-activated",
                transmute(custom_item_activated_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_heading_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::heading",
                transmute(notify_heading_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_show_default_item_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::show-default-item",
                transmute(notify_show_default_item_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_show_dialog_item_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::show-dialog-item",
                transmute(notify_show_dialog_item_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn custom_item_activated_trampoline<P>(this: *mut ffi::GtkAppChooserButton, item_name: *mut libc::c_char, f: glib_ffi::gpointer)
where P: IsA<AppChooserButton> {
    let f: &&(Fn(&P, &str) + 'static) = transmute(f);
    f(&AppChooserButton::from_glib_borrow(this).downcast_unchecked(), &String::from_glib_none(item_name))
}

unsafe extern "C" fn notify_heading_trampoline<P>(this: *mut ffi::GtkAppChooserButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<AppChooserButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&AppChooserButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_show_default_item_trampoline<P>(this: *mut ffi::GtkAppChooserButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<AppChooserButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&AppChooserButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_show_dialog_item_trampoline<P>(this: *mut ffi::GtkAppChooserButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<AppChooserButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&AppChooserButton::from_glib_borrow(this).downcast_unchecked())
}
