#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;

use lib 'lib';
use Data::Dumper;
use Database::Filter;
use OPTIMADE::Filter::Parser;

binmode( STDOUT, 'utf8' );

my @test_cases = (
    "a < 0",
    "(a < 0)",

    "a < 0 AND c >= \"d\"",
    "(a < 0) AND (c >= \"d\")",

    "a < 0 AND c <= 0",

    "a < 0 AND NOT c <= 0",
    "(a < 0) AND (NOT (c <= 0))",

    "(a != \"bbb\" AND c = 0) OR d != 0",
    "a != \"bbb\" AND c = 0 OR d != 0",
    "a != \"bbb\" OR c = 0 AND d != 0",

    "(((( (((a != \"bbb\" OR c = 0))) AND (((d != 0))) ))))",
    "(((a != \"bbb\") OR (c = 0)) AND (d != 0))",
);

eval {
    local $\ = "\n";
    for my $case (@test_cases) {
        my $parser = new OPTIMADE::Filter::Parser;
        print $case;
        my $tree = $parser->parse_string( $case );
        my $filter = Database::Filter->new_from_tree( $tree );
        my $filter_string = $filter->filter->to_SQL( { delim => '`' } );
        print $filter_string;
        print '';
    }
};
if( $@ ) {
    print STDERR $@;
}
