# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from AssetStripConfig.idl.

use strict;

package Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "assetmgrmodel.AssetStripConfig:1.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::StripSettings;

sub getStripSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getStripSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::StripSettings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::StripSettings;

sub setStripSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::StripSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setStripSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings;

sub getRackUnitSettings($$$) {
    my ($self, $rackUnitNumber, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rackUnitNumber'} = 1 * $rackUnitNumber;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getRackUnitSettings', $args);
    $$settings = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings::decode($agent, $rsp->{'settings'});
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings;

sub getAllRackUnitSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getAllRackUnitSettings', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings;

sub setRackUnitSettings($$$) {
    my ($self, $rackUnitNumber, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rackUnitNumber'} = 1 * $rackUnitNumber;
    $args->{'settings'} = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setRackUnitSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings;

sub setMultipleRackUnitSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = [];
    foreach my $key0 (keys %{$settings}) {
        my $value0 = $settings->{$key0};
        my $elem0 = {};
        $elem0->{'key'} = 1 * $key0;
        $elem0->{'value'} = Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1::RackUnitSettings::encode($value0);
        push(@{$args->{'settings'}}, $elem0);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setMultipleRackUnitSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('assetmgrmodel.AssetStripConfig', 1, 0, 1, 'Raritan::RPC::assetmgrmodel::AssetStripConfig_1_0_1');
1;
