% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_descriptions.R
\name{param_kappa}
\alias{param_kappa}
\title{Parameter Description: Kappa}
\arguments{
\item{kappa}{A numeric value >= 0. A \code{kappa != 1} will be used for the specification 
of the shape of the Weibull distribution. 
Default is \code{1}, i.e., the exponential survival distribution is used instead of the Weibull distribution.
Note that the Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution, i.e., only \code{lambda} and \code{kappa} need to be specified.
This function is equivalent to \code{pweibull(t, shape = kappa, scale = 1 / lambda)} 
of the \code{stats} package, i.e., 
the scale parameter is \code{1 / 'hazard rate'}.\cr
For example, \cr
\code{getPiecewiseExponentialDistribution(time = 130, piecewiseLambda = 0.01, kappa = 4.2)} 
and \code{pweibull(q = 130, shape = 4.2, scale = 1 / 0.01)} provide the sample result.}
}
\description{
Parameter Description: Kappa
}
\keyword{internal}
