% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_list.R
\name{export_list}
\alias{export_list}
\title{Export list of data frames to files}
\usage{
export_list(x, file, ...)
}
\arguments{
\item{x}{A list of data frames to be written to files.}

\item{file}{A character vector string containing a single file name with a \code{\%s} wildcard placeholder, or a vector of file paths for multiple files to be imported. If \code{x} elements are named, these will be used in place of \code{\%s}, otherwise numbers will be used; all elements must be named for names to be used.}

\item{\dots}{Additional arguments passed to \code{\link{export}}.}
}
\value{
The name(s) of the output file(s) as a character vector (invisibly).
}
\description{
Use \code{\link{export}} to export a list of data frames to a vector of file names or a filename pattern.
}
\details{
\code{\link{export}} can export a list of data frames to a single multi-dataset file (e.g., an Rdata or Excel .xlsx file). Use \code{export_list} to export such a list to \emph{multiple} files.
}
\examples{
library('datasets')
export(list(mtcars1 = mtcars[1:10,], 
            mtcars2 = mtcars[11:20,],
            mtcars3 = mtcars[21:32,]),
    xlsx_file <- tempfile(fileext = ".xlsx")
)

# import all worksheets
mylist <- import_list(xlsx_file)

# re-export as separate named files
csv_files1 <- sapply(1:3, function(x) tempfile(fileext = paste0("-", x, ".csv")))
export_list(mylist, file = csv_files1)

# re-export as separate files using a name pattern
export_list(mylist, file = csv_files2 <- tempfile(fileext = "\%s.csv"))

# cleanup
unlink(xlsx_file)
unlink(csv_files1)
unlink(csv_files2)

}
\seealso{
\code{\link{import}}, \code{\link{import_list}}, \code{\link{export}}
}
