% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{read_file}
\alias{read_file}
\alias{read_file_raw}
\alias{write_file}
\title{Read/write a complete file}
\usage{
read_file(file, locale = default_locale())

read_file_raw(file)

write_file(x, file, append = FALSE, path = deprecated())
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{x}{A single string, or a raw vector to write to disk.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if the file does not exist a new
file is created.}

\item{path}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}
}
\value{
\code{read_file}: A length 1 character vector.
\code{read_lines_raw}: A raw vector.
}
\description{
\code{read_file()} reads a complete file into a single object: either a
character vector of length one, or a raw vector. \code{write_file()} takes a
single string, or a raw vector, and writes it exactly as is.  Raw vectors
are useful when dealing with binary data, or if you have text data with
unknown encoding.
}
\examples{
read_file(file.path(R.home("doc"), "AUTHORS"))
read_file_raw(file.path(R.home("doc"), "AUTHORS"))

tmp <- tempfile()

x <- format_csv(mtcars[1:6, ])
write_file(x, tmp)
identical(x, read_file(tmp))

read_lines(x)
}
