% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{performances}
\alias{performances}
\alias{performances.vselsummary}
\alias{performances.vsel}
\title{Predictive performance results}
\usage{
performances(object, ...)

\method{performances}{vselsummary}(object, ...)

\method{performances}{vsel}(object, ...)
}
\arguments{
\item{object}{The object from which to retrieve the predictive performance
results. Possible classes may be inferred from the names of the
corresponding methods (see also the description).}

\item{...}{For \code{\link[=performances.vsel]{performances.vsel()}}: arguments passed to \code{\link[=summary.vsel]{summary.vsel()}}.
For \code{\link[=performances.vselsummary]{performances.vselsummary()}}: currently ignored.}
}
\value{
An object of class \code{performances} which is a \code{list} with the
following elements:
\itemize{
\item \code{submodels}: The predictive performance results for the submodels, as a
\code{data.frame}.
\item \code{reference_model}: The predictive performance results for the reference
model, as a named vector.
}
}
\description{
Retrieves the predictive performance summaries after running \code{\link[=varsel]{varsel()}} or
\code{\link[=cv_varsel]{cv_varsel()}}. These summaries are computed by \code{\link[=summary.vsel]{summary.vsel()}}, so the main
method of \code{\link[=performances]{performances()}} is \code{\link[=performances.vselsummary]{performances.vselsummary()}} (objects of class
\code{vselsummary} are returned by \code{\link[=summary.vsel]{summary.vsel()}}). As a shortcut method,
\code{\link[=performances.vsel]{performances.vsel()}} is provided as well (objects of class \code{vsel} are
returned by \code{\link[=varsel]{varsel()}} and \code{\link[=cv_varsel]{cv_varsel()}}). For a graphical representation,
see \code{\link[=plot.vsel]{plot.vsel()}}.
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The `stanreg` fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Run varsel() (here without cross-validation, with L1 search, and with small
# values for `nterms_max` and `nclusters_pred`, but only for the sake of
# speed in this example; this is not recommended in general):
vs <- varsel(fit, method = "L1", nterms_max = 3, nclusters_pred = 10,
             seed = 5555)
print(performances(vs))
\dontshow{\}) # examplesIf}
}
