% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brackets.R
\name{color_brackets}
\alias{color_brackets}
\title{Colored brackets}
\usage{
color_brackets(x, color_seq = list(yellow, blue, cyan))
}
\arguments{
\item{x}{a character vector of brackets consisting of a valid sequence of any
of the following: \code{'[[', '[', ']', '(', ')', '{', '}'}}

\item{color_seq}{a list of functions that take and return a character scalar}
}
\description{
Add color to brackets. Brackets will be coloured consecutively with the
colors provided in \code{color_seq} by scope.
}
\details{
Meant for coloring brackets encountered within \code{highlight}.
Note that occurrences of 'orphan' brackets are not taken into account
mainly due to the fact that cases such as

\code{foo <- function(x){ `[`(x, 1) }}

will either be converted to

\code{foo <- function(x){ x[1]}}

before the brackets are coloured if passed in as
\code{highlight(deparse(foo))} or will be identified as a
'SYMBOL_FUNCTION_CALL' token instead of 'LBB' if passed in as

\code{highlight("foo <- function(x){ `[`(x, 1) }")}

Similarly, invalid code that would lead to orphaned brackets is not taken
into account as this would be caught before hand in \code{highlight}.
}
\keyword{internal}
