% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{lines.survtab}
\alias{lines.survtab}
\title{\code{lines} method for survtab objects}
\usage{
\method{lines}{survtab}(x, y = NULL, subset = NULL, conf.int = TRUE,
  col = NULL, lty = NULL, ...)
}
\arguments{
\item{x}{a \code{survtab} output object}

\item{y}{a variable to plot; a quoted name of a variable
in \code{x}; e.g. \code{y = "surv.obs"};
if \code{NULL}, picks last survival variable column in order in \code{x}}

\item{subset}{a logical condition; \code{obj} is subset accordingly 
before plotting; use this for limiting to specific strata, 
e.g. \code{subset = sex == "male"}}

\item{conf.int}{logical; if \code{TRUE}, also plots any confidence intervals
present in \code{obj} for variables in \code{y}}

\item{col}{line colour passed to \code{matlines}}

\item{lty}{line type passed to \code{matlines}}

\item{...}{additional arguments passed on to to a \code{matlines} call;
e.g. \code{lwd} can be defined this way}
}
\description{
Plot \code{lines} from a \code{survtab} object
}
\examples{
data(sire)
data(sibr)
si <- rbind(sire, sibr)
si$period <- cut(si$dg_date, as.Date(c("1993-01-01", "2004-01-01", "2013-01-01")), right = FALSE)
si$cancer <- c(rep("rectal", nrow(sire)), rep("breast", nrow(sibr)))
x <- lexpand(si, birth = bi_date, entry = dg_date, exit = ex_date, 
             status = status \%in\% 1:2, 
             fot = 0:5, aggre = list(cancer, period, fot))
st <- survtab_ag(fot ~ cancer + period, data = x, 
                 surv.method = "lifetable", surv.type = "surv.obs")

plot(st, "surv.obs", subset = cancer == "breast", ylim = c(0.5, 1), col = "blue")
lines(st, "surv.obs", subset = cancer == "rectal", col = "red")

## or
plot(st, "surv.obs", col = c(2,2,4,4), lty = c(1, 2, 1, 2))
}
\seealso{
Other survtab functions: \code{\link{Surv}},
  \code{\link{plot.survtab}}, \code{\link{print.survtab}},
  \code{\link{summary.survtab}}, \code{\link{survtab_ag}},
  \code{\link{survtab}}
}
\author{
Joonas Miettinen
}
\concept{survtab functions}
