% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cgam.R, R/methods_mgcv.R,
%   R/methods_other.R, R/methods_scam.R
\name{model_parameters.cgam}
\alias{model_parameters.cgam}
\alias{model_parameters.gamm}
\alias{model_parameters.Gam}
\alias{model_parameters.scam}
\title{Parameters from Generalized Additive (Mixed) Models}
\usage{
\method{model_parameters}{cgam}(
  model,
  ci = 0.95,
  ci_method = "residual",
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  keep = NULL,
  drop = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{gamm}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  verbose = TRUE,
  ...
)

\method{model_parameters}{Gam}(
  model,
  es_type = NULL,
  df_error = NULL,
  type = NULL,
  table_wide = FALSE,
  verbose = TRUE,
  ...
)

\method{model_parameters}{scam}(
  model,
  ci = 0.95,
  ci_method = "residual",
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  keep = NULL,
  drop = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A gam/gamm model.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{ci_method}{Method for computing degrees of freedom for
confidence intervals (CI) and the related p-values. Allowed are following
options (which vary depending on the model class): \code{"residual"},
\code{"normal"}, \code{"likelihood"}, \code{"satterthwaite"}, \code{"kenward"}, \code{"wald"},
\code{"profile"}, \code{"boot"}, \code{"uniroot"}, \code{"ml1"}, \code{"betwithin"}, \code{"hdi"},
\code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, or \code{"bcai"}. See section
\emph{Confidence intervals and approximation of degrees of freedom} in
\code{\link[=model_parameters]{model_parameters()}} for further details. When \code{ci_method=NULL}, in most
cases \code{"wald"} is used then.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{NULL} (default; no standardization), \code{"refit"} (for re-fitting the model
on standardized data) or one of \code{"basic"}, \code{"posthoc"}, \code{"smart"},
\code{"pseudo"}. See 'Details' in \code{\link[=standardize_parameters]{standardize_parameters()}}.
\strong{Importantly}:
\itemize{
\item The \code{"refit"} method does \emph{not} standardize categorical predictors (i.e.
factors), which may be a different behaviour compared to other R packages
(such as \strong{lm.beta}) or other software packages (like SPSS). to mimic
such behaviours, either use \code{standardize="basic"} or standardize the data
with \code{datawizard::standardize(force=TRUE)} \emph{before} fitting the model.
\item For mixed models, when using methods other than \code{"refit"}, only the fixed
effects will be standardized.
\item Robust estimation (i.e., \code{vcov} set to a value other than \code{NULL}) of
standardized parameters only works when \code{standardize="refit"}.
}}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log or
logit links. It is also recommended to use \code{exponentiate = TRUE} for models
with log-transformed response values. \strong{Note:} Delta-method standard
errors are also computed (by multiplying the standard errors by the
transformed coefficients). This is to mimic behaviour of other software
packages, such as Stata, but these standard errors poorly estimate
uncertainty for the transformed coefficient. The transformed confidence
interval more clearly captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients from
non-Gaussian families.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats:p.adjust]{stats::p.adjust()}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \strong{emmeans}).}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{keep} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{See \code{keep}.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are passed down to
\code{bootstrap_model()}. Further non-documented arguments are \code{digits},
\code{p_digits}, \code{ci_digits} and \code{footer_digits} to set the number of digits for
the output. If \code{s_value = TRUE}, the p-value will be replaced by the
S-value in the output (cf. \emph{Rafi and Greenland 2020}). \code{pd} adds an
additional column with the \emph{probability of direction} (see
\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}} for details). \code{groups} can be used to group
coefficients. It will be passed to the print-method, or can directly be
used in \code{print()}, see documentation in \code{\link[=print.parameters_model]{print.parameters_model()}}.
Furthermore, see 'Examples' for this function. For developers, whose
interest mainly is to get a "tidy" data frame of model summaries, it is
recommended to set \code{pretty_names = FALSE} to speed up computation of the
summary table.}

\item{es_type}{The effect size of interest. Not that possibly not all
effect sizes are applicable to the model object. See 'Details'. For Anova
models, can also be a character vector with multiple effect size names.}

\item{df_error}{Denominator degrees of freedom (or degrees of freedom of the
error estimate, i.e., the residuals). This is used to compute effect sizes
for ANOVA-tables from mixed models. See 'Examples'. (Ignored for
\code{afex_aov}.)}

\item{type}{Numeric, type of sums of squares. May be 1, 2 or 3. If 2 or 3,
ANOVA-tables using \code{car::Anova()} will be returned. (Ignored for
\code{afex_aov}.)}

\item{table_wide}{Logical that decides whether the ANOVA table should be in
wide format, i.e. should the numerator and denominator degrees of freedom
be in the same row. Default: \code{FALSE}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Extract and compute indices and measures to describe parameters
of generalized additive models (GAM(M)s).
}
\details{
The reporting of degrees of freedom \emph{for the spline terms}
slightly differs from the output of \code{summary(model)}, for example in the
case of \code{mgcv::gam()}. The \emph{estimated degrees of freedom}, column
\code{edf} in the summary-output, is named \code{df} in the returned data
frame, while the column \code{df_error} in the returned data frame refers to
the residual degrees of freedom that are returned by \code{df.residual()}.
Hence, the values in the the column \code{df_error} differ from the column
\code{Ref.df} from the summary, which is intentional, as these reference
degrees of freedom \dQuote{is not very interpretable}
(\href{https://stat.ethz.ch/pipermail/r-help/2019-March/462135.html}{web}).
}
\examples{
library(parameters)
if (require("mgcv")) {
  dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
  model <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
  model_parameters(model)
}
}
\seealso{
\code{\link[insight:standardize_names]{insight::standardize_names()}} to rename
columns into a consistent, standardized naming scheme.
}
