% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/for_loop_index_linter.R
\name{for_loop_index_linter}
\alias{for_loop_index_linter}
\title{Block usage of for loops directly overwriting the indexing variable}
\usage{
for_loop_index_linter()
}
\description{
\verb{for (x in x)} is a poor choice of indexing variable. This overwrites
\code{x} in the calling scope and is confusing to read.
}
\examples{
# will produce lints
lint(
  text = "for (x in x) { TRUE }",
  linters = for_loop_index_linter()
)

lint(
  text = "for (x in foo(x, y)) { TRUE }",
  linters = for_loop_index_linter()
)

# okay
lint(
  text = "for (xi in x) { TRUE }",
  linters = for_loop_index_linter()
)

lint(
  text = "for (col in DF$col) { TRUE }",
  linters = for_loop_index_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}, \link[=robustness_linters]{robustness}
}
