% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactiveTable.R
\name{interactiveTable}
\alias{interactiveTable}
\alias{interactiveTable.htmlTable}
\alias{knit_print.interactiveTable}
\alias{print.interactiveTable}
\title{An interactive table that allows you to limit the size of boxes}
\usage{
interactiveTable(x, ..., txt.maxlen = 20, button = FALSE,
  minimized.columns, js.scripts = c())

\method{interactiveTable}{htmlTable}(tbl, txt.maxlen = 20,
  button = FALSE, minimized.columns, js.scripts = c())

\method{knit_print}{interactiveTable}(x, ...)

\method{print}{interactiveTable}(x, useViewer, ...)
}
\arguments{
\item{x}{The interactive table that is to be printed}

\item{...}{The exact same parameters as \code{\link{htmlTable}} uses}

\item{txt.maxlen}{The maximum length of a text}

\item{button}{Indicator if the cell should be clickable or if a button should appear with a plus/minus}

\item{minimized.columns}{Notifies if any particular columns should be collapsed from start}

\item{js.scripts}{If you want to add your own JavaScript code you can just add it here.
All code is merged into one string where each section is wrapped in it's own
\code{<scrip></script>} element.}

\item{tbl}{An htmlTable object can be directly passed into the function}

\item{useViewer}{If you are using RStudio there is a viewer thar can render
the table within that is envoced if in \code{\link[base]{interactive}} mode.
Set this to \code{FALSE} if you want to remove that  functionality. You can
also force the function to call a specific viewer by setting this to a
viewer function, e.g. \code{useViewer = utils::browseURL} if you want to
override the default RStudio viewer. Another option that does the same is to
set the \code{options(viewer=utils::browseURL)} and it will default to that
particular viewer (this is how RStudio decides on a viewer).
\emph{Note:} If you want to force all output to go through the
\code{\link[base]{cat}()} the set \code{\link[base]{options}(htmlTable.cat = TRUE)}.}
}
\value{
An htmlTable with a javascript attribute containing the code that is then printed
}
\description{
This function wraps the htmlTable and adds JavaScript code for toggling the amount
of text shown in any particular cell.
}
\examples{
# A simple output
long_txt <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit,
sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit
in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur
sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt
mollit anim id est laborum"
short_txt <- gsub("(^[^.]+).*", "\\\\1", long_txt)

output <-
  cbind(rep(short_txt, 2),
        rep(long_txt, 2))

interactiveTable(output,
                 minimized.columns = ncol(output),
                 header = c("Short", "Long"),
                 rnames = c("First", "Second"),
                 col.rgroup = c("#FFF", "#EEF"))
}
