% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lump.R
\name{fct_lump}
\alias{fct_lump}
\title{Lump together least/most common factor levels into "other"}
\usage{
fct_lump(f, n, prop, w = NULL, other_level = "Other",
  ties.method = c("min", "average", "first", "last", "random", "max"))
}
\arguments{
\item{f}{A factor (or character vector).}

\item{n, prop}{If both \code{n} and \code{prop} are missing, \code{fct_lump} lumps
together the least frequent levels into "other", while ensuring that
"other" is still the smallest level. It's particularly useful in
conjunction with \code{\link{fct_inorder}()}.

Positive \code{n} preserves the most common \code{n} values.
Negative \code{n} preserves the least common \code{-n} values.
It there are ties, you will get at least \code{abs(n)} values.

Positive \code{prop} preserves values that appear at least
\code{prop} of the time. Negative \code{prop} preserves values that
appear at most \code{-prop} of the time.}

\item{w}{An optional numeric vector giving weights for frequency of
each value (not level) in f.}

\item{other_level}{Value of level used for "other" values. Always
placed at end of levels.}

\item{ties.method}{A character string specifying how ties are
treated. See \code{\link[=rank]{rank()}} for details.}
}
\description{
Lump together least/most common factor levels into "other"
}
\examples{
x <- factor(rep(LETTERS[1:9], times = c(40, 10, 5, 27, 1, 1, 1, 1, 1)))
x \%>\% table()
x \%>\% fct_lump() \%>\% table()
x \%>\% fct_lump() \%>\% fct_inorder() \%>\% table()

x <- factor(letters[rpois(100, 5)])
x
table(x)
table(fct_lump(x))

# Use positive values to collapse the rarest
fct_lump(x, n = 3)
fct_lump(x, prop = 0.1)

# Use negative values to collapse the most common
fct_lump(x, n = -3)
fct_lump(x, prop = -0.1)

# Use weighted frequencies
w <- c(rep(2, 50), rep(1, 50))
fct_lump(x, n = 5, w = w)

# Use ties.method to control how tied factors are collapsed
fct_lump(x, n = 6)
fct_lump(x, n = 6, ties.method = "max")

}
\seealso{
\code{\link[=fct_other]{fct_other()}} to convert specified levels to other.
}
