% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-bench-compare.r
\name{bench_compare}
\alias{bench_compare}
\alias{bench_tbls}
\alias{compare_tbls}
\alias{compare_tbls2}
\alias{eval_tbls}
\alias{eval_tbls2}
\title{Evaluate, compare, benchmark operations of a set of srcs.}
\usage{
bench_tbls(tbls, op, ..., times = 10)

compare_tbls(tbls, op, ref = NULL, compare = equal_data_frame, ...)

compare_tbls2(tbls_x, tbls_y, op, ref = NULL, compare = equal_data_frame, ...)

eval_tbls(tbls, op)

eval_tbls2(tbls_x, tbls_y, op)
}
\arguments{
\item{tbls, tbls_x, tbls_y}{A list of \code{\link[=tbl]{tbl()}}s.}

\item{op}{A function with a single argument, called often with each
element of \code{tbls}.}

\item{\dots}{For \code{compare_tbls()}: additional parameters passed on the
\code{compare()} function

For \code{bench_tbls()}: additional benchmarks to run.}

\item{times}{For benchmarking, the number of times each operation is
repeated.}

\item{ref}{For checking, a data frame to test results against. If not
supplied, defaults to the results from the first \code{src}.}

\item{compare}{A function used to compare the results. Defaults to
\code{equal_data_frame} which ignores the order of rows and columns.}
}
\value{
\code{eval_tbls()}: a list of data frames.

\code{compare_tbls()}: an invisible \code{TRUE} on success, otherwise
an error is thrown.

\code{bench_tbls()}: an object of class
\code{\link[microbenchmark:microbenchmark]{microbenchmark::microbenchmark()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
These functions are deprecated because we now believe that you're
better of performing the comparisons directly, yourself, in order to
generate more informative test failures.
}
\keyword{internal}
