% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-orderset.R, R/chk-setequal.R
\name{vld_orderset}
\alias{vld_orderset}
\alias{chk_setequal}
\alias{vld_setequal}
\title{Check Set Equal}
\usage{
vld_orderset(x, values)

chk_setequal(x, values, x_name = NULL)

vld_setequal(x, values)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if equal set using

\code{setequal(x, values)}
}
\section{Functions}{
\itemize{
\item \code{vld_orderset()}: Validate Set Ordered

\item \code{vld_setequal()}: Validate Set Equal

}}
\examples{

# vld_orderset
vld_orderset(1, 1)
vld_orderset(1:2, 2:1)
vld_orderset(1, 2:1)
vld_orderset(1:2, 2)
# chk_setequal
chk_setequal(1:2, 2:1)
try(chk_setequal(1, 1:2))
# vld_setequal
vld_setequal(1, 1)
vld_setequal(1:2, 2:1)
vld_setequal(1, 2:1)
vld_setequal(1:2, 2)
}
\seealso{
Other chk_set: 
\code{\link{chk_join}()},
\code{\link{chk_not_subset}()},
\code{\link{chk_orderset}()},
\code{\link{chk_superset}()},
\code{\link{vld_not_subset}()}
}
\concept{chk_set}
