% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qvcalc.BTabilities.R
\name{qvcalc.BTabilities}
\alias{qvcalc.BTabilities}
\title{Quasi Variances for Estimated Abilities}
\usage{
\method{qvcalc}{BTabilities}(object, ...)
}
\arguments{
\item{object}{a \code{"BTabilities"} object as returned by \code{\link[=BTabilities]{BTabilities()}}.}

\item{...}{additional arguments, currently ignored.}
}
\value{
A list of class \code{"qv"}, with components
\item{covmat}{The full variance-covariance matrix for the estimated
abilities.}
\item{qvframe}{A data frame with variables \code{estimate}, \code{SE}, \code{quasiSE} and
\code{quasiVar}, the last two being a quasi standard error and quasi-variance
for each ability.}
\item{dispersion}{\code{NULL} (dispersion is fixed to 1).}
\item{relerrs}{Relative errors for approximating the standard errors of all
simple contrasts.}
\item{factorname}{The name of the ID factor identifying players in the \code{BTm}
formula.}
\item{coef.indices}{\code{NULL} (no required for this method).}
\item{modelcall}{The call to \code{BTm} to fit the Bradley-Terry model from which
the abilities were estimated.}
}
\description{
A method for \code{\link[qvcalc:qvcalc]{qvcalc::qvcalc()}} to compute a set of quasi variances (and
corresponding quasi standard errors) for estimated abilities from a
Bradley-Terry model as returned by \code{\link[=BTabilities]{BTabilities()}}.
}
\details{
For details of the method see Firth (2000), Firth (2003) or Firth and de
Menezes (2004). Quasi variances generalize and improve the accuracy of
\dQuote{floating absolute risk} (Easton et al., 1991). This device for
economical model summary was first suggested by Ridout (1989).

Ordinarily the quasi variances are positive and so their square roots
(the quasi standard errors) exist and can be used in plots, etc.
}
\examples{
    
example(baseball)
baseball.qv <- qvcalc(BTabilities(baseballModel2))
print(baseball.qv)
plot(baseball.qv, xlab = "team",
     levelNames = c("Bal", "Bos", "Cle", "Det", "Mil", "NY", "Tor"))
}
\references{
Easton, D. F, Peto, J. and Babiker, A. G. A. G. (1991) Floating absolute
risk: an alternative to relative risk in survival and case-control analysis
avoiding an arbitrary reference group. \emph{Statistics in Medicine} \strong{10},
1025--1035.

Firth, D. (2000)  Quasi-variances in Xlisp-Stat and on the web.
\emph{Journal of Statistical Software} \strong{5.4}, 1--13.
\url{https://www.jstatsoft.org/article/view/v005i04}.

Firth, D. (2003) Overcoming the reference category problem in the
presentation of statistical models. \emph{Sociological Methodology}
\strong{33}, 1--18.

Firth, D. and de Menezes, R. X. (2004)  Quasi-variances.
\emph{Biometrika} \strong{91}, 65--80.

Menezes, R. X. de (1999)  More useful standard errors for group and factor
effects in generalized linear models.  \emph{D.Phil. Thesis},
Department of Statistics, University of Oxford.

Ridout, M.S. (1989). Summarizing the results of fitting generalized
linear models to data from designed experiments. In: \emph{Statistical
Modelling: Proceedings of GLIM89 and the 4th International
Workshop on Statistical Modelling held in Trento, Italy, July 17--21,
1989} (A. Decarli et al., eds.), pp 262--269. New York: Springer.
}
\seealso{
\code{\link[qvcalc:worstErrors]{qvcalc::worstErrors()}}, \code{\link[qvcalc:plot.qv]{qvcalc::plot.qv()}}.
}
\author{
David Firth
}
