% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brownian.motion.R
\name{brownian.motion}
\alias{brownian.motion}
\title{Demonstration of Brownian motion on the 2D plane}
\usage{
brownian.motion(n = 10, xlim = c(-20, 20), ylim = c(-20, 20), ...)
}
\arguments{
\item{n}{Number of points in the scatterplot}

\item{xlim, ylim}{Arguments passed to \code{\link{plot.default}} to control
the apperance of the scatterplot (title, points, etc), see
\code{\link{points}} for details.}

\item{...}{other arguments passed to \code{\link{plot.default}}}
}
\value{
None (invisible \code{NULL}).
}
\description{
Brownian motion, or random walk, can be regarded as the trace of some
cumulative normal random numbers.
}
\details{
The location of the next step is ``current location + random Gaussian
numbers'', i.e.,

\deqn{x_{k + 1} = x_{k} + rnorm(1)}{x[k + 1] = x[k] + rnorm(1)}

\deqn{y_{k + 1} = y_{k} + rnorm(1)}{y[k + 1] = y[k] + rnorm(1)}

where \emph{(x, y)} stands for the location of a point.
}
\note{
The maximum number of steps in the motion is specified in
  \code{ani.options('nmax')}.
}
\references{
Examples at \url{https://yihui.name/animation/example/brownian-motion/}
}
\seealso{
\code{\link{rnorm}}
}
\author{
Yihui Xie
}
