% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZilionisLungData.R
\name{ZilionisLungData}
\alias{ZilionisLungData}
\title{Obtain the Zilionis lung cancer data}
\usage{
ZilionisLungData(
  which = c("human", "mouse"),
  ensembl = FALSE,
  location = TRUE,
  filter = FALSE,
  legacy = FALSE
)
}
\arguments{
\item{which}{String specifying the species to get data for.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{filter}{Logical scalar indicating if the filtered subset should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the human/mouse lung cancer single-cell RNA-seq data from Zilionis et al. (2019).
}
\details{
Column metadata is provided and contains information on the library, donor ID/animal ID, replicate and tissue.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

If \code{filter=TRUE}, only cells that have been used in the original analysis are returned.
The cells used are specified in the \code{Used} column of the \code{\link{colData}}.

The \code{\link{reducedDim}} contains coordinates of SPRING representations.
This may be filled with \code{NA}s for SPRING coordinates computed on a subset of cells (specified in \code{\link{colData}}).

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/zilionis-lung}.
}
\examples{
sce.human <- ZilionisLungData()

sce.mouse <- ZilionisLungData("mouse")

}
\references{
Zilionis R et al. (2019). 
Single-cell transcriptomics of human and mouse lung cancers reveals 
conserved myeloid populations across individuals and species. 
\emph{Immunity} 50(5), 1317-1334.
}
\author{
Jens Preussner
}
