% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsvaNewAPI.R
\name{readGMT}
\alias{readGMT}
\title{Import Gene Sets from a GMT File}
\usage{
readGMT(
  con,
  deduplUse = c("first", "drop", "union", "smallest", "largest", "custom")
)
}
\arguments{
\item{con}{A connection object or character string containing e.g.
a file name or URL.  This is directly passed to \code{\link{readLines}} and hence may
contain anything that \code{readLines()} can handle.}

\item{deduplUse}{With the exception of the special method \code{custom}, all
handling of duplicated gene set names is delegated to function
\code{\link{deduplicateGeneSets}} and this argument is directly passed on.
Please see \code{?deduplicateGeneSets}.
Using \code{deduplUse=custom} allows import of the GMT file for manual inspection
and its content and remedy is the user's responsibility.  However, \code{gsva()}
will \emph{not} accept the result for further use unless it is modified to have
duplicated gene set names removed.}
}
\value{
A named list of gene sets that represented as character vectors of
gene IDs.
}
\description{
Imports a list of gene sets from a GMT (Gene Matrix Transposed)
format file, offering a choice of ways to handle duplicated gene set names.
}
\seealso{
\code{\link{readLines}}, \code{\link{deduplicateGeneSets}}
}
