% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsva.R
\name{filterGeneSets}
\alias{filterGeneSets}
\alias{filterGeneSets,list-method}
\alias{filterGeneSets,GeneSetCollection-method}
\title{Filter gene sets}
\usage{
\S4method{filterGeneSets}{list}(gSets, minSize = 1, maxSize = Inf)

\S4method{filterGeneSets}{GeneSetCollection}(gSets, minSize = 1, maxSize = Inf)
}
\arguments{
\item{gSets}{Gene sets given either as a \code{list} or a
\code{GeneSetCollection} object.}

\item{minSize}{Minimum size.}

\item{maxSize}{Maximum size.}
}
\value{
A collection of gene sets that meet the given minimum and maximum
set size.
}
\description{
Filters gene sets through a given minimum and maximum set size.

This function filters the input gene sets according to a given minimum and
maximum set size.
}
\examples{
geneSets <- list(set1=as.character(1:4), set2=as.character(4:10))
filterGeneSets(geneSets, minSize=5)
}
\references{
Hänzelmann, S., Castelo, R. and Guinney, J. GSVA: Gene set
variation analysis for microarray and RNA-Seq data.
\emph{BMC Bioinformatics}, 14:7, 2013.
}
\seealso{
\code{\link{computeGeneSetsOverlap}}
}
\author{
J. Guinney
}
\keyword{Gene}
\keyword{set}
