% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateDirectory.R
\name{validateDirectory}
\alias{validateDirectory}
\alias{checkValidDirectory}
\title{Check if a staging directory is valid}
\usage{
validateDirectory(
  dir,
  validate.metadata = TRUE,
  schema.locations = NULL,
  attempt.load = FALSE
)
}
\arguments{
\item{dir}{String containing the path to a staging directory.}

\item{validate.metadata}{Whether to validate each metadata JSON file against the schema.}

\item{schema.locations}{Character vector containing the name of the package containing the JSON schemas.
Only used if \code{validate.metadata=TRUE}; if \code{NULL}, defaults to the locations described in \code{?\link{loadObject}}.}

\item{attempt.load}{Whether to validate each object by attempting to load it into memory.}
}
\value{
\code{NULL} invisibly on success, otherwise an error is raised.
}
\description{
Check whether a staging directory is valid in terms of its structure and metadata.
}
\details{
This function verifies that the restrictions described in \code{\link{stageObject}} are respected, namely:
\itemize{
\item Each object is represented by subdirectory with a single JSON document.
\item Each JSON metadata document's \code{path} property exists and is consistent with the path of the document itself.
\item Child objects are nested in subdirectories of the parent object's directory.
\item Child objects have the \code{is_child} property set to true in their metadata.
\item Each child object is referenced exactly once in its parent object's metadata.
}

This function will also check that redirections are valid:
\itemize{
\item The \code{path} property of the redirection does \emph{not} exist and is consistent with the path of the redirection document.
\item The redirection target location exists in the directory.
}

If \code{validate.metadata=TRUE}, this function will validate each metadata file against its specified JSON schema.
Applications may set \code{schema.locations} to point to an appropriate set of schemas other than the defaults in \pkg{alabaster.base}.

If \code{attempt.load=TRUE}, this function will attempt to load each non-child object into memory.
This serves as an additional validation step to check that the contents of each file are valid (at least, according to the current \code{\link{altLoadObject}} function).
However, it may be time-consuming and so defaults to \code{FALSE}.
Child objects are assumed to be loaded as part of their parents and are not explicitly checked.
}
\examples{
# Mocking up an object:
library(S4Vectors)
ncols <- 123
df <- DataFrame(
    X = rep(LETTERS[1:3], length.out=ncols),
    Y = runif(ncols)
)
df$Z <- DataFrame(AA = sample(ncols))

# Mocking up the directory:
tmp <- tempfile()
dir.create(tmp, recursive=TRUE)
writeMetadata(stageObject(df, tmp, "foo"), tmp)

# Checking that it's valid:
validateDirectory(tmp)

}
\author{
Aaron Lun
}
