open Resume_t

let ascii_printable c =
  let n = Char.code c in
  n >= 32 && n <= 127

(*
  Check that string is not empty and contains only ASCII printable
  characters (for the sake of the example; we use UTF-8 these days)
*)
let validate_some_text s =
  s <> "" &&
  try
    String.iter (fun c -> if not (ascii_printable c) then raise Exit) s;
    true
  with Exit ->
    false

(*
  Check that the combination of year, month and day exists in the
  Gregorian calendar.
*)
let validate_date x =
  let y = x.year in
  let m = x.month in
  let d = x.day in
  m >= 1 && m <= 12 && d >= 1 &&
  (let dmax =
    match m with
        2 ->
        if y mod 4 = 0 && not (y mod 100 = 0) || y mod 400 = 0 then 29
        else 28
      | 1 | 3 | 5 | 7 | 8 | 10 | 12 -> 31
      | _ -> 30
   in
   d <= dmax)

(* Compare dates chronologically *)
let compare_date a b =
  let c = compare a.year b.year in
  if c <> 0 then c
  else
    let c = compare a.month b.month in
    if c <> 0 then c
    else compare a.day b.day

(* Check that the end_date, when defined, is not earlier than the start_date *)
let validate_job x =
  match x.end_date with
    None -> None
  | Some end_date ->
      compare_date x.start_date end_date <= 0
