/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmneweval.cpp
 * \date 21/08/2025
 * \author Olivier Langella
 * \brief add any new eval contained in a double vector
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "psmneweval.h"
#include "../cborscanmapbase.h"

pappso::cbor::psm::PsmNewEval::PsmNewEval(std::size_t buffer_scan_size,
                                          CborStreamWriter *cbor_output_p,
                                          const QString &eval_name,
                                          const QJsonObject &parameters)
  : PsmFileScanProcessAndCopy(buffer_scan_size, cbor_output_p, QString("add %1").append(eval_name))
{
  qDebug();
  m_newEvalParameters = parameters;
  m_evalName          = eval_name;
  qDebug();
}

pappso::cbor::psm::PsmNewEval::~PsmNewEval()
{
}

pappso::cbor::psm::CborScanMapBase *
pappso::cbor::psm::PsmNewEval::newCborScanMap()
{
  CborScanMapBase *p_cbor_scan_map = new CborScanMapBase(*this);
  value_it                         = p_cbor_scan_map->addPsmEvalVectorDouble(
    m_evalName, m_evalKeyValueName, value_it, m_psmEvalValues.end());
  return p_cbor_scan_map;
}

void
pappso::cbor::psm::PsmNewEval::addEvalDoubleVector(const QString &eval_key_value_name,
                                                   std::vector<double> arr_values)
{
  m_evalKeyValueName = eval_key_value_name;
  m_psmEvalValues    = arr_values;
}

void
pappso::cbor::psm::PsmNewEval::parameterMapReady(pappso::UiMonitorInterface &monitor
                                                 [[maybe_unused]])
{
  qDebug();
  QCborMap cbor_neweval_parameters = QCborValue::fromJsonValue(m_newEvalParameters).toMap();


  m_cborParameterMap.insert(m_evalName, cbor_neweval_parameters);


  mp_cborOutput->append("parameter_map");
  mp_cborOutput->writeCborMap(m_cborParameterMap);
  qDebug();
}
