from typing import Any, Type, Dict, Tuple

API_VERSION: str

def get_compressor(name: str, **kwargs) -> Any: ...

class CompressionSpec:
    def __init__(self, spec: str) -> None: ...
    @property
    def compressor(self) -> Any: ...
    inner: CompressionSpec

class Compressor:
    def __init__(self, name: Any = ..., **kwargs) -> None: ...
    def compress(self, meta: Dict, data: bytes) -> Tuple[Dict, bytes]: ...
    def decompress(self, meta: Dict, data: bytes) -> Tuple[Dict, bytes]: ...
    @staticmethod
    def detect(data: bytes) -> Any: ...

class CompressorBase:
    ID: bytes = ...
    name: str = ...
    @classmethod
    def detect(self, data: bytes) -> bool: ...
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    def decide(self, data: bytes) -> Any: ...
    def compress(self, data: bytes) -> bytes: ...
    def decompress(self, data: bytes) -> bytes: ...

class Auto(CompressorBase):
    def __init__(self, compressor: Any) -> None: ...

class DecidingCompressor(CompressorBase):
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    def decide_compress(self, data: bytes) -> Any: ...

class CNONE(CompressorBase):
    def __init__(self, level: int = ..., **kwargs) -> None: ...

class ObfuscateSize(CompressorBase):
    def __init__(self, level: int = ..., compressor: Any = ...) -> None: ...

class ZLIB_legacy(CompressorBase):
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    level: int

class ZLIB(CompressorBase):
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    level: int

class LZ4(DecidingCompressor):
    def __init__(self, level: int = ..., **kwargs) -> None: ...

class LZMA(DecidingCompressor):
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    level: int

class ZSTD(DecidingCompressor):
    def __init__(self, level: int = ..., **kwargs) -> None: ...
    level: int

LZ4_COMPRESSOR: Type[LZ4]
NONE_COMPRESSOR: Type[CNONE]

COMPRESSOR_TABLE: dict
