#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_security_policies
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_security_policies
version_added: 2.9.0
short_description: Create and manage security policies on Juniper JUNOS devices
description: This module provides declarative creation and management of security policies on Juniper JUNOS devices
author: Pranav Bhatt (@pranav-bhatt)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
  - This module requires the netconf system service be enabled on the device being managed
  - This module works with connection C(netconf)
  - See L(the Junos OS Platform Options,https://docsansiblecom/ansible/latest/network/user_guide/platform_junoshtml)
  - Tested against JunOS v18.4R1
options:
  config:
    description: A dictionary of security policies
    type: dict
    suboptions:
      from_zones:
        description:
          - List of security zones from which the traffic originates from
        type: list
        elements: dict
        suboptions:
          name:
            description:
              - The name of the security zone from which the traffic originates from
            type: str
          to_zones:
            description:
              - List of destination security zones of the traffic
            type: list
            elements: dict
            suboptions:
              name:
                description:
                  - The name of the destination security zone of the traffic
                type: str
              policies: &policy_attributes
                description:
                  - List of policies defined for the associated category
                type: list
                elements: dict
                suboptions:
                  name:
                    description:
                      - Name of the policy
                    type: str
                  description:
                    description:
                      - Description of the security policy
                    type: str
                  scheduler_name:
                    description:
                      - Name of the scheduler to run this policy
                    type: str
                  match:
                    description: Configure security policy match criteria
                    type: dict
                    suboptions:
                      application:
                        description:
                          - Specify the IP or remote procedure call (RPC) application or set of applications to be used as match criteria
                        type: dict
                        suboptions:
                          names:
                            description: Name of the predefined or custom application or application set used as match criteria
                            type: list
                            elements: str
                          any:
                            description: Match any predefined or custom applications or application sets
                            type: bool
                      dynamic_application:
                        description:
                          - Specify the dynamic applications or dynamic application groups used as match criteria within a security policy
                        type: dict
                        suboptions:
                          names:
                            description: Specify dynamic applications or dynamic application groups
                            type: list
                            elements: str
                          any:
                            description:
                              - Configuring the dynamic application as any installs the policy with the application as a wildcard (default)
                            type: bool
                          none:
                            description:
                              - Configuring the dynamic application as none ignores classification results from AppID and does not use the
                                dynamic application in security policy lookups
                            type: bool
                      destination_address:
                        description:
                          - Define the matching criteria You can specify one or more IP addresses, address sets, or wildcard addresses
                        type: dict
                        suboptions:
                          addresses:
                            description:
                              - IP address, IP address set, or address book entry, or wildcard address (represented as ABCD/wildcard_mask)
                            type: list
                            elements: str
                          any:
                            description: Any IPv4 or IPv6 address
                            type: bool
                          any_ipv4:
                            description: Any IPv4 address
                            type: bool
                          any_ipv6:
                            description: Any IPv6 address
                            type: bool
                      destination_address_excluded:
                        description:
                          - Exclude destination addresses
                        type: bool
                      source_address:
                        description:
                          - Define the matching criteria You can specify one or more IP addresses, address sets, or wildcard addresses
                        type: dict
                        suboptions:
                          addresses:
                            description:
                              - IP address, IP address set, or address book entry, or wildcard address (represented as ABCD/wildcard_mask)
                            type: list
                            elements: str
                          any:
                            description: Any IPv4 or IPv6 address
                            type: bool
                          any_ipv4:
                            description: Any IPv4 address
                            type: bool
                          any_ipv6:
                            description: Any IPv6 address
                            type: bool
                      source_address_excluded:
                        description:
                          - Exclude source addresses
                        type: bool
                      source_identity:
                        description:
                          - Identifies users and roles to be used as match criteria for a policy
                        type: dict
                        suboptions:
                          names:
                            description: A list of specific users and roles
                            type: list
                            elements: str
                          any:
                            description:
                              - Any user or role, as well as the keywords authenticated_user, unauthenticated_user,
                                and unknown_user
                            type: bool
                          authenticated_user:
                            description: All users and roles that have been authenticated
                            type: bool
                          unauthenticated_user:
                            description:
                              - Any user or role that does not have an IP_address mapped to authentication sources and the authentication source
                                is up and running
                            type: bool
                          unknown_user:
                            description:
                              - Any user or role that does not have an IP address mapped to authentication sources, because the
                                authentication source is disconnected from the SRX Series device
                            type: bool
                      source_end_user_profile:
                        description: Source end user profile name
                        type: str
                      url_category:
                        description: URL category
                        type: dict
                        suboptions:
                          names:
                            description:
                              - Names of url category to match
                            type: list
                            elements: str
                          any:
                            description:
                              - Apply to any url category
                            type: bool
                          none:
                            description:
                              - Do not apply to the url category
                            type: bool
                      from_zone:
                        description: Identify a single source zone or multiple source zones to be used as a match criteria for a policy
                        type: dict
                        suboptions:
                          names:
                            description: Name of single or multiple source zone
                            type: list
                            elements: str
                          any:
                            description: Match any zone
                            type: bool
                          junos_host:
                            description:
                              - junos-host
                            type: bool
                      to_zone:
                        description: Identify a single destination zone or multiple destination zones to be used as a match criteria for a policy
                        type: dict
                        suboptions:
                          names:
                            description: Name of single or multiple destination zone
                            type: list
                            elements: str
                          any:
                            description: Match any zone
                            type: bool
                          junos_host:
                            description:
                              - junos-host
                            type: bool
                  then:
                    description: Specify the policy action to be performed when packets match the defined criteria
                    type: dict
                    suboptions:
                      count:
                        description:
                          - Enable a count, in bytes or kilobytes, of all network traffic the policy allows to pass through the device
                            in both directions; the originating traffic from the client to the server (from the from_zone to the to_zone),
                            and the return traffic from the server to the originating client
                        type: bool
                      deny:
                        description: Block the service at the firewall The device drops the packets
                        type: bool
                      reject:
                        description:
                          - Block the service at the firewall The device drops the packet and sends a TCP reset (RST) segment to the
                            source host for TCP traffic and an ICMP "destination unreachable, port unreachable"
                            message (type 3, code 3) for UDP traffic
                        type: dict
                        suboptions:
                          enable:
                            description:
                              - Enable rejection of packets based on match criteria
                            type: bool
                          profile:
                            description:
                              - You can chose to provide a notification to the clients or redirect client request to an informative
                                Web page when a policy blocks HTTP or HTTPS traffic with a deny or reject action
                            type: str
                          ssl_proxy:
                            description:
                              - You can apply a redirect SSL proxy profile when a policy blocks HTTPS traffic with a reject action
                                When you apply am SSL proxy profile, SSL proxy decrypts the traffic and application
                                identification functionality identifies the application
                            type: dict
                            suboptions:
                              enable:
                                description:
                                  - Enable SSL proxy
                                type: bool
                              profile_name:
                                description: Name of SSL proxy profile
                                type: str
                      log:
                        description:
                          - Log traffic information for a specific policy Traffic information is logged when a
                            session begins (session_init) or closes (session_close)
                        type: dict
                        suboptions:
                          session_init:
                            description:
                              - Enable logging on session initialization time
                            type: bool
                          session_close:
                            description:
                              - Enable logging on session close time
                            type: bool
                      permit:
                        description: Block the service at the firewall The device drops the packets
                        type: dict
                        suboptions:
                          application_services:
                            description:
                              - Enable application services within a security policy
                            type: dict
                            suboptions:
                              advanced_anti_malware_policy:
                                description:
                                  - Specify advanced_anti_malware policy name
                                type: str
                              application_firewalls:
                                description:
                                  - Specify the rule sets configured as part of application firewall to be applied to the permitted traffic
                                type: list
                                elements: dict
                                suboptions:
                                  rule_set:
                                    description:
                                      - name of rule set to use
                                    type: str
                              application_traffic_control_rule_set:
                                description:
                                  - Specify the rule set configured as part of AppQoS, application_aware quality of service,
                                    to be applied to the permitted traffic
                                type: str
                              gprs_gtp_profile:
                                description:
                                  - Specify GPRS tunneling protocol profile name
                                type: str
                              gprs_sctp_profile:
                                description:
                                  - Specify GPRS stream control protocol profile name
                                type: str
                              icap_redirect:
                                description:
                                  - Specify icap redirect profile name
                                type: str
                              idp:
                                description:
                                  - Intrusion Detection and Prevention (IDP)
                                type: bool
                              idp_policy:
                                description:
                                  - Specify IDP policy name
                                type: str
                              packet_capture:
                                description:
                                  - Option to enable or disable packet capture
                                type: bool
                              redirect_wx:
                                description:
                                  - Specify the WX redirection needed for the packets that arrive from the LAN
                                type: bool
                              reverse_redirect_wx:
                                description:
                                  - Specify the WX redirection needed for the reverse flow of the packets that arrive from the WAN
                                type: bool
                              security_intelligence_policy:
                                description:
                                  - Specify security_intelligence policy name
                                type: str
                              security_intelligence:
                                description: Specify the security intelligence feed post action
                                type: dict
                                suboptions:
                                  add_destination_identity_to_feed:
                                    description: Add destination user identity to the security feed
                                    type: str
                                  add_destination_ip_to_feed:
                                    description: Add the destination IP address to the security feed
                                    type: str
                                  add_source_ip_to_feed:
                                    description: Add the source IP address to the security feed
                                    type: str
                                  add_source_identity_to_feed:
                                    description: Add source user identity to the security feed
                                    type: str
                              ssl_proxy:
                                description: You can apply a redirect SSL proxy profile when a policy blocks HTTPS traffic with a reject action
                                type: dict
                                suboptions:
                                  enable:
                                    description:
                                      - Enable SSL proxy
                                    type: bool
                                  profile_name:
                                    description: Name of SSL proxy profile
                                    type: str
                              uac_policy:
                                description:
                                  - Enable Unified Access Control (UAC) for the security policy
                                type: dict
                                suboptions:
                                  enable:
                                    description:
                                      - Enable Unified Access Control (UAC)
                                    type: bool
                                  captive_portal:
                                    description:
                                      - Specify the preconfigured security policy for captive portal on the Junos OS Enforcer to enable the
                                        captive portal feature
                                    type: str
                              utm_policy:
                                description:
                                  - Specify UTM policy name
                                type: str
                          destination_address:
                            description:
                              - Specify whether the traffic permitted by the security policy is limited to packets
                                where the destination IP address has been translated by means of a destination NAT rule
                                or to packets where the destination IP address has not been translated
                            choices:
                              - drop-translated
                              - drop-untranslated
                            type: str
                          firewall_authentication:
                            description: Configure firewall authentication methods
                            type: dict
                            suboptions:
                              pass_through:
                                description:
                                  - Configure pass-through firewall user authentication
                                type: dict
                                suboptions:
                                  access_profile:
                                    description:
                                      - Specify the name of the access profile
                                    type: str
                                  client_match:
                                    description:
                                      - Specify the name of the users or user groups in a profile who are allowed access by this policy
                                    type: str
                                  ssl_termination_profile:
                                    description:
                                      - Specify the SSL termination profile used for SSL offloading
                                    type: str
                                  web_redirect:
                                    description:
                                      - Enable redirecting an HTTP request to the device and redirecting the client system to a
                                        webpage for authentication
                                    type: bool
                                  web_redirect_to_https:
                                    description:
                                      - Redirect unauthenticated HTTP requests to the internal HTTPS Web server of the device
                                    type: bool
                                  auth_only_browser:
                                    description:
                                      - Configure firewall authentication to ignore non-browser HTTP/HTTPS traffic
                                    type: bool
                                  auth_user_agent:
                                    description:
                                      - Specify a user-agent value to be used to verify that the user's browser traffic is HTTP/HTTPS traffic
                                    type: str
                              push_to_identity_management:
                                description: enables pushing to identity management devices
                                type: bool
                              user_firewall:
                                description:
                                  - Configure user role firewall authentication, and map the source IP address to the username and its
                                    associated roles (groups)
                                type: dict
                                suboptions:
                                  access_profile:
                                    description:
                                      - Specify the name of the access profile to be used for authentication
                                    type: str
                                  domain:
                                    description:
                                      - Specify the name of the domain where firewall authentication occurs in the event that the
                                        Windows Management Instrumentation client (WMIC) is not available to get
                                        IP_to_user mapping for the integrated user firewall feature
                                    type: str
                                  ssl_termination_profile:
                                    description:
                                      - For HTTPS traffic, specify the name of the SSL termination profile used for SSL offloading
                                    type: str
                                  web_redirect:
                                    description:
                                      - Enable webpage redirection
                                    type: bool
                                  web_redirect_to_https:
                                    description:
                                      - Enable redirection to HTTPS
                                    type: bool
                                  auth_only_browser:
                                    description:
                                      - Configure firewall authentication to ignore non-browser HTTP/HTTPS traffic
                                    type: bool
                                  auth_user_agent:
                                    description:
                                      - Specify a user-agent value to be used to verify that the user's browser traffic is HTTP/HTTPS traffic
                                    type: str
                              web_authentication:
                                description:
                                  - Specify that the policy allows access to users or user groups who have previously been authenticated by
                                    Web authentication
                                type: list
                                elements: str
                          tcp_options:
                            description:
                              - Specify the TCP options for each policy You can configure sync and sequence checks for each policy
                                based on your requirements, and, because each policy has two directions, you can configure a
                                TCP MSS value for both directions or for just one direction
                            type: dict
                            suboptions:
                              initial_tcp_mss:
                                description:
                                  - Configure the TCP maximum segment size (MSS) for packets that arrive at the
                                    ingress interface (initial direction), match a specific policy, and for which a session is created
                                type: int
                              reverse_tcp_mss:
                                description:
                                  - Configure the TCP maximum segment size (MSS) for packets that match a specific policy and travel in the
                                    reverse direction of a session
                                type: int
                              sequence_check_required:
                                description:
                                  - Enable sequence check per policy The sequence_check_required value overrides the global value no_sequence_check
                                type: bool
                              syn_check_required:
                                description:
                                  - Enable sync check per policy The syn_check_required value overrides the global value no_syn_check
                                type: bool
                              window_scale:
                                description:
                                  - Enable window_scale per policy
                                type: bool
                          tunnel:
                            description: Encapsulate outgoing IP packets and decapsulate incoming IP packets
                            type: dict
                            suboptions:
                              ipsec_vpn:
                                description:
                                  - name of the ipsec policy
                                type: str
                              pair_policy:
                                description:
                                  - name of the pair policy
                                type: str
      global:
        description:
          - List of global security policies
        type: dict
        suboptions:
          policies: *policy_attributes
  running_config:
    description:
      - This option is used only with state I(parsed)
      - The value of this option should be the output received from the JunOS device
        by executing the command B(show configuration security policies)
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result
    type: str
  state:
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - rendered
    - gathered
    - parsed
    default: merged
    description:
      - The state the configuration should be left in
      - The states I(rendered), I(gathered) and I(parsed) does not perform any change
        on the device
      - The state I(rendered) will transform the configuration in C(config) option to
        platform specific CLI commands which will be returned in the I(rendered) key
        within the result For state I(rendered) active connection to remote host is
        not required
      - The state I(replaced) will replace the running configuration with the provided
        configuration
      - The state I(replaced) and state I(overridden) have the same behaviour
      - The state I(gathered) will fetch the running configuration from device and transform
        it into structured data in the format as per the resource module argspec and
        the value is returned in the I(gathered) key within the result
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into JSON format as per the resource module parameters and the
        value is returned in the I(parsed) key within the result The value of C(running_config)
        option should be the same format as the output of command
        I(show security policies detail) executed on device For state I(parsed) active
        connection to remote host is not required
    type: str
"""
EXAMPLES = """
# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# Global policies:
# Policy: test_glob, State: enabled, Index: 4, Scope Policy: 0, Sequence number: 1
#   From zones: any
#     To zones: any
#     Source addresses: any-ipv4
#     Destination addresses: any-ipv4
#     Applications: any
#     Action: deny
#
# vagrant@vsrx> show security zones
#
# Security zone: one
# Send reset for non-SYN session TCP packets: Off
# Policy configurable: Yes
# Interfaces bound: 1
# Interfaces:
# ge-0/0/0.0
#
# Security zone: three
# Send reset for non-SYN session TCP packets: Off
# Policy configurable: Yes
# Interfaces bound: 1
# Interfaces:
# ge-0/0/2.0
#
# Security zone: two
# Send reset for non-SYN session TCP packets: Off
# Policy configurable: Yes
# Interfaces bound: 1
# Interfaces:
# ge-0/0/1.0
#
# Security zone: junos-host
# Send reset for non-SYN session TCP packets: Off
# Policy configurable: Yes
# Interfaces bound: 0
# Interfaces:
#
- junipernetworks.junos.junos_security_policies:
    config:
      from_zones:
        - name: one
          to_zones:
            - name: two
              policies:
                - match:
                    application:
                      names:
                        - junos-dhcp-relay
                        - junos-finger
                    destination_address:
                      addresses:
                        - a2
                        - a4
                    destination_address_excluded: true
                    dynamic_application:
                      names:
                        - any
                    source_address:
                      addresses:
                        - a1
                        - a3
                    source_address_excluded: true
                    source_end_user_profile: test_end_user_profile
                    source_identity:
                      unknown_user: true
                    url_category:
                      names:
                        - Enhanced_Web_Chat
                  name: test_policy_1
                  then:
                    count: true
                    deny: true
                    log: session-close
                - match:
                    application:
                      any: true
                    destination_address:
                      any_ipv6: true
                    source_address:
                      addresses:
                        - a1
                  name: test_policy_2
                  then:
                    reject:
                      enable: true
                      profile: test_dyn_app
                      ssl_proxy:
                        enable: true
                        profile_name: SECURITY-SSL-PROXY
            - name: three
              policies:
                - match:
                    application:
                      any: true
                    destination_address:
                      addresses:
                        - a2
                    source_address:
                      addresses:
                        - a1
                  name: test_policy_3
                  then:
                    permit:
                      application_services:
                        application_traffic_control_rule_set: test_traffic_control
                        gprs_gtp_profile: gtp1
                        icap_redirect: test_icap
                        reverse_redirect_wx: 'True'
                        uac_policy:
                          enable: true
                      firewall_authentication:
                        push_to_identity_management: true
                        web_authentication:
                          - FWClient1
                      tcp_options:
                        initial_tcp_mss: 64
                        window_scale: true
      global:
        policies:
          - match:
              application:
                any: true
              destination_address:
                any_ipv6: true
              source_address:
                any_ipv6: true
            name: test_glob_1
            then:
              deny: true
          - match:
              application:
                any: true
              destination_address:
                any_ipv6: true
              source_address:
                any_ipv6: true
            name: test_glob_2
            then:
              deny: true
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#   "after": {
#     "from_zones": [
#       {
#         "name": "one",
#         "to_zones": [
#           {
#             "name": "two",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "names": [
#                       "junos-dhcp-relay",
#                       "junos-finger"
#                     ]
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2",
#                       "a4"
#                     ]
#                   },
#                   "destination_address_excluded": true,
#                   "dynamic_application": {
#                     "names": [
#                       "any"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1",
#                       "a3"
#                     ]
#                   },
#                   "source_address_excluded": true,
#                   "source_end_user_profile": "test_end_user_profile",
#                   "source_identity": {
#                     "unknown_user": true
#                   },
#                   "url_category": {
#                     "names": [
#                       "Enhanced_Web_Chat"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_1",
#                 "then": {
#                   "count": true,
#                   "deny": true,
#                   "log": "session-close"
#                 }
#               },
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "any_ipv6": true
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_2",
#                 "then": {
#                   "reject": {
#                     "enable": true,
#                     "profile": "test_dyn_app",
#                     "ssl_proxy": {
#                       "enable": true,
#                       "profile_name": "SECURITY-SSL-PROXY"
#                     }
#                   }
#                 }
#               }
#             ]
#           },
#           {
#             "name": "three",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_3",
#                 "then": {
#                   "permit": {
#                     "application_services": {
#                       "application_traffic_control_rule_set": "test_traffic_control",
#                       "gprs_gtp_profile": "gtp1",
#                       "icap_redirect": "test_icap",
#                       "reverse_redirect_wx": "True",
#                       "uac_policy": {
#                         "enable": true
#                       }
#                     },
#                     "firewall_authentication": {
#                       "push_to_identity_management": true,
#                       "web_authentication": [
#                         "FWClient1"
#                       ]
#                     },
#                     "tcp_options": {
#                       "initial_tcp_mss": 64,
#                       "window_scale": true
#                     }
#                   }
#                 }
#               }
#             ]
#           }
#         ]
#       }
#     ],
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv4": true
#             },
#             "source_address": {
#               "any_ipv4": true
#             }
#           },
#           "name": "test_glob",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_1",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_2",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "before": {
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv4": true
#             },
#             "source_address": {
#               "any_ipv4": true
#             }
#           },
#           "name": "test_glob",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "changed": true,
#   "commands": "<nc:security
#                   xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#                   <nc:policies>
#                     <nc:policy>
#                       <nc:from-zone-name>one</nc:from-zone-name>
#                       <nc:to-zone-name>two</nc:to-zone-name>
#                       <nc:policy>
#                         <nc:name>test_policy_1</nc:name>
#                         <nc:match>
#                           <nc:source-address>a1</nc:source-address>
#                           <nc:source-address>a3</nc:source-address>
#                           <nc:source-address-excluded/>
#                           <nc:destination-address>a2</nc:destination-address>
#                           <nc:destination-address>a4</nc:destination-address>
#                           <nc:destination-address-excluded/>
#                           <nc:application>junos-dhcp-relay</nc:application>
#                           <nc:application>junos-finger</nc:application>
#                           <nc:source-end-user-profile>test_end_user_profile</nc:source-end-user-profile>
#                           <nc:source-identity>unknown-user</nc:source-identity>
#                           <nc:url-category>Enhanced_Web_Chat</nc:url-category>
#                           <nc:dynamic-application>any</nc:dynamic-application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:deny/>
#                           <nc:count></nc:count>
#                           <nc:log>
#                             <nc:session-close/>
#                           </nc:log>
#                         </nc:then>
#                       </nc:policy>
#                       <nc:policy>
#                         <nc:name>test_policy_2</nc:name>
#                         <nc:match>
#                           <nc:source-address>a1</nc:source-address>
#                           <nc:destination-address>any-ipv6</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:reject>
#                             <nc:profile>test_dyn_app</nc:profile>
#                             <nc:ssl-proxy>
#                               <nc:profile-name>SECURITY-SSL-PROXY</nc:profile-name>
#                             </nc:ssl-proxy>
#                           </nc:reject>
#                         </nc:then>
#                       </nc:policy>
#                     </nc:policy>
#                     <nc:policy>
#                       <nc:from-zone-name>one</nc:from-zone-name>
#                       <nc:to-zone-name>three</nc:to-zone-name>
#                       <nc:policy>
#                         <nc:name>test_policy_3</nc:name>
#                         <nc:match>
#                           <nc:source-address>a1</nc:source-address>
#                           <nc:destination-address>a2</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:permit>
#                             <nc:application-services>
#                               <nc:application-traffic-control>
#                                 <nc:rule-set>test_traffic_control</nc:rule-set>
#                               </nc:application-traffic-control>
#                               <nc:gprs-gtp-profile>gtp1</nc:gprs-gtp-profile>
#                               <nc:icap-redirect>test_icap</nc:icap-redirect>
#                               <nc:reverse-redirect-wx/>
#                               <nc:uac-policy></nc:uac-policy>
#                             </nc:application-services>
#                             <nc:firewall-authentication>
#                               <nc:push-to-identity-management/>
#                               <nc:web-authentication>
#                                 <nc:client-match>FWClient1</nc:client-match>
#                               </nc:web-authentication>
#                             </nc:firewall-authentication>
#                             <nc:tcp-options>
#                               <nc:initial-tcp-mss>64</nc:initial-tcp-mss>
#                               <nc:window-scale/>
#                             </nc:tcp-options>
#                           </nc:permit>
#                         </nc:then>
#                       </nc:policy>
#                     </nc:policy>
#                     <nc:global>
#                       <nc:policy>
#                         <nc:name>test_glob_1</nc:name>
#                         <nc:match>
#                           <nc:source-address>any-ipv6</nc:source-address>
#                           <nc:destination-address>any-ipv6</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:deny/>
#                         </nc:then>
#                       </nc:policy>
#                       <nc:policy>
#                         <nc:name>test_glob_2</nc:name>
#                         <nc:match>
#                           <nc:source-address>any-ipv6</nc:source-address>
#                           <nc:destination-address>any-ipv6</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:deny/>
#                         </nc:then>
#                       </nc:policy>
#                     </nc:global>
#                   </nc:policies>
#                 </nc:security>
#                 "
# After state
# -----------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# From zone: one, To zone: two
# Policy: test_policy_1, State: enabled, Index: 5, Scope Policy: 0, Sequence number: 1
# Source addresses(excluded): a1, a3
# Destination addresses(excluded): a2, a4
# Source-end-user-profile: test_end_user_profile(1)
# Applications: junos-dhcp-relay, junos-finger
# Dynamic Applications: any
# Url-category: Enhanced_Web_Chat
# Source identities: unknown-user
# Action: deny, log, count
# Policy: test_policy_2, State: enabled, Index: 6, Scope Policy: 0, Sequence number: 2
# Source addresses: a1
# Destination addresses: any-ipv6
# Applications: any
# Action: reject
# dynapp-redir-profile: test_dyn_app(1)
# From zone: one, To zone: three
# Policy: test_policy_3, State: enabled, Index: 7, Scope Policy: 0, Sequence number: 1
# Source addresses: a1
# Destination addresses: a2
# Applications: any
# Action: permit, firewall authentication, application services, unified access control
# Application traffic control: test_traffic_control
# Global policies:
# Policy: test_glob, State: enabled, Index: 4, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any-ipv4
# Destination addresses: any-ipv4
# Applications: any
# Action: deny
# Policy: test_glob_1, State: enabled, Index: 8, Scope Policy: 0, Sequence number: 2
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
# Policy: test_glob_2, State: enabled, Index: 9, Scope Policy: 0, Sequence number: 3
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny


# Using Replaced
# Before state
# ------------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# From zone: one, To zone: two
# Policy: test_policy_1, State: enabled, Index: 5, Scope Policy: 0, Sequence number: 1
# Source addresses(excluded): a1, a3
# Destination addresses(excluded): a2, a4
# Source-end-user-profile: test_end_user_profile(1)
# Applications: junos-dhcp-relay, junos-finger
# Dynamic Applications: any
# Url-category: Enhanced_Web_Chat
# Source identities: unknown-user
# Action: deny, log, count
# Policy: test_policy_2, State: enabled, Index: 6, Scope Policy: 0, Sequence number: 2
# Source addresses: a1
# Destination addresses: any-ipv6
# Applications: any
# Action: reject
# dynapp-redir-profile: test_dyn_app(1)
# From zone: one, To zone: three
# Policy: test_policy_3, State: enabled, Index: 7, Scope Policy: 0, Sequence number: 1
# Source addresses: a1
# Destination addresses: a2
# Applications: any
# Action: permit, firewall authentication, application services, unified access control
# Application traffic control: test_traffic_control
# Global policies:
# Policy: test_glob, State: enabled, Index: 4, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any-ipv4
# Destination addresses: any-ipv4
# Applications: any
# Action: deny
# Policy: test_glob_1, State: enabled, Index: 8, Scope Policy: 0, Sequence number: 2
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
# Policy: test_glob_2, State: enabled, Index: 9, Scope Policy: 0, Sequence number: 3
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
#
- junipernetworks.junos.junos_security_policies:
    config:
      global:
        policies:
          - description: test update
            match:
              application:
                any: true
              destination_address:
                any_ipv6: true
              source_address:
                any: true
            name: test_glob_3
            then:
              deny: true
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
#   "after": {
#     "global": {
#       "policies": [
#         {
#           "description": "test update",
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any": true
#             }
#           },
#           "name": "test_glob_3",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "before": {
#     "from_zones": [
#       {
#         "name": "one",
#         "to_zones": [
#           {
#             "name": "two",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "names": [
#                       "junos-dhcp-relay",
#                       "junos-finger"
#                     ]
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2",
#                       "a4"
#                     ]
#                   },
#                   "destination_address_excluded": true,
#                   "dynamic_application": {
#                     "names": [
#                       "any"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1",
#                       "a3"
#                     ]
#                   },
#                   "source_address_excluded": true,
#                   "source_end_user_profile": "test_end_user_profile",
#                   "source_identity": {
#                     "unknown_user": true
#                   },
#                   "url_category": {
#                     "names": [
#                       "Enhanced_Web_Chat"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_1",
#                 "then": {
#                   "count": true,
#                   "deny": true,
#                   "log": "session-close"
#                 }
#               },
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "any_ipv6": true
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_2",
#                 "then": {
#                   "reject": {
#                     "enable": true,
#                     "profile": "test_dyn_app",
#                     "ssl_proxy": {
#                       "enable": true,
#                       "profile_name": "SECURITY-SSL-PROXY"
#                     }
#                   }
#                 }
#               }
#             ]
#           },
#           {
#             "name": "three",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_3",
#                 "then": {
#                   "permit": {
#                     "application_services": {
#                       "application_traffic_control_rule_set": "test_traffic_control",
#                       "gprs_gtp_profile": "gtp1",
#                       "icap_redirect": "test_icap",
#                       "reverse_redirect_wx": "True",
#                       "uac_policy": {
#                         "enable": true
#                       }
#                     },
#                     "firewall_authentication": {
#                       "push_to_identity_management": true,
#                       "web_authentication": [
#                         "FWClient1"
#                       ]
#                     },
#                     "tcp_options": {
#                       "initial_tcp_mss": 64,
#                       "window_scale": true
#                     }
#                   }
#                 }
#               }
#             ]
#           }
#         ]
#       }
#     ],
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv4": true
#             },
#             "source_address": {
#               "any_ipv4": true
#             }
#           },
#           "name": "test_glob",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_1",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_2",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "changed": true,
#   "commands": "<nc:security
#                   xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#                   <nc:policies delete="delete"/>
#                   <nc:policies>
#                     <nc:global>
#                       <nc:policy>
#                         <nc:name>test_glob_3</nc:name>
#                         <nc:description>test update</nc:description>
#                         <nc:match>
#                           <nc:source-address>any</nc:source-address>
#                           <nc:destination-address>any-ipv6</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:deny/>
#                         </nc:then>
#                       </nc:policy>
#                     </nc:global>
#                   </nc:policies>
#                 </nc:security>"
# }
# After state
# -----------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# Global policies:
# Policy: test_glob_3, State: enabled, Index: 10, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any
# Destination addresses: any-ipv6
# Applications: any
# Action: deny


# Using overridden
#
# Before state
# ------------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# From zone: one, To zone: two
# Policy: test_policy_1, State: enabled, Index: 5, Scope Policy: 0, Sequence number: 1
# Source addresses(excluded): a1, a3
# Destination addresses(excluded): a2, a4
# Source-end-user-profile: test_end_user_profile(1)
# Applications: junos-dhcp-relay, junos-finger
# Dynamic Applications: any
# Url-category: Enhanced_Web_Chat
# Source identities: unknown-user
# Action: deny, log, count
# Policy: test_policy_2, State: enabled, Index: 6, Scope Policy: 0, Sequence number: 2
# Source addresses: a1
# Destination addresses: any-ipv6
# Applications: any
# Action: reject
# dynapp-redir-profile: test_dyn_app(1)
# From zone: one, To zone: three
# Policy: test_policy_3, State: enabled, Index: 7, Scope Policy: 0, Sequence number: 1
# Source addresses: a1
# Destination addresses: a2
# Applications: any
# Action: permit, firewall authentication, application services, unified access control
# Application traffic control: test_traffic_control
# Global policies:
# Policy: test_glob, State: enabled, Index: 4, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any-ipv4
# Destination addresses: any-ipv4
# Applications: any
# Action: deny
# Policy: test_glob_1, State: enabled, Index: 8, Scope Policy: 0, Sequence number: 2
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
# Policy: test_glob_2, State: enabled, Index: 9, Scope Policy: 0, Sequence number: 3
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
#
- junipernetworks.junos.junos_security_policies:
    config:
      global:
        policies:
          - description: test update
            match:
              application:
                any: true
              destination_address:
                any_ipv6: true
              source_address:
                any: true
            name: test_glob_3
            then:
              deny: true
    state: overridden
#
# -------------------------
# Module Execution Result
# -------------------------
#   "after": {
#     "global": {
#       "policies": [
#         {
#           "description": "test update",
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any": true
#             }
#           },
#           "name": "test_glob_3",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "before": {
#     "from_zones": [
#       {
#         "name": "one",
#         "to_zones": [
#           {
#             "name": "two",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "names": [
#                       "junos-dhcp-relay",
#                       "junos-finger"
#                     ]
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2",
#                       "a4"
#                     ]
#                   },
#                   "destination_address_excluded": true,
#                   "dynamic_application": {
#                     "names": [
#                       "any"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1",
#                       "a3"
#                     ]
#                   },
#                   "source_address_excluded": true,
#                   "source_end_user_profile": "test_end_user_profile",
#                   "source_identity": {
#                     "unknown_user": true
#                   },
#                   "url_category": {
#                     "names": [
#                       "Enhanced_Web_Chat"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_1",
#                 "then": {
#                   "count": true,
#                   "deny": true,
#                   "log": "session-close"
#                 }
#               },
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "any_ipv6": true
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_2",
#                 "then": {
#                   "reject": {
#                     "enable": true,
#                     "profile": "test_dyn_app",
#                     "ssl_proxy": {
#                       "enable": true,
#                       "profile_name": "SECURITY-SSL-PROXY"
#                     }
#                   }
#                 }
#               }
#             ]
#           },
#           {
#             "name": "three",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_3",
#                 "then": {
#                   "permit": {
#                     "application_services": {
#                       "application_traffic_control_rule_set": "test_traffic_control",
#                       "gprs_gtp_profile": "gtp1",
#                       "icap_redirect": "test_icap",
#                       "reverse_redirect_wx": "True",
#                       "uac_policy": {
#                         "enable": true
#                       }
#                     },
#                     "firewall_authentication": {
#                       "push_to_identity_management": true,
#                       "web_authentication": [
#                         "FWClient1"
#                       ]
#                     },
#                     "tcp_options": {
#                       "initial_tcp_mss": 64,
#                       "window_scale": true
#                     }
#                   }
#                 }
#               }
#             ]
#           }
#         ]
#       }
#     ],
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv4": true
#             },
#             "source_address": {
#               "any_ipv4": true
#             }
#           },
#           "name": "test_glob",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_1",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_2",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "changed": true,
#   "commands": "<nc:security
#                   xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#                   <nc:policies delete="delete"/>
#                   <nc:policies>
#                     <nc:global>
#                       <nc:policy>
#                         <nc:name>test_glob_3</nc:name>
#                         <nc:description>test update</nc:description>
#                         <nc:match>
#                           <nc:source-address>any</nc:source-address>
#                           <nc:destination-address>any-ipv6</nc:destination-address>
#                           <nc:application>any</nc:application>
#                         </nc:match>
#                         <nc:then>
#                           <nc:deny/>
#                         </nc:then>
#                       </nc:policy>
#                     </nc:global>
#                   </nc:policies>
#                 </nc:security>"
# }
# After state
# -----------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# Global policies:
# Policy: test_glob_3, State: enabled, Index: 10, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any
# Destination addresses: any-ipv6
# Applications: any
# Action: deny


# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# Global policies:
# Policy: test_glob_3, State: enabled, Index: 10, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
#
- junipernetworks.junos.junos_security_policies:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#
#   "after": {},
#   "before": {
#     "global": {
#       "policies": [
#         {
#           "description": "test update",
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any": true
#             }
#           },
#           "name": "test_glob_3",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   },
#   "changed": true,
#   "commands": "<nc:security xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#   <nc:policies delete="delete"/></nc:security>"
#
# After state
# -----------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all


# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply>
#     <configuration>
#         <version>18.4R1-S3.1</version>
#         <services>
#             <ssl>
#                 <termination>
#                     <profile>
#                         <name>test_ssl_term</name>
#                         <server-certificate>SECURITY-cert</server-certificate>
#                     </profile>
#                 </termination>
#                 <proxy>
#                     <profile>
#                         <name>SECURITY-SSL-PROXY</name>
#                         <root-ca>SECURITY-cert</root-ca>
#                     </profile>
#                 </proxy>
#             </ssl>
#             <icap-redirect>
#                 <profile>
#                     <name>test_icap</name>
#                     <server>
#                         <name>test_icap_server</name>
#                         <host>10.10.10.11</host>
#                     </server>
#                 </profile>
#             </icap-redirect>
#             <user-identification>
#                 <device-information>
#                     <end-user-profile>
#                         <profile-name>
#                             <name>test_end_user_profile</name>
#                             <domain-name>test_domain</domain-name>
#                             <attribute>
#                                 <name>device-identity</name>
#                                 <string>Windows</string>
#                             </attribute>
#                         </profile-name>
#                     </end-user-profile>
#                 </device-information>
#             </user-identification>
#         </services>
#         <security>
#             <address-book>
#                 <name>global</name>
#                 <address>
#                     <name>a1</name>
#                     <ip-prefix>200.0.113.0/24</ip-prefix>
#                 </address>
#                 <address>
#                     <name>a2</name>
#                     <ip-prefix>201.0.113.0/24</ip-prefix>
#                 </address>
#                 <address>
#                     <name>a3</name>
#                     <ip-prefix>202.0.113.0/24</ip-prefix>
#                 </address>
#                 <address>
#                     <name>a4</name>
#                     <ip-prefix>203.0.113.0/24</ip-prefix>
#                 </address>
#             </address-book>
#             <dynamic-application>
#                 <profile>
#                     <name>test_dyn_app</name>
#                     <redirect-message>
#                         <type>
#                             <custom-text>
#                                 <content>hello_world</content>
#                             </custom-text>
#                         </type>
#                     </redirect-message>
#                 </profile>
#             </dynamic-application>
#             <policies>
#                 <policy>
#                     <from-zone-name>one</from-zone-name>
#                     <to-zone-name>two</to-zone-name>
#                     <policy>
#                         <name>test_policy_1</name>
#                         <match>
#                             <source-address>a1</source-address>
#                             <source-address>a3</source-address>
#                             <destination-address>a2</destination-address>
#                             <destination-address>a4</destination-address>
#                             <source-address-excluded />
#                             <destination-address-excluded />
#                             <application>junos-dhcp-relay</application>
#                             <application>junos-finger</application>
#                             <source-identity>authenticated-user</source-identity>
#                             <source-identity>unknown-user</source-identity>
#                             <source-end-user-profile>
#                                 <source-end-user-profile-name>test_end_user_profile</source-end-user-profile-name>
#                             </source-end-user-profile>
#                             <dynamic-application>any</dynamic-application>
#                             <url-category>Enhanced_Web_Chat</url-category>
#                         </match>
#                         <then>
#                             <deny />
#                             <log>
#                                 <session-close />
#                             </log>
#                             <count></count>
#                         </then>
#                     </policy>
#                     <policy>
#                         <name>test_policy_2</name>
#                         <match>
#                             <source-address>a1</source-address>
#                             <destination-address>any-ipv6</destination-address>
#                             <application>any</application>
#                         </match>
#                         <then>
#                             <reject>
#                                 <profile>test_dyn_app</profile>
#                                 <ssl-proxy>
#                                     <profile-name>SECURITY-SSL-PROXY</profile-name>
#                                 </ssl-proxy>
#                             </reject>
#                         </then>
#                     </policy>
#                 </policy>
#                 <policy>
#                     <from-zone-name>one</from-zone-name>
#                     <to-zone-name>three</to-zone-name>
#                     <policy>
#                         <name>test_policy_3</name>
#                         <match>
#                             <source-address>a1</source-address>
#                             <destination-address>a2</destination-address>
#                             <application>any</application>
#                         </match>
#                         <then>
#                             <permit>
#                                 <firewall-authentication>
#                                     <web-authentication>
#                                         <client-match>FWClient1</client-match>
#                                     </web-authentication>
#                                     <push-to-identity-management />
#                                 </firewall-authentication>
#                                 <destination-address>
#                                     <drop-untranslated />
#                                 </destination-address>
#                                 <application-services>
#                                     <gprs-gtp-profile>gtp1</gprs-gtp-profile>
#                                     <uac-policy></uac-policy>
#                                     <icap-redirect>test_icap</icap-redirect>
#                                     <application-traffic-control>
#                                         <rule-set>test_traffic_control</rule-set>
#                                     </application-traffic-control>
#                                     <reverse-redirect-wx />
#                                 </application-services>
#                                 <tcp-options>
#                                     <initial-tcp-mss>64</initial-tcp-mss>
#                                     <window-scale />
#                                 </tcp-options>
#                             </permit>
#                         </then>
#                     </policy>
#                 </policy>
#                 <global>
#                     <policy>
#                         <name>test_glob_1</name>
#                         <match>
#                             <source-address>any-ipv6</source-address>
#                             <destination-address>any-ipv6</destination-address>
#                             <application>any</application>
#                         </match>
#                         <then>
#                             <deny />
#                         </then>
#                     </policy>
#                     <policy>
#                         <name>test_glob_2</name>
#                         <match>
#                             <source-address>any-ipv6</source-address>
#                             <destination-address>any-ipv6</destination-address>
#                             <application>any</application>
#                         </match>
#                         <then>
#                             <deny />
#                         </then>
#                     </policy>
#                 </global>
#             </policies>
#             <zones>
#                 <security-zone>
#                     <name>one</name>
#                     <interfaces>
#                         <name>ge-0/0/0.0</name>
#                     </interfaces>
#                 </security-zone>
#                 <security-zone>
#                     <name>two</name>
#                     <interfaces>
#                         <name>ge-0/0/1.0</name>
#                     </interfaces>
#                 </security-zone>
#                 <security-zone>
#                     <name>three</name>
#                     <interfaces>
#                         <name>ge-0/0/2.0</name>
#                     </interfaces>
#                 </security-zone>
#             </zones>
#             <gprs>
#                 <gtp>
#                     <profile>
#                         <name>gtp1</name>
#                     </profile>
#                 </gtp>
#             </gprs>
#         </security>
#         <interfaces>
#             <interface>
#                 <name>ge-0/0/0</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <address>
#                                 <name>200.0.113.1/24</name>
#                             </address>
#                         </inet>
#                     </family>
#                 </unit>
#             </interface>
#             <interface>
#                 <name>ge-0/0/1</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <address>
#                                 <name>201.0.113.1/24</name>
#                             </address>
#                         </inet>
#                     </family>
#                 </unit>
#             </interface>
#             <interface>
#                 <name>ge-0/0/2</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <address>
#                                 <name>202.0.113.1/24</name>
#                             </address>
#                         </inet>
#                     </family>
#                 </unit>
#             </interface>
#             <interface>
#                 <name>fxp0</name>
#                 <unit>
#                     <name>0</name>
#                     <family>
#                         <inet>
#                             <dhcp></dhcp>
#                         </inet>
#                     </family>
#                 </unit>
#             </interface>
#         </interfaces>
#         <class-of-service>
#             <application-traffic-control>
#                 <rule-sets>
#                     <name>test_traffic_control</name>
#                     <rule>
#                         <name>test_rule</name>
#                         <match>
#                             <application-known />
#                         </match>
#                         <then>
#                             <log />
#                         </then>
#                     </rule>
#                 </rule-sets>
#             </application-traffic-control>
#         </class-of-service>
#         <access>
#             <profile>
#                 <name>WEBAUTH</name>
#                 <client>
#                     <name>FWClient1</name>
#                     <firewall-user>
#                         <password>$9$kq5Ftu1cSe</password>
#                     </firewall-user>
#                 </client>
#             </profile>
#             <firewall-authentication>
#                 <web-authentication>
#                     <default-profile>WEBAUTH</default-profile>
#                 </web-authentication>
#             </firewall-authentication>
#         </access>
#     </configuration>
#     <database-status-information></database-status-information>
# </rpc-reply>
#
- name: Parse NTP global running config
  junipernetworks.junos.junos_security_policies:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#   "parsed": {
#     "from_zones": [
#       {
#         "name": "one",
#         "to_zones": [
#           {
#             "name": "two",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "names": [
#                       "junos-dhcp-relay",
#                       "junos-finger"
#                     ]
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2",
#                       "a4"
#                     ]
#                   },
#                   "destination_address_excluded": true,
#                   "dynamic_application": {
#                     "names": [
#                       "any"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1",
#                       "a3"
#                     ]
#                   },
#                   "source_address_excluded": true,
#                   "source_end_user_profile": "test_end_user_profile",
#                   "source_identity": {
#                     "unknown_user": true
#                   },
#                   "url_category": {
#                     "names": [
#                       "Enhanced_Web_Chat"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_1",
#                 "then": {
#                   "count": true,
#                   "deny": true,
#                   "log": "session-close"
#                 }
#               },
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "any_ipv6": true
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_2",
#                 "then": {
#                   "reject": {
#                     "enable": true,
#                     "profile": "test_dyn_app",
#                     "ssl_proxy": {
#                       "enable": true,
#                       "profile_name": "SECURITY-SSL-PROXY"
#                     }
#                   }
#                 }
#               }
#             ]
#           },
#           {
#             "name": "three",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_3",
#                 "then": {
#                   "permit": {
#                     "application_services": {
#                       "application_traffic_control_rule_set": "test_traffic_control",
#                       "gprs_gtp_profile": "gtp1",
#                       "icap_redirect": "test_icap",
#                       "reverse_redirect_wx": "True",
#                       "uac_policy": {
#                         "enable": true
#                       }
#                     },
#                     "firewall_authentication": {
#                       "push_to_identity_management": true,
#                       "web_authentication": [
#                         "FWClient1"
#                       ]
#                     },
#                     "tcp_options": {
#                       "initial_tcp_mss": 64,
#                       "window_scale": true
#                     }
#                   }
#                 }
#               }
#             ]
#           }
#         ]
#       }
#     ],
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_1",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_2",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   }


# Using gathered
#
# Before state
# ------------
#
# vagrant@vsrx> show security policies
# Default policy: deny-all
# Pre ID default policy: permit-all
# From zone: one, To zone: two
# Policy: test_policy_1, State: enabled, Index: 4, Scope Policy: 0, Sequence number: 1
# Source addresses(excluded): a1, a3
# Destination addresses(excluded): a2, a4
# Source-end-user-profile: test_end_user_profile(1)
# Applications: junos-dhcp-relay, junos-finger
# Dynamic Applications: any
# Url-category: Enhanced_Web_Chat
# Source identities: authenticated-user, unknown-user
# Action: deny, log, count
# Policy: test_policy_2, State: enabled, Index: 5, Scope Policy: 0, Sequence number: 2
# Source addresses: a1
# Destination addresses: any-ipv6
# Applications: any
# Action: reject
# dynapp-redir-profile: test_dyn_app(1)
# From zone: one, To zone: three
# Policy: test_policy_3, State: enabled, Index: 6, Scope Policy: 0, Sequence number: 1
# Source addresses: a1
# Destination addresses: a2
# Applications: any
# Action: permit, drop-untranslated, firewall authentication, application services, unified access control
# Application traffic control: test_traffic_control
# Global policies:
# Policy: test_glob_1, State: enabled, Index: 7, Scope Policy: 0, Sequence number: 1
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
# Policy: test_glob_2, State: enabled, Index: 8, Scope Policy: 0, Sequence number: 2
# From zones: any
# To zones: any
# Source addresses: any-ipv6
# Destination addresses: any-ipv6
# Applications: any
# Action: deny
#
- junipernetworks.junos.junos_security_policies:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
#
#   "changed": false,
#   "gathered": {
#     "from_zones": [
#       {
#         "name": "one",
#         "to_zones": [
#           {
#             "name": "two",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "names": [
#                       "junos-dhcp-relay",
#                       "junos-finger"
#                     ]
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2",
#                       "a4"
#                     ]
#                   },
#                   "destination_address_excluded": true,
#                   "dynamic_application": {
#                     "names": [
#                       "any"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1",
#                       "a3"
#                     ]
#                   },
#                   "source_address_excluded": true,
#                   "source_end_user_profile": "test_end_user_profile",
#                   "source_identity": {
#                     "unknown_user": true
#                   },
#                   "url_category": {
#                     "names": [
#                       "Enhanced_Web_Chat"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_1",
#                 "then": {
#                   "count": true,
#                   "deny": true,
#                   "log": "session-close"
#                 }
#               },
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "any_ipv6": true
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_2",
#                 "then": {
#                   "reject": {
#                     "enable": true,
#                     "profile": "test_dyn_app",
#                     "ssl_proxy": {
#                       "enable": true,
#                       "profile_name": "SECURITY-SSL-PROXY"
#                     }
#                   }
#                 }
#               }
#             ]
#           },
#           {
#             "name": "three",
#             "policies": [
#               {
#                 "match": {
#                   "application": {
#                     "any": true
#                   },
#                   "destination_address": {
#                     "addresses": [
#                       "a2"
#                     ]
#                   },
#                   "source_address": {
#                     "addresses": [
#                       "a1"
#                     ]
#                   }
#                 },
#                 "name": "test_policy_3",
#                 "then": {
#                   "permit": {
#                     "application_services": {
#                       "application_traffic_control_rule_set": "test_traffic_control",
#                       "gprs_gtp_profile": "gtp1",
#                       "icap_redirect": "test_icap",
#                       "reverse_redirect_wx": "True",
#                       "uac_policy": {
#                         "enable": true
#                       }
#                     },
#                     "firewall_authentication": {
#                       "push_to_identity_management": true,
#                       "web_authentication": [
#                         "FWClient1"
#                       ]
#                     },
#                     "tcp_options": {
#                       "initial_tcp_mss": 64,
#                       "window_scale": true
#                     }
#                   }
#                 }
#               }
#             ]
#           }
#         ]
#       }
#     ],
#     "global": {
#       "policies": [
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_1",
#           "then": {
#             "deny": true
#           }
#         },
#         {
#           "match": {
#             "application": {
#               "any": true
#             },
#             "destination_address": {
#               "any_ipv6": true
#             },
#             "source_address": {
#               "any_ipv6": true
#             }
#           },
#           "name": "test_glob_2",
#           "then": {
#             "deny": true
#           }
#         }
#       ]
#     }
#   }
# }


# Using rendered
#
# Before state
# ------------
#
- junipernetworks.junos.junos_security_policies:
    config:
      global:
        policies:
          - description: test update
            match:
              application:
                any: true
              destination_address:
                any_ipv6: true
              source_address:
                any: true
            name: test_glob_3
            then:
              deny: true
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
#     "rendered": "<nc:security
#                 xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
#                 <nc:policies>
#                   <nc:global>
#                     <nc:policy>
#                       <nc:name>test_glob_3</nc:name>
#                       <nc:description>test update</nc:description>
#                       <nc:match>
#                         <nc:source-address>any</nc:source-address>
#                         <nc:destination-address>any-ipv6</nc:destination-address>
#                         <nc:application>any</nc:application>
#                       </nc:match>
#                       <nc:then>
#                         <nc:deny/>
#                       </nc:then>
#                     </nc:policy>
#                   </nc:global>
#                 </nc:policies>
#               </nc:security>"
"""
RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when state is I(merged), I(replaced), I(overridden) or I(deleted)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: when state is I(merged), I(replaced), I(overridden) or I(deleted)
  type: list
  sample:
    - "<rpc-reply>
      <configuration>
        <security>
          <policies>
            <global>
              <policy>
                  <name>test_glob_1</name>
                  <match>
                      <source-address>any-ipv6</source-address>
                      <destination-address>any-ipv6</destination-address>
                      <application>any</application>
                  </match>
                  <then>
                      <deny />
                  </then>
              </policy>
            </global>
          </policies>
        </security>
      </configuration>
    </rpc-reply>"
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when state is I(rendered)
  type: dict
  sample:
    - "<rpc-reply>
      <configuration>
        <security>
          <policies>
            <global>
              <policy>
                  <name>test_glob_1</name>
                  <match>
                      <source-address>any-ipv6</source-address>
                      <destination-address>any-ipv6</destination-address>
                      <application>any</application>
                  </match>
                  <then>
                      <deny />
                  </then>
              </policy>
            </global>
          </policies>
        </security>
      </configuration>
    </rpc-reply>"
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when state is I(gathered)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when state is I(parsed)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.security_policies.security_policies import (
    Security_policiesArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.security_policies.security_policies import (
    Security_policies,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """

    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    module = AnsibleModule(
        argument_spec=Security_policiesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Security_policies(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
