# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the nxos_hsrp_interfaces module
"""


class Hsrp_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_hsrp_interfaces module"""

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str"},
                "bfd": {"type": "str", "choices": ["enable", "disable"]},
                "standby_options": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "group_no": {"type": "int"},
                        "authentication": {
                            "type": "dict",
                            "options": {
                                "key_chain": {"type": "str", "no_log": True},
                                "key_string": {"type": "str", "no_log": True},
                                "password_text": {"type": "str", "no_log": True},
                            },
                        },
                        "follow": {"type": "str"},
                        "mac_address": {"type": "str"},
                        "ip": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "virtual_ip": {"type": "str"},
                                "secondary": {"type": "bool"},
                            },
                        },
                        "group_name": {"type": "str"},
                        "preempt": {
                            "type": "dict",
                            "options": {
                                "minimum": {"type": "int"},
                                "reload": {"type": "int"},
                                "sync": {"type": "int"},
                            },
                        },
                        "priority": {
                            "type": "dict",
                            "options": {
                                "level": {"type": "int"},
                                "upper": {"type": "int"},
                                "lower": {"type": "int"},
                            },
                        },
                        "timer": {
                            "type": "dict",
                            "options": {
                                "hello_interval": {"type": "int"},
                                "hold_time": {"type": "int"},
                                "msec": {"type": "bool"},
                            },
                        },
                        "track": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "object_no": {"type": "int"},
                                "decrement": {"type": "int"},
                            },
                        },
                    },
                },
                "standby": {
                    "type": "dict",
                    "options": {
                        "bfd": {"type": "bool"},
                        "delay": {
                            "type": "dict",
                            "options": {
                                "minimum": {"type": "int"},
                                "reload": {"type": "int"},
                            },
                        },
                        "mac_refresh": {"type": "int"},
                        "use_bia": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "scope": {"type": "bool"},
                            },
                        },
                        "version": {"type": "int"},
                    },
                },
            },
        },
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "rendered",
                "gathered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
